# Release notes for MUSE v1.2.1 (October 9, 2024)

These are the main changes in MUSE v1.2.1.

Please read carefully if upgrading from an earlier version, as some of the changes may require you to modify your model input files.

## Carbon budget module

- The bisection method has been fixed, as this was not working as expected before ({github}`483`, {github}`484`). Additionally, a number of default settings have been changed, and parameters renamed. Users must carefully check which parameters are specified in their settings files, as any unspecified parameters will revert to the new defaults. The main changes are as follows:
  - `control_undershoot` / `control_overshoot`: The default has been changed from True to False
  - `method`: The default has changed from `fitting` to `bisection`
  - `method_options.refine_price`: The default has changed from True to False
  - `method_options.resolution`: New parameter
  - `method_options.sample_size`: This parameter no longer applies to the bisection algorithm, and won't be permitted when using that method. Please use `method_options.max_iterations` instead
  - `method_options.tolerance` and `method_options.early_termination_count`: New parameters for the bisection method

__Please read the [new documentation page](https://muse-os.readthedocs.io/en/documentation/inputs/toml.html#carbon-market) in full before using a carbon budget__

## Default model

- A number of changes have been made to the default model that is generated with `muse --model default --copy PATH`. This is mostly to simplify the outputs ({github}`461`)

## Tutorials

- The tutorials have been simplified and re-ordered ({github}`470`)
- A tutorial has been added explaining the use of a carbon budget ({github}`486`)
