# Release notes for MUSE v1.2.0 (September 19, 2024)

These are the main changes in MUSE v1.2.0.

Please read carefully if upgrading from an earlier version, as some of the changes may require you to modify your model input files or downstream analysis scripts.

## Dropped support for Python 3.8

- MUSE is now compatible with Python versions 3.9 to 3.12
- If you were previously using Python 3.8, you must create a new environment using 3.9 or later. There are instructions on setting up a new environment with the appropriate Python version [here](https://muse-os.readthedocs.io/en/latest/installation/virtual-env-based.html)

## Model settings

- The default `demand_share` has changed from "new_and_retro" to "standard_demand" ({github}`349`). If your model uses retrofit agents, you MUST explicitly specify `demand_share = "new_and_retro"` for all relevant sectors. If this is left out, the model will try to use the "standard_demand" share and will fail. See updated documentation about this parameter [here](https://muse-os.readthedocs.io/en/latest/inputs/toml.html#standard-sectors).
- The default value for `maximum_iterations` has changed from 3 to 100 ({github}`386`)

## Input files

- The `Level` column is no longer required in the `Technodata`  and `CommOut` files, as this parameter isn't used and never has been ({github}`374` and {github}`377`). See updated documentation about this parameter [here](https://muse-os.readthedocs.io/en/latest/inputs/commodities_io.html).
- The `ProcessName` column is no longer required in consumption files specified in the _consumption_path_ format. See updated documentation [here](https://muse-os.readthedocs.io/en/latest/inputs/toml.html#preset-sectors). Users are encouraged to remove this column from their files (summing rows for different processes if necessary), as this more accurately depicts how this data is used in the model.

## Output files

- We have changed how timeslices are represented in some of the output files ({github}`412`), so this now follows a consistent format across all files. Some of your downstream scripts for loading and analysing these output files may need to be updated.
- Previously it was necessary to specify `index = true` (in `settings.toml`) for some of the outputs to prevent some important columns from being dropped. This is no longer required, and users should no longer require the `index` parameter for any reason ({github}`412`).

## Model

- Fixed a bug with the calculation of commodity prices ({github}`418`), which affects all models that have multiple timeslices and `maximum_iterations` > 1.
- Fixed a bug which was preventing the convergence criteria in the MCA algorithm from being properly checked ({github}`407`). This will likely affect the results of most models that have `maximum_iterations` > 1.
- The `minimum_service_factor` parameter was previously being applied incorrectly - this has been fixed ({github}`388`).
- Constraints specified in the `settings.toml` file (with the `constraints` key) were previously being ignored (the model would always revert to the default list of constraints). This has been fixed ({github}`354`).
- We have added a constraint that limits installed capacity to be no greater than that required to meet peak demand ({github}`355`). This is applied by default, however if you are manually overriding the defaults in the settings file with the `constraints` key, you MUST include "demand_limiting_capacity" in this list otherwise this constraint won't be used. Note that this only applies to the scipy solver (`lpsolver = "scipy"` in `settings.toml`), not the adhoc solver.
- Fixed a bug with the calculation of LCOE in models that have a utilization factor of zero for some timeslices ({github}`304`)
- Fixed a bug with the weighted_sum decision method ({github}`449`)

## Other notes

- Please don't use the "metric_supply", "metricy_supply", "timeslice_supply", "yearly_supply", "metric_consumption", "metricy_consumption", "timeslice_consumption" or "yearly_consumption" outputs, as these sometimes give incorrect values and will likely be deleted in the future. You should be able to get everything you need by using the "supply" and "consumption" outputs within each sector, for example (replacing `SECTOR_NAME` with the name of the sector):

  ```toml
  [[sectors.SECTOR_NAME.outputs]]
  filename = '{cwd}/{default_output_dir}/{Sector}/{Quantity}.csv'
  quantity = "supply"
  sink = "aggregate"
  ```
