"""Resources derived from the US Census Demographic Profile 1 dataset."""

from typing import Any

CENSUS_DP1_DEMOGRAPHIC_COLUMNS = [
    "dp0010001",
    "dp0010002",
    "dp0010003",
    "dp0010004",
    "dp0010005",
    "dp0010006",
    "dp0010007",
    "dp0010008",
    "dp0010009",
    "dp0010010",
    "dp0010011",
    "dp0010012",
    "dp0010013",
    "dp0010014",
    "dp0010015",
    "dp0010016",
    "dp0010017",
    "dp0010018",
    "dp0010019",
    "dp0010020",
    "dp0010021",
    "dp0010022",
    "dp0010023",
    "dp0010024",
    "dp0010025",
    "dp0010026",
    "dp0010027",
    "dp0010028",
    "dp0010029",
    "dp0010030",
    "dp0010031",
    "dp0010032",
    "dp0010033",
    "dp0010034",
    "dp0010035",
    "dp0010036",
    "dp0010037",
    "dp0010038",
    "dp0010039",
    "dp0010040",
    "dp0010041",
    "dp0010042",
    "dp0010043",
    "dp0010044",
    "dp0010045",
    "dp0010046",
    "dp0010047",
    "dp0010048",
    "dp0010049",
    "dp0010050",
    "dp0010051",
    "dp0010052",
    "dp0010053",
    "dp0010054",
    "dp0010055",
    "dp0010056",
    "dp0010057",
    "dp0020001",
    "dp0020002",
    "dp0020003",
    "dp0030001",
    "dp0030002",
    "dp0030003",
    "dp0040001",
    "dp0040002",
    "dp0040003",
    "dp0050001",
    "dp0050002",
    "dp0050003",
    "dp0060001",
    "dp0060002",
    "dp0060003",
    "dp0070001",
    "dp0070002",
    "dp0070003",
    "dp0080001",
    "dp0080002",
    "dp0080003",
    "dp0080004",
    "dp0080005",
    "dp0080006",
    "dp0080007",
    "dp0080008",
    "dp0080009",
    "dp0080010",
    "dp0080011",
    "dp0080012",
    "dp0080013",
    "dp0080014",
    "dp0080015",
    "dp0080016",
    "dp0080017",
    "dp0080018",
    "dp0080019",
    "dp0080020",
    "dp0080021",
    "dp0080022",
    "dp0080023",
    "dp0080024",
    "dp0090001",
    "dp0090002",
    "dp0090003",
    "dp0090004",
    "dp0090005",
    "dp0090006",
    "dp0100001",
    "dp0100002",
    "dp0100003",
    "dp0100004",
    "dp0100005",
    "dp0100006",
    "dp0100007",
    "dp0110001",
    "dp0110002",
    "dp0110003",
    "dp0110004",
    "dp0110005",
    "dp0110006",
    "dp0110007",
    "dp0110008",
    "dp0110009",
    "dp0110010",
    "dp0110011",
    "dp0110012",
    "dp0110013",
    "dp0110014",
    "dp0110015",
    "dp0110016",
    "dp0110017",
    "dp0120001",
    "dp0120002",
    "dp0120003",
    "dp0120004",
    "dp0120005",
    "dp0120006",
    "dp0120007",
    "dp0120008",
    "dp0120009",
    "dp0120010",
    "dp0120011",
    "dp0120012",
    "dp0120013",
    "dp0120014",
    "dp0120015",
    "dp0120016",
    "dp0120017",
    "dp0120018",
    "dp0120019",
    "dp0120020",
    "dp0130001",
    "dp0130002",
    "dp0130003",
    "dp0130004",
    "dp0130005",
    "dp0130006",
    "dp0130007",
    "dp0130008",
    "dp0130009",
    "dp0130010",
    "dp0130011",
    "dp0130012",
    "dp0130013",
    "dp0130014",
    "dp0130015",
    "dp0140001",
    "dp0150001",
    "dp0160001",
    "dp0170001",
    "dp0180001",
    "dp0180002",
    "dp0180003",
    "dp0180004",
    "dp0180005",
    "dp0180006",
    "dp0180007",
    "dp0180008",
    "dp0180009",
    "dp0190001",
    "dp0200001",
    "dp0210001",
    "dp0210002",
    "dp0210003",
    "dp0220001",
    "dp0220002",
    "dp0230001",
    "dp0230002",
]

RESOURCE_METADATA: dict[str, dict[str, Any]] = {
    "out_censusdp1tract__states": {
        "description": (
            "State-level summarized US Census demographic information, along with "
            "a geometry describing state boundaries. Based on the 2010 Census. Used "
            "as a convenient source of geospatial information within PUDL, but should "
            "not be treated as authoritative."
        ),
        "schema": {
            "fields": [
                "state_id_fips",
                "geometry",
                "state_name",
                "state",
                "land_area",
                "water_area",
                "internal_point_latitude",
                "internal_point_longitude",
                "shape_length",
                "shape_area",
            ]
            + CENSUS_DP1_DEMOGRAPHIC_COLUMNS,
            "primary_key": ["state_id_fips"],
        },
        "field_namespace": "censusdp1tract",
        "sources": ["censusdp1tract"],
        "etl_group": "censusdp1tract",
        "create_database_schema": False,
    },
    "out_censusdp1tract__counties": {
        "description": (
            "County-level summarized US Census demographic information, along with "
            "a geometry describing county boundaries. Based on the 2010 Census. Used "
            "as a convenient source of geospatial information within PUDL, but should "
            "not be treated as authoritative."
        ),
        "schema": {
            "fields": [
                "county_id_fips",
                "geometry",
                "county",
                "functional_status_code_census",
                "land_area",
                "water_area",
                "internal_point_latitude",
                "internal_point_longitude",
                "shape_length",
                "shape_area",
            ]
            + CENSUS_DP1_DEMOGRAPHIC_COLUMNS,
            "primary_key": ["county_id_fips"],
        },
        "field_namespace": "censusdp1tract",
        "sources": ["censusdp1tract"],
        "etl_group": "censusdp1tract",
        "create_database_schema": False,
    },
    "out_censusdp1tract__tracts": {
        "description": (
            "Census tract-level summarized US Census demographic information, along "
            "with a geometry describing tract boundaries. Based on the 2010 Census. "
            "Used as a convenient source of geospatial information within PUDL, but "
            "should not be treated as authoritative."
        ),
        "schema": {
            "fields": [
                "tract_id_fips",
                "geometry",
                "tract_name",
                "land_area",
                "water_area",
                "internal_point_latitude",
                "internal_point_longitude",
                "shape_length",
                "shape_area",
            ]
            + CENSUS_DP1_DEMOGRAPHIC_COLUMNS,
            "primary_key": ["tract_id_fips"],
        },
        "field_namespace": "censusdp1tract",
        "sources": ["censusdp1tract"],
        "etl_group": "censusdp1tract",
        "create_database_schema": False,
    },
}
