"""Fix column name typo

Revision ID: fff6efbd14db
Revises: d8b39f16e69e
Create Date: 2025-06-25 17:05:17.410415

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'fff6efbd14db'
down_revision = 'd8b39f16e69e'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_eia860__scd_generators', schema=None) as batch_op:
        batch_op.add_column(sa.Column('synchronized_transmission_grid', sa.Boolean(), nullable=True, comment='Indicates whether standby generators (SB status) can be synchronized to the grid.'))
        batch_op.drop_column('syncronized_transmission_grid')

    with op.batch_alter_table('out_eia__monthly_generators', schema=None) as batch_op:
        batch_op.add_column(sa.Column('synchronized_transmission_grid', sa.Boolean(), nullable=True, comment='Indicates whether standby generators (SB status) can be synchronized to the grid.'))
        batch_op.drop_column('syncronized_transmission_grid')

    with op.batch_alter_table('out_eia__yearly_generators', schema=None) as batch_op:
        batch_op.add_column(sa.Column('synchronized_transmission_grid', sa.Boolean(), nullable=True, comment='Indicates whether standby generators (SB status) can be synchronized to the grid.'))
        batch_op.drop_column('syncronized_transmission_grid')

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('out_eia__yearly_generators', schema=None) as batch_op:
        batch_op.add_column(sa.Column('syncronized_transmission_grid', sa.BOOLEAN(), nullable=True))
        batch_op.drop_column('synchronized_transmission_grid')

    with op.batch_alter_table('out_eia__monthly_generators', schema=None) as batch_op:
        batch_op.add_column(sa.Column('syncronized_transmission_grid', sa.BOOLEAN(), nullable=True))
        batch_op.drop_column('synchronized_transmission_grid')

    with op.batch_alter_table('core_eia860__scd_generators', schema=None) as batch_op:
        batch_op.add_column(sa.Column('syncronized_transmission_grid', sa.BOOLEAN(), nullable=True))
        batch_op.drop_column('synchronized_transmission_grid')

    # ### end Alembic commands ###
