"""add eiaaeo table 2

Revision ID: eda43a449586
Revises: b2f5c3b44300
Create Date: 2025-05-30 12:04:36.504993

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'eda43a449586'
down_revision = 'b2f5c3b44300'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('core_eiaaeo__yearly_projected_energy_use_by_sector_and_type',
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('region_name_eiaaeo', sa.Enum('east_north_central', 'east_south_central', 'middle_atlantic', 'mountain', 'new_england', 'pacific', 'south_atlantic', 'west_north_central', 'west_south_central', 'united_states'), nullable=False, comment='EIA AEO region for energy consumption. Includes US Census Divisions plus United States.'),
    sa.Column('region_type_eiaaeo', sa.Enum('us_census_division', 'country'), nullable=True, comment='Region type for EIA AEO energy consumption, indicating whether region_name_eiaaeo is a US Census Division or country (United States)'),
    sa.Column('model_case_eiaaeo', sa.Enum('aeo2022', 'fast_builds_plus_high_lng_price', 'high_economic_growth', 'high_lng_price', 'high_macro_and_high_zero_carbon_technology_cost', 'high_macro_and_low_zero_carbon_technology_cost', 'high_oil_and_gas_supply', 'high_oil_price', 'high_uptake_of_inflation_reduction_act', 'high_zero_carbon_technology_cost', 'low_economic_growth', 'low_lng_price', 'low_macro_and_high_zero_carbon_technology_cost', 'low_macro_and_low_zero_carbon_technology_cost', 'low_oil_and_gas_supply', 'low_oil_price', 'low_uptake_of_inflation_reduction_act', 'low_zero_carbon_technology_cost', 'no_inflation_reduction_act', 'reference'), nullable=False, comment='Factors such as economic growth, future oil prices, the ultimate size of domestic energy resources, and technological change are often uncertain. To illustrate some of these uncertainties, EIA runs side cases to show how the model responds to changes in key input variables compared with the Reference case. See https://www.eia.gov/outlooks/aeo/assumptions/case_descriptions.php for more details.'),
    sa.Column('projection_year', sa.Integer(), nullable=False, comment='The year of the projected value.'),
    sa.Column('energy_use_sector', sa.Enum('commercial', 'industrial', 'commercial_other', 'unspecified', 'other', 'total', 'electric_power', 'residential', 'transportation'), nullable=False, comment='Sector for energy use figures in AEO Table 2. Similar to customer class, but with some missing and some extra values.'),
    sa.Column('energy_use_type', sa.Enum('biofuels_heat_and_coproducts', 'coal', 'coal_subtotal', 'coal_to_liquids_heat_and_power', 'delivered_energy', 'distillate_fuel_oil', 'e85', 'electricity', 'electricity_imports', 'electricity_related_losses', 'hydrocarbon_gas_liquids', 'hydrogen', 'jet_fuel', 'kerosene', 'lease_and_plant_fuel', 'liquefaction', 'liquid_fuels_subtotal', 'liquefied_petroleum_gases', 'metallurgical_coal', 'motor_gasoline', 'natural_gas', 'natural_gas_subtotal', 'natural_gas_to_liquids_heat_and_power', 'net_coal_coke_imports', 'non_biogenic_municipal_waste', 'nuclear', 'other_industrial_coal', 'other_petroleum', 'other_coal', 'petrochemical_feedstocks', 'pipeline_fuel_natural_gas', 'pipeline_natural_gas', 'propane', 'renewable_energy', 'residual_fuel_oil', 'steam_coal', 'total'), nullable=False, comment='Type of energy use, indicating the name of the series from AEO Table 2. Includes fuels, electricity, losses, and various subtotals; consult table documentation for aggregation guidelines.'),
    sa.Column('energy_use_mmbtu', sa.Float(), nullable=True, comment='Energy use, in MMBtu; also referred to as energy consumption, energy demand, or delivered energy, depending on type.'),
    sa.PrimaryKeyConstraint('report_year', 'region_name_eiaaeo', 'model_case_eiaaeo', 'projection_year', 'energy_use_sector', 'energy_use_type', name=op.f('pk_core_eiaaeo__yearly_projected_energy_use_by_sector_and_type'))
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('core_eiaaeo__yearly_projected_energy_use_by_sector_and_type')
    # ### end Alembic commands ###
