"""Add byproduct expenses and revenues table to DB

Revision ID: d629674ba279
Revises: 361e6f89774e
Create Date: 2025-10-13 11:16:34.668106

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'd629674ba279'
down_revision = '361e6f89774e'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('_core_eia923__yearly_byproduct_expenses_and_revenues',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Maturity of the source data published by EIA that is reflected in this record. EIA releases data incrementally over time, including monthly updates, annual year-to-date updates, provisional early releases of annual data, and final annual release data that is not expected to change further. Records sourced from multiple upstream EIA datasets may have no well defined data maturity. Records whose values have been inferred within PUDL will also have no data maturity.'),
    sa.Column('capex_air_abatement', sa.Float(), nullable=True, comment='Cost of new structures and/or equipment purchased to reduce, monitor, or eliminate airborne pollutants.'),
    sa.Column('capex_other_abatement', sa.Float(), nullable=True, comment='Other amortizable expenses and purchases of new structures and or equipment when such purchases are not allocated to a particular unit or item.'),
    sa.Column('capex_solid_waste', sa.Float(), nullable=True, comment='Cost of structures or equipment purchased to collect and dispose of objectionable solids or contained liquids.'),
    sa.Column('capex_water_abatement', sa.Float(), nullable=True, comment='Cost of new structures and/or equipment purchased to reduce, monitor, or eliminate waterborne pollutants, including chlorine, phosphates, acids, bases, hydrocarbons, sewage, and other pollutants.'),
    sa.Column('opex_bottom_ash_collection', sa.Float(), nullable=True, comment='Costs of materials and labor associated with the collection of bottom ash from all sources.'),
    sa.Column('opex_bottom_ash_disposal', sa.Float(), nullable=True, comment='Costs of materials and labor associated with the disposal of bottom ash from all sources.'),
    sa.Column('opex_bottom_ash_other', sa.Float(), nullable=True, comment='Other costs associated with the collection and disposal of bottom ash.'),
    sa.Column('opex_fgd_byproduct_collection', sa.Float(), nullable=True, comment='Costs of materials and labor associated with the collection of sulfur by-product (flue gas desulfurization).'),
    sa.Column('opex_fgd_byproduct_disposal', sa.Float(), nullable=True, comment='Costs of materials and labor associated with the disposal of sulfur by-product (flue gas desulfurization).'),
    sa.Column('opex_fgd_byproduct_other', sa.Float(), nullable=True, comment='Other costs associated with the collection and disposal of sulfur by-product (flue gas desulfurization).'),
    sa.Column('opex_fly_ash_collection', sa.Float(), nullable=True, comment='Costs of materials and labor associated with the collection of fly ash from all sources.'),
    sa.Column('opex_fly_ash_disposal', sa.Float(), nullable=True, comment='Costs of materials and labor associated with the disposal of fly ash from all sources.'),
    sa.Column('opex_fly_ash_other', sa.Float(), nullable=True, comment='Other costs associated with the collection and disposal of fly ash.'),
    sa.Column('opex_other_abatement_collection', sa.Float(), nullable=True, comment='Abatement costs of by-product collection that are not allocated to a particular expenditure, e.g., costs of operating an environmental protection office.'),
    sa.Column('opex_other_abatement_disposal', sa.Float(), nullable=True, comment='Abatement costs of by-product disposal that are not allocated to a particular expenditure.'),
    sa.Column('opex_other_abatement_other', sa.Float(), nullable=True, comment='Other abatement costs that are not allocated to a particular expenditure.'),
    sa.Column('opex_total_collection_abatement', sa.Float(), nullable=True, comment='Sum of abatement costs associated with by-product collection.'),
    sa.Column('opex_total_disposal_abatement', sa.Float(), nullable=True, comment='Sum of abatement costs associated with by-product disposal.'),
    sa.Column('opex_total_other_abatement', sa.Float(), nullable=True, comment='Sum of other abatement costs associated with the collection and disposal of byproducts.'),
    sa.Column('opex_water_abatement_collection', sa.Float(), nullable=True, comment='Costs associated with the collection/abatement of water pollution, e.g., equipment operation and maintenance of pumps, pipes, and settling ponds.'),
    sa.Column('opex_water_abatement_disposal', sa.Float(), nullable=True, comment='Costs associated with the disposal of water pollutants.'),
    sa.Column('opex_water_abatement_other', sa.Float(), nullable=True, comment='Other abatement costs associated with water pollutants.'),
    sa.Column('revenues_bottom_ash', sa.Float(), nullable=True, comment='Revenue from the sale of bottom ash by-product.'),
    sa.Column('revenues_fgd_byproducts', sa.Float(), nullable=True, comment='Revenue from the sale of flue gas desulfurization by-product.'),
    sa.Column('revenues_fly_ash', sa.Float(), nullable=True, comment='Revenue from the sale of fly ash by-product.'),
    sa.Column('revenues_fly_bottom_ash_intermingled', sa.Float(), nullable=True, comment='Revenue from the sale of intermingled fly and bottom ash by-product.'),
    sa.Column('revenues_other_byproducts', sa.Float(), nullable=True, comment='Revenue from the sale of other by-products.'),
    sa.Column('revenues_total_byproduct', sa.Float(), nullable=True, comment='Total revenue from the sale of by-products.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk__core_eia923__yearly_byproduct_expenses_and_revenues_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk__core_eia923__yearly_byproduct_expenses_and_revenues_plant_id_eia_core_eia__entity_plants')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_year', name=op.f('pk__core_eia923__yearly_byproduct_expenses_and_revenues'))
    )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('_core_eia923__yearly_byproduct_expenses_and_revenues')
    # ### end Alembic commands ###
