"""Add energy_capacity_mwh to net and non-net generation tables

Revision ID: d52742bec92a
Revises: 1fd5fac43603
Create Date: 2024-10-17 09:48:45.659743

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'd52742bec92a'
down_revision = '1fd5fac43603'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_eia861__yearly_net_metering_customer_fuel_class', schema=None) as batch_op:
        batch_op.add_column(sa.Column('energy_capacity_mwh', sa.Float(), nullable=True, comment='The total amount of energy which the system can supply power before recharging is necessary, in megawatt-hours.'))

    with op.batch_alter_table('core_eia861__yearly_non_net_metering_customer_fuel_class', schema=None) as batch_op:
        batch_op.add_column(sa.Column('energy_capacity_mwh', sa.Float(), nullable=True, comment='The total amount of energy which the system can supply power before recharging is necessary, in megawatt-hours.'))

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_eia861__yearly_non_net_metering_customer_fuel_class', schema=None) as batch_op:
        batch_op.drop_column('energy_capacity_mwh')

    with op.batch_alter_table('core_eia861__yearly_net_metering_customer_fuel_class', schema=None) as batch_op:
        batch_op.drop_column('energy_capacity_mwh')

    # ### end Alembic commands ###
