"""standardize max_steam_flow eia860 column

Revision ID: d2a79341dd16
Revises: 94f669451682
Create Date: 2025-12-04 17:20:30.259770

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'd2a79341dd16'
down_revision = '94f669451682'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_eia860__scd_boilers', schema=None) as batch_op:
        batch_op.add_column(sa.Column('max_steam_flow_lbs_per_hour', sa.Float(), nullable=True, comment='Maximum continuous steam flow at 100 percent load.'))
        batch_op.drop_column('max_steam_flow_1000_lbs_per_hour')

    with op.batch_alter_table('out_eia__yearly_boilers', schema=None) as batch_op:
        batch_op.add_column(sa.Column('max_steam_flow_lbs_per_hour', sa.Float(), nullable=True, comment='Maximum continuous steam flow at 100 percent load.'))
        batch_op.drop_column('max_steam_flow_1000_lbs_per_hour')

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('out_eia__yearly_boilers', schema=None) as batch_op:
        batch_op.add_column(sa.Column('max_steam_flow_1000_lbs_per_hour', sa.FLOAT(), nullable=True))
        batch_op.drop_column('max_steam_flow_lbs_per_hour')

    with op.batch_alter_table('core_eia860__scd_boilers', schema=None) as batch_op:
        batch_op.add_column(sa.Column('max_steam_flow_1000_lbs_per_hour', sa.FLOAT(), nullable=True))
        batch_op.drop_column('max_steam_flow_lbs_per_hour')

    # ### end Alembic commands ###
