"""Add utility name and PUDL ID to detailed income/balance sheet tables.

Revision ID: b2f5c3b44300
Revises: 375fdd29a34b
Create Date: 2025-05-12 17:25:56.991215

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'b2f5c3b44300'
down_revision = '375fdd29a34b'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('out_ferc1__yearly_detailed_balance_sheet_assets', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'))
        batch_op.add_column(sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'))
        batch_op.create_foreign_key(batch_op.f('fk_out_ferc1__yearly_detailed_balance_sheet_assets_utility_id_pudl_core_pudl__entity_utilities_pudl'), 'core_pudl__entity_utilities_pudl', ['utility_id_pudl'], ['utility_id_pudl'])

    with op.batch_alter_table('out_ferc1__yearly_detailed_balance_sheet_liabilities', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'))
        batch_op.add_column(sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'))
        batch_op.create_foreign_key(batch_op.f('fk_out_ferc1__yearly_detailed_balance_sheet_liabilities_utility_id_pudl_core_pudl__entity_utilities_pudl'), 'core_pudl__entity_utilities_pudl', ['utility_id_pudl'], ['utility_id_pudl'])

    with op.batch_alter_table('out_ferc1__yearly_detailed_income_statements', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'))
        batch_op.add_column(sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'))
        batch_op.create_foreign_key(batch_op.f('fk_out_ferc1__yearly_detailed_income_statements_utility_id_pudl_core_pudl__entity_utilities_pudl'), 'core_pudl__entity_utilities_pudl', ['utility_id_pudl'], ['utility_id_pudl'])

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('out_ferc1__yearly_detailed_income_statements', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_out_ferc1__yearly_detailed_income_statements_utility_id_pudl_core_pudl__entity_utilities_pudl'), type_='foreignkey')
        batch_op.drop_column('utility_name_ferc1')
        batch_op.drop_column('utility_id_pudl')

    with op.batch_alter_table('out_ferc1__yearly_detailed_balance_sheet_liabilities', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_out_ferc1__yearly_detailed_balance_sheet_liabilities_utility_id_pudl_core_pudl__entity_utilities_pudl'), type_='foreignkey')
        batch_op.drop_column('utility_name_ferc1')
        batch_op.drop_column('utility_id_pudl')

    with op.batch_alter_table('out_ferc1__yearly_detailed_balance_sheet_assets', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_out_ferc1__yearly_detailed_balance_sheet_assets_utility_id_pudl_core_pudl__entity_utilities_pudl'), type_='foreignkey')
        batch_op.drop_column('utility_name_ferc1')
        batch_op.drop_column('utility_id_pudl')

    # ### end Alembic commands ###
