"""Add my cool ferc1 detailed tables

Revision ID: b2acd10c5d2b
Revises: 1e2ec7bf2b64
Create Date: 2025-02-12 19:01:13.986694

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'b2acd10c5d2b'
down_revision = '1e2ec7bf2b64'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('out_ferc1__yearly_detailed_balance_sheet_assets',
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('xbrl_factoid', sa.Text(), nullable=True, comment='The name of type of value which is a derivative of the XBRL fact name.'),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('plant_function', sa.Text(), nullable=True, comment='Functional role played by utility plant (steam production, nuclear production, distribution, transmission, etc.).'),
    sa.Column('plant_status', sa.Text(), nullable=True, comment='Utility plant financial status (in service, future, leased, total).'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('utility_type_other', sa.Text(), nullable=True, comment='Freeform description of type of utility reported in one of the other three other utility_type sections in the core_ferc1__yearly_utility_plant_summary_sched200 table. This field is reported only in the DBF reporting years (1994-2020).'),
    sa.Column('in_rate_base', sa.Boolean(), nullable=True, comment="Whether or not a record from the detailed FERC1 accounting tables should be considered allowable in a utility's rate base based on utility accounting standards. This flag was mannually compiled by RMI utility accounting experts based on the xbrl_factoid and sometimes varies based on the utility_type, plant_status or plant_function."),
    sa.Column('rate_base_category', sa.Enum('other_plant', 'nuclear', 'transmission', 'net_nuclear_fuel', 'distribution', 'steam', 'experimental_plant', 'net_working_capital', 'general_plant', 'regional_transmission_and_market_operation', 'other_production', 'other_noncurrent_liabilities', 'hydro', 'net_utility_plant', 'intangible_plant', 'other_deferred_debits_and_credits', 'net_regulatory_assets', 'net_ADIT', 'asset_retirement_costs', 'utility_plant', 'electric_plant_leased_to_others', 'electric_plant_held_for_future_use', 'non_utility_plant', 'construction_work_in_progress', 'AROs', 'correction'), nullable=True, comment='A category of asset or liability that RMI compiled to use as a shorthand for various types of utility assets. These tags were compiled manually based on the xbrl_factoid and sometimes varies based on the utility_type, plant_function or plant_status as well.'),
    sa.Column('table_name', sa.Text(), nullable=True, comment='The name of the PUDL database table where a given record originated from.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_detailed_balance_sheet_assets_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities'))
    )
    op.create_table('out_ferc1__yearly_detailed_balance_sheet_liabilities',
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('xbrl_factoid', sa.Text(), nullable=True, comment='The name of type of value which is a derivative of the XBRL fact name.'),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('in_rate_base', sa.Boolean(), nullable=True, comment="Whether or not a record from the detailed FERC1 accounting tables should be considered allowable in a utility's rate base based on utility accounting standards. This flag was mannually compiled by RMI utility accounting experts based on the xbrl_factoid and sometimes varies based on the utility_type, plant_status or plant_function."),
    sa.Column('rate_base_category', sa.Enum('other_plant', 'nuclear', 'transmission', 'net_nuclear_fuel', 'distribution', 'steam', 'experimental_plant', 'net_working_capital', 'general_plant', 'regional_transmission_and_market_operation', 'other_production', 'other_noncurrent_liabilities', 'hydro', 'net_utility_plant', 'intangible_plant', 'other_deferred_debits_and_credits', 'net_regulatory_assets', 'net_ADIT', 'asset_retirement_costs', 'utility_plant', 'electric_plant_leased_to_others', 'electric_plant_held_for_future_use', 'non_utility_plant', 'construction_work_in_progress', 'AROs', 'correction'), nullable=True, comment='A category of asset or liability that RMI compiled to use as a shorthand for various types of utility assets. These tags were compiled manually based on the xbrl_factoid and sometimes varies based on the utility_type, plant_function or plant_status as well.'),
    sa.Column('table_name', sa.Text(), nullable=True, comment='The name of the PUDL database table where a given record originated from.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_detailed_balance_sheet_liabilities_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities'))
    )
    op.create_table('out_ferc1__yearly_detailed_income_statements',
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('xbrl_factoid', sa.Text(), nullable=True, comment='The name of type of value which is a derivative of the XBRL fact name.'),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('plant_function', sa.Text(), nullable=True, comment='Functional role played by utility plant (steam production, nuclear production, distribution, transmission, etc.).'),
    sa.Column('revenue_requirement_technology', sa.Enum('administrative', 'common_plant_electric', 'customer_accounts', 'customer_service', 'distribution', 'general', 'hydraulic_production', 'hydraulic_production_conventional', 'hydraulic_production_pumped_storage', 'intangible', 'nuclear_production', 'other', 'other_electric_plant', 'other_power_supply', 'other_production', 'purchased_power', 'regional_transmission_and_market_operation', 'sales', 'steam_production', 'transmission'), nullable=True, comment="The technology type associated with components of a utility's revenue requirement. These categories were mannually compiled by RMI utility accounting experts based on the xbrl_factoid and sometimes vary based on the utility_type or plant_function as well. This column is intended to be used to aggregate this table."),
    sa.Column('dollar_value', sa.Float(), nullable=True, comment='Dollar value of reported income, expense, asset, or liability.'),
    sa.Column('in_revenue_requirement', sa.Boolean(), nullable=True, comment="Whether or not a record from the detailed income statement data is typically included in a utility's revenue requirement. This flag was mannually compiled by RMI utility accounting experts based on the xbrl_factoid and sometimes varies based on the utility_type or plant_function."),
    sa.Column('revenue_requirement_category', sa.Enum('depreciation_amortization_depletion', 'depreciation_arc', 'fuel', 'investment_tax_credit', 'maintenance', 'non_fuel_operation', 'other', 'purchased_power', 'regulatory_debits_credits', 'taxes'), nullable=True, comment="The category of revenue requirement associated with each component of utility'sincome statements. These categories were mannually compiled by RMI utility accounting experts based on the xbrl_factoid and sometimes vary based on the utility_type or plant_function. This column is intended to be used to aggregate this table."),
    sa.Column('table_name', sa.Text(), nullable=True, comment='The name of the PUDL database table where a given record originated from.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_detailed_income_statements_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities'))
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('out_ferc1__yearly_detailed_income_statements')
    op.drop_table('out_ferc1__yearly_detailed_balance_sheet_liabilities')
    op.drop_table('out_ferc1__yearly_detailed_balance_sheet_assets')
    # ### end Alembic commands ###
