"""Metadata migration for EIA923

Revision ID: af82802f2b64
Revises: d9eb718658b0
Create Date: 2025-07-16 09:37:10.313267

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'af82802f2b64'
down_revision = 'd9eb718658b0'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('_core_eia923__monthly_cooling_system_information',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('cooling_id_eia', sa.Text(), nullable=False, comment="EIA Identification code for cooling system (if multiple cooling systems are not distinguished by separate IDs, the word 'PLANT' is listed to encompass the cooling system for the entire plant)"),
    sa.Column('cooling_status_code', sa.Text(), nullable=True, comment='Operating status of cooling system'),
    sa.Column('cooling_type', sa.Text(), nullable=True, comment='Type of cooling system'),
    sa.Column('monthly_total_cooling_hours_in_service', sa.Integer(), nullable=True, comment='Total hours the system operated during the month'),
    sa.Column('flow_rate_method', sa.Text(), nullable=True, comment='Calculation method for flow rates (actual or method of estimation)'),
    sa.Column('temperature_method', sa.Text(), nullable=True, comment='Method for measurement of temperatures'),
    sa.Column('annual_maximum_intake_summer_temperature_fahrenheit', sa.Float(), nullable=True, comment='Maximum cooling water temperature at intake during the summer'),
    sa.Column('annual_maximum_intake_winter_temperature_fahrenheit', sa.Float(), nullable=True, comment='Maximum cooling water temperature at intake in winter'),
    sa.Column('monthly_average_intake_temperature_fahrenheit', sa.Float(), nullable=True, comment='Average cooling water temperature at intake point'),
    sa.Column('monthly_maximum_intake_temperature_fahrenheit', sa.Float(), nullable=True, comment='Maximum cooling water temperature at intake'),
    sa.Column('annual_maximum_outlet_summer_temperature_fahrenheit', sa.Float(), nullable=True, comment='Maximum cooling water temperature at outlet in summer'),
    sa.Column('annual_maximum_outlet_winter_temperature_fahrenheit', sa.Float(), nullable=True, comment='Maximum cooling water temperature at outlet in winter'),
    sa.Column('monthly_average_discharge_temperature_fahrenheit', sa.Float(), nullable=True, comment='Average cooling water temperature at discharge point'),
    sa.Column('monthly_maximum_discharge_temperature_fahrenheit', sa.Float(), nullable=True, comment='Maximum cooling water temperature at discharge'),
    sa.Column('annual_average_consumption_rate_gallons_per_minute', sa.Float(), nullable=True, comment='Annual average consumption rate of cooling water'),
    sa.Column('monthly_average_consumption_rate_gallons_per_minute', sa.Float(), nullable=True, comment='Monthly average consumption rate of cooling water'),
    sa.Column('monthly_total_consumption_volume_gallons', sa.Float(), nullable=True, comment='Monthly volume of water consumed at consumption point (accurate to 0.1 million gal)'),
    sa.Column('annual_average_discharge_rate_gallons_per_minute', sa.Float(), nullable=True, comment='Annual average discharge rate of cooling water'),
    sa.Column('monthly_average_discharge_rate_gallons_per_minute', sa.Float(), nullable=True, comment='Monthly average discharge rate of cooling water'),
    sa.Column('monthly_total_discharge_volume_gallons', sa.Float(), nullable=True, comment='Monthly volume of water discharged at discharge point (accurate to 0.1 million gal)'),
    sa.Column('monthly_average_diversion_rate_gallons_per_minute', sa.Float(), nullable=True, comment='Monthly average diversion rate of cooling water'),
    sa.Column('monthly_total_diversion_volume_gallons', sa.Float(), nullable=True, comment='Monthly volume of water diverted at diversion point (accurate to 0.1 million gal)'),
    sa.Column('annual_average_withdrawal_rate_gallons_per_minute', sa.Float(), nullable=True, comment='Annual average withdrawal rate of cooling water'),
    sa.Column('monthly_average_withdrawal_rate_gallons_per_minute', sa.Float(), nullable=True, comment='Monthly average withdrawal rate of cooling water'),
    sa.Column('monthly_total_withdrawal_volume_gallons', sa.Float(), nullable=True, comment='Monthly volume of water withdrawn at withdrawal point (accurate to 0.1 million gal)'),
    sa.Column('annual_total_chlorine_lbs', sa.Float(), nullable=True, comment='Amount of elemental chlorine added to cooling water annually. May be just the amount of chlorine-containing compound if schedule 9 is filled out.'),
    sa.Column('monthly_total_chlorine_lbs', sa.Float(), nullable=True, comment='Amount of elemental chlorine added to cooling water monthly. May be just the amount of chlorine-containing compound if schedule 9 is filled out.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['cooling_status_code'], ['core_eia__codes_operational_status.code'], name=op.f('fk__core_eia923__monthly_cooling_system_information_cooling_status_code_core_eia__codes_operational_status')),
    sa.ForeignKeyConstraint(['cooling_type'], ['core_eia__codes_cooling_system_types.code'], name=op.f('fk__core_eia923__monthly_cooling_system_information_cooling_type_core_eia__codes_cooling_system_types')),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk__core_eia923__monthly_cooling_system_information_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk__core_eia923__monthly_cooling_system_information_plant_id_eia_core_eia__entity_plants')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_date', 'cooling_id_eia', name=op.f('pk__core_eia923__monthly_cooling_system_information'))
    )
    op.create_table('_core_eia923__yearly_fgd_operation_maintenance',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('so2_control_id_eia', sa.Text(), nullable=False, comment='Sulfur dioxide control identification number. This ID is not a unique identifier.'),
    sa.Column('opex_fgd_feed_materials_chemical', sa.Integer(), nullable=True, comment='Annual operation and maintenance expenditures for feed materials and chemicals for flue gas desulfurization equipment, excluding electricity.'),
    sa.Column('opex_fgd_labor_supervision', sa.Integer(), nullable=True, comment='Annual operation and maintenance expenditures for labor and supervision of flue gas desulfurization equipment, excluding electricity.'),
    sa.Column('opex_fgd_land_acquisition', sa.Integer(), nullable=True, comment='Annual operation and maintenance expenditures for land acquisition for flue gas desulfurization equipment, excluding electricity.'),
    sa.Column('opex_fgd_maintenance_material_other', sa.Integer(), nullable=True, comment='Annual operation and maintenance expenditures for maintenance, materials and all other costs of flue gas desulfurization equipment, excluding electricity'),
    sa.Column('opex_fgd_waste_disposal', sa.Integer(), nullable=True, comment='Annual operation and maintenance expenditures for waste disposal, excluding electricity.'),
    sa.Column('opex_fgd_total_cost', sa.Integer(), nullable=True, comment='Annual total cost of operation and maintenance expenditures on flue gas desulfurization equipment, excluding electricity'),
    sa.Column('fgd_control_flag', sa.Boolean(), nullable=True, comment='Indicates whether or not a plant has a flue gas desulfurization control unit.'),
    sa.Column('fgd_operational_status_code', sa.Text(), nullable=True, comment='Operating status code for flue gas desulfurization equipment.'),
    sa.Column('fgd_hours_in_service', sa.Integer(), nullable=True, comment='Number of hours the flue gas desulfurization equipment was in operation during the year.'),
    sa.Column('fgd_electricity_consumption_mwh', sa.Float(), nullable=True, comment='Electric power consumed by the flue gas desulfurization unit (in MWh).'),
    sa.Column('fgd_sorbent_consumption_1000_tons', sa.Float(), nullable=True, comment='Quantity of flue gas desulfurization sorbent used, to the nearest 0.1 thousand tons.'),
    sa.Column('so2_removal_efficiency_tested', sa.Float(), nullable=True, comment='Removal efficiency for sulfur dioxide (to the nearest 0.1 percent by weight) at tested rate at 100 percent load.'),
    sa.Column('so2_removal_efficiency_annual', sa.Float(), nullable=True, comment='Removal efficiency for sulfur dioxide (to the nearest 0.1 percent by weight) based on designed firing rate and hours in operation (listed as a percentage).'),
    sa.Column('so2_test_date', sa.Date(), nullable=True, comment='Date of most recent test for sulfur dioxide removal efficiency.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk__core_eia923__yearly_fgd_operation_maintenance_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['fgd_operational_status_code'], ['core_eia__codes_operational_status.code'], name=op.f('fk__core_eia923__yearly_fgd_operation_maintenance_fgd_operational_status_code_core_eia__codes_operational_status')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk__core_eia923__yearly_fgd_operation_maintenance_plant_id_eia_core_eia__entity_plants')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_date', 'so2_control_id_eia', name=op.f('pk__core_eia923__yearly_fgd_operation_maintenance'))
    )
    op.drop_table('_core_eia923__cooling_system_information')
    op.drop_table('_core_eia923__fgd_operation_maintenance')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('_core_eia923__fgd_operation_maintenance',
    sa.Column('report_date', sa.DATE(), nullable=False),
    sa.Column('plant_id_eia', sa.INTEGER(), nullable=False),
    sa.Column('so2_control_id_eia', sa.TEXT(), nullable=False),
    sa.Column('opex_fgd_feed_materials_chemical', sa.INTEGER(), nullable=True),
    sa.Column('opex_fgd_labor_supervision', sa.INTEGER(), nullable=True),
    sa.Column('opex_fgd_land_acquisition', sa.INTEGER(), nullable=True),
    sa.Column('opex_fgd_maintenance_material_other', sa.INTEGER(), nullable=True),
    sa.Column('opex_fgd_waste_disposal', sa.INTEGER(), nullable=True),
    sa.Column('opex_fgd_total_cost', sa.INTEGER(), nullable=True),
    sa.Column('fgd_control_flag', sa.BOOLEAN(), nullable=True),
    sa.Column('fgd_operational_status_code', sa.TEXT(), nullable=True),
    sa.Column('fgd_hours_in_service', sa.INTEGER(), nullable=True),
    sa.Column('fgd_electricity_consumption_mwh', sa.FLOAT(), nullable=True),
    sa.Column('fgd_sorbent_consumption_1000_tons', sa.FLOAT(), nullable=True),
    sa.Column('so2_removal_efficiency_tested', sa.FLOAT(), nullable=True),
    sa.Column('so2_removal_efficiency_annual', sa.FLOAT(), nullable=True),
    sa.Column('so2_test_date', sa.DATE(), nullable=True),
    sa.Column('data_maturity', sa.TEXT(), nullable=True),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk__core_eia923__fgd_operation_maintenance_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['fgd_operational_status_code'], ['core_eia__codes_operational_status.code'], name=op.f('fk__core_eia923__fgd_operation_maintenance_fgd_operational_status_code_core_eia__codes_operational_status')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk__core_eia923__fgd_operation_maintenance_plant_id_eia_core_eia__entity_plants')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_date', 'so2_control_id_eia', name=op.f('pk__core_eia923__fgd_operation_maintenance'))
    )
    op.create_table('_core_eia923__cooling_system_information',
    sa.Column('report_date', sa.DATE(), nullable=False),
    sa.Column('plant_id_eia', sa.INTEGER(), nullable=False),
    sa.Column('cooling_id_eia', sa.TEXT(), nullable=False),
    sa.Column('cooling_status_code', sa.TEXT(), nullable=True),
    sa.Column('cooling_type', sa.TEXT(), nullable=True),
    sa.Column('monthly_total_cooling_hours_in_service', sa.INTEGER(), nullable=True),
    sa.Column('flow_rate_method', sa.TEXT(), nullable=True),
    sa.Column('temperature_method', sa.TEXT(), nullable=True),
    sa.Column('annual_maximum_intake_summer_temperature_fahrenheit', sa.FLOAT(), nullable=True),
    sa.Column('annual_maximum_intake_winter_temperature_fahrenheit', sa.FLOAT(), nullable=True),
    sa.Column('monthly_average_intake_temperature_fahrenheit', sa.FLOAT(), nullable=True),
    sa.Column('monthly_maximum_intake_temperature_fahrenheit', sa.FLOAT(), nullable=True),
    sa.Column('annual_maximum_outlet_summer_temperature_fahrenheit', sa.FLOAT(), nullable=True),
    sa.Column('annual_maximum_outlet_winter_temperature_fahrenheit', sa.FLOAT(), nullable=True),
    sa.Column('monthly_average_discharge_temperature_fahrenheit', sa.FLOAT(), nullable=True),
    sa.Column('monthly_maximum_discharge_temperature_fahrenheit', sa.FLOAT(), nullable=True),
    sa.Column('annual_average_consumption_rate_gallons_per_minute', sa.FLOAT(), nullable=True),
    sa.Column('monthly_average_consumption_rate_gallons_per_minute', sa.FLOAT(), nullable=True),
    sa.Column('monthly_total_consumption_volume_gallons', sa.FLOAT(), nullable=True),
    sa.Column('annual_average_discharge_rate_gallons_per_minute', sa.FLOAT(), nullable=True),
    sa.Column('monthly_average_discharge_rate_gallons_per_minute', sa.FLOAT(), nullable=True),
    sa.Column('monthly_total_discharge_volume_gallons', sa.FLOAT(), nullable=True),
    sa.Column('monthly_average_diversion_rate_gallons_per_minute', sa.FLOAT(), nullable=True),
    sa.Column('monthly_total_diversion_volume_gallons', sa.FLOAT(), nullable=True),
    sa.Column('annual_average_withdrawal_rate_gallons_per_minute', sa.FLOAT(), nullable=True),
    sa.Column('monthly_average_withdrawal_rate_gallons_per_minute', sa.FLOAT(), nullable=True),
    sa.Column('monthly_total_withdrawal_volume_gallons', sa.FLOAT(), nullable=True),
    sa.Column('annual_total_chlorine_lbs', sa.FLOAT(), nullable=True),
    sa.Column('monthly_total_chlorine_lbs', sa.FLOAT(), nullable=True),
    sa.Column('data_maturity', sa.TEXT(), nullable=True),
    sa.ForeignKeyConstraint(['cooling_status_code'], ['core_eia__codes_operational_status.code'], name=op.f('fk__core_eia923__cooling_system_information_cooling_status_code_core_eia__codes_operational_status')),
    sa.ForeignKeyConstraint(['cooling_type'], ['core_eia__codes_cooling_system_types.code'], name=op.f('fk__core_eia923__cooling_system_information_cooling_type_core_eia__codes_cooling_system_types')),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk__core_eia923__cooling_system_information_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk__core_eia923__cooling_system_information_plant_id_eia_core_eia__entity_plants')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_date', 'cooling_id_eia', name=op.f('pk__core_eia923__cooling_system_information'))
    )
    op.drop_table('_core_eia923__yearly_fgd_operation_maintenance')
    op.drop_table('_core_eia923__monthly_cooling_system_information')
    # ### end Alembic commands ###
