"""Wipe and reset

Revision ID: aee9c15c7394
Revises:
Create Date: 2024-07-23 10:46:16.550280

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'aee9c15c7394'
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('core_eia861__assn_balancing_authority',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('balancing_authority_id_eia', sa.Integer(), nullable=False, comment='EIA balancing authority ID. This is often (but not always!) the same as the utility ID associated with the same legal entity.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.Column('state', sa.Text(), nullable=False, comment='Two letter US state abbreviation.'),
    sa.PrimaryKeyConstraint('report_date', 'balancing_authority_id_eia', 'utility_id_eia', 'state', name=op.f('pk_core_eia861__assn_balancing_authority'))
    )
    op.create_table('core_eia861__assn_utility',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.Column('state', sa.Text(), nullable=False, comment='Two letter US state abbreviation.'),
    sa.PrimaryKeyConstraint('report_date', 'utility_id_eia', 'state', name=op.f('pk_core_eia861__assn_utility'))
    )
    op.create_table('core_eia861__yearly_balancing_authority',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('balancing_authority_id_eia', sa.Integer(), nullable=False, comment='EIA balancing authority ID. This is often (but not always!) the same as the utility ID associated with the same legal entity.'),
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=True, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('balancing_authority_name_eia', sa.Text(), nullable=True, comment='Name of the balancing authority.'),
    sa.PrimaryKeyConstraint('report_date', 'balancing_authority_id_eia', name=op.f('pk_core_eia861__yearly_balancing_authority'))
    )
    op.create_table('core_eia__codes_averaging_periods',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_averaging_periods'))
    )
    op.create_table('core_eia__codes_balancing_authorities',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.Column('balancing_authority_region_code_eia', sa.Enum('TEX', 'NY', 'CAN', 'MIDW', 'CENT', 'NW', 'CAL', 'FLA', 'SW', 'SE', 'CAR', 'NE', 'MIDA', 'MEX'), nullable=True, comment='EIA balancing authority region code.'),
    sa.Column('balancing_authority_region_name_eia', sa.Text(), nullable=True, comment='Human-readable name of the EIA balancing region.'),
    sa.Column('report_timezone', sa.Enum('America/Anchorage', 'America/Chicago', 'America/Denver', 'America/Los_Angeles', 'America/New_York', 'America/Phoenix', 'Pacific/Honolulu'), nullable=True, comment='Timezone used by the reporting entity. For use in localizing UTC times.'),
    sa.Column('balancing_authority_retirement_date', sa.Date(), nullable=True, comment='Date on which the balancing authority ceased independent operation.'),
    sa.Column('is_generation_only', sa.Boolean(), nullable=True, comment='Indicates whether the balancing authority is generation-only, meaning it does not serve retail customers and thus reports only net generation and interchange, but not demand.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_balancing_authorities'))
    )
    op.create_table('core_eia__codes_boiler_generator_assn_types',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_boiler_generator_assn_types'))
    )
    op.create_table('core_eia__codes_boiler_status',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_boiler_status'))
    )
    op.create_table('core_eia__codes_boiler_types',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_boiler_types'))
    )
    op.create_table('core_eia__codes_coalmine_types',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_coalmine_types'))
    )
    op.create_table('core_eia__codes_contract_types',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_contract_types'))
    )
    op.create_table('core_eia__codes_cooling_system_types',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_cooling_system_types'))
    )
    op.create_table('core_eia__codes_cooling_tower_types',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_cooling_tower_types'))
    )
    op.create_table('core_eia__codes_cooling_water_sources',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_cooling_water_sources'))
    )
    op.create_table('core_eia__codes_cooling_water_types',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_cooling_water_types'))
    )
    op.create_table('core_eia__codes_emission_control_equipment_types',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_emission_control_equipment_types'))
    )
    op.create_table('core_eia__codes_energy_sources',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('fuel_units', sa.Enum('barrels', 'mcf', 'mwh', 'short_tons'), nullable=True, comment='Reported unit of measure for fuel.'),
    sa.Column('min_fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Minimum heat content per physical unit of fuel in MMBtu.'),
    sa.Column('max_fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Maximum heat content per physical unit of fuel in MMBtu.'),
    sa.Column('fuel_group_eia', sa.Enum('fossil', 'other', 'renewable'), nullable=True, comment='High level fuel group defined in the 2021-2023 EIA Form 860 instructions, Table 28.'),
    sa.Column('fuel_derived_from', sa.Enum('biomass', 'coal', 'gas', 'other', 'petroleum'), nullable=True, comment='Original fuel from which this refined fuel was derived.'),
    sa.Column('fuel_phase', sa.Enum('gas', 'liquid', 'solid'), nullable=True, comment='Physical phase of matter of the fuel.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_energy_sources'))
    )
    op.create_table('core_eia__codes_environmental_equipment_manufacturers',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_environmental_equipment_manufacturers'))
    )
    op.create_table('core_eia__codes_firing_types',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_firing_types'))
    )
    op.create_table('core_eia__codes_fuel_transportation_modes',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_fuel_transportation_modes'))
    )
    op.create_table('core_eia__codes_fuel_types_agg',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_fuel_types_agg'))
    )
    op.create_table('core_eia__codes_mercury_compliance_strategies',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_mercury_compliance_strategies'))
    )
    op.create_table('core_eia__codes_momentary_interruptions',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_momentary_interruptions'))
    )
    op.create_table('core_eia__codes_nox_compliance_strategies',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_nox_compliance_strategies'))
    )
    op.create_table('core_eia__codes_nox_control_status',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_nox_control_status'))
    )
    op.create_table('core_eia__codes_nox_units',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_nox_units'))
    )
    op.create_table('core_eia__codes_operational_status',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.Column('operational_status', sa.Text(), nullable=True, comment='The operating status of the asset. For generators this is based on which tab the generator was listed in in EIA 860.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_operational_status'))
    )
    op.create_table('core_eia__codes_particulate_compliance_strategies',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_particulate_compliance_strategies'))
    )
    op.create_table('core_eia__codes_particulate_units',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_particulate_units'))
    )
    op.create_table('core_eia__codes_prime_movers',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_prime_movers'))
    )
    op.create_table('core_eia__codes_regulations',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_regulations'))
    )
    op.create_table('core_eia__codes_reporting_frequencies',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_reporting_frequencies'))
    )
    op.create_table('core_eia__codes_sector_consolidated',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_sector_consolidated'))
    )
    op.create_table('core_eia__codes_so2_compliance_strategies',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_so2_compliance_strategies'))
    )
    op.create_table('core_eia__codes_so2_units',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_so2_units'))
    )
    op.create_table('core_eia__codes_sorbent_types',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_sorbent_types'))
    )
    op.create_table('core_eia__codes_steam_plant_types',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_steam_plant_types'))
    )
    op.create_table('core_eia__codes_storage_enclosure_types',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_storage_enclosure_types'))
    )
    op.create_table('core_eia__codes_storage_technology_types',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_storage_technology_types'))
    )
    op.create_table('core_eia__codes_wet_dry_bottom',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_wet_dry_bottom'))
    )
    op.create_table('core_eia__codes_wind_quality_class',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.Column('wind_speed_avg_ms', sa.Float(), nullable=True, comment='Average wind speed in meters per second.'),
    sa.Column('extreme_fifty_year_gust_ms', sa.Float(), nullable=True, comment='The extreme 50-year wind gusts at this generator in meters per hour.'),
    sa.Column('turbulence_intensity_a', sa.Float(), nullable=True, comment='The upper bounds of the turbulence intensity at the wind site (ratio of standard deviation of fluctuating wind velocity to the mean wind speed).'),
    sa.Column('turbulence_intensity_b', sa.Float(), nullable=True, comment='The lower bounds of the turbulence intensity at the wind site (ratio of standard deviation of fluctuating wind velocity to the mean wind speed).'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_eia__codes_wind_quality_class'))
    )
    op.create_table('core_eia__entity_plants',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('city', sa.Text(), nullable=True, comment='Name of the city.'),
    sa.Column('county', sa.Text(), nullable=True, comment='County name.'),
    sa.Column('latitude', sa.Float(), nullable=True, comment="Latitude of the plant's location, in degrees."),
    sa.Column('longitude', sa.Float(), nullable=True, comment="Longitude of the plant's location, in degrees."),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('street_address', sa.Text(), nullable=True, comment='Physical street address.'),
    sa.Column('zip_code', sa.Text(), nullable=True, comment='Five digit US Zip Code.'),
    sa.Column('timezone', sa.Enum('Africa/Abidjan', 'Africa/Accra', 'Africa/Addis_Ababa', 'Africa/Algiers', 'Africa/Asmara', 'Africa/Asmera', 'Africa/Bamako', 'Africa/Bangui', 'Africa/Banjul', 'Africa/Bissau', 'Africa/Blantyre', 'Africa/Brazzaville', 'Africa/Bujumbura', 'Africa/Cairo', 'Africa/Casablanca', 'Africa/Ceuta', 'Africa/Conakry', 'Africa/Dakar', 'Africa/Dar_es_Salaam', 'Africa/Djibouti', 'Africa/Douala', 'Africa/El_Aaiun', 'Africa/Freetown', 'Africa/Gaborone', 'Africa/Harare', 'Africa/Johannesburg', 'Africa/Juba', 'Africa/Kampala', 'Africa/Khartoum', 'Africa/Kigali', 'Africa/Kinshasa', 'Africa/Lagos', 'Africa/Libreville', 'Africa/Lome', 'Africa/Luanda', 'Africa/Lubumbashi', 'Africa/Lusaka', 'Africa/Malabo', 'Africa/Maputo', 'Africa/Maseru', 'Africa/Mbabane', 'Africa/Mogadishu', 'Africa/Monrovia', 'Africa/Nairobi', 'Africa/Ndjamena', 'Africa/Niamey', 'Africa/Nouakchott', 'Africa/Ouagadougou', 'Africa/Porto-Novo', 'Africa/Sao_Tome', 'Africa/Timbuktu', 'Africa/Tripoli', 'Africa/Tunis', 'Africa/Windhoek', 'America/Adak', 'America/Anchorage', 'America/Anguilla', 'America/Antigua', 'America/Araguaina', 'America/Argentina/Buenos_Aires', 'America/Argentina/Catamarca', 'America/Argentina/ComodRivadavia', 'America/Argentina/Cordoba', 'America/Argentina/Jujuy', 'America/Argentina/La_Rioja', 'America/Argentina/Mendoza', 'America/Argentina/Rio_Gallegos', 'America/Argentina/Salta', 'America/Argentina/San_Juan', 'America/Argentina/San_Luis', 'America/Argentina/Tucuman', 'America/Argentina/Ushuaia', 'America/Aruba', 'America/Asuncion', 'America/Atikokan', 'America/Atka', 'America/Bahia', 'America/Bahia_Banderas', 'America/Barbados', 'America/Belem', 'America/Belize', 'America/Blanc-Sablon', 'America/Boa_Vista', 'America/Bogota', 'America/Boise', 'America/Buenos_Aires', 'America/Cambridge_Bay', 'America/Campo_Grande', 'America/Cancun', 'America/Caracas', 'America/Catamarca', 'America/Cayenne', 'America/Cayman', 'America/Chicago', 'America/Chihuahua', 'America/Ciudad_Juarez', 'America/Coral_Harbour', 'America/Cordoba', 'America/Costa_Rica', 'America/Creston', 'America/Cuiaba', 'America/Curacao', 'America/Danmarkshavn', 'America/Dawson', 'America/Dawson_Creek', 'America/Denver', 'America/Detroit', 'America/Dominica', 'America/Edmonton', 'America/Eirunepe', 'America/El_Salvador', 'America/Ensenada', 'America/Fort_Nelson', 'America/Fort_Wayne', 'America/Fortaleza', 'America/Glace_Bay', 'America/Godthab', 'America/Goose_Bay', 'America/Grand_Turk', 'America/Grenada', 'America/Guadeloupe', 'America/Guatemala', 'America/Guayaquil', 'America/Guyana', 'America/Halifax', 'America/Havana', 'America/Hermosillo', 'America/Indiana/Indianapolis', 'America/Indiana/Knox', 'America/Indiana/Marengo', 'America/Indiana/Petersburg', 'America/Indiana/Tell_City', 'America/Indiana/Vevay', 'America/Indiana/Vincennes', 'America/Indiana/Winamac', 'America/Indianapolis', 'America/Inuvik', 'America/Iqaluit', 'America/Jamaica', 'America/Jujuy', 'America/Juneau', 'America/Kentucky/Louisville', 'America/Kentucky/Monticello', 'America/Knox_IN', 'America/Kralendijk', 'America/La_Paz', 'America/Lima', 'America/Los_Angeles', 'America/Louisville', 'America/Lower_Princes', 'America/Maceio', 'America/Managua', 'America/Manaus', 'America/Marigot', 'America/Martinique', 'America/Matamoros', 'America/Mazatlan', 'America/Mendoza', 'America/Menominee', 'America/Merida', 'America/Metlakatla', 'America/Mexico_City', 'America/Miquelon', 'America/Moncton', 'America/Monterrey', 'America/Montevideo', 'America/Montreal', 'America/Montserrat', 'America/Nassau', 'America/New_York', 'America/Nipigon', 'America/Nome', 'America/Noronha', 'America/North_Dakota/Beulah', 'America/North_Dakota/Center', 'America/North_Dakota/New_Salem', 'America/Nuuk', 'America/Ojinaga', 'America/Panama', 'America/Pangnirtung', 'America/Paramaribo', 'America/Phoenix', 'America/Port-au-Prince', 'America/Port_of_Spain', 'America/Porto_Acre', 'America/Porto_Velho', 'America/Puerto_Rico', 'America/Punta_Arenas', 'America/Rainy_River', 'America/Rankin_Inlet', 'America/Recife', 'America/Regina', 'America/Resolute', 'America/Rio_Branco', 'America/Rosario', 'America/Santa_Isabel', 'America/Santarem', 'America/Santiago', 'America/Santo_Domingo', 'America/Sao_Paulo', 'America/Scoresbysund', 'America/Shiprock', 'America/Sitka', 'America/St_Barthelemy', 'America/St_Johns', 'America/St_Kitts', 'America/St_Lucia', 'America/St_Thomas', 'America/St_Vincent', 'America/Swift_Current', 'America/Tegucigalpa', 'America/Thule', 'America/Thunder_Bay', 'America/Tijuana', 'America/Toronto', 'America/Tortola', 'America/Vancouver', 'America/Virgin', 'America/Whitehorse', 'America/Winnipeg', 'America/Yakutat', 'America/Yellowknife', 'Antarctica/Casey', 'Antarctica/Davis', 'Antarctica/DumontDUrville', 'Antarctica/Macquarie', 'Antarctica/Mawson', 'Antarctica/McMurdo', 'Antarctica/Palmer', 'Antarctica/Rothera', 'Antarctica/South_Pole', 'Antarctica/Syowa', 'Antarctica/Troll', 'Antarctica/Vostok', 'Arctic/Longyearbyen', 'Asia/Aden', 'Asia/Almaty', 'Asia/Amman', 'Asia/Anadyr', 'Asia/Aqtau', 'Asia/Aqtobe', 'Asia/Ashgabat', 'Asia/Ashkhabad', 'Asia/Atyrau', 'Asia/Baghdad', 'Asia/Bahrain', 'Asia/Baku', 'Asia/Bangkok', 'Asia/Barnaul', 'Asia/Beirut', 'Asia/Bishkek', 'Asia/Brunei', 'Asia/Calcutta', 'Asia/Chita', 'Asia/Choibalsan', 'Asia/Chongqing', 'Asia/Chungking', 'Asia/Colombo', 'Asia/Dacca', 'Asia/Damascus', 'Asia/Dhaka', 'Asia/Dili', 'Asia/Dubai', 'Asia/Dushanbe', 'Asia/Famagusta', 'Asia/Gaza', 'Asia/Harbin', 'Asia/Hebron', 'Asia/Ho_Chi_Minh', 'Asia/Hong_Kong', 'Asia/Hovd', 'Asia/Irkutsk', 'Asia/Istanbul', 'Asia/Jakarta', 'Asia/Jayapura', 'Asia/Jerusalem', 'Asia/Kabul', 'Asia/Kamchatka', 'Asia/Karachi', 'Asia/Kashgar', 'Asia/Kathmandu', 'Asia/Katmandu', 'Asia/Khandyga', 'Asia/Kolkata', 'Asia/Krasnoyarsk', 'Asia/Kuala_Lumpur', 'Asia/Kuching', 'Asia/Kuwait', 'Asia/Macao', 'Asia/Macau', 'Asia/Magadan', 'Asia/Makassar', 'Asia/Manila', 'Asia/Muscat', 'Asia/Nicosia', 'Asia/Novokuznetsk', 'Asia/Novosibirsk', 'Asia/Omsk', 'Asia/Oral', 'Asia/Phnom_Penh', 'Asia/Pontianak', 'Asia/Pyongyang', 'Asia/Qatar', 'Asia/Qostanay', 'Asia/Qyzylorda', 'Asia/Rangoon', 'Asia/Riyadh', 'Asia/Saigon', 'Asia/Sakhalin', 'Asia/Samarkand', 'Asia/Seoul', 'Asia/Shanghai', 'Asia/Singapore', 'Asia/Srednekolymsk', 'Asia/Taipei', 'Asia/Tashkent', 'Asia/Tbilisi', 'Asia/Tehran', 'Asia/Tel_Aviv', 'Asia/Thimbu', 'Asia/Thimphu', 'Asia/Tokyo', 'Asia/Tomsk', 'Asia/Ujung_Pandang', 'Asia/Ulaanbaatar', 'Asia/Ulan_Bator', 'Asia/Urumqi', 'Asia/Ust-Nera', 'Asia/Vientiane', 'Asia/Vladivostok', 'Asia/Yakutsk', 'Asia/Yangon', 'Asia/Yekaterinburg', 'Asia/Yerevan', 'Atlantic/Azores', 'Atlantic/Bermuda', 'Atlantic/Canary', 'Atlantic/Cape_Verde', 'Atlantic/Faeroe', 'Atlantic/Faroe', 'Atlantic/Jan_Mayen', 'Atlantic/Madeira', 'Atlantic/Reykjavik', 'Atlantic/South_Georgia', 'Atlantic/St_Helena', 'Atlantic/Stanley', 'Australia/ACT', 'Australia/Adelaide', 'Australia/Brisbane', 'Australia/Broken_Hill', 'Australia/Canberra', 'Australia/Currie', 'Australia/Darwin', 'Australia/Eucla', 'Australia/Hobart', 'Australia/LHI', 'Australia/Lindeman', 'Australia/Lord_Howe', 'Australia/Melbourne', 'Australia/NSW', 'Australia/North', 'Australia/Perth', 'Australia/Queensland', 'Australia/South', 'Australia/Sydney', 'Australia/Tasmania', 'Australia/Victoria', 'Australia/West', 'Australia/Yancowinna', 'Brazil/Acre', 'Brazil/DeNoronha', 'Brazil/East', 'Brazil/West', 'CET', 'CST6CDT', 'Canada/Atlantic', 'Canada/Central', 'Canada/Eastern', 'Canada/Mountain', 'Canada/Newfoundland', 'Canada/Pacific', 'Canada/Saskatchewan', 'Canada/Yukon', 'Chile/Continental', 'Chile/EasterIsland', 'Cuba', 'EET', 'EST', 'EST5EDT', 'Egypt', 'Eire', 'Etc/GMT', 'Etc/GMT+0', 'Etc/GMT+1', 'Etc/GMT+10', 'Etc/GMT+11', 'Etc/GMT+12', 'Etc/GMT+2', 'Etc/GMT+3', 'Etc/GMT+4', 'Etc/GMT+5', 'Etc/GMT+6', 'Etc/GMT+7', 'Etc/GMT+8', 'Etc/GMT+9', 'Etc/GMT-0', 'Etc/GMT-1', 'Etc/GMT-10', 'Etc/GMT-11', 'Etc/GMT-12', 'Etc/GMT-13', 'Etc/GMT-14', 'Etc/GMT-2', 'Etc/GMT-3', 'Etc/GMT-4', 'Etc/GMT-5', 'Etc/GMT-6', 'Etc/GMT-7', 'Etc/GMT-8', 'Etc/GMT-9', 'Etc/GMT0', 'Etc/Greenwich', 'Etc/UCT', 'Etc/UTC', 'Etc/Universal', 'Etc/Zulu', 'Europe/Amsterdam', 'Europe/Andorra', 'Europe/Astrakhan', 'Europe/Athens', 'Europe/Belfast', 'Europe/Belgrade', 'Europe/Berlin', 'Europe/Bratislava', 'Europe/Brussels', 'Europe/Bucharest', 'Europe/Budapest', 'Europe/Busingen', 'Europe/Chisinau', 'Europe/Copenhagen', 'Europe/Dublin', 'Europe/Gibraltar', 'Europe/Guernsey', 'Europe/Helsinki', 'Europe/Isle_of_Man', 'Europe/Istanbul', 'Europe/Jersey', 'Europe/Kaliningrad', 'Europe/Kiev', 'Europe/Kirov', 'Europe/Kyiv', 'Europe/Lisbon', 'Europe/Ljubljana', 'Europe/London', 'Europe/Luxembourg', 'Europe/Madrid', 'Europe/Malta', 'Europe/Mariehamn', 'Europe/Minsk', 'Europe/Monaco', 'Europe/Moscow', 'Europe/Nicosia', 'Europe/Oslo', 'Europe/Paris', 'Europe/Podgorica', 'Europe/Prague', 'Europe/Riga', 'Europe/Rome', 'Europe/Samara', 'Europe/San_Marino', 'Europe/Sarajevo', 'Europe/Saratov', 'Europe/Simferopol', 'Europe/Skopje', 'Europe/Sofia', 'Europe/Stockholm', 'Europe/Tallinn', 'Europe/Tirane', 'Europe/Tiraspol', 'Europe/Ulyanovsk', 'Europe/Uzhgorod', 'Europe/Vaduz', 'Europe/Vatican', 'Europe/Vienna', 'Europe/Vilnius', 'Europe/Volgograd', 'Europe/Warsaw', 'Europe/Zagreb', 'Europe/Zaporozhye', 'Europe/Zurich', 'GB', 'GB-Eire', 'GMT', 'GMT+0', 'GMT-0', 'GMT0', 'Greenwich', 'HST', 'Hongkong', 'Iceland', 'Indian/Antananarivo', 'Indian/Chagos', 'Indian/Christmas', 'Indian/Cocos', 'Indian/Comoro', 'Indian/Kerguelen', 'Indian/Mahe', 'Indian/Maldives', 'Indian/Mauritius', 'Indian/Mayotte', 'Indian/Reunion', 'Iran', 'Israel', 'Jamaica', 'Japan', 'Kwajalein', 'Libya', 'MET', 'MST', 'MST7MDT', 'Mexico/BajaNorte', 'Mexico/BajaSur', 'Mexico/General', 'NZ', 'NZ-CHAT', 'Navajo', 'PRC', 'PST8PDT', 'Pacific/Apia', 'Pacific/Auckland', 'Pacific/Bougainville', 'Pacific/Chatham', 'Pacific/Chuuk', 'Pacific/Easter', 'Pacific/Efate', 'Pacific/Enderbury', 'Pacific/Fakaofo', 'Pacific/Fiji', 'Pacific/Funafuti', 'Pacific/Galapagos', 'Pacific/Gambier', 'Pacific/Guadalcanal', 'Pacific/Guam', 'Pacific/Honolulu', 'Pacific/Johnston', 'Pacific/Kanton', 'Pacific/Kiritimati', 'Pacific/Kosrae', 'Pacific/Kwajalein', 'Pacific/Majuro', 'Pacific/Marquesas', 'Pacific/Midway', 'Pacific/Nauru', 'Pacific/Niue', 'Pacific/Norfolk', 'Pacific/Noumea', 'Pacific/Pago_Pago', 'Pacific/Palau', 'Pacific/Pitcairn', 'Pacific/Pohnpei', 'Pacific/Ponape', 'Pacific/Port_Moresby', 'Pacific/Rarotonga', 'Pacific/Saipan', 'Pacific/Samoa', 'Pacific/Tahiti', 'Pacific/Tarawa', 'Pacific/Tongatapu', 'Pacific/Truk', 'Pacific/Wake', 'Pacific/Wallis', 'Pacific/Yap', 'Poland', 'Portugal', 'ROC', 'ROK', 'Singapore', 'Turkey', 'UCT', 'US/Alaska', 'US/Aleutian', 'US/Arizona', 'US/Central', 'US/East-Indiana', 'US/Eastern', 'US/Hawaii', 'US/Indiana-Starke', 'US/Michigan', 'US/Mountain', 'US/Pacific', 'US/Samoa', 'UTC', 'Universal', 'W-SU', 'WET', 'Zulu'), nullable=True, comment='IANA timezone name'),
    sa.PrimaryKeyConstraint('plant_id_eia', name=op.f('pk_core_eia__entity_plants'))
    )
    op.create_table('core_eia__entity_utilities',
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.PrimaryKeyConstraint('utility_id_eia', name=op.f('pk_core_eia__entity_utilities'))
    )
    op.create_table('core_eia__yearly_fuel_receipts_costs_aggs',
    sa.Column('fuel_agg', sa.Text(), nullable=False, comment='Category of fuel aggregation in EIA bulk electricity data.'),
    sa.Column('geo_agg', sa.Text(), nullable=False, comment='Category of geographic aggregation in EIA bulk electricity data.'),
    sa.Column('sector_agg', sa.Text(), nullable=False, comment='Category of sectoral aggregation in EIA bulk electricity data.'),
    sa.Column('temporal_agg', sa.Text(), nullable=False, comment='Category of temporal aggregation in EIA bulk electricity data.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('fuel_received_mmbtu', sa.Float(), nullable=True, comment='Aggregated fuel receipts, in MMBtu, in EIA bulk electricity data.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.PrimaryKeyConstraint('fuel_agg', 'geo_agg', 'sector_agg', 'temporal_agg', 'report_date', name=op.f('pk_core_eia__yearly_fuel_receipts_costs_aggs'))
    )
    op.create_table('core_eiaaeo__yearly_projected_electric_sales',
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('electricity_market_module_region_eiaaeo', sa.Enum('florida_reliability_coordinating_council', 'midcontinent_central', 'midcontinent_east', 'midcontinent_south', 'midcontinent_west', 'northeast_power_coordinating_council_new_england', 'northeast_power_coordinating_council_new_york_city_and_long_island', 'northeast_power_coordinating_council_upstate_new_york', 'pjm_commonwealth_edison', 'pjm_dominion', 'pjm_east', 'pjm_west', 'serc_reliability_corporation_central', 'serc_reliability_corporation_east', 'serc_reliability_corporation_southeastern', 'southwest_power_pool_central', 'southwest_power_pool_north', 'southwest_power_pool_south', 'texas_reliability_entity', 'united_states', 'western_electricity_coordinating_council_basin', 'western_electricity_coordinating_council_california_north', 'western_electricity_coordinating_council_california_south', 'western_electricity_coordinating_council_northwest_power_pool_area', 'western_electricity_coordinating_council_rockies', 'western_electricity_coordinating_council_southwest'), nullable=False, comment='AEO projection region.'),
    sa.Column('model_case_eiaaeo', sa.Enum('aeo2022', 'high_economic_growth', 'high_macro_and_high_zero_carbon_technology_cost', 'high_macro_and_low_zero_carbon_technology_cost', 'high_oil_and_gas_supply', 'high_oil_price', 'high_uptake_of_inflation_reduction_act', 'high_zero_carbon_technology_cost', 'low_economic_growth', 'low_macro_and_high_zero_carbon_technology_cost', 'low_macro_and_low_zero_carbon_technology_cost', 'low_oil_and_gas_supply', 'low_oil_price', 'low_uptake_of_inflation_reduction_act', 'low_zero_carbon_technology_cost', 'no_inflation_reduction_act', 'reference'), nullable=False, comment='Factors such as economic growth, future oil prices, the ultimate size of domestic energy resources, and technological change are often uncertain. To illustrate some of these uncertainties, EIA runs side cases to show how the model responds to changes in key input variables compared with the Reference case. See https://www.eia.gov/outlooks/aeo/assumptions/case_descriptions.php for more details.'),
    sa.Column('projection_year', sa.Integer(), nullable=False, comment='The year of the projected value.'),
    sa.Column('customer_class', sa.Enum('commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other'), nullable=False, comment="High level categorization of customer type: ['commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other']."),
    sa.Column('sales_mwh', sa.Float(), nullable=True, comment='Quantity of electricity sold in MWh.'),
    sa.PrimaryKeyConstraint('report_year', 'electricity_market_module_region_eiaaeo', 'model_case_eiaaeo', 'projection_year', 'customer_class', name=op.f('pk_core_eiaaeo__yearly_projected_electric_sales'))
    )
    op.create_table('core_eiaaeo__yearly_projected_fuel_cost_in_electric_sector_by_type',
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('electricity_market_module_region_eiaaeo', sa.Enum('florida_reliability_coordinating_council', 'midcontinent_central', 'midcontinent_east', 'midcontinent_south', 'midcontinent_west', 'northeast_power_coordinating_council_new_england', 'northeast_power_coordinating_council_new_york_city_and_long_island', 'northeast_power_coordinating_council_upstate_new_york', 'pjm_commonwealth_edison', 'pjm_dominion', 'pjm_east', 'pjm_west', 'serc_reliability_corporation_central', 'serc_reliability_corporation_east', 'serc_reliability_corporation_southeastern', 'southwest_power_pool_central', 'southwest_power_pool_north', 'southwest_power_pool_south', 'texas_reliability_entity', 'united_states', 'western_electricity_coordinating_council_basin', 'western_electricity_coordinating_council_california_north', 'western_electricity_coordinating_council_california_south', 'western_electricity_coordinating_council_northwest_power_pool_area', 'western_electricity_coordinating_council_rockies', 'western_electricity_coordinating_council_southwest'), nullable=False, comment='AEO projection region.'),
    sa.Column('model_case_eiaaeo', sa.Enum('aeo2022', 'high_economic_growth', 'high_macro_and_high_zero_carbon_technology_cost', 'high_macro_and_low_zero_carbon_technology_cost', 'high_oil_and_gas_supply', 'high_oil_price', 'high_uptake_of_inflation_reduction_act', 'high_zero_carbon_technology_cost', 'low_economic_growth', 'low_macro_and_high_zero_carbon_technology_cost', 'low_macro_and_low_zero_carbon_technology_cost', 'low_oil_and_gas_supply', 'low_oil_price', 'low_uptake_of_inflation_reduction_act', 'low_zero_carbon_technology_cost', 'no_inflation_reduction_act', 'reference'), nullable=False, comment='Factors such as economic growth, future oil prices, the ultimate size of domestic energy resources, and technological change are often uncertain. To illustrate some of these uncertainties, EIA runs side cases to show how the model responds to changes in key input variables compared with the Reference case. See https://www.eia.gov/outlooks/aeo/assumptions/case_descriptions.php for more details.'),
    sa.Column('projection_year', sa.Integer(), nullable=False, comment='The year of the projected value.'),
    sa.Column('fuel_type_eiaaeo', sa.Enum('coal', 'distillate_fuel_oil', 'residual_fuel_oil', 'petroleum', 'natural_gas', 'other_gaseous_fuels', 'renewable_sources', 'other'), nullable=False, comment='Fuel type reported for AEO end-use sector generation data.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('fuel_cost_real_per_mmbtu_eiaaeo', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in real USD, standardized to the value of a USD in the year defined by ``real_cost_basis_year``.'),
    sa.Column('real_cost_basis_year', sa.Integer(), nullable=True, comment="Four-digit year which is the basis for any 'real cost' monetary values (as opposed to nominal values)."),
    sa.PrimaryKeyConstraint('report_year', 'electricity_market_module_region_eiaaeo', 'model_case_eiaaeo', 'projection_year', 'fuel_type_eiaaeo', name=op.f('pk_core_eiaaeo__yearly_projected_fuel_cost_in_electric_sector_by_type'))
    )
    op.create_table('core_eiaaeo__yearly_projected_generation_in_electric_sector_by_technology',
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('electricity_market_module_region_eiaaeo', sa.Enum('florida_reliability_coordinating_council', 'midcontinent_central', 'midcontinent_east', 'midcontinent_south', 'midcontinent_west', 'northeast_power_coordinating_council_new_england', 'northeast_power_coordinating_council_new_york_city_and_long_island', 'northeast_power_coordinating_council_upstate_new_york', 'pjm_commonwealth_edison', 'pjm_dominion', 'pjm_east', 'pjm_west', 'serc_reliability_corporation_central', 'serc_reliability_corporation_east', 'serc_reliability_corporation_southeastern', 'southwest_power_pool_central', 'southwest_power_pool_north', 'southwest_power_pool_south', 'texas_reliability_entity', 'united_states', 'western_electricity_coordinating_council_basin', 'western_electricity_coordinating_council_california_north', 'western_electricity_coordinating_council_california_south', 'western_electricity_coordinating_council_northwest_power_pool_area', 'western_electricity_coordinating_council_rockies', 'western_electricity_coordinating_council_southwest'), nullable=False, comment='AEO projection region.'),
    sa.Column('model_case_eiaaeo', sa.Enum('aeo2022', 'high_economic_growth', 'high_macro_and_high_zero_carbon_technology_cost', 'high_macro_and_low_zero_carbon_technology_cost', 'high_oil_and_gas_supply', 'high_oil_price', 'high_uptake_of_inflation_reduction_act', 'high_zero_carbon_technology_cost', 'low_economic_growth', 'low_macro_and_high_zero_carbon_technology_cost', 'low_macro_and_low_zero_carbon_technology_cost', 'low_oil_and_gas_supply', 'low_oil_price', 'low_uptake_of_inflation_reduction_act', 'low_zero_carbon_technology_cost', 'no_inflation_reduction_act', 'reference'), nullable=False, comment='Factors such as economic growth, future oil prices, the ultimate size of domestic energy resources, and technological change are often uncertain. To illustrate some of these uncertainties, EIA runs side cases to show how the model responds to changes in key input variables compared with the Reference case. See https://www.eia.gov/outlooks/aeo/assumptions/case_descriptions.php for more details.'),
    sa.Column('projection_year', sa.Integer(), nullable=False, comment='The year of the projected value.'),
    sa.Column('technology_description_eiaaeo', sa.Enum('coal', 'combined_cycle', 'combustion_turbine_diesel', 'distributed_generation', 'diurnal_storage', 'fuel_cells', 'natural_gas', 'nuclear', 'oil_and_natural_gas_steam', 'petroleum', 'pumped_storage', 'pumped_storage_other', 'renewable_sources'), nullable=False, comment='Generation technology reported for AEO.'),
    sa.Column('summer_capacity_mw', sa.Float(), nullable=True, comment='The net summer capacity.'),
    sa.Column('summer_capacity_planned_additions_mw', sa.Float(), nullable=True, comment='The total planned additions to net summer generating capacity.'),
    sa.Column('summer_capacity_unplanned_additions_mw', sa.Float(), nullable=True, comment='The total unplanned additions to net summer generating capacity.'),
    sa.Column('summer_capacity_retirements_mw', sa.Float(), nullable=True, comment='The total retirements from net summer generating capacity.'),
    sa.Column('gross_generation_mwh', sa.Float(), nullable=True, comment='Gross electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.PrimaryKeyConstraint('report_year', 'electricity_market_module_region_eiaaeo', 'model_case_eiaaeo', 'projection_year', 'technology_description_eiaaeo', name=op.f('pk_core_eiaaeo__yearly_projected_generation_in_electric_sector_by_technology'))
    )
    op.create_table('core_eiaaeo__yearly_projected_generation_in_end_use_sectors_by_fuel_type',
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('electricity_market_module_region_eiaaeo', sa.Enum('florida_reliability_coordinating_council', 'midcontinent_central', 'midcontinent_east', 'midcontinent_south', 'midcontinent_west', 'northeast_power_coordinating_council_new_england', 'northeast_power_coordinating_council_new_york_city_and_long_island', 'northeast_power_coordinating_council_upstate_new_york', 'pjm_commonwealth_edison', 'pjm_dominion', 'pjm_east', 'pjm_west', 'serc_reliability_corporation_central', 'serc_reliability_corporation_east', 'serc_reliability_corporation_southeastern', 'southwest_power_pool_central', 'southwest_power_pool_north', 'southwest_power_pool_south', 'texas_reliability_entity', 'united_states', 'western_electricity_coordinating_council_basin', 'western_electricity_coordinating_council_california_north', 'western_electricity_coordinating_council_california_south', 'western_electricity_coordinating_council_northwest_power_pool_area', 'western_electricity_coordinating_council_rockies', 'western_electricity_coordinating_council_southwest'), nullable=False, comment='AEO projection region.'),
    sa.Column('model_case_eiaaeo', sa.Enum('aeo2022', 'high_economic_growth', 'high_macro_and_high_zero_carbon_technology_cost', 'high_macro_and_low_zero_carbon_technology_cost', 'high_oil_and_gas_supply', 'high_oil_price', 'high_uptake_of_inflation_reduction_act', 'high_zero_carbon_technology_cost', 'low_economic_growth', 'low_macro_and_high_zero_carbon_technology_cost', 'low_macro_and_low_zero_carbon_technology_cost', 'low_oil_and_gas_supply', 'low_oil_price', 'low_uptake_of_inflation_reduction_act', 'low_zero_carbon_technology_cost', 'no_inflation_reduction_act', 'reference'), nullable=False, comment='Factors such as economic growth, future oil prices, the ultimate size of domestic energy resources, and technological change are often uncertain. To illustrate some of these uncertainties, EIA runs side cases to show how the model responds to changes in key input variables compared with the Reference case. See https://www.eia.gov/outlooks/aeo/assumptions/case_descriptions.php for more details.'),
    sa.Column('projection_year', sa.Integer(), nullable=False, comment='The year of the projected value.'),
    sa.Column('fuel_type_eiaaeo', sa.Enum('coal', 'distillate_fuel_oil', 'residual_fuel_oil', 'petroleum', 'natural_gas', 'other_gaseous_fuels', 'renewable_sources', 'other'), nullable=False, comment='Fuel type reported for AEO end-use sector generation data.'),
    sa.Column('summer_capacity_mw', sa.Float(), nullable=True, comment='The net summer capacity.'),
    sa.Column('gross_generation_mwh', sa.Float(), nullable=True, comment='Gross electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.PrimaryKeyConstraint('report_year', 'electricity_market_module_region_eiaaeo', 'model_case_eiaaeo', 'projection_year', 'fuel_type_eiaaeo', name=op.f('pk_core_eiaaeo__yearly_projected_generation_in_end_use_sectors_by_fuel_type'))
    )
    op.create_table('core_epa__assn_eia_epacamd_subplant_ids',
    sa.Column('plant_id_eia', sa.Integer(), nullable=True, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_epa', sa.Integer(), nullable=True, comment='The ORISPL ID used by EPA to refer to the plant. Usually but not always the same as plant_id_eia.'),
    sa.Column('subplant_id', sa.Integer(), nullable=True, comment='Sub-plant ID links EPA CEMS emissions units to EIA units.'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('emissions_unit_id_epa', sa.Text(), nullable=True, comment='Emissions (smokestack) unit monitored by EPA CEMS.'),
    sa.Column('generator_id', sa.Text(), nullable=True, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!')
    )
    op.create_table('core_ferc1__codes_power_purchase_types',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('label', sa.Text(), nullable=True, comment='Longer human-readable code using snake_case'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_ferc1__codes_power_purchase_types'))
    )
    op.create_table('core_ferc714__respondent_id',
    sa.Column('respondent_id_ferc714', sa.Integer(), nullable=False, comment='FERC Form 714 respondent ID. Note that this ID does not correspond to FERC respondent IDs from other forms.'),
    sa.Column('respondent_name_ferc714', sa.Text(), nullable=True, comment='Name of the utility, balancing area authority, or planning authority responding to FERC Form 714.'),
    sa.Column('eia_code', sa.Integer(), nullable=True, comment='EIA utility or balancing area authority ID associated with this FERC Form 714 respondent. Note that many utilities are also balancing authorities and in many cases EIA uses the same integer ID to identify a utility in its role as a balancing authority AND as a utility, but there is no requirement that these IDs be the same, and in a number of cases they are different.'),
    sa.PrimaryKeyConstraint('respondent_id_ferc714', name=op.f('pk_core_ferc714__respondent_id'))
    )
    op.create_table('core_ferc__codes_accounts',
    sa.Column('ferc_account_id', sa.Text(), nullable=False, comment="Account identifier from FERC's Uniform System of Accounts for Electric Plant. Includes higher level labeled categories."),
    sa.Column('ferc_account_description', sa.Text(), nullable=True, comment='Description of the FERC account.'),
    sa.PrimaryKeyConstraint('ferc_account_id', name=op.f('pk_core_ferc__codes_accounts'))
    )
    op.create_table('core_nrelatb__yearly_projected_cost_performance',
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('model_case_nrelatb', sa.Enum('Market', 'R&D'), nullable=True, comment="NREL's financial assumption cases. There are two cases which effect project finanical assumptions: R&D Only Case and Market + Policies Case. R&D Only includes only projected R&D improvements while Market + Policy case includes policy and tax incentives. https://atb.nrel.gov/electricity/2024/financial_cases_&_methods"),
    sa.Column('model_tax_credit_case_nrelatb', sa.Enum('Market', 'R&D'), nullable=True, comment="NREL's tax credit assumption cases. There are two types of tax credits: production tax credit (PTC) and investment tax credit (ITC). For more detail, see: https://atb.nrel.gov/electricity/2024/financial_cases_&_methods"),
    sa.Column('projection_year', sa.Integer(), nullable=True, comment='The year of the projected value.'),
    sa.Column('technology_description', sa.Enum('CommPV', 'Pumped Storage Hydropower', 'Nuclear', 'Biopower', 'OffShoreWind', 'Coal_FE', 'LandbasedWind', 'Utility-Scale Battery Storage', 'DistributedWind', 'Hydropower', 'AEO', 'NaturalGas_FE', 'Residential Battery Storage', 'ResPV', 'Utility-Scale PV-Plus-Battery', 'Commercial Battery Storage', 'NaturalGas_Retrofits', 'Geothermal', 'UtilityPV', 'Coal_Retrofits', 'CSP'), nullable=True, comment='High level description of the technology used by the generator to produce electricity.'),
    sa.Column('cost_recovery_period_years', sa.Integer(), nullable=True, comment='The period over which the initial capital investment to build a plant is recovered.'),
    sa.Column('scenario_atb', sa.Enum('Advanced', 'Moderate', 'Conservative'), nullable=True, comment='Technology innovation scenarios. https://atb.nrel.gov/electricity/2023/definitions#scenarios'),
    sa.Column('technology_description_detail_1', sa.Text(), nullable=True, comment='Technology details indicate resource levels and specific technology subcategories.'),
    sa.Column('technology_description_detail_2', sa.Text(), nullable=True, comment='Technology details indicate resource levels and specific technology subcategories.'),
    sa.Column('capacity_factor', sa.Float(), nullable=True, comment='Fraction of potential generation that was actually reported for a plant part.'),
    sa.Column('capex_per_kw', sa.Float(), nullable=True, comment='Capital cost (USD). Expenditures required to achieve commercial operation of the generation plant.'),
    sa.Column('capex_overnight_per_kw', sa.Float(), nullable=True, comment='capex if plant could be constructed overnight (i.e., excludes construction period financing); includes on-site electrical equipment (e.g., switchyard), a nominal-distance spur line (<1 mi), and necessary upgrades at a transmission substation.'),
    sa.Column('capex_overnight_additional_per_kw', sa.Float(), nullable=True, comment='capex for retrofits if plant could be constructed overnight (i.e., excludes construction period financing); includes on-site electrical equipment (e.g., switchyard), a nominal-distance spur line (<1 mi), and necessary upgrades at a transmission substation.'),
    sa.Column('capex_grid_connection_per_kw', sa.Float(), nullable=True, comment='Overnight capital cost includes a nominal-distance spur line (<1 mi) for all technologies, and for offshore wind, it includes export cable and construction period transit costs for a 30-km distance from shore. Project-specific costs lines that are based on distance to existing transmission are not included. This only applies to offshore wind.'),
    sa.Column('capex_construction_finance_factor', sa.Float(), nullable=True, comment='Portion of all-in capital cost associated with construction period financing. This factor is applied to an overnight capital cost to represent the financing costs incurred during the construction period.'),
    sa.Column('fuel_cost_per_mwh', sa.Float(), nullable=True, comment='Fuel costs in USD$/MWh. NREL-derived values using heat rates.'),
    sa.Column('heat_rate_mmbtu_per_mwh', sa.Float(), nullable=True, comment='Fuel content per unit of electricity generated.'),
    sa.Column('heat_rate_penalty', sa.Float(), nullable=True, comment='Heat rate penalty for retrofitting. This column only has contents to retrofit technologies. It seems to be a rate between 0.35 and 0.09'),
    sa.Column('levelized_cost_of_energy_per_mwh', sa.Float(), nullable=True, comment='Levelized cost of energy (LCOE) is a summary metric that combines the primary technology cost and performance parameters: capital expenditures, operations expenditures, and capacity factor.'),
    sa.Column('net_output_penalty', sa.Float(), nullable=True, comment='Penalty for retrofitting for net output.  This column only has contents to retrofit technologies. It seems to be a rate between -0.25 and -0.08'),
    sa.Column('opex_fixed_per_kw', sa.Float(), nullable=True, comment='Fixed operation and maintenance expenses. Annual expenditures to operate and maintain equipment that are not incurred on a per-unit-energy basis.'),
    sa.Column('opex_variable_per_mwh', sa.Float(), nullable=True, comment='Operation and maintenance costs incurred on a per-unit-energy basis.')
    )
    op.create_table('core_nrelatb__yearly_projected_financial_cases',
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('model_case_nrelatb', sa.Enum('Market', 'R&D'), nullable=False, comment="NREL's financial assumption cases. There are two cases which effect project finanical assumptions: R&D Only Case and Market + Policies Case. R&D Only includes only projected R&D improvements while Market + Policy case includes policy and tax incentives. https://atb.nrel.gov/electricity/2024/financial_cases_&_methods"),
    sa.Column('projection_year', sa.Integer(), nullable=False, comment='The year of the projected value.'),
    sa.Column('technology_description', sa.Enum('CommPV', 'Pumped Storage Hydropower', 'Nuclear', 'Biopower', 'OffShoreWind', 'Coal_FE', 'LandbasedWind', 'Utility-Scale Battery Storage', 'DistributedWind', 'Hydropower', 'AEO', 'NaturalGas_FE', 'Residential Battery Storage', 'ResPV', 'Utility-Scale PV-Plus-Battery', 'Commercial Battery Storage', 'NaturalGas_Retrofits', 'Geothermal', 'UtilityPV', 'Coal_Retrofits', 'CSP'), nullable=False, comment='High level description of the technology used by the generator to produce electricity.'),
    sa.Column('inflation_rate', sa.Float(), nullable=True, comment='Rate of inflation. All dollar values are given in 2021 USD, using the Consumer Price Index for All Urban Consumers for dollar year conversions where the source year dollars do not match 2021.'),
    sa.Column('interest_rate_during_construction_nominal', sa.Float(), nullable=True, comment='Also referred to as construction finance cost. Portion of all-in capital cost associated with construction period financing. It is a function of construction duration, capital fraction during construction, and interest during construction.'),
    sa.Column('interest_rate_calculated_real', sa.Float(), nullable=True, comment='Calculated real interest rate.'),
    sa.Column('interest_rate_nominal', sa.Float(), nullable=True, comment='Nominal interest rate.'),
    sa.Column('rate_of_return_on_equity_calculated_real', sa.Float(), nullable=True, comment='Calculated real rate of return on equity.'),
    sa.Column('rate_of_return_on_equity_nominal', sa.Float(), nullable=True, comment='Nomial rate of return on equity.'),
    sa.Column('tax_rate_federal_state', sa.Float(), nullable=True, comment='Combined federal and state tax rate. The R&D model_case_nrelatb holds tax and inflation rates constant at assumed long-term values: 21 percent federal tax rate, 6 percent state tax rate (though actual state tax rates vary), and 2.5 percent inflation rate excludes effects of tax credits. The Market + Policy model_case_nrelatb applies federal tax credits and expires them as consistent with existing law and guidelines.'),
    sa.PrimaryKeyConstraint('report_year', 'model_case_nrelatb', 'projection_year', 'technology_description', name=op.f('pk_core_nrelatb__yearly_projected_financial_cases'))
    )
    op.create_table('core_nrelatb__yearly_projected_financial_cases_by_scenario',
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('model_case_nrelatb', sa.Enum('Market', 'R&D'), nullable=True, comment="NREL's financial assumption cases. There are two cases which effect project finanical assumptions: R&D Only Case and Market + Policies Case. R&D Only includes only projected R&D improvements while Market + Policy case includes policy and tax incentives. https://atb.nrel.gov/electricity/2024/financial_cases_&_methods"),
    sa.Column('model_tax_credit_case_nrelatb', sa.Enum('Market', 'R&D'), nullable=True, comment="NREL's tax credit assumption cases. There are two types of tax credits: production tax credit (PTC) and investment tax credit (ITC). For more detail, see: https://atb.nrel.gov/electricity/2024/financial_cases_&_methods"),
    sa.Column('projection_year', sa.Integer(), nullable=True, comment='The year of the projected value.'),
    sa.Column('technology_description', sa.Enum('CommPV', 'Pumped Storage Hydropower', 'Nuclear', 'Biopower', 'OffShoreWind', 'Coal_FE', 'LandbasedWind', 'Utility-Scale Battery Storage', 'DistributedWind', 'Hydropower', 'AEO', 'NaturalGas_FE', 'Residential Battery Storage', 'ResPV', 'Utility-Scale PV-Plus-Battery', 'Commercial Battery Storage', 'NaturalGas_Retrofits', 'Geothermal', 'UtilityPV', 'Coal_Retrofits', 'CSP'), nullable=True, comment='High level description of the technology used by the generator to produce electricity.'),
    sa.Column('scenario_atb', sa.Enum('Advanced', 'Moderate', 'Conservative'), nullable=True, comment='Technology innovation scenarios. https://atb.nrel.gov/electricity/2023/definitions#scenarios'),
    sa.Column('cost_recovery_period_years', sa.Integer(), nullable=True, comment='The period over which the initial capital investment to build a plant is recovered.'),
    sa.Column('capital_recovery_factor', sa.Float(), nullable=True, comment='Ratio of a constant annuity to the present value of receiving that annuity for a given length of time.'),
    sa.Column('debt_fraction', sa.Float(), nullable=True, comment='Fraction of capital financed with debt; Debt fraction is assumed financed with equity; also referred to as the leverage ratio.'),
    sa.Column('fixed_charge_rate', sa.Float(), nullable=True, comment='Amount of revenue per dollar of investment required that must be collected annually from customers to pay the carrying charges on that investment.'),
    sa.Column('wacc_nominal', sa.Float(), nullable=True, comment='Nominal weighted average cost of capital - average expected rate that is paid to finance assets.'),
    sa.Column('wacc_real', sa.Float(), nullable=True, comment='Real weighted average cost of capital - average expected rate that is paid to finance assets.')
    )
    op.create_table('core_nrelatb__yearly_technology_status',
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('technology_description', sa.Enum('CommPV', 'Pumped Storage Hydropower', 'Nuclear', 'Biopower', 'OffShoreWind', 'Coal_FE', 'LandbasedWind', 'Utility-Scale Battery Storage', 'DistributedWind', 'Hydropower', 'AEO', 'NaturalGas_FE', 'Residential Battery Storage', 'ResPV', 'Utility-Scale PV-Plus-Battery', 'Commercial Battery Storage', 'NaturalGas_Retrofits', 'Geothermal', 'UtilityPV', 'Coal_Retrofits', 'CSP'), nullable=True, comment='High level description of the technology used by the generator to produce electricity.'),
    sa.Column('technology_description_detail_1', sa.Text(), nullable=True, comment='Technology details indicate resource levels and specific technology subcategories.'),
    sa.Column('technology_description_detail_2', sa.Text(), nullable=True, comment='Technology details indicate resource levels and specific technology subcategories.'),
    sa.Column('is_technology_mature', sa.Boolean(), nullable=True, comment='Indicator of whether the technology is mature. Technologies are definedas mature if a representative plant is operating or under constructionin the United States in the Base Year.'),
    sa.Column('is_default', sa.Boolean(), nullable=True, comment='Indicator of whether the technology is default.')
    )
    op.create_table('core_pudl__codes_data_maturities',
    sa.Column('code', sa.Text(), nullable=False, comment='Originally reported short code.'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.PrimaryKeyConstraint('code', name=op.f('pk_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_pudl__codes_datasources',
    sa.Column('datasource', sa.Enum('censusdp1tract', 'eia176', 'eia191', 'eia757a', 'eia860', 'eia860m', 'eia861', 'eia923', 'eia930', 'eiaaeo', 'eia_bulk_elec', 'eiawater', 'epacems', 'epacamd_eia', 'ferc1', 'ferc2', 'ferc6', 'ferc60', 'ferc714', 'ferceqr', 'gridpathratoolkit', 'mshamines', 'nrelatb', 'phmsagas', 'pudl', 'sec10k'), nullable=False, comment='Code identifying a dataset available within PUDL.'),
    sa.Column('partitions', sa.Text(), nullable=True, comment='The data parititions used to generate this instance of the database.'),
    sa.Column('doi', sa.Text(), nullable=True, comment='Unique digitial object identifier of Zenodo archive.'),
    sa.Column('pudl_version', sa.Text(), nullable=True, comment='The version of PUDL used to generate this database.'),
    sa.PrimaryKeyConstraint('datasource', name=op.f('pk_core_pudl__codes_datasources'))
    )
    op.create_table('core_pudl__codes_subdivisions',
    sa.Column('country_code', sa.Enum('CAN', 'USA'), nullable=False, comment='Three letter ISO-3166 country code (e.g. USA or CAN).'),
    sa.Column('country_name', sa.Text(), nullable=True, comment='Full country name (e.g. United States of America).'),
    sa.Column('subdivision_code', sa.Enum('SD', 'KS', 'ND', 'AK', 'CT', 'AS', 'MA', 'MD', 'PA', 'FL', 'QC', 'IA', 'MP', 'HI', 'MT', 'IL', 'WI', 'LA', 'NU', 'NB', 'MI', 'NS', 'PE', 'CA', 'OK', 'NJ', 'ME', 'UT', 'GU', 'GA', 'NV', 'WV', 'MS', 'NL', 'WA', 'MO', 'KY', 'AL', 'SC', 'VI', 'WY', 'DC', 'VA', 'IN', 'NC', 'NE', 'NT', 'RI', 'TX', 'SK', 'NY', 'PR', 'NH', 'VT', 'CO', 'MN', 'AZ', 'ID', 'YT', 'MB', 'NM', 'TN', 'DE', 'BC', 'OR', 'AR', 'AB', 'ON', 'OH'), nullable=False, comment='Two-letter ISO-3166 political subdivision code (e.g. US state or Canadian provice abbreviations like CA or AB).'),
    sa.Column('subdivision_name', sa.Text(), nullable=True, comment='Full name of political subdivision (e.g. US state or Canadian province names like California or Alberta.'),
    sa.Column('subdivision_type', sa.Text(), nullable=True, comment='ISO-3166 political subdivision type. E.g. state, province, outlying_area.'),
    sa.Column('timezone_approx', sa.Enum('Africa/Abidjan', 'Africa/Accra', 'Africa/Addis_Ababa', 'Africa/Algiers', 'Africa/Asmara', 'Africa/Asmera', 'Africa/Bamako', 'Africa/Bangui', 'Africa/Banjul', 'Africa/Bissau', 'Africa/Blantyre', 'Africa/Brazzaville', 'Africa/Bujumbura', 'Africa/Cairo', 'Africa/Casablanca', 'Africa/Ceuta', 'Africa/Conakry', 'Africa/Dakar', 'Africa/Dar_es_Salaam', 'Africa/Djibouti', 'Africa/Douala', 'Africa/El_Aaiun', 'Africa/Freetown', 'Africa/Gaborone', 'Africa/Harare', 'Africa/Johannesburg', 'Africa/Juba', 'Africa/Kampala', 'Africa/Khartoum', 'Africa/Kigali', 'Africa/Kinshasa', 'Africa/Lagos', 'Africa/Libreville', 'Africa/Lome', 'Africa/Luanda', 'Africa/Lubumbashi', 'Africa/Lusaka', 'Africa/Malabo', 'Africa/Maputo', 'Africa/Maseru', 'Africa/Mbabane', 'Africa/Mogadishu', 'Africa/Monrovia', 'Africa/Nairobi', 'Africa/Ndjamena', 'Africa/Niamey', 'Africa/Nouakchott', 'Africa/Ouagadougou', 'Africa/Porto-Novo', 'Africa/Sao_Tome', 'Africa/Timbuktu', 'Africa/Tripoli', 'Africa/Tunis', 'Africa/Windhoek', 'America/Adak', 'America/Anchorage', 'America/Anguilla', 'America/Antigua', 'America/Araguaina', 'America/Argentina/Buenos_Aires', 'America/Argentina/Catamarca', 'America/Argentina/ComodRivadavia', 'America/Argentina/Cordoba', 'America/Argentina/Jujuy', 'America/Argentina/La_Rioja', 'America/Argentina/Mendoza', 'America/Argentina/Rio_Gallegos', 'America/Argentina/Salta', 'America/Argentina/San_Juan', 'America/Argentina/San_Luis', 'America/Argentina/Tucuman', 'America/Argentina/Ushuaia', 'America/Aruba', 'America/Asuncion', 'America/Atikokan', 'America/Atka', 'America/Bahia', 'America/Bahia_Banderas', 'America/Barbados', 'America/Belem', 'America/Belize', 'America/Blanc-Sablon', 'America/Boa_Vista', 'America/Bogota', 'America/Boise', 'America/Buenos_Aires', 'America/Cambridge_Bay', 'America/Campo_Grande', 'America/Cancun', 'America/Caracas', 'America/Catamarca', 'America/Cayenne', 'America/Cayman', 'America/Chicago', 'America/Chihuahua', 'America/Ciudad_Juarez', 'America/Coral_Harbour', 'America/Cordoba', 'America/Costa_Rica', 'America/Creston', 'America/Cuiaba', 'America/Curacao', 'America/Danmarkshavn', 'America/Dawson', 'America/Dawson_Creek', 'America/Denver', 'America/Detroit', 'America/Dominica', 'America/Edmonton', 'America/Eirunepe', 'America/El_Salvador', 'America/Ensenada', 'America/Fort_Nelson', 'America/Fort_Wayne', 'America/Fortaleza', 'America/Glace_Bay', 'America/Godthab', 'America/Goose_Bay', 'America/Grand_Turk', 'America/Grenada', 'America/Guadeloupe', 'America/Guatemala', 'America/Guayaquil', 'America/Guyana', 'America/Halifax', 'America/Havana', 'America/Hermosillo', 'America/Indiana/Indianapolis', 'America/Indiana/Knox', 'America/Indiana/Marengo', 'America/Indiana/Petersburg', 'America/Indiana/Tell_City', 'America/Indiana/Vevay', 'America/Indiana/Vincennes', 'America/Indiana/Winamac', 'America/Indianapolis', 'America/Inuvik', 'America/Iqaluit', 'America/Jamaica', 'America/Jujuy', 'America/Juneau', 'America/Kentucky/Louisville', 'America/Kentucky/Monticello', 'America/Knox_IN', 'America/Kralendijk', 'America/La_Paz', 'America/Lima', 'America/Los_Angeles', 'America/Louisville', 'America/Lower_Princes', 'America/Maceio', 'America/Managua', 'America/Manaus', 'America/Marigot', 'America/Martinique', 'America/Matamoros', 'America/Mazatlan', 'America/Mendoza', 'America/Menominee', 'America/Merida', 'America/Metlakatla', 'America/Mexico_City', 'America/Miquelon', 'America/Moncton', 'America/Monterrey', 'America/Montevideo', 'America/Montreal', 'America/Montserrat', 'America/Nassau', 'America/New_York', 'America/Nipigon', 'America/Nome', 'America/Noronha', 'America/North_Dakota/Beulah', 'America/North_Dakota/Center', 'America/North_Dakota/New_Salem', 'America/Nuuk', 'America/Ojinaga', 'America/Panama', 'America/Pangnirtung', 'America/Paramaribo', 'America/Phoenix', 'America/Port-au-Prince', 'America/Port_of_Spain', 'America/Porto_Acre', 'America/Porto_Velho', 'America/Puerto_Rico', 'America/Punta_Arenas', 'America/Rainy_River', 'America/Rankin_Inlet', 'America/Recife', 'America/Regina', 'America/Resolute', 'America/Rio_Branco', 'America/Rosario', 'America/Santa_Isabel', 'America/Santarem', 'America/Santiago', 'America/Santo_Domingo', 'America/Sao_Paulo', 'America/Scoresbysund', 'America/Shiprock', 'America/Sitka', 'America/St_Barthelemy', 'America/St_Johns', 'America/St_Kitts', 'America/St_Lucia', 'America/St_Thomas', 'America/St_Vincent', 'America/Swift_Current', 'America/Tegucigalpa', 'America/Thule', 'America/Thunder_Bay', 'America/Tijuana', 'America/Toronto', 'America/Tortola', 'America/Vancouver', 'America/Virgin', 'America/Whitehorse', 'America/Winnipeg', 'America/Yakutat', 'America/Yellowknife', 'Antarctica/Casey', 'Antarctica/Davis', 'Antarctica/DumontDUrville', 'Antarctica/Macquarie', 'Antarctica/Mawson', 'Antarctica/McMurdo', 'Antarctica/Palmer', 'Antarctica/Rothera', 'Antarctica/South_Pole', 'Antarctica/Syowa', 'Antarctica/Troll', 'Antarctica/Vostok', 'Arctic/Longyearbyen', 'Asia/Aden', 'Asia/Almaty', 'Asia/Amman', 'Asia/Anadyr', 'Asia/Aqtau', 'Asia/Aqtobe', 'Asia/Ashgabat', 'Asia/Ashkhabad', 'Asia/Atyrau', 'Asia/Baghdad', 'Asia/Bahrain', 'Asia/Baku', 'Asia/Bangkok', 'Asia/Barnaul', 'Asia/Beirut', 'Asia/Bishkek', 'Asia/Brunei', 'Asia/Calcutta', 'Asia/Chita', 'Asia/Choibalsan', 'Asia/Chongqing', 'Asia/Chungking', 'Asia/Colombo', 'Asia/Dacca', 'Asia/Damascus', 'Asia/Dhaka', 'Asia/Dili', 'Asia/Dubai', 'Asia/Dushanbe', 'Asia/Famagusta', 'Asia/Gaza', 'Asia/Harbin', 'Asia/Hebron', 'Asia/Ho_Chi_Minh', 'Asia/Hong_Kong', 'Asia/Hovd', 'Asia/Irkutsk', 'Asia/Istanbul', 'Asia/Jakarta', 'Asia/Jayapura', 'Asia/Jerusalem', 'Asia/Kabul', 'Asia/Kamchatka', 'Asia/Karachi', 'Asia/Kashgar', 'Asia/Kathmandu', 'Asia/Katmandu', 'Asia/Khandyga', 'Asia/Kolkata', 'Asia/Krasnoyarsk', 'Asia/Kuala_Lumpur', 'Asia/Kuching', 'Asia/Kuwait', 'Asia/Macao', 'Asia/Macau', 'Asia/Magadan', 'Asia/Makassar', 'Asia/Manila', 'Asia/Muscat', 'Asia/Nicosia', 'Asia/Novokuznetsk', 'Asia/Novosibirsk', 'Asia/Omsk', 'Asia/Oral', 'Asia/Phnom_Penh', 'Asia/Pontianak', 'Asia/Pyongyang', 'Asia/Qatar', 'Asia/Qostanay', 'Asia/Qyzylorda', 'Asia/Rangoon', 'Asia/Riyadh', 'Asia/Saigon', 'Asia/Sakhalin', 'Asia/Samarkand', 'Asia/Seoul', 'Asia/Shanghai', 'Asia/Singapore', 'Asia/Srednekolymsk', 'Asia/Taipei', 'Asia/Tashkent', 'Asia/Tbilisi', 'Asia/Tehran', 'Asia/Tel_Aviv', 'Asia/Thimbu', 'Asia/Thimphu', 'Asia/Tokyo', 'Asia/Tomsk', 'Asia/Ujung_Pandang', 'Asia/Ulaanbaatar', 'Asia/Ulan_Bator', 'Asia/Urumqi', 'Asia/Ust-Nera', 'Asia/Vientiane', 'Asia/Vladivostok', 'Asia/Yakutsk', 'Asia/Yangon', 'Asia/Yekaterinburg', 'Asia/Yerevan', 'Atlantic/Azores', 'Atlantic/Bermuda', 'Atlantic/Canary', 'Atlantic/Cape_Verde', 'Atlantic/Faeroe', 'Atlantic/Faroe', 'Atlantic/Jan_Mayen', 'Atlantic/Madeira', 'Atlantic/Reykjavik', 'Atlantic/South_Georgia', 'Atlantic/St_Helena', 'Atlantic/Stanley', 'Australia/ACT', 'Australia/Adelaide', 'Australia/Brisbane', 'Australia/Broken_Hill', 'Australia/Canberra', 'Australia/Currie', 'Australia/Darwin', 'Australia/Eucla', 'Australia/Hobart', 'Australia/LHI', 'Australia/Lindeman', 'Australia/Lord_Howe', 'Australia/Melbourne', 'Australia/NSW', 'Australia/North', 'Australia/Perth', 'Australia/Queensland', 'Australia/South', 'Australia/Sydney', 'Australia/Tasmania', 'Australia/Victoria', 'Australia/West', 'Australia/Yancowinna', 'Brazil/Acre', 'Brazil/DeNoronha', 'Brazil/East', 'Brazil/West', 'CET', 'CST6CDT', 'Canada/Atlantic', 'Canada/Central', 'Canada/Eastern', 'Canada/Mountain', 'Canada/Newfoundland', 'Canada/Pacific', 'Canada/Saskatchewan', 'Canada/Yukon', 'Chile/Continental', 'Chile/EasterIsland', 'Cuba', 'EET', 'EST', 'EST5EDT', 'Egypt', 'Eire', 'Etc/GMT', 'Etc/GMT+0', 'Etc/GMT+1', 'Etc/GMT+10', 'Etc/GMT+11', 'Etc/GMT+12', 'Etc/GMT+2', 'Etc/GMT+3', 'Etc/GMT+4', 'Etc/GMT+5', 'Etc/GMT+6', 'Etc/GMT+7', 'Etc/GMT+8', 'Etc/GMT+9', 'Etc/GMT-0', 'Etc/GMT-1', 'Etc/GMT-10', 'Etc/GMT-11', 'Etc/GMT-12', 'Etc/GMT-13', 'Etc/GMT-14', 'Etc/GMT-2', 'Etc/GMT-3', 'Etc/GMT-4', 'Etc/GMT-5', 'Etc/GMT-6', 'Etc/GMT-7', 'Etc/GMT-8', 'Etc/GMT-9', 'Etc/GMT0', 'Etc/Greenwich', 'Etc/UCT', 'Etc/UTC', 'Etc/Universal', 'Etc/Zulu', 'Europe/Amsterdam', 'Europe/Andorra', 'Europe/Astrakhan', 'Europe/Athens', 'Europe/Belfast', 'Europe/Belgrade', 'Europe/Berlin', 'Europe/Bratislava', 'Europe/Brussels', 'Europe/Bucharest', 'Europe/Budapest', 'Europe/Busingen', 'Europe/Chisinau', 'Europe/Copenhagen', 'Europe/Dublin', 'Europe/Gibraltar', 'Europe/Guernsey', 'Europe/Helsinki', 'Europe/Isle_of_Man', 'Europe/Istanbul', 'Europe/Jersey', 'Europe/Kaliningrad', 'Europe/Kiev', 'Europe/Kirov', 'Europe/Kyiv', 'Europe/Lisbon', 'Europe/Ljubljana', 'Europe/London', 'Europe/Luxembourg', 'Europe/Madrid', 'Europe/Malta', 'Europe/Mariehamn', 'Europe/Minsk', 'Europe/Monaco', 'Europe/Moscow', 'Europe/Nicosia', 'Europe/Oslo', 'Europe/Paris', 'Europe/Podgorica', 'Europe/Prague', 'Europe/Riga', 'Europe/Rome', 'Europe/Samara', 'Europe/San_Marino', 'Europe/Sarajevo', 'Europe/Saratov', 'Europe/Simferopol', 'Europe/Skopje', 'Europe/Sofia', 'Europe/Stockholm', 'Europe/Tallinn', 'Europe/Tirane', 'Europe/Tiraspol', 'Europe/Ulyanovsk', 'Europe/Uzhgorod', 'Europe/Vaduz', 'Europe/Vatican', 'Europe/Vienna', 'Europe/Vilnius', 'Europe/Volgograd', 'Europe/Warsaw', 'Europe/Zagreb', 'Europe/Zaporozhye', 'Europe/Zurich', 'GB', 'GB-Eire', 'GMT', 'GMT+0', 'GMT-0', 'GMT0', 'Greenwich', 'HST', 'Hongkong', 'Iceland', 'Indian/Antananarivo', 'Indian/Chagos', 'Indian/Christmas', 'Indian/Cocos', 'Indian/Comoro', 'Indian/Kerguelen', 'Indian/Mahe', 'Indian/Maldives', 'Indian/Mauritius', 'Indian/Mayotte', 'Indian/Reunion', 'Iran', 'Israel', 'Jamaica', 'Japan', 'Kwajalein', 'Libya', 'MET', 'MST', 'MST7MDT', 'Mexico/BajaNorte', 'Mexico/BajaSur', 'Mexico/General', 'NZ', 'NZ-CHAT', 'Navajo', 'PRC', 'PST8PDT', 'Pacific/Apia', 'Pacific/Auckland', 'Pacific/Bougainville', 'Pacific/Chatham', 'Pacific/Chuuk', 'Pacific/Easter', 'Pacific/Efate', 'Pacific/Enderbury', 'Pacific/Fakaofo', 'Pacific/Fiji', 'Pacific/Funafuti', 'Pacific/Galapagos', 'Pacific/Gambier', 'Pacific/Guadalcanal', 'Pacific/Guam', 'Pacific/Honolulu', 'Pacific/Johnston', 'Pacific/Kanton', 'Pacific/Kiritimati', 'Pacific/Kosrae', 'Pacific/Kwajalein', 'Pacific/Majuro', 'Pacific/Marquesas', 'Pacific/Midway', 'Pacific/Nauru', 'Pacific/Niue', 'Pacific/Norfolk', 'Pacific/Noumea', 'Pacific/Pago_Pago', 'Pacific/Palau', 'Pacific/Pitcairn', 'Pacific/Pohnpei', 'Pacific/Ponape', 'Pacific/Port_Moresby', 'Pacific/Rarotonga', 'Pacific/Saipan', 'Pacific/Samoa', 'Pacific/Tahiti', 'Pacific/Tarawa', 'Pacific/Tongatapu', 'Pacific/Truk', 'Pacific/Wake', 'Pacific/Wallis', 'Pacific/Yap', 'Poland', 'Portugal', 'ROC', 'ROK', 'Singapore', 'Turkey', 'UCT', 'US/Alaska', 'US/Aleutian', 'US/Arizona', 'US/Central', 'US/East-Indiana', 'US/Eastern', 'US/Hawaii', 'US/Indiana-Starke', 'US/Michigan', 'US/Mountain', 'US/Pacific', 'US/Samoa', 'UTC', 'Universal', 'W-SU', 'WET', 'Zulu'), nullable=True, comment='IANA timezone name of the timezone which encompasses the largest portion of the population in the associated geographic area.'),
    sa.Column('state_id_fips', sa.Text(), nullable=True, comment='Two digit state FIPS code.'),
    sa.Column('division_name_us_census', sa.Text(), nullable=True, comment='Longer human readable name describing the US Census division.'),
    sa.Column('division_code_us_census', sa.Enum('WSC', 'NEW', 'MTN', 'MAT', 'PCN', 'SAT', 'ESC', 'PCC', 'WNC', 'ENC'), nullable=True, comment='Three-letter US Census division code as it appears in the bulk electricity data published by the EIA. Note that EIA splits the Pacific division into distinct contiguous (CA, OR, WA) and non-contiguous (AK, HI) states. For reference see this US Census region and division map: https://www2.census.gov/geo/pdfs/maps-data/maps/reference/us_regdiv.pdf'),
    sa.Column('region_name_us_census', sa.Text(), nullable=True, comment='Human-readable name of a US Census region.'),
    sa.Column('is_epacems_state', sa.Boolean(), nullable=True, comment="Indicates whether the associated state reports data within the EPA's Continuous Emissions Monitoring System."),
    sa.PrimaryKeyConstraint('country_code', 'subdivision_code', name=op.f('pk_core_pudl__codes_subdivisions'))
    )
    op.create_table('core_pudl__entity_plants_pudl',
    sa.Column('plant_id_pudl', sa.Integer(), nullable=False, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_pudl', sa.Text(), nullable=True, comment='Plant name, chosen arbitrarily from the several possible plant names available in the plant matching process. Included for human readability only.'),
    sa.PrimaryKeyConstraint('plant_id_pudl', name=op.f('pk_core_pudl__entity_plants_pudl'))
    )
    op.create_table('core_pudl__entity_utilities_pudl',
    sa.Column('utility_id_pudl', sa.Integer(), nullable=False, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_pudl', sa.Text(), nullable=True, comment='Utility name, chosen arbitrarily from the several possible utility names available in the utility matching process. Included for human readability only.'),
    sa.PrimaryKeyConstraint('utility_id_pudl', name=op.f('pk_core_pudl__entity_utilities_pudl'))
    )
    op.create_table('out_eia861__yearly_balancing_authority_service_territory',
    sa.Column('county_id_fips', sa.Text(), nullable=False, comment='County ID from the Federal Information Processing Standard Publication 6-4.'),
    sa.Column('county_name_census', sa.Text(), nullable=True, comment='County name as specified in Census DP1 Data.'),
    sa.Column('population', sa.Float(), nullable=True, comment='County population, sourced from Census DP1 data.'),
    sa.Column('area_km2', sa.Float(), nullable=True, comment='County area in km2.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('balancing_authority_id_eia', sa.Integer(), nullable=False, comment='EIA balancing authority ID. This is often (but not always!) the same as the utility ID associated with the same legal entity.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('county', sa.Text(), nullable=False, comment='County name.'),
    sa.Column('state_id_fips', sa.Text(), nullable=True, comment='Two digit state FIPS code.'),
    sa.PrimaryKeyConstraint('balancing_authority_id_eia', 'report_date', 'county_id_fips', 'county', name=op.f('pk_out_eia861__yearly_balancing_authority_service_territory'))
    )
    op.create_table('out_eia861__yearly_utility_service_territory',
    sa.Column('county_id_fips', sa.Text(), nullable=False, comment='County ID from the Federal Information Processing Standard Publication 6-4.'),
    sa.Column('county_name_census', sa.Text(), nullable=True, comment='County name as specified in Census DP1 Data.'),
    sa.Column('population', sa.Float(), nullable=True, comment='County population, sourced from Census DP1 data.'),
    sa.Column('area_km2', sa.Float(), nullable=True, comment='County area in km2.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('county', sa.Text(), nullable=True, comment='County name.'),
    sa.Column('state_id_fips', sa.Text(), nullable=True, comment='Two digit state FIPS code.'),
    sa.PrimaryKeyConstraint('utility_id_eia', 'report_date', 'county_id_fips', name=op.f('pk_out_eia861__yearly_utility_service_territory'))
    )
    op.create_table('_core_eia923__cooling_system_information',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('cooling_id_eia', sa.Text(), nullable=False, comment="EIA Identification code for cooling system (if multiple cooling systems are not distinguished by separate IDs, the word 'PLANT' is listed to encompass the cooling system for the entire plant)"),
    sa.Column('cooling_status_code', sa.Text(), nullable=True, comment='Operating status of cooling system'),
    sa.Column('cooling_type', sa.Text(), nullable=True, comment='Type of cooling system'),
    sa.Column('monthly_total_cooling_hours_in_service', sa.Integer(), nullable=True, comment='Total hours the system operated during the month'),
    sa.Column('flow_rate_method', sa.Text(), nullable=True, comment='Calculation method for flow rates (actual or method of estimation)'),
    sa.Column('temperature_method', sa.Text(), nullable=True, comment='Method for measurement of temperatures'),
    sa.Column('annual_maximum_intake_summer_temperature_fahrenheit', sa.Float(), nullable=True, comment='Maximum cooling water temperature at intake during the summer'),
    sa.Column('annual_maximum_intake_winter_temperature_fahrenheit', sa.Float(), nullable=True, comment='Maximum cooling water temperature at intake in winter'),
    sa.Column('monthly_average_intake_temperature_fahrenheit', sa.Float(), nullable=True, comment='Average cooling water temperature at intake point'),
    sa.Column('monthly_maximum_intake_temperature_fahrenheit', sa.Float(), nullable=True, comment='Maximum cooling water temperature at intake'),
    sa.Column('annual_maximum_outlet_summer_temperature_fahrenheit', sa.Float(), nullable=True, comment='Maximum cooling water temperature at outlet in summer'),
    sa.Column('annual_maximum_outlet_winter_temperature_fahrenheit', sa.Float(), nullable=True, comment='Maximum cooling water temperature at outlet in winter'),
    sa.Column('monthly_average_discharge_temperature_fahrenheit', sa.Float(), nullable=True, comment='Average cooling water temperature at discharge point'),
    sa.Column('monthly_maximum_discharge_temperature_fahrenheit', sa.Float(), nullable=True, comment='Maximum cooling water temperature at discharge'),
    sa.Column('annual_average_consumption_rate_gallons_per_minute', sa.Float(), nullable=True, comment='Annual average consumption rate of cooling water'),
    sa.Column('monthly_average_consumption_rate_gallons_per_minute', sa.Float(), nullable=True, comment='Monthly average consumption rate of cooling water'),
    sa.Column('monthly_total_consumption_volume_gallons', sa.Float(), nullable=True, comment='Monthly volume of water consumed at consumption point (accurate to 0.1 million gal)'),
    sa.Column('annual_average_discharge_rate_gallons_per_minute', sa.Float(), nullable=True, comment='Annual average discharge rate of cooling water'),
    sa.Column('monthly_average_discharge_rate_gallons_per_minute', sa.Float(), nullable=True, comment='Monthly average discharge rate of cooling water'),
    sa.Column('monthly_total_discharge_volume_gallons', sa.Float(), nullable=True, comment='Monthly volume of water discharged at discharge point (accurate to 0.1 million gal)'),
    sa.Column('monthly_average_diversion_rate_gallons_per_minute', sa.Float(), nullable=True, comment='Monthly average diversion rate of cooling water'),
    sa.Column('monthly_total_diversion_volume_gallons', sa.Float(), nullable=True, comment='Monthly volume of water diverted at diversion point (accurate to 0.1 million gal)'),
    sa.Column('annual_average_withdrawal_rate_gallons_per_minute', sa.Float(), nullable=True, comment='Annual average withdrawal rate of cooling water'),
    sa.Column('monthly_average_withdrawal_rate_gallons_per_minute', sa.Float(), nullable=True, comment='Monthly average withdrawal rate of cooling water'),
    sa.Column('monthly_total_withdrawal_volume_gallons', sa.Float(), nullable=True, comment='Monthly volume of water withdrawn at withdrawal point (accurate to 0.1 million gal)'),
    sa.Column('annual_total_chlorine_lbs', sa.Float(), nullable=True, comment='Amount of elemental chlorine added to cooling water annually. May be just the amount of chlorine-containing compound if schedule 9 is filled out.'),
    sa.Column('monthly_total_chlorine_lbs', sa.Float(), nullable=True, comment='Amount of elemental chlorine added to cooling water monthly. May be just the amount of chlorine-containing compound if schedule 9 is filled out.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['cooling_status_code'], ['core_eia__codes_operational_status.code'], name=op.f('fk__core_eia923__cooling_system_information_cooling_status_code_core_eia__codes_operational_status')),
    sa.ForeignKeyConstraint(['cooling_type'], ['core_eia__codes_cooling_system_types.code'], name=op.f('fk__core_eia923__cooling_system_information_cooling_type_core_eia__codes_cooling_system_types')),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk__core_eia923__cooling_system_information_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk__core_eia923__cooling_system_information_plant_id_eia_core_eia__entity_plants')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_date', 'cooling_id_eia', name=op.f('pk__core_eia923__cooling_system_information'))
    )
    op.create_table('_core_eia923__fgd_operation_maintenance',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('so2_control_id_eia', sa.Text(), nullable=False, comment='Sulfur dioxide control identification number. This ID is not a unique identifier.'),
    sa.Column('opex_fgd_feed_materials_chemical', sa.Integer(), nullable=True, comment='Annual operation and maintenance expenditures for feed materials and chemicals for flue gas desulfurization equipment, excluding electricity.'),
    sa.Column('opex_fgd_labor_supervision', sa.Integer(), nullable=True, comment='Annual operation and maintenance expenditures for labor and supervision of flue gas desulfurization equipment, excluding electricity.'),
    sa.Column('opex_fgd_land_acquisition', sa.Integer(), nullable=True, comment='Annual operation and maintenance expenditures for land acquisition for flue gas desulfurization equipment, excluding electricity.'),
    sa.Column('opex_fgd_maintenance_material_other', sa.Integer(), nullable=True, comment='Annual operation and maintenance expenditures for maintenance, materials and all other costs of flue gas desulfurization equipment, excluding electricity'),
    sa.Column('opex_fgd_waste_disposal', sa.Integer(), nullable=True, comment='Annual operation and maintenance expenditures for waste disposal, excluding electricity.'),
    sa.Column('opex_fgd_total_cost', sa.Integer(), nullable=True, comment='Annual total cost of operation and maintenance expenditures on flue gas desulfurization equipment, excluding electricity'),
    sa.Column('fgd_control_flag', sa.Boolean(), nullable=True, comment='Indicates whether or not a plant has a flue gas desulfurization control unit.'),
    sa.Column('fgd_operational_status_code', sa.Text(), nullable=True, comment='Operating status code for flue gas desulfurization equipment.'),
    sa.Column('fgd_hours_in_service', sa.Integer(), nullable=True, comment='Number of hours the flue gas desulfurization equipment was in operation during the year.'),
    sa.Column('fgd_electricity_consumption_mwh', sa.Float(), nullable=True, comment='Electric power consumed by the flue gas desulfurization unit (in MWh).'),
    sa.Column('fgd_sorbent_consumption_1000_tons', sa.Float(), nullable=True, comment='Quantity of flue gas desulfurization sorbent used, to the nearest 0.1 thousand tons.'),
    sa.Column('so2_removal_efficiency_tested', sa.Float(), nullable=True, comment='Removal efficiency for sulfur dioxide (to the nearest 0.1 percent by weight) at tested rate at 100 percent load.'),
    sa.Column('so2_removal_efficiency_annual', sa.Float(), nullable=True, comment='Removal efficiency for sulfur dioxide (to the nearest 0.1 percent by weight) based on designed firing rate and hours in operation (listed as a percentage).'),
    sa.Column('so2_test_date', sa.Date(), nullable=True, comment='Date of most recent test for sulfur dioxide removal efficiency.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk__core_eia923__fgd_operation_maintenance_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['fgd_operational_status_code'], ['core_eia__codes_operational_status.code'], name=op.f('fk__core_eia923__fgd_operation_maintenance_fgd_operational_status_code_core_eia__codes_operational_status')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk__core_eia923__fgd_operation_maintenance_plant_id_eia_core_eia__entity_plants')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_date', 'so2_control_id_eia', name=op.f('pk__core_eia923__fgd_operation_maintenance'))
    )
    op.create_table('_out_eia__monthly_heat_rate_by_unit',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=False, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('fuel_consumed_for_electricity_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel to produce electricity, in physical unit, year to date.'),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.Float(), nullable=True, comment='Fuel content per unit of electricity generated. Coming from MCOE calculation.'),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk__out_eia__monthly_heat_rate_by_unit_plant_id_eia_core_eia__entity_plants')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'unit_id_pudl', name=op.f('pk__out_eia__monthly_heat_rate_by_unit'))
    )
    op.create_table('core_eia860__scd_emissions_control_equipment',
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('emission_control_id_pudl', sa.Float(), nullable=False, comment='A PUDL-generated ID used to distinguish emission control units in the same report year and plant id. This ID should not be used to track units over time or between plants.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.Column('emission_control_equipment_type_code', sa.Text(), nullable=True, comment='Short code indicating the type of emission control equipment installed.'),
    sa.Column('operational_status_code', sa.Text(), nullable=True, comment='The operating status of the asset.'),
    sa.Column('mercury_control_id_eia', sa.Text(), nullable=True, comment='Mercury control identification number. This ID is not a unique identifier.'),
    sa.Column('nox_control_id_eia', sa.Text(), nullable=True, comment='Nitrogen oxide control identification number. This ID is not a unique identifier.'),
    sa.Column('particulate_control_id_eia', sa.Text(), nullable=True, comment='Particulate matter control identification number. This ID is not a unique identifier.'),
    sa.Column('so2_control_id_eia', sa.Text(), nullable=True, comment='Sulfur dioxide control identification number. This ID is not a unique identifier.'),
    sa.Column('acid_gas_control', sa.Boolean(), nullable=True, comment='Indicates whether the emissions control equipment controls acid (HCl) gas.'),
    sa.Column('emission_control_equipment_cost', sa.Float(), nullable=True, comment='The total cost to install a piece of emission control equipment.'),
    sa.Column('emission_control_operating_date', sa.Date(), nullable=True, comment='The date a piece of emissions control equipment began operating. Derived from month and year columns in the raw data.'),
    sa.Column('emission_control_retirement_date', sa.Date(), nullable=True, comment='The expected or actual retirement date for a piece of emissions control equipment. Derived from month and year columns in the raw data.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia860__scd_emissions_control_equipment_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['emission_control_equipment_type_code'], ['core_eia__codes_emission_control_equipment_types.code'], name=op.f('fk_core_eia860__scd_emissions_control_equipment_emission_control_equipment_type_code_core_eia__codes_emission_control_equipment_types')),
    sa.ForeignKeyConstraint(['operational_status_code'], ['core_eia__codes_operational_status.code'], name=op.f('fk_core_eia860__scd_emissions_control_equipment_operational_status_code_core_eia__codes_operational_status')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk_core_eia860__scd_emissions_control_equipment_plant_id_eia_core_eia__entity_plants')),
    sa.PrimaryKeyConstraint('report_year', 'plant_id_eia', 'emission_control_id_pudl', name=op.f('pk_core_eia860__scd_emissions_control_equipment'))
    )
    op.create_table('core_eia860__scd_utilities',
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('street_address', sa.Text(), nullable=True, comment='Physical street address.'),
    sa.Column('city', sa.Text(), nullable=True, comment='Name of the city.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('zip_code', sa.Text(), nullable=True, comment='Five digit US Zip Code.'),
    sa.Column('plants_reported_owner', sa.Boolean(), nullable=True, comment='Is the reporting entity an owner of power plants reported on Schedule 2 of the form?'),
    sa.Column('plants_reported_operator', sa.Boolean(), nullable=True, comment='Is the reporting entity an operator of power plants reported on Schedule 2 of the form?'),
    sa.Column('plants_reported_asset_manager', sa.Boolean(), nullable=True, comment='Is the reporting entity an asset manager of power plants reported on Schedule 2 of the form?'),
    sa.Column('plants_reported_other_relationship', sa.Boolean(), nullable=True, comment='Does the reporting entity have any other relationship to the power plants reported on Schedule 2 of the form?'),
    sa.Column('entity_type', sa.Text(), nullable=True, comment='Entity type of principal owner.'),
    sa.Column('attention_line', sa.Text(), nullable=True, comment='Mail attention name of the operator/owner.'),
    sa.Column('address_2', sa.Text(), nullable=True, comment='Second line of the address.'),
    sa.Column('zip_code_4', sa.Text(), nullable=True, comment='Four digit US Zip Code suffix.'),
    sa.Column('contact_firstname', sa.Text(), nullable=True, comment='First name of utility contact 1.'),
    sa.Column('contact_lastname', sa.Text(), nullable=True, comment='Last name of utility contact 1.'),
    sa.Column('contact_title', sa.Text(), nullable=True, comment='Title of of utility contact 1.'),
    sa.Column('phone_number', sa.Text(), nullable=True, comment='Phone number for utility contact 1.'),
    sa.Column('phone_extension', sa.Text(), nullable=True, comment='Phone extension for utility contact 1'),
    sa.Column('contact_firstname_2', sa.Text(), nullable=True, comment='First name of utility contact 2.'),
    sa.Column('contact_lastname_2', sa.Text(), nullable=True, comment='Last name of utility contact 2.'),
    sa.Column('contact_title_2', sa.Text(), nullable=True, comment='Title of utility contact 2.'),
    sa.Column('phone_number_2', sa.Text(), nullable=True, comment='Phone number for utility contact 2.'),
    sa.Column('phone_extension_2', sa.Text(), nullable=True, comment='Phone extension for utility contact 2'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia860__scd_utilities_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['utility_id_eia'], ['core_eia__entity_utilities.utility_id_eia'], name=op.f('fk_core_eia860__scd_utilities_utility_id_eia_core_eia__entity_utilities')),
    sa.PrimaryKeyConstraint('utility_id_eia', 'report_date', name=op.f('pk_core_eia860__scd_utilities'))
    )
    op.create_table('core_eia860m__changelog_generators',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('valid_until_date', sa.Date(), nullable=True, comment='The record in the changelog is valid until this date. The record is valid from the report_date up until but not including the valid_until_date.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=True, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('county', sa.Text(), nullable=True, comment='County name.'),
    sa.Column('current_planned_generator_operating_date', sa.Date(), nullable=True, comment='The most recently updated effective date on which the generator is scheduled to start operation'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.Column('energy_source_code_1', sa.Text(), nullable=True, comment='The code representing the most predominant type of energy that fuels the generator.'),
    sa.Column('energy_storage_capacity_mwh', sa.Float(), nullable=True, comment='Energy storage capacity in MWh (e.g. for batteries).'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('generator_retirement_date', sa.Date(), nullable=True, comment='Date of the scheduled or effected retirement of the generator.'),
    sa.Column('latitude', sa.Float(), nullable=True, comment="Latitude of the plant's location, in degrees."),
    sa.Column('longitude', sa.Float(), nullable=True, comment="Longitude of the plant's location, in degrees."),
    sa.Column('net_capacity_mwdc', sa.Float(), nullable=True, comment='Generation capacity in megawatts of direct current that is subject to a net metering agreement. Typically used for behind-the-meter solar PV.'),
    sa.Column('operational_status', sa.Text(), nullable=True, comment='The operating status of the asset. For generators this is based on which tab the generator was listed in in EIA 860.'),
    sa.Column('operational_status_code', sa.Text(), nullable=True, comment='The operating status of the asset.'),
    sa.Column('planned_derate_date', sa.Date(), nullable=True, comment='Planned effective month that the generator is scheduled to enter operation after the derate modification.'),
    sa.Column('planned_generator_retirement_date', sa.Date(), nullable=True, comment='Planned effective date of the scheduled retirement of the generator.'),
    sa.Column('planned_net_summer_capacity_derate_mw', sa.Float(), nullable=True, comment='Decrease in summer capacity expected to be realized from the derate modification to the equipment.'),
    sa.Column('planned_net_summer_capacity_uprate_mw', sa.Float(), nullable=True, comment='Increase in summer capacity expected to be realized from the modification to the equipment.'),
    sa.Column('planned_uprate_date', sa.Date(), nullable=True, comment='Planned effective date that the generator is scheduled to enter operation after the uprate modification.'),
    sa.Column('prime_mover_code', sa.Text(), nullable=True, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('sector_id_eia', sa.Integer(), nullable=True, comment='EIA assigned sector ID, corresponding to high level NAICS sector, designated by the primary purpose, regulatory status and plant-level combined heat and power status'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('summer_capacity_mw', sa.Float(), nullable=True, comment='The net summer capacity.'),
    sa.Column('technology_description', sa.Text(), nullable=True, comment='High level description of the technology used by the generator to produce electricity.'),
    sa.Column('winter_capacity_mw', sa.Float(), nullable=True, comment='The net winter capacity.'),
    sa.ForeignKeyConstraint(['balancing_authority_code_eia'], ['core_eia__codes_balancing_authorities.code'], name=op.f('fk_core_eia860m__changelog_generators_balancing_authority_code_eia_core_eia__codes_balancing_authorities')),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia860m__changelog_generators_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia860m__changelog_generators_energy_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['operational_status_code'], ['core_eia__codes_operational_status.code'], name=op.f('fk_core_eia860m__changelog_generators_operational_status_code_core_eia__codes_operational_status')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_core_eia860m__changelog_generators_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['sector_id_eia'], ['core_eia__codes_sector_consolidated.code'], name=op.f('fk_core_eia860m__changelog_generators_sector_id_eia_core_eia__codes_sector_consolidated')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'generator_id', 'report_date', name=op.f('pk_core_eia860m__changelog_generators'))
    )
    op.create_table('core_eia861__yearly_advanced_metering_infrastructure',
    sa.Column('advanced_metering_infrastructure', sa.Integer(), nullable=True, comment='Number of meters that measure and record usage data at a minimum, in hourly intervals and provide usage data at least daily to energy companies and may also provide data to consumers. Data are used for billing and other purposes. Advanced meters include basic hourly interval meters and extend to real-time meters with built-in two-way communication capable of recording and transmitting instantaneous data.'),
    sa.Column('automated_meter_reading', sa.Integer(), nullable=True, comment='Number of meters that collect data for billing purposes only and transmit this data one way, usually from the customer to the distribution utility.'),
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=False, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('customer_class', sa.Enum('commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other'), nullable=False, comment="High level categorization of customer type: ['commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other']."),
    sa.Column('daily_digital_access_customers', sa.Integer(), nullable=True, comment='Number of customers able to access daily energy usage through a webportal or other electronic means.'),
    sa.Column('direct_load_control_customers', sa.Integer(), nullable=True, comment='Number of customers with direct load control: a A demand response activity by which the program sponsor remotely shuts down or cycles a customer’s electrical equipment (e.g. air conditioner, water heater) on short notice.'),
    sa.Column('energy_served_ami_mwh', sa.Float(), nullable=True, comment='Amount of energy served through AMI meters. AMI meters can transmit data in both directions, between the delivery entity and the customer.'),
    sa.Column('entity_type', sa.Text(), nullable=True, comment='Entity type of principal owner.'),
    sa.Column('home_area_network', sa.Integer(), nullable=True, comment='Number of AMI meters with home area network (HAN) gateway enabled.'),
    sa.Column('non_amr_ami', sa.Integer(), nullable=True, comment='Number of non-AMR/AMI meters. Usually electromechanical or solid state meters measuring aggregated kWh where data are manually retrieved over monthly billing cycles for billing purposes only. Standard meters may also include functions to measure time-of-use and/or demand with data manually retrieved over monthly billing cycles.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('short_form', sa.Boolean(), nullable=True, comment='Whether the reported information comes from the short form. In the case of form EIA 861, a shorter version of the form was created in 2012 to reduce respondent burden on smaller utilities and increase our processing efficiency.'),
    sa.Column('state', sa.Text(), nullable=False, comment='Two letter US state abbreviation.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_advanced_metering_infrastructure_data_maturity_core_pudl__codes_data_maturities')),
    sa.PrimaryKeyConstraint('balancing_authority_code_eia', 'customer_class', 'report_date', 'state', 'utility_id_eia', name=op.f('pk_core_eia861__yearly_advanced_metering_infrastructure'))
    )
    op.create_table('core_eia861__yearly_demand_response',
    sa.Column('actual_peak_demand_savings_mw', sa.Float(), nullable=True, comment="Demand reduction actually achieved by demand response activities. Measured at the time of the company's annual system peak hour."),
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=False, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('customer_class', sa.Enum('commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other'), nullable=False, comment="High level categorization of customer type: ['commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other']."),
    sa.Column('customer_incentives_cost', sa.Float(), nullable=True, comment='Total cost of customer incentives in a given report year. Customer incentives are the total financial value provided to a customer for program participation, whether, for example, cash payment, or lowered tariff rates relative to non-participants, in-kind services (e.g. design work), or other benefits directly provided to the customer for their program participation.'),
    sa.Column('customers', sa.Float(), nullable=True, comment='Number of customers.'),
    sa.Column('energy_savings_mwh', sa.Float(), nullable=True, comment='The energy savings incurred in a given reporting year by participation in demand response programs.'),
    sa.Column('other_costs', sa.Float(), nullable=True, comment='Additional costs.'),
    sa.Column('potential_peak_demand_savings_mw', sa.Float(), nullable=True, comment='The total demand savings that could occur at the time of the system peak hour assuming all demand response is called.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('short_form', sa.Boolean(), nullable=True, comment='Whether the reported information comes from the short form. In the case of form EIA 861, a shorter version of the form was created in 2012 to reduce respondent burden on smaller utilities and increase our processing efficiency.'),
    sa.Column('state', sa.Text(), nullable=False, comment='Two letter US state abbreviation.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_demand_response_data_maturity_core_pudl__codes_data_maturities')),
    sa.PrimaryKeyConstraint('balancing_authority_code_eia', 'customer_class', 'report_date', 'state', 'utility_id_eia', name=op.f('pk_core_eia861__yearly_demand_response'))
    )
    op.create_table('core_eia861__yearly_demand_response_water_heater',
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=False, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('state', sa.Text(), nullable=False, comment='Two letter US state abbreviation.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.Column('num_water_heaters', sa.Integer(), nullable=True, comment="The number of grid-enabled water heaters added to the respondent's program this year - if the respondent has DSM program for grid-enabled water heaters (as defined by DOE’s Office of Energy Efficiency and Renewable Energy)."),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_demand_response_water_heater_data_maturity_core_pudl__codes_data_maturities')),
    sa.PrimaryKeyConstraint('balancing_authority_code_eia', 'report_date', 'state', 'utility_id_eia', name=op.f('pk_core_eia861__yearly_demand_response_water_heater'))
    )
    op.create_table('core_eia861__yearly_demand_side_management_ee_dr',
    sa.Column('annual_indirect_program_cost', sa.Float(), nullable=True, comment='Costs that have not been included in any program category, but could be meaningfully identified with operating the company’s DSM programs (e.g., Administrative, Marketing, Monitoring & Evaluation, Company-Earned Incentives, Other).'),
    sa.Column('annual_total_cost', sa.Float(), nullable=True, comment='The sum of direct program costs, indirect program costs, and incentive payments associated with utility demand side management programs.'),
    sa.Column('customer_class', sa.Enum('commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other'), nullable=True, comment="High level categorization of customer type: ['commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other']."),
    sa.Column('energy_efficiency_annual_actual_peak_reduction_mw', sa.Float(), nullable=True, comment='The peak reduction incurred in a given reporting year by all participants in efficiency programs.'),
    sa.Column('energy_efficiency_annual_cost', sa.Float(), nullable=True, comment='The sum of actual direct costs, incentive payments, and indirect costs incurred in a given reporting year from energy efficiency programs.'),
    sa.Column('energy_efficiency_annual_effects_mwh', sa.Float(), nullable=True, comment='The change in energy use incurred in a given reporting year by all participants in energy efficiency programs.'),
    sa.Column('energy_efficiency_annual_incentive_payment', sa.Float(), nullable=True, comment='The cost of incentive payments incurred in a given reporting year from energy efficiency programs. Incentives are the total financial value provided to a customer for program participation, whether cash payment, in-kind services (e.g. design work), or other benefits directly provided customer for their program participation.'),
    sa.Column('energy_efficiency_incremental_actual_peak_reduction_mw', sa.Float(), nullable=True, comment='The peak reduction incurred in a given reporting year by new participants in existing energy efficiency programs and all participants in new energy efficiency programs.'),
    sa.Column('energy_efficiency_incremental_effects_mwh', sa.Float(), nullable=True, comment='The change in energy use incurred in a given reporting year by new participants in existing energy efficiency programs and all participants in new energy efficiency programs.'),
    sa.Column('load_management_annual_actual_peak_reduction_mw', sa.Float(), nullable=True, comment='The peak reduction incurred in a given reporting year by all participants in load management programs.'),
    sa.Column('load_management_annual_cost', sa.Float(), nullable=True, comment='The sum of actual direct costs, incentive payments, and indirect costs incurred in a given reporting year from load management programs.'),
    sa.Column('load_management_annual_effects_mwh', sa.Float(), nullable=True, comment='The change in energy use incurred in a given reporting year by all participants in load management programs.'),
    sa.Column('load_management_annual_incentive_payment', sa.Float(), nullable=True, comment='The cost of incentive payments incurred in a given reporting year from load management programs. Incentives are the total financial value provided to a customer for program participation, whether cash payment, in-kind services (e.g. design work), or other benefits directly provided customer for their program participation.'),
    sa.Column('load_management_annual_potential_peak_reduction_mw', sa.Float(), nullable=True, comment='The potential amount of peak reduction that could be incurred in a given reporting year by all participants in load management programs.'),
    sa.Column('load_management_incremental_actual_peak_reduction_mw', sa.Float(), nullable=True, comment='The peak reduction incurred in a given reporting year by new participants in existing load management programs and all participants in new load management programs.'),
    sa.Column('load_management_incremental_effects_mwh', sa.Float(), nullable=True, comment='The change in energy use incurred in a given reporting year by new participants in existing load management programs and all participants in new load managment programs.'),
    sa.Column('load_management_incremental_potential_peak_reduction_mw', sa.Float(), nullable=True, comment='The potential amount of peak reduction that could be incurred in a given reporting year by new participants in existing load management programs and all participants in new load management programs.'),
    sa.Column('nerc_region', sa.Enum('BASN', 'CALN', 'CALS', 'DSW', 'ASCC', 'ISONE', 'ERCOT', 'NORW', 'NYISO', 'PJM', 'ROCK', 'ECAR', 'FRCC', 'HICC', 'MAAC', 'MAIN', 'MAPP', 'MRO', 'NPCC', 'RFC', 'SERC', 'SPP', 'TRE', 'WECC', 'WSCC', 'MISO', 'ECAR_MAAC', 'MAPP_WECC', 'RFC_SERC', 'SPP_WECC', 'MRO_WECC', 'ERCOT_SPP', 'SPP_TRE', 'ERCOT_TRE', 'MISO_TRE', 'VI', 'GU', 'PR', 'AS', 'UNK'), nullable=True, comment='NERC region in which the plant is located'),
    sa.Column('price_responsiveness_customers', sa.Integer(), nullable=True, comment="The number of customers participating in the respondent's incentive-based demand response programs."),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('time_responsiveness_customers', sa.Integer(), nullable=True, comment="The number of cusomters participating in the respondent's time-based rate programs."),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_demand_side_management_ee_dr_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_demand_side_management_misc',
    sa.Column('energy_savings_estimates_independently_verified', sa.Boolean(), nullable=True, comment='Whether savings estimates are based on a forecast or the report of one or more independent evaluators.'),
    sa.Column('energy_savings_independently_verified', sa.Boolean(), nullable=True, comment='Whether reported energy savings were verified through an independent evaluation.'),
    sa.Column('entity_type', sa.Text(), nullable=True, comment='Entity type of principal owner.'),
    sa.Column('major_program_changes', sa.Boolean(), nullable=True, comment="Whether there have been any major changes to the respondent's demand-side management programs (e.g., terminated programs, new information or financing programs, or a shift to programs with dual load building objectives and energy efficiency objectives), program tracking procedures, or reporting methods that affect the comparison of demand-side management data reported on this schedule to data from previous years."),
    sa.Column('nerc_region', sa.Enum('BASN', 'CALN', 'CALS', 'DSW', 'ASCC', 'ISONE', 'ERCOT', 'NORW', 'NYISO', 'PJM', 'ROCK', 'ECAR', 'FRCC', 'HICC', 'MAAC', 'MAIN', 'MAPP', 'MRO', 'NPCC', 'RFC', 'SERC', 'SPP', 'TRE', 'WECC', 'WSCC', 'MISO', 'ECAR_MAAC', 'MAPP_WECC', 'RFC_SERC', 'SPP_WECC', 'MRO_WECC', 'ERCOT_SPP', 'SPP_TRE', 'ERCOT_TRE', 'MISO_TRE', 'VI', 'GU', 'PR', 'AS', 'UNK'), nullable=True, comment='NERC region in which the plant is located'),
    sa.Column('price_responsive_programs', sa.Boolean(), nullable=True, comment='Whether the respondent operates any incentive-based demand response programs (e.g., market incentives, financial incentives, direct load control, interruptible programs, demand bidding/buyback, emergency demand response, capacity market programs, and ancillary service market programs).'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('reported_as_another_company', sa.Text(), nullable=True, comment="The name of the company if a respondent's demand-side management activities are reported on Schedule 6 of another company’s form."),
    sa.Column('short_form', sa.Boolean(), nullable=True, comment='Whether the reported information comes from the short form. In the case of form EIA 861, a shorter version of the form was created in 2012 to reduce respondent burden on smaller utilities and increase our processing efficiency.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('has_time_responsive_programs', sa.Boolean(), nullable=True, comment='Whether the respondent operates any time-based rate programs (e.g., real-time pricing, critical peak pricing, variable peak pricing and time-of-use rates administered through a tariff).'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_demand_side_management_misc_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_demand_side_management_sales',
    sa.Column('nerc_region', sa.Enum('BASN', 'CALN', 'CALS', 'DSW', 'ASCC', 'ISONE', 'ERCOT', 'NORW', 'NYISO', 'PJM', 'ROCK', 'ECAR', 'FRCC', 'HICC', 'MAAC', 'MAIN', 'MAPP', 'MRO', 'NPCC', 'RFC', 'SERC', 'SPP', 'TRE', 'WECC', 'WSCC', 'MISO', 'ECAR_MAAC', 'MAPP_WECC', 'RFC_SERC', 'SPP_WECC', 'MRO_WECC', 'ERCOT_SPP', 'SPP_TRE', 'ERCOT_TRE', 'MISO_TRE', 'VI', 'GU', 'PR', 'AS', 'UNK'), nullable=True, comment='NERC region in which the plant is located'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('sales_for_resale_mwh', sa.Float(), nullable=True, comment='The amount of electricity sold for resale purposes. This entry should include sales for resale to power marketers (reported separately in previous years), full and partial requirements customers, firm power customers and nonfirm customers.'),
    sa.Column('sales_to_ultimate_consumers_mwh', sa.Float(), nullable=True, comment='The amount of electricity sold to customers purchasing electricity for their own use and not for resale.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_demand_side_management_sales_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_distributed_generation_fuel',
    sa.Column('estimated_or_actual_fuel_data', sa.Enum('estimated', 'actual'), nullable=True, comment='Whether the reported fuel data is estimated or actual.'),
    sa.Column('fuel_class', sa.Enum('gas', 'oil', 'other', 'renewable', 'water', 'wind', 'wood'), nullable=True, comment="Fuel types specific to EIA 861 distributed generation table: ['gas', 'oil', 'other', 'renewable', 'water', 'wind', 'wood']"),
    sa.Column('fuel_pct', sa.Float(), nullable=True, comment='Percent of fuel'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_distributed_generation_fuel_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_distributed_generation_misc',
    sa.Column('backup_capacity_mw', sa.Float(), nullable=True, comment='The total nameplate capacity of generators that are used only for emergency backup service.'),
    sa.Column('distributed_generation_owned_capacity_mw', sa.Float(), nullable=True, comment='Amount of distributed generation capacity owned by the respondent.'),
    sa.Column('estimated_or_actual_capacity_data', sa.Enum('estimated', 'actual'), nullable=True, comment='Whether the reported capacity data is estimated or actual.'),
    sa.Column('generators_num_less_1_mw', sa.Integer(), nullable=True, comment='Total number of generators less than 1 MW.'),
    sa.Column('generators_number', sa.Integer(), nullable=True, comment='Total number of generators'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('total_capacity_less_1_mw', sa.Float(), nullable=True, comment='The total amount of capacity from generators with less than 1 MW of nameplate capacity.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_distributed_generation_misc_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_distributed_generation_tech',
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('estimated_or_actual_tech_data', sa.Enum('estimated', 'actual'), nullable=True, comment='Whether the reported technology data is estimated or actual.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('tech_class', sa.Enum('backup', 'chp_cogen', 'combustion_turbine', 'fuel_cell', 'hydro', 'internal_combustion', 'other', 'pv', 'steam', 'storage_pv', 'all_storage', 'total', 'virtual_pv', 'wind'), nullable=True, comment="Type of technology specific to EIA 861 distributed generation and net generation tables: ['backup', 'chp_cogen', 'combustion_turbine', 'fuel_cell', 'hydro', 'internal_combustion', 'other', 'pv', 'steam', 'storage_pv', 'all_storage', 'total', 'virtual_pv', 'wind']."),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_distributed_generation_tech_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_distribution_systems',
    sa.Column('circuits_with_voltage_optimization', sa.Integer(), nullable=True, comment='Number of distribution circuits that employ voltage/VAR optimization (VVO).'),
    sa.Column('distribution_circuits', sa.Integer(), nullable=True, comment='Total number of distribution circuits.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('short_form', sa.Boolean(), nullable=True, comment='Whether the reported information comes from the short form. In the case of form EIA 861, a shorter version of the form was created in 2012 to reduce respondent burden on smaller utilities and increase our processing efficiency.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_distribution_systems_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_dynamic_pricing',
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=True, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('critical_peak_pricing', sa.Boolean(), nullable=True, comment='Whether customers are participating in critical peak pricing, a program in which rate and/or price structure is designed to encourage reduced consumption during periods of high wholesale market prices or system contingencies, by imposing a pre-specified high rate or price for a limited number of days or hours.'),
    sa.Column('critical_peak_rebate', sa.Boolean(), nullable=True, comment='Whether customers are participating in critical peak rebates, a program in which rate and/or price structure is designed to encourage reduced consumption during periods of high wholesale market prices or system contingencies, by providing a rebate to the customer on a limited number of days and for a limited number of hours, at the request of the energy provider.'),
    sa.Column('customer_class', sa.Enum('commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other'), nullable=True, comment="High level categorization of customer type: ['commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other']."),
    sa.Column('customers', sa.Float(), nullable=True, comment='Number of customers.'),
    sa.Column('real_time_pricing', sa.Boolean(), nullable=True, comment='Whether the respondent has customers participating in a real time pricing (RTP) program. RTP is a program of rate and price structure in which the retail price for electricity typically fluctuates hourly or more often, to reflect changes in the wholesale price of electricity on either a day- ahead or hour-ahead basis.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('short_form', sa.Boolean(), nullable=True, comment='Whether the reported information comes from the short form. In the case of form EIA 861, a shorter version of the form was created in 2012 to reduce respondent burden on smaller utilities and increase our processing efficiency.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('time_of_use_pricing', sa.Boolean(), nullable=True, comment='Whether the respondent has customers participating in a time-of-use pricing programs (TOU). TOU is a program in which customers pay different prices at different times of the day. On-peak prices are higher and off-peak prices are lower than a “standard” rate. Price schedule is fixed and predefined, based on season, day of week, and time of day.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('variable_peak_pricing', sa.Boolean(), nullable=True, comment='Whether the respondent has customers participating in a variable peak pricing program (VPP). VPP is a program in which a form of TOU pricing allows customers to purchase their generation supply at prices set on a daily basis with varying on-peak and constant off-peak rates. Under the VPP program, the on-peak price for each weekday becomes available the previous day (typically late afternoon) and the customer is billed for actual consumption during the billing cycle at these prices.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_dynamic_pricing_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_energy_efficiency',
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=True, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('customer_class', sa.Enum('commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other'), nullable=True, comment="High level categorization of customer type: ['commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other']."),
    sa.Column('customer_incentives_incremental_cost', sa.Float(), nullable=True, comment='The cost of customer incentives resulting from new participants in existing energy efficiency programs and all participants in new energy efficiency programs. Customer incentives are the total financial value provided to a customer for program participation, whether, for example, cash payment, or lowered tariff rates relative to non-participants, in-kind services (e.g. design work), or other benefits directly provided to the customer for their program participation.'),
    sa.Column('customer_incentives_incremental_life_cycle_cost', sa.Float(), nullable=True, comment='All anticipated costs of the customer incentives including reporting year incremental costs and all future costs. Customer incentives are the total financial value provided to a customer for program participation, whether, for example, cash payment, or lowered tariff rates relative to non-participants, in-kind services (e.g. design work), or other benefits directly provided to the customer for their program participation.'),
    sa.Column('customer_other_costs_incremental_life_cycle_cost', sa.Float(), nullable=True, comment='All anticipated costs other than customer incentives. Includes reporting year incremental costs and all future costs.'),
    sa.Column('incremental_energy_savings_mwh', sa.Float(), nullable=True, comment='energy savings in the given report year resulting from new participants in existing demand response programs and all participants in new demand response programs.'),
    sa.Column('incremental_life_cycle_energy_savings_mwh', sa.Float(), nullable=True, comment='The estimated total changes in energy use for incremental programs and participants over the life of the programs. DSM programs have a useful life, and the net effects of these programs will diminish over time. Considers the useful life of energy efficiency technology by accounting for building demolition, equipment degradation, and program attrition.'),
    sa.Column('incremental_life_cycle_peak_reduction_mw', sa.Float(), nullable=True, comment='The estimated total changes in peak load for incremental programs and participants over the life of the programs. DSM programs have a useful life, and the net effects of these programs will diminish over time. Considers the useful life of energy efficiency technology by accounting for building demolition, equipment degradation, and program attrition.'),
    sa.Column('incremental_peak_reduction_mw', sa.Float(), nullable=True, comment='The peak reduction incurred in a given reporting year by new participants in existing energy efficiency programs and all participants in new energy efficiency programs.'),
    sa.Column('other_costs_incremental_cost', sa.Float(), nullable=True, comment="Costs resulting from new participants in existing energy efficiency programs and all participants in new energy efficiency programs that aren't directly associated with customer incentives."),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('short_form', sa.Boolean(), nullable=True, comment='Whether the reported information comes from the short form. In the case of form EIA 861, a shorter version of the form was created in 2012 to reduce respondent burden on smaller utilities and increase our processing efficiency.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('weighted_average_life_years', sa.Float(), nullable=True, comment="The weighted average life of the respondent's portfolio of energy efficiency programs."),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_energy_efficiency_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_green_pricing',
    sa.Column('customer_class', sa.Enum('commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other'), nullable=True, comment="High level categorization of customer type: ['commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other']."),
    sa.Column('customers', sa.Float(), nullable=True, comment='Number of customers.'),
    sa.Column('green_pricing_revenue', sa.Float(), nullable=True, comment="The money derived from premium green pricing rate of the respondent'sprogram."),
    sa.Column('rec_revenue', sa.Float(), nullable=True, comment='Amount of revenue collected from Renewable Energy Certificates (RECs).'),
    sa.Column('rec_sales_mwh', sa.Float(), nullable=True, comment='Amount of sales collected from Renewable Energy Certificates (RECs).'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('sales_mwh', sa.Float(), nullable=True, comment='Quantity of electricity sold in MWh.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_green_pricing_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_mergers',
    sa.Column('entity_type', sa.Text(), nullable=True, comment='Entity type of principal owner.'),
    sa.Column('merge_address', sa.Text(), nullable=True, comment='Address of new parent company.'),
    sa.Column('merge_city', sa.Text(), nullable=True, comment='City of new parent company.'),
    sa.Column('merge_company', sa.Text(), nullable=True, comment='Name of the company merged with or acquired.'),
    sa.Column('merge_date', sa.Date(), nullable=True, comment='Date of merger or acquisition.'),
    sa.Column('merge_state', sa.Text(), nullable=True, comment='Two letter US state abbreviations and three letter ISO-3166-1 country codes for international mines.'),
    sa.Column('new_parent', sa.Text(), nullable=True, comment='Name of the new parent company post merger.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('zip_code', sa.Text(), nullable=True, comment='Five digit US Zip Code.'),
    sa.Column('zip_code_4', sa.Text(), nullable=True, comment='Four digit US Zip Code suffix.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_mergers_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_net_metering_customer_fuel_class',
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=True, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('customer_class', sa.Enum('commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other'), nullable=True, comment="High level categorization of customer type: ['commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other']."),
    sa.Column('customers', sa.Float(), nullable=True, comment='Number of customers.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('short_form', sa.Boolean(), nullable=True, comment='Whether the reported information comes from the short form. In the case of form EIA 861, a shorter version of the form was created in 2012 to reduce respondent burden on smaller utilities and increase our processing efficiency.'),
    sa.Column('sold_to_utility_mwh', sa.Float(), nullable=True, comment='The amount of electric energy sold back to the utility through the net metering application.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('tech_class', sa.Enum('backup', 'chp_cogen', 'combustion_turbine', 'fuel_cell', 'hydro', 'internal_combustion', 'other', 'pv', 'steam', 'storage_pv', 'all_storage', 'total', 'virtual_pv', 'wind'), nullable=True, comment="Type of technology specific to EIA 861 distributed generation and net generation tables: ['backup', 'chp_cogen', 'combustion_turbine', 'fuel_cell', 'hydro', 'internal_combustion', 'other', 'pv', 'steam', 'storage_pv', 'all_storage', 'total', 'virtual_pv', 'wind']."),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_net_metering_customer_fuel_class_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_net_metering_misc',
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=True, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('pv_current_flow_type', sa.Enum('AC', 'DC'), nullable=True, comment='Current flow type for photovoltaics: AC or DC'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_net_metering_misc_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_non_net_metering_customer_fuel_class',
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=True, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('customer_class', sa.Enum('commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other'), nullable=True, comment="High level categorization of customer type: ['commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other']."),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('tech_class', sa.Enum('backup', 'chp_cogen', 'combustion_turbine', 'fuel_cell', 'hydro', 'internal_combustion', 'other', 'pv', 'steam', 'storage_pv', 'all_storage', 'total', 'virtual_pv', 'wind'), nullable=True, comment="Type of technology specific to EIA 861 distributed generation and net generation tables: ['backup', 'chp_cogen', 'combustion_turbine', 'fuel_cell', 'hydro', 'internal_combustion', 'other', 'pv', 'steam', 'storage_pv', 'all_storage', 'total', 'virtual_pv', 'wind']."),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_non_net_metering_customer_fuel_class_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_non_net_metering_misc',
    sa.Column('backup_capacity_mw', sa.Float(), nullable=True, comment='The total nameplate capacity of generators that are used only for emergency backup service.'),
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=True, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('generators_number', sa.Integer(), nullable=True, comment='Total number of generators'),
    sa.Column('pv_current_flow_type', sa.Enum('AC', 'DC'), nullable=True, comment='Current flow type for photovoltaics: AC or DC'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_owned_capacity_mw', sa.Float(), nullable=True, comment='Total non-net-metered capacity owned by the respondent.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_non_net_metering_misc_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_operational_data_misc',
    sa.Column('consumed_by_facility_mwh', sa.Float(), nullable=True, comment='The amount of electricity used by the facility.'),
    sa.Column('consumed_by_respondent_without_charge_mwh', sa.Float(), nullable=True, comment='The amount of electricity used by the electric utility in its electric and other departments without charge.'),
    sa.Column('data_observed', sa.Boolean(), nullable=True, comment='Is the value observed (True) or imputed (False).'),
    sa.Column('entity_type', sa.Text(), nullable=True, comment='Entity type of principal owner.'),
    sa.Column('exchange_energy_delivered_mwh', sa.Float(), nullable=True, comment='The amount of exchange energy delivered. Does not include power delivered as part of a tolling arrangement.'),
    sa.Column('exchange_energy_received_mwh', sa.Float(), nullable=True, comment='The amount of exchange energy received. Does not include power received through tolling arrangements.'),
    sa.Column('furnished_without_charge_mwh', sa.Float(), nullable=True, comment='The amount of electricity furnished by the electric utility without charge, such as to a municipality under a franchise agreement or for street and highway lighting.'),
    sa.Column('nerc_region', sa.Enum('BASN', 'CALN', 'CALS', 'DSW', 'ASCC', 'ISONE', 'ERCOT', 'NORW', 'NYISO', 'PJM', 'ROCK', 'ECAR', 'FRCC', 'HICC', 'MAAC', 'MAIN', 'MAPP', 'MRO', 'NPCC', 'RFC', 'SERC', 'SPP', 'TRE', 'WECC', 'WSCC', 'MISO', 'ECAR_MAAC', 'MAPP_WECC', 'RFC_SERC', 'SPP_WECC', 'MRO_WECC', 'ERCOT_SPP', 'SPP_TRE', 'ERCOT_TRE', 'MISO_TRE', 'VI', 'GU', 'PR', 'AS', 'UNK'), nullable=True, comment='NERC region in which the plant is located'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('net_power_exchanged_mwh', sa.Float(), nullable=True, comment='The net amount of energy exchanged. Net exchange is the difference between the amount of exchange received and the amount of exchange delivered. This entry should not include wholesale energy purchased from or sold to regulated companies or unregulated companies for other systems.'),
    sa.Column('net_wheeled_power_mwh', sa.Float(), nullable=True, comment="The difference between the amount of energy entering the respondent's system (wheeled received) for transmission through the respondent's system and the amount of energy leaving the respondent's system (wheeled delievered). Wheeled net represents the energy losses on the respondent's system associated with the wheeling of energy for other systems."),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('retail_sales_mwh', sa.Float(), nullable=True, comment='MWh of sales to end-use customers in areas where the customer has been given the legal right to select a power supplier other than the traditional, vertically integrated electric utility.'),
    sa.Column('sales_for_resale_mwh', sa.Float(), nullable=True, comment='The amount of electricity sold for resale purposes. This entry should include sales for resale to power marketers (reported separately in previous years), full and partial requirements customers, firm power customers and nonfirm customers.'),
    sa.Column('short_form', sa.Boolean(), nullable=True, comment='Whether the reported information comes from the short form. In the case of form EIA 861, a shorter version of the form was created in 2012 to reduce respondent burden on smaller utilities and increase our processing efficiency.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('summer_peak_demand_mw', sa.Float(), nullable=True, comment='The maximum hourly summer load (for the months of June through September) based on net energy for the system during the reporting year. Net energy for the system is the sum of energy an electric utility needs to satisfy their service area and includes full and partial wholesale requirements customers, and the losses experienced in delivery. The maximum hourly load is determined by the interval in which the 60-minute integrated demand is the greatest.'),
    sa.Column('total_disposition_mwh', sa.Float(), nullable=True, comment='Sum of all disposition of electricity listed. Includes sales to ultimate customers, sales for resale, energy furnished without charge, energy consumed by respondent without charge and total energy losses.'),
    sa.Column('total_energy_losses_mwh', sa.Float(), nullable=True, comment='The total amount of electricity lost from transmission, distribution, and/or unaccounted for. Should be expressed as a positive number.'),
    sa.Column('total_sources_mwh', sa.Float(), nullable=True, comment='Sum of all sources of electricity listed. Includes net generation, purchases from electricity suppliers, net exchanges (received - delivered), net wheeled (received - delivered), transmission by others, and losses.'),
    sa.Column('transmission_by_other_losses_mwh', sa.Float(), nullable=True, comment="The amount of energy losses associated with the wheeling of electricity provided to the respondent's system by other utilities. Transmission by others, losses should always be a negative value."),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('wheeled_power_delivered_mwh', sa.Float(), nullable=True, comment="The total amount of energy leaving the respondent's system that was transmitted through the respondent's system for delivery to other systems. If wheeling delivered is not precisely known, the value is an estimate based on the respondent's system's known percentage of losses for wheeling transactions."),
    sa.Column('wheeled_power_received_mwh', sa.Float(), nullable=True, comment="The total amount of energy entering the respondent's system from other systems for transmission through the respondent's system (wheeling) for delivery to other systems. Does not include energy purchased or exchanged for consumption within the respondent's system, which was wheeled to the respondent by others."),
    sa.Column('wholesale_power_purchases_mwh', sa.Float(), nullable=True, comment='Purchases from electricity suppliers.'),
    sa.Column('winter_peak_demand_mw', sa.Float(), nullable=True, comment='The maximum hourly winter load (for the months of January through March) based on net energy for the system during the reporting year. Net energy for the system is the sum of energy an electric utility needs to satisfy their service area and includes full and partial wholesale requirements customers, and the losses experienced in delivery. The maximum hourly load is determined by the interval in which the 60-minute integrated demand is the greatest.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_operational_data_misc_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_operational_data_revenue',
    sa.Column('nerc_region', sa.Enum('BASN', 'CALN', 'CALS', 'DSW', 'ASCC', 'ISONE', 'ERCOT', 'NORW', 'NYISO', 'PJM', 'ROCK', 'ECAR', 'FRCC', 'HICC', 'MAAC', 'MAIN', 'MAPP', 'MRO', 'NPCC', 'RFC', 'SERC', 'SPP', 'TRE', 'WECC', 'WSCC', 'MISO', 'ECAR_MAAC', 'MAPP_WECC', 'RFC_SERC', 'SPP_WECC', 'MRO_WECC', 'ERCOT_SPP', 'SPP_TRE', 'ERCOT_TRE', 'MISO_TRE', 'VI', 'GU', 'PR', 'AS', 'UNK'), nullable=True, comment='NERC region in which the plant is located'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('revenue', sa.Float(), nullable=True, comment='Amount of revenue.'),
    sa.Column('revenue_class', sa.Enum('credits_or_adjustments', 'delivery_customers', 'other', 'retail_sales', 'sales_for_resale', 'total', 'transmission', 'unbundled'), nullable=True, comment="Source of revenue: ['credits_or_adjustments', 'delivery_customers', 'other', 'retail_sales', 'sales_for_resale', 'total', 'transmission', 'unbundled']"),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_operational_data_revenue_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_reliability',
    sa.Column('caidi_w_major_event_days_minus_loss_of_service_minutes', sa.Float(), nullable=True, comment='Average number of minutes per interruption (SAIDI/SAIFI) including major event days and excluding reliability events caused by a loss of supply.'),
    sa.Column('caidi_w_major_event_days_minutes', sa.Float(), nullable=True, comment='Average number of minutes per interruption (SAIDI/SAIFI) including major event days.'),
    sa.Column('caidi_wo_major_event_days_minutes', sa.Float(), nullable=True, comment='Average number of minutes per interruption (SAIDI/SAIFI) excluding major event days.'),
    sa.Column('customers', sa.Float(), nullable=True, comment='Number of customers.'),
    sa.Column('entity_type', sa.Text(), nullable=True, comment='Entity type of principal owner.'),
    sa.Column('highest_distribution_voltage_kv', sa.Float(), nullable=True, comment="The highest voltage that's part of the distribution system."),
    sa.Column('inactive_accounts_included', sa.Boolean(), nullable=True, comment='Whether the respondent includes inactive accounts in its definition of customers used to determine SAIDI and SAIFI.'),
    sa.Column('momentary_interruption_definition', sa.Text(), nullable=True, comment='How the respondent defines momentary service interruptions: less than 1 min, equal to or less than 5 min, or some other way.'),
    sa.Column('outages_recorded_automatically', sa.Boolean(), nullable=True, comment='Whether the information about customer outages is recorded automatically.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('saidi_w_major_event_days_minus_loss_of_service_minutes', sa.Float(), nullable=True, comment='Cumulative duration (minutes) of interruption for the average customer during the report year including major event days and excluding reliability events caused by a loss of supply.'),
    sa.Column('saidi_w_major_event_days_minutes', sa.Float(), nullable=True, comment='Cumulative duration (minutes) of interruption for the average customer during the report year including major event days.'),
    sa.Column('saidi_wo_major_event_days_minutes', sa.Float(), nullable=True, comment='Cumulative duration (minutes) of interruption for the average customer during the report year excluding major event days.'),
    sa.Column('saifi_w_major_event_days_customers', sa.Float(), nullable=True, comment='Average number of times a customer experienced a sustained interruption (over 5 minutes) during the report year including major event days.'),
    sa.Column('saifi_w_major_event_days_minus_loss_of_service_customers', sa.Float(), nullable=True, comment='Average number of times a customer experienced a sustained interruption (over 5 minutes) during the report year including major event days and excluding reliability events caused by a loss of supply.'),
    sa.Column('saifi_wo_major_event_days_customers', sa.Float(), nullable=True, comment='Average number of times a customer experienced a sustained interruption (over 5 minutes) during the report year excluding major event days.'),
    sa.Column('short_form', sa.Boolean(), nullable=True, comment='Whether the reported information comes from the short form. In the case of form EIA 861, a shorter version of the form was created in 2012 to reduce respondent burden on smaller utilities and increase our processing efficiency.'),
    sa.Column('standard', sa.Enum('ieee_standard', 'other_standard'), nullable=True, comment='Whether the respondent calculates SAIDI/SAIFI, and major event days according to the IEEE or an Other standard.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_reliability_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['momentary_interruption_definition'], ['core_eia__codes_momentary_interruptions.code'], name=op.f('fk_core_eia861__yearly_reliability_momentary_interruption_definition_core_eia__codes_momentary_interruptions'))
    )
    op.create_table('core_eia861__yearly_sales',
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.Column('state', sa.Text(), nullable=False, comment='Two letter US state abbreviation.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=False, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('customer_class', sa.Enum('commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other'), nullable=False, comment="High level categorization of customer type: ['commercial', 'industrial', 'direct_connection', 'other', 'residential', 'total', 'transportation', 'commercial_other']."),
    sa.Column('business_model', sa.Enum('retail', 'energy_services'), nullable=False, comment='Business model.'),
    sa.Column('data_observed', sa.Boolean(), nullable=True, comment='Is the value observed (True) or imputed (False).'),
    sa.Column('entity_type', sa.Text(), nullable=True, comment='Entity type of principal owner.'),
    sa.Column('service_type', sa.Enum('bundled', 'energy', 'delivery'), nullable=False, comment='The type of service the respondent provides to a given customer class.Bundled: both energy and delivery; energy: just the energy consumed; delivery: just the billing and energy delivery services.'),
    sa.Column('short_form', sa.Boolean(), nullable=True, comment='Whether the reported information comes from the short form. In the case of form EIA 861, a shorter version of the form was created in 2012 to reduce respondent burden on smaller utilities and increase our processing efficiency.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('customers', sa.Float(), nullable=True, comment='Number of customers.'),
    sa.Column('sales_mwh', sa.Float(), nullable=True, comment='Quantity of electricity sold in MWh.'),
    sa.Column('sales_revenue', sa.Float(), nullable=True, comment='Revenue from electricity sold.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_sales_data_maturity_core_pudl__codes_data_maturities')),
    sa.PrimaryKeyConstraint('utility_id_eia', 'state', 'report_date', 'balancing_authority_code_eia', 'customer_class', 'business_model', 'service_type', name=op.f('pk_core_eia861__yearly_sales'))
    )
    op.create_table('core_eia861__yearly_service_territory',
    sa.Column('county', sa.Text(), nullable=True, comment='County name.'),
    sa.Column('short_form', sa.Boolean(), nullable=True, comment='Whether the reported information comes from the short form. In the case of form EIA 861, a shorter version of the form was created in 2012 to reduce respondent burden on smaller utilities and increase our processing efficiency.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('state_id_fips', sa.Text(), nullable=True, comment='Two digit state FIPS code.'),
    sa.Column('county_id_fips', sa.Text(), nullable=False, comment='County ID from the Federal Information Processing Standard Publication 6-4.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_service_territory_data_maturity_core_pudl__codes_data_maturities')),
    sa.PrimaryKeyConstraint('report_date', 'utility_id_eia', 'county_id_fips', name=op.f('pk_core_eia861__yearly_service_territory'))
    )
    op.create_table('core_eia861__yearly_short_form',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('entity_type', sa.Text(), nullable=True, comment='Entity type of principal owner.'),
    sa.Column('state', sa.Text(), nullable=False, comment='Two letter US state abbreviation.'),
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=False, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('sales_revenue', sa.Float(), nullable=True, comment='Revenue from electricity sold.'),
    sa.Column('sales_mwh', sa.Float(), nullable=True, comment='Quantity of electricity sold in MWh.'),
    sa.Column('customers', sa.Float(), nullable=True, comment='Number of customers.'),
    sa.Column('has_net_metering', sa.Boolean(), nullable=True, comment='Whether the plant has a net metering agreement in effect during the reporting year.  (Only displayed for facilities that report the sun or wind as an energy source). This field was only reported up until 2015'),
    sa.Column('has_demand_side_management', sa.Boolean(), nullable=True, comment='Whether there were strategies or measures used to control electricity demand by customers'),
    sa.Column('has_time_responsive_programs', sa.Boolean(), nullable=True, comment='Whether the respondent operates any time-based rate programs (e.g., real-time pricing, critical peak pricing, variable peak pricing and time-of-use rates administered through a tariff).'),
    sa.Column('has_green_pricing', sa.Boolean(), nullable=True, comment='Whether a green pricing program was associated with this utility during the reporting year.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_short_form_data_maturity_core_pudl__codes_data_maturities')),
    sa.PrimaryKeyConstraint('utility_id_eia', 'state', 'report_date', 'balancing_authority_code_eia', name=op.f('pk_core_eia861__yearly_short_form'))
    )
    op.create_table('core_eia861__yearly_utility_data_misc',
    sa.Column('alternative_fuel_vehicle_2_activity', sa.Boolean(), nullable=True, comment='Whether the utility plants to operate alternative-fueled vehicles this coming year.'),
    sa.Column('alternative_fuel_vehicle_activity', sa.Boolean(), nullable=True, comment='Whether the utility operates alternative-fueled vehicles during the year.'),
    sa.Column('bundled_activity', sa.Boolean(), nullable=True, comment='Whether a utility engaged in combined utility services (electricity plus other services such as gas, water, etc. in addition to electric services) during the year.'),
    sa.Column('buying_distribution_activity', sa.Boolean(), nullable=True, comment='Whether a utility bought any distribution on other electrical systems during the year.'),
    sa.Column('buying_transmission_activity', sa.Boolean(), nullable=True, comment='Whether a utility bought any transmission services on other electrical systems during the year.'),
    sa.Column('distribution_activity', sa.Boolean(), nullable=True, comment='Whether a utility engaged in any distribution using owned/leased electrical wires during the year.'),
    sa.Column('entity_type', sa.Text(), nullable=True, comment='Entity type of principal owner.'),
    sa.Column('generation_activity', sa.Boolean(), nullable=True, comment='Whether a utility utilized generation from company owned plant during the year.'),
    sa.Column('nerc_region', sa.Enum('BASN', 'CALN', 'CALS', 'DSW', 'ASCC', 'ISONE', 'ERCOT', 'NORW', 'NYISO', 'PJM', 'ROCK', 'ECAR', 'FRCC', 'HICC', 'MAAC', 'MAIN', 'MAPP', 'MRO', 'NPCC', 'RFC', 'SERC', 'SPP', 'TRE', 'WECC', 'WSCC', 'MISO', 'ECAR_MAAC', 'MAPP_WECC', 'RFC_SERC', 'SPP_WECC', 'MRO_WECC', 'ERCOT_SPP', 'SPP_TRE', 'ERCOT_TRE', 'MISO_TRE', 'VI', 'GU', 'PR', 'AS', 'UNK'), nullable=True, comment='NERC region in which the plant is located'),
    sa.Column('operates_generating_plant', sa.Boolean(), nullable=True, comment='Whether the respondent operated at least one generating plant during the reporting period.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('retail_marketing_activity', sa.Boolean(), nullable=True, comment='Whether a utility engaged in retail power marketing during the year.'),
    sa.Column('short_form', sa.Boolean(), nullable=True, comment='Whether the reported information comes from the short form. In the case of form EIA 861, a shorter version of the form was created in 2012 to reduce respondent burden on smaller utilities and increase our processing efficiency.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('transmission_activity', sa.Boolean(), nullable=True, comment='Whether a utility engaged in any transmission activities during the year.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('wholesale_marketing_activity', sa.Boolean(), nullable=True, comment='Whether a utility engages in wholesale power marketing during the year.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_utility_data_misc_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_utility_data_nerc',
    sa.Column('nerc_region', sa.Enum('BASN', 'CALN', 'CALS', 'DSW', 'ASCC', 'ISONE', 'ERCOT', 'NORW', 'NYISO', 'PJM', 'ROCK', 'ECAR', 'FRCC', 'HICC', 'MAAC', 'MAIN', 'MAPP', 'MRO', 'NPCC', 'RFC', 'SERC', 'SPP', 'TRE', 'WECC', 'WSCC', 'MISO', 'ECAR_MAAC', 'MAPP_WECC', 'RFC_SERC', 'SPP_WECC', 'MRO_WECC', 'ERCOT_SPP', 'SPP_TRE', 'ERCOT_TRE', 'MISO_TRE', 'VI', 'GU', 'PR', 'AS', 'UNK'), nullable=True, comment='NERC region in which the plant is located'),
    sa.Column('nerc_regions_of_operation', sa.Enum('BASN', 'CALN', 'CALS', 'DSW', 'ASCC', 'ISONE', 'ERCOT', 'NORW', 'NYISO', 'PJM', 'ROCK', 'ECAR', 'FRCC', 'HICC', 'MAAC', 'MAIN', 'MAPP', 'MRO', 'NPCC', 'RFC', 'SERC', 'SPP', 'TRE', 'WECC', 'WSCC', 'MISO', 'ECAR_MAAC', 'MAPP_WECC', 'RFC_SERC', 'SPP_WECC', 'MRO_WECC', 'ERCOT_SPP', 'SPP_TRE', 'ERCOT_TRE', 'MISO_TRE', 'VI', 'GU', 'PR', 'AS', 'UNK'), nullable=True, comment='All the regional entities within the North American Electric Reliability Corporation (NERC) in which the respodent conducts operations.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_utility_data_nerc_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia861__yearly_utility_data_rto',
    sa.Column('nerc_region', sa.Enum('BASN', 'CALN', 'CALS', 'DSW', 'ASCC', 'ISONE', 'ERCOT', 'NORW', 'NYISO', 'PJM', 'ROCK', 'ECAR', 'FRCC', 'HICC', 'MAAC', 'MAIN', 'MAPP', 'MRO', 'NPCC', 'RFC', 'SERC', 'SPP', 'TRE', 'WECC', 'WSCC', 'MISO', 'ECAR_MAAC', 'MAPP_WECC', 'RFC_SERC', 'SPP_WECC', 'MRO_WECC', 'ERCOT_SPP', 'SPP_TRE', 'ERCOT_TRE', 'MISO_TRE', 'VI', 'GU', 'PR', 'AS', 'UNK'), nullable=True, comment='NERC region in which the plant is located'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('rtos_of_operation', sa.Enum('caiso', 'ercot', 'isone', 'miso', 'nyiso', 'other', 'pjm', 'spp'), nullable=True, comment='The ISOs/RTOs, in which the respondent conducts operations.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia861__yearly_utility_data_rto_data_maturity_core_pudl__codes_data_maturities'))
    )
    op.create_table('core_eia923__entity_coalmine',
    sa.Column('mine_id_pudl', sa.Integer(), nullable=False, comment='Dynamically assigned PUDL mine identifier.'),
    sa.Column('mine_name', sa.Text(), nullable=True, comment='Coal mine name.'),
    sa.Column('mine_type_code', sa.Text(), nullable=True, comment='Type of coal mine.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('county_id_fips', sa.Text(), nullable=True, comment='County ID from the Federal Information Processing Standard Publication 6-4.'),
    sa.Column('mine_id_msha', sa.Integer(), nullable=True, comment='MSHA issued mine identifier.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia923__entity_coalmine_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['mine_type_code'], ['core_eia__codes_coalmine_types.code'], name=op.f('fk_core_eia923__entity_coalmine_mine_type_code_core_eia__codes_coalmine_types')),
    sa.PrimaryKeyConstraint('mine_id_pudl', name=op.f('pk_core_eia923__entity_coalmine'))
    )
    op.create_table('core_eia923__monthly_energy_storage',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('prime_mover_code', sa.Text(), nullable=False, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('energy_source_code', sa.Text(), nullable=False, comment='A 2-3 letter code indicating the energy source (e.g. fuel type) associated with the record.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.Column('fuel_units', sa.Enum('barrels', 'mcf', 'mwh', 'short_tons'), nullable=True, comment='Reported unit of measure for fuel.'),
    sa.Column('fuel_consumed_for_electricity_units', sa.Float(), nullable=True, comment='Consumption for electric generation of the fuel type in physical unit.'),
    sa.Column('fuel_consumed_units', sa.Float(), nullable=True, comment='Consumption of the fuel type in physical unit. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('gross_generation_mwh', sa.Float(), nullable=True, comment='Gross electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia923__monthly_energy_storage_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_code'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia923__monthly_energy_storage_energy_source_code_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk_core_eia923__monthly_energy_storage_plant_id_eia_core_eia__entity_plants')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_core_eia923__monthly_energy_storage_prime_mover_code_core_eia__codes_prime_movers')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_date', 'prime_mover_code', 'energy_source_code', name=op.f('pk_core_eia923__monthly_energy_storage'))
    )
    op.create_table('core_eia923__monthly_generation_fuel',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('energy_source_code', sa.Text(), nullable=False, comment='A 2-3 letter code indicating the energy source (e.g. fuel type) associated with the record.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_type_code_agg', sa.Text(), nullable=True, comment='A partial aggregation of the reported fuel type codes into larger categories used by EIA in, for example, the Annual Energy Review (AER) or Monthly Energy Review (MER). Two or three letter alphanumeric.'),
    sa.Column('prime_mover_code', sa.Text(), nullable=False, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('fuel_consumed_units', sa.Float(), nullable=True, comment='Consumption of the fuel type in physical unit. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_consumed_for_electricity_units', sa.Float(), nullable=True, comment='Consumption for electric generation of the fuel type in physical unit.'),
    sa.Column('fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Heat content of the fuel in millions of Btus per physical unit.'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_consumed_for_electricity_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel to produce electricity, in physical unit, year to date.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia923__monthly_generation_fuel_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_code'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia923__monthly_generation_fuel_energy_source_code_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['fuel_type_code_agg'], ['core_eia__codes_fuel_types_agg.code'], name=op.f('fk_core_eia923__monthly_generation_fuel_fuel_type_code_agg_core_eia__codes_fuel_types_agg')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk_core_eia923__monthly_generation_fuel_plant_id_eia_core_eia__entity_plants')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_core_eia923__monthly_generation_fuel_prime_mover_code_core_eia__codes_prime_movers')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_date', 'prime_mover_code', 'energy_source_code', name=op.f('pk_core_eia923__monthly_generation_fuel'))
    )
    op.create_table('core_eia923__monthly_generation_fuel_nuclear',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('nuclear_unit_id', sa.Text(), nullable=False, comment='For nuclear plants only, the unit number .One digit numeric. Nuclear plants are the only type of plants for which data are shown explicitly at the generating unit level.'),
    sa.Column('energy_source_code', sa.Text(), nullable=False, comment='A 2-3 letter code indicating the energy source (e.g. fuel type) associated with the record.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_type_code_agg', sa.Text(), nullable=True, comment='A partial aggregation of the reported fuel type codes into larger categories used by EIA in, for example, the Annual Energy Review (AER) or Monthly Energy Review (MER). Two or three letter alphanumeric.'),
    sa.Column('prime_mover_code', sa.Text(), nullable=False, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('fuel_consumed_units', sa.Float(), nullable=True, comment='Consumption of the fuel type in physical unit. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_consumed_for_electricity_units', sa.Float(), nullable=True, comment='Consumption for electric generation of the fuel type in physical unit.'),
    sa.Column('fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Heat content of the fuel in millions of Btus per physical unit.'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_consumed_for_electricity_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel to produce electricity, in physical unit, year to date.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia923__monthly_generation_fuel_nuclear_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_code'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia923__monthly_generation_fuel_nuclear_energy_source_code_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['fuel_type_code_agg'], ['core_eia__codes_fuel_types_agg.code'], name=op.f('fk_core_eia923__monthly_generation_fuel_nuclear_fuel_type_code_agg_core_eia__codes_fuel_types_agg')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk_core_eia923__monthly_generation_fuel_nuclear_plant_id_eia_core_eia__entity_plants')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_core_eia923__monthly_generation_fuel_nuclear_prime_mover_code_core_eia__codes_prime_movers')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_date', 'nuclear_unit_id', 'energy_source_code', 'prime_mover_code', name=op.f('pk_core_eia923__monthly_generation_fuel_nuclear'))
    )
    op.create_table('core_eia__codes_balancing_authority_subregions',
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=False, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('balancing_authority_subregion_code_eia', sa.Enum('0001', '0004', '0006', '0027', '0035', '4001', '4002', '4003', '4004', '4005', '4006', '4007', '4008', '8910', 'ACMA', 'AE', 'AEP', 'AP', 'ATSI', 'BC', 'CE', 'COAS', 'CSWS', 'CYGA', 'DAY', 'DEOK', 'DOM', 'DPL', 'DUQ', 'EAST', 'EDE', 'EKPC', 'FREP', 'FWES', 'GRDA', 'INDN', 'JC', 'JICA', 'KACY', 'KAFB', 'KCEC', 'KCPL', 'LAC', 'LES', 'ME', 'MPS', 'NCEN', 'NPPD', 'NRTH', 'NTUA', 'OKGE', 'OPPD', 'PE', 'PEP', 'PGAE', 'PL', 'PN', 'PNM', 'PS', 'RECO', 'SCE', 'SCEN', 'SDGE', 'SECI', 'SOUT', 'SPRM', 'SPS', 'TSGT', 'VEA', 'WAUE', 'WEST', 'WFEC', 'WR', 'ZONA', 'ZONB', 'ZONC', 'ZOND', 'ZONE', 'ZONF', 'ZONG', 'ZONH', 'ZONI', 'ZONJ', 'ZONK'), nullable=False, comment='Code identifying subregions of larger balancing authorities.'),
    sa.Column('balancing_authority_subregion_name_eia', sa.Text(), nullable=True, comment='Name of the balancing authority subregion.'),
    sa.ForeignKeyConstraint(['balancing_authority_code_eia'], ['core_eia__codes_balancing_authorities.code'], name=op.f('fk_core_eia__codes_balancing_authority_subregions_balancing_authority_code_eia_core_eia__codes_balancing_authorities')),
    sa.PrimaryKeyConstraint('balancing_authority_code_eia', 'balancing_authority_subregion_code_eia', name=op.f('pk_core_eia__codes_balancing_authority_subregions'))
    )
    op.create_table('core_eia__entity_boilers',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('boiler_id', sa.Text(), nullable=False, comment='Alphanumeric boiler ID.'),
    sa.Column('boiler_manufacturer', sa.Text(), nullable=True, comment='Name of boiler manufacturer.'),
    sa.Column('boiler_manufacturer_code', sa.Text(), nullable=True, comment='EIA short code for boiler manufacturer.'),
    sa.ForeignKeyConstraint(['boiler_manufacturer_code'], ['core_eia__codes_environmental_equipment_manufacturers.code'], name=op.f('fk_core_eia__entity_boilers_boiler_manufacturer_code_core_eia__codes_environmental_equipment_manufacturers')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk_core_eia__entity_boilers_plant_id_eia_core_eia__entity_plants')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'boiler_id', name=op.f('pk_core_eia__entity_boilers'))
    )
    op.create_table('core_eia__entity_generators',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('duct_burners', sa.Boolean(), nullable=True, comment='Indicates whether the unit has duct-burners for supplementary firing of the turbine exhaust gas'),
    sa.Column('generator_operating_date', sa.Date(), nullable=True, comment='Date the generator began commercial operation. If harvested values are inconsistent, we default to using the most recently reported date.'),
    sa.Column('topping_bottoming_code', sa.Text(), nullable=True, comment='If the generator is associated with a combined heat and power system, indicates whether the generator is part of a topping cycle or a bottoming cycle'),
    sa.Column('solid_fuel_gasification', sa.Boolean(), nullable=True, comment='Indicates whether the generator is part of a solid fuel gasification system'),
    sa.Column('pulverized_coal_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses pulverized coal technology'),
    sa.Column('fluidized_bed_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses fluidized bed technology'),
    sa.Column('subcritical_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses subcritical technology'),
    sa.Column('supercritical_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses supercritical technology'),
    sa.Column('ultrasupercritical_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses ultra-supercritical technology'),
    sa.Column('stoker_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses stoker technology'),
    sa.Column('other_combustion_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses other combustion technologies'),
    sa.Column('bypass_heat_recovery', sa.Boolean(), nullable=True, comment='Can this generator operate while bypassing the heat recovery steam generator?'),
    sa.Column('rto_iso_lmp_node_id', sa.Text(), nullable=True, comment='The designation used to identify the price node in RTO/ISO Locational Marginal Price reports'),
    sa.Column('rto_iso_location_wholesale_reporting_id', sa.Text(), nullable=True, comment='The designation used to report ths specific location of the wholesale sales transactions to FERC for the Electric Quarterly Report'),
    sa.Column('associated_combined_heat_power', sa.Boolean(), nullable=True, comment='Indicates whether the generator is associated with a combined heat and power system'),
    sa.Column('original_planned_generator_operating_date', sa.Date(), nullable=True, comment='The date the generator was originally scheduled to be operational'),
    sa.Column('operating_switch', sa.Text(), nullable=True, comment='Indicates whether the fuel switching generator can switch when operating'),
    sa.Column('previously_canceled', sa.Boolean(), nullable=True, comment='Indicates whether the generator was previously reported as indefinitely postponed or canceled'),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk_core_eia__entity_generators_plant_id_eia_core_eia__entity_plants')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'generator_id', name=op.f('pk_core_eia__entity_generators'))
    )
    op.create_table('core_ferc714__yearly_planning_area_demand_forecast',
    sa.Column('respondent_id_ferc714', sa.Integer(), nullable=False, comment='FERC Form 714 respondent ID. Note that this ID does not correspond to FERC respondent IDs from other forms.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('forecast_year', sa.Integer(), nullable=False, comment='Four-digit year that applies to a particular forecasted value.'),
    sa.Column('summer_peak_demand_mw', sa.Float(), nullable=True, comment='The maximum hourly summer load (for the months of June through September) based on net energy for the system during the reporting year. Net energy for the system is the sum of energy an electric utility needs to satisfy their service area and includes full and partial wholesale requirements customers, and the losses experienced in delivery. The maximum hourly load is determined by the interval in which the 60-minute integrated demand is the greatest.'),
    sa.Column('winter_peak_demand_mw', sa.Float(), nullable=True, comment='The maximum hourly winter load (for the months of January through March) based on net energy for the system during the reporting year. Net energy for the system is the sum of energy an electric utility needs to satisfy their service area and includes full and partial wholesale requirements customers, and the losses experienced in delivery. The maximum hourly load is determined by the interval in which the 60-minute integrated demand is the greatest.'),
    sa.Column('net_demand_mwh', sa.Float(), nullable=True, comment='Net electricity demand for the specified period in megawatt-hours (MWh).'),
    sa.ForeignKeyConstraint(['respondent_id_ferc714'], ['core_ferc714__respondent_id.respondent_id_ferc714'], name=op.f('fk_core_ferc714__yearly_planning_area_demand_forecast_respondent_id_ferc714_core_ferc714__respondent_id')),
    sa.PrimaryKeyConstraint('respondent_id_ferc714', 'report_year', 'forecast_year', name=op.f('pk_core_ferc714__yearly_planning_area_demand_forecast'))
    )
    op.create_table('core_pudl__assn_eia_pudl_plants',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_core_pudl__assn_eia_pudl_plants_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.PrimaryKeyConstraint('plant_id_eia', name=op.f('pk_core_pudl__assn_eia_pudl_plants'))
    )
    op.create_table('core_pudl__assn_eia_pudl_utilities',
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_core_pudl__assn_eia_pudl_utilities_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_eia', name=op.f('pk_core_pudl__assn_eia_pudl_utilities'))
    )
    op.create_table('core_pudl__assn_ferc1_pudl_utilities',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_core_pudl__assn_ferc1_pudl_utilities_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', name=op.f('pk_core_pudl__assn_ferc1_pudl_utilities'))
    )
    op.create_table('core_pudl__assn_utilities_plants',
    sa.Column('utility_id_pudl', sa.Integer(), nullable=False, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=False, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_core_pudl__assn_utilities_plants_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_core_pudl__assn_utilities_plants_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_pudl', 'plant_id_pudl', name=op.f('pk_core_pudl__assn_utilities_plants'))
    )
    op.create_table('out_eia860__yearly_emissions_control_equipment',
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('emission_control_id_pudl', sa.Float(), nullable=False, comment='A PUDL-generated ID used to distinguish emission control units in the same report year and plant id. This ID should not be used to track units over time or between plants.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.Column('emission_control_equipment_type_code', sa.Text(), nullable=True, comment='Short code indicating the type of emission control equipment installed.'),
    sa.Column('operational_status_code', sa.Text(), nullable=True, comment='The operating status of the asset.'),
    sa.Column('operational_status', sa.Text(), nullable=True, comment='The operating status of the asset. For generators this is based on which tab the generator was listed in in EIA 860.'),
    sa.Column('mercury_control_id_eia', sa.Text(), nullable=True, comment='Mercury control identification number. This ID is not a unique identifier.'),
    sa.Column('nox_control_id_eia', sa.Text(), nullable=True, comment='Nitrogen oxide control identification number. This ID is not a unique identifier.'),
    sa.Column('particulate_control_id_eia', sa.Text(), nullable=True, comment='Particulate matter control identification number. This ID is not a unique identifier.'),
    sa.Column('so2_control_id_eia', sa.Text(), nullable=True, comment='Sulfur dioxide control identification number. This ID is not a unique identifier.'),
    sa.Column('acid_gas_control', sa.Boolean(), nullable=True, comment='Indicates whether the emissions control equipment controls acid (HCl) gas.'),
    sa.Column('emission_control_equipment_cost', sa.Float(), nullable=True, comment='The total cost to install a piece of emission control equipment.'),
    sa.Column('emission_control_operating_date', sa.Date(), nullable=True, comment='The date a piece of emissions control equipment began operating. Derived from month and year columns in the raw data.'),
    sa.Column('emission_control_retirement_date', sa.Date(), nullable=True, comment='The expected or actual retirement date for a piece of emissions control equipment. Derived from month and year columns in the raw data.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia860__yearly_emissions_control_equipment_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['emission_control_equipment_type_code'], ['core_eia__codes_emission_control_equipment_types.code'], name=op.f('fk_out_eia860__yearly_emissions_control_equipment_emission_control_equipment_type_code_core_eia__codes_emission_control_equipment_types')),
    sa.ForeignKeyConstraint(['operational_status_code'], ['core_eia__codes_operational_status.code'], name=op.f('fk_out_eia860__yearly_emissions_control_equipment_operational_status_code_core_eia__codes_operational_status')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk_out_eia860__yearly_emissions_control_equipment_plant_id_eia_core_eia__entity_plants')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia860__yearly_emissions_control_equipment_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_eia'], ['core_eia__entity_utilities.utility_id_eia'], name=op.f('fk_out_eia860__yearly_emissions_control_equipment_utility_id_eia_core_eia__entity_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia860__yearly_emissions_control_equipment_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('report_year', 'plant_id_eia', 'emission_control_id_pudl', name=op.f('pk_out_eia860__yearly_emissions_control_equipment'))
    )
    op.create_table('out_eia923__fuel_receipts_costs',
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=True, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('contract_type_code', sa.Enum('S', 'C', 'NC', 'T'), nullable=True, comment='Purchase type under which receipts occurred in the reporting month. C: Contract, NC: New Contract, S: Spot Purchase, T: Tolling Agreement.'),
    sa.Column('contract_expiration_date', sa.Date(), nullable=True, comment='Date contract expires.Format:  MMYY.'),
    sa.Column('energy_source_code', sa.Text(), nullable=True, comment='A 2-3 letter code indicating the energy source (e.g. fuel type) associated with the record.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_group_code', sa.Enum('petroleum', 'other_gas', 'petroleum_coke', 'natural_gas', 'coal'), nullable=True, comment='Fuel groups used in the Electric Power Monthly'),
    sa.Column('supplier_name', sa.Text(), nullable=True, comment='Company that sold the fuel to the plant or, in the case of Natural Gas, pipline owner.'),
    sa.Column('fuel_received_units', sa.Float(), nullable=True, comment='Quanity of fuel received in tons, barrel, or Mcf.'),
    sa.Column('fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Heat content of the fuel in millions of Btus per physical unit.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('bulk_agg_fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Fuel cost per mmbtu reported in the EIA bulk electricity data. This is an aggregate average fuel price for a whole state, region, month, sector, etc. Used to fill in missing fuel prices.'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('total_fuel_cost', sa.Float(), nullable=True, comment='Total annual reported fuel costs for the plant part. Includes costs from all fuels.'),
    sa.Column('fuel_cost_from_eiaapi', sa.Boolean(), nullable=True, comment='Indicates whether the fuel cost was derived from the EIA API.'),
    sa.Column('sulfur_content_pct', sa.Float(), nullable=True, comment='Sulfur content percentage by weight to the nearest 0.01 percent.'),
    sa.Column('ash_content_pct', sa.Float(), nullable=True, comment='Ash content percentage by weight to the nearest 0.1 percent.'),
    sa.Column('mercury_content_ppm', sa.Float(), nullable=True, comment='Mercury content in parts per million (ppm) to the nearest 0.001 ppm.'),
    sa.Column('primary_transportation_mode_code', sa.Text(), nullable=True, comment='Transportation mode for the longest distance transported.'),
    sa.Column('secondary_transportation_mode_code', sa.Text(), nullable=True, comment='Transportation mode for the second longest distance transported.'),
    sa.Column('natural_gas_transport_code', sa.Enum('firm', 'interruptible'), nullable=True, comment='Contract type for natural gas transportation service.'),
    sa.Column('natural_gas_delivery_contract_type_code', sa.Enum('firm', 'interruptible'), nullable=True, comment='Contract type for natrual gas delivery service:'),
    sa.Column('moisture_content_pct', sa.Float(), nullable=True, comment='For coal only: the moisture content of the fuel in terms of moisture percentage by weight. Reported to the nearest 0.01 percent.'),
    sa.Column('chlorine_content_ppm', sa.Float(), nullable=True, comment='For coal only: the chlorine content in parts per million (ppm) to the nearest 0.001 ppm. If lab tests of the coal do not include the chlorine content, this field contains the amount specified in the contract with the supplier.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.Column('mine_id_msha', sa.Integer(), nullable=True, comment='MSHA issued mine identifier.'),
    sa.Column('mine_name', sa.Text(), nullable=True, comment='Coal mine name.'),
    sa.Column('mine_state', sa.Text(), nullable=True, comment='State where the coal mine is located. Two letter abbreviation.'),
    sa.Column('coalmine_county_id_fips', sa.Text(), nullable=True, comment='County ID from the Federal Information Processing Standard Publication 6-4. This is the county where the coal mine is located.'),
    sa.Column('mine_type_code', sa.Text(), nullable=True, comment='Type of coal mine.'),
    sa.ForeignKeyConstraint(['contract_type_code'], ['core_eia__codes_contract_types.code'], name=op.f('fk_out_eia923__fuel_receipts_costs_contract_type_code_core_eia__codes_contract_types')),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia923__fuel_receipts_costs_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_code'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia923__fuel_receipts_costs_energy_source_code_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['mine_type_code'], ['core_eia__codes_coalmine_types.code'], name=op.f('fk_out_eia923__fuel_receipts_costs_mine_type_code_core_eia__codes_coalmine_types')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk_out_eia923__fuel_receipts_costs_plant_id_eia_core_eia__entity_plants')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia923__fuel_receipts_costs_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['primary_transportation_mode_code'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_out_eia923__fuel_receipts_costs_primary_transportation_mode_code_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['secondary_transportation_mode_code'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_out_eia923__fuel_receipts_costs_secondary_transportation_mode_code_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['utility_id_eia'], ['core_eia__entity_utilities.utility_id_eia'], name=op.f('fk_out_eia923__fuel_receipts_costs_utility_id_eia_core_eia__entity_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia923__fuel_receipts_costs_utility_id_pudl_core_pudl__entity_utilities_pudl'))
    )
    op.create_table('out_eia923__generation_fuel_combined',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('energy_source_code', sa.Text(), nullable=False, comment='A 2-3 letter code indicating the energy source (e.g. fuel type) associated with the record.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_type_code_agg', sa.Text(), nullable=True, comment='A partial aggregation of the reported fuel type codes into larger categories used by EIA in, for example, the Annual Energy Review (AER) or Monthly Energy Review (MER). Two or three letter alphanumeric.'),
    sa.Column('prime_mover_code', sa.Text(), nullable=False, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('fuel_consumed_units', sa.Float(), nullable=True, comment='Consumption of the fuel type in physical unit. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_consumed_for_electricity_units', sa.Float(), nullable=True, comment='Consumption for electric generation of the fuel type in physical unit.'),
    sa.Column('fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Heat content of the fuel in millions of Btus per physical unit.'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_consumed_for_electricity_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel to produce electricity, in physical unit, year to date.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia923__generation_fuel_combined_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_code'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia923__generation_fuel_combined_energy_source_code_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['fuel_type_code_agg'], ['core_eia__codes_fuel_types_agg.code'], name=op.f('fk_out_eia923__generation_fuel_combined_fuel_type_code_agg_core_eia__codes_fuel_types_agg')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk_out_eia923__generation_fuel_combined_plant_id_eia_core_eia__entity_plants')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia923__generation_fuel_combined_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_out_eia923__generation_fuel_combined_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['utility_id_eia'], ['core_eia__entity_utilities.utility_id_eia'], name=op.f('fk_out_eia923__generation_fuel_combined_utility_id_eia_core_eia__entity_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia923__generation_fuel_combined_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_date', 'prime_mover_code', 'energy_source_code', name=op.f('pk_out_eia923__generation_fuel_combined'))
    )
    op.create_table('out_eia923__monthly_fuel_receipts_costs',
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=True, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_received_units', sa.Float(), nullable=True, comment='Quanity of fuel received in tons, barrel, or Mcf.'),
    sa.Column('fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Heat content of the fuel in millions of Btus per physical unit.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('total_fuel_cost', sa.Float(), nullable=True, comment='Total annual reported fuel costs for the plant part. Includes costs from all fuels.'),
    sa.Column('fuel_cost_from_eiaapi', sa.Boolean(), nullable=True, comment='Indicates whether the fuel cost was derived from the EIA API.'),
    sa.Column('sulfur_content_pct', sa.Float(), nullable=True, comment='Sulfur content percentage by weight to the nearest 0.01 percent.'),
    sa.Column('ash_content_pct', sa.Float(), nullable=True, comment='Ash content percentage by weight to the nearest 0.1 percent.'),
    sa.Column('mercury_content_ppm', sa.Float(), nullable=True, comment='Mercury content in parts per million (ppm) to the nearest 0.001 ppm.'),
    sa.Column('moisture_content_pct', sa.Float(), nullable=True, comment='For coal only: the moisture content of the fuel in terms of moisture percentage by weight. Reported to the nearest 0.01 percent.'),
    sa.Column('chlorine_content_ppm', sa.Float(), nullable=True, comment='For coal only: the chlorine content in parts per million (ppm) to the nearest 0.001 ppm. If lab tests of the coal do not include the chlorine content, this field contains the amount specified in the contract with the supplier.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia923__monthly_fuel_receipts_costs_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk_out_eia923__monthly_fuel_receipts_costs_plant_id_eia_core_eia__entity_plants')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia923__monthly_fuel_receipts_costs_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_eia'], ['core_eia__entity_utilities.utility_id_eia'], name=op.f('fk_out_eia923__monthly_fuel_receipts_costs_utility_id_eia_core_eia__entity_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia923__monthly_fuel_receipts_costs_utility_id_pudl_core_pudl__entity_utilities_pudl'))
    )
    op.create_table('out_eia923__monthly_generation_fuel_combined',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('energy_source_code', sa.Text(), nullable=False, comment='A 2-3 letter code indicating the energy source (e.g. fuel type) associated with the record.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('prime_mover_code', sa.Text(), nullable=False, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('fuel_consumed_units', sa.Float(), nullable=True, comment='Consumption of the fuel type in physical unit. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_consumed_for_electricity_units', sa.Float(), nullable=True, comment='Consumption for electric generation of the fuel type in physical unit.'),
    sa.Column('fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Heat content of the fuel in millions of Btus per physical unit.'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_consumed_for_electricity_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel to produce electricity, in physical unit, year to date.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia923__monthly_generation_fuel_combined_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_code'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia923__monthly_generation_fuel_combined_energy_source_code_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk_out_eia923__monthly_generation_fuel_combined_plant_id_eia_core_eia__entity_plants')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia923__monthly_generation_fuel_combined_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_out_eia923__monthly_generation_fuel_combined_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['utility_id_eia'], ['core_eia__entity_utilities.utility_id_eia'], name=op.f('fk_out_eia923__monthly_generation_fuel_combined_utility_id_eia_core_eia__entity_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia923__monthly_generation_fuel_combined_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_date', 'prime_mover_code', 'energy_source_code', name=op.f('pk_out_eia923__monthly_generation_fuel_combined'))
    )
    op.create_table('out_ferc714__respondents_with_fips',
    sa.Column('eia_code', sa.Integer(), nullable=True, comment='EIA utility or balancing area authority ID associated with this FERC Form 714 respondent. Note that many utilities are also balancing authorities and in many cases EIA uses the same integer ID to identify a utility in its role as a balancing authority AND as a utility, but there is no requirement that these IDs be the same, and in a number of cases they are different.'),
    sa.Column('respondent_type', sa.Enum('utility', 'balancing_authority'), nullable=True, comment='Whether a respondent to the FERC form 714 is a utility or a balancing authority.'),
    sa.Column('respondent_id_ferc714', sa.Integer(), nullable=True, comment='FERC Form 714 respondent ID. Note that this ID does not correspond to FERC respondent IDs from other forms.'),
    sa.Column('respondent_name_ferc714', sa.Text(), nullable=True, comment='Name of the utility, balancing area authority, or planning authority responding to FERC Form 714.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('balancing_authority_id_eia', sa.Integer(), nullable=True, comment='EIA balancing authority ID. This is often (but not always!) the same as the utility ID associated with the same legal entity.'),
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=True, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('balancing_authority_name_eia', sa.Text(), nullable=True, comment='Name of the balancing authority.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('county', sa.Text(), nullable=True, comment='County name.'),
    sa.Column('state_id_fips', sa.Text(), nullable=True, comment='Two digit state FIPS code.'),
    sa.Column('county_id_fips', sa.Text(), nullable=True, comment='County ID from the Federal Information Processing Standard Publication 6-4.'),
    sa.ForeignKeyConstraint(['respondent_id_ferc714'], ['core_ferc714__respondent_id.respondent_id_ferc714'], name=op.f('fk_out_ferc714__respondents_with_fips_respondent_id_ferc714_core_ferc714__respondent_id'))
    )
    op.create_table('out_ferc714__summarized_demand',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('respondent_id_ferc714', sa.Integer(), nullable=False, comment='FERC Form 714 respondent ID. Note that this ID does not correspond to FERC respondent IDs from other forms.'),
    sa.Column('demand_annual_mwh', sa.Float(), nullable=True, comment='Annual electricity demand in a given report year.'),
    sa.Column('population', sa.Float(), nullable=True, comment='County population, sourced from Census DP1 data.'),
    sa.Column('area_km2', sa.Float(), nullable=True, comment='County area in km2.'),
    sa.Column('population_density_km2', sa.Float(), nullable=True, comment='Average population per sq. km area of a service territory.'),
    sa.Column('demand_annual_per_capita_mwh', sa.Float(), nullable=True, comment='Per-capita annual demand, averaged using Census county-level population estimates.'),
    sa.Column('demand_density_mwh_km2', sa.Float(), nullable=True, comment='Annual demand per km2 of a given service territory.'),
    sa.Column('eia_code', sa.Integer(), nullable=True, comment='EIA utility or balancing area authority ID associated with this FERC Form 714 respondent. Note that many utilities are also balancing authorities and in many cases EIA uses the same integer ID to identify a utility in its role as a balancing authority AND as a utility, but there is no requirement that these IDs be the same, and in a number of cases they are different.'),
    sa.Column('respondent_type', sa.Enum('utility', 'balancing_authority'), nullable=True, comment='Whether a respondent to the FERC form 714 is a utility or a balancing authority.'),
    sa.Column('respondent_name_ferc714', sa.Text(), nullable=True, comment='Name of the utility, balancing area authority, or planning authority responding to FERC Form 714.'),
    sa.Column('balancing_authority_id_eia', sa.Integer(), nullable=True, comment='EIA balancing authority ID. This is often (but not always!) the same as the utility ID associated with the same legal entity.'),
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=True, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('balancing_authority_name_eia', sa.Text(), nullable=True, comment='Name of the balancing authority.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.ForeignKeyConstraint(['respondent_id_ferc714'], ['core_ferc714__respondent_id.respondent_id_ferc714'], name=op.f('fk_out_ferc714__summarized_demand_respondent_id_ferc714_core_ferc714__respondent_id')),
    sa.PrimaryKeyConstraint('respondent_id_ferc714', 'report_date', name=op.f('pk_out_ferc714__summarized_demand'))
    )
    op.create_table('_out_eia__monthly_capacity_factor_by_generator',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('capacity_factor', sa.Float(), nullable=True, comment='Fraction of potential generation that was actually reported for a plant part.'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk__out_eia__monthly_capacity_factor_by_generator_plant_id_eia_core_eia__entity_generators')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk__out_eia__monthly_capacity_factor_by_generator'))
    )
    op.create_table('_out_eia__monthly_derived_generator_attributes',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('capacity_factor', sa.Float(), nullable=True, comment='Fraction of potential generation that was actually reported for a plant part.'),
    sa.Column('fuel_cost_from_eiaapi', sa.Boolean(), nullable=True, comment='Indicates whether the fuel cost was derived from the EIA API.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('fuel_cost_per_mwh', sa.Float(), nullable=True, comment='Derived from MCOE, a unit level value. Average fuel cost per MWh of heat content in nominal USD.'),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.Float(), nullable=True, comment='Fuel content per unit of electricity generated. Coming from MCOE calculation.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('total_fuel_cost', sa.Float(), nullable=True, comment='Total annual reported fuel costs for the plant part. Includes costs from all fuels.'),
    sa.Column('total_mmbtu', sa.Float(), nullable=True, comment='Total annual heat content of fuel consumed by a plant part record in the plant parts list.'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk__out_eia__monthly_derived_generator_attributes_plant_id_eia_core_eia__entity_generators')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk__out_eia__monthly_derived_generator_attributes'))
    )
    op.create_table('_out_eia__monthly_fuel_cost_by_generator',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('fuel_type_count', sa.Integer(), nullable=True, comment='A count of how many different simple energy sources there are associated with a generator.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_cost_from_eiaapi', sa.Boolean(), nullable=True, comment='Indicates whether the fuel cost was derived from the EIA API.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.Float(), nullable=True, comment='Fuel content per unit of electricity generated. Coming from MCOE calculation.'),
    sa.Column('fuel_cost_per_mwh', sa.Float(), nullable=True, comment='Derived from MCOE, a unit level value. Average fuel cost per MWh of heat content in nominal USD.'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk__out_eia__monthly_fuel_cost_by_generator_plant_id_eia_core_eia__entity_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk__out_eia__monthly_fuel_cost_by_generator_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_eia'], ['core_eia__entity_utilities.utility_id_eia'], name=op.f('fk__out_eia__monthly_fuel_cost_by_generator_utility_id_eia_core_eia__entity_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk__out_eia__monthly_fuel_cost_by_generator_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk__out_eia__monthly_fuel_cost_by_generator'))
    )
    op.create_table('_out_eia__monthly_heat_rate_by_generator',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.Float(), nullable=True, comment='Fuel content per unit of electricity generated. Coming from MCOE calculation.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_type_count', sa.Integer(), nullable=True, comment='A count of how many different simple energy sources there are associated with a generator.'),
    sa.Column('prime_mover_code', sa.Text(), nullable=True, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk__out_eia__monthly_heat_rate_by_generator_plant_id_eia_core_eia__entity_generators')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk__out_eia__monthly_heat_rate_by_generator_prime_mover_code_core_eia__codes_prime_movers')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk__out_eia__monthly_heat_rate_by_generator'))
    )
    op.create_table('core_eia860__scd_plants',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('ash_impoundment', sa.Boolean(), nullable=True, comment='Is there an ash impoundment (e.g. pond, reservoir) at the plant?'),
    sa.Column('ash_impoundment_lined', sa.Boolean(), nullable=True, comment='If there is an ash impoundment at the plant, is the impoundment lined?'),
    sa.Column('ash_impoundment_status', sa.Text(), nullable=True, comment='If there is an ash impoundment at the plant, the ash impoundment status as of December 31 of the reporting year.'),
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=True, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('balancing_authority_name_eia', sa.Text(), nullable=True, comment='Name of the balancing authority.'),
    sa.Column('datum', sa.Text(), nullable=True, comment='Geodetic coordinate system identifier (e.g. NAD27, NAD83, or WGS84).'),
    sa.Column('energy_storage', sa.Boolean(), nullable=True, comment='Indicates if the facility has energy storage capabilities.'),
    sa.Column('ferc_cogen_docket_no', sa.Text(), nullable=True, comment='The docket number relating to the FERC cogenerator status. See FERC Form 556.'),
    sa.Column('ferc_cogen_status', sa.Boolean(), nullable=True, comment='Indicates whether the plant has FERC qualifying facility cogenerator status. See FERC Form 556.'),
    sa.Column('ferc_exempt_wholesale_generator_docket_no', sa.Text(), nullable=True, comment='The docket number relating to the FERC qualifying facility exempt wholesale generator status.'),
    sa.Column('ferc_exempt_wholesale_generator', sa.Boolean(), nullable=True, comment='Indicates whether the plant has FERC qualifying facility exempt wholesale generator status'),
    sa.Column('ferc_small_power_producer_docket_no', sa.Text(), nullable=True, comment='The docket number relating to the FERC qualifying facility small power producer status. See FERC Form 556.'),
    sa.Column('ferc_small_power_producer', sa.Boolean(), nullable=True, comment='Indicates whether the plant has FERC qualifying facility small power producer status. See FERC Form 556.'),
    sa.Column('ferc_qualifying_facility_docket_no', sa.Text(), nullable=True, comment='The docket number relating to the FERC qualifying facility cogenerator status. See FERC Form 556.'),
    sa.Column('grid_voltage_1_kv', sa.Float(), nullable=True, comment="Plant's grid voltage at point of interconnection to transmission or distibution facilities"),
    sa.Column('grid_voltage_2_kv', sa.Float(), nullable=True, comment="Plant's grid voltage at point of interconnection to transmission or distibution facilities"),
    sa.Column('grid_voltage_3_kv', sa.Float(), nullable=True, comment="Plant's grid voltage at point of interconnection to transmission or distibution facilities"),
    sa.Column('iso_rto_code', sa.Text(), nullable=True, comment="The code of the plant's ISO or RTO. NA if not reported in that year."),
    sa.Column('liquefied_natural_gas_storage', sa.Boolean(), nullable=True, comment='Indicates if the facility have the capability to store the natural gas in the form of liquefied natural gas.'),
    sa.Column('natural_gas_local_distribution_company', sa.Text(), nullable=True, comment='Names of Local Distribution Company (LDC), connected to natural gas burning power plants.'),
    sa.Column('natural_gas_storage', sa.Boolean(), nullable=True, comment='Indicates if the facility have on-site storage of natural gas.'),
    sa.Column('natural_gas_pipeline_name_1', sa.Text(), nullable=True, comment='The name of the owner or operator of natural gas pipeline that connects directly to this facility or that connects to a lateral pipeline owned by this facility.'),
    sa.Column('natural_gas_pipeline_name_2', sa.Text(), nullable=True, comment='The name of the owner or operator of natural gas pipeline that connects directly to this facility or that connects to a lateral pipeline owned by this facility.'),
    sa.Column('natural_gas_pipeline_name_3', sa.Text(), nullable=True, comment='The name of the owner or operator of natural gas pipeline that connects directly to this facility or that connects to a lateral pipeline owned by this facility.'),
    sa.Column('nerc_region', sa.Enum('BASN', 'CALN', 'CALS', 'DSW', 'ASCC', 'ISONE', 'ERCOT', 'NORW', 'NYISO', 'PJM', 'ROCK', 'ECAR', 'FRCC', 'HICC', 'MAAC', 'MAIN', 'MAPP', 'MRO', 'NPCC', 'RFC', 'SERC', 'SPP', 'TRE', 'WECC', 'WSCC', 'MISO', 'ECAR_MAAC', 'MAPP_WECC', 'RFC_SERC', 'SPP_WECC', 'MRO_WECC', 'ERCOT_SPP', 'SPP_TRE', 'ERCOT_TRE', 'MISO_TRE', 'VI', 'GU', 'PR', 'AS', 'UNK'), nullable=True, comment='NERC region in which the plant is located'),
    sa.Column('has_net_metering', sa.Boolean(), nullable=True, comment='Whether the plant has a net metering agreement in effect during the reporting year.  (Only displayed for facilities that report the sun or wind as an energy source). This field was only reported up until 2015'),
    sa.Column('pipeline_notes', sa.Text(), nullable=True, comment='Additional owner or operator of natural gas pipeline.'),
    sa.Column('primary_purpose_id_naics', sa.Integer(), nullable=True, comment='North American Industry Classification System (NAICS) code that best describes the primary purpose of the reporting plant'),
    sa.Column('regulatory_status_code', sa.Text(), nullable=True, comment='Indicates whether the plant is regulated or non-regulated.'),
    sa.Column('reporting_frequency_code', sa.Enum('A', 'AM', 'M'), nullable=True, comment='Code that specifies what time period data has to be reported (i.e. monthly data or annual totals) and how often the power plant reports this data to EIA. See reporting_frequencies_eia for more details.'),
    sa.Column('sector_id_eia', sa.Integer(), nullable=True, comment='EIA assigned sector ID, corresponding to high level NAICS sector, designated by the primary purpose, regulatory status and plant-level combined heat and power status'),
    sa.Column('sector_name_eia', sa.Text(), nullable=True, comment='EIA assigned sector name, corresponding to high level NAICS sector, designated by the primary purpose, regulatory status and plant-level combined heat and power status'),
    sa.Column('service_area', sa.Text(), nullable=True, comment="Service area in which plant is located; for unregulated companies, it's the electric utility with which plant is interconnected"),
    sa.Column('transmission_distribution_owner_id', sa.Integer(), nullable=True, comment='EIA-assigned code for owner of transmission/distribution system to which the plant is interconnected.'),
    sa.Column('transmission_distribution_owner_name', sa.Text(), nullable=True, comment='Name of the owner of the transmission or distribution system to which the plant is interconnected.'),
    sa.Column('transmission_distribution_owner_state', sa.Text(), nullable=True, comment='State location for owner of transmission/distribution system to which the plant is interconnected.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('water_source', sa.Text(), nullable=True, comment='Name of water source associated with the plant.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['balancing_authority_code_eia'], ['core_eia__codes_balancing_authorities.code'], name=op.f('fk_core_eia860__scd_plants_balancing_authority_code_eia_core_eia__codes_balancing_authorities')),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia860__scd_plants_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk_core_eia860__scd_plants_plant_id_eia_core_eia__entity_plants')),
    sa.ForeignKeyConstraint(['reporting_frequency_code'], ['core_eia__codes_reporting_frequencies.code'], name=op.f('fk_core_eia860__scd_plants_reporting_frequency_code_core_eia__codes_reporting_frequencies')),
    sa.ForeignKeyConstraint(['sector_id_eia'], ['core_eia__codes_sector_consolidated.code'], name=op.f('fk_core_eia860__scd_plants_sector_id_eia_core_eia__codes_sector_consolidated')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk_core_eia860__scd_plants_utility_id_eia_core_eia860__scd_utilities')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_date', name=op.f('pk_core_eia860__scd_plants'))
    )
    op.create_table('core_eia923__monthly_boiler_fuel',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('boiler_id', sa.Text(), nullable=False, comment='Alphanumeric boiler ID.'),
    sa.Column('energy_source_code', sa.Text(), nullable=False, comment='A 2-3 letter code indicating the energy source (e.g. fuel type) associated with the record.'),
    sa.Column('prime_mover_code', sa.Text(), nullable=False, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('fuel_consumed_units', sa.Float(), nullable=True, comment='Consumption of the fuel type in physical unit. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Heat content of the fuel in millions of Btus per physical unit.'),
    sa.Column('sulfur_content_pct', sa.Float(), nullable=True, comment='Sulfur content percentage by weight to the nearest 0.01 percent.'),
    sa.Column('ash_content_pct', sa.Float(), nullable=True, comment='Ash content percentage by weight to the nearest 0.1 percent.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia923__monthly_boiler_fuel_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_code'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia923__monthly_boiler_fuel_energy_source_code_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'boiler_id'], ['core_eia__entity_boilers.plant_id_eia', 'core_eia__entity_boilers.boiler_id'], name=op.f('fk_core_eia923__monthly_boiler_fuel_plant_id_eia_core_eia__entity_boilers')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_core_eia923__monthly_boiler_fuel_prime_mover_code_core_eia__codes_prime_movers')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'boiler_id', 'energy_source_code', 'prime_mover_code', 'report_date', name=op.f('pk_core_eia923__monthly_boiler_fuel'))
    )
    op.create_table('core_eia923__monthly_fuel_receipts_costs',
    sa.Column('plant_id_eia', sa.Integer(), nullable=True, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('contract_type_code', sa.Enum('S', 'C', 'NC', 'T'), nullable=True, comment='Purchase type under which receipts occurred in the reporting month. C: Contract, NC: New Contract, S: Spot Purchase, T: Tolling Agreement.'),
    sa.Column('contract_expiration_date', sa.Date(), nullable=True, comment='Date contract expires.Format:  MMYY.'),
    sa.Column('energy_source_code', sa.Text(), nullable=True, comment='A 2-3 letter code indicating the energy source (e.g. fuel type) associated with the record.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_group_code', sa.Enum('petroleum', 'other_gas', 'petroleum_coke', 'natural_gas', 'coal'), nullable=True, comment='Fuel groups used in the Electric Power Monthly'),
    sa.Column('mine_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL mine identifier.'),
    sa.Column('supplier_name', sa.Text(), nullable=True, comment='Company that sold the fuel to the plant or, in the case of Natural Gas, pipline owner.'),
    sa.Column('fuel_received_units', sa.Float(), nullable=True, comment='Quanity of fuel received in tons, barrel, or Mcf.'),
    sa.Column('fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Heat content of the fuel in millions of Btus per physical unit.'),
    sa.Column('sulfur_content_pct', sa.Float(), nullable=True, comment='Sulfur content percentage by weight to the nearest 0.01 percent.'),
    sa.Column('ash_content_pct', sa.Float(), nullable=True, comment='Ash content percentage by weight to the nearest 0.1 percent.'),
    sa.Column('mercury_content_ppm', sa.Float(), nullable=True, comment='Mercury content in parts per million (ppm) to the nearest 0.001 ppm.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('primary_transportation_mode_code', sa.Text(), nullable=True, comment='Transportation mode for the longest distance transported.'),
    sa.Column('secondary_transportation_mode_code', sa.Text(), nullable=True, comment='Transportation mode for the second longest distance transported.'),
    sa.Column('natural_gas_transport_code', sa.Enum('firm', 'interruptible'), nullable=True, comment='Contract type for natural gas transportation service.'),
    sa.Column('natural_gas_delivery_contract_type_code', sa.Enum('firm', 'interruptible'), nullable=True, comment='Contract type for natrual gas delivery service:'),
    sa.Column('moisture_content_pct', sa.Float(), nullable=True, comment='For coal only: the moisture content of the fuel in terms of moisture percentage by weight. Reported to the nearest 0.01 percent.'),
    sa.Column('chlorine_content_ppm', sa.Float(), nullable=True, comment='For coal only: the chlorine content in parts per million (ppm) to the nearest 0.001 ppm. If lab tests of the coal do not include the chlorine content, this field contains the amount specified in the contract with the supplier.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['contract_type_code'], ['core_eia__codes_contract_types.code'], name=op.f('fk_core_eia923__monthly_fuel_receipts_costs_contract_type_code_core_eia__codes_contract_types')),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia923__monthly_fuel_receipts_costs_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_code'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia923__monthly_fuel_receipts_costs_energy_source_code_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['mine_id_pudl'], ['core_eia923__entity_coalmine.mine_id_pudl'], name=op.f('fk_core_eia923__monthly_fuel_receipts_costs_mine_id_pudl_core_eia923__entity_coalmine')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk_core_eia923__monthly_fuel_receipts_costs_plant_id_eia_core_eia__entity_plants')),
    sa.ForeignKeyConstraint(['primary_transportation_mode_code'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_core_eia923__monthly_fuel_receipts_costs_primary_transportation_mode_code_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['secondary_transportation_mode_code'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_core_eia923__monthly_fuel_receipts_costs_secondary_transportation_mode_code_core_eia__codes_fuel_transportation_modes'))
    )
    op.create_table('core_eia923__monthly_generation',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia923__monthly_generation_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk_core_eia923__monthly_generation_plant_id_eia_core_eia__entity_generators')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'generator_id', 'report_date', name=op.f('pk_core_eia923__monthly_generation'))
    )
    op.create_table('core_epa__assn_eia_epacamd',
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('plant_id_epa', sa.Integer(), nullable=True, comment='The ORISPL ID used by EPA to refer to the plant. Usually but not always the same as plant_id_eia.'),
    sa.Column('emissions_unit_id_epa', sa.Text(), nullable=True, comment='Emissions (smokestack) unit monitored by EPA CEMS.'),
    sa.Column('generator_id_epa', sa.Text(), nullable=True, comment='Generator ID used by the EPA.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=True, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('boiler_id', sa.Text(), nullable=True, comment='Alphanumeric boiler ID.'),
    sa.Column('generator_id', sa.Text(), nullable=True, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'boiler_id'], ['core_eia__entity_boilers.plant_id_eia', 'core_eia__entity_boilers.boiler_id'], name=op.f('fk_core_epa__assn_eia_epacamd_plant_id_eia_core_eia__entity_boilers')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk_core_epa__assn_eia_epacamd_plant_id_eia_core_eia__entity_generators'))
    )
    op.create_table('core_ferc1__yearly_balance_sheet_assets_sched110',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('asset_type', sa.Text(), nullable=False, comment='Type of asset being reported to the core_ferc1__yearly_balance_sheet_assets_sched110 table.'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('starting_balance', sa.Float(), nullable=True, comment='Account balance at beginning of year.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('balance', sa.Text(), nullable=True, comment='Indication of whether a column is a credit or debit, as reported in the XBRL taxonomy.'),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_balance_sheet_assets_sched110_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'asset_type', name=op.f('pk_core_ferc1__yearly_balance_sheet_assets_sched110'))
    )
    op.create_table('core_ferc1__yearly_balance_sheet_liabilities_sched110',
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('starting_balance', sa.Float(), nullable=True, comment='Account balance at beginning of year.'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('liability_type', sa.Text(), nullable=False, comment='Type of liability being reported to the core_ferc1__yearly_balance_sheet_liabilities_sched110 table.'),
    sa.Column('balance', sa.Text(), nullable=True, comment='Indication of whether a column is a credit or debit, as reported in the XBRL taxonomy.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_balance_sheet_liabilities_sched110_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'liability_type', name=op.f('pk_core_ferc1__yearly_balance_sheet_liabilities_sched110'))
    )
    op.create_table('core_ferc1__yearly_cash_flows_sched120',
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('amount_type', sa.Text(), nullable=False, comment='Label describing the type of amount being reported. This could be a balance or a change in value.'),
    sa.Column('amount', sa.Float(), nullable=True, comment='Reported amount of dollars. This could be a balance or a change in value.'),
    sa.Column('balance', sa.Text(), nullable=True, comment='Indication of whether a column is a credit or debit, as reported in the XBRL taxonomy.'),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_cash_flows_sched120_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'amount_type', name=op.f('pk_core_ferc1__yearly_cash_flows_sched120'))
    )
    op.create_table('core_ferc1__yearly_depreciation_by_function_sched219',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('depreciation_type', sa.Text(), nullable=False, comment='Type of depreciation provision within FERC Account 108, including cost ofremoval, depreciation expenses, salvage, cost of retired plant, etc.'),
    sa.Column('plant_function', sa.Text(), nullable=False, comment='Functional role played by utility plant (steam production, nuclear production, distribution, transmission, etc.).'),
    sa.Column('plant_status', sa.Text(), nullable=False, comment='Utility plant financial status (in service, future, leased, total).'),
    sa.Column('utility_type', sa.Text(), nullable=False, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('balance', sa.Text(), nullable=True, comment='Indication of whether a column is a credit or debit, as reported in the XBRL taxonomy.'),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_depreciation_by_function_sched219_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'depreciation_type', 'plant_function', 'plant_status', 'utility_type', name=op.f('pk_core_ferc1__yearly_depreciation_by_function_sched219'))
    )
    op.create_table('core_ferc1__yearly_depreciation_changes_sched219',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('depreciation_type', sa.Text(), nullable=False, comment='Type of depreciation provision within FERC Account 108, including cost ofremoval, depreciation expenses, salvage, cost of retired plant, etc.'),
    sa.Column('plant_status', sa.Text(), nullable=False, comment='Utility plant financial status (in service, future, leased, total).'),
    sa.Column('utility_type', sa.Text(), nullable=False, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('dollar_value', sa.Float(), nullable=True, comment='Dollar value of reported income, expense, asset, or liability.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('balance', sa.Text(), nullable=True, comment='Indication of whether a column is a credit or debit, as reported in the XBRL taxonomy.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_depreciation_changes_sched219_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'depreciation_type', 'plant_status', 'utility_type', name=op.f('pk_core_ferc1__yearly_depreciation_changes_sched219'))
    )
    op.create_table('core_ferc1__yearly_depreciation_summary_sched336',
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('plant_function', sa.Text(), nullable=False, comment='Functional role played by utility plant (steam production, nuclear production, distribution, transmission, etc.).'),
    sa.Column('ferc_account_label', sa.Text(), nullable=False, comment='Long FERC account identifier derived from values reported in the XBRL taxonomies. May also refer to aggregations of individual FERC accounts.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('dollar_value', sa.Float(), nullable=True, comment='Dollar value of reported income, expense, asset, or liability.'),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_depreciation_summary_sched336_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'plant_function', 'ferc_account_label', name=op.f('pk_core_ferc1__yearly_depreciation_summary_sched336'))
    )
    op.create_table('core_ferc1__yearly_energy_dispositions_sched401',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('energy_disposition_type', sa.Text(), nullable=False, comment='Type of energy disposition reported in the core_ferc1__yearly_energy_dispositions_sched401. Dispositions include sales to customers, re-sales of energy, energy used internally, losses, etc.'),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.Column('energy_mwh', sa.Float(), nullable=True, comment='Sources and uses of energy in MWh.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_energy_dispositions_sched401_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'energy_disposition_type', name=op.f('pk_core_ferc1__yearly_energy_dispositions_sched401'))
    )
    op.create_table('core_ferc1__yearly_energy_sources_sched401',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('energy_source_type', sa.Text(), nullable=False, comment='Type of energy source reported in the core_ferc1__yearly_energy_sources_sched401 table. There are three groups of energy sources: generation, power exchanges and transmission.'),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.Column('energy_mwh', sa.Float(), nullable=True, comment='Sources and uses of energy in MWh.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_energy_sources_sched401_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'energy_source_type', name=op.f('pk_core_ferc1__yearly_energy_sources_sched401'))
    )
    op.create_table('core_ferc1__yearly_income_statements_sched114',
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_type', sa.Text(), nullable=False, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('income_type', sa.Text(), nullable=False, comment='Type of income reported in income_statement_ferc1 table.'),
    sa.Column('dollar_value', sa.Float(), nullable=True, comment='Dollar value of reported income, expense, asset, or liability.'),
    sa.Column('balance', sa.Text(), nullable=True, comment='Indication of whether a column is a credit or debit, as reported in the XBRL taxonomy.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_income_statements_sched114_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'utility_type', 'income_type', name=op.f('pk_core_ferc1__yearly_income_statements_sched114'))
    )
    op.create_table('core_ferc1__yearly_operating_expenses_sched320',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('dollar_value', sa.Float(), nullable=True, comment='Dollar value of reported income, expense, asset, or liability.'),
    sa.Column('expense_type', sa.Text(), nullable=False, comment='The type of expense.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_operating_expenses_sched320_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'expense_type', name=op.f('pk_core_ferc1__yearly_operating_expenses_sched320'))
    )
    op.create_table('core_ferc1__yearly_operating_revenues_sched300',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('revenue_type', sa.Text(), nullable=False, comment='Label describing types of revenues.'),
    sa.Column('dollar_value', sa.Float(), nullable=True, comment='Dollar value of reported income, expense, asset, or liability.'),
    sa.Column('sales_mwh', sa.Float(), nullable=True, comment='Quantity of electricity sold in MWh.'),
    sa.Column('avg_customers_per_month', sa.Float(), nullable=True, comment='Average number of customers per month.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_operating_revenues_sched300_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'revenue_type', name=op.f('pk_core_ferc1__yearly_operating_revenues_sched300'))
    )
    op.create_table('core_ferc1__yearly_other_regulatory_liabilities_sched278',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('starting_balance', sa.Float(), nullable=True, comment='Account balance at beginning of year.'),
    sa.Column('increase_in_other_regulatory_liabilities', sa.Float(), nullable=True, comment='The increase during the reporting period of other regulatory liabilities.'),
    sa.Column('account_detail', sa.Text(), nullable=True, comment='Description of the account number credited from making debit adjustment to other regulatory liabilities.'),
    sa.Column('decrease_in_other_regulatory_liabilities', sa.Float(), nullable=True, comment='The decrease during the reporting period of other regulatory liabilities.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_other_regulatory_liabilities_sched278_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities'))
    )
    op.create_table('core_ferc1__yearly_plant_in_service_sched204',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('ferc_account_label', sa.Text(), nullable=False, comment='Long FERC account identifier derived from values reported in the XBRL taxonomies. May also refer to aggregations of individual FERC accounts.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.Column('starting_balance', sa.Float(), nullable=True, comment='Account balance at beginning of year.'),
    sa.Column('additions', sa.Float(), nullable=True, comment='Cost of acquisition of items classified within the account.'),
    sa.Column('retirements', sa.Float(), nullable=True, comment='Cost of disposal of items classified within the account.'),
    sa.Column('adjustments', sa.Float(), nullable=True, comment='Cost of adjustments to the account.'),
    sa.Column('transfers', sa.Float(), nullable=True, comment='Cost of transfers into (out of) the account.'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('plant_status', sa.Text(), nullable=True, comment='Utility plant financial status (in service, future, leased, total).'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_plant_in_service_sched204_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'ferc_account_label', name=op.f('pk_core_ferc1__yearly_plant_in_service_sched204'))
    )
    op.create_table('core_ferc1__yearly_purchased_power_and_exchanges_sched326',
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('seller_name', sa.Text(), nullable=True, comment='Name of the seller, or the other party in an exchange transaction.'),
    sa.Column('purchase_type_code', sa.Text(), nullable=True, comment="Categorization based on the original contractual terms and conditions of the service. Must be one of 'requirements', 'long_firm', 'intermediate_firm', 'short_firm', 'long_unit', 'intermediate_unit', 'electricity_exchange', 'other_service', or 'adjustment'. Requirements service is ongoing high reliability service, with load integrated into system resource planning. 'Long term' means 5+ years. 'Intermediate term' is 1-5 years. 'Short term' is less than 1 year. 'Firm' means not interruptible for economic reasons. 'unit' indicates service from a particular designated generating unit. 'exchange' is an in-kind transaction."),
    sa.Column('tariff', sa.Text(), nullable=True, comment='FERC Rate Schedule Number or Tariff. (Note: may be incomplete if originally reported on multiple lines.)'),
    sa.Column('billing_demand_mw', sa.Float(), nullable=True, comment='Monthly average billing demand (for requirements purchases, and any transactions involving demand charges). In megawatts.'),
    sa.Column('non_coincident_peak_demand_mw', sa.Float(), nullable=True, comment='Average monthly non-coincident peak (NCP) demand (for requirements purhcases, and any transactions involving demand charges). Monthly NCP demand is the maximum metered hourly (60-minute integration) demand in a month. In megawatts.'),
    sa.Column('coincident_peak_demand_mw', sa.Float(), nullable=True, comment="Average monthly coincident peak (CP) demand (for requirements purchases, and any transactions involving demand charges). Monthly CP demand is the metered demand during the hour (60-minute integration) in which the supplier's system reaches its monthly peak. In megawatts."),
    sa.Column('purchased_mwh', sa.Float(), nullable=True, comment='Megawatt-hours shown on bills rendered to the respondent. Includes both electricity purchased for storage and non-storage purposes, which were lumped together prior to 2021.'),
    sa.Column('purchased_storage_mwh', sa.Float(), nullable=True, comment='Number of megawatt hours purchased during the period for energy storage.'),
    sa.Column('purchased_other_than_storage_mwh', sa.Float(), nullable=True, comment='Number of megawatt hours purchased during the period for other than energy storage.'),
    sa.Column('received_mwh', sa.Float(), nullable=True, comment='Gross megawatt-hours received in power exchanges and used as the basis for settlement.'),
    sa.Column('delivered_mwh', sa.Float(), nullable=True, comment='Gross megawatt-hours delivered in power exchanges and used as the basis for settlement.'),
    sa.Column('demand_charges', sa.Float(), nullable=True, comment='Demand charges (USD).'),
    sa.Column('energy_charges', sa.Float(), nullable=True, comment='Energy charges (USD).'),
    sa.Column('other_charges', sa.Float(), nullable=True, comment='Other charges, including out-of-period adjustments (USD).'),
    sa.Column('total_settlement', sa.Float(), nullable=True, comment='Sum of demand, energy, and other charges (USD). For power exchanges, the settlement amount for the net receipt of energy. If more energy was delivered than received, this amount is negative.'),
    sa.ForeignKeyConstraint(['purchase_type_code'], ['core_ferc1__codes_power_purchase_types.code'], name=op.f('fk_core_ferc1__yearly_purchased_power_and_exchanges_sched326_purchase_type_code_core_ferc1__codes_power_purchase_types')),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_purchased_power_and_exchanges_sched326_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities'))
    )
    op.create_table('core_ferc1__yearly_retained_earnings_sched118',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('earnings_type', sa.Text(), nullable=False, comment='Label describing types of earnings.'),
    sa.Column('starting_balance', sa.Float(), nullable=True, comment='Account balance at beginning of year.'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('balance', sa.Text(), nullable=True, comment='Indication of whether a column is a credit or debit, as reported in the XBRL taxonomy.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_retained_earnings_sched118_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'earnings_type', name=op.f('pk_core_ferc1__yearly_retained_earnings_sched118'))
    )
    op.create_table('core_ferc1__yearly_sales_by_rate_schedules_sched304',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('rate_schedule_type', sa.Text(), nullable=True, comment='Categorization of rate schedule type.'),
    sa.Column('billing_status', sa.Text(), nullable=True, comment='Whether an amount is billed, unbilled, or both. Billed amounts pertain to the exchange of energy and unbilled amounts pertain to other sources of revenue such as contracts with peaker plants to keep them on standby or charging rent to host cell antennas on transmission towers.'),
    sa.Column('rate_schedule_description', sa.Text(), nullable=True, comment='Free-form description of what the rate schedule name is. Not standardized. Often a sub-category of rate_schedule_type.'),
    sa.Column('sales_mwh', sa.Float(), nullable=True, comment='Quantity of electricity sold in MWh.'),
    sa.Column('dollar_value', sa.Float(), nullable=True, comment='Dollar value of reported income, expense, asset, or liability.'),
    sa.Column('avg_customers_per_month', sa.Float(), nullable=True, comment='Average number of customers per month.'),
    sa.Column('kwh_per_customer', sa.Float(), nullable=True, comment='kWh per customer.'),
    sa.Column('revenue_per_kwh', sa.Float(), nullable=True, comment='The amount of revenue per kWh by rate schedule aquired in the given report year.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_sales_by_rate_schedules_sched304_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities'))
    )
    op.create_table('core_ferc1__yearly_transmission_lines_sched422',
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('start_point', sa.Text(), nullable=True, comment='The starting point of a transmission line.'),
    sa.Column('end_point', sa.Text(), nullable=True, comment='The end point of a transmission line.'),
    sa.Column('operating_voltage_kv', sa.Float(), nullable=True, comment='The operating voltage, expressed kilo-volts, for three-phase 60 cycle alternative current transmission lines.'),
    sa.Column('designed_voltage_kv', sa.Float(), nullable=True, comment='Manufactured (Designed) voltage, expressed in kilo-volts, for three-phase 60 cycle alternative current transmission lines'),
    sa.Column('supporting_structure_type', sa.Text(), nullable=True, comment='Supporting structure of the transmission line.'),
    sa.Column('transmission_line_length_miles', sa.Float(), nullable=True, comment='Length (in pole miles or circuit miles (if transmission lines are underground)) for lines that are stand alone structures (whose cost are reported on a stand-alone basis).'),
    sa.Column('transmission_line_and_structures_length_miles', sa.Float(), nullable=True, comment='Length (in pole miles or circuit miles (if transmission lines are underground)) for lines that are agrregated with other lines / structures (whose cost are aggregated and combined with other structures).'),
    sa.Column('num_transmission_circuits', sa.Integer(), nullable=True, comment='Number of circuits in a transmission line.'),
    sa.Column('conductor_size_and_material', sa.Text(), nullable=True, comment='Size of transmission conductor and material of the transmission line.'),
    sa.Column('capex_land', sa.Float(), nullable=True, comment='Cost of Land and land rights for the transmission line.'),
    sa.Column('capex_other', sa.Float(), nullable=True, comment='Construction and other costs for the transmission line.'),
    sa.Column('capex_total', sa.Float(), nullable=True, comment='Total costs for the transmission line.'),
    sa.Column('opex_operations', sa.Float(), nullable=True, comment='Operating expenses for the transmission line.'),
    sa.Column('opex_maintenance', sa.Float(), nullable=True, comment='Maintenance expenses for the transmission line.'),
    sa.Column('opex_rents', sa.Float(), nullable=True, comment='Rent expenses for the transmission line.'),
    sa.Column('opex_total', sa.Float(), nullable=True, comment='Overall expenses for the transmission line.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_transmission_lines_sched422_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities'))
    )
    op.create_table('core_ferc1__yearly_utility_plant_summary_sched200',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_type', sa.Text(), nullable=False, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('utility_type_other', sa.Text(), nullable=True, comment='Freeform description of type of utility reported in one of the other three other utility_type sections in the core_ferc1__yearly_utility_plant_summary_sched200 table. This field is reported only in the DBF reporting years (1994-2020).'),
    sa.Column('utility_plant_asset_type', sa.Text(), nullable=False, comment='Type of utility plant asset reported in the core_ferc1__yearly_utility_plant_summary_sched200 table. Assets include those leased to others, held for future use, construction work-in-progress and details of accumulated depreciation.'),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_ferc1__yearly_utility_plant_summary_sched200_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'utility_type', 'utility_plant_asset_type', name=op.f('pk_core_ferc1__yearly_utility_plant_summary_sched200'))
    )
    op.create_table('core_gridpathratoolkit__assn_generator_aggregation_group',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('aggregation_group', sa.Text(), nullable=True, comment='A label identifying a group of aggregated generator capacity factors.'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('include_generator', sa.Boolean(), nullable=True, comment='Every row in the aggregation table describes a single generator. Groups of rows with the same aggregation are combined using a capacity weighted average to produce an aggregate generation profile. A few generators are not included in that aggregation process. This column determines whether a generator is included.'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk_core_gridpathratoolkit__assn_generator_aggregation_group_plant_id_eia_core_eia__entity_generators')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'generator_id', name=op.f('pk_core_gridpathratoolkit__assn_generator_aggregation_group'))
    )
    op.create_table('core_pudl__assn_ferc1_dbf_pudl_utilities',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=False, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_pudl__assn_ferc1_dbf_pudl_utilities_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1_dbf', name=op.f('pk_core_pudl__assn_ferc1_dbf_pudl_utilities'))
    )
    op.create_table('core_pudl__assn_ferc1_pudl_plants',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('plant_name_ferc1', sa.Text(), nullable=False, comment='Name of the plant, as reported to FERC. This is a freeform string, not guaranteed to be consistent across references to the same plant.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_core_pudl__assn_ferc1_pudl_plants_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_pudl__assn_ferc1_pudl_plants_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'plant_name_ferc1', name=op.f('pk_core_pudl__assn_ferc1_pudl_plants'))
    )
    op.create_table('core_pudl__assn_ferc1_xbrl_pudl_utilities',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=False, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_core_pudl__assn_ferc1_xbrl_pudl_utilities_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.PrimaryKeyConstraint('utility_id_ferc1_xbrl', name=op.f('pk_core_pudl__assn_ferc1_xbrl_pudl_utilities'))
    )
    op.create_table('out_eia923__boiler_fuel',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('boiler_id', sa.Text(), nullable=False, comment='Alphanumeric boiler ID.'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('energy_source_code', sa.Text(), nullable=False, comment='A 2-3 letter code indicating the energy source (e.g. fuel type) associated with the record.'),
    sa.Column('prime_mover_code', sa.Text(), nullable=False, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_consumed_units', sa.Float(), nullable=True, comment='Consumption of the fuel type in physical unit. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Heat content of the fuel in millions of Btus per physical unit.'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('sulfur_content_pct', sa.Float(), nullable=True, comment='Sulfur content percentage by weight to the nearest 0.01 percent.'),
    sa.Column('ash_content_pct', sa.Float(), nullable=True, comment='Ash content percentage by weight to the nearest 0.1 percent.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia923__boiler_fuel_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_code'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia923__boiler_fuel_energy_source_code_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'boiler_id'], ['core_eia__entity_boilers.plant_id_eia', 'core_eia__entity_boilers.boiler_id'], name=op.f('fk_out_eia923__boiler_fuel_plant_id_eia_core_eia__entity_boilers')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia923__boiler_fuel_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_out_eia923__boiler_fuel_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['utility_id_eia'], ['core_eia__entity_utilities.utility_id_eia'], name=op.f('fk_out_eia923__boiler_fuel_utility_id_eia_core_eia__entity_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia923__boiler_fuel_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'boiler_id', 'energy_source_code', 'prime_mover_code', 'report_date', name=op.f('pk_out_eia923__boiler_fuel'))
    )
    op.create_table('out_eia923__generation',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia923__generation_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk_out_eia923__generation_plant_id_eia_core_eia__entity_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia923__generation_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_eia'], ['core_eia__entity_utilities.utility_id_eia'], name=op.f('fk_out_eia923__generation_utility_id_eia_core_eia__entity_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia923__generation_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'generator_id', 'report_date', name=op.f('pk_out_eia923__generation'))
    )
    op.create_table('out_eia923__monthly_boiler_fuel',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('boiler_id', sa.Text(), nullable=False, comment='Alphanumeric boiler ID.'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('energy_source_code', sa.Text(), nullable=False, comment='A 2-3 letter code indicating the energy source (e.g. fuel type) associated with the record.'),
    sa.Column('prime_mover_code', sa.Text(), nullable=False, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_consumed_units', sa.Float(), nullable=True, comment='Consumption of the fuel type in physical unit. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Heat content of the fuel in millions of Btus per physical unit.'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('sulfur_content_pct', sa.Float(), nullable=True, comment='Sulfur content percentage by weight to the nearest 0.01 percent.'),
    sa.Column('ash_content_pct', sa.Float(), nullable=True, comment='Ash content percentage by weight to the nearest 0.1 percent.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia923__monthly_boiler_fuel_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_code'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia923__monthly_boiler_fuel_energy_source_code_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'boiler_id'], ['core_eia__entity_boilers.plant_id_eia', 'core_eia__entity_boilers.boiler_id'], name=op.f('fk_out_eia923__monthly_boiler_fuel_plant_id_eia_core_eia__entity_boilers')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia923__monthly_boiler_fuel_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_out_eia923__monthly_boiler_fuel_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['utility_id_eia'], ['core_eia__entity_utilities.utility_id_eia'], name=op.f('fk_out_eia923__monthly_boiler_fuel_utility_id_eia_core_eia__entity_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia923__monthly_boiler_fuel_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'boiler_id', 'energy_source_code', 'prime_mover_code', 'report_date', name=op.f('pk_out_eia923__monthly_boiler_fuel'))
    )
    op.create_table('out_eia923__monthly_generation',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia923__monthly_generation_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk_out_eia923__monthly_generation_plant_id_eia_core_eia__entity_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia923__monthly_generation_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_eia'], ['core_eia__entity_utilities.utility_id_eia'], name=op.f('fk_out_eia923__monthly_generation_utility_id_eia_core_eia__entity_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia923__monthly_generation_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'generator_id', 'report_date', name=op.f('pk_out_eia923__monthly_generation'))
    )
    op.create_table('out_eia923__monthly_generation_fuel_by_generator',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('fuel_consumed_for_electricity_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel to produce electricity, in physical unit, year to date.'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk_out_eia923__monthly_generation_fuel_by_generator_plant_id_eia_core_eia__entity_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia923__monthly_generation_fuel_by_generator_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_eia'], ['core_eia__entity_utilities.utility_id_eia'], name=op.f('fk_out_eia923__monthly_generation_fuel_by_generator_utility_id_eia_core_eia__entity_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia923__monthly_generation_fuel_by_generator_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk_out_eia923__monthly_generation_fuel_by_generator'))
    )
    op.create_table('out_eia923__monthly_generation_fuel_by_generator_energy_source',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('prime_mover_code', sa.Text(), nullable=False, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('energy_source_code', sa.Text(), nullable=False, comment='A 2-3 letter code indicating the energy source (e.g. fuel type) associated with the record.'),
    sa.Column('energy_source_code_num', sa.Enum('energy_source_code_1', 'energy_source_code_2', 'energy_source_code_3', 'energy_source_code_4', 'energy_source_code_5', 'energy_source_code_6', 'energy_source_code_7', 'energy_source_code_8'), nullable=True, comment='Name of the energy_source_code_N column that this energy source code was reported in for the generator referenced in the same record.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_consumed_for_electricity_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel to produce electricity, in physical unit, year to date.'),
    sa.ForeignKeyConstraint(['energy_source_code'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia923__monthly_generation_fuel_by_generator_energy_source_energy_source_code_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk_out_eia923__monthly_generation_fuel_by_generator_energy_source_plant_id_eia_core_eia__entity_generators')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_out_eia923__monthly_generation_fuel_by_generator_energy_source_prime_mover_code_core_eia__codes_prime_movers')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', 'prime_mover_code', 'energy_source_code', name=op.f('pk_out_eia923__monthly_generation_fuel_by_generator_energy_source'))
    )
    op.create_table('out_eia__monthly_generators',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('technology_description', sa.Text(), nullable=True, comment='High level description of the technology used by the generator to produce electricity.'),
    sa.Column('energy_source_code_1', sa.Text(), nullable=True, comment='The code representing the most predominant type of energy that fuels the generator.'),
    sa.Column('prime_mover_code', sa.Text(), nullable=True, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('generator_operating_date', sa.Date(), nullable=True, comment='Date the generator began commercial operation. If harvested values are inconsistent, we default to using the most recently reported date.'),
    sa.Column('generator_retirement_date', sa.Date(), nullable=True, comment='Date of the scheduled or effected retirement of the generator.'),
    sa.Column('operational_status', sa.Text(), nullable=True, comment='The operating status of the asset. For generators this is based on which tab the generator was listed in in EIA 860.'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('planned_generator_retirement_date', sa.Date(), nullable=True, comment='Planned effective date of the scheduled retirement of the generator.'),
    sa.Column('capacity_factor', sa.Float(), nullable=True, comment='Fraction of potential generation that was actually reported for a plant part.'),
    sa.Column('fuel_cost_from_eiaapi', sa.Boolean(), nullable=True, comment='Indicates whether the fuel cost was derived from the EIA API.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('fuel_cost_per_mwh', sa.Float(), nullable=True, comment='Derived from MCOE, a unit level value. Average fuel cost per MWh of heat content in nominal USD.'),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.Float(), nullable=True, comment='Fuel content per unit of electricity generated. Coming from MCOE calculation.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('total_fuel_cost', sa.Float(), nullable=True, comment='Total annual reported fuel costs for the plant part. Includes costs from all fuels.'),
    sa.Column('total_mmbtu', sa.Float(), nullable=True, comment='Total annual heat content of fuel consumed by a plant part record in the plant parts list.'),
    sa.Column('associated_combined_heat_power', sa.Boolean(), nullable=True, comment='Indicates whether the generator is associated with a combined heat and power system'),
    sa.Column('bga_source', sa.Text(), nullable=True, comment='The source from where the unit_id_pudl is compiled. The unit_id_pudl comes directly from EIA 860, or string association (which looks at all the boilers and generators that are not associated with a unit and tries to find a matching string in the respective collection of boilers or generator), or from a unit connection (where the unit_id_eia is employed to find additional boiler generator connections).'),
    sa.Column('bypass_heat_recovery', sa.Boolean(), nullable=True, comment='Can this generator operate while bypassing the heat recovery steam generator?'),
    sa.Column('carbon_capture', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses carbon capture technology.'),
    sa.Column('city', sa.Text(), nullable=True, comment='Name of the city.'),
    sa.Column('cofire_fuels', sa.Boolean(), nullable=True, comment='Can the generator co-fire fuels?.'),
    sa.Column('county', sa.Text(), nullable=True, comment='County name.'),
    sa.Column('current_planned_generator_operating_date', sa.Date(), nullable=True, comment='The most recently updated effective date on which the generator is scheduled to start operation'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.Column('deliver_power_transgrid', sa.Boolean(), nullable=True, comment='Indicate whether the generator can deliver power to the transmission grid.'),
    sa.Column('distributed_generation', sa.Boolean(), nullable=True, comment='Whether the generator is considered distributed generation'),
    sa.Column('duct_burners', sa.Boolean(), nullable=True, comment='Indicates whether the unit has duct-burners for supplementary firing of the turbine exhaust gas'),
    sa.Column('energy_source_1_transport_1', sa.Text(), nullable=True, comment='Primary mode of transport for energy source 1.'),
    sa.Column('energy_source_1_transport_2', sa.Text(), nullable=True, comment='Secondary mode of transport for energy source 1.'),
    sa.Column('energy_source_1_transport_3', sa.Text(), nullable=True, comment='Tertiary mode of transport for energy source 1.'),
    sa.Column('energy_source_2_transport_1', sa.Text(), nullable=True, comment='Primary mode of transport for energy source 2.'),
    sa.Column('energy_source_2_transport_2', sa.Text(), nullable=True, comment='Secondary mode of transport for energy source 2.'),
    sa.Column('energy_source_2_transport_3', sa.Text(), nullable=True, comment='Tertiary mode of transport for energy source 2.'),
    sa.Column('energy_source_code_2', sa.Text(), nullable=True, comment='The code representing the second most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_code_3', sa.Text(), nullable=True, comment='The code representing the third most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_code_4', sa.Text(), nullable=True, comment='The code representing the fourth most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_code_5', sa.Text(), nullable=True, comment='The code representing the fifth most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_code_6', sa.Text(), nullable=True, comment='The code representing the sixth most predominant type of energy that fuels the generator'),
    sa.Column('energy_storage_capacity_mwh', sa.Float(), nullable=True, comment='Energy storage capacity in MWh (e.g. for batteries).'),
    sa.Column('ferc_qualifying_facility', sa.Boolean(), nullable=True, comment='Indicates whether or not a generator is a qualifying FERC cogeneration facility.'),
    sa.Column('fluidized_bed_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses fluidized bed technology'),
    sa.Column('fuel_type_count', sa.Integer(), nullable=True, comment='A count of how many different simple energy sources there are associated with a generator.'),
    sa.Column('latitude', sa.Float(), nullable=True, comment="Latitude of the plant's location, in degrees."),
    sa.Column('longitude', sa.Float(), nullable=True, comment="Longitude of the plant's location, in degrees."),
    sa.Column('minimum_load_mw', sa.Float(), nullable=True, comment='The minimum load at which the generator can operate at continuosuly.'),
    sa.Column('multiple_fuels', sa.Boolean(), nullable=True, comment='Can the generator burn multiple fuels?'),
    sa.Column('nameplate_power_factor', sa.Float(), nullable=True, comment='The nameplate power factor of the generator.'),
    sa.Column('net_capacity_mwdc', sa.Float(), nullable=True, comment='Generation capacity in megawatts of direct current that is subject to a net metering agreement. Typically used for behind-the-meter solar PV.'),
    sa.Column('operating_switch', sa.Text(), nullable=True, comment='Indicates whether the fuel switching generator can switch when operating'),
    sa.Column('operational_status_code', sa.Text(), nullable=True, comment='The operating status of the asset.'),
    sa.Column('original_planned_generator_operating_date', sa.Date(), nullable=True, comment='The date the generator was originally scheduled to be operational'),
    sa.Column('other_combustion_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses other combustion technologies'),
    sa.Column('other_modifications_date', sa.Date(), nullable=True, comment='Planned effective date that the generator is scheduled to enter commercial operation after any other planned modification is complete.'),
    sa.Column('other_planned_modifications', sa.Boolean(), nullable=True, comment='Indicates whether there are there other modifications planned for the generator.'),
    sa.Column('owned_by_non_utility', sa.Boolean(), nullable=True, comment='Whether any part of generator is owned by a nonutilty'),
    sa.Column('ownership_code', sa.Text(), nullable=True, comment='Identifies the ownership for each generator.'),
    sa.Column('planned_derate_date', sa.Date(), nullable=True, comment='Planned effective month that the generator is scheduled to enter operation after the derate modification.'),
    sa.Column('planned_energy_source_code_1', sa.Text(), nullable=True, comment='New energy source code for the planned repowered generator.'),
    sa.Column('planned_modifications', sa.Boolean(), nullable=True, comment='Indicates whether there are any planned capacity uprates/derates, repowering, other modifications, or generator retirements scheduled for the next 5 years.'),
    sa.Column('planned_net_summer_capacity_derate_mw', sa.Float(), nullable=True, comment='Decrease in summer capacity expected to be realized from the derate modification to the equipment.'),
    sa.Column('planned_net_summer_capacity_uprate_mw', sa.Float(), nullable=True, comment='Increase in summer capacity expected to be realized from the modification to the equipment.'),
    sa.Column('planned_net_winter_capacity_derate_mw', sa.Float(), nullable=True, comment='Decrease in winter capacity expected to be realized from the derate modification to the equipment.'),
    sa.Column('planned_net_winter_capacity_uprate_mw', sa.Float(), nullable=True, comment='Increase in winter capacity expected to be realized from the uprate modification to the equipment.'),
    sa.Column('planned_new_capacity_mw', sa.Float(), nullable=True, comment='The expected new namplate capacity for the generator.'),
    sa.Column('planned_new_prime_mover_code', sa.Text(), nullable=True, comment='New prime mover for the planned repowered generator.'),
    sa.Column('planned_repower_date', sa.Date(), nullable=True, comment='Planned effective date that the generator is scheduled to enter operation after the repowering is complete.'),
    sa.Column('planned_uprate_date', sa.Date(), nullable=True, comment='Planned effective date that the generator is scheduled to enter operation after the uprate modification.'),
    sa.Column('previously_canceled', sa.Boolean(), nullable=True, comment='Indicates whether the generator was previously reported as indefinitely postponed or canceled'),
    sa.Column('pulverized_coal_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses pulverized coal technology'),
    sa.Column('reactive_power_output_mvar', sa.Float(), nullable=True, comment='Reactive Power Output (MVAr)'),
    sa.Column('rto_iso_lmp_node_id', sa.Text(), nullable=True, comment='The designation used to identify the price node in RTO/ISO Locational Marginal Price reports'),
    sa.Column('rto_iso_location_wholesale_reporting_id', sa.Text(), nullable=True, comment='The designation used to report ths specific location of the wholesale sales transactions to FERC for the Electric Quarterly Report'),
    sa.Column('solid_fuel_gasification', sa.Boolean(), nullable=True, comment='Indicates whether the generator is part of a solid fuel gasification system'),
    sa.Column('startup_source_code_1', sa.Text(), nullable=True, comment='The code representing the first, second, third or fourth start-up and flame stabilization energy source used by the combustion unit(s) associated with this generator.'),
    sa.Column('startup_source_code_2', sa.Text(), nullable=True, comment='The code representing the first, second, third or fourth start-up and flame stabilization energy source used by the combustion unit(s) associated with this generator.'),
    sa.Column('startup_source_code_3', sa.Text(), nullable=True, comment='The code representing the first, second, third or fourth start-up and flame stabilization energy source used by the combustion unit(s) associated with this generator.'),
    sa.Column('startup_source_code_4', sa.Text(), nullable=True, comment='The code representing the first, second, third or fourth start-up and flame stabilization energy source used by the combustion unit(s) associated with this generator.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('stoker_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses stoker technology'),
    sa.Column('street_address', sa.Text(), nullable=True, comment='Physical street address.'),
    sa.Column('subcritical_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses subcritical technology'),
    sa.Column('summer_capacity_estimate', sa.Boolean(), nullable=True, comment='Whether the summer capacity value was an estimate'),
    sa.Column('summer_capacity_mw', sa.Float(), nullable=True, comment='The net summer capacity.'),
    sa.Column('summer_estimated_capability_mw', sa.Float(), nullable=True, comment='EIA estimated summer capacity (in MWh).'),
    sa.Column('supercritical_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses supercritical technology'),
    sa.Column('switch_oil_gas', sa.Boolean(), nullable=True, comment='Indicates whether the generator switch between oil and natural gas.'),
    sa.Column('syncronized_transmission_grid', sa.Boolean(), nullable=True, comment='Indicates whether standby generators (SB status) can be synchronized to the grid.'),
    sa.Column('time_cold_shutdown_full_load_code', sa.Text(), nullable=True, comment='The minimum amount of time required to bring the unit to full load from shutdown.'),
    sa.Column('timezone', sa.Enum('Africa/Abidjan', 'Africa/Accra', 'Africa/Addis_Ababa', 'Africa/Algiers', 'Africa/Asmara', 'Africa/Asmera', 'Africa/Bamako', 'Africa/Bangui', 'Africa/Banjul', 'Africa/Bissau', 'Africa/Blantyre', 'Africa/Brazzaville', 'Africa/Bujumbura', 'Africa/Cairo', 'Africa/Casablanca', 'Africa/Ceuta', 'Africa/Conakry', 'Africa/Dakar', 'Africa/Dar_es_Salaam', 'Africa/Djibouti', 'Africa/Douala', 'Africa/El_Aaiun', 'Africa/Freetown', 'Africa/Gaborone', 'Africa/Harare', 'Africa/Johannesburg', 'Africa/Juba', 'Africa/Kampala', 'Africa/Khartoum', 'Africa/Kigali', 'Africa/Kinshasa', 'Africa/Lagos', 'Africa/Libreville', 'Africa/Lome', 'Africa/Luanda', 'Africa/Lubumbashi', 'Africa/Lusaka', 'Africa/Malabo', 'Africa/Maputo', 'Africa/Maseru', 'Africa/Mbabane', 'Africa/Mogadishu', 'Africa/Monrovia', 'Africa/Nairobi', 'Africa/Ndjamena', 'Africa/Niamey', 'Africa/Nouakchott', 'Africa/Ouagadougou', 'Africa/Porto-Novo', 'Africa/Sao_Tome', 'Africa/Timbuktu', 'Africa/Tripoli', 'Africa/Tunis', 'Africa/Windhoek', 'America/Adak', 'America/Anchorage', 'America/Anguilla', 'America/Antigua', 'America/Araguaina', 'America/Argentina/Buenos_Aires', 'America/Argentina/Catamarca', 'America/Argentina/ComodRivadavia', 'America/Argentina/Cordoba', 'America/Argentina/Jujuy', 'America/Argentina/La_Rioja', 'America/Argentina/Mendoza', 'America/Argentina/Rio_Gallegos', 'America/Argentina/Salta', 'America/Argentina/San_Juan', 'America/Argentina/San_Luis', 'America/Argentina/Tucuman', 'America/Argentina/Ushuaia', 'America/Aruba', 'America/Asuncion', 'America/Atikokan', 'America/Atka', 'America/Bahia', 'America/Bahia_Banderas', 'America/Barbados', 'America/Belem', 'America/Belize', 'America/Blanc-Sablon', 'America/Boa_Vista', 'America/Bogota', 'America/Boise', 'America/Buenos_Aires', 'America/Cambridge_Bay', 'America/Campo_Grande', 'America/Cancun', 'America/Caracas', 'America/Catamarca', 'America/Cayenne', 'America/Cayman', 'America/Chicago', 'America/Chihuahua', 'America/Ciudad_Juarez', 'America/Coral_Harbour', 'America/Cordoba', 'America/Costa_Rica', 'America/Creston', 'America/Cuiaba', 'America/Curacao', 'America/Danmarkshavn', 'America/Dawson', 'America/Dawson_Creek', 'America/Denver', 'America/Detroit', 'America/Dominica', 'America/Edmonton', 'America/Eirunepe', 'America/El_Salvador', 'America/Ensenada', 'America/Fort_Nelson', 'America/Fort_Wayne', 'America/Fortaleza', 'America/Glace_Bay', 'America/Godthab', 'America/Goose_Bay', 'America/Grand_Turk', 'America/Grenada', 'America/Guadeloupe', 'America/Guatemala', 'America/Guayaquil', 'America/Guyana', 'America/Halifax', 'America/Havana', 'America/Hermosillo', 'America/Indiana/Indianapolis', 'America/Indiana/Knox', 'America/Indiana/Marengo', 'America/Indiana/Petersburg', 'America/Indiana/Tell_City', 'America/Indiana/Vevay', 'America/Indiana/Vincennes', 'America/Indiana/Winamac', 'America/Indianapolis', 'America/Inuvik', 'America/Iqaluit', 'America/Jamaica', 'America/Jujuy', 'America/Juneau', 'America/Kentucky/Louisville', 'America/Kentucky/Monticello', 'America/Knox_IN', 'America/Kralendijk', 'America/La_Paz', 'America/Lima', 'America/Los_Angeles', 'America/Louisville', 'America/Lower_Princes', 'America/Maceio', 'America/Managua', 'America/Manaus', 'America/Marigot', 'America/Martinique', 'America/Matamoros', 'America/Mazatlan', 'America/Mendoza', 'America/Menominee', 'America/Merida', 'America/Metlakatla', 'America/Mexico_City', 'America/Miquelon', 'America/Moncton', 'America/Monterrey', 'America/Montevideo', 'America/Montreal', 'America/Montserrat', 'America/Nassau', 'America/New_York', 'America/Nipigon', 'America/Nome', 'America/Noronha', 'America/North_Dakota/Beulah', 'America/North_Dakota/Center', 'America/North_Dakota/New_Salem', 'America/Nuuk', 'America/Ojinaga', 'America/Panama', 'America/Pangnirtung', 'America/Paramaribo', 'America/Phoenix', 'America/Port-au-Prince', 'America/Port_of_Spain', 'America/Porto_Acre', 'America/Porto_Velho', 'America/Puerto_Rico', 'America/Punta_Arenas', 'America/Rainy_River', 'America/Rankin_Inlet', 'America/Recife', 'America/Regina', 'America/Resolute', 'America/Rio_Branco', 'America/Rosario', 'America/Santa_Isabel', 'America/Santarem', 'America/Santiago', 'America/Santo_Domingo', 'America/Sao_Paulo', 'America/Scoresbysund', 'America/Shiprock', 'America/Sitka', 'America/St_Barthelemy', 'America/St_Johns', 'America/St_Kitts', 'America/St_Lucia', 'America/St_Thomas', 'America/St_Vincent', 'America/Swift_Current', 'America/Tegucigalpa', 'America/Thule', 'America/Thunder_Bay', 'America/Tijuana', 'America/Toronto', 'America/Tortola', 'America/Vancouver', 'America/Virgin', 'America/Whitehorse', 'America/Winnipeg', 'America/Yakutat', 'America/Yellowknife', 'Antarctica/Casey', 'Antarctica/Davis', 'Antarctica/DumontDUrville', 'Antarctica/Macquarie', 'Antarctica/Mawson', 'Antarctica/McMurdo', 'Antarctica/Palmer', 'Antarctica/Rothera', 'Antarctica/South_Pole', 'Antarctica/Syowa', 'Antarctica/Troll', 'Antarctica/Vostok', 'Arctic/Longyearbyen', 'Asia/Aden', 'Asia/Almaty', 'Asia/Amman', 'Asia/Anadyr', 'Asia/Aqtau', 'Asia/Aqtobe', 'Asia/Ashgabat', 'Asia/Ashkhabad', 'Asia/Atyrau', 'Asia/Baghdad', 'Asia/Bahrain', 'Asia/Baku', 'Asia/Bangkok', 'Asia/Barnaul', 'Asia/Beirut', 'Asia/Bishkek', 'Asia/Brunei', 'Asia/Calcutta', 'Asia/Chita', 'Asia/Choibalsan', 'Asia/Chongqing', 'Asia/Chungking', 'Asia/Colombo', 'Asia/Dacca', 'Asia/Damascus', 'Asia/Dhaka', 'Asia/Dili', 'Asia/Dubai', 'Asia/Dushanbe', 'Asia/Famagusta', 'Asia/Gaza', 'Asia/Harbin', 'Asia/Hebron', 'Asia/Ho_Chi_Minh', 'Asia/Hong_Kong', 'Asia/Hovd', 'Asia/Irkutsk', 'Asia/Istanbul', 'Asia/Jakarta', 'Asia/Jayapura', 'Asia/Jerusalem', 'Asia/Kabul', 'Asia/Kamchatka', 'Asia/Karachi', 'Asia/Kashgar', 'Asia/Kathmandu', 'Asia/Katmandu', 'Asia/Khandyga', 'Asia/Kolkata', 'Asia/Krasnoyarsk', 'Asia/Kuala_Lumpur', 'Asia/Kuching', 'Asia/Kuwait', 'Asia/Macao', 'Asia/Macau', 'Asia/Magadan', 'Asia/Makassar', 'Asia/Manila', 'Asia/Muscat', 'Asia/Nicosia', 'Asia/Novokuznetsk', 'Asia/Novosibirsk', 'Asia/Omsk', 'Asia/Oral', 'Asia/Phnom_Penh', 'Asia/Pontianak', 'Asia/Pyongyang', 'Asia/Qatar', 'Asia/Qostanay', 'Asia/Qyzylorda', 'Asia/Rangoon', 'Asia/Riyadh', 'Asia/Saigon', 'Asia/Sakhalin', 'Asia/Samarkand', 'Asia/Seoul', 'Asia/Shanghai', 'Asia/Singapore', 'Asia/Srednekolymsk', 'Asia/Taipei', 'Asia/Tashkent', 'Asia/Tbilisi', 'Asia/Tehran', 'Asia/Tel_Aviv', 'Asia/Thimbu', 'Asia/Thimphu', 'Asia/Tokyo', 'Asia/Tomsk', 'Asia/Ujung_Pandang', 'Asia/Ulaanbaatar', 'Asia/Ulan_Bator', 'Asia/Urumqi', 'Asia/Ust-Nera', 'Asia/Vientiane', 'Asia/Vladivostok', 'Asia/Yakutsk', 'Asia/Yangon', 'Asia/Yekaterinburg', 'Asia/Yerevan', 'Atlantic/Azores', 'Atlantic/Bermuda', 'Atlantic/Canary', 'Atlantic/Cape_Verde', 'Atlantic/Faeroe', 'Atlantic/Faroe', 'Atlantic/Jan_Mayen', 'Atlantic/Madeira', 'Atlantic/Reykjavik', 'Atlantic/South_Georgia', 'Atlantic/St_Helena', 'Atlantic/Stanley', 'Australia/ACT', 'Australia/Adelaide', 'Australia/Brisbane', 'Australia/Broken_Hill', 'Australia/Canberra', 'Australia/Currie', 'Australia/Darwin', 'Australia/Eucla', 'Australia/Hobart', 'Australia/LHI', 'Australia/Lindeman', 'Australia/Lord_Howe', 'Australia/Melbourne', 'Australia/NSW', 'Australia/North', 'Australia/Perth', 'Australia/Queensland', 'Australia/South', 'Australia/Sydney', 'Australia/Tasmania', 'Australia/Victoria', 'Australia/West', 'Australia/Yancowinna', 'Brazil/Acre', 'Brazil/DeNoronha', 'Brazil/East', 'Brazil/West', 'CET', 'CST6CDT', 'Canada/Atlantic', 'Canada/Central', 'Canada/Eastern', 'Canada/Mountain', 'Canada/Newfoundland', 'Canada/Pacific', 'Canada/Saskatchewan', 'Canada/Yukon', 'Chile/Continental', 'Chile/EasterIsland', 'Cuba', 'EET', 'EST', 'EST5EDT', 'Egypt', 'Eire', 'Etc/GMT', 'Etc/GMT+0', 'Etc/GMT+1', 'Etc/GMT+10', 'Etc/GMT+11', 'Etc/GMT+12', 'Etc/GMT+2', 'Etc/GMT+3', 'Etc/GMT+4', 'Etc/GMT+5', 'Etc/GMT+6', 'Etc/GMT+7', 'Etc/GMT+8', 'Etc/GMT+9', 'Etc/GMT-0', 'Etc/GMT-1', 'Etc/GMT-10', 'Etc/GMT-11', 'Etc/GMT-12', 'Etc/GMT-13', 'Etc/GMT-14', 'Etc/GMT-2', 'Etc/GMT-3', 'Etc/GMT-4', 'Etc/GMT-5', 'Etc/GMT-6', 'Etc/GMT-7', 'Etc/GMT-8', 'Etc/GMT-9', 'Etc/GMT0', 'Etc/Greenwich', 'Etc/UCT', 'Etc/UTC', 'Etc/Universal', 'Etc/Zulu', 'Europe/Amsterdam', 'Europe/Andorra', 'Europe/Astrakhan', 'Europe/Athens', 'Europe/Belfast', 'Europe/Belgrade', 'Europe/Berlin', 'Europe/Bratislava', 'Europe/Brussels', 'Europe/Bucharest', 'Europe/Budapest', 'Europe/Busingen', 'Europe/Chisinau', 'Europe/Copenhagen', 'Europe/Dublin', 'Europe/Gibraltar', 'Europe/Guernsey', 'Europe/Helsinki', 'Europe/Isle_of_Man', 'Europe/Istanbul', 'Europe/Jersey', 'Europe/Kaliningrad', 'Europe/Kiev', 'Europe/Kirov', 'Europe/Kyiv', 'Europe/Lisbon', 'Europe/Ljubljana', 'Europe/London', 'Europe/Luxembourg', 'Europe/Madrid', 'Europe/Malta', 'Europe/Mariehamn', 'Europe/Minsk', 'Europe/Monaco', 'Europe/Moscow', 'Europe/Nicosia', 'Europe/Oslo', 'Europe/Paris', 'Europe/Podgorica', 'Europe/Prague', 'Europe/Riga', 'Europe/Rome', 'Europe/Samara', 'Europe/San_Marino', 'Europe/Sarajevo', 'Europe/Saratov', 'Europe/Simferopol', 'Europe/Skopje', 'Europe/Sofia', 'Europe/Stockholm', 'Europe/Tallinn', 'Europe/Tirane', 'Europe/Tiraspol', 'Europe/Ulyanovsk', 'Europe/Uzhgorod', 'Europe/Vaduz', 'Europe/Vatican', 'Europe/Vienna', 'Europe/Vilnius', 'Europe/Volgograd', 'Europe/Warsaw', 'Europe/Zagreb', 'Europe/Zaporozhye', 'Europe/Zurich', 'GB', 'GB-Eire', 'GMT', 'GMT+0', 'GMT-0', 'GMT0', 'Greenwich', 'HST', 'Hongkong', 'Iceland', 'Indian/Antananarivo', 'Indian/Chagos', 'Indian/Christmas', 'Indian/Cocos', 'Indian/Comoro', 'Indian/Kerguelen', 'Indian/Mahe', 'Indian/Maldives', 'Indian/Mauritius', 'Indian/Mayotte', 'Indian/Reunion', 'Iran', 'Israel', 'Jamaica', 'Japan', 'Kwajalein', 'Libya', 'MET', 'MST', 'MST7MDT', 'Mexico/BajaNorte', 'Mexico/BajaSur', 'Mexico/General', 'NZ', 'NZ-CHAT', 'Navajo', 'PRC', 'PST8PDT', 'Pacific/Apia', 'Pacific/Auckland', 'Pacific/Bougainville', 'Pacific/Chatham', 'Pacific/Chuuk', 'Pacific/Easter', 'Pacific/Efate', 'Pacific/Enderbury', 'Pacific/Fakaofo', 'Pacific/Fiji', 'Pacific/Funafuti', 'Pacific/Galapagos', 'Pacific/Gambier', 'Pacific/Guadalcanal', 'Pacific/Guam', 'Pacific/Honolulu', 'Pacific/Johnston', 'Pacific/Kanton', 'Pacific/Kiritimati', 'Pacific/Kosrae', 'Pacific/Kwajalein', 'Pacific/Majuro', 'Pacific/Marquesas', 'Pacific/Midway', 'Pacific/Nauru', 'Pacific/Niue', 'Pacific/Norfolk', 'Pacific/Noumea', 'Pacific/Pago_Pago', 'Pacific/Palau', 'Pacific/Pitcairn', 'Pacific/Pohnpei', 'Pacific/Ponape', 'Pacific/Port_Moresby', 'Pacific/Rarotonga', 'Pacific/Saipan', 'Pacific/Samoa', 'Pacific/Tahiti', 'Pacific/Tarawa', 'Pacific/Tongatapu', 'Pacific/Truk', 'Pacific/Wake', 'Pacific/Wallis', 'Pacific/Yap', 'Poland', 'Portugal', 'ROC', 'ROK', 'Singapore', 'Turkey', 'UCT', 'US/Alaska', 'US/Aleutian', 'US/Arizona', 'US/Central', 'US/East-Indiana', 'US/Eastern', 'US/Hawaii', 'US/Indiana-Starke', 'US/Michigan', 'US/Mountain', 'US/Pacific', 'US/Samoa', 'UTC', 'Universal', 'W-SU', 'WET', 'Zulu'), nullable=True, comment='IANA timezone name'),
    sa.Column('topping_bottoming_code', sa.Text(), nullable=True, comment='If the generator is associated with a combined heat and power system, indicates whether the generator is part of a topping cycle or a bottoming cycle'),
    sa.Column('turbines_inverters_hydrokinetics', sa.Integer(), nullable=True, comment='Number of wind turbines, or hydrokinetic buoys.'),
    sa.Column('turbines_num', sa.Integer(), nullable=True, comment='Number of wind turbines, or hydrokinetic buoys.'),
    sa.Column('ultrasupercritical_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses ultra-supercritical technology'),
    sa.Column('uprate_derate_completed_date', sa.Date(), nullable=True, comment='The date when the uprate or derate was completed.'),
    sa.Column('uprate_derate_during_year', sa.Boolean(), nullable=True, comment='Was an uprate or derate completed on this generator during the reporting year?'),
    sa.Column('winter_capacity_estimate', sa.Boolean(), nullable=True, comment='Whether the winter capacity value was an estimate'),
    sa.Column('winter_capacity_mw', sa.Float(), nullable=True, comment='The net winter capacity.'),
    sa.Column('winter_estimated_capability_mw', sa.Float(), nullable=True, comment='EIA estimated winter capacity (in MWh).'),
    sa.Column('zip_code', sa.Text(), nullable=True, comment='Five digit US Zip Code.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia__monthly_generators_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_1_transport_1'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_out_eia__monthly_generators_energy_source_1_transport_1_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_1_transport_2'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_out_eia__monthly_generators_energy_source_1_transport_2_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_1_transport_3'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_out_eia__monthly_generators_energy_source_1_transport_3_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_2_transport_1'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_out_eia__monthly_generators_energy_source_2_transport_1_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_2_transport_2'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_out_eia__monthly_generators_energy_source_2_transport_2_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_2_transport_3'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_out_eia__monthly_generators_energy_source_2_transport_3_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__monthly_generators_energy_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_2'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__monthly_generators_energy_source_code_2_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_3'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__monthly_generators_energy_source_code_3_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_4'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__monthly_generators_energy_source_code_4_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_5'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__monthly_generators_energy_source_code_5_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_6'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__monthly_generators_energy_source_code_6_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['operational_status_code'], ['core_eia__codes_operational_status.code'], name=op.f('fk_out_eia__monthly_generators_operational_status_code_core_eia__codes_operational_status')),
    sa.ForeignKeyConstraint(['planned_energy_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__monthly_generators_planned_energy_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['planned_new_prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_out_eia__monthly_generators_planned_new_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk_out_eia__monthly_generators_plant_id_eia_core_eia__entity_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia__monthly_generators_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_out_eia__monthly_generators_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['startup_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__monthly_generators_startup_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['startup_source_code_2'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__monthly_generators_startup_source_code_2_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['startup_source_code_3'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__monthly_generators_startup_source_code_3_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['startup_source_code_4'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__monthly_generators_startup_source_code_4_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['utility_id_eia'], ['core_eia__entity_utilities.utility_id_eia'], name=op.f('fk_out_eia__monthly_generators_utility_id_eia_core_eia__entity_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia__monthly_generators_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk_out_eia__monthly_generators'))
    )
    op.create_table('out_eia__yearly_utilities',
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('street_address', sa.Text(), nullable=True, comment='Physical street address.'),
    sa.Column('city', sa.Text(), nullable=True, comment='Name of the city.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('zip_code', sa.Text(), nullable=True, comment='Five digit US Zip Code.'),
    sa.Column('plants_reported_owner', sa.Boolean(), nullable=True, comment='Is the reporting entity an owner of power plants reported on Schedule 2 of the form?'),
    sa.Column('plants_reported_operator', sa.Boolean(), nullable=True, comment='Is the reporting entity an operator of power plants reported on Schedule 2 of the form?'),
    sa.Column('plants_reported_asset_manager', sa.Boolean(), nullable=True, comment='Is the reporting entity an asset manager of power plants reported on Schedule 2 of the form?'),
    sa.Column('plants_reported_other_relationship', sa.Boolean(), nullable=True, comment='Does the reporting entity have any other relationship to the power plants reported on Schedule 2 of the form?'),
    sa.Column('entity_type', sa.Text(), nullable=True, comment='Entity type of principal owner.'),
    sa.Column('attention_line', sa.Text(), nullable=True, comment='Mail attention name of the operator/owner.'),
    sa.Column('address_2', sa.Text(), nullable=True, comment='Second line of the address.'),
    sa.Column('zip_code_4', sa.Text(), nullable=True, comment='Four digit US Zip Code suffix.'),
    sa.Column('contact_firstname', sa.Text(), nullable=True, comment='First name of utility contact 1.'),
    sa.Column('contact_lastname', sa.Text(), nullable=True, comment='Last name of utility contact 1.'),
    sa.Column('contact_title', sa.Text(), nullable=True, comment='Title of of utility contact 1.'),
    sa.Column('phone_number', sa.Text(), nullable=True, comment='Phone number for utility contact 1.'),
    sa.Column('phone_extension', sa.Text(), nullable=True, comment='Phone extension for utility contact 1'),
    sa.Column('contact_firstname_2', sa.Text(), nullable=True, comment='First name of utility contact 2.'),
    sa.Column('contact_lastname_2', sa.Text(), nullable=True, comment='Last name of utility contact 2.'),
    sa.Column('contact_title_2', sa.Text(), nullable=True, comment='Title of utility contact 2.'),
    sa.Column('phone_number_2', sa.Text(), nullable=True, comment='Phone number for utility contact 2.'),
    sa.Column('phone_extension_2', sa.Text(), nullable=True, comment='Phone extension for utility contact 2'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia__yearly_utilities_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk_out_eia__yearly_utilities_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia__yearly_utilities_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_eia', 'report_date', name=op.f('pk_out_eia__yearly_utilities'))
    )
    op.create_table('out_ferc1__yearly_balance_sheet_assets_sched110',
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('asset_type', sa.Text(), nullable=False, comment='Type of asset being reported to the core_ferc1__yearly_balance_sheet_assets_sched110 table.'),
    sa.Column('balance', sa.Text(), nullable=True, comment='Indication of whether a column is a credit or debit, as reported in the XBRL taxonomy.'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.Column('starting_balance', sa.Float(), nullable=True, comment='Account balance at beginning of year.'),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_balance_sheet_assets_sched110_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_balance_sheet_assets_sched110_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'asset_type', name=op.f('pk_out_ferc1__yearly_balance_sheet_assets_sched110'))
    )
    op.create_table('out_ferc1__yearly_balance_sheet_liabilities_sched110',
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('starting_balance', sa.Float(), nullable=True, comment='Account balance at beginning of year.'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('liability_type', sa.Text(), nullable=False, comment='Type of liability being reported to the core_ferc1__yearly_balance_sheet_liabilities_sched110 table.'),
    sa.Column('balance', sa.Text(), nullable=True, comment='Indication of whether a column is a credit or debit, as reported in the XBRL taxonomy.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_balance_sheet_liabilities_sched110_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_balance_sheet_liabilities_sched110_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'liability_type', name=op.f('pk_out_ferc1__yearly_balance_sheet_liabilities_sched110'))
    )
    op.create_table('out_ferc1__yearly_cash_flows_sched120',
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('amount_type', sa.Text(), nullable=False, comment='Label describing the type of amount being reported. This could be a balance or a change in value.'),
    sa.Column('amount', sa.Float(), nullable=True, comment='Reported amount of dollars. This could be a balance or a change in value.'),
    sa.Column('balance', sa.Text(), nullable=True, comment='Indication of whether a column is a credit or debit, as reported in the XBRL taxonomy.'),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_cash_flows_sched120_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_cash_flows_sched120_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'amount_type', name=op.f('pk_out_ferc1__yearly_cash_flows_sched120'))
    )
    op.create_table('out_ferc1__yearly_depreciation_by_function_sched219',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('depreciation_type', sa.Text(), nullable=False, comment='Type of depreciation provision within FERC Account 108, including cost ofremoval, depreciation expenses, salvage, cost of retired plant, etc.'),
    sa.Column('plant_function', sa.Text(), nullable=False, comment='Functional role played by utility plant (steam production, nuclear production, distribution, transmission, etc.).'),
    sa.Column('plant_status', sa.Text(), nullable=False, comment='Utility plant financial status (in service, future, leased, total).'),
    sa.Column('utility_type', sa.Text(), nullable=False, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('balance', sa.Text(), nullable=True, comment='Indication of whether a column is a credit or debit, as reported in the XBRL taxonomy.'),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_depreciation_by_function_sched219_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_depreciation_by_function_sched219_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'depreciation_type', 'plant_function', 'plant_status', 'utility_type', name=op.f('pk_out_ferc1__yearly_depreciation_by_function_sched219'))
    )
    op.create_table('out_ferc1__yearly_depreciation_changes_sched219',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('depreciation_type', sa.Text(), nullable=False, comment='Type of depreciation provision within FERC Account 108, including cost ofremoval, depreciation expenses, salvage, cost of retired plant, etc.'),
    sa.Column('plant_status', sa.Text(), nullable=False, comment='Utility plant financial status (in service, future, leased, total).'),
    sa.Column('utility_type', sa.Text(), nullable=False, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('dollar_value', sa.Float(), nullable=True, comment='Dollar value of reported income, expense, asset, or liability.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('balance', sa.Text(), nullable=True, comment='Indication of whether a column is a credit or debit, as reported in the XBRL taxonomy.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_depreciation_changes_sched219_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_depreciation_changes_sched219_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'depreciation_type', 'plant_status', 'utility_type', name=op.f('pk_out_ferc1__yearly_depreciation_changes_sched219'))
    )
    op.create_table('out_ferc1__yearly_depreciation_summary_sched336',
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('plant_function', sa.Text(), nullable=False, comment='Functional role played by utility plant (steam production, nuclear production, distribution, transmission, etc.).'),
    sa.Column('ferc_account_label', sa.Text(), nullable=False, comment='Long FERC account identifier derived from values reported in the XBRL taxonomies. May also refer to aggregations of individual FERC accounts.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('dollar_value', sa.Float(), nullable=True, comment='Dollar value of reported income, expense, asset, or liability.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_depreciation_summary_sched336_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_depreciation_summary_sched336_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'plant_function', 'ferc_account_label', name=op.f('pk_out_ferc1__yearly_depreciation_summary_sched336'))
    )
    op.create_table('out_ferc1__yearly_energy_dispositions_sched401',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('energy_disposition_type', sa.Text(), nullable=False, comment='Type of energy disposition reported in the core_ferc1__yearly_energy_dispositions_sched401. Dispositions include sales to customers, re-sales of energy, energy used internally, losses, etc.'),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.Column('energy_mwh', sa.Float(), nullable=True, comment='Sources and uses of energy in MWh.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_energy_dispositions_sched401_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_energy_dispositions_sched401_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'energy_disposition_type', name=op.f('pk_out_ferc1__yearly_energy_dispositions_sched401'))
    )
    op.create_table('out_ferc1__yearly_energy_sources_sched401',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('energy_source_type', sa.Text(), nullable=False, comment='Type of energy source reported in the core_ferc1__yearly_energy_sources_sched401 table. There are three groups of energy sources: generation, power exchanges and transmission.'),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.Column('energy_mwh', sa.Float(), nullable=True, comment='Sources and uses of energy in MWh.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_energy_sources_sched401_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_energy_sources_sched401_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'energy_source_type', name=op.f('pk_out_ferc1__yearly_energy_sources_sched401'))
    )
    op.create_table('out_ferc1__yearly_income_statements_sched114',
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_type', sa.Text(), nullable=False, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('income_type', sa.Text(), nullable=False, comment='Type of income reported in income_statement_ferc1 table.'),
    sa.Column('dollar_value', sa.Float(), nullable=True, comment='Dollar value of reported income, expense, asset, or liability.'),
    sa.Column('balance', sa.Text(), nullable=True, comment='Indication of whether a column is a credit or debit, as reported in the XBRL taxonomy.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_income_statements_sched114_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_income_statements_sched114_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'utility_type', 'income_type', name=op.f('pk_out_ferc1__yearly_income_statements_sched114'))
    )
    op.create_table('out_ferc1__yearly_operating_expenses_sched320',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('dollar_value', sa.Float(), nullable=True, comment='Dollar value of reported income, expense, asset, or liability.'),
    sa.Column('expense_type', sa.Text(), nullable=False, comment='The type of expense.'),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_operating_expenses_sched320_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_operating_expenses_sched320_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'expense_type', name=op.f('pk_out_ferc1__yearly_operating_expenses_sched320'))
    )
    op.create_table('out_ferc1__yearly_operating_revenues_sched300',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('revenue_type', sa.Text(), nullable=False, comment='Label describing types of revenues.'),
    sa.Column('dollar_value', sa.Float(), nullable=True, comment='Dollar value of reported income, expense, asset, or liability.'),
    sa.Column('sales_mwh', sa.Float(), nullable=True, comment='Quantity of electricity sold in MWh.'),
    sa.Column('avg_customers_per_month', sa.Float(), nullable=True, comment='Average number of customers per month.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_operating_revenues_sched300_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_operating_revenues_sched300_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'revenue_type', name=op.f('pk_out_ferc1__yearly_operating_revenues_sched300'))
    )
    op.create_table('out_ferc1__yearly_other_regulatory_liabilities_sched278',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('description', sa.Text(), nullable=True, comment='Long human-readable description of the meaning of a code/label.'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('starting_balance', sa.Float(), nullable=True, comment='Account balance at beginning of year.'),
    sa.Column('increase_in_other_regulatory_liabilities', sa.Float(), nullable=True, comment='The increase during the reporting period of other regulatory liabilities.'),
    sa.Column('account_detail', sa.Text(), nullable=True, comment='Description of the account number credited from making debit adjustment to other regulatory liabilities.'),
    sa.Column('decrease_in_other_regulatory_liabilities', sa.Float(), nullable=True, comment='The decrease during the reporting period of other regulatory liabilities.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_other_regulatory_liabilities_sched278_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_other_regulatory_liabilities_sched278_utility_id_pudl_core_pudl__entity_utilities_pudl'))
    )
    op.create_table('out_ferc1__yearly_plant_in_service_sched204',
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('plant_status', sa.Text(), nullable=True, comment='Utility plant financial status (in service, future, leased, total).'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('additions', sa.Float(), nullable=True, comment='Cost of acquisition of items classified within the account.'),
    sa.Column('adjustments', sa.Float(), nullable=True, comment='Cost of adjustments to the account.'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('ferc_account_label', sa.Text(), nullable=False, comment='Long FERC account identifier derived from values reported in the XBRL taxonomies. May also refer to aggregations of individual FERC accounts.'),
    sa.Column('retirements', sa.Float(), nullable=True, comment='Cost of disposal of items classified within the account.'),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.Column('starting_balance', sa.Float(), nullable=True, comment='Account balance at beginning of year.'),
    sa.Column('transfers', sa.Float(), nullable=True, comment='Cost of transfers into (out of) the account.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_plant_in_service_sched204_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_plant_in_service_sched204_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'ferc_account_label', name=op.f('pk_out_ferc1__yearly_plant_in_service_sched204'))
    )
    op.create_table('out_ferc1__yearly_purchased_power_and_exchanges_sched326',
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('seller_name', sa.Text(), nullable=True, comment='Name of the seller, or the other party in an exchange transaction.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('billing_demand_mw', sa.Float(), nullable=True, comment='Monthly average billing demand (for requirements purchases, and any transactions involving demand charges). In megawatts.'),
    sa.Column('coincident_peak_demand_mw', sa.Float(), nullable=True, comment="Average monthly coincident peak (CP) demand (for requirements purchases, and any transactions involving demand charges). Monthly CP demand is the metered demand during the hour (60-minute integration) in which the supplier's system reaches its monthly peak. In megawatts."),
    sa.Column('delivered_mwh', sa.Float(), nullable=True, comment='Gross megawatt-hours delivered in power exchanges and used as the basis for settlement.'),
    sa.Column('demand_charges', sa.Float(), nullable=True, comment='Demand charges (USD).'),
    sa.Column('energy_charges', sa.Float(), nullable=True, comment='Energy charges (USD).'),
    sa.Column('non_coincident_peak_demand_mw', sa.Float(), nullable=True, comment='Average monthly non-coincident peak (NCP) demand (for requirements purhcases, and any transactions involving demand charges). Monthly NCP demand is the maximum metered hourly (60-minute integration) demand in a month. In megawatts.'),
    sa.Column('other_charges', sa.Float(), nullable=True, comment='Other charges, including out-of-period adjustments (USD).'),
    sa.Column('purchase_type_code', sa.Text(), nullable=True, comment="Categorization based on the original contractual terms and conditions of the service. Must be one of 'requirements', 'long_firm', 'intermediate_firm', 'short_firm', 'long_unit', 'intermediate_unit', 'electricity_exchange', 'other_service', or 'adjustment'. Requirements service is ongoing high reliability service, with load integrated into system resource planning. 'Long term' means 5+ years. 'Intermediate term' is 1-5 years. 'Short term' is less than 1 year. 'Firm' means not interruptible for economic reasons. 'unit' indicates service from a particular designated generating unit. 'exchange' is an in-kind transaction."),
    sa.Column('purchased_mwh', sa.Float(), nullable=True, comment='Megawatt-hours shown on bills rendered to the respondent. Includes both electricity purchased for storage and non-storage purposes, which were lumped together prior to 2021.'),
    sa.Column('purchased_storage_mwh', sa.Float(), nullable=True, comment='Number of megawatt hours purchased during the period for energy storage.'),
    sa.Column('purchased_other_than_storage_mwh', sa.Float(), nullable=True, comment='Number of megawatt hours purchased during the period for other than energy storage.'),
    sa.Column('received_mwh', sa.Float(), nullable=True, comment='Gross megawatt-hours received in power exchanges and used as the basis for settlement.'),
    sa.Column('tariff', sa.Text(), nullable=True, comment='FERC Rate Schedule Number or Tariff. (Note: may be incomplete if originally reported on multiple lines.)'),
    sa.Column('total_settlement', sa.Float(), nullable=True, comment='Sum of demand, energy, and other charges (USD). For power exchanges, the settlement amount for the net receipt of energy. If more energy was delivered than received, this amount is negative.'),
    sa.ForeignKeyConstraint(['purchase_type_code'], ['core_ferc1__codes_power_purchase_types.code'], name=op.f('fk_out_ferc1__yearly_purchased_power_and_exchanges_sched326_purchase_type_code_core_ferc1__codes_power_purchase_types')),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_purchased_power_and_exchanges_sched326_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_purchased_power_and_exchanges_sched326_utility_id_pudl_core_pudl__entity_utilities_pudl'))
    )
    op.create_table('out_ferc1__yearly_rate_base',
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('table_name', sa.Text(), nullable=True, comment='The name of the PUDL database table where a given record originated from.'),
    sa.Column('utility_type', sa.Enum('electric', 'gas', 'common', 'other', 'other3', 'other2'), nullable=True, comment='Listing of utility plant types.'),
    sa.Column('plant_function', sa.Enum('distribution', 'experimental', 'general', 'hydraulic_production', 'intangible', 'nuclear_production', 'other_production', 'purchased_sold', 'regional_transmission_and_market_operation', 'steam_production', 'transmission', 'unclassified'), nullable=True, comment='Functional role played by utility plant (steam production, nuclear production, distribution, transmission, etc.).'),
    sa.Column('plant_status', sa.Text(), nullable=True, comment='Utility plant financial status (in service, future, leased, total).'),
    sa.Column('xbrl_factoid', sa.Text(), nullable=True, comment='The name of type of value which is a derivative of the XBRL fact name.'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('utility_type_other', sa.Text(), nullable=True, comment='Freeform description of type of utility reported in one of the other three other utility_type sections in the core_ferc1__yearly_utility_plant_summary_sched200 table. This field is reported only in the DBF reporting years (1994-2020).'),
    sa.Column('rate_base_category', sa.Enum('other_plant', 'nuclear', 'transmission', 'net_nuclear_fuel', 'distribution', 'steam', 'experimental_plant', 'net_working_capital', 'general_plant', 'regional_transmission_and_market_operation', 'other_production', 'hydro', 'net_utility_plant', 'intangible_plant', 'other_deferred_debits_and_credits', 'net_regulatory_assets', 'net_ADIT', 'asset_retirement_costs', 'utility_plant', 'AROs', 'correction'), nullable=True, comment='A category of asset or liability that RMI compiled to use as a shorthand for various types of utility assets. These tags were compiled manually based on the xbrl_factoid and sometimes varies based on the utility_type, plant_function or plant_status as well.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('is_disaggregated_utility_type', sa.Boolean(), nullable=True, comment='Indicates whether or not records with null or total values in the utility_type column were disaggregated. See documentation for process: pudl.output.ferc1.disaggregate_null_or_total_tag'),
    sa.Column('is_disaggregated_in_rate_base', sa.Boolean(), nullable=True, comment='Indicates whether or not records with null values in the in_rate_base column were disaggregated. See documentation for process: pudl.output.ferc1.disaggregate_null_or_total_tag'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_rate_base_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities'))
    )
    op.create_table('out_ferc1__yearly_retained_earnings_sched118',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('earnings_type', sa.Text(), nullable=False, comment='Label describing types of earnings.'),
    sa.Column('starting_balance', sa.Float(), nullable=True, comment='Account balance at beginning of year.'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('balance', sa.Text(), nullable=True, comment='Indication of whether a column is a credit or debit, as reported in the XBRL taxonomy.'),
    sa.Column('ferc_account', sa.Text(), nullable=True, comment="Actual FERC Account number (e.g. '359.1') if available, or a PUDL assigned ID when FERC accounts have been split or combined in reporting."),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.Column('utility_type', sa.Text(), nullable=True, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_retained_earnings_sched118_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_retained_earnings_sched118_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'earnings_type', name=op.f('pk_out_ferc1__yearly_retained_earnings_sched118'))
    )
    op.create_table('out_ferc1__yearly_sales_by_rate_schedules_sched304',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('rate_schedule_type', sa.Text(), nullable=True, comment='Categorization of rate schedule type.'),
    sa.Column('billing_status', sa.Text(), nullable=True, comment='Whether an amount is billed, unbilled, or both. Billed amounts pertain to the exchange of energy and unbilled amounts pertain to other sources of revenue such as contracts with peaker plants to keep them on standby or charging rent to host cell antennas on transmission towers.'),
    sa.Column('rate_schedule_description', sa.Text(), nullable=True, comment='Free-form description of what the rate schedule name is. Not standardized. Often a sub-category of rate_schedule_type.'),
    sa.Column('sales_mwh', sa.Float(), nullable=True, comment='Quantity of electricity sold in MWh.'),
    sa.Column('dollar_value', sa.Float(), nullable=True, comment='Dollar value of reported income, expense, asset, or liability.'),
    sa.Column('avg_customers_per_month', sa.Float(), nullable=True, comment='Average number of customers per month.'),
    sa.Column('kwh_per_customer', sa.Float(), nullable=True, comment='kWh per customer.'),
    sa.Column('revenue_per_kwh', sa.Float(), nullable=True, comment='The amount of revenue per kWh by rate schedule aquired in the given report year.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_sales_by_rate_schedules_sched304_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_sales_by_rate_schedules_sched304_utility_id_pudl_core_pudl__entity_utilities_pudl'))
    )
    op.create_table('out_ferc1__yearly_transmission_lines_sched422',
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('start_point', sa.Text(), nullable=True, comment='The starting point of a transmission line.'),
    sa.Column('end_point', sa.Text(), nullable=True, comment='The end point of a transmission line.'),
    sa.Column('operating_voltage_kv', sa.Float(), nullable=True, comment='The operating voltage, expressed kilo-volts, for three-phase 60 cycle alternative current transmission lines.'),
    sa.Column('designed_voltage_kv', sa.Float(), nullable=True, comment='Manufactured (Designed) voltage, expressed in kilo-volts, for three-phase 60 cycle alternative current transmission lines'),
    sa.Column('supporting_structure_type', sa.Text(), nullable=True, comment='Supporting structure of the transmission line.'),
    sa.Column('transmission_line_length_miles', sa.Float(), nullable=True, comment='Length (in pole miles or circuit miles (if transmission lines are underground)) for lines that are stand alone structures (whose cost are reported on a stand-alone basis).'),
    sa.Column('transmission_line_and_structures_length_miles', sa.Float(), nullable=True, comment='Length (in pole miles or circuit miles (if transmission lines are underground)) for lines that are agrregated with other lines / structures (whose cost are aggregated and combined with other structures).'),
    sa.Column('num_transmission_circuits', sa.Integer(), nullable=True, comment='Number of circuits in a transmission line.'),
    sa.Column('conductor_size_and_material', sa.Text(), nullable=True, comment='Size of transmission conductor and material of the transmission line.'),
    sa.Column('capex_land', sa.Float(), nullable=True, comment='Cost of plant: land and land rights (USD).'),
    sa.Column('capex_other', sa.Float(), nullable=True, comment='Other costs associated with the plant (USD).'),
    sa.Column('capex_total', sa.Float(), nullable=True, comment='Total cost of plant (USD).'),
    sa.Column('opex_operations', sa.Float(), nullable=True, comment='Production expenses: operations, supervision, and engineering (USD).'),
    sa.Column('opex_maintenance', sa.Float(), nullable=True, comment='Production expenses: Maintenance (USD).'),
    sa.Column('opex_rents', sa.Float(), nullable=True, comment='Production expenses: rents (USD).'),
    sa.Column('opex_total', sa.Float(), nullable=True, comment='Total production expenses, excluding fuel (USD).'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_transmission_lines_sched422_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_transmission_lines_sched422_utility_id_pudl_core_pudl__entity_utilities_pudl'))
    )
    op.create_table('out_ferc1__yearly_utility_plant_summary_sched200',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_type', sa.Text(), nullable=False, comment='Listing of utility plant types. Examples include Electric Utility, Gas Utility, and Other Utility.'),
    sa.Column('utility_type_other', sa.Text(), nullable=True, comment='Freeform description of type of utility reported in one of the other three other utility_type sections in the core_ferc1__yearly_utility_plant_summary_sched200 table. This field is reported only in the DBF reporting years (1994-2020).'),
    sa.Column('utility_plant_asset_type', sa.Text(), nullable=False, comment='Type of utility plant asset reported in the core_ferc1__yearly_utility_plant_summary_sched200 table. Assets include those leased to others, held for future use, construction work-in-progress and details of accumulated depreciation.'),
    sa.Column('row_type_xbrl', sa.Enum('calculated_value', 'reported_value', 'correction', 'subdimension_correction'), nullable=True, comment='Indicates whether the value reported in the row is calculated, or uniquely reported within the table.'),
    sa.Column('ending_balance', sa.Float(), nullable=True, comment='Account balance at end of year.'),
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1'], ['core_pudl__assn_ferc1_pudl_utilities.utility_id_ferc1'], name=op.f('fk_out_ferc1__yearly_utility_plant_summary_sched200_utility_id_ferc1_core_pudl__assn_ferc1_pudl_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_utility_plant_summary_sched200_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'report_year', 'utility_type', 'utility_plant_asset_type', name=op.f('pk_out_ferc1__yearly_utility_plant_summary_sched200'))
    )
    op.create_table('_core_eia860__cooling_equipment',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('cooling_id_eia', sa.Text(), nullable=False, comment="EIA Identification code for cooling system (if multiple cooling systems are not distinguished by separate IDs, the word 'PLANT' is listed to encompass the cooling system for the entire plant)"),
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('county', sa.Text(), nullable=True, comment='County name.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('chlorine_equipment_cost', sa.Float(), nullable=True, comment='Actual installed cost for the existing chlorine discharge control system or the anticipated cost to bring the chlorine discharge control system into commercial operation'),
    sa.Column('chlorine_equipment_operating_date', sa.Date(), nullable=True, comment='Actual or projected in-service date for chlorine discharge control structures and equipment'),
    sa.Column('cooling_equipment_total_cost', sa.Float(), nullable=True, comment='Actual installed cost for the existing system or the anticipated cost to bring the total system into commercial operation'),
    sa.Column('cooling_status_code', sa.Text(), nullable=True, comment='Operating status of cooling system'),
    sa.Column('cooling_system_operating_date', sa.Date(), nullable=True, comment='The actual or projected in-service datetime of this cooling system'),
    sa.Column('cooling_type_1', sa.Text(), nullable=True, comment='Type of cooling system'),
    sa.Column('cooling_type_2', sa.Text(), nullable=True, comment='Type of cooling system'),
    sa.Column('cooling_type_3', sa.Text(), nullable=True, comment='Type of cooling system'),
    sa.Column('cooling_type_4', sa.Text(), nullable=True, comment='Type of cooling system'),
    sa.Column('cooling_water_discharge', sa.Text(), nullable=True, comment='Name of river, lake, or water source that cooling water is discharged into'),
    sa.Column('cooling_water_source', sa.Text(), nullable=True, comment='Name of river, lake, or water source that provides cooling water'),
    sa.Column('intake_distance_shore_feet', sa.Float(), nullable=True, comment='Maximum distance from shore to intake'),
    sa.Column('intake_distance_surface_feet', sa.Float(), nullable=True, comment='Average distance below water surface to intake'),
    sa.Column('intake_rate_100pct_gallons_per_minute', sa.Float(), nullable=True, comment='Design cooling water flow rate at 100 percent load at in-take'),
    sa.Column('outlet_distance_shore_feet', sa.Float(), nullable=True, comment='Maximum distance from shore to outlet'),
    sa.Column('outlet_distance_surface_feet', sa.Float(), nullable=True, comment='Average distance below water surface to outlet'),
    sa.Column('percent_dry_cooling', sa.Float(), nullable=True, comment='Percent of cooling load served by dry cooling components'),
    sa.Column('plant_summer_capacity_mw', sa.Float(), nullable=True, comment='The plant summer capacity associated with the operating generators at the plant'),
    sa.Column('pond_cost', sa.Float(), nullable=True, comment='Actual installed cost for the existing cooling ponds or the anticipated cost to bring the cooling ponds into commercial operation'),
    sa.Column('pond_operating_date', sa.Date(), nullable=True, comment='Cooling ponds actual or projected in-service date'),
    sa.Column('pond_surface_area_acres', sa.Float(), nullable=True, comment='Total surface area of cooling pond'),
    sa.Column('pond_volume_acre_feet', sa.Float(), nullable=True, comment='Total volume of water in cooling pond'),
    sa.Column('power_requirement_mw', sa.Float(), nullable=True, comment='Maximum power requirement for cooling towers at 100 percent load'),
    sa.Column('steam_plant_type_code', sa.Integer(), nullable=True, comment='Code that describes types of steam plants from EIA 860. See steam_plant_types_eia table for more details.'),
    sa.Column('tower_cost', sa.Float(), nullable=True, comment='Actual installed cost for the existing cooling towers or the anticipated cost to bring the cooling towers into commercial operation'),
    sa.Column('tower_operating_date', sa.Date(), nullable=True, comment='Cooling towers actual or projected in-service date'),
    sa.Column('tower_type_1', sa.Text(), nullable=True, comment='Types of cooling towers at this plant'),
    sa.Column('tower_type_2', sa.Text(), nullable=True, comment='Types of cooling towers at this plant'),
    sa.Column('tower_type_3', sa.Text(), nullable=True, comment='Types of cooling towers at this plant'),
    sa.Column('tower_type_4', sa.Text(), nullable=True, comment='Types of cooling towers at this plant'),
    sa.Column('tower_water_rate_100pct_gallons_per_minute', sa.Float(), nullable=True, comment='Maximum design rate of water flow at 100 percent load for the cooling towers'),
    sa.Column('water_source_code', sa.Text(), nullable=True, comment='Type of cooling water source'),
    sa.Column('water_source', sa.Text(), nullable=True, comment='Name of water source associated with the plant.'),
    sa.Column('water_type_code', sa.Text(), nullable=True, comment='Type of cooling water'),
    sa.ForeignKeyConstraint(['cooling_status_code'], ['core_eia__codes_operational_status.code'], name=op.f('fk__core_eia860__cooling_equipment_cooling_status_code_core_eia__codes_operational_status')),
    sa.ForeignKeyConstraint(['cooling_type_1'], ['core_eia__codes_cooling_system_types.code'], name=op.f('fk__core_eia860__cooling_equipment_cooling_type_1_core_eia__codes_cooling_system_types')),
    sa.ForeignKeyConstraint(['cooling_type_2'], ['core_eia__codes_cooling_system_types.code'], name=op.f('fk__core_eia860__cooling_equipment_cooling_type_2_core_eia__codes_cooling_system_types')),
    sa.ForeignKeyConstraint(['cooling_type_3'], ['core_eia__codes_cooling_system_types.code'], name=op.f('fk__core_eia860__cooling_equipment_cooling_type_3_core_eia__codes_cooling_system_types')),
    sa.ForeignKeyConstraint(['cooling_type_4'], ['core_eia__codes_cooling_system_types.code'], name=op.f('fk__core_eia860__cooling_equipment_cooling_type_4_core_eia__codes_cooling_system_types')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'report_date'], ['core_eia860__scd_plants.plant_id_eia', 'core_eia860__scd_plants.report_date'], name=op.f('fk__core_eia860__cooling_equipment_plant_id_eia_core_eia860__scd_plants')),
    sa.ForeignKeyConstraint(['steam_plant_type_code'], ['core_eia__codes_steam_plant_types.code'], name=op.f('fk__core_eia860__cooling_equipment_steam_plant_type_code_core_eia__codes_steam_plant_types')),
    sa.ForeignKeyConstraint(['tower_type_1'], ['core_eia__codes_cooling_tower_types.code'], name=op.f('fk__core_eia860__cooling_equipment_tower_type_1_core_eia__codes_cooling_tower_types')),
    sa.ForeignKeyConstraint(['tower_type_2'], ['core_eia__codes_cooling_tower_types.code'], name=op.f('fk__core_eia860__cooling_equipment_tower_type_2_core_eia__codes_cooling_tower_types')),
    sa.ForeignKeyConstraint(['tower_type_3'], ['core_eia__codes_cooling_tower_types.code'], name=op.f('fk__core_eia860__cooling_equipment_tower_type_3_core_eia__codes_cooling_tower_types')),
    sa.ForeignKeyConstraint(['tower_type_4'], ['core_eia__codes_cooling_tower_types.code'], name=op.f('fk__core_eia860__cooling_equipment_tower_type_4_core_eia__codes_cooling_tower_types')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk__core_eia860__cooling_equipment_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['water_type_code'], ['core_eia__codes_cooling_water_types.code'], name=op.f('fk__core_eia860__cooling_equipment_water_type_code_core_eia__codes_cooling_water_types')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'utility_id_eia', 'cooling_id_eia', 'report_date', name=op.f('pk__core_eia860__cooling_equipment'))
    )
    op.create_table('_core_eia860__fgd_equipment',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('so2_control_id_eia', sa.Text(), nullable=False, comment='Sulfur dioxide control identification number. This ID is not a unique identifier.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('state_id_fips', sa.Text(), nullable=True, comment='Two digit state FIPS code.'),
    sa.Column('county', sa.Text(), nullable=True, comment='County name.'),
    sa.Column('county_id_fips', sa.Text(), nullable=True, comment='County ID from the Federal Information Processing Standard Publication 6-4.'),
    sa.Column('fgd_operating_date', sa.Date(), nullable=True, comment='The actual or projected in-service datetime of this flue gas desulfurization system'),
    sa.Column('fgd_operational_status_code', sa.Text(), nullable=True, comment='Operating status code for flue gas desulfurization equipment.'),
    sa.Column('flue_gas_bypass_fgd', sa.Boolean(), nullable=True, comment='Indicates whether flue gas can bypass the flue gas desulfurization unit.'),
    sa.Column('byproduct_recovery', sa.Boolean(), nullable=True, comment='Is salable byproduct is recovered by the unit?'),
    sa.Column('sludge_pond', sa.Boolean(), nullable=True, comment='Indicates if there is a sludge pond associated with this unit.'),
    sa.Column('sludge_pond_lined', sa.Boolean(), nullable=True, comment='Indicates whether the sludge pond is lined.'),
    sa.Column('pond_landfill_requirements_acre_foot_per_year', sa.Float(), nullable=True, comment='Annual pond and land fill requirements for flue gas desulfurization equipment.'),
    sa.Column('fgd_structure_cost', sa.Float(), nullable=True, comment='Actual installed costs for the existing systems or the anticipated costs of structures and equipment to bring a planned flue gas desulfurization system into commercial operation.'),
    sa.Column('fgd_other_cost', sa.Float(), nullable=True, comment='Other actual installed costs for installation of a flue gas desulfurization unit or the anticipated other costs pertaining to the installation of a flue gas desulfurization unit.'),
    sa.Column('sludge_disposal_cost', sa.Float(), nullable=True, comment='Actual installed costs for the existing sludge transport and disposal systems or the anticipated costs of sludge transport and disposal systems to bring a planned system into commercial operation.'),
    sa.Column('total_fgd_equipment_cost', sa.Float(), nullable=True, comment='Total actual installed costs for the existing flue gas desulfurization unit or the anticipated costs to bring a planned flue gas desulfurization unit into commercial operation.'),
    sa.Column('fgd_trains_100pct', sa.Float(), nullable=True, comment='Total number of flue gas desulfurization unit scrubber trains operated at 100 percent load.'),
    sa.Column('fgd_trains_total', sa.Float(), nullable=True, comment='Total number of flue gas desulfurization unit scrubber trains.'),
    sa.Column('flue_gas_entering_fgd_pct_of_total', sa.Float(), nullable=True, comment='Ratio of all flue gas that is entering the flue gas desulfurization unit.'),
    sa.Column('flue_gas_exit_rate_cubic_feet_per_minute', sa.Float(), nullable=True, comment='Actual flue gas exit rate, in cubic feet per minute.'),
    sa.Column('flue_gas_exit_temperature_fahrenheit', sa.Float(), nullable=True, comment='Flue gas exit temperature, in degrees Fahrenheit.'),
    sa.Column('so2_emission_rate_lbs_per_hour', sa.Float(), nullable=True, comment='Sulfur dioxide emission rate when operating at 100 percent load (pounds per hour).'),
    sa.Column('so2_equipment_type_1', sa.Text(), nullable=True, comment='Type of sulfur dioxide control equipment.'),
    sa.Column('so2_equipment_type_2', sa.Text(), nullable=True, comment='Type of sulfur dioxide control equipment.'),
    sa.Column('so2_equipment_type_3', sa.Text(), nullable=True, comment='Type of sulfur dioxide control equipment.'),
    sa.Column('so2_equipment_type_4', sa.Text(), nullable=True, comment='Type of sulfur dioxide control equipment.'),
    sa.Column('so2_removal_efficiency_design', sa.Float(), nullable=True, comment='Designed removal efficiency for sulfur dioxide when operating at 100 percent load. Reported at the nearest 0.1 percent by weight of gases removed from the flue gas.'),
    sa.Column('specifications_of_coal_ash', sa.Float(), nullable=True, comment='Design fuel specifications for ash when burning coal or petroleum coke (nearest 0.1 percent by weight).'),
    sa.Column('specifications_of_coal_sulfur', sa.Float(), nullable=True, comment='Design fuel specifications for sulfur when burning coal or petroleum coke (nearest 0.1 percent by weight).'),
    sa.Column('sorbent_type_1', sa.Text(), nullable=True, comment='Type of sorbent used by this sulfur dioxide control equipment.'),
    sa.Column('sorbent_type_2', sa.Text(), nullable=True, comment='Type of sorbent used by this sulfur dioxide control equipment.'),
    sa.Column('sorbent_type_3', sa.Text(), nullable=True, comment='Type of sorbent used by this sulfur dioxide control equipment.'),
    sa.Column('sorbent_type_4', sa.Text(), nullable=True, comment='Type of sorbent used by this sulfur dioxide control equipment.'),
    sa.Column('fgd_manufacturer', sa.Text(), nullable=True, comment='Name of flue gas desulfurization equipment manufacturer.'),
    sa.Column('fgd_manufacturer_code', sa.Text(), nullable=True, comment='Code corresponding to name of flue gas desulfurization equipment manufacturer.'),
    sa.Column('steam_plant_type_code', sa.Integer(), nullable=True, comment='Code that describes types of steam plants from EIA 860. See steam_plant_types_eia table for more details.'),
    sa.Column('plant_summer_capacity_mw', sa.Float(), nullable=True, comment='The plant summer capacity associated with the operating generators at the plant'),
    sa.Column('water_source', sa.Text(), nullable=True, comment='Name of water source associated with the plant.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk__core_eia860__fgd_equipment_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['fgd_manufacturer_code'], ['core_eia__codes_environmental_equipment_manufacturers.code'], name=op.f('fk__core_eia860__fgd_equipment_fgd_manufacturer_code_core_eia__codes_environmental_equipment_manufacturers')),
    sa.ForeignKeyConstraint(['fgd_operational_status_code'], ['core_eia__codes_operational_status.code'], name=op.f('fk__core_eia860__fgd_equipment_fgd_operational_status_code_core_eia__codes_operational_status')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'report_date'], ['core_eia860__scd_plants.plant_id_eia', 'core_eia860__scd_plants.report_date'], name=op.f('fk__core_eia860__fgd_equipment_plant_id_eia_core_eia860__scd_plants')),
    sa.ForeignKeyConstraint(['so2_equipment_type_1'], ['core_eia__codes_emission_control_equipment_types.code'], name=op.f('fk__core_eia860__fgd_equipment_so2_equipment_type_1_core_eia__codes_emission_control_equipment_types')),
    sa.ForeignKeyConstraint(['so2_equipment_type_2'], ['core_eia__codes_emission_control_equipment_types.code'], name=op.f('fk__core_eia860__fgd_equipment_so2_equipment_type_2_core_eia__codes_emission_control_equipment_types')),
    sa.ForeignKeyConstraint(['so2_equipment_type_3'], ['core_eia__codes_emission_control_equipment_types.code'], name=op.f('fk__core_eia860__fgd_equipment_so2_equipment_type_3_core_eia__codes_emission_control_equipment_types')),
    sa.ForeignKeyConstraint(['so2_equipment_type_4'], ['core_eia__codes_emission_control_equipment_types.code'], name=op.f('fk__core_eia860__fgd_equipment_so2_equipment_type_4_core_eia__codes_emission_control_equipment_types')),
    sa.ForeignKeyConstraint(['sorbent_type_1'], ['core_eia__codes_sorbent_types.code'], name=op.f('fk__core_eia860__fgd_equipment_sorbent_type_1_core_eia__codes_sorbent_types')),
    sa.ForeignKeyConstraint(['sorbent_type_2'], ['core_eia__codes_sorbent_types.code'], name=op.f('fk__core_eia860__fgd_equipment_sorbent_type_2_core_eia__codes_sorbent_types')),
    sa.ForeignKeyConstraint(['sorbent_type_3'], ['core_eia__codes_sorbent_types.code'], name=op.f('fk__core_eia860__fgd_equipment_sorbent_type_3_core_eia__codes_sorbent_types')),
    sa.ForeignKeyConstraint(['sorbent_type_4'], ['core_eia__codes_sorbent_types.code'], name=op.f('fk__core_eia860__fgd_equipment_sorbent_type_4_core_eia__codes_sorbent_types')),
    sa.ForeignKeyConstraint(['steam_plant_type_code'], ['core_eia__codes_steam_plant_types.code'], name=op.f('fk__core_eia860__fgd_equipment_steam_plant_type_code_core_eia__codes_steam_plant_types')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk__core_eia860__fgd_equipment_utility_id_eia_core_eia860__scd_utilities')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'so2_control_id_eia', 'report_date', name=op.f('pk__core_eia860__fgd_equipment'))
    )
    op.create_table('_out_eia__plants_utilities',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk__out_eia__plants_utilities_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'report_date'], ['core_eia860__scd_plants.plant_id_eia', 'core_eia860__scd_plants.report_date'], name=op.f('fk__out_eia__plants_utilities_plant_id_eia_core_eia860__scd_plants')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk__out_eia__plants_utilities_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk__out_eia__plants_utilities_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk__out_eia__plants_utilities_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'utility_id_eia', name=op.f('pk__out_eia__plants_utilities'))
    )
    op.create_table('_out_eia__yearly_heat_rate_by_unit',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=False, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('fuel_consumed_for_electricity_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel to produce electricity, in physical unit, year to date.'),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.Float(), nullable=True, comment='Fuel content per unit of electricity generated. Coming from MCOE calculation.'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'report_date'], ['core_eia860__scd_plants.plant_id_eia', 'core_eia860__scd_plants.report_date'], name=op.f('fk__out_eia__yearly_heat_rate_by_unit_plant_id_eia_core_eia860__scd_plants')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'unit_id_pudl', name=op.f('pk__out_eia__yearly_heat_rate_by_unit'))
    )
    op.create_table('_out_ferc1__yearly_plants_utilities',
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('plant_name_ferc1', sa.Text(), nullable=False, comment='Name of the plant, as reported to FERC. This is a freeform string, not guaranteed to be consistent across references to the same plant.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk__out_ferc1__yearly_plants_utilities_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_ferc1', 'plant_name_ferc1'], ['core_pudl__assn_ferc1_pudl_plants.utility_id_ferc1', 'core_pudl__assn_ferc1_pudl_plants.plant_name_ferc1'], name=op.f('fk__out_ferc1__yearly_plants_utilities_utility_id_ferc1_core_pudl__assn_ferc1_pudl_plants')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk__out_ferc1__yearly_plants_utilities_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'plant_name_ferc1', name=op.f('pk__out_ferc1__yearly_plants_utilities'))
    )
    op.create_table('core_eia860__scd_boilers',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('boiler_id', sa.Text(), nullable=False, comment='Alphanumeric boiler ID.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('boiler_operating_date', sa.Date(), nullable=True, comment='Date the boiler began or is planned to begin commercial operation.'),
    sa.Column('boiler_status', sa.Text(), nullable=True, comment='EIA short code identifying boiler operational status.'),
    sa.Column('boiler_retirement_date', sa.Date(), nullable=True, comment='Date of the scheduled or effected retirement of the boiler.'),
    sa.Column('boiler_type', sa.Text(), nullable=True, comment='EIA short code indicating the standards under which the boiler is operating as described in the U.S. EPA regulation under 40 CFR.'),
    sa.Column('firing_type_1', sa.Text(), nullable=True, comment='EIA short code indicating the type of firing used by this boiler.'),
    sa.Column('firing_type_2', sa.Text(), nullable=True, comment='EIA short code indicating the type of firing used by this boiler.'),
    sa.Column('firing_type_3', sa.Text(), nullable=True, comment='EIA short code indicating the type of firing used by this boiler.'),
    sa.Column('firing_rate_using_coal_tons_per_hour', sa.Float(), nullable=True, comment='Design firing rate at maximum continuous steam flow for coal to the nearest 0.1 ton per hour.'),
    sa.Column('firing_rate_using_oil_bbls_per_hour', sa.Float(), nullable=True, comment='Design firing rate at maximum continuous steam flow for pet coke to the nearest 0.1 barrels per hour.'),
    sa.Column('firing_rate_using_gas_mcf_per_hour', sa.Float(), nullable=True, comment='Design firing rate at maximum continuous steam flow for gas to the nearest 0.1 cubic feet per hour.'),
    sa.Column('firing_rate_using_other_fuels', sa.Float(), nullable=True, comment='Design firing rate at maximum continuous steam flow for energy sources other than coal, petroleum, or natural gas.'),
    sa.Column('boiler_fuel_code_1', sa.Text(), nullable=True, comment='The code representing the most predominant type of energy that fuels the boiler.'),
    sa.Column('boiler_fuel_code_2', sa.Text(), nullable=True, comment='The code representing the second most predominant type of energy that fuels the boiler.'),
    sa.Column('boiler_fuel_code_3', sa.Text(), nullable=True, comment='The code representing the third most predominant type of energy that fuels the boiler.'),
    sa.Column('boiler_fuel_code_4', sa.Text(), nullable=True, comment='The code representing the fourth most predominant type of energy that fuels the boiler.'),
    sa.Column('waste_heat_input_mmbtu_per_hour', sa.Float(), nullable=True, comment='Design waste-heat input rate at maximum continuous steam flow where a waste-heat boiler is a boiler that receives all or a substantial portion of its energy input from the noncumbustible exhaust gases of a separate fuel-burning process (MMBtu per hour).'),
    sa.Column('wet_dry_bottom', sa.Text(), nullable=True, comment='Wet or Dry Bottom where Wet Bottom is defined as slag tanks that are installed at furnace throat to contain and remove molten ash from the furnace, and Dry Bottom is defined as having no slag tanks at furnace throat area, throat area is clear, and bottom ash drops through throat to bottom ash water hoppers.'),
    sa.Column('fly_ash_reinjection', sa.Boolean(), nullable=True, comment='Indicates whether the boiler is capable of re-injecting fly ash.'),
    sa.Column('hrsg', sa.Boolean(), nullable=True, comment='indicates if the boiler is a heat recovery steam generator (HRSG).'),
    sa.Column('max_steam_flow_1000_lbs_per_hour', sa.Float(), nullable=True, comment='Maximum continuous steam flow at 100 percent load.'),
    sa.Column('turndown_ratio', sa.Float(), nullable=True, comment='The turndown ratio for the boiler.'),
    sa.Column('efficiency_100pct_load', sa.Float(), nullable=True, comment='Boiler efficiency percentage when burning at 100 percent load to the nearest 0.1 percent.'),
    sa.Column('efficiency_50pct_load', sa.Float(), nullable=True, comment='Boiler efficiency percentage when burning at 50 percent load to the nearest 0.1 percent.'),
    sa.Column('air_flow_100pct_load_cubic_feet_per_minute', sa.Float(), nullable=True, comment='Total air flow including excess air at 100 percent load, reported at standard temperature and pressure (i.e. 68 F and one atmosphere pressure).'),
    sa.Column('new_source_review', sa.Boolean(), nullable=True, comment='Indicates whether the boiler is subject to New Source Review requirements.'),
    sa.Column('new_source_review_date', sa.Date(), nullable=True, comment='Month of issued New Source Review permit.'),
    sa.Column('new_source_review_permit', sa.Text(), nullable=True, comment='New Source Review permit number.'),
    sa.Column('regulation_particulate', sa.Text(), nullable=True, comment='EIA short code for most stringent type of statute or regulation code under which the boiler is operating for particulate matter control standards.'),
    sa.Column('regulation_so2', sa.Text(), nullable=True, comment='EIA short code for most stringent type of statute or regulation code under which the boiler is operating for sulfur dioxide control standards.'),
    sa.Column('regulation_nox', sa.Text(), nullable=True, comment='EIA short code for most stringent type of statute or regulation code under which the boiler is operating for nitrogen oxide control standards.'),
    sa.Column('standard_particulate_rate', sa.Float(), nullable=True, comment='Numeric value for the unit of measurement specified for particulate matter.'),
    sa.Column('standard_so2_rate', sa.Float(), nullable=True, comment='Numeric value for the unit of measurement specified for sulfur dioxide.'),
    sa.Column('standard_nox_rate', sa.Float(), nullable=True, comment='Numeric value for the unit of measurement specified for nitrogen oxide.'),
    sa.Column('unit_particulate', sa.Text(), nullable=True, comment='Numeric value for the unit of measurement specified for particulate matter.'),
    sa.Column('unit_so2', sa.Text(), nullable=True, comment='Numeric value for the unit of measurement specified for sulfur dioxide.'),
    sa.Column('unit_nox', sa.Text(), nullable=True, comment='Numeric value for the unit of measurement specified for nitrogen oxide.'),
    sa.Column('compliance_year_particulate', sa.Integer(), nullable=True, comment='Year boiler was or is expected to be in compliance with federal, state and/or local regulations for particulate matter emissions.'),
    sa.Column('compliance_year_nox', sa.Integer(), nullable=True, comment='Year boiler was or is expected to be in compliance with federal, state and/or local regulations for nitrogen oxide emissions.'),
    sa.Column('compliance_year_so2', sa.Integer(), nullable=True, comment='Year boiler was or is expected to be in compliance with federal, state and/or local regulations for sulfur dioxide emissions.'),
    sa.Column('particulate_control_out_of_compliance_strategy_1', sa.Text(), nullable=True, comment='If boiler is not in compliance with particulate matter regulations, strategy for compliance.'),
    sa.Column('particulate_control_out_of_compliance_strategy_2', sa.Text(), nullable=True, comment='If boiler is not in compliance with particulate matter regulations, strategy for compliance.'),
    sa.Column('particulate_control_out_of_compliance_strategy_3', sa.Text(), nullable=True, comment='If boiler is not in compliance with particulate matter regulations, strategy for compliance.'),
    sa.Column('so2_control_out_of_compliance_strategy_1', sa.Text(), nullable=True, comment='If boiler is not in compliance with sulfur dioxide regulations, strategy for compliance.'),
    sa.Column('so2_control_out_of_compliance_strategy_2', sa.Text(), nullable=True, comment='If boiler is not in compliance with sulfur dioxide regulations, strategy for compliance.'),
    sa.Column('so2_control_out_of_compliance_strategy_3', sa.Text(), nullable=True, comment='If boiler is not in compliance with sulfur dioxide regulations, strategy for compliance.'),
    sa.Column('so2_control_existing_caaa_compliance_strategy_1', sa.Text(), nullable=True, comment='Existing strategies to meet the sulfur dioxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('so2_control_existing_caaa_compliance_strategy_2', sa.Text(), nullable=True, comment='Existing strategies to meet the sulfur dioxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('so2_control_existing_caaa_compliance_strategy_3', sa.Text(), nullable=True, comment='Existing strategies to meet the sulfur dioxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('so2_control_planned_caaa_compliance_strategy_1', sa.Text(), nullable=True, comment='Planned strategies to meet the sulfur dioxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('so2_control_planned_caaa_compliance_strategy_2', sa.Text(), nullable=True, comment='Planned strategies to meet the sulfur dioxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('so2_control_planned_caaa_compliance_strategy_3', sa.Text(), nullable=True, comment='Planned strategies to meet the sulfur dioxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('nox_control_out_of_compliance_strategy_1', sa.Text(), nullable=True, comment='If boiler is not in compliance with nitrogen oxide regulations, strategy for compliance.'),
    sa.Column('nox_control_out_of_compliance_strategy_2', sa.Text(), nullable=True, comment='If boiler is not in compliance with nitrogen oxide regulations, strategy for compliance.'),
    sa.Column('nox_control_out_of_compliance_strategy_3', sa.Text(), nullable=True, comment='If boiler is not in compliance with nitrogen oxide regulations, strategy for compliance.'),
    sa.Column('nox_control_existing_caaa_compliance_strategy_1', sa.Text(), nullable=True, comment='Existing strategies to meet the nitrogen oxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('nox_control_existing_caaa_compliance_strategy_2', sa.Text(), nullable=True, comment='Existing strategies to meet the nitrogen oxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('nox_control_existing_caaa_compliance_strategy_3', sa.Text(), nullable=True, comment='Existing strategies to meet the nitrogen oxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('nox_control_planned_caaa_compliance_strategy_1', sa.Text(), nullable=True, comment='Planned strategies to meet the nitrogen oxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('nox_control_planned_caaa_compliance_strategy_2', sa.Text(), nullable=True, comment='Planned strategies to meet the nitrogen oxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('nox_control_planned_caaa_compliance_strategy_3', sa.Text(), nullable=True, comment='Planned strategies to meet the nitrogen oxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('compliance_year_mercury', sa.Integer(), nullable=True, comment='Year boiler was or is expected to be in compliance with federal, state and/or local regulations for mercury emissions.'),
    sa.Column('mercury_control_existing_strategy_1', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent mercury regulation.'),
    sa.Column('mercury_control_existing_strategy_2', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent mercury regulation.'),
    sa.Column('mercury_control_existing_strategy_3', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent mercury regulation.'),
    sa.Column('mercury_control_existing_strategy_4', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent mercury regulation.'),
    sa.Column('mercury_control_existing_strategy_5', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent mercury regulation.'),
    sa.Column('mercury_control_existing_strategy_6', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent mercury regulation.'),
    sa.Column('mercury_control_proposed_strategy_1', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent mercury regulation.'),
    sa.Column('mercury_control_proposed_strategy_2', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent mercury regulation.'),
    sa.Column('mercury_control_proposed_strategy_3', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent mercury regulation.'),
    sa.Column('nox_control_existing_strategy_1', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent nitrogen oxide regulation.'),
    sa.Column('nox_control_existing_strategy_2', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent nitrogen oxide regulation.'),
    sa.Column('nox_control_existing_strategy_3', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent nitrogen oxide regulation.'),
    sa.Column('nox_control_manufacturer', sa.Text(), nullable=True, comment='Name of nitrogen oxide control manufacturer.'),
    sa.Column('nox_control_manufacturer_code', sa.Text(), nullable=True, comment='Code indicating the nitrogen oxide control burner manufacturer.'),
    sa.Column('nox_control_proposed_strategy_1', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent nitrogen oxide regulation.'),
    sa.Column('nox_control_proposed_strategy_2', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent nitrogen oxide regulation.'),
    sa.Column('nox_control_proposed_strategy_3', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent nitrogen oxide regulation.'),
    sa.Column('nox_control_status_code', sa.Text(), nullable=True, comment='Nitrogen oxide control status code.'),
    sa.Column('regulation_mercury', sa.Text(), nullable=True, comment='Most stringent type of statute or regulation code under which the boiler is operating for mercury control standards.'),
    sa.Column('so2_control_existing_strategy_1', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent sulfur dioxide regulation.'),
    sa.Column('so2_control_existing_strategy_2', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent sulfur dioxide regulation.'),
    sa.Column('so2_control_existing_strategy_3', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent sulfur dioxide regulation.'),
    sa.Column('so2_control_proposed_strategy_1', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent sulfur dioxide regulation.'),
    sa.Column('so2_control_proposed_strategy_2', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent sulfur dioxide regulation.'),
    sa.Column('so2_control_proposed_strategy_3', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent sulfur dioxide regulation.'),
    sa.Column('standard_so2_percent_scrubbed', sa.Float(), nullable=True, comment='The percent of sulfur dioxide to be scrubbed specified by the most stringent sulfur dioxide regulation.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['boiler_fuel_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia860__scd_boilers_boiler_fuel_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['boiler_fuel_code_2'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia860__scd_boilers_boiler_fuel_code_2_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['boiler_fuel_code_3'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia860__scd_boilers_boiler_fuel_code_3_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['boiler_fuel_code_4'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia860__scd_boilers_boiler_fuel_code_4_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['boiler_status'], ['core_eia__codes_boiler_status.code'], name=op.f('fk_core_eia860__scd_boilers_boiler_status_core_eia__codes_boiler_status')),
    sa.ForeignKeyConstraint(['boiler_type'], ['core_eia__codes_boiler_types.code'], name=op.f('fk_core_eia860__scd_boilers_boiler_type_core_eia__codes_boiler_types')),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia860__scd_boilers_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['firing_type_1'], ['core_eia__codes_firing_types.code'], name=op.f('fk_core_eia860__scd_boilers_firing_type_1_core_eia__codes_firing_types')),
    sa.ForeignKeyConstraint(['firing_type_2'], ['core_eia__codes_firing_types.code'], name=op.f('fk_core_eia860__scd_boilers_firing_type_2_core_eia__codes_firing_types')),
    sa.ForeignKeyConstraint(['firing_type_3'], ['core_eia__codes_firing_types.code'], name=op.f('fk_core_eia860__scd_boilers_firing_type_3_core_eia__codes_firing_types')),
    sa.ForeignKeyConstraint(['mercury_control_existing_strategy_1'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_mercury_control_existing_strategy_1_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['mercury_control_existing_strategy_2'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_mercury_control_existing_strategy_2_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['mercury_control_existing_strategy_3'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_mercury_control_existing_strategy_3_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['mercury_control_existing_strategy_4'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_mercury_control_existing_strategy_4_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['mercury_control_existing_strategy_5'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_mercury_control_existing_strategy_5_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['mercury_control_existing_strategy_6'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_mercury_control_existing_strategy_6_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['mercury_control_proposed_strategy_1'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_mercury_control_proposed_strategy_1_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['mercury_control_proposed_strategy_2'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_mercury_control_proposed_strategy_2_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['mercury_control_proposed_strategy_3'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_mercury_control_proposed_strategy_3_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_existing_caaa_compliance_strategy_1'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_nox_control_existing_caaa_compliance_strategy_1_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_existing_caaa_compliance_strategy_2'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_nox_control_existing_caaa_compliance_strategy_2_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_existing_caaa_compliance_strategy_3'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_nox_control_existing_caaa_compliance_strategy_3_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_manufacturer_code'], ['core_eia__codes_environmental_equipment_manufacturers.code'], name=op.f('fk_core_eia860__scd_boilers_nox_control_manufacturer_code_core_eia__codes_environmental_equipment_manufacturers')),
    sa.ForeignKeyConstraint(['nox_control_out_of_compliance_strategy_1'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_nox_control_out_of_compliance_strategy_1_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_out_of_compliance_strategy_2'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_nox_control_out_of_compliance_strategy_2_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_out_of_compliance_strategy_3'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_nox_control_out_of_compliance_strategy_3_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_planned_caaa_compliance_strategy_1'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_nox_control_planned_caaa_compliance_strategy_1_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_planned_caaa_compliance_strategy_2'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_nox_control_planned_caaa_compliance_strategy_2_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_planned_caaa_compliance_strategy_3'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_nox_control_planned_caaa_compliance_strategy_3_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_status_code'], ['core_eia__codes_nox_control_status.code'], name=op.f('fk_core_eia860__scd_boilers_nox_control_status_code_core_eia__codes_nox_control_status')),
    sa.ForeignKeyConstraint(['particulate_control_out_of_compliance_strategy_1'], ['core_eia__codes_particulate_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_particulate_control_out_of_compliance_strategy_1_core_eia__codes_particulate_compliance_strategies')),
    sa.ForeignKeyConstraint(['particulate_control_out_of_compliance_strategy_2'], ['core_eia__codes_particulate_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_particulate_control_out_of_compliance_strategy_2_core_eia__codes_particulate_compliance_strategies')),
    sa.ForeignKeyConstraint(['particulate_control_out_of_compliance_strategy_3'], ['core_eia__codes_particulate_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_particulate_control_out_of_compliance_strategy_3_core_eia__codes_particulate_compliance_strategies')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'boiler_id'], ['core_eia__entity_boilers.plant_id_eia', 'core_eia__entity_boilers.boiler_id'], name=op.f('fk_core_eia860__scd_boilers_plant_id_eia_core_eia__entity_boilers')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'report_date'], ['core_eia860__scd_plants.plant_id_eia', 'core_eia860__scd_plants.report_date'], name=op.f('fk_core_eia860__scd_boilers_plant_id_eia_core_eia860__scd_plants')),
    sa.ForeignKeyConstraint(['regulation_mercury'], ['core_eia__codes_regulations.code'], name=op.f('fk_core_eia860__scd_boilers_regulation_mercury_core_eia__codes_regulations')),
    sa.ForeignKeyConstraint(['regulation_nox'], ['core_eia__codes_regulations.code'], name=op.f('fk_core_eia860__scd_boilers_regulation_nox_core_eia__codes_regulations')),
    sa.ForeignKeyConstraint(['regulation_particulate'], ['core_eia__codes_regulations.code'], name=op.f('fk_core_eia860__scd_boilers_regulation_particulate_core_eia__codes_regulations')),
    sa.ForeignKeyConstraint(['regulation_so2'], ['core_eia__codes_regulations.code'], name=op.f('fk_core_eia860__scd_boilers_regulation_so2_core_eia__codes_regulations')),
    sa.ForeignKeyConstraint(['so2_control_existing_caaa_compliance_strategy_1'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_so2_control_existing_caaa_compliance_strategy_1_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['so2_control_existing_caaa_compliance_strategy_2'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_so2_control_existing_caaa_compliance_strategy_2_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['so2_control_existing_caaa_compliance_strategy_3'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_so2_control_existing_caaa_compliance_strategy_3_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['so2_control_out_of_compliance_strategy_1'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_so2_control_out_of_compliance_strategy_1_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['so2_control_out_of_compliance_strategy_2'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_so2_control_out_of_compliance_strategy_2_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['so2_control_out_of_compliance_strategy_3'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_so2_control_out_of_compliance_strategy_3_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['so2_control_planned_caaa_compliance_strategy_1'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_so2_control_planned_caaa_compliance_strategy_1_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['so2_control_planned_caaa_compliance_strategy_2'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_so2_control_planned_caaa_compliance_strategy_2_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['so2_control_planned_caaa_compliance_strategy_3'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_core_eia860__scd_boilers_so2_control_planned_caaa_compliance_strategy_3_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['unit_nox'], ['core_eia__codes_nox_units.code'], name=op.f('fk_core_eia860__scd_boilers_unit_nox_core_eia__codes_nox_units')),
    sa.ForeignKeyConstraint(['unit_particulate'], ['core_eia__codes_particulate_units.code'], name=op.f('fk_core_eia860__scd_boilers_unit_particulate_core_eia__codes_particulate_units')),
    sa.ForeignKeyConstraint(['unit_so2'], ['core_eia__codes_so2_units.code'], name=op.f('fk_core_eia860__scd_boilers_unit_so2_core_eia__codes_so2_units')),
    sa.ForeignKeyConstraint(['wet_dry_bottom'], ['core_eia__codes_wet_dry_bottom.code'], name=op.f('fk_core_eia860__scd_boilers_wet_dry_bottom_core_eia__codes_wet_dry_bottom')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'boiler_id', 'report_date', name=op.f('pk_core_eia860__scd_boilers'))
    )
    op.create_table('core_eia860__scd_generators',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('operational_status_code', sa.Text(), nullable=True, comment='The operating status of the asset.'),
    sa.Column('operational_status', sa.Text(), nullable=True, comment='The operating status of the asset. For generators this is based on which tab the generator was listed in in EIA 860.'),
    sa.Column('ownership_code', sa.Text(), nullable=True, comment='Identifies the ownership for each generator.'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('summer_capacity_mw', sa.Float(), nullable=True, comment='The net summer capacity.'),
    sa.Column('summer_capacity_estimate', sa.Boolean(), nullable=True, comment='Whether the summer capacity value was an estimate'),
    sa.Column('winter_capacity_mw', sa.Float(), nullable=True, comment='The net winter capacity.'),
    sa.Column('winter_capacity_estimate', sa.Boolean(), nullable=True, comment='Whether the winter capacity value was an estimate'),
    sa.Column('net_capacity_mwdc', sa.Float(), nullable=True, comment='Generation capacity in megawatts of direct current that is subject to a net metering agreement. Typically used for behind-the-meter solar PV.'),
    sa.Column('energy_storage_capacity_mwh', sa.Float(), nullable=True, comment='Energy storage capacity in MWh (e.g. for batteries).'),
    sa.Column('prime_mover_code', sa.Text(), nullable=True, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('energy_source_code_1', sa.Text(), nullable=True, comment='The code representing the most predominant type of energy that fuels the generator.'),
    sa.Column('energy_source_code_2', sa.Text(), nullable=True, comment='The code representing the second most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_code_3', sa.Text(), nullable=True, comment='The code representing the third most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_code_4', sa.Text(), nullable=True, comment='The code representing the fourth most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_code_5', sa.Text(), nullable=True, comment='The code representing the fifth most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_code_6', sa.Text(), nullable=True, comment='The code representing the sixth most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_1_transport_1', sa.Text(), nullable=True, comment='Primary mode of transport for energy source 1.'),
    sa.Column('energy_source_1_transport_2', sa.Text(), nullable=True, comment='Secondary mode of transport for energy source 1.'),
    sa.Column('energy_source_1_transport_3', sa.Text(), nullable=True, comment='Tertiary mode of transport for energy source 1.'),
    sa.Column('energy_source_2_transport_1', sa.Text(), nullable=True, comment='Primary mode of transport for energy source 2.'),
    sa.Column('energy_source_2_transport_2', sa.Text(), nullable=True, comment='Secondary mode of transport for energy source 2.'),
    sa.Column('energy_source_2_transport_3', sa.Text(), nullable=True, comment='Tertiary mode of transport for energy source 2.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('multiple_fuels', sa.Boolean(), nullable=True, comment='Can the generator burn multiple fuels?'),
    sa.Column('deliver_power_transgrid', sa.Boolean(), nullable=True, comment='Indicate whether the generator can deliver power to the transmission grid.'),
    sa.Column('distributed_generation', sa.Boolean(), nullable=True, comment='Whether the generator is considered distributed generation'),
    sa.Column('syncronized_transmission_grid', sa.Boolean(), nullable=True, comment='Indicates whether standby generators (SB status) can be synchronized to the grid.'),
    sa.Column('turbines_num', sa.Integer(), nullable=True, comment='Number of wind turbines, or hydrokinetic buoys.'),
    sa.Column('planned_modifications', sa.Boolean(), nullable=True, comment='Indicates whether there are any planned capacity uprates/derates, repowering, other modifications, or generator retirements scheduled for the next 5 years.'),
    sa.Column('planned_net_summer_capacity_uprate_mw', sa.Float(), nullable=True, comment='Increase in summer capacity expected to be realized from the modification to the equipment.'),
    sa.Column('planned_net_winter_capacity_uprate_mw', sa.Float(), nullable=True, comment='Increase in winter capacity expected to be realized from the uprate modification to the equipment.'),
    sa.Column('planned_uprate_date', sa.Date(), nullable=True, comment='Planned effective date that the generator is scheduled to enter operation after the uprate modification.'),
    sa.Column('planned_net_summer_capacity_derate_mw', sa.Float(), nullable=True, comment='Decrease in summer capacity expected to be realized from the derate modification to the equipment.'),
    sa.Column('planned_net_winter_capacity_derate_mw', sa.Float(), nullable=True, comment='Decrease in winter capacity expected to be realized from the derate modification to the equipment.'),
    sa.Column('planned_derate_date', sa.Date(), nullable=True, comment='Planned effective month that the generator is scheduled to enter operation after the derate modification.'),
    sa.Column('planned_new_prime_mover_code', sa.Text(), nullable=True, comment='New prime mover for the planned repowered generator.'),
    sa.Column('planned_energy_source_code_1', sa.Text(), nullable=True, comment='New energy source code for the planned repowered generator.'),
    sa.Column('planned_repower_date', sa.Date(), nullable=True, comment='Planned effective date that the generator is scheduled to enter operation after the repowering is complete.'),
    sa.Column('other_planned_modifications', sa.Boolean(), nullable=True, comment='Indicates whether there are there other modifications planned for the generator.'),
    sa.Column('other_modifications_date', sa.Date(), nullable=True, comment='Planned effective date that the generator is scheduled to enter commercial operation after any other planned modification is complete.'),
    sa.Column('planned_generator_retirement_date', sa.Date(), nullable=True, comment='Planned effective date of the scheduled retirement of the generator.'),
    sa.Column('carbon_capture', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses carbon capture technology.'),
    sa.Column('startup_source_code_1', sa.Text(), nullable=True, comment='The code representing the first, second, third or fourth start-up and flame stabilization energy source used by the combustion unit(s) associated with this generator.'),
    sa.Column('startup_source_code_2', sa.Text(), nullable=True, comment='The code representing the first, second, third or fourth start-up and flame stabilization energy source used by the combustion unit(s) associated with this generator.'),
    sa.Column('startup_source_code_3', sa.Text(), nullable=True, comment='The code representing the first, second, third or fourth start-up and flame stabilization energy source used by the combustion unit(s) associated with this generator.'),
    sa.Column('startup_source_code_4', sa.Text(), nullable=True, comment='The code representing the first, second, third or fourth start-up and flame stabilization energy source used by the combustion unit(s) associated with this generator.'),
    sa.Column('technology_description', sa.Text(), nullable=True, comment='High level description of the technology used by the generator to produce electricity.'),
    sa.Column('turbines_inverters_hydrokinetics', sa.Integer(), nullable=True, comment='Number of wind turbines, or hydrokinetic buoys.'),
    sa.Column('time_cold_shutdown_full_load_code', sa.Text(), nullable=True, comment='The minimum amount of time required to bring the unit to full load from shutdown.'),
    sa.Column('planned_new_capacity_mw', sa.Float(), nullable=True, comment='The expected new namplate capacity for the generator.'),
    sa.Column('cofire_fuels', sa.Boolean(), nullable=True, comment='Can the generator co-fire fuels?.'),
    sa.Column('switch_oil_gas', sa.Boolean(), nullable=True, comment='Indicates whether the generator switch between oil and natural gas.'),
    sa.Column('nameplate_power_factor', sa.Float(), nullable=True, comment='The nameplate power factor of the generator.'),
    sa.Column('minimum_load_mw', sa.Float(), nullable=True, comment='The minimum load at which the generator can operate at continuosuly.'),
    sa.Column('uprate_derate_during_year', sa.Boolean(), nullable=True, comment='Was an uprate or derate completed on this generator during the reporting year?'),
    sa.Column('uprate_derate_completed_date', sa.Date(), nullable=True, comment='The date when the uprate or derate was completed.'),
    sa.Column('current_planned_generator_operating_date', sa.Date(), nullable=True, comment='The most recently updated effective date on which the generator is scheduled to start operation'),
    sa.Column('summer_estimated_capability_mw', sa.Float(), nullable=True, comment='EIA estimated summer capacity (in MWh).'),
    sa.Column('winter_estimated_capability_mw', sa.Float(), nullable=True, comment='EIA estimated winter capacity (in MWh).'),
    sa.Column('generator_retirement_date', sa.Date(), nullable=True, comment='Date of the scheduled or effected retirement of the generator.'),
    sa.Column('owned_by_non_utility', sa.Boolean(), nullable=True, comment='Whether any part of generator is owned by a nonutilty'),
    sa.Column('reactive_power_output_mvar', sa.Float(), nullable=True, comment='Reactive Power Output (MVAr)'),
    sa.Column('ferc_qualifying_facility', sa.Boolean(), nullable=True, comment='Indicates whether or not a generator is a qualifying FERC cogeneration facility.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia860__scd_generators_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_1_transport_1'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_core_eia860__scd_generators_energy_source_1_transport_1_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_1_transport_2'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_core_eia860__scd_generators_energy_source_1_transport_2_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_1_transport_3'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_core_eia860__scd_generators_energy_source_1_transport_3_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_2_transport_1'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_core_eia860__scd_generators_energy_source_2_transport_1_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_2_transport_2'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_core_eia860__scd_generators_energy_source_2_transport_2_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_2_transport_3'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_core_eia860__scd_generators_energy_source_2_transport_3_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia860__scd_generators_energy_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_2'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia860__scd_generators_energy_source_code_2_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_3'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia860__scd_generators_energy_source_code_3_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_4'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia860__scd_generators_energy_source_code_4_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_5'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia860__scd_generators_energy_source_code_5_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_6'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia860__scd_generators_energy_source_code_6_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['operational_status_code'], ['core_eia__codes_operational_status.code'], name=op.f('fk_core_eia860__scd_generators_operational_status_code_core_eia__codes_operational_status')),
    sa.ForeignKeyConstraint(['planned_energy_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia860__scd_generators_planned_energy_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['planned_new_prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_core_eia860__scd_generators_planned_new_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk_core_eia860__scd_generators_plant_id_eia_core_eia__entity_generators')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'report_date'], ['core_eia860__scd_plants.plant_id_eia', 'core_eia860__scd_plants.report_date'], name=op.f('fk_core_eia860__scd_generators_plant_id_eia_core_eia860__scd_plants')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_core_eia860__scd_generators_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['startup_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia860__scd_generators_startup_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['startup_source_code_2'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia860__scd_generators_startup_source_code_2_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['startup_source_code_3'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia860__scd_generators_startup_source_code_3_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['startup_source_code_4'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_core_eia860__scd_generators_startup_source_code_4_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk_core_eia860__scd_generators_utility_id_eia_core_eia860__scd_utilities')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'generator_id', 'report_date', name=op.f('pk_core_eia860__scd_generators'))
    )
    op.create_table('core_ferc1__yearly_hydroelectric_plants_sched406',
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('plant_name_ferc1', sa.Text(), nullable=True, comment='Name of the plant, as reported to FERC. This is a freeform string, not guaranteed to be consistent across references to the same plant.'),
    sa.Column('project_num', sa.Integer(), nullable=True, comment='FERC Licensed Project Number.'),
    sa.Column('plant_type', sa.Enum('run_of_river', 'storage', 'hydro', 'run_of_river_with_storage', 'na_category'), nullable=True, comment='Type of plant.'),
    sa.Column('construction_type', sa.Enum('conventional', 'outdoor', 'semioutdoor'), nullable=True, comment="Type of plant construction ('outdoor', 'semioutdoor', or 'conventional'). Categorized by PUDL based on our best guess of intended value in FERC1 freeform strings."),
    sa.Column('construction_year', sa.Integer(), nullable=True, comment="Year the plant's oldest still operational unit was built."),
    sa.Column('installation_year', sa.Integer(), nullable=True, comment="Year the plant's most recently built unit was installed."),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('peak_demand_mw', sa.Float(), nullable=True, comment='Net peak demand for 60 minutes. Note: in some cases peak demand for other time periods may have been reported instead, if hourly peak demand was unavailable.'),
    sa.Column('plant_hours_connected_while_generating', sa.Float(), nullable=True, comment='Hours the plant was connected to load while generating in the report year.'),
    sa.Column('net_capacity_favorable_conditions_mw', sa.Float(), nullable=True, comment='Net plant capability under the most favorable operating conditions, in megawatts.'),
    sa.Column('net_capacity_adverse_conditions_mw', sa.Float(), nullable=True, comment='Net plant capability under the least favorable operating conditions, in megawatts.'),
    sa.Column('avg_num_employees', sa.Float(), nullable=True, comment='The average number of employees assigned to each plant.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('capex_land', sa.Float(), nullable=True, comment='Cost of plant: land and land rights (USD).'),
    sa.Column('capex_structures', sa.Float(), nullable=True, comment='Cost of plant: structures and improvements (USD).'),
    sa.Column('capex_facilities', sa.Float(), nullable=True, comment='Cost of plant: reservoirs, dams, and waterways (USD).'),
    sa.Column('capex_equipment', sa.Float(), nullable=True, comment='Cost of plant: equipment (USD).'),
    sa.Column('capex_roads', sa.Float(), nullable=True, comment='Cost of plant: roads, railroads, and bridges (USD).'),
    sa.Column('asset_retirement_cost', sa.Float(), nullable=True, comment='Asset retirement cost (USD).'),
    sa.Column('capex_total', sa.Float(), nullable=True, comment='Total cost of plant (USD).'),
    sa.Column('capex_per_mw', sa.Float(), nullable=True, comment='Cost of plant per megawatt of installed (nameplate) capacity. Nominal USD.'),
    sa.Column('opex_operations', sa.Float(), nullable=True, comment='Production expenses: operations, supervision, and engineering (USD).'),
    sa.Column('opex_water_for_power', sa.Float(), nullable=True, comment='Production expenses: water for power (USD).'),
    sa.Column('opex_hydraulic', sa.Float(), nullable=True, comment='Production expenses: hydraulic expenses (USD).'),
    sa.Column('opex_electric', sa.Float(), nullable=True, comment='Production expenses: electric expenses (USD).'),
    sa.Column('opex_generation_misc', sa.Float(), nullable=True, comment='Production expenses: miscellaneous power generation expenses (USD).'),
    sa.Column('opex_rents', sa.Float(), nullable=True, comment='Production expenses: rents (USD).'),
    sa.Column('opex_engineering', sa.Float(), nullable=True, comment='Production expenses: maintenance, supervision, and engineering (USD).'),
    sa.Column('opex_structures', sa.Float(), nullable=True, comment='Production expenses: maintenance of structures (USD).'),
    sa.Column('opex_dams', sa.Float(), nullable=True, comment='Production expenses: maintenance of reservoirs, dams, and waterways (USD).'),
    sa.Column('opex_plant', sa.Float(), nullable=True, comment='Production expenses: maintenance of electric plant (USD).'),
    sa.Column('opex_misc_plant', sa.Float(), nullable=True, comment='Production expenses: maintenance of miscellaneous hydraulic plant (USD).'),
    sa.Column('opex_total', sa.Float(), nullable=True, comment='Total production expenses, excluding fuel (USD).'),
    sa.Column('opex_per_mwh', sa.Float(), nullable=True, comment='Total production expenses (USD per MWh generated).'),
    sa.ForeignKeyConstraint(['utility_id_ferc1', 'plant_name_ferc1'], ['core_pudl__assn_ferc1_pudl_plants.utility_id_ferc1', 'core_pudl__assn_ferc1_pudl_plants.plant_name_ferc1'], name=op.f('fk_core_ferc1__yearly_hydroelectric_plants_sched406_utility_id_ferc1_core_pudl__assn_ferc1_pudl_plants'))
    )
    op.create_table('core_ferc1__yearly_pumped_storage_plants_sched408',
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('plant_name_ferc1', sa.Text(), nullable=True, comment='Name of the plant, as reported to FERC. This is a freeform string, not guaranteed to be consistent across references to the same plant.'),
    sa.Column('project_num', sa.Integer(), nullable=True, comment='FERC Licensed Project Number.'),
    sa.Column('construction_type', sa.Enum('conventional', 'outdoor', 'semioutdoor'), nullable=True, comment="Type of plant construction ('outdoor', 'semioutdoor', or 'conventional'). Categorized by PUDL based on our best guess of intended value in FERC1 freeform strings."),
    sa.Column('construction_year', sa.Integer(), nullable=True, comment="Year the plant's oldest still operational unit was built."),
    sa.Column('installation_year', sa.Integer(), nullable=True, comment="Year the plant's most recently built unit was installed."),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('peak_demand_mw', sa.Float(), nullable=True, comment='Net peak demand for 60 minutes. Note: in some cases peak demand for other time periods may have been reported instead, if hourly peak demand was unavailable.'),
    sa.Column('plant_hours_connected_while_generating', sa.Float(), nullable=True, comment='Hours the plant was connected to load while generating in the report year.'),
    sa.Column('plant_capability_mw', sa.Float(), nullable=True, comment='Net plant capability in megawatts.'),
    sa.Column('avg_num_employees', sa.Float(), nullable=True, comment='The average number of employees assigned to each plant.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('energy_used_for_pumping_mwh', sa.Float(), nullable=True, comment='Energy used for pumping, in megawatt-hours.'),
    sa.Column('net_load_mwh', sa.Float(), nullable=True, comment='Net output for load (net generation - energy used for pumping) in megawatt-hours.'),
    sa.Column('capex_land', sa.Float(), nullable=True, comment='Cost of plant: land and land rights (USD).'),
    sa.Column('capex_structures', sa.Float(), nullable=True, comment='Cost of plant: structures and improvements (USD).'),
    sa.Column('capex_facilities', sa.Float(), nullable=True, comment='Cost of plant: reservoirs, dams, and waterways (USD).'),
    sa.Column('capex_wheels_turbines_generators', sa.Float(), nullable=True, comment='Cost of plant: water wheels, turbines, and generators (USD).'),
    sa.Column('capex_equipment_electric', sa.Float(), nullable=True, comment='Cost of plant: accessory electric equipment (USD).'),
    sa.Column('capex_equipment_misc', sa.Float(), nullable=True, comment='Cost of plant: miscellaneous power plant equipment (USD).'),
    sa.Column('capex_roads', sa.Float(), nullable=True, comment='Cost of plant: roads, railroads, and bridges (USD).'),
    sa.Column('asset_retirement_cost', sa.Float(), nullable=True, comment='Asset retirement cost (USD).'),
    sa.Column('capex_total', sa.Float(), nullable=True, comment='Total cost of plant (USD).'),
    sa.Column('capex_per_mw', sa.Float(), nullable=True, comment='Cost of plant per megawatt of installed (nameplate) capacity. Nominal USD.'),
    sa.Column('opex_operations', sa.Float(), nullable=True, comment='Production expenses: operations, supervision, and engineering (USD).'),
    sa.Column('opex_water_for_power', sa.Float(), nullable=True, comment='Production expenses: water for power (USD).'),
    sa.Column('opex_pumped_storage', sa.Float(), nullable=True, comment='Production expenses: pumped storage (USD).'),
    sa.Column('opex_electric', sa.Float(), nullable=True, comment='Production expenses: electric expenses (USD).'),
    sa.Column('opex_generation_misc', sa.Float(), nullable=True, comment='Production expenses: miscellaneous power generation expenses (USD).'),
    sa.Column('opex_rents', sa.Float(), nullable=True, comment='Production expenses: rents (USD).'),
    sa.Column('opex_engineering', sa.Float(), nullable=True, comment='Production expenses: maintenance, supervision, and engineering (USD).'),
    sa.Column('opex_structures', sa.Float(), nullable=True, comment='Production expenses: maintenance of structures (USD).'),
    sa.Column('opex_dams', sa.Float(), nullable=True, comment='Production expenses: maintenance of reservoirs, dams, and waterways (USD).'),
    sa.Column('opex_plant', sa.Float(), nullable=True, comment='Production expenses: maintenance of electric plant (USD).'),
    sa.Column('opex_misc_plant', sa.Float(), nullable=True, comment='Production expenses: maintenance of miscellaneous hydraulic plant (USD).'),
    sa.Column('opex_production_before_pumping', sa.Float(), nullable=True, comment='Total production expenses before pumping (USD).'),
    sa.Column('opex_pumping', sa.Float(), nullable=True, comment='Production expenses: We are here to PUMP YOU UP! (USD).'),
    sa.Column('opex_total', sa.Float(), nullable=True, comment='Total production expenses, excluding fuel (USD).'),
    sa.Column('opex_per_mwh', sa.Float(), nullable=True, comment='Total production expenses (USD per MWh generated).'),
    sa.ForeignKeyConstraint(['utility_id_ferc1', 'plant_name_ferc1'], ['core_pudl__assn_ferc1_pudl_plants.utility_id_ferc1', 'core_pudl__assn_ferc1_pudl_plants.plant_name_ferc1'], name=op.f('fk_core_ferc1__yearly_pumped_storage_plants_sched408_utility_id_ferc1_core_pudl__assn_ferc1_pudl_plants'))
    )
    op.create_table('core_ferc1__yearly_small_plants_sched410',
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('plant_name_ferc1', sa.Text(), nullable=True, comment='Name of the plant, as reported to FERC. This is a freeform string, not guaranteed to be consistent across references to the same plant.'),
    sa.Column('plant_type', sa.Text(), nullable=True, comment='Type of plant.'),
    sa.Column('license_id_ferc1', sa.Integer(), nullable=True, comment='FERC issued operating license ID for the facility, if available. This value is extracted from the original plant name where possible.'),
    sa.Column('construction_year', sa.Integer(), nullable=True, comment="Year the plant's oldest still operational unit was built."),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('peak_demand_mw', sa.Float(), nullable=True, comment='Net peak demand for 60 minutes. Note: in some cases peak demand for other time periods may have been reported instead, if hourly peak demand was unavailable.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('capex_total', sa.Float(), nullable=True, comment='Total cost of plant (USD).'),
    sa.Column('capex_per_mw', sa.Float(), nullable=True, comment='Cost of plant per megawatt of installed (nameplate) capacity. Nominal USD.'),
    sa.Column('opex_operations', sa.Float(), nullable=True, comment='Production expenses: operations, supervision, and engineering (USD).'),
    sa.Column('opex_fuel', sa.Float(), nullable=True, comment='Production expenses: fuel (USD).'),
    sa.Column('opex_maintenance', sa.Float(), nullable=True, comment='Production expenses: Maintenance (USD).'),
    sa.Column('fuel_type', sa.Text(), nullable=True, comment='Type of fuel.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1', 'plant_name_ferc1'], ['core_pudl__assn_ferc1_pudl_plants.utility_id_ferc1', 'core_pudl__assn_ferc1_pudl_plants.plant_name_ferc1'], name=op.f('fk_core_ferc1__yearly_small_plants_sched410_utility_id_ferc1_core_pudl__assn_ferc1_pudl_plants'))
    )
    op.create_table('core_ferc1__yearly_steam_plants_fuel_sched402',
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('plant_name_ferc1', sa.Text(), nullable=True, comment='Name of the plant, as reported to FERC. This is a freeform string, not guaranteed to be consistent across references to the same plant.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_units', sa.Enum('mmbtu', 'gramsU', 'kg', 'mwhth', 'kgal', 'bbl', 'klbs', 'mcf', 'gal', 'mwdth', 'btu', 'ton'), nullable=True, comment='Reported unit of measure for fuel.'),
    sa.Column('fuel_consumed_units', sa.Float(), nullable=True, comment='Consumption of the fuel type in physical unit. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Heat content of the fuel in millions of Btus per physical unit.'),
    sa.Column('fuel_cost_per_unit_burned', sa.Float(), nullable=True, comment='Average cost of fuel consumed in the report year per reported fuel unit (USD).'),
    sa.Column('fuel_cost_per_unit_delivered', sa.Float(), nullable=True, comment='Average cost of fuel delivered in the report year per reported fuel unit (USD).'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.ForeignKeyConstraint(['utility_id_ferc1', 'plant_name_ferc1'], ['core_pudl__assn_ferc1_pudl_plants.utility_id_ferc1', 'core_pudl__assn_ferc1_pudl_plants.plant_name_ferc1'], name=op.f('fk_core_ferc1__yearly_steam_plants_fuel_sched402_utility_id_ferc1_core_pudl__assn_ferc1_pudl_plants'))
    )
    op.create_table('core_ferc1__yearly_steam_plants_sched402',
    sa.Column('record_id', sa.Text(), nullable=True, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('plant_name_ferc1', sa.Text(), nullable=True, comment='Name of the plant, as reported to FERC. This is a freeform string, not guaranteed to be consistent across references to the same plant.'),
    sa.Column('plant_type', sa.Enum('combined_cycle', 'steam', 'na_category', 'internal_combustion', 'geothermal', 'photovoltaic', 'solar_thermal', 'combustion_turbine', 'nuclear', 'wind'), nullable=True, comment='Type of plant.'),
    sa.Column('construction_type', sa.Enum('conventional', 'outdoor', 'semioutdoor'), nullable=True, comment="Type of plant construction ('outdoor', 'semioutdoor', or 'conventional'). Categorized by PUDL based on our best guess of intended value in FERC1 freeform strings."),
    sa.Column('construction_year', sa.Integer(), nullable=True, comment="Year the plant's oldest still operational unit was built."),
    sa.Column('installation_year', sa.Integer(), nullable=True, comment="Year the plant's most recently built unit was installed."),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('peak_demand_mw', sa.Float(), nullable=True, comment='Net peak demand for 60 minutes. Note: in some cases peak demand for other time periods may have been reported instead, if hourly peak demand was unavailable.'),
    sa.Column('plant_hours_connected_while_generating', sa.Float(), nullable=True, comment='Hours the plant was connected to load while generating in the report year.'),
    sa.Column('plant_capability_mw', sa.Float(), nullable=True, comment='Net plant capability in megawatts.'),
    sa.Column('water_limited_capacity_mw', sa.Float(), nullable=True, comment='Plant capacity in MW when limited by condenser water.'),
    sa.Column('not_water_limited_capacity_mw', sa.Float(), nullable=True, comment='Plant capacity in MW when not limited by condenser water.'),
    sa.Column('avg_num_employees', sa.Float(), nullable=True, comment='The average number of employees assigned to each plant.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('capex_land', sa.Float(), nullable=True, comment='Cost of plant: land and land rights (USD).'),
    sa.Column('capex_structures', sa.Float(), nullable=True, comment='Cost of plant: structures and improvements (USD).'),
    sa.Column('capex_equipment', sa.Float(), nullable=True, comment='Cost of plant: equipment (USD).'),
    sa.Column('capex_total', sa.Float(), nullable=True, comment='Total cost of plant (USD).'),
    sa.Column('capex_per_mw', sa.Float(), nullable=True, comment='Cost of plant per megawatt of installed (nameplate) capacity. Nominal USD.'),
    sa.Column('opex_operations', sa.Float(), nullable=True, comment='Production expenses: operations, supervision, and engineering (USD).'),
    sa.Column('opex_fuel', sa.Float(), nullable=True, comment='Production expenses: fuel (USD).'),
    sa.Column('opex_coolants', sa.Float(), nullable=True, comment='Cost of coolants and water (nuclear plants only)'),
    sa.Column('opex_steam', sa.Float(), nullable=True, comment='Steam expenses.'),
    sa.Column('opex_steam_other', sa.Float(), nullable=True, comment='Steam from other sources.'),
    sa.Column('opex_transfer', sa.Float(), nullable=True, comment='Steam transferred (Credit).'),
    sa.Column('opex_electric', sa.Float(), nullable=True, comment='Production expenses: electric expenses (USD).'),
    sa.Column('opex_misc_power', sa.Float(), nullable=True, comment='Miscellaneous steam (or nuclear) expenses.'),
    sa.Column('opex_rents', sa.Float(), nullable=True, comment='Production expenses: rents (USD).'),
    sa.Column('opex_allowances', sa.Float(), nullable=True, comment='Allowances.'),
    sa.Column('opex_engineering', sa.Float(), nullable=True, comment='Production expenses: maintenance, supervision, and engineering (USD).'),
    sa.Column('opex_structures', sa.Float(), nullable=True, comment='Production expenses: maintenance of structures (USD).'),
    sa.Column('opex_boiler', sa.Float(), nullable=True, comment='Maintenance of boiler (or reactor) plant.'),
    sa.Column('opex_plants', sa.Float(), nullable=True, comment='Maintenance of electrical plant.'),
    sa.Column('opex_misc_steam', sa.Float(), nullable=True, comment='Maintenance of miscellaneous steam (or nuclear) plant.'),
    sa.Column('opex_production_total', sa.Float(), nullable=True, comment='Total operating expenses.'),
    sa.Column('opex_per_mwh', sa.Float(), nullable=True, comment='Total production expenses (USD per MWh generated).'),
    sa.Column('asset_retirement_cost', sa.Float(), nullable=True, comment='Asset retirement cost (USD).'),
    sa.ForeignKeyConstraint(['utility_id_ferc1', 'plant_name_ferc1'], ['core_pudl__assn_ferc1_pudl_plants.utility_id_ferc1', 'core_pudl__assn_ferc1_pudl_plants.plant_name_ferc1'], name=op.f('fk_core_ferc1__yearly_steam_plants_sched402_utility_id_ferc1_core_pudl__assn_ferc1_pudl_plants'))
    )
    op.create_table('out_eia923__yearly_fuel_receipts_costs',
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=True, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_received_units', sa.Float(), nullable=True, comment='Quanity of fuel received in tons, barrel, or Mcf.'),
    sa.Column('fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Heat content of the fuel in millions of Btus per physical unit.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('total_fuel_cost', sa.Float(), nullable=True, comment='Total annual reported fuel costs for the plant part. Includes costs from all fuels.'),
    sa.Column('fuel_cost_from_eiaapi', sa.Boolean(), nullable=True, comment='Indicates whether the fuel cost was derived from the EIA API.'),
    sa.Column('sulfur_content_pct', sa.Float(), nullable=True, comment='Sulfur content percentage by weight to the nearest 0.01 percent.'),
    sa.Column('ash_content_pct', sa.Float(), nullable=True, comment='Ash content percentage by weight to the nearest 0.1 percent.'),
    sa.Column('mercury_content_ppm', sa.Float(), nullable=True, comment='Mercury content in parts per million (ppm) to the nearest 0.001 ppm.'),
    sa.Column('moisture_content_pct', sa.Float(), nullable=True, comment='For coal only: the moisture content of the fuel in terms of moisture percentage by weight. Reported to the nearest 0.01 percent.'),
    sa.Column('chlorine_content_ppm', sa.Float(), nullable=True, comment='For coal only: the chlorine content in parts per million (ppm) to the nearest 0.001 ppm. If lab tests of the coal do not include the chlorine content, this field contains the amount specified in the contract with the supplier.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia923__yearly_fuel_receipts_costs_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'report_date'], ['core_eia860__scd_plants.plant_id_eia', 'core_eia860__scd_plants.report_date'], name=op.f('fk_out_eia923__yearly_fuel_receipts_costs_plant_id_eia_core_eia860__scd_plants')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia923__yearly_fuel_receipts_costs_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk_out_eia923__yearly_fuel_receipts_costs_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia923__yearly_fuel_receipts_costs_utility_id_pudl_core_pudl__entity_utilities_pudl'))
    )
    op.create_table('out_eia923__yearly_generation_fuel_combined',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('energy_source_code', sa.Text(), nullable=False, comment='A 2-3 letter code indicating the energy source (e.g. fuel type) associated with the record.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('prime_mover_code', sa.Text(), nullable=False, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('fuel_consumed_units', sa.Float(), nullable=True, comment='Consumption of the fuel type in physical unit. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_consumed_for_electricity_units', sa.Float(), nullable=True, comment='Consumption for electric generation of the fuel type in physical unit.'),
    sa.Column('fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Heat content of the fuel in millions of Btus per physical unit.'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_consumed_for_electricity_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel to produce electricity, in physical unit, year to date.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia923__yearly_generation_fuel_combined_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_code'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia923__yearly_generation_fuel_combined_energy_source_code_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'report_date'], ['core_eia860__scd_plants.plant_id_eia', 'core_eia860__scd_plants.report_date'], name=op.f('fk_out_eia923__yearly_generation_fuel_combined_plant_id_eia_core_eia860__scd_plants')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia923__yearly_generation_fuel_combined_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_out_eia923__yearly_generation_fuel_combined_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk_out_eia923__yearly_generation_fuel_combined_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia923__yearly_generation_fuel_combined_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_date', 'prime_mover_code', 'energy_source_code', name=op.f('pk_out_eia923__yearly_generation_fuel_combined'))
    )
    op.create_table('out_eia__yearly_plants',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('city', sa.Text(), nullable=True, comment='Name of the city.'),
    sa.Column('county', sa.Text(), nullable=True, comment='County name.'),
    sa.Column('latitude', sa.Float(), nullable=True, comment="Latitude of the plant's location, in degrees."),
    sa.Column('longitude', sa.Float(), nullable=True, comment="Longitude of the plant's location, in degrees."),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('street_address', sa.Text(), nullable=True, comment='Physical street address.'),
    sa.Column('zip_code', sa.Text(), nullable=True, comment='Five digit US Zip Code.'),
    sa.Column('timezone', sa.Enum('Africa/Abidjan', 'Africa/Accra', 'Africa/Addis_Ababa', 'Africa/Algiers', 'Africa/Asmara', 'Africa/Asmera', 'Africa/Bamako', 'Africa/Bangui', 'Africa/Banjul', 'Africa/Bissau', 'Africa/Blantyre', 'Africa/Brazzaville', 'Africa/Bujumbura', 'Africa/Cairo', 'Africa/Casablanca', 'Africa/Ceuta', 'Africa/Conakry', 'Africa/Dakar', 'Africa/Dar_es_Salaam', 'Africa/Djibouti', 'Africa/Douala', 'Africa/El_Aaiun', 'Africa/Freetown', 'Africa/Gaborone', 'Africa/Harare', 'Africa/Johannesburg', 'Africa/Juba', 'Africa/Kampala', 'Africa/Khartoum', 'Africa/Kigali', 'Africa/Kinshasa', 'Africa/Lagos', 'Africa/Libreville', 'Africa/Lome', 'Africa/Luanda', 'Africa/Lubumbashi', 'Africa/Lusaka', 'Africa/Malabo', 'Africa/Maputo', 'Africa/Maseru', 'Africa/Mbabane', 'Africa/Mogadishu', 'Africa/Monrovia', 'Africa/Nairobi', 'Africa/Ndjamena', 'Africa/Niamey', 'Africa/Nouakchott', 'Africa/Ouagadougou', 'Africa/Porto-Novo', 'Africa/Sao_Tome', 'Africa/Timbuktu', 'Africa/Tripoli', 'Africa/Tunis', 'Africa/Windhoek', 'America/Adak', 'America/Anchorage', 'America/Anguilla', 'America/Antigua', 'America/Araguaina', 'America/Argentina/Buenos_Aires', 'America/Argentina/Catamarca', 'America/Argentina/ComodRivadavia', 'America/Argentina/Cordoba', 'America/Argentina/Jujuy', 'America/Argentina/La_Rioja', 'America/Argentina/Mendoza', 'America/Argentina/Rio_Gallegos', 'America/Argentina/Salta', 'America/Argentina/San_Juan', 'America/Argentina/San_Luis', 'America/Argentina/Tucuman', 'America/Argentina/Ushuaia', 'America/Aruba', 'America/Asuncion', 'America/Atikokan', 'America/Atka', 'America/Bahia', 'America/Bahia_Banderas', 'America/Barbados', 'America/Belem', 'America/Belize', 'America/Blanc-Sablon', 'America/Boa_Vista', 'America/Bogota', 'America/Boise', 'America/Buenos_Aires', 'America/Cambridge_Bay', 'America/Campo_Grande', 'America/Cancun', 'America/Caracas', 'America/Catamarca', 'America/Cayenne', 'America/Cayman', 'America/Chicago', 'America/Chihuahua', 'America/Ciudad_Juarez', 'America/Coral_Harbour', 'America/Cordoba', 'America/Costa_Rica', 'America/Creston', 'America/Cuiaba', 'America/Curacao', 'America/Danmarkshavn', 'America/Dawson', 'America/Dawson_Creek', 'America/Denver', 'America/Detroit', 'America/Dominica', 'America/Edmonton', 'America/Eirunepe', 'America/El_Salvador', 'America/Ensenada', 'America/Fort_Nelson', 'America/Fort_Wayne', 'America/Fortaleza', 'America/Glace_Bay', 'America/Godthab', 'America/Goose_Bay', 'America/Grand_Turk', 'America/Grenada', 'America/Guadeloupe', 'America/Guatemala', 'America/Guayaquil', 'America/Guyana', 'America/Halifax', 'America/Havana', 'America/Hermosillo', 'America/Indiana/Indianapolis', 'America/Indiana/Knox', 'America/Indiana/Marengo', 'America/Indiana/Petersburg', 'America/Indiana/Tell_City', 'America/Indiana/Vevay', 'America/Indiana/Vincennes', 'America/Indiana/Winamac', 'America/Indianapolis', 'America/Inuvik', 'America/Iqaluit', 'America/Jamaica', 'America/Jujuy', 'America/Juneau', 'America/Kentucky/Louisville', 'America/Kentucky/Monticello', 'America/Knox_IN', 'America/Kralendijk', 'America/La_Paz', 'America/Lima', 'America/Los_Angeles', 'America/Louisville', 'America/Lower_Princes', 'America/Maceio', 'America/Managua', 'America/Manaus', 'America/Marigot', 'America/Martinique', 'America/Matamoros', 'America/Mazatlan', 'America/Mendoza', 'America/Menominee', 'America/Merida', 'America/Metlakatla', 'America/Mexico_City', 'America/Miquelon', 'America/Moncton', 'America/Monterrey', 'America/Montevideo', 'America/Montreal', 'America/Montserrat', 'America/Nassau', 'America/New_York', 'America/Nipigon', 'America/Nome', 'America/Noronha', 'America/North_Dakota/Beulah', 'America/North_Dakota/Center', 'America/North_Dakota/New_Salem', 'America/Nuuk', 'America/Ojinaga', 'America/Panama', 'America/Pangnirtung', 'America/Paramaribo', 'America/Phoenix', 'America/Port-au-Prince', 'America/Port_of_Spain', 'America/Porto_Acre', 'America/Porto_Velho', 'America/Puerto_Rico', 'America/Punta_Arenas', 'America/Rainy_River', 'America/Rankin_Inlet', 'America/Recife', 'America/Regina', 'America/Resolute', 'America/Rio_Branco', 'America/Rosario', 'America/Santa_Isabel', 'America/Santarem', 'America/Santiago', 'America/Santo_Domingo', 'America/Sao_Paulo', 'America/Scoresbysund', 'America/Shiprock', 'America/Sitka', 'America/St_Barthelemy', 'America/St_Johns', 'America/St_Kitts', 'America/St_Lucia', 'America/St_Thomas', 'America/St_Vincent', 'America/Swift_Current', 'America/Tegucigalpa', 'America/Thule', 'America/Thunder_Bay', 'America/Tijuana', 'America/Toronto', 'America/Tortola', 'America/Vancouver', 'America/Virgin', 'America/Whitehorse', 'America/Winnipeg', 'America/Yakutat', 'America/Yellowknife', 'Antarctica/Casey', 'Antarctica/Davis', 'Antarctica/DumontDUrville', 'Antarctica/Macquarie', 'Antarctica/Mawson', 'Antarctica/McMurdo', 'Antarctica/Palmer', 'Antarctica/Rothera', 'Antarctica/South_Pole', 'Antarctica/Syowa', 'Antarctica/Troll', 'Antarctica/Vostok', 'Arctic/Longyearbyen', 'Asia/Aden', 'Asia/Almaty', 'Asia/Amman', 'Asia/Anadyr', 'Asia/Aqtau', 'Asia/Aqtobe', 'Asia/Ashgabat', 'Asia/Ashkhabad', 'Asia/Atyrau', 'Asia/Baghdad', 'Asia/Bahrain', 'Asia/Baku', 'Asia/Bangkok', 'Asia/Barnaul', 'Asia/Beirut', 'Asia/Bishkek', 'Asia/Brunei', 'Asia/Calcutta', 'Asia/Chita', 'Asia/Choibalsan', 'Asia/Chongqing', 'Asia/Chungking', 'Asia/Colombo', 'Asia/Dacca', 'Asia/Damascus', 'Asia/Dhaka', 'Asia/Dili', 'Asia/Dubai', 'Asia/Dushanbe', 'Asia/Famagusta', 'Asia/Gaza', 'Asia/Harbin', 'Asia/Hebron', 'Asia/Ho_Chi_Minh', 'Asia/Hong_Kong', 'Asia/Hovd', 'Asia/Irkutsk', 'Asia/Istanbul', 'Asia/Jakarta', 'Asia/Jayapura', 'Asia/Jerusalem', 'Asia/Kabul', 'Asia/Kamchatka', 'Asia/Karachi', 'Asia/Kashgar', 'Asia/Kathmandu', 'Asia/Katmandu', 'Asia/Khandyga', 'Asia/Kolkata', 'Asia/Krasnoyarsk', 'Asia/Kuala_Lumpur', 'Asia/Kuching', 'Asia/Kuwait', 'Asia/Macao', 'Asia/Macau', 'Asia/Magadan', 'Asia/Makassar', 'Asia/Manila', 'Asia/Muscat', 'Asia/Nicosia', 'Asia/Novokuznetsk', 'Asia/Novosibirsk', 'Asia/Omsk', 'Asia/Oral', 'Asia/Phnom_Penh', 'Asia/Pontianak', 'Asia/Pyongyang', 'Asia/Qatar', 'Asia/Qostanay', 'Asia/Qyzylorda', 'Asia/Rangoon', 'Asia/Riyadh', 'Asia/Saigon', 'Asia/Sakhalin', 'Asia/Samarkand', 'Asia/Seoul', 'Asia/Shanghai', 'Asia/Singapore', 'Asia/Srednekolymsk', 'Asia/Taipei', 'Asia/Tashkent', 'Asia/Tbilisi', 'Asia/Tehran', 'Asia/Tel_Aviv', 'Asia/Thimbu', 'Asia/Thimphu', 'Asia/Tokyo', 'Asia/Tomsk', 'Asia/Ujung_Pandang', 'Asia/Ulaanbaatar', 'Asia/Ulan_Bator', 'Asia/Urumqi', 'Asia/Ust-Nera', 'Asia/Vientiane', 'Asia/Vladivostok', 'Asia/Yakutsk', 'Asia/Yangon', 'Asia/Yekaterinburg', 'Asia/Yerevan', 'Atlantic/Azores', 'Atlantic/Bermuda', 'Atlantic/Canary', 'Atlantic/Cape_Verde', 'Atlantic/Faeroe', 'Atlantic/Faroe', 'Atlantic/Jan_Mayen', 'Atlantic/Madeira', 'Atlantic/Reykjavik', 'Atlantic/South_Georgia', 'Atlantic/St_Helena', 'Atlantic/Stanley', 'Australia/ACT', 'Australia/Adelaide', 'Australia/Brisbane', 'Australia/Broken_Hill', 'Australia/Canberra', 'Australia/Currie', 'Australia/Darwin', 'Australia/Eucla', 'Australia/Hobart', 'Australia/LHI', 'Australia/Lindeman', 'Australia/Lord_Howe', 'Australia/Melbourne', 'Australia/NSW', 'Australia/North', 'Australia/Perth', 'Australia/Queensland', 'Australia/South', 'Australia/Sydney', 'Australia/Tasmania', 'Australia/Victoria', 'Australia/West', 'Australia/Yancowinna', 'Brazil/Acre', 'Brazil/DeNoronha', 'Brazil/East', 'Brazil/West', 'CET', 'CST6CDT', 'Canada/Atlantic', 'Canada/Central', 'Canada/Eastern', 'Canada/Mountain', 'Canada/Newfoundland', 'Canada/Pacific', 'Canada/Saskatchewan', 'Canada/Yukon', 'Chile/Continental', 'Chile/EasterIsland', 'Cuba', 'EET', 'EST', 'EST5EDT', 'Egypt', 'Eire', 'Etc/GMT', 'Etc/GMT+0', 'Etc/GMT+1', 'Etc/GMT+10', 'Etc/GMT+11', 'Etc/GMT+12', 'Etc/GMT+2', 'Etc/GMT+3', 'Etc/GMT+4', 'Etc/GMT+5', 'Etc/GMT+6', 'Etc/GMT+7', 'Etc/GMT+8', 'Etc/GMT+9', 'Etc/GMT-0', 'Etc/GMT-1', 'Etc/GMT-10', 'Etc/GMT-11', 'Etc/GMT-12', 'Etc/GMT-13', 'Etc/GMT-14', 'Etc/GMT-2', 'Etc/GMT-3', 'Etc/GMT-4', 'Etc/GMT-5', 'Etc/GMT-6', 'Etc/GMT-7', 'Etc/GMT-8', 'Etc/GMT-9', 'Etc/GMT0', 'Etc/Greenwich', 'Etc/UCT', 'Etc/UTC', 'Etc/Universal', 'Etc/Zulu', 'Europe/Amsterdam', 'Europe/Andorra', 'Europe/Astrakhan', 'Europe/Athens', 'Europe/Belfast', 'Europe/Belgrade', 'Europe/Berlin', 'Europe/Bratislava', 'Europe/Brussels', 'Europe/Bucharest', 'Europe/Budapest', 'Europe/Busingen', 'Europe/Chisinau', 'Europe/Copenhagen', 'Europe/Dublin', 'Europe/Gibraltar', 'Europe/Guernsey', 'Europe/Helsinki', 'Europe/Isle_of_Man', 'Europe/Istanbul', 'Europe/Jersey', 'Europe/Kaliningrad', 'Europe/Kiev', 'Europe/Kirov', 'Europe/Kyiv', 'Europe/Lisbon', 'Europe/Ljubljana', 'Europe/London', 'Europe/Luxembourg', 'Europe/Madrid', 'Europe/Malta', 'Europe/Mariehamn', 'Europe/Minsk', 'Europe/Monaco', 'Europe/Moscow', 'Europe/Nicosia', 'Europe/Oslo', 'Europe/Paris', 'Europe/Podgorica', 'Europe/Prague', 'Europe/Riga', 'Europe/Rome', 'Europe/Samara', 'Europe/San_Marino', 'Europe/Sarajevo', 'Europe/Saratov', 'Europe/Simferopol', 'Europe/Skopje', 'Europe/Sofia', 'Europe/Stockholm', 'Europe/Tallinn', 'Europe/Tirane', 'Europe/Tiraspol', 'Europe/Ulyanovsk', 'Europe/Uzhgorod', 'Europe/Vaduz', 'Europe/Vatican', 'Europe/Vienna', 'Europe/Vilnius', 'Europe/Volgograd', 'Europe/Warsaw', 'Europe/Zagreb', 'Europe/Zaporozhye', 'Europe/Zurich', 'GB', 'GB-Eire', 'GMT', 'GMT+0', 'GMT-0', 'GMT0', 'Greenwich', 'HST', 'Hongkong', 'Iceland', 'Indian/Antananarivo', 'Indian/Chagos', 'Indian/Christmas', 'Indian/Cocos', 'Indian/Comoro', 'Indian/Kerguelen', 'Indian/Mahe', 'Indian/Maldives', 'Indian/Mauritius', 'Indian/Mayotte', 'Indian/Reunion', 'Iran', 'Israel', 'Jamaica', 'Japan', 'Kwajalein', 'Libya', 'MET', 'MST', 'MST7MDT', 'Mexico/BajaNorte', 'Mexico/BajaSur', 'Mexico/General', 'NZ', 'NZ-CHAT', 'Navajo', 'PRC', 'PST8PDT', 'Pacific/Apia', 'Pacific/Auckland', 'Pacific/Bougainville', 'Pacific/Chatham', 'Pacific/Chuuk', 'Pacific/Easter', 'Pacific/Efate', 'Pacific/Enderbury', 'Pacific/Fakaofo', 'Pacific/Fiji', 'Pacific/Funafuti', 'Pacific/Galapagos', 'Pacific/Gambier', 'Pacific/Guadalcanal', 'Pacific/Guam', 'Pacific/Honolulu', 'Pacific/Johnston', 'Pacific/Kanton', 'Pacific/Kiritimati', 'Pacific/Kosrae', 'Pacific/Kwajalein', 'Pacific/Majuro', 'Pacific/Marquesas', 'Pacific/Midway', 'Pacific/Nauru', 'Pacific/Niue', 'Pacific/Norfolk', 'Pacific/Noumea', 'Pacific/Pago_Pago', 'Pacific/Palau', 'Pacific/Pitcairn', 'Pacific/Pohnpei', 'Pacific/Ponape', 'Pacific/Port_Moresby', 'Pacific/Rarotonga', 'Pacific/Saipan', 'Pacific/Samoa', 'Pacific/Tahiti', 'Pacific/Tarawa', 'Pacific/Tongatapu', 'Pacific/Truk', 'Pacific/Wake', 'Pacific/Wallis', 'Pacific/Yap', 'Poland', 'Portugal', 'ROC', 'ROK', 'Singapore', 'Turkey', 'UCT', 'US/Alaska', 'US/Aleutian', 'US/Arizona', 'US/Central', 'US/East-Indiana', 'US/Eastern', 'US/Hawaii', 'US/Indiana-Starke', 'US/Michigan', 'US/Mountain', 'US/Pacific', 'US/Samoa', 'UTC', 'Universal', 'W-SU', 'WET', 'Zulu'), nullable=True, comment='IANA timezone name'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('ash_impoundment', sa.Boolean(), nullable=True, comment='Is there an ash impoundment (e.g. pond, reservoir) at the plant?'),
    sa.Column('ash_impoundment_lined', sa.Boolean(), nullable=True, comment='If there is an ash impoundment at the plant, is the impoundment lined?'),
    sa.Column('ash_impoundment_status', sa.Text(), nullable=True, comment='If there is an ash impoundment at the plant, the ash impoundment status as of December 31 of the reporting year.'),
    sa.Column('balancing_authority_code_eia', sa.Text(), nullable=True, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'),
    sa.Column('balancing_authority_name_eia', sa.Text(), nullable=True, comment='Name of the balancing authority.'),
    sa.Column('datum', sa.Text(), nullable=True, comment='Geodetic coordinate system identifier (e.g. NAD27, NAD83, or WGS84).'),
    sa.Column('energy_storage', sa.Boolean(), nullable=True, comment='Indicates if the facility has energy storage capabilities.'),
    sa.Column('ferc_cogen_docket_no', sa.Text(), nullable=True, comment='The docket number relating to the FERC cogenerator status. See FERC Form 556.'),
    sa.Column('ferc_cogen_status', sa.Boolean(), nullable=True, comment='Indicates whether the plant has FERC qualifying facility cogenerator status. See FERC Form 556.'),
    sa.Column('ferc_exempt_wholesale_generator_docket_no', sa.Text(), nullable=True, comment='The docket number relating to the FERC qualifying facility exempt wholesale generator status.'),
    sa.Column('ferc_exempt_wholesale_generator', sa.Boolean(), nullable=True, comment='Indicates whether the plant has FERC qualifying facility exempt wholesale generator status'),
    sa.Column('ferc_small_power_producer_docket_no', sa.Text(), nullable=True, comment='The docket number relating to the FERC qualifying facility small power producer status. See FERC Form 556.'),
    sa.Column('ferc_small_power_producer', sa.Boolean(), nullable=True, comment='Indicates whether the plant has FERC qualifying facility small power producer status. See FERC Form 556.'),
    sa.Column('ferc_qualifying_facility_docket_no', sa.Text(), nullable=True, comment='The docket number relating to the FERC qualifying facility cogenerator status. See FERC Form 556.'),
    sa.Column('grid_voltage_1_kv', sa.Float(), nullable=True, comment="Plant's grid voltage at point of interconnection to transmission or distibution facilities"),
    sa.Column('grid_voltage_2_kv', sa.Float(), nullable=True, comment="Plant's grid voltage at point of interconnection to transmission or distibution facilities"),
    sa.Column('grid_voltage_3_kv', sa.Float(), nullable=True, comment="Plant's grid voltage at point of interconnection to transmission or distibution facilities"),
    sa.Column('iso_rto_code', sa.Text(), nullable=True, comment="The code of the plant's ISO or RTO. NA if not reported in that year."),
    sa.Column('liquefied_natural_gas_storage', sa.Boolean(), nullable=True, comment='Indicates if the facility have the capability to store the natural gas in the form of liquefied natural gas.'),
    sa.Column('natural_gas_local_distribution_company', sa.Text(), nullable=True, comment='Names of Local Distribution Company (LDC), connected to natural gas burning power plants.'),
    sa.Column('natural_gas_storage', sa.Boolean(), nullable=True, comment='Indicates if the facility have on-site storage of natural gas.'),
    sa.Column('natural_gas_pipeline_name_1', sa.Text(), nullable=True, comment='The name of the owner or operator of natural gas pipeline that connects directly to this facility or that connects to a lateral pipeline owned by this facility.'),
    sa.Column('natural_gas_pipeline_name_2', sa.Text(), nullable=True, comment='The name of the owner or operator of natural gas pipeline that connects directly to this facility or that connects to a lateral pipeline owned by this facility.'),
    sa.Column('natural_gas_pipeline_name_3', sa.Text(), nullable=True, comment='The name of the owner or operator of natural gas pipeline that connects directly to this facility or that connects to a lateral pipeline owned by this facility.'),
    sa.Column('nerc_region', sa.Enum('BASN', 'CALN', 'CALS', 'DSW', 'ASCC', 'ISONE', 'ERCOT', 'NORW', 'NYISO', 'PJM', 'ROCK', 'ECAR', 'FRCC', 'HICC', 'MAAC', 'MAIN', 'MAPP', 'MRO', 'NPCC', 'RFC', 'SERC', 'SPP', 'TRE', 'WECC', 'WSCC', 'MISO', 'ECAR_MAAC', 'MAPP_WECC', 'RFC_SERC', 'SPP_WECC', 'MRO_WECC', 'ERCOT_SPP', 'SPP_TRE', 'ERCOT_TRE', 'MISO_TRE', 'VI', 'GU', 'PR', 'AS', 'UNK'), nullable=True, comment='NERC region in which the plant is located'),
    sa.Column('has_net_metering', sa.Boolean(), nullable=True, comment='Whether the plant has a net metering agreement in effect during the reporting year.  (Only displayed for facilities that report the sun or wind as an energy source). This field was only reported up until 2015'),
    sa.Column('pipeline_notes', sa.Text(), nullable=True, comment='Additional owner or operator of natural gas pipeline.'),
    sa.Column('primary_purpose_id_naics', sa.Integer(), nullable=True, comment='North American Industry Classification System (NAICS) code that best describes the primary purpose of the reporting plant'),
    sa.Column('regulatory_status_code', sa.Text(), nullable=True, comment='Indicates whether the plant is regulated or non-regulated.'),
    sa.Column('reporting_frequency_code', sa.Enum('A', 'AM', 'M'), nullable=True, comment='Code that specifies what time period data has to be reported (i.e. monthly data or annual totals) and how often the power plant reports this data to EIA. See reporting_frequencies_eia for more details.'),
    sa.Column('sector_id_eia', sa.Integer(), nullable=True, comment='EIA assigned sector ID, corresponding to high level NAICS sector, designated by the primary purpose, regulatory status and plant-level combined heat and power status'),
    sa.Column('sector_name_eia', sa.Text(), nullable=True, comment='EIA assigned sector name, corresponding to high level NAICS sector, designated by the primary purpose, regulatory status and plant-level combined heat and power status'),
    sa.Column('service_area', sa.Text(), nullable=True, comment="Service area in which plant is located; for unregulated companies, it's the electric utility with which plant is interconnected"),
    sa.Column('transmission_distribution_owner_id', sa.Integer(), nullable=True, comment='EIA-assigned code for owner of transmission/distribution system to which the plant is interconnected.'),
    sa.Column('transmission_distribution_owner_name', sa.Text(), nullable=True, comment='Name of the owner of the transmission or distribution system to which the plant is interconnected.'),
    sa.Column('transmission_distribution_owner_state', sa.Text(), nullable=True, comment='State location for owner of transmission/distribution system to which the plant is interconnected.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('water_source', sa.Text(), nullable=True, comment='Name of water source associated with the plant.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('balancing_authority_code_eia_consistent_rate', sa.Float(), nullable=True, comment='Percentage consistency of balancing authority code across entity records.'),
    sa.ForeignKeyConstraint(['balancing_authority_code_eia'], ['core_eia__codes_balancing_authorities.code'], name=op.f('fk_out_eia__yearly_plants_balancing_authority_code_eia_core_eia__codes_balancing_authorities')),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia__yearly_plants_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'report_date'], ['core_eia860__scd_plants.plant_id_eia', 'core_eia860__scd_plants.report_date'], name=op.f('fk_out_eia__yearly_plants_plant_id_eia_core_eia860__scd_plants')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia__yearly_plants_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['reporting_frequency_code'], ['core_eia__codes_reporting_frequencies.code'], name=op.f('fk_out_eia__yearly_plants_reporting_frequency_code_core_eia__codes_reporting_frequencies')),
    sa.ForeignKeyConstraint(['sector_id_eia'], ['core_eia__codes_sector_consolidated.code'], name=op.f('fk_out_eia__yearly_plants_sector_id_eia_core_eia__codes_sector_consolidated')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk_out_eia__yearly_plants_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia__yearly_plants_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_date', name=op.f('pk_out_eia__yearly_plants'))
    )
    op.create_table('out_ferc1__yearly_all_plants',
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_id_ferc1', sa.Integer(), nullable=True, comment='Algorithmically assigned PUDL FERC Plant ID. WARNING: NOT STABLE BETWEEN PUDL DB INITIALIZATIONS.'),
    sa.Column('plant_name_ferc1', sa.Text(), nullable=True, comment='Name of the plant, as reported to FERC. This is a freeform string, not guaranteed to be consistent across references to the same plant.'),
    sa.Column('asset_retirement_cost', sa.Float(), nullable=True, comment='Asset retirement cost (USD).'),
    sa.Column('avg_num_employees', sa.Float(), nullable=True, comment='The average number of employees assigned to each plant.'),
    sa.Column('capacity_factor', sa.Float(), nullable=True, comment='Fraction of potential generation that was actually reported for a plant part.'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('capex_annual_addition', sa.Float(), nullable=True, comment='Annual capital addition into `capex_total`.'),
    sa.Column('capex_annual_addition_rolling', sa.Float(), nullable=True, comment='Year-to-date capital addition into `capex_total`.'),
    sa.Column('capex_annual_per_kw', sa.Float(), nullable=True, comment='Annual capital addition into `capex_total` per kw.'),
    sa.Column('capex_annual_per_mw', sa.Float(), nullable=True, comment='Annual capital addition into `capex_total` per MW.'),
    sa.Column('capex_annual_per_mw_rolling', sa.Float(), nullable=True, comment='Year-to-date capital addition into `capex_total` per MW.'),
    sa.Column('capex_annual_per_mwh', sa.Float(), nullable=True, comment='Annual capital addition into `capex_total` per MWh.'),
    sa.Column('capex_annual_per_mwh_rolling', sa.Float(), nullable=True, comment='Year-to-date capital addition into `capex_total` per MWh.'),
    sa.Column('capex_equipment', sa.Float(), nullable=True, comment='Cost of plant: equipment (USD).'),
    sa.Column('capex_land', sa.Float(), nullable=True, comment='Cost of plant: land and land rights (USD).'),
    sa.Column('capex_per_mw', sa.Float(), nullable=True, comment='Cost of plant per megawatt of installed (nameplate) capacity. Nominal USD.'),
    sa.Column('capex_structures', sa.Float(), nullable=True, comment='Cost of plant: structures and improvements (USD).'),
    sa.Column('capex_total', sa.Float(), nullable=True, comment='Total cost of plant (USD).'),
    sa.Column('capex_wo_retirement_total', sa.Float(), nullable=True, comment='Total cost of plant (USD) without retirements.'),
    sa.Column('construction_type', sa.Enum('conventional', 'outdoor', 'semioutdoor'), nullable=True, comment="Type of plant construction ('outdoor', 'semioutdoor', or 'conventional'). Categorized by PUDL based on our best guess of intended value in FERC1 freeform strings."),
    sa.Column('construction_year', sa.Integer(), nullable=True, comment="Year the plant's oldest still operational unit was built."),
    sa.Column('installation_year', sa.Integer(), nullable=True, comment="Year the plant's most recently built unit was installed."),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('not_water_limited_capacity_mw', sa.Float(), nullable=True, comment='Plant capacity in MW when not limited by condenser water.'),
    sa.Column('opex_allowances', sa.Float(), nullable=True, comment='Allowances.'),
    sa.Column('opex_boiler', sa.Float(), nullable=True, comment='Maintenance of boiler (or reactor) plant.'),
    sa.Column('opex_coolants', sa.Float(), nullable=True, comment='Cost of coolants and water (nuclear plants only)'),
    sa.Column('opex_electric', sa.Float(), nullable=True, comment='Production expenses: electric expenses (USD).'),
    sa.Column('opex_engineering', sa.Float(), nullable=True, comment='Production expenses: maintenance, supervision, and engineering (USD).'),
    sa.Column('opex_fuel', sa.Float(), nullable=True, comment='Production expenses: fuel (USD).'),
    sa.Column('fuel_cost_per_mwh', sa.Float(), nullable=True, comment='Derived from MCOE, a unit level value. Average fuel cost per MWh of heat content in nominal USD.'),
    sa.Column('opex_misc_power', sa.Float(), nullable=True, comment='Miscellaneous steam (or nuclear) expenses.'),
    sa.Column('opex_misc_steam', sa.Float(), nullable=True, comment='Maintenance of miscellaneous steam (or nuclear) plant.'),
    sa.Column('opex_nonfuel_per_mwh', sa.Float(), nullable=True, comment='Investments in non-fuel production expenses per Mwh.'),
    sa.Column('opex_operations', sa.Float(), nullable=True, comment='Production expenses: operations, supervision, and engineering (USD).'),
    sa.Column('opex_per_mwh', sa.Float(), nullable=True, comment='Total production expenses (USD per MWh generated).'),
    sa.Column('opex_plant', sa.Float(), nullable=True, comment='Production expenses: maintenance of electric plant (USD).'),
    sa.Column('opex_production_total', sa.Float(), nullable=True, comment='Total operating expenses.'),
    sa.Column('opex_rents', sa.Float(), nullable=True, comment='Production expenses: rents (USD).'),
    sa.Column('opex_steam', sa.Float(), nullable=True, comment='Steam expenses.'),
    sa.Column('opex_steam_other', sa.Float(), nullable=True, comment='Steam from other sources.'),
    sa.Column('opex_structures', sa.Float(), nullable=True, comment='Production expenses: maintenance of structures (USD).'),
    sa.Column('opex_total_nonfuel', sa.Float(), nullable=True, comment='Total production expenses, excluding fuel (USD).'),
    sa.Column('opex_transfer', sa.Float(), nullable=True, comment='Steam transferred (Credit).'),
    sa.Column('peak_demand_mw', sa.Float(), nullable=True, comment='Net peak demand for 60 minutes. Note: in some cases peak demand for other time periods may have been reported instead, if hourly peak demand was unavailable.'),
    sa.Column('plant_capability_mw', sa.Float(), nullable=True, comment='Net plant capability in megawatts.'),
    sa.Column('plant_hours_connected_while_generating', sa.Float(), nullable=True, comment='Hours the plant was connected to load while generating in the report year.'),
    sa.Column('plant_type', sa.Text(), nullable=True, comment='Type of plant.'),
    sa.Column('record_id', sa.Text(), nullable=False, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('water_limited_capacity_mw', sa.Float(), nullable=True, comment='Plant capacity in MW when limited by condenser water.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('fuel_type', sa.Text(), nullable=True, comment='Type of fuel.'),
    sa.Column('license_id_ferc1', sa.Integer(), nullable=True, comment='FERC issued operating license ID for the facility, if available. This value is extracted from the original plant name where possible.'),
    sa.Column('opex_maintenance', sa.Float(), nullable=True, comment='Production expenses: Maintenance (USD).'),
    sa.Column('opex_total', sa.Float(), nullable=True, comment='Total production expenses, excluding fuel (USD).'),
    sa.Column('capex_facilities', sa.Float(), nullable=True, comment='Cost of plant: reservoirs, dams, and waterways (USD).'),
    sa.Column('capex_roads', sa.Float(), nullable=True, comment='Cost of plant: roads, railroads, and bridges (USD).'),
    sa.Column('net_capacity_adverse_conditions_mw', sa.Float(), nullable=True, comment='Net plant capability under the least favorable operating conditions, in megawatts.'),
    sa.Column('net_capacity_favorable_conditions_mw', sa.Float(), nullable=True, comment='Net plant capability under the most favorable operating conditions, in megawatts.'),
    sa.Column('opex_dams', sa.Float(), nullable=True, comment='Production expenses: maintenance of reservoirs, dams, and waterways (USD).'),
    sa.Column('opex_generation_misc', sa.Float(), nullable=True, comment='Production expenses: miscellaneous power generation expenses (USD).'),
    sa.Column('opex_hydraulic', sa.Float(), nullable=True, comment='Production expenses: hydraulic expenses (USD).'),
    sa.Column('opex_misc_plant', sa.Float(), nullable=True, comment='Production expenses: maintenance of miscellaneous hydraulic plant (USD).'),
    sa.Column('opex_water_for_power', sa.Float(), nullable=True, comment='Production expenses: water for power (USD).'),
    sa.Column('ferc_license_id', sa.Text(), nullable=True, comment='The FERC license ID of a project.'),
    sa.Column('capex_equipment_electric', sa.Float(), nullable=True, comment='Cost of plant: accessory electric equipment (USD).'),
    sa.Column('capex_equipment_misc', sa.Float(), nullable=True, comment='Cost of plant: miscellaneous power plant equipment (USD).'),
    sa.Column('capex_wheels_turbines_generators', sa.Float(), nullable=True, comment='Cost of plant: water wheels, turbines, and generators (USD).'),
    sa.Column('energy_used_for_pumping_mwh', sa.Float(), nullable=True, comment='Energy used for pumping, in megawatt-hours.'),
    sa.Column('net_load_mwh', sa.Float(), nullable=True, comment='Net output for load (net generation - energy used for pumping) in megawatt-hours.'),
    sa.Column('opex_production_before_pumping', sa.Float(), nullable=True, comment='Total production expenses before pumping (USD).'),
    sa.Column('opex_pumped_storage', sa.Float(), nullable=True, comment='Production expenses: pumped storage (USD).'),
    sa.Column('opex_pumping', sa.Float(), nullable=True, comment='Production expenses: We are here to PUMP YOU UP! (USD).'),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_ferc1__yearly_all_plants_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_ferc1', 'plant_name_ferc1'], ['core_pudl__assn_ferc1_pudl_plants.utility_id_ferc1', 'core_pudl__assn_ferc1_pudl_plants.plant_name_ferc1'], name=op.f('fk_out_ferc1__yearly_all_plants_utility_id_ferc1_core_pudl__assn_ferc1_pudl_plants')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_all_plants_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('record_id', name=op.f('pk_out_ferc1__yearly_all_plants'))
    )
    op.create_table('out_ferc1__yearly_hydroelectric_plants_sched406',
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('plant_name_ferc1', sa.Text(), nullable=True, comment='Name of the plant, as reported to FERC. This is a freeform string, not guaranteed to be consistent across references to the same plant.'),
    sa.Column('record_id', sa.Text(), nullable=False, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('asset_retirement_cost', sa.Float(), nullable=True, comment='Asset retirement cost (USD).'),
    sa.Column('avg_num_employees', sa.Float(), nullable=True, comment='The average number of employees assigned to each plant.'),
    sa.Column('capacity_factor', sa.Float(), nullable=True, comment='Fraction of potential generation that was actually reported for a plant part.'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('capex_equipment', sa.Float(), nullable=True, comment='Cost of plant: equipment (USD).'),
    sa.Column('capex_facilities', sa.Float(), nullable=True, comment='Cost of plant: reservoirs, dams, and waterways (USD).'),
    sa.Column('capex_land', sa.Float(), nullable=True, comment='Cost of plant: land and land rights (USD).'),
    sa.Column('capex_per_mw', sa.Float(), nullable=True, comment='Cost of plant per megawatt of installed (nameplate) capacity. Nominal USD.'),
    sa.Column('capex_roads', sa.Float(), nullable=True, comment='Cost of plant: roads, railroads, and bridges (USD).'),
    sa.Column('capex_structures', sa.Float(), nullable=True, comment='Cost of plant: structures and improvements (USD).'),
    sa.Column('capex_total', sa.Float(), nullable=True, comment='Total cost of plant (USD).'),
    sa.Column('construction_type', sa.Enum('conventional', 'outdoor', 'semioutdoor'), nullable=True, comment="Type of plant construction ('outdoor', 'semioutdoor', or 'conventional'). Categorized by PUDL based on our best guess of intended value in FERC1 freeform strings."),
    sa.Column('construction_year', sa.Integer(), nullable=True, comment="Year the plant's oldest still operational unit was built."),
    sa.Column('installation_year', sa.Integer(), nullable=True, comment="Year the plant's most recently built unit was installed."),
    sa.Column('net_capacity_adverse_conditions_mw', sa.Float(), nullable=True, comment='Net plant capability under the least favorable operating conditions, in megawatts.'),
    sa.Column('net_capacity_favorable_conditions_mw', sa.Float(), nullable=True, comment='Net plant capability under the most favorable operating conditions, in megawatts.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('opex_dams', sa.Float(), nullable=True, comment='Production expenses: maintenance of reservoirs, dams, and waterways (USD).'),
    sa.Column('opex_electric', sa.Float(), nullable=True, comment='Production expenses: electric expenses (USD).'),
    sa.Column('opex_engineering', sa.Float(), nullable=True, comment='Production expenses: maintenance, supervision, and engineering (USD).'),
    sa.Column('opex_generation_misc', sa.Float(), nullable=True, comment='Production expenses: miscellaneous power generation expenses (USD).'),
    sa.Column('opex_hydraulic', sa.Float(), nullable=True, comment='Production expenses: hydraulic expenses (USD).'),
    sa.Column('opex_misc_plant', sa.Float(), nullable=True, comment='Production expenses: maintenance of miscellaneous hydraulic plant (USD).'),
    sa.Column('opex_operations', sa.Float(), nullable=True, comment='Production expenses: operations, supervision, and engineering (USD).'),
    sa.Column('opex_per_mwh', sa.Float(), nullable=True, comment='Total production expenses (USD per MWh generated).'),
    sa.Column('opex_plant', sa.Float(), nullable=True, comment='Production expenses: maintenance of electric plant (USD).'),
    sa.Column('opex_rents', sa.Float(), nullable=True, comment='Production expenses: rents (USD).'),
    sa.Column('opex_structures', sa.Float(), nullable=True, comment='Production expenses: maintenance of structures (USD).'),
    sa.Column('opex_total', sa.Float(), nullable=True, comment='Total production expenses, excluding fuel (USD).'),
    sa.Column('opex_total_nonfuel', sa.Float(), nullable=True, comment='Total production expenses, excluding fuel (USD).'),
    sa.Column('opex_water_for_power', sa.Float(), nullable=True, comment='Production expenses: water for power (USD).'),
    sa.Column('peak_demand_mw', sa.Float(), nullable=True, comment='Net peak demand for 60 minutes. Note: in some cases peak demand for other time periods may have been reported instead, if hourly peak demand was unavailable.'),
    sa.Column('plant_hours_connected_while_generating', sa.Float(), nullable=True, comment='Hours the plant was connected to load while generating in the report year.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_type', sa.Text(), nullable=True, comment='Type of plant.'),
    sa.Column('project_num', sa.Integer(), nullable=True, comment='FERC Licensed Project Number.'),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_ferc1__yearly_hydroelectric_plants_sched406_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_ferc1', 'plant_name_ferc1'], ['core_pudl__assn_ferc1_pudl_plants.utility_id_ferc1', 'core_pudl__assn_ferc1_pudl_plants.plant_name_ferc1'], name=op.f('fk_out_ferc1__yearly_hydroelectric_plants_sched406_utility_id_ferc1_core_pudl__assn_ferc1_pudl_plants')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_hydroelectric_plants_sched406_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('record_id', name=op.f('pk_out_ferc1__yearly_hydroelectric_plants_sched406'))
    )
    op.create_table('out_ferc1__yearly_pumped_storage_plants_sched408',
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('plant_name_ferc1', sa.Text(), nullable=True, comment='Name of the plant, as reported to FERC. This is a freeform string, not guaranteed to be consistent across references to the same plant.'),
    sa.Column('record_id', sa.Text(), nullable=False, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('asset_retirement_cost', sa.Float(), nullable=True, comment='Asset retirement cost (USD).'),
    sa.Column('avg_num_employees', sa.Float(), nullable=True, comment='The average number of employees assigned to each plant.'),
    sa.Column('capacity_factor', sa.Float(), nullable=True, comment='Fraction of potential generation that was actually reported for a plant part.'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('capex_equipment_electric', sa.Float(), nullable=True, comment='Cost of plant: accessory electric equipment (USD).'),
    sa.Column('capex_equipment_misc', sa.Float(), nullable=True, comment='Cost of plant: miscellaneous power plant equipment (USD).'),
    sa.Column('capex_facilities', sa.Float(), nullable=True, comment='Cost of plant: reservoirs, dams, and waterways (USD).'),
    sa.Column('capex_land', sa.Float(), nullable=True, comment='Cost of plant: land and land rights (USD).'),
    sa.Column('capex_per_mw', sa.Float(), nullable=True, comment='Cost of plant per megawatt of installed (nameplate) capacity. Nominal USD.'),
    sa.Column('capex_roads', sa.Float(), nullable=True, comment='Cost of plant: roads, railroads, and bridges (USD).'),
    sa.Column('capex_structures', sa.Float(), nullable=True, comment='Cost of plant: structures and improvements (USD).'),
    sa.Column('capex_total', sa.Float(), nullable=True, comment='Total cost of plant (USD).'),
    sa.Column('capex_wheels_turbines_generators', sa.Float(), nullable=True, comment='Cost of plant: water wheels, turbines, and generators (USD).'),
    sa.Column('construction_type', sa.Enum('conventional', 'outdoor', 'semioutdoor'), nullable=True, comment="Type of plant construction ('outdoor', 'semioutdoor', or 'conventional'). Categorized by PUDL based on our best guess of intended value in FERC1 freeform strings."),
    sa.Column('construction_year', sa.Integer(), nullable=True, comment="Year the plant's oldest still operational unit was built."),
    sa.Column('energy_used_for_pumping_mwh', sa.Float(), nullable=True, comment='Energy used for pumping, in megawatt-hours.'),
    sa.Column('installation_year', sa.Integer(), nullable=True, comment="Year the plant's most recently built unit was installed."),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('net_load_mwh', sa.Float(), nullable=True, comment='Net output for load (net generation - energy used for pumping) in megawatt-hours.'),
    sa.Column('opex_dams', sa.Float(), nullable=True, comment='Production expenses: maintenance of reservoirs, dams, and waterways (USD).'),
    sa.Column('opex_electric', sa.Float(), nullable=True, comment='Production expenses: electric expenses (USD).'),
    sa.Column('opex_engineering', sa.Float(), nullable=True, comment='Production expenses: maintenance, supervision, and engineering (USD).'),
    sa.Column('opex_generation_misc', sa.Float(), nullable=True, comment='Production expenses: miscellaneous power generation expenses (USD).'),
    sa.Column('opex_misc_plant', sa.Float(), nullable=True, comment='Production expenses: maintenance of miscellaneous hydraulic plant (USD).'),
    sa.Column('opex_operations', sa.Float(), nullable=True, comment='Production expenses: operations, supervision, and engineering (USD).'),
    sa.Column('opex_per_mwh', sa.Float(), nullable=True, comment='Total production expenses (USD per MWh generated).'),
    sa.Column('opex_plant', sa.Float(), nullable=True, comment='Production expenses: maintenance of electric plant (USD).'),
    sa.Column('opex_production_before_pumping', sa.Float(), nullable=True, comment='Total production expenses before pumping (USD).'),
    sa.Column('opex_pumped_storage', sa.Float(), nullable=True, comment='Production expenses: pumped storage (USD).'),
    sa.Column('opex_pumping', sa.Float(), nullable=True, comment='Production expenses: We are here to PUMP YOU UP! (USD).'),
    sa.Column('opex_rents', sa.Float(), nullable=True, comment='Production expenses: rents (USD).'),
    sa.Column('opex_structures', sa.Float(), nullable=True, comment='Production expenses: maintenance of structures (USD).'),
    sa.Column('opex_total', sa.Float(), nullable=True, comment='Total production expenses, excluding fuel (USD).'),
    sa.Column('opex_total_nonfuel', sa.Float(), nullable=True, comment='Total production expenses, excluding fuel (USD).'),
    sa.Column('opex_water_for_power', sa.Float(), nullable=True, comment='Production expenses: water for power (USD).'),
    sa.Column('peak_demand_mw', sa.Float(), nullable=True, comment='Net peak demand for 60 minutes. Note: in some cases peak demand for other time periods may have been reported instead, if hourly peak demand was unavailable.'),
    sa.Column('plant_capability_mw', sa.Float(), nullable=True, comment='Net plant capability in megawatts.'),
    sa.Column('plant_hours_connected_while_generating', sa.Float(), nullable=True, comment='Hours the plant was connected to load while generating in the report year.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('project_num', sa.Integer(), nullable=True, comment='FERC Licensed Project Number.'),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_ferc1__yearly_pumped_storage_plants_sched408_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_ferc1', 'plant_name_ferc1'], ['core_pudl__assn_ferc1_pudl_plants.utility_id_ferc1', 'core_pudl__assn_ferc1_pudl_plants.plant_name_ferc1'], name=op.f('fk_out_ferc1__yearly_pumped_storage_plants_sched408_utility_id_ferc1_core_pudl__assn_ferc1_pudl_plants')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_pumped_storage_plants_sched408_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('record_id', name=op.f('pk_out_ferc1__yearly_pumped_storage_plants_sched408'))
    )
    op.create_table('out_ferc1__yearly_small_plants_sched410',
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_ferc1', sa.Text(), nullable=True, comment='Name of the plant, as reported to FERC. This is a freeform string, not guaranteed to be consistent across references to the same plant.'),
    sa.Column('record_id', sa.Text(), nullable=False, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('capex_per_mw', sa.Float(), nullable=True, comment='Cost of plant per megawatt of installed (nameplate) capacity. Nominal USD.'),
    sa.Column('capex_total', sa.Float(), nullable=True, comment='Total cost of plant (USD).'),
    sa.Column('construction_year', sa.Integer(), nullable=True, comment="Year the plant's oldest still operational unit was built."),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('fuel_type', sa.Text(), nullable=True, comment='Type of fuel.'),
    sa.Column('license_id_ferc1', sa.Integer(), nullable=True, comment='FERC issued operating license ID for the facility, if available. This value is extracted from the original plant name where possible.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('opex_fuel', sa.Float(), nullable=True, comment='Production expenses: fuel (USD).'),
    sa.Column('opex_maintenance', sa.Float(), nullable=True, comment='Production expenses: Maintenance (USD).'),
    sa.Column('opex_operations', sa.Float(), nullable=True, comment='Production expenses: operations, supervision, and engineering (USD).'),
    sa.Column('opex_total', sa.Float(), nullable=True, comment='Total production expenses, excluding fuel (USD).'),
    sa.Column('opex_total_nonfuel', sa.Float(), nullable=True, comment='Total production expenses, excluding fuel (USD).'),
    sa.Column('peak_demand_mw', sa.Float(), nullable=True, comment='Net peak demand for 60 minutes. Note: in some cases peak demand for other time periods may have been reported instead, if hourly peak demand was unavailable.'),
    sa.Column('plant_type', sa.Text(), nullable=True, comment='Type of plant.'),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_ferc1__yearly_small_plants_sched410_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_ferc1', 'plant_name_ferc1'], ['core_pudl__assn_ferc1_pudl_plants.utility_id_ferc1', 'core_pudl__assn_ferc1_pudl_plants.plant_name_ferc1'], name=op.f('fk_out_ferc1__yearly_small_plants_sched410_utility_id_ferc1_core_pudl__assn_ferc1_pudl_plants')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_small_plants_sched410_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('record_id', name=op.f('pk_out_ferc1__yearly_small_plants_sched410'))
    )
    op.create_table('out_ferc1__yearly_steam_plants_fuel_by_plant_sched402',
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=False, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_ferc1', sa.Text(), nullable=False, comment='Name of the plant, as reported to FERC. This is a freeform string, not guaranteed to be consistent across references to the same plant.'),
    sa.Column('coal_fraction_cost', sa.Float(), nullable=True, comment='Coal cost as a percentage of overall fuel cost.'),
    sa.Column('coal_fraction_mmbtu', sa.Float(), nullable=True, comment='Coal heat content as a percentage of overall fuel heat content (mmBTU).'),
    sa.Column('fuel_cost', sa.Float(), nullable=True, comment='Total fuel cost for plant (in $USD).'),
    sa.Column('fuel_mmbtu', sa.Float(), nullable=True, comment='Total heat content for plant (in MMBtu).'),
    sa.Column('gas_fraction_cost', sa.Float(), nullable=True, comment='Natural gas cost as a percentage of overall fuel cost.'),
    sa.Column('gas_fraction_mmbtu', sa.Float(), nullable=True, comment='Natural gas heat content as a percentage of overall fuel heat content (MMBtu).'),
    sa.Column('nuclear_fraction_cost', sa.Float(), nullable=True, comment='Nuclear cost as a percentage of overall fuel cost.'),
    sa.Column('nuclear_fraction_mmbtu', sa.Float(), nullable=True, comment='Nuclear heat content as a percentage of overall fuel heat content (MMBtu).'),
    sa.Column('oil_fraction_cost', sa.Float(), nullable=True, comment='Oil cost as a percentage of overall fuel cost.'),
    sa.Column('oil_fraction_mmbtu', sa.Float(), nullable=True, comment='Oil heat content as a percentage of overall fuel heat content (MMBtu).'),
    sa.Column('primary_fuel_by_cost', sa.Text(), nullable=True, comment='Primary fuel for plant as a percentage of cost.'),
    sa.Column('primary_fuel_by_mmbtu', sa.Text(), nullable=True, comment='Primary fuel for plant as a percentage of heat content.'),
    sa.Column('waste_fraction_cost', sa.Float(), nullable=True, comment='Waste-heat cost as a percentage of overall fuel cost.'),
    sa.Column('waste_fraction_mmbtu', sa.Float(), nullable=True, comment='Waste-heat heat content as a percentage of overall fuel heat content (MMBtu).'),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_ferc1__yearly_steam_plants_fuel_by_plant_sched402_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_ferc1', 'plant_name_ferc1'], ['core_pudl__assn_ferc1_pudl_plants.utility_id_ferc1', 'core_pudl__assn_ferc1_pudl_plants.plant_name_ferc1'], name=op.f('fk_out_ferc1__yearly_steam_plants_fuel_by_plant_sched402_utility_id_ferc1_core_pudl__assn_ferc1_pudl_plants')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_steam_plants_fuel_by_plant_sched402_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('report_year', 'utility_id_ferc1', 'plant_name_ferc1', name=op.f('pk_out_ferc1__yearly_steam_plants_fuel_by_plant_sched402'))
    )
    op.create_table('out_ferc1__yearly_steam_plants_fuel_sched402',
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_ferc1', sa.Text(), nullable=True, comment='Name of the plant, as reported to FERC. This is a freeform string, not guaranteed to be consistent across references to the same plant.'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_consumed_total_cost', sa.Float(), nullable=True, comment='Total cost of consumed fuel.'),
    sa.Column('fuel_consumed_units', sa.Float(), nullable=True, comment='Consumption of the fuel type in physical unit. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('fuel_cost_per_unit_burned', sa.Float(), nullable=True, comment='Average cost of fuel consumed in the report year per reported fuel unit (USD).'),
    sa.Column('fuel_cost_per_unit_delivered', sa.Float(), nullable=True, comment='Average cost of fuel delivered in the report year per reported fuel unit (USD).'),
    sa.Column('fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Heat content of the fuel in millions of Btus per physical unit.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_units', sa.Enum('mmbtu', 'gramsU', 'kg', 'mwhth', 'kgal', 'bbl', 'klbs', 'mcf', 'gal', 'mwdth', 'btu', 'ton'), nullable=True, comment='Reported unit of measure for fuel.'),
    sa.Column('record_id', sa.Text(), nullable=False, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_ferc1__yearly_steam_plants_fuel_sched402_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_ferc1', 'plant_name_ferc1'], ['core_pudl__assn_ferc1_pudl_plants.utility_id_ferc1', 'core_pudl__assn_ferc1_pudl_plants.plant_name_ferc1'], name=op.f('fk_out_ferc1__yearly_steam_plants_fuel_sched402_utility_id_ferc1_core_pudl__assn_ferc1_pudl_plants')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_steam_plants_fuel_sched402_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('record_id', name=op.f('pk_out_ferc1__yearly_steam_plants_fuel_sched402'))
    )
    op.create_table('out_ferc1__yearly_steam_plants_sched402',
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_id_ferc1', sa.Integer(), nullable=True, comment='Algorithmically assigned PUDL FERC Plant ID. WARNING: NOT STABLE BETWEEN PUDL DB INITIALIZATIONS.'),
    sa.Column('plant_name_ferc1', sa.Text(), nullable=True, comment='Name of the plant, as reported to FERC. This is a freeform string, not guaranteed to be consistent across references to the same plant.'),
    sa.Column('asset_retirement_cost', sa.Float(), nullable=True, comment='Asset retirement cost (USD).'),
    sa.Column('avg_num_employees', sa.Float(), nullable=True, comment='The average number of employees assigned to each plant.'),
    sa.Column('capacity_factor', sa.Float(), nullable=True, comment='Fraction of potential generation that was actually reported for a plant part.'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('capex_annual_addition', sa.Float(), nullable=True, comment='Annual capital addition into `capex_total`.'),
    sa.Column('capex_annual_addition_rolling', sa.Float(), nullable=True, comment='Year-to-date capital addition into `capex_total`.'),
    sa.Column('capex_annual_per_kw', sa.Float(), nullable=True, comment='Annual capital addition into `capex_total` per kw.'),
    sa.Column('capex_annual_per_mw', sa.Float(), nullable=True, comment='Annual capital addition into `capex_total` per MW.'),
    sa.Column('capex_annual_per_mw_rolling', sa.Float(), nullable=True, comment='Year-to-date capital addition into `capex_total` per MW.'),
    sa.Column('capex_annual_per_mwh', sa.Float(), nullable=True, comment='Annual capital addition into `capex_total` per MWh.'),
    sa.Column('capex_annual_per_mwh_rolling', sa.Float(), nullable=True, comment='Year-to-date capital addition into `capex_total` per MWh.'),
    sa.Column('capex_equipment', sa.Float(), nullable=True, comment='Cost of plant: equipment (USD).'),
    sa.Column('capex_land', sa.Float(), nullable=True, comment='Cost of plant: land and land rights (USD).'),
    sa.Column('capex_per_mw', sa.Float(), nullable=True, comment='Cost of plant per megawatt of installed (nameplate) capacity. Nominal USD.'),
    sa.Column('capex_structures', sa.Float(), nullable=True, comment='Cost of plant: structures and improvements (USD).'),
    sa.Column('capex_total', sa.Float(), nullable=True, comment='Total cost of plant (USD).'),
    sa.Column('capex_wo_retirement_total', sa.Float(), nullable=True, comment='Total cost of plant (USD) without retirements.'),
    sa.Column('construction_type', sa.Enum('conventional', 'outdoor', 'semioutdoor'), nullable=True, comment="Type of plant construction ('outdoor', 'semioutdoor', or 'conventional'). Categorized by PUDL based on our best guess of intended value in FERC1 freeform strings."),
    sa.Column('construction_year', sa.Integer(), nullable=True, comment="Year the plant's oldest still operational unit was built."),
    sa.Column('installation_year', sa.Integer(), nullable=True, comment="Year the plant's most recently built unit was installed."),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('not_water_limited_capacity_mw', sa.Float(), nullable=True, comment='Plant capacity in MW when not limited by condenser water.'),
    sa.Column('opex_allowances', sa.Float(), nullable=True, comment='Allowances.'),
    sa.Column('opex_boiler', sa.Float(), nullable=True, comment='Maintenance of boiler (or reactor) plant.'),
    sa.Column('opex_coolants', sa.Float(), nullable=True, comment='Cost of coolants and water (nuclear plants only)'),
    sa.Column('opex_electric', sa.Float(), nullable=True, comment='Production expenses: electric expenses (USD).'),
    sa.Column('opex_engineering', sa.Float(), nullable=True, comment='Production expenses: maintenance, supervision, and engineering (USD).'),
    sa.Column('opex_fuel', sa.Float(), nullable=True, comment='Production expenses: fuel (USD).'),
    sa.Column('opex_fuel_per_mwh', sa.Float(), nullable=True, comment='Production expenses: fuel (USD) per megawatt-hour (Mwh).'),
    sa.Column('opex_misc_power', sa.Float(), nullable=True, comment='Miscellaneous steam (or nuclear) expenses.'),
    sa.Column('opex_misc_steam', sa.Float(), nullable=True, comment='Maintenance of miscellaneous steam (or nuclear) plant.'),
    sa.Column('opex_nonfuel_per_mwh', sa.Float(), nullable=True, comment='Investments in non-fuel production expenses per Mwh.'),
    sa.Column('opex_operations', sa.Float(), nullable=True, comment='Production expenses: operations, supervision, and engineering (USD).'),
    sa.Column('opex_per_mwh', sa.Float(), nullable=True, comment='Total production expenses (USD per MWh generated).'),
    sa.Column('opex_plants', sa.Float(), nullable=True, comment='Maintenance of electrical plant.'),
    sa.Column('opex_production_total', sa.Float(), nullable=True, comment='Total operating expenses.'),
    sa.Column('opex_rents', sa.Float(), nullable=True, comment='Production expenses: rents (USD).'),
    sa.Column('opex_steam', sa.Float(), nullable=True, comment='Steam expenses.'),
    sa.Column('opex_steam_other', sa.Float(), nullable=True, comment='Steam from other sources.'),
    sa.Column('opex_structures', sa.Float(), nullable=True, comment='Production expenses: maintenance of structures (USD).'),
    sa.Column('opex_total_nonfuel', sa.Float(), nullable=True, comment='Total production expenses, excluding fuel (USD).'),
    sa.Column('opex_transfer', sa.Float(), nullable=True, comment='Steam transferred (Credit).'),
    sa.Column('peak_demand_mw', sa.Float(), nullable=True, comment='Net peak demand for 60 minutes. Note: in some cases peak demand for other time periods may have been reported instead, if hourly peak demand was unavailable.'),
    sa.Column('plant_capability_mw', sa.Float(), nullable=True, comment='Net plant capability in megawatts.'),
    sa.Column('plant_hours_connected_while_generating', sa.Float(), nullable=True, comment='Hours the plant was connected to load while generating in the report year.'),
    sa.Column('plant_type', sa.Text(), nullable=True, comment='Type of plant.'),
    sa.Column('record_id', sa.Text(), nullable=False, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('water_limited_capacity_mw', sa.Float(), nullable=True, comment='Plant capacity in MW when limited by condenser water.'),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_ferc1__yearly_steam_plants_sched402_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_ferc1', 'plant_name_ferc1'], ['core_pudl__assn_ferc1_pudl_plants.utility_id_ferc1', 'core_pudl__assn_ferc1_pudl_plants.plant_name_ferc1'], name=op.f('fk_out_ferc1__yearly_steam_plants_sched402_utility_id_ferc1_core_pudl__assn_ferc1_pudl_plants')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_ferc1__yearly_steam_plants_sched402_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('record_id', name=op.f('pk_out_ferc1__yearly_steam_plants_sched402'))
    )
    op.create_table('_out_eia__yearly_capacity_factor_by_generator',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('capacity_factor', sa.Float(), nullable=True, comment='Fraction of potential generation that was actually reported for a plant part.'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk__out_eia__yearly_capacity_factor_by_generator_plant_id_eia_core_eia860__scd_generators')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk__out_eia__yearly_capacity_factor_by_generator'))
    )
    op.create_table('_out_eia__yearly_derived_generator_attributes',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('capacity_factor', sa.Float(), nullable=True, comment='Fraction of potential generation that was actually reported for a plant part.'),
    sa.Column('fuel_cost_from_eiaapi', sa.Boolean(), nullable=True, comment='Indicates whether the fuel cost was derived from the EIA API.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('fuel_cost_per_mwh', sa.Float(), nullable=True, comment='Derived from MCOE, a unit level value. Average fuel cost per MWh of heat content in nominal USD.'),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.Float(), nullable=True, comment='Fuel content per unit of electricity generated. Coming from MCOE calculation.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('total_fuel_cost', sa.Float(), nullable=True, comment='Total annual reported fuel costs for the plant part. Includes costs from all fuels.'),
    sa.Column('total_mmbtu', sa.Float(), nullable=True, comment='Total annual heat content of fuel consumed by a plant part record in the plant parts list.'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk__out_eia__yearly_derived_generator_attributes_plant_id_eia_core_eia860__scd_generators')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk__out_eia__yearly_derived_generator_attributes'))
    )
    op.create_table('_out_eia__yearly_fuel_cost_by_generator',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('fuel_type_count', sa.Integer(), nullable=True, comment='A count of how many different simple energy sources there are associated with a generator.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_cost_from_eiaapi', sa.Boolean(), nullable=True, comment='Indicates whether the fuel cost was derived from the EIA API.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.Float(), nullable=True, comment='Fuel content per unit of electricity generated. Coming from MCOE calculation.'),
    sa.Column('fuel_cost_per_mwh', sa.Float(), nullable=True, comment='Derived from MCOE, a unit level value. Average fuel cost per MWh of heat content in nominal USD.'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk__out_eia__yearly_fuel_cost_by_generator_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk__out_eia__yearly_fuel_cost_by_generator_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk__out_eia__yearly_fuel_cost_by_generator_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk__out_eia__yearly_fuel_cost_by_generator_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk__out_eia__yearly_fuel_cost_by_generator'))
    )
    op.create_table('_out_eia__yearly_generators',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('associated_combined_heat_power', sa.Boolean(), nullable=True, comment='Indicates whether the generator is associated with a combined heat and power system'),
    sa.Column('bga_source', sa.Text(), nullable=True, comment='The source from where the unit_id_pudl is compiled. The unit_id_pudl comes directly from EIA 860, or string association (which looks at all the boilers and generators that are not associated with a unit and tries to find a matching string in the respective collection of boilers or generator), or from a unit connection (where the unit_id_eia is employed to find additional boiler generator connections).'),
    sa.Column('bypass_heat_recovery', sa.Boolean(), nullable=True, comment='Can this generator operate while bypassing the heat recovery steam generator?'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('carbon_capture', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses carbon capture technology.'),
    sa.Column('city', sa.Text(), nullable=True, comment='Name of the city.'),
    sa.Column('cofire_fuels', sa.Boolean(), nullable=True, comment='Can the generator co-fire fuels?.'),
    sa.Column('county', sa.Text(), nullable=True, comment='County name.'),
    sa.Column('current_planned_generator_operating_date', sa.Date(), nullable=True, comment='The most recently updated effective date on which the generator is scheduled to start operation'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.Column('deliver_power_transgrid', sa.Boolean(), nullable=True, comment='Indicate whether the generator can deliver power to the transmission grid.'),
    sa.Column('distributed_generation', sa.Boolean(), nullable=True, comment='Whether the generator is considered distributed generation'),
    sa.Column('duct_burners', sa.Boolean(), nullable=True, comment='Indicates whether the unit has duct-burners for supplementary firing of the turbine exhaust gas'),
    sa.Column('energy_source_1_transport_1', sa.Text(), nullable=True, comment='Primary mode of transport for energy source 1.'),
    sa.Column('energy_source_1_transport_2', sa.Text(), nullable=True, comment='Secondary mode of transport for energy source 1.'),
    sa.Column('energy_source_1_transport_3', sa.Text(), nullable=True, comment='Tertiary mode of transport for energy source 1.'),
    sa.Column('energy_source_2_transport_1', sa.Text(), nullable=True, comment='Primary mode of transport for energy source 2.'),
    sa.Column('energy_source_2_transport_2', sa.Text(), nullable=True, comment='Secondary mode of transport for energy source 2.'),
    sa.Column('energy_source_2_transport_3', sa.Text(), nullable=True, comment='Tertiary mode of transport for energy source 2.'),
    sa.Column('energy_source_code_1', sa.Text(), nullable=True, comment='The code representing the most predominant type of energy that fuels the generator.'),
    sa.Column('energy_source_code_2', sa.Text(), nullable=True, comment='The code representing the second most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_code_3', sa.Text(), nullable=True, comment='The code representing the third most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_code_4', sa.Text(), nullable=True, comment='The code representing the fourth most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_code_5', sa.Text(), nullable=True, comment='The code representing the fifth most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_code_6', sa.Text(), nullable=True, comment='The code representing the sixth most predominant type of energy that fuels the generator'),
    sa.Column('energy_storage_capacity_mwh', sa.Float(), nullable=True, comment='Energy storage capacity in MWh (e.g. for batteries).'),
    sa.Column('ferc_qualifying_facility', sa.Boolean(), nullable=True, comment='Indicates whether or not a generator is a qualifying FERC cogeneration facility.'),
    sa.Column('fluidized_bed_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses fluidized bed technology'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_type_count', sa.Integer(), nullable=True, comment='A count of how many different simple energy sources there are associated with a generator.'),
    sa.Column('generator_operating_date', sa.Date(), nullable=True, comment='Date the generator began commercial operation. If harvested values are inconsistent, we default to using the most recently reported date.'),
    sa.Column('generator_retirement_date', sa.Date(), nullable=True, comment='Date of the scheduled or effected retirement of the generator.'),
    sa.Column('latitude', sa.Float(), nullable=True, comment="Latitude of the plant's location, in degrees."),
    sa.Column('longitude', sa.Float(), nullable=True, comment="Longitude of the plant's location, in degrees."),
    sa.Column('minimum_load_mw', sa.Float(), nullable=True, comment='The minimum load at which the generator can operate at continuosuly.'),
    sa.Column('multiple_fuels', sa.Boolean(), nullable=True, comment='Can the generator burn multiple fuels?'),
    sa.Column('nameplate_power_factor', sa.Float(), nullable=True, comment='The nameplate power factor of the generator.'),
    sa.Column('net_capacity_mwdc', sa.Float(), nullable=True, comment='Generation capacity in megawatts of direct current that is subject to a net metering agreement. Typically used for behind-the-meter solar PV.'),
    sa.Column('operating_switch', sa.Text(), nullable=True, comment='Indicates whether the fuel switching generator can switch when operating'),
    sa.Column('operational_status', sa.Text(), nullable=True, comment='The operating status of the asset. For generators this is based on which tab the generator was listed in in EIA 860.'),
    sa.Column('operational_status_code', sa.Text(), nullable=True, comment='The operating status of the asset.'),
    sa.Column('original_planned_generator_operating_date', sa.Date(), nullable=True, comment='The date the generator was originally scheduled to be operational'),
    sa.Column('other_combustion_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses other combustion technologies'),
    sa.Column('other_modifications_date', sa.Date(), nullable=True, comment='Planned effective date that the generator is scheduled to enter commercial operation after any other planned modification is complete.'),
    sa.Column('other_planned_modifications', sa.Boolean(), nullable=True, comment='Indicates whether there are there other modifications planned for the generator.'),
    sa.Column('owned_by_non_utility', sa.Boolean(), nullable=True, comment='Whether any part of generator is owned by a nonutilty'),
    sa.Column('ownership_code', sa.Text(), nullable=True, comment='Identifies the ownership for each generator.'),
    sa.Column('planned_derate_date', sa.Date(), nullable=True, comment='Planned effective month that the generator is scheduled to enter operation after the derate modification.'),
    sa.Column('planned_energy_source_code_1', sa.Text(), nullable=True, comment='New energy source code for the planned repowered generator.'),
    sa.Column('planned_generator_retirement_date', sa.Date(), nullable=True, comment='Planned effective date of the scheduled retirement of the generator.'),
    sa.Column('planned_modifications', sa.Boolean(), nullable=True, comment='Indicates whether there are any planned capacity uprates/derates, repowering, other modifications, or generator retirements scheduled for the next 5 years.'),
    sa.Column('planned_net_summer_capacity_derate_mw', sa.Float(), nullable=True, comment='Decrease in summer capacity expected to be realized from the derate modification to the equipment.'),
    sa.Column('planned_net_summer_capacity_uprate_mw', sa.Float(), nullable=True, comment='Increase in summer capacity expected to be realized from the modification to the equipment.'),
    sa.Column('planned_net_winter_capacity_derate_mw', sa.Float(), nullable=True, comment='Decrease in winter capacity expected to be realized from the derate modification to the equipment.'),
    sa.Column('planned_net_winter_capacity_uprate_mw', sa.Float(), nullable=True, comment='Increase in winter capacity expected to be realized from the uprate modification to the equipment.'),
    sa.Column('planned_new_capacity_mw', sa.Float(), nullable=True, comment='The expected new namplate capacity for the generator.'),
    sa.Column('planned_new_prime_mover_code', sa.Text(), nullable=True, comment='New prime mover for the planned repowered generator.'),
    sa.Column('planned_repower_date', sa.Date(), nullable=True, comment='Planned effective date that the generator is scheduled to enter operation after the repowering is complete.'),
    sa.Column('planned_uprate_date', sa.Date(), nullable=True, comment='Planned effective date that the generator is scheduled to enter operation after the uprate modification.'),
    sa.Column('previously_canceled', sa.Boolean(), nullable=True, comment='Indicates whether the generator was previously reported as indefinitely postponed or canceled'),
    sa.Column('prime_mover_code', sa.Text(), nullable=True, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('pulverized_coal_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses pulverized coal technology'),
    sa.Column('reactive_power_output_mvar', sa.Float(), nullable=True, comment='Reactive Power Output (MVAr)'),
    sa.Column('rto_iso_lmp_node_id', sa.Text(), nullable=True, comment='The designation used to identify the price node in RTO/ISO Locational Marginal Price reports'),
    sa.Column('rto_iso_location_wholesale_reporting_id', sa.Text(), nullable=True, comment='The designation used to report ths specific location of the wholesale sales transactions to FERC for the Electric Quarterly Report'),
    sa.Column('solid_fuel_gasification', sa.Boolean(), nullable=True, comment='Indicates whether the generator is part of a solid fuel gasification system'),
    sa.Column('startup_source_code_1', sa.Text(), nullable=True, comment='The code representing the first, second, third or fourth start-up and flame stabilization energy source used by the combustion unit(s) associated with this generator.'),
    sa.Column('startup_source_code_2', sa.Text(), nullable=True, comment='The code representing the first, second, third or fourth start-up and flame stabilization energy source used by the combustion unit(s) associated with this generator.'),
    sa.Column('startup_source_code_3', sa.Text(), nullable=True, comment='The code representing the first, second, third or fourth start-up and flame stabilization energy source used by the combustion unit(s) associated with this generator.'),
    sa.Column('startup_source_code_4', sa.Text(), nullable=True, comment='The code representing the first, second, third or fourth start-up and flame stabilization energy source used by the combustion unit(s) associated with this generator.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('stoker_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses stoker technology'),
    sa.Column('street_address', sa.Text(), nullable=True, comment='Physical street address.'),
    sa.Column('subcritical_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses subcritical technology'),
    sa.Column('summer_capacity_estimate', sa.Boolean(), nullable=True, comment='Whether the summer capacity value was an estimate'),
    sa.Column('summer_capacity_mw', sa.Float(), nullable=True, comment='The net summer capacity.'),
    sa.Column('summer_estimated_capability_mw', sa.Float(), nullable=True, comment='EIA estimated summer capacity (in MWh).'),
    sa.Column('supercritical_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses supercritical technology'),
    sa.Column('switch_oil_gas', sa.Boolean(), nullable=True, comment='Indicates whether the generator switch between oil and natural gas.'),
    sa.Column('syncronized_transmission_grid', sa.Boolean(), nullable=True, comment='Indicates whether standby generators (SB status) can be synchronized to the grid.'),
    sa.Column('technology_description', sa.Text(), nullable=True, comment='High level description of the technology used by the generator to produce electricity.'),
    sa.Column('time_cold_shutdown_full_load_code', sa.Text(), nullable=True, comment='The minimum amount of time required to bring the unit to full load from shutdown.'),
    sa.Column('timezone', sa.Enum('Africa/Abidjan', 'Africa/Accra', 'Africa/Addis_Ababa', 'Africa/Algiers', 'Africa/Asmara', 'Africa/Asmera', 'Africa/Bamako', 'Africa/Bangui', 'Africa/Banjul', 'Africa/Bissau', 'Africa/Blantyre', 'Africa/Brazzaville', 'Africa/Bujumbura', 'Africa/Cairo', 'Africa/Casablanca', 'Africa/Ceuta', 'Africa/Conakry', 'Africa/Dakar', 'Africa/Dar_es_Salaam', 'Africa/Djibouti', 'Africa/Douala', 'Africa/El_Aaiun', 'Africa/Freetown', 'Africa/Gaborone', 'Africa/Harare', 'Africa/Johannesburg', 'Africa/Juba', 'Africa/Kampala', 'Africa/Khartoum', 'Africa/Kigali', 'Africa/Kinshasa', 'Africa/Lagos', 'Africa/Libreville', 'Africa/Lome', 'Africa/Luanda', 'Africa/Lubumbashi', 'Africa/Lusaka', 'Africa/Malabo', 'Africa/Maputo', 'Africa/Maseru', 'Africa/Mbabane', 'Africa/Mogadishu', 'Africa/Monrovia', 'Africa/Nairobi', 'Africa/Ndjamena', 'Africa/Niamey', 'Africa/Nouakchott', 'Africa/Ouagadougou', 'Africa/Porto-Novo', 'Africa/Sao_Tome', 'Africa/Timbuktu', 'Africa/Tripoli', 'Africa/Tunis', 'Africa/Windhoek', 'America/Adak', 'America/Anchorage', 'America/Anguilla', 'America/Antigua', 'America/Araguaina', 'America/Argentina/Buenos_Aires', 'America/Argentina/Catamarca', 'America/Argentina/ComodRivadavia', 'America/Argentina/Cordoba', 'America/Argentina/Jujuy', 'America/Argentina/La_Rioja', 'America/Argentina/Mendoza', 'America/Argentina/Rio_Gallegos', 'America/Argentina/Salta', 'America/Argentina/San_Juan', 'America/Argentina/San_Luis', 'America/Argentina/Tucuman', 'America/Argentina/Ushuaia', 'America/Aruba', 'America/Asuncion', 'America/Atikokan', 'America/Atka', 'America/Bahia', 'America/Bahia_Banderas', 'America/Barbados', 'America/Belem', 'America/Belize', 'America/Blanc-Sablon', 'America/Boa_Vista', 'America/Bogota', 'America/Boise', 'America/Buenos_Aires', 'America/Cambridge_Bay', 'America/Campo_Grande', 'America/Cancun', 'America/Caracas', 'America/Catamarca', 'America/Cayenne', 'America/Cayman', 'America/Chicago', 'America/Chihuahua', 'America/Ciudad_Juarez', 'America/Coral_Harbour', 'America/Cordoba', 'America/Costa_Rica', 'America/Creston', 'America/Cuiaba', 'America/Curacao', 'America/Danmarkshavn', 'America/Dawson', 'America/Dawson_Creek', 'America/Denver', 'America/Detroit', 'America/Dominica', 'America/Edmonton', 'America/Eirunepe', 'America/El_Salvador', 'America/Ensenada', 'America/Fort_Nelson', 'America/Fort_Wayne', 'America/Fortaleza', 'America/Glace_Bay', 'America/Godthab', 'America/Goose_Bay', 'America/Grand_Turk', 'America/Grenada', 'America/Guadeloupe', 'America/Guatemala', 'America/Guayaquil', 'America/Guyana', 'America/Halifax', 'America/Havana', 'America/Hermosillo', 'America/Indiana/Indianapolis', 'America/Indiana/Knox', 'America/Indiana/Marengo', 'America/Indiana/Petersburg', 'America/Indiana/Tell_City', 'America/Indiana/Vevay', 'America/Indiana/Vincennes', 'America/Indiana/Winamac', 'America/Indianapolis', 'America/Inuvik', 'America/Iqaluit', 'America/Jamaica', 'America/Jujuy', 'America/Juneau', 'America/Kentucky/Louisville', 'America/Kentucky/Monticello', 'America/Knox_IN', 'America/Kralendijk', 'America/La_Paz', 'America/Lima', 'America/Los_Angeles', 'America/Louisville', 'America/Lower_Princes', 'America/Maceio', 'America/Managua', 'America/Manaus', 'America/Marigot', 'America/Martinique', 'America/Matamoros', 'America/Mazatlan', 'America/Mendoza', 'America/Menominee', 'America/Merida', 'America/Metlakatla', 'America/Mexico_City', 'America/Miquelon', 'America/Moncton', 'America/Monterrey', 'America/Montevideo', 'America/Montreal', 'America/Montserrat', 'America/Nassau', 'America/New_York', 'America/Nipigon', 'America/Nome', 'America/Noronha', 'America/North_Dakota/Beulah', 'America/North_Dakota/Center', 'America/North_Dakota/New_Salem', 'America/Nuuk', 'America/Ojinaga', 'America/Panama', 'America/Pangnirtung', 'America/Paramaribo', 'America/Phoenix', 'America/Port-au-Prince', 'America/Port_of_Spain', 'America/Porto_Acre', 'America/Porto_Velho', 'America/Puerto_Rico', 'America/Punta_Arenas', 'America/Rainy_River', 'America/Rankin_Inlet', 'America/Recife', 'America/Regina', 'America/Resolute', 'America/Rio_Branco', 'America/Rosario', 'America/Santa_Isabel', 'America/Santarem', 'America/Santiago', 'America/Santo_Domingo', 'America/Sao_Paulo', 'America/Scoresbysund', 'America/Shiprock', 'America/Sitka', 'America/St_Barthelemy', 'America/St_Johns', 'America/St_Kitts', 'America/St_Lucia', 'America/St_Thomas', 'America/St_Vincent', 'America/Swift_Current', 'America/Tegucigalpa', 'America/Thule', 'America/Thunder_Bay', 'America/Tijuana', 'America/Toronto', 'America/Tortola', 'America/Vancouver', 'America/Virgin', 'America/Whitehorse', 'America/Winnipeg', 'America/Yakutat', 'America/Yellowknife', 'Antarctica/Casey', 'Antarctica/Davis', 'Antarctica/DumontDUrville', 'Antarctica/Macquarie', 'Antarctica/Mawson', 'Antarctica/McMurdo', 'Antarctica/Palmer', 'Antarctica/Rothera', 'Antarctica/South_Pole', 'Antarctica/Syowa', 'Antarctica/Troll', 'Antarctica/Vostok', 'Arctic/Longyearbyen', 'Asia/Aden', 'Asia/Almaty', 'Asia/Amman', 'Asia/Anadyr', 'Asia/Aqtau', 'Asia/Aqtobe', 'Asia/Ashgabat', 'Asia/Ashkhabad', 'Asia/Atyrau', 'Asia/Baghdad', 'Asia/Bahrain', 'Asia/Baku', 'Asia/Bangkok', 'Asia/Barnaul', 'Asia/Beirut', 'Asia/Bishkek', 'Asia/Brunei', 'Asia/Calcutta', 'Asia/Chita', 'Asia/Choibalsan', 'Asia/Chongqing', 'Asia/Chungking', 'Asia/Colombo', 'Asia/Dacca', 'Asia/Damascus', 'Asia/Dhaka', 'Asia/Dili', 'Asia/Dubai', 'Asia/Dushanbe', 'Asia/Famagusta', 'Asia/Gaza', 'Asia/Harbin', 'Asia/Hebron', 'Asia/Ho_Chi_Minh', 'Asia/Hong_Kong', 'Asia/Hovd', 'Asia/Irkutsk', 'Asia/Istanbul', 'Asia/Jakarta', 'Asia/Jayapura', 'Asia/Jerusalem', 'Asia/Kabul', 'Asia/Kamchatka', 'Asia/Karachi', 'Asia/Kashgar', 'Asia/Kathmandu', 'Asia/Katmandu', 'Asia/Khandyga', 'Asia/Kolkata', 'Asia/Krasnoyarsk', 'Asia/Kuala_Lumpur', 'Asia/Kuching', 'Asia/Kuwait', 'Asia/Macao', 'Asia/Macau', 'Asia/Magadan', 'Asia/Makassar', 'Asia/Manila', 'Asia/Muscat', 'Asia/Nicosia', 'Asia/Novokuznetsk', 'Asia/Novosibirsk', 'Asia/Omsk', 'Asia/Oral', 'Asia/Phnom_Penh', 'Asia/Pontianak', 'Asia/Pyongyang', 'Asia/Qatar', 'Asia/Qostanay', 'Asia/Qyzylorda', 'Asia/Rangoon', 'Asia/Riyadh', 'Asia/Saigon', 'Asia/Sakhalin', 'Asia/Samarkand', 'Asia/Seoul', 'Asia/Shanghai', 'Asia/Singapore', 'Asia/Srednekolymsk', 'Asia/Taipei', 'Asia/Tashkent', 'Asia/Tbilisi', 'Asia/Tehran', 'Asia/Tel_Aviv', 'Asia/Thimbu', 'Asia/Thimphu', 'Asia/Tokyo', 'Asia/Tomsk', 'Asia/Ujung_Pandang', 'Asia/Ulaanbaatar', 'Asia/Ulan_Bator', 'Asia/Urumqi', 'Asia/Ust-Nera', 'Asia/Vientiane', 'Asia/Vladivostok', 'Asia/Yakutsk', 'Asia/Yangon', 'Asia/Yekaterinburg', 'Asia/Yerevan', 'Atlantic/Azores', 'Atlantic/Bermuda', 'Atlantic/Canary', 'Atlantic/Cape_Verde', 'Atlantic/Faeroe', 'Atlantic/Faroe', 'Atlantic/Jan_Mayen', 'Atlantic/Madeira', 'Atlantic/Reykjavik', 'Atlantic/South_Georgia', 'Atlantic/St_Helena', 'Atlantic/Stanley', 'Australia/ACT', 'Australia/Adelaide', 'Australia/Brisbane', 'Australia/Broken_Hill', 'Australia/Canberra', 'Australia/Currie', 'Australia/Darwin', 'Australia/Eucla', 'Australia/Hobart', 'Australia/LHI', 'Australia/Lindeman', 'Australia/Lord_Howe', 'Australia/Melbourne', 'Australia/NSW', 'Australia/North', 'Australia/Perth', 'Australia/Queensland', 'Australia/South', 'Australia/Sydney', 'Australia/Tasmania', 'Australia/Victoria', 'Australia/West', 'Australia/Yancowinna', 'Brazil/Acre', 'Brazil/DeNoronha', 'Brazil/East', 'Brazil/West', 'CET', 'CST6CDT', 'Canada/Atlantic', 'Canada/Central', 'Canada/Eastern', 'Canada/Mountain', 'Canada/Newfoundland', 'Canada/Pacific', 'Canada/Saskatchewan', 'Canada/Yukon', 'Chile/Continental', 'Chile/EasterIsland', 'Cuba', 'EET', 'EST', 'EST5EDT', 'Egypt', 'Eire', 'Etc/GMT', 'Etc/GMT+0', 'Etc/GMT+1', 'Etc/GMT+10', 'Etc/GMT+11', 'Etc/GMT+12', 'Etc/GMT+2', 'Etc/GMT+3', 'Etc/GMT+4', 'Etc/GMT+5', 'Etc/GMT+6', 'Etc/GMT+7', 'Etc/GMT+8', 'Etc/GMT+9', 'Etc/GMT-0', 'Etc/GMT-1', 'Etc/GMT-10', 'Etc/GMT-11', 'Etc/GMT-12', 'Etc/GMT-13', 'Etc/GMT-14', 'Etc/GMT-2', 'Etc/GMT-3', 'Etc/GMT-4', 'Etc/GMT-5', 'Etc/GMT-6', 'Etc/GMT-7', 'Etc/GMT-8', 'Etc/GMT-9', 'Etc/GMT0', 'Etc/Greenwich', 'Etc/UCT', 'Etc/UTC', 'Etc/Universal', 'Etc/Zulu', 'Europe/Amsterdam', 'Europe/Andorra', 'Europe/Astrakhan', 'Europe/Athens', 'Europe/Belfast', 'Europe/Belgrade', 'Europe/Berlin', 'Europe/Bratislava', 'Europe/Brussels', 'Europe/Bucharest', 'Europe/Budapest', 'Europe/Busingen', 'Europe/Chisinau', 'Europe/Copenhagen', 'Europe/Dublin', 'Europe/Gibraltar', 'Europe/Guernsey', 'Europe/Helsinki', 'Europe/Isle_of_Man', 'Europe/Istanbul', 'Europe/Jersey', 'Europe/Kaliningrad', 'Europe/Kiev', 'Europe/Kirov', 'Europe/Kyiv', 'Europe/Lisbon', 'Europe/Ljubljana', 'Europe/London', 'Europe/Luxembourg', 'Europe/Madrid', 'Europe/Malta', 'Europe/Mariehamn', 'Europe/Minsk', 'Europe/Monaco', 'Europe/Moscow', 'Europe/Nicosia', 'Europe/Oslo', 'Europe/Paris', 'Europe/Podgorica', 'Europe/Prague', 'Europe/Riga', 'Europe/Rome', 'Europe/Samara', 'Europe/San_Marino', 'Europe/Sarajevo', 'Europe/Saratov', 'Europe/Simferopol', 'Europe/Skopje', 'Europe/Sofia', 'Europe/Stockholm', 'Europe/Tallinn', 'Europe/Tirane', 'Europe/Tiraspol', 'Europe/Ulyanovsk', 'Europe/Uzhgorod', 'Europe/Vaduz', 'Europe/Vatican', 'Europe/Vienna', 'Europe/Vilnius', 'Europe/Volgograd', 'Europe/Warsaw', 'Europe/Zagreb', 'Europe/Zaporozhye', 'Europe/Zurich', 'GB', 'GB-Eire', 'GMT', 'GMT+0', 'GMT-0', 'GMT0', 'Greenwich', 'HST', 'Hongkong', 'Iceland', 'Indian/Antananarivo', 'Indian/Chagos', 'Indian/Christmas', 'Indian/Cocos', 'Indian/Comoro', 'Indian/Kerguelen', 'Indian/Mahe', 'Indian/Maldives', 'Indian/Mauritius', 'Indian/Mayotte', 'Indian/Reunion', 'Iran', 'Israel', 'Jamaica', 'Japan', 'Kwajalein', 'Libya', 'MET', 'MST', 'MST7MDT', 'Mexico/BajaNorte', 'Mexico/BajaSur', 'Mexico/General', 'NZ', 'NZ-CHAT', 'Navajo', 'PRC', 'PST8PDT', 'Pacific/Apia', 'Pacific/Auckland', 'Pacific/Bougainville', 'Pacific/Chatham', 'Pacific/Chuuk', 'Pacific/Easter', 'Pacific/Efate', 'Pacific/Enderbury', 'Pacific/Fakaofo', 'Pacific/Fiji', 'Pacific/Funafuti', 'Pacific/Galapagos', 'Pacific/Gambier', 'Pacific/Guadalcanal', 'Pacific/Guam', 'Pacific/Honolulu', 'Pacific/Johnston', 'Pacific/Kanton', 'Pacific/Kiritimati', 'Pacific/Kosrae', 'Pacific/Kwajalein', 'Pacific/Majuro', 'Pacific/Marquesas', 'Pacific/Midway', 'Pacific/Nauru', 'Pacific/Niue', 'Pacific/Norfolk', 'Pacific/Noumea', 'Pacific/Pago_Pago', 'Pacific/Palau', 'Pacific/Pitcairn', 'Pacific/Pohnpei', 'Pacific/Ponape', 'Pacific/Port_Moresby', 'Pacific/Rarotonga', 'Pacific/Saipan', 'Pacific/Samoa', 'Pacific/Tahiti', 'Pacific/Tarawa', 'Pacific/Tongatapu', 'Pacific/Truk', 'Pacific/Wake', 'Pacific/Wallis', 'Pacific/Yap', 'Poland', 'Portugal', 'ROC', 'ROK', 'Singapore', 'Turkey', 'UCT', 'US/Alaska', 'US/Aleutian', 'US/Arizona', 'US/Central', 'US/East-Indiana', 'US/Eastern', 'US/Hawaii', 'US/Indiana-Starke', 'US/Michigan', 'US/Mountain', 'US/Pacific', 'US/Samoa', 'UTC', 'Universal', 'W-SU', 'WET', 'Zulu'), nullable=True, comment='IANA timezone name'),
    sa.Column('topping_bottoming_code', sa.Text(), nullable=True, comment='If the generator is associated with a combined heat and power system, indicates whether the generator is part of a topping cycle or a bottoming cycle'),
    sa.Column('turbines_inverters_hydrokinetics', sa.Integer(), nullable=True, comment='Number of wind turbines, or hydrokinetic buoys.'),
    sa.Column('turbines_num', sa.Integer(), nullable=True, comment='Number of wind turbines, or hydrokinetic buoys.'),
    sa.Column('ultrasupercritical_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses ultra-supercritical technology'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('uprate_derate_completed_date', sa.Date(), nullable=True, comment='The date when the uprate or derate was completed.'),
    sa.Column('uprate_derate_during_year', sa.Boolean(), nullable=True, comment='Was an uprate or derate completed on this generator during the reporting year?'),
    sa.Column('winter_capacity_estimate', sa.Boolean(), nullable=True, comment='Whether the winter capacity value was an estimate'),
    sa.Column('winter_capacity_mw', sa.Float(), nullable=True, comment='The net winter capacity.'),
    sa.Column('winter_estimated_capability_mw', sa.Float(), nullable=True, comment='EIA estimated winter capacity (in MWh).'),
    sa.Column('zip_code', sa.Text(), nullable=True, comment='Five digit US Zip Code.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk__out_eia__yearly_generators_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_1_transport_1'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_1_transport_1_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_1_transport_2'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_1_transport_2_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_1_transport_3'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_1_transport_3_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_2_transport_1'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_2_transport_1_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_2_transport_2'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_2_transport_2_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_2_transport_3'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_2_transport_3_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_2'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_code_2_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_3'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_code_3_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_4'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_code_4_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_5'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_code_5_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_6'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_code_6_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['operational_status_code'], ['core_eia__codes_operational_status.code'], name=op.f('fk__out_eia__yearly_generators_operational_status_code_core_eia__codes_operational_status')),
    sa.ForeignKeyConstraint(['planned_energy_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_planned_energy_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['planned_new_prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk__out_eia__yearly_generators_planned_new_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk__out_eia__yearly_generators_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk__out_eia__yearly_generators_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk__out_eia__yearly_generators_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['startup_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_startup_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['startup_source_code_2'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_startup_source_code_2_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['startup_source_code_3'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_startup_source_code_3_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['startup_source_code_4'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_startup_source_code_4_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk__out_eia__yearly_generators_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk__out_eia__yearly_generators_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'generator_id', 'report_date', name=op.f('pk__out_eia__yearly_generators'))
    )
    op.create_table('_out_eia__yearly_heat_rate_by_generator',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.Float(), nullable=True, comment='Fuel content per unit of electricity generated. Coming from MCOE calculation.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_type_count', sa.Integer(), nullable=True, comment='A count of how many different simple energy sources there are associated with a generator.'),
    sa.Column('prime_mover_code', sa.Text(), nullable=True, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk__out_eia__yearly_heat_rate_by_generator_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk__out_eia__yearly_heat_rate_by_generator_prime_mover_code_core_eia__codes_prime_movers')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk__out_eia__yearly_heat_rate_by_generator'))
    )
    op.create_table('core_eia860__assn_boiler_cooling',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('boiler_id', sa.Text(), nullable=False, comment='Alphanumeric boiler ID.'),
    sa.Column('cooling_id_eia', sa.Text(), nullable=False, comment="EIA Identification code for cooling system (if multiple cooling systems are not distinguished by separate IDs, the word 'PLANT' is listed to encompass the cooling system for the entire plant)"),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia860__assn_boiler_cooling_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'boiler_id', 'report_date'], ['core_eia860__scd_boilers.plant_id_eia', 'core_eia860__scd_boilers.boiler_id', 'core_eia860__scd_boilers.report_date'], name=op.f('fk_core_eia860__assn_boiler_cooling_plant_id_eia_core_eia860__scd_boilers')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'boiler_id', 'cooling_id_eia', name=op.f('pk_core_eia860__assn_boiler_cooling'))
    )
    op.create_table('core_eia860__assn_boiler_generator',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('boiler_id', sa.Text(), nullable=False, comment='Alphanumeric boiler ID.'),
    sa.Column('unit_id_eia', sa.Text(), nullable=True, comment='EIA-assigned unit identification code.'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('boiler_generator_assn_type_code', sa.Text(), nullable=True, comment='Indicates whether boiler associations with generator during the year were actual or theoretical. Only available before 2013.'),
    sa.Column('steam_plant_type_code', sa.Integer(), nullable=True, comment='Code that describes types of steam plants from EIA 860. See steam_plant_types_eia table for more details.'),
    sa.Column('bga_source', sa.Text(), nullable=True, comment='The source from where the unit_id_pudl is compiled. The unit_id_pudl comes directly from EIA 860, or string association (which looks at all the boilers and generators that are not associated with a unit and tries to find a matching string in the respective collection of boilers or generator), or from a unit connection (where the unit_id_eia is employed to find additional boiler generator connections).'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['boiler_generator_assn_type_code'], ['core_eia__codes_boiler_generator_assn_types.code'], name=op.f('fk_core_eia860__assn_boiler_generator_boiler_generator_assn_type_code_core_eia__codes_boiler_generator_assn_types')),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia860__assn_boiler_generator_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'boiler_id', 'report_date'], ['core_eia860__scd_boilers.plant_id_eia', 'core_eia860__scd_boilers.boiler_id', 'core_eia860__scd_boilers.report_date'], name=op.f('fk_core_eia860__assn_boiler_generator_plant_id_eia_core_eia860__scd_boilers')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk_core_eia860__assn_boiler_generator_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['steam_plant_type_code'], ['core_eia__codes_steam_plant_types.code'], name=op.f('fk_core_eia860__assn_boiler_generator_steam_plant_type_code_core_eia__codes_steam_plant_types')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_date', 'generator_id', 'boiler_id', name=op.f('pk_core_eia860__assn_boiler_generator'))
    )
    op.create_table('core_eia860__assn_boiler_stack_flue',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('boiler_id', sa.Text(), nullable=False, comment='Alphanumeric boiler ID.'),
    sa.Column('stack_id_eia', sa.Text(), nullable=True, comment='The stack identification value reported to EIA. Stacks or chimneys are the place where emissions from the combustion process are released into the atmosphere. This field was reported in conjunction with flue_id_eia until 2013 when stack_flue_id_eia took their place.'),
    sa.Column('flue_id_eia', sa.Text(), nullable=True, comment='The flue identification value reported to EIA. The flue is a duct, pipe, or opening that transports exhast gases through the stack. This field was reported in conjunction with stack_id_eia until 2013 when stack_flue_id_eia took their place.'),
    sa.Column('stack_flue_id_eia', sa.Text(), nullable=True, comment='The stack or flue identification value reported to EIA. This denotes the place where emissions from the combusion process are released into the atmosphere. Prior to 2013, this was reported as `stack_id_eia` and `flue_id_eia`.'),
    sa.Column('stack_flue_id_pudl', sa.Text(), nullable=False, comment='A stack and/or flue identification value created by PUDL for use as part of the primary key for the stack flue equipment and boiler association tables. For 2013 and onward, this value is equal to the value for stack_flue_id_eia. Prior to 2013, this value is equal to the value for stack_id_eia and the value for flue_id_eia seperated by an underscore or just the stack_flue_eia in cases where flue_id_eia is NA.'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'boiler_id', 'report_date'], ['core_eia860__scd_boilers.plant_id_eia', 'core_eia860__scd_boilers.boiler_id', 'core_eia860__scd_boilers.report_date'], name=op.f('fk_core_eia860__assn_boiler_stack_flue_plant_id_eia_core_eia860__scd_boilers')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'boiler_id', 'stack_flue_id_pudl', name=op.f('pk_core_eia860__assn_boiler_stack_flue'))
    )
    op.create_table('core_eia860__assn_yearly_boiler_emissions_control_equipment',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('boiler_id', sa.Text(), nullable=False, comment='Alphanumeric boiler ID.'),
    sa.Column('emission_control_id_type', sa.Text(), nullable=False, comment='The type of emissions control id: SO2, NOx, particulate, or mercury.'),
    sa.Column('emission_control_id_eia', sa.Text(), nullable=False, comment="The emission control ID used to collect SO2, NOx, particulate, and mercury emissions data. This column should be used in conjunction with emissions_control_type as it's not guaranteed to be unique."),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia860__assn_yearly_boiler_emissions_control_equipment_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'boiler_id', 'report_date'], ['core_eia860__scd_boilers.plant_id_eia', 'core_eia860__scd_boilers.boiler_id', 'core_eia860__scd_boilers.report_date'], name=op.f('fk_core_eia860__assn_yearly_boiler_emissions_control_equipment_plant_id_eia_core_eia860__scd_boilers')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'boiler_id', 'emission_control_id_type', 'emission_control_id_eia', name=op.f('pk_core_eia860__assn_yearly_boiler_emissions_control_equipment'))
    )
    op.create_table('core_eia860__scd_generators_energy_storage',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('max_charge_rate_mw', sa.Float(), nullable=True, comment='Maximum charge rate in MW.'),
    sa.Column('max_discharge_rate_mw', sa.Float(), nullable=True, comment='Maximum discharge rate in MW.'),
    sa.Column('storage_enclosure_code', sa.Text(), nullable=True, comment='A code representing the enclosure type that best describes where the generator is located.'),
    sa.Column('storage_technology_code_1', sa.Text(), nullable=True, comment='The electro-chemical storage technology used for this battery applications.'),
    sa.Column('storage_technology_code_2', sa.Text(), nullable=True, comment='The electro-chemical storage technology used for this battery applications.'),
    sa.Column('storage_technology_code_3', sa.Text(), nullable=True, comment='The electro-chemical storage technology used for this battery applications.'),
    sa.Column('storage_technology_code_4', sa.Text(), nullable=True, comment='The electro-chemical storage technology used for this battery applications.'),
    sa.Column('served_arbitrage', sa.Boolean(), nullable=True, comment='Whether the energy storage device served arbitrage applications during the reporting year'),
    sa.Column('served_backup_power', sa.Boolean(), nullable=True, comment='Whether the energy storage device served backup power applications during the reporting year.'),
    sa.Column('served_co_located_renewable_firming', sa.Boolean(), nullable=True, comment='Whether the energy storage device served renewable firming applications during the reporting year.'),
    sa.Column('served_frequency_regulation', sa.Boolean(), nullable=True, comment='Whether the energy storage device served frequency regulation applications during the reporting year.'),
    sa.Column('served_load_following', sa.Boolean(), nullable=True, comment='Whether the energy storage device served load following applications during the reporting year.'),
    sa.Column('served_load_management', sa.Boolean(), nullable=True, comment='Whether the energy storage device served load management applications during the reporting year.'),
    sa.Column('served_ramping_spinning_reserve', sa.Boolean(), nullable=True, comment='Whether the this energy storage device served ramping / spinning reserve applications during the reporting year.'),
    sa.Column('served_system_peak_shaving', sa.Boolean(), nullable=True, comment='Whether the energy storage device served system peak shaving applications during the reporting year.'),
    sa.Column('served_transmission_and_distribution_deferral', sa.Boolean(), nullable=True, comment='Whether the energy storage device served renewable firming applications during the reporting year.'),
    sa.Column('served_voltage_or_reactive_power_support', sa.Boolean(), nullable=True, comment='Whether the energy storage device served voltage or reactive power support applications during the reporting year.'),
    sa.Column('stored_excess_wind_and_solar_generation', sa.Boolean(), nullable=True, comment='Whether the energy storage device was used to store excess wind/solar generation during the reporting year.'),
    sa.Column('is_ac_coupled', sa.Boolean(), nullable=True, comment='Indicates if this energy storage device is AC-coupled (means the energy storage device and the PV system are not installed on the same side of an inverter).'),
    sa.Column('is_dc_coupled', sa.Boolean(), nullable=True, comment='Indicates if this energy storage device is DC-coupled (means the energy storage device and the PV system are on the same side of an inverter and the battery can still charge from the grid).'),
    sa.Column('id_dc_coupled_tightly', sa.Boolean(), nullable=True, comment='Indicates if this energy storage device is DC tightly coupled (means the energy storage device and the PV system are on the same side of an inverter and the battery cannot charge from the grid).'),
    sa.Column('is_independent', sa.Boolean(), nullable=True, comment='Indicates if this energy storage device is independent (not coupled with another generators)'),
    sa.Column('is_transmission_and_distribution_asset_support', sa.Boolean(), nullable=True, comment='Indicate if the energy storage system is intended to support a specific substation, transmission or distribution asset.'),
    sa.Column('is_direct_support', sa.Boolean(), nullable=True, comment='Indicates if this energy storage device is intended for dedicated generator firming or storing excess generation of other units.'),
    sa.Column('plant_id_eia_direct_support_1', sa.Float(), nullable=True, comment='The EIA Plant ID of the primary unit whose generation this energy storage device is intended to firm or store.'),
    sa.Column('generator_id_direct_support_1', sa.Text(), nullable=True, comment='The EIA Generator ID of the primary unit whose generation this energy storage device is intended to firm or store.'),
    sa.Column('plant_id_eia_direct_support_2', sa.Float(), nullable=True, comment='The EIA Plant ID of the secondary unit whose generation this energy storage device is intended to firm or store.'),
    sa.Column('generator_id_direct_support_2', sa.Text(), nullable=True, comment='The EIA Generator ID of the secondary unit whose generation this energy storage device is intended to firm or store.'),
    sa.Column('plant_id_eia_direct_support_3', sa.Float(), nullable=True, comment='The EIA Plant ID of the tertiary unit whose generation this energy storage device is intended to firm or store.'),
    sa.Column('generator_id_direct_support_3', sa.Text(), nullable=True, comment='The EIA Generator ID of the tertiary unit whose generation this energy storage device is intended to firm or store.'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk_core_eia860__scd_generators_energy_storage_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['storage_enclosure_code'], ['core_eia__codes_storage_enclosure_types.code'], name=op.f('fk_core_eia860__scd_generators_energy_storage_storage_enclosure_code_core_eia__codes_storage_enclosure_types')),
    sa.ForeignKeyConstraint(['storage_technology_code_1'], ['core_eia__codes_storage_technology_types.code'], name=op.f('fk_core_eia860__scd_generators_energy_storage_storage_technology_code_1_core_eia__codes_storage_technology_types')),
    sa.ForeignKeyConstraint(['storage_technology_code_2'], ['core_eia__codes_storage_technology_types.code'], name=op.f('fk_core_eia860__scd_generators_energy_storage_storage_technology_code_2_core_eia__codes_storage_technology_types')),
    sa.ForeignKeyConstraint(['storage_technology_code_3'], ['core_eia__codes_storage_technology_types.code'], name=op.f('fk_core_eia860__scd_generators_energy_storage_storage_technology_code_3_core_eia__codes_storage_technology_types')),
    sa.ForeignKeyConstraint(['storage_technology_code_4'], ['core_eia__codes_storage_technology_types.code'], name=op.f('fk_core_eia860__scd_generators_energy_storage_storage_technology_code_4_core_eia__codes_storage_technology_types')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'generator_id', 'report_date', name=op.f('pk_core_eia860__scd_generators_energy_storage'))
    )
    op.create_table('core_eia860__scd_generators_solar',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('standard_testing_conditions_capacity_mwdc', sa.Float(), nullable=True, comment='The net capacity of this photovoltaic generator in direct current under standard test conditions (STC) of 1000 W/m^2 solar irradiance and 25 degrees Celsius PV module temperature. This was only reported in 2013 and 2014.'),
    sa.Column('net_metering_capacity_mwdc', sa.Float(), nullable=True, comment='The DC megawatt capacity that is part of a net metering agreement.'),
    sa.Column('uses_net_metering_agreement', sa.Boolean(), nullable=True, comment='Indicates if the output from this generator is part of a net metering agreement.'),
    sa.Column('uses_virtual_net_metering_agreement', sa.Boolean(), nullable=True, comment='Indicates if the output from this generator is part of a virtual net metering agreement.'),
    sa.Column('virtual_net_metering_capacity_mwdc', sa.Float(), nullable=True, comment='The DC capacity in MW that is part of a virtual net metering agreement.'),
    sa.Column('azimuth_angle_deg', sa.Float(), nullable=True, comment='Indicates the azimuth angle of the unit for fixed tilt or single-axis technologies.'),
    sa.Column('tilt_angle_deg', sa.Float(), nullable=True, comment='Indicates the tilt angle of the unit for fixed tilt or single-axis technologies.'),
    sa.Column('uses_technology_lenses_mirrors', sa.Boolean(), nullable=True, comment='Indicates whether lenses or mirrors are used at this solar generating unit.'),
    sa.Column('uses_technology_single_axis_tracking', sa.Boolean(), nullable=True, comment='Indicates whether single-axis tracking technologies are used at this solar generating unit.'),
    sa.Column('uses_technology_dual_axis_tracking', sa.Boolean(), nullable=True, comment='Indicates whether dual-axis tracking technologies are used at this solar generating unit.'),
    sa.Column('uses_technology_fixed_tilt', sa.Boolean(), nullable=True, comment='Indicates whether fixed tilt technologies are used at this solar generating unit.'),
    sa.Column('uses_technology_east_west_fixed_tilt', sa.Boolean(), nullable=True, comment='Indicates whether east west fixed tilt technologies are used at this solar generating unit.'),
    sa.Column('uses_technology_parabolic_trough', sa.Boolean(), nullable=True, comment='Indicates whether parabolic trough technologies s are used at this solar generating unit.'),
    sa.Column('uses_technology_linear_fresnel', sa.Boolean(), nullable=True, comment='Indicates whether linear fresnel technologies are used at this solar generating unit.'),
    sa.Column('uses_technology_power_tower', sa.Boolean(), nullable=True, comment='Indicates whether power towers are used at this solar generating unit.'),
    sa.Column('uses_technology_dish_engine', sa.Boolean(), nullable=True, comment='Indicates whether dish engines are used at this solar generating unit.'),
    sa.Column('uses_technology_other', sa.Boolean(), nullable=True, comment='Indicates whether other solar technologies are used at this solar generating unit.'),
    sa.Column('uses_material_crystalline_silicon', sa.Boolean(), nullable=True, comment='Indicates whether any solar photovoltaic panels at this generator are made of crystalline silicon.'),
    sa.Column('uses_material_thin_film_a_si', sa.Boolean(), nullable=True, comment='Indicates whether any solar photovoltaic panels at this generator are made of thin-film amorphous silicon (A-Si).'),
    sa.Column('uses_material_thin_film_cdte', sa.Boolean(), nullable=True, comment='Indicates whether any solar photovoltaic panels at this generator are made of thin-film cadmium telluride (CdTe).'),
    sa.Column('uses_material_thin_film_cigs', sa.Boolean(), nullable=True, comment='Indicates whether any solar photovoltaic panels at this generator are made of thin-film copper indium gallium diselenide (CIGS).'),
    sa.Column('uses_material_thin_film_other', sa.Boolean(), nullable=True, comment='Indicates whether any solar photovoltaic panels at this generator are made of other thin-film material.'),
    sa.Column('uses_material_other', sa.Boolean(), nullable=True, comment='Indicates whether any solar photovoltaic panels at this generator are made of other materials.'),
    sa.Column('uses_bifacial_panels', sa.Boolean(), nullable=True, comment='Indicates whether bifacial solar panels are used at this solar generating unit.'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk_core_eia860__scd_generators_solar_plant_id_eia_core_eia860__scd_generators')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'generator_id', 'report_date', name=op.f('pk_core_eia860__scd_generators_solar'))
    )
    op.create_table('core_eia860__scd_generators_wind',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('design_wind_speed_mph', sa.Float(), nullable=True, comment='Average annual wind speed that turbines at this wind site were designed for.'),
    sa.Column('obstacle_id_faa', sa.Text(), nullable=True, comment="The Federal Aviation Administration (FAA) obstacle number assigned to this generator. If more than one obstacle number exists, the one that best represents the turbines. References the obstacle numbers reported in the FAA's Digital Obstacle File: https://www.faa.gov/air_traffic/flight_info/aeronav/digital_products/dof/ This field was only reported from 2013 through 2015."),
    sa.Column('predominant_turbine_manufacturer', sa.Text(), nullable=True, comment='Name of predominant manufacturer of turbines at this generator.'),
    sa.Column('predominant_turbine_model', sa.Text(), nullable=True, comment='Predominant model number of turbines at this generator.'),
    sa.Column('turbine_hub_height_feet', sa.Float(), nullable=True, comment='The hub height of turbines at this generator. If more than one value exists, the one that best represents the turbines.'),
    sa.Column('wind_quality_class', sa.Integer(), nullable=True, comment='The wind quality class for turbines at this generator. See table core_eia__codes_wind_quality_class for specifications about each class.'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk_core_eia860__scd_generators_wind_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['wind_quality_class'], ['core_eia__codes_wind_quality_class.code'], name=op.f('fk_core_eia860__scd_generators_wind_wind_quality_class_core_eia__codes_wind_quality_class')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'generator_id', 'report_date', name=op.f('pk_core_eia860__scd_generators_wind'))
    )
    op.create_table('core_eia860__scd_ownership',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('owner_utility_id_eia', sa.Integer(), nullable=False, comment='The EIA utility Identification number for the owner company that is responsible for the day-to-day operations of the generator, not the operator utility.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('owner_utility_name_eia', sa.Text(), nullable=True, comment='The name of the EIA owner utility.'),
    sa.Column('owner_state', sa.Enum('SD', 'KS', 'ND', 'AK', 'CT', 'AS', 'MA', 'MD', 'PA', 'FL', 'QC', 'IA', 'MP', 'HI', 'MT', 'IL', 'WI', 'LA', 'NU', 'NB', 'MI', 'NS', 'PE', 'CA', 'OK', 'NJ', 'ME', 'UT', 'GU', 'GA', 'NV', 'WV', 'MS', 'NL', 'WA', 'MO', 'KY', 'AL', 'SC', 'VI', 'WY', 'DC', 'VA', 'IN', 'NC', 'NE', 'NT', 'RI', 'TX', 'SK', 'NY', 'PR', 'NH', 'VT', 'CO', 'MN', 'AZ', 'ID', 'YT', 'MB', 'NM', 'TN', 'DE', 'BC', 'OR', 'AR', 'AB', 'ON', 'OH'), nullable=True, comment='Two letter ISO-3166 political subdivision code.'),
    sa.Column('owner_city', sa.Text(), nullable=True, comment='City of owner.'),
    sa.Column('owner_country', sa.Enum('CAN', 'USA'), nullable=True, comment='Three letter ISO-3166 country code.'),
    sa.Column('owner_street_address', sa.Text(), nullable=True, comment='Steet address of owner.'),
    sa.Column('owner_zip_code', sa.Text(), nullable=True, comment='Zip code of owner.'),
    sa.Column('fraction_owned', sa.Float(), nullable=True, comment='Proportion of generator ownership attributable to this utility.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_core_eia860__scd_ownership_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['owner_utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk_core_eia860__scd_ownership_owner_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk_core_eia860__scd_ownership_plant_id_eia_core_eia860__scd_generators')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', 'owner_utility_id_eia', name=op.f('pk_core_eia860__scd_ownership'))
    )
    op.create_table('out_eia860__yearly_ownership',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('owner_utility_id_eia', sa.Integer(), nullable=False, comment='The EIA utility Identification number for the owner company that is responsible for the day-to-day operations of the generator, not the operator utility.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('owner_utility_name_eia', sa.Text(), nullable=True, comment='The name of the EIA owner utility.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('owner_state', sa.Enum('SD', 'KS', 'ND', 'AK', 'CT', 'AS', 'MA', 'MD', 'PA', 'FL', 'QC', 'IA', 'MP', 'HI', 'MT', 'IL', 'WI', 'LA', 'NU', 'NB', 'MI', 'NS', 'PE', 'CA', 'OK', 'NJ', 'ME', 'UT', 'GU', 'GA', 'NV', 'WV', 'MS', 'NL', 'WA', 'MO', 'KY', 'AL', 'SC', 'VI', 'WY', 'DC', 'VA', 'IN', 'NC', 'NE', 'NT', 'RI', 'TX', 'SK', 'NY', 'PR', 'NH', 'VT', 'CO', 'MN', 'AZ', 'ID', 'YT', 'MB', 'NM', 'TN', 'DE', 'BC', 'OR', 'AR', 'AB', 'ON', 'OH'), nullable=True, comment='Two letter ISO-3166 political subdivision code.'),
    sa.Column('owner_city', sa.Text(), nullable=True, comment='City of owner.'),
    sa.Column('owner_country', sa.Enum('CAN', 'USA'), nullable=True, comment='Three letter ISO-3166 country code.'),
    sa.Column('owner_street_address', sa.Text(), nullable=True, comment='Steet address of owner.'),
    sa.Column('owner_zip_code', sa.Text(), nullable=True, comment='Zip code of owner.'),
    sa.Column('fraction_owned', sa.Float(), nullable=True, comment='Proportion of generator ownership attributable to this utility.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia860__yearly_ownership_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['owner_utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk_out_eia860__yearly_ownership_owner_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk_out_eia860__yearly_ownership_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia860__yearly_ownership_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia860__yearly_ownership_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', 'owner_utility_id_eia', name=op.f('pk_out_eia860__yearly_ownership'))
    )
    op.create_table('out_eia923__yearly_boiler_fuel',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('boiler_id', sa.Text(), nullable=False, comment='Alphanumeric boiler ID.'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('energy_source_code', sa.Text(), nullable=False, comment='A 2-3 letter code indicating the energy source (e.g. fuel type) associated with the record.'),
    sa.Column('prime_mover_code', sa.Text(), nullable=False, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('fuel_consumed_units', sa.Float(), nullable=True, comment='Consumption of the fuel type in physical unit. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_mmbtu_per_unit', sa.Float(), nullable=True, comment='Heat content of the fuel in millions of Btus per physical unit.'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('sulfur_content_pct', sa.Float(), nullable=True, comment='Sulfur content percentage by weight to the nearest 0.01 percent.'),
    sa.Column('ash_content_pct', sa.Float(), nullable=True, comment='Ash content percentage by weight to the nearest 0.1 percent.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia923__yearly_boiler_fuel_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_code'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia923__yearly_boiler_fuel_energy_source_code_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'boiler_id', 'report_date'], ['core_eia860__scd_boilers.plant_id_eia', 'core_eia860__scd_boilers.boiler_id', 'core_eia860__scd_boilers.report_date'], name=op.f('fk_out_eia923__yearly_boiler_fuel_plant_id_eia_core_eia860__scd_boilers')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia923__yearly_boiler_fuel_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_out_eia923__yearly_boiler_fuel_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk_out_eia923__yearly_boiler_fuel_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia923__yearly_boiler_fuel_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'boiler_id', 'energy_source_code', 'prime_mover_code', 'report_date', name=op.f('pk_out_eia923__yearly_boiler_fuel'))
    )
    op.create_table('out_eia923__yearly_generation',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia923__yearly_generation_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk_out_eia923__yearly_generation_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia923__yearly_generation_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk_out_eia923__yearly_generation_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia923__yearly_generation_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'generator_id', 'report_date', name=op.f('pk_out_eia923__yearly_generation'))
    )
    op.create_table('out_eia923__yearly_generation_fuel_by_generator',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('fuel_consumed_for_electricity_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel to produce electricity, in physical unit, year to date.'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk_out_eia923__yearly_generation_fuel_by_generator_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia923__yearly_generation_fuel_by_generator_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk_out_eia923__yearly_generation_fuel_by_generator_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia923__yearly_generation_fuel_by_generator_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk_out_eia923__yearly_generation_fuel_by_generator'))
    )
    op.create_table('out_eia923__yearly_generation_fuel_by_generator_energy_source',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('prime_mover_code', sa.Text(), nullable=False, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('energy_source_code', sa.Text(), nullable=False, comment='A 2-3 letter code indicating the energy source (e.g. fuel type) associated with the record.'),
    sa.Column('energy_source_code_num', sa.Enum('energy_source_code_1', 'energy_source_code_2', 'energy_source_code_3', 'energy_source_code_4', 'energy_source_code_5', 'energy_source_code_6', 'energy_source_code_7', 'energy_source_code_8'), nullable=True, comment='Name of the energy_source_code_N column that this energy source code was reported in for the generator referenced in the same record.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_consumed_for_electricity_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel to produce electricity, in physical unit, year to date.'),
    sa.ForeignKeyConstraint(['energy_source_code'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia923__yearly_generation_fuel_by_generator_energy_source_energy_source_code_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk_out_eia923__yearly_generation_fuel_by_generator_energy_source_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_out_eia923__yearly_generation_fuel_by_generator_energy_source_prime_mover_code_core_eia__codes_prime_movers')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', 'prime_mover_code', 'energy_source_code', name=op.f('pk_out_eia923__yearly_generation_fuel_by_generator_energy_source'))
    )
    op.create_table('out_eia923__yearly_generation_fuel_by_generator_energy_source_owner',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('prime_mover_code', sa.Text(), nullable=False, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('energy_source_code', sa.Text(), nullable=False, comment='A 2-3 letter code indicating the energy source (e.g. fuel type) associated with the record.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.Column('ownership_record_type', sa.Enum('owned', 'total'), nullable=False, comment='Whether each generator record is for one owner or represents a total of all ownerships.'),
    sa.Column('fraction_owned', sa.Float(), nullable=True, comment='Proportion of generator ownership attributable to this utility.'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('energy_source_code_num', sa.Enum('energy_source_code_1', 'energy_source_code_2', 'energy_source_code_3', 'energy_source_code_4', 'energy_source_code_5', 'energy_source_code_6', 'energy_source_code_7', 'energy_source_code_8'), nullable=True, comment='Name of the energy_source_code_N column that this energy source code was reported in for the generator referenced in the same record.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('fuel_consumed_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel in physical unit, year to date. Note: this is the total quantity consumed for both electricity and, in the case of combined heat and power plants, process steam production.'),
    sa.Column('fuel_consumed_for_electricity_mmbtu', sa.Float(), nullable=True, comment='Total consumption of fuel to produce electricity, in physical unit, year to date.'),
    sa.ForeignKeyConstraint(['energy_source_code'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia923__yearly_generation_fuel_by_generator_energy_source_owner_energy_source_code_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk_out_eia923__yearly_generation_fuel_by_generator_energy_source_owner_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_out_eia923__yearly_generation_fuel_by_generator_energy_source_owner_prime_mover_code_core_eia__codes_prime_movers')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', 'prime_mover_code', 'energy_source_code', 'utility_id_eia', 'ownership_record_type', name=op.f('pk_out_eia923__yearly_generation_fuel_by_generator_energy_source_owner'))
    )
    op.create_table('out_eia__yearly_boilers',
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('boiler_id', sa.Text(), nullable=False, comment='Alphanumeric boiler ID.'),
    sa.Column('air_flow_100pct_load_cubic_feet_per_minute', sa.Float(), nullable=True, comment='Total air flow including excess air at 100 percent load, reported at standard temperature and pressure (i.e. 68 F and one atmosphere pressure).'),
    sa.Column('boiler_fuel_code_1', sa.Text(), nullable=True, comment='The code representing the most predominant type of energy that fuels the boiler.'),
    sa.Column('boiler_fuel_code_2', sa.Text(), nullable=True, comment='The code representing the second most predominant type of energy that fuels the boiler.'),
    sa.Column('boiler_fuel_code_3', sa.Text(), nullable=True, comment='The code representing the third most predominant type of energy that fuels the boiler.'),
    sa.Column('boiler_fuel_code_4', sa.Text(), nullable=True, comment='The code representing the fourth most predominant type of energy that fuels the boiler.'),
    sa.Column('boiler_manufacturer', sa.Text(), nullable=True, comment='Name of boiler manufacturer.'),
    sa.Column('boiler_manufacturer_code', sa.Text(), nullable=True, comment='EIA short code for boiler manufacturer.'),
    sa.Column('boiler_operating_date', sa.Date(), nullable=True, comment='Date the boiler began or is planned to begin commercial operation.'),
    sa.Column('boiler_retirement_date', sa.Date(), nullable=True, comment='Date of the scheduled or effected retirement of the boiler.'),
    sa.Column('boiler_status', sa.Text(), nullable=True, comment='EIA short code identifying boiler operational status.'),
    sa.Column('boiler_type', sa.Text(), nullable=True, comment='EIA short code indicating the standards under which the boiler is operating as described in the U.S. EPA regulation under 40 CFR.'),
    sa.Column('city', sa.Text(), nullable=True, comment='Name of the city.'),
    sa.Column('compliance_year_mercury', sa.Integer(), nullable=True, comment='Year boiler was or is expected to be in compliance with federal, state and/or local regulations for mercury emissions.'),
    sa.Column('compliance_year_nox', sa.Integer(), nullable=True, comment='Year boiler was or is expected to be in compliance with federal, state and/or local regulations for nitrogen oxide emissions.'),
    sa.Column('compliance_year_particulate', sa.Integer(), nullable=True, comment='Year boiler was or is expected to be in compliance with federal, state and/or local regulations for particulate matter emissions.'),
    sa.Column('compliance_year_so2', sa.Integer(), nullable=True, comment='Year boiler was or is expected to be in compliance with federal, state and/or local regulations for sulfur dioxide emissions.'),
    sa.Column('county', sa.Text(), nullable=True, comment='County name.'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.Column('efficiency_100pct_load', sa.Float(), nullable=True, comment='Boiler efficiency percentage when burning at 100 percent load to the nearest 0.1 percent.'),
    sa.Column('efficiency_50pct_load', sa.Float(), nullable=True, comment='Boiler efficiency percentage when burning at 50 percent load to the nearest 0.1 percent.'),
    sa.Column('firing_rate_using_coal_tons_per_hour', sa.Float(), nullable=True, comment='Design firing rate at maximum continuous steam flow for coal to the nearest 0.1 ton per hour.'),
    sa.Column('firing_rate_using_gas_mcf_per_hour', sa.Float(), nullable=True, comment='Design firing rate at maximum continuous steam flow for gas to the nearest 0.1 cubic feet per hour.'),
    sa.Column('firing_rate_using_oil_bbls_per_hour', sa.Float(), nullable=True, comment='Design firing rate at maximum continuous steam flow for pet coke to the nearest 0.1 barrels per hour.'),
    sa.Column('firing_rate_using_other_fuels', sa.Float(), nullable=True, comment='Design firing rate at maximum continuous steam flow for energy sources other than coal, petroleum, or natural gas.'),
    sa.Column('firing_type_1', sa.Text(), nullable=True, comment='EIA short code indicating the type of firing used by this boiler.'),
    sa.Column('firing_type_2', sa.Text(), nullable=True, comment='EIA short code indicating the type of firing used by this boiler.'),
    sa.Column('firing_type_3', sa.Text(), nullable=True, comment='EIA short code indicating the type of firing used by this boiler.'),
    sa.Column('fly_ash_reinjection', sa.Boolean(), nullable=True, comment='Indicates whether the boiler is capable of re-injecting fly ash.'),
    sa.Column('hrsg', sa.Boolean(), nullable=True, comment='indicates if the boiler is a heat recovery steam generator (HRSG).'),
    sa.Column('latitude', sa.Float(), nullable=True, comment="Latitude of the plant's location, in degrees."),
    sa.Column('longitude', sa.Float(), nullable=True, comment="Longitude of the plant's location, in degrees."),
    sa.Column('max_steam_flow_1000_lbs_per_hour', sa.Float(), nullable=True, comment='Maximum continuous steam flow at 100 percent load.'),
    sa.Column('mercury_control_existing_strategy_1', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent mercury regulation.'),
    sa.Column('mercury_control_existing_strategy_2', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent mercury regulation.'),
    sa.Column('mercury_control_existing_strategy_3', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent mercury regulation.'),
    sa.Column('mercury_control_existing_strategy_4', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent mercury regulation.'),
    sa.Column('mercury_control_existing_strategy_5', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent mercury regulation.'),
    sa.Column('mercury_control_existing_strategy_6', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent mercury regulation.'),
    sa.Column('mercury_control_proposed_strategy_1', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent mercury regulation.'),
    sa.Column('mercury_control_proposed_strategy_2', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent mercury regulation.'),
    sa.Column('mercury_control_proposed_strategy_3', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent mercury regulation.'),
    sa.Column('new_source_review', sa.Boolean(), nullable=True, comment='Indicates whether the boiler is subject to New Source Review requirements.'),
    sa.Column('new_source_review_date', sa.Date(), nullable=True, comment='Month of issued New Source Review permit.'),
    sa.Column('new_source_review_permit', sa.Text(), nullable=True, comment='New Source Review permit number.'),
    sa.Column('nox_control_existing_caaa_compliance_strategy_1', sa.Text(), nullable=True, comment='Existing strategies to meet the nitrogen oxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('nox_control_existing_caaa_compliance_strategy_2', sa.Text(), nullable=True, comment='Existing strategies to meet the nitrogen oxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('nox_control_existing_caaa_compliance_strategy_3', sa.Text(), nullable=True, comment='Existing strategies to meet the nitrogen oxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('nox_control_existing_strategy_1', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent nitrogen oxide regulation.'),
    sa.Column('nox_control_existing_strategy_2', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent nitrogen oxide regulation.'),
    sa.Column('nox_control_existing_strategy_3', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent nitrogen oxide regulation.'),
    sa.Column('nox_control_manufacturer', sa.Text(), nullable=True, comment='Name of nitrogen oxide control manufacturer.'),
    sa.Column('nox_control_manufacturer_code', sa.Text(), nullable=True, comment='Code indicating the nitrogen oxide control burner manufacturer.'),
    sa.Column('nox_control_out_of_compliance_strategy_1', sa.Text(), nullable=True, comment='If boiler is not in compliance with nitrogen oxide regulations, strategy for compliance.'),
    sa.Column('nox_control_out_of_compliance_strategy_2', sa.Text(), nullable=True, comment='If boiler is not in compliance with nitrogen oxide regulations, strategy for compliance.'),
    sa.Column('nox_control_out_of_compliance_strategy_3', sa.Text(), nullable=True, comment='If boiler is not in compliance with nitrogen oxide regulations, strategy for compliance.'),
    sa.Column('nox_control_planned_caaa_compliance_strategy_1', sa.Text(), nullable=True, comment='Planned strategies to meet the nitrogen oxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('nox_control_planned_caaa_compliance_strategy_2', sa.Text(), nullable=True, comment='Planned strategies to meet the nitrogen oxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('nox_control_planned_caaa_compliance_strategy_3', sa.Text(), nullable=True, comment='Planned strategies to meet the nitrogen oxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('nox_control_proposed_strategy_1', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent nitrogen oxide regulation.'),
    sa.Column('nox_control_proposed_strategy_2', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent nitrogen oxide regulation.'),
    sa.Column('nox_control_proposed_strategy_3', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent nitrogen oxide regulation.'),
    sa.Column('nox_control_status_code', sa.Text(), nullable=True, comment='Nitrogen oxide control status code.'),
    sa.Column('particulate_control_out_of_compliance_strategy_1', sa.Text(), nullable=True, comment='If boiler is not in compliance with particulate matter regulations, strategy for compliance.'),
    sa.Column('particulate_control_out_of_compliance_strategy_2', sa.Text(), nullable=True, comment='If boiler is not in compliance with particulate matter regulations, strategy for compliance.'),
    sa.Column('particulate_control_out_of_compliance_strategy_3', sa.Text(), nullable=True, comment='If boiler is not in compliance with particulate matter regulations, strategy for compliance.'),
    sa.Column('regulation_mercury', sa.Text(), nullable=True, comment='Most stringent type of statute or regulation code under which the boiler is operating for mercury control standards.'),
    sa.Column('regulation_nox', sa.Text(), nullable=True, comment='EIA short code for most stringent type of statute or regulation code under which the boiler is operating for nitrogen oxide control standards.'),
    sa.Column('regulation_particulate', sa.Text(), nullable=True, comment='EIA short code for most stringent type of statute or regulation code under which the boiler is operating for particulate matter control standards.'),
    sa.Column('regulation_so2', sa.Text(), nullable=True, comment='EIA short code for most stringent type of statute or regulation code under which the boiler is operating for sulfur dioxide control standards.'),
    sa.Column('so2_control_existing_caaa_compliance_strategy_1', sa.Text(), nullable=True, comment='Existing strategies to meet the sulfur dioxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('so2_control_existing_caaa_compliance_strategy_2', sa.Text(), nullable=True, comment='Existing strategies to meet the sulfur dioxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('so2_control_existing_caaa_compliance_strategy_3', sa.Text(), nullable=True, comment='Existing strategies to meet the sulfur dioxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('so2_control_existing_strategy_1', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent sulfur dioxide regulation.'),
    sa.Column('so2_control_existing_strategy_2', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent sulfur dioxide regulation.'),
    sa.Column('so2_control_existing_strategy_3', sa.Text(), nullable=True, comment='Existing strategy to comply with the most stringent sulfur dioxide regulation.'),
    sa.Column('so2_control_out_of_compliance_strategy_1', sa.Text(), nullable=True, comment='If boiler is not in compliance with sulfur dioxide regulations, strategy for compliance.'),
    sa.Column('so2_control_out_of_compliance_strategy_2', sa.Text(), nullable=True, comment='If boiler is not in compliance with sulfur dioxide regulations, strategy for compliance.'),
    sa.Column('so2_control_out_of_compliance_strategy_3', sa.Text(), nullable=True, comment='If boiler is not in compliance with sulfur dioxide regulations, strategy for compliance.'),
    sa.Column('so2_control_planned_caaa_compliance_strategy_1', sa.Text(), nullable=True, comment='Planned strategies to meet the sulfur dioxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('so2_control_planned_caaa_compliance_strategy_2', sa.Text(), nullable=True, comment='Planned strategies to meet the sulfur dioxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('so2_control_planned_caaa_compliance_strategy_3', sa.Text(), nullable=True, comment='Planned strategies to meet the sulfur dioxide requirements of Title IV of the Clean Air Act Amendment of 1990.'),
    sa.Column('so2_control_proposed_strategy_1', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent sulfur dioxide regulation.'),
    sa.Column('so2_control_proposed_strategy_2', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent sulfur dioxide regulation.'),
    sa.Column('so2_control_proposed_strategy_3', sa.Text(), nullable=True, comment='Proposed strategy to comply with the most stringent sulfur dioxide regulation.'),
    sa.Column('standard_nox_rate', sa.Float(), nullable=True, comment='Numeric value for the unit of measurement specified for nitrogen oxide.'),
    sa.Column('standard_particulate_rate', sa.Float(), nullable=True, comment='Numeric value for the unit of measurement specified for particulate matter.'),
    sa.Column('standard_so2_percent_scrubbed', sa.Float(), nullable=True, comment='The percent of sulfur dioxide to be scrubbed specified by the most stringent sulfur dioxide regulation.'),
    sa.Column('standard_so2_rate', sa.Float(), nullable=True, comment='Numeric value for the unit of measurement specified for sulfur dioxide.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('street_address', sa.Text(), nullable=True, comment='Physical street address.'),
    sa.Column('timezone', sa.Enum('Africa/Abidjan', 'Africa/Accra', 'Africa/Addis_Ababa', 'Africa/Algiers', 'Africa/Asmara', 'Africa/Asmera', 'Africa/Bamako', 'Africa/Bangui', 'Africa/Banjul', 'Africa/Bissau', 'Africa/Blantyre', 'Africa/Brazzaville', 'Africa/Bujumbura', 'Africa/Cairo', 'Africa/Casablanca', 'Africa/Ceuta', 'Africa/Conakry', 'Africa/Dakar', 'Africa/Dar_es_Salaam', 'Africa/Djibouti', 'Africa/Douala', 'Africa/El_Aaiun', 'Africa/Freetown', 'Africa/Gaborone', 'Africa/Harare', 'Africa/Johannesburg', 'Africa/Juba', 'Africa/Kampala', 'Africa/Khartoum', 'Africa/Kigali', 'Africa/Kinshasa', 'Africa/Lagos', 'Africa/Libreville', 'Africa/Lome', 'Africa/Luanda', 'Africa/Lubumbashi', 'Africa/Lusaka', 'Africa/Malabo', 'Africa/Maputo', 'Africa/Maseru', 'Africa/Mbabane', 'Africa/Mogadishu', 'Africa/Monrovia', 'Africa/Nairobi', 'Africa/Ndjamena', 'Africa/Niamey', 'Africa/Nouakchott', 'Africa/Ouagadougou', 'Africa/Porto-Novo', 'Africa/Sao_Tome', 'Africa/Timbuktu', 'Africa/Tripoli', 'Africa/Tunis', 'Africa/Windhoek', 'America/Adak', 'America/Anchorage', 'America/Anguilla', 'America/Antigua', 'America/Araguaina', 'America/Argentina/Buenos_Aires', 'America/Argentina/Catamarca', 'America/Argentina/ComodRivadavia', 'America/Argentina/Cordoba', 'America/Argentina/Jujuy', 'America/Argentina/La_Rioja', 'America/Argentina/Mendoza', 'America/Argentina/Rio_Gallegos', 'America/Argentina/Salta', 'America/Argentina/San_Juan', 'America/Argentina/San_Luis', 'America/Argentina/Tucuman', 'America/Argentina/Ushuaia', 'America/Aruba', 'America/Asuncion', 'America/Atikokan', 'America/Atka', 'America/Bahia', 'America/Bahia_Banderas', 'America/Barbados', 'America/Belem', 'America/Belize', 'America/Blanc-Sablon', 'America/Boa_Vista', 'America/Bogota', 'America/Boise', 'America/Buenos_Aires', 'America/Cambridge_Bay', 'America/Campo_Grande', 'America/Cancun', 'America/Caracas', 'America/Catamarca', 'America/Cayenne', 'America/Cayman', 'America/Chicago', 'America/Chihuahua', 'America/Ciudad_Juarez', 'America/Coral_Harbour', 'America/Cordoba', 'America/Costa_Rica', 'America/Creston', 'America/Cuiaba', 'America/Curacao', 'America/Danmarkshavn', 'America/Dawson', 'America/Dawson_Creek', 'America/Denver', 'America/Detroit', 'America/Dominica', 'America/Edmonton', 'America/Eirunepe', 'America/El_Salvador', 'America/Ensenada', 'America/Fort_Nelson', 'America/Fort_Wayne', 'America/Fortaleza', 'America/Glace_Bay', 'America/Godthab', 'America/Goose_Bay', 'America/Grand_Turk', 'America/Grenada', 'America/Guadeloupe', 'America/Guatemala', 'America/Guayaquil', 'America/Guyana', 'America/Halifax', 'America/Havana', 'America/Hermosillo', 'America/Indiana/Indianapolis', 'America/Indiana/Knox', 'America/Indiana/Marengo', 'America/Indiana/Petersburg', 'America/Indiana/Tell_City', 'America/Indiana/Vevay', 'America/Indiana/Vincennes', 'America/Indiana/Winamac', 'America/Indianapolis', 'America/Inuvik', 'America/Iqaluit', 'America/Jamaica', 'America/Jujuy', 'America/Juneau', 'America/Kentucky/Louisville', 'America/Kentucky/Monticello', 'America/Knox_IN', 'America/Kralendijk', 'America/La_Paz', 'America/Lima', 'America/Los_Angeles', 'America/Louisville', 'America/Lower_Princes', 'America/Maceio', 'America/Managua', 'America/Manaus', 'America/Marigot', 'America/Martinique', 'America/Matamoros', 'America/Mazatlan', 'America/Mendoza', 'America/Menominee', 'America/Merida', 'America/Metlakatla', 'America/Mexico_City', 'America/Miquelon', 'America/Moncton', 'America/Monterrey', 'America/Montevideo', 'America/Montreal', 'America/Montserrat', 'America/Nassau', 'America/New_York', 'America/Nipigon', 'America/Nome', 'America/Noronha', 'America/North_Dakota/Beulah', 'America/North_Dakota/Center', 'America/North_Dakota/New_Salem', 'America/Nuuk', 'America/Ojinaga', 'America/Panama', 'America/Pangnirtung', 'America/Paramaribo', 'America/Phoenix', 'America/Port-au-Prince', 'America/Port_of_Spain', 'America/Porto_Acre', 'America/Porto_Velho', 'America/Puerto_Rico', 'America/Punta_Arenas', 'America/Rainy_River', 'America/Rankin_Inlet', 'America/Recife', 'America/Regina', 'America/Resolute', 'America/Rio_Branco', 'America/Rosario', 'America/Santa_Isabel', 'America/Santarem', 'America/Santiago', 'America/Santo_Domingo', 'America/Sao_Paulo', 'America/Scoresbysund', 'America/Shiprock', 'America/Sitka', 'America/St_Barthelemy', 'America/St_Johns', 'America/St_Kitts', 'America/St_Lucia', 'America/St_Thomas', 'America/St_Vincent', 'America/Swift_Current', 'America/Tegucigalpa', 'America/Thule', 'America/Thunder_Bay', 'America/Tijuana', 'America/Toronto', 'America/Tortola', 'America/Vancouver', 'America/Virgin', 'America/Whitehorse', 'America/Winnipeg', 'America/Yakutat', 'America/Yellowknife', 'Antarctica/Casey', 'Antarctica/Davis', 'Antarctica/DumontDUrville', 'Antarctica/Macquarie', 'Antarctica/Mawson', 'Antarctica/McMurdo', 'Antarctica/Palmer', 'Antarctica/Rothera', 'Antarctica/South_Pole', 'Antarctica/Syowa', 'Antarctica/Troll', 'Antarctica/Vostok', 'Arctic/Longyearbyen', 'Asia/Aden', 'Asia/Almaty', 'Asia/Amman', 'Asia/Anadyr', 'Asia/Aqtau', 'Asia/Aqtobe', 'Asia/Ashgabat', 'Asia/Ashkhabad', 'Asia/Atyrau', 'Asia/Baghdad', 'Asia/Bahrain', 'Asia/Baku', 'Asia/Bangkok', 'Asia/Barnaul', 'Asia/Beirut', 'Asia/Bishkek', 'Asia/Brunei', 'Asia/Calcutta', 'Asia/Chita', 'Asia/Choibalsan', 'Asia/Chongqing', 'Asia/Chungking', 'Asia/Colombo', 'Asia/Dacca', 'Asia/Damascus', 'Asia/Dhaka', 'Asia/Dili', 'Asia/Dubai', 'Asia/Dushanbe', 'Asia/Famagusta', 'Asia/Gaza', 'Asia/Harbin', 'Asia/Hebron', 'Asia/Ho_Chi_Minh', 'Asia/Hong_Kong', 'Asia/Hovd', 'Asia/Irkutsk', 'Asia/Istanbul', 'Asia/Jakarta', 'Asia/Jayapura', 'Asia/Jerusalem', 'Asia/Kabul', 'Asia/Kamchatka', 'Asia/Karachi', 'Asia/Kashgar', 'Asia/Kathmandu', 'Asia/Katmandu', 'Asia/Khandyga', 'Asia/Kolkata', 'Asia/Krasnoyarsk', 'Asia/Kuala_Lumpur', 'Asia/Kuching', 'Asia/Kuwait', 'Asia/Macao', 'Asia/Macau', 'Asia/Magadan', 'Asia/Makassar', 'Asia/Manila', 'Asia/Muscat', 'Asia/Nicosia', 'Asia/Novokuznetsk', 'Asia/Novosibirsk', 'Asia/Omsk', 'Asia/Oral', 'Asia/Phnom_Penh', 'Asia/Pontianak', 'Asia/Pyongyang', 'Asia/Qatar', 'Asia/Qostanay', 'Asia/Qyzylorda', 'Asia/Rangoon', 'Asia/Riyadh', 'Asia/Saigon', 'Asia/Sakhalin', 'Asia/Samarkand', 'Asia/Seoul', 'Asia/Shanghai', 'Asia/Singapore', 'Asia/Srednekolymsk', 'Asia/Taipei', 'Asia/Tashkent', 'Asia/Tbilisi', 'Asia/Tehran', 'Asia/Tel_Aviv', 'Asia/Thimbu', 'Asia/Thimphu', 'Asia/Tokyo', 'Asia/Tomsk', 'Asia/Ujung_Pandang', 'Asia/Ulaanbaatar', 'Asia/Ulan_Bator', 'Asia/Urumqi', 'Asia/Ust-Nera', 'Asia/Vientiane', 'Asia/Vladivostok', 'Asia/Yakutsk', 'Asia/Yangon', 'Asia/Yekaterinburg', 'Asia/Yerevan', 'Atlantic/Azores', 'Atlantic/Bermuda', 'Atlantic/Canary', 'Atlantic/Cape_Verde', 'Atlantic/Faeroe', 'Atlantic/Faroe', 'Atlantic/Jan_Mayen', 'Atlantic/Madeira', 'Atlantic/Reykjavik', 'Atlantic/South_Georgia', 'Atlantic/St_Helena', 'Atlantic/Stanley', 'Australia/ACT', 'Australia/Adelaide', 'Australia/Brisbane', 'Australia/Broken_Hill', 'Australia/Canberra', 'Australia/Currie', 'Australia/Darwin', 'Australia/Eucla', 'Australia/Hobart', 'Australia/LHI', 'Australia/Lindeman', 'Australia/Lord_Howe', 'Australia/Melbourne', 'Australia/NSW', 'Australia/North', 'Australia/Perth', 'Australia/Queensland', 'Australia/South', 'Australia/Sydney', 'Australia/Tasmania', 'Australia/Victoria', 'Australia/West', 'Australia/Yancowinna', 'Brazil/Acre', 'Brazil/DeNoronha', 'Brazil/East', 'Brazil/West', 'CET', 'CST6CDT', 'Canada/Atlantic', 'Canada/Central', 'Canada/Eastern', 'Canada/Mountain', 'Canada/Newfoundland', 'Canada/Pacific', 'Canada/Saskatchewan', 'Canada/Yukon', 'Chile/Continental', 'Chile/EasterIsland', 'Cuba', 'EET', 'EST', 'EST5EDT', 'Egypt', 'Eire', 'Etc/GMT', 'Etc/GMT+0', 'Etc/GMT+1', 'Etc/GMT+10', 'Etc/GMT+11', 'Etc/GMT+12', 'Etc/GMT+2', 'Etc/GMT+3', 'Etc/GMT+4', 'Etc/GMT+5', 'Etc/GMT+6', 'Etc/GMT+7', 'Etc/GMT+8', 'Etc/GMT+9', 'Etc/GMT-0', 'Etc/GMT-1', 'Etc/GMT-10', 'Etc/GMT-11', 'Etc/GMT-12', 'Etc/GMT-13', 'Etc/GMT-14', 'Etc/GMT-2', 'Etc/GMT-3', 'Etc/GMT-4', 'Etc/GMT-5', 'Etc/GMT-6', 'Etc/GMT-7', 'Etc/GMT-8', 'Etc/GMT-9', 'Etc/GMT0', 'Etc/Greenwich', 'Etc/UCT', 'Etc/UTC', 'Etc/Universal', 'Etc/Zulu', 'Europe/Amsterdam', 'Europe/Andorra', 'Europe/Astrakhan', 'Europe/Athens', 'Europe/Belfast', 'Europe/Belgrade', 'Europe/Berlin', 'Europe/Bratislava', 'Europe/Brussels', 'Europe/Bucharest', 'Europe/Budapest', 'Europe/Busingen', 'Europe/Chisinau', 'Europe/Copenhagen', 'Europe/Dublin', 'Europe/Gibraltar', 'Europe/Guernsey', 'Europe/Helsinki', 'Europe/Isle_of_Man', 'Europe/Istanbul', 'Europe/Jersey', 'Europe/Kaliningrad', 'Europe/Kiev', 'Europe/Kirov', 'Europe/Kyiv', 'Europe/Lisbon', 'Europe/Ljubljana', 'Europe/London', 'Europe/Luxembourg', 'Europe/Madrid', 'Europe/Malta', 'Europe/Mariehamn', 'Europe/Minsk', 'Europe/Monaco', 'Europe/Moscow', 'Europe/Nicosia', 'Europe/Oslo', 'Europe/Paris', 'Europe/Podgorica', 'Europe/Prague', 'Europe/Riga', 'Europe/Rome', 'Europe/Samara', 'Europe/San_Marino', 'Europe/Sarajevo', 'Europe/Saratov', 'Europe/Simferopol', 'Europe/Skopje', 'Europe/Sofia', 'Europe/Stockholm', 'Europe/Tallinn', 'Europe/Tirane', 'Europe/Tiraspol', 'Europe/Ulyanovsk', 'Europe/Uzhgorod', 'Europe/Vaduz', 'Europe/Vatican', 'Europe/Vienna', 'Europe/Vilnius', 'Europe/Volgograd', 'Europe/Warsaw', 'Europe/Zagreb', 'Europe/Zaporozhye', 'Europe/Zurich', 'GB', 'GB-Eire', 'GMT', 'GMT+0', 'GMT-0', 'GMT0', 'Greenwich', 'HST', 'Hongkong', 'Iceland', 'Indian/Antananarivo', 'Indian/Chagos', 'Indian/Christmas', 'Indian/Cocos', 'Indian/Comoro', 'Indian/Kerguelen', 'Indian/Mahe', 'Indian/Maldives', 'Indian/Mauritius', 'Indian/Mayotte', 'Indian/Reunion', 'Iran', 'Israel', 'Jamaica', 'Japan', 'Kwajalein', 'Libya', 'MET', 'MST', 'MST7MDT', 'Mexico/BajaNorte', 'Mexico/BajaSur', 'Mexico/General', 'NZ', 'NZ-CHAT', 'Navajo', 'PRC', 'PST8PDT', 'Pacific/Apia', 'Pacific/Auckland', 'Pacific/Bougainville', 'Pacific/Chatham', 'Pacific/Chuuk', 'Pacific/Easter', 'Pacific/Efate', 'Pacific/Enderbury', 'Pacific/Fakaofo', 'Pacific/Fiji', 'Pacific/Funafuti', 'Pacific/Galapagos', 'Pacific/Gambier', 'Pacific/Guadalcanal', 'Pacific/Guam', 'Pacific/Honolulu', 'Pacific/Johnston', 'Pacific/Kanton', 'Pacific/Kiritimati', 'Pacific/Kosrae', 'Pacific/Kwajalein', 'Pacific/Majuro', 'Pacific/Marquesas', 'Pacific/Midway', 'Pacific/Nauru', 'Pacific/Niue', 'Pacific/Norfolk', 'Pacific/Noumea', 'Pacific/Pago_Pago', 'Pacific/Palau', 'Pacific/Pitcairn', 'Pacific/Pohnpei', 'Pacific/Ponape', 'Pacific/Port_Moresby', 'Pacific/Rarotonga', 'Pacific/Saipan', 'Pacific/Samoa', 'Pacific/Tahiti', 'Pacific/Tarawa', 'Pacific/Tongatapu', 'Pacific/Truk', 'Pacific/Wake', 'Pacific/Wallis', 'Pacific/Yap', 'Poland', 'Portugal', 'ROC', 'ROK', 'Singapore', 'Turkey', 'UCT', 'US/Alaska', 'US/Aleutian', 'US/Arizona', 'US/Central', 'US/East-Indiana', 'US/Eastern', 'US/Hawaii', 'US/Indiana-Starke', 'US/Michigan', 'US/Mountain', 'US/Pacific', 'US/Samoa', 'UTC', 'Universal', 'W-SU', 'WET', 'Zulu'), nullable=True, comment='IANA timezone name'),
    sa.Column('turndown_ratio', sa.Float(), nullable=True, comment='The turndown ratio for the boiler.'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('unit_nox', sa.Text(), nullable=True, comment='Numeric value for the unit of measurement specified for nitrogen oxide.'),
    sa.Column('unit_particulate', sa.Text(), nullable=True, comment='Numeric value for the unit of measurement specified for particulate matter.'),
    sa.Column('unit_so2', sa.Text(), nullable=True, comment='Numeric value for the unit of measurement specified for sulfur dioxide.'),
    sa.Column('waste_heat_input_mmbtu_per_hour', sa.Float(), nullable=True, comment='Design waste-heat input rate at maximum continuous steam flow where a waste-heat boiler is a boiler that receives all or a substantial portion of its energy input from the noncumbustible exhaust gases of a separate fuel-burning process (MMBtu per hour).'),
    sa.Column('wet_dry_bottom', sa.Text(), nullable=True, comment='Wet or Dry Bottom where Wet Bottom is defined as slag tanks that are installed at furnace throat to contain and remove molten ash from the furnace, and Dry Bottom is defined as having no slag tanks at furnace throat area, throat area is clear, and bottom ash drops through throat to bottom ash water hoppers.'),
    sa.Column('zip_code', sa.Text(), nullable=True, comment='Five digit US Zip Code.'),
    sa.ForeignKeyConstraint(['boiler_fuel_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_boilers_boiler_fuel_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['boiler_fuel_code_2'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_boilers_boiler_fuel_code_2_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['boiler_fuel_code_3'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_boilers_boiler_fuel_code_3_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['boiler_fuel_code_4'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_boilers_boiler_fuel_code_4_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['boiler_manufacturer_code'], ['core_eia__codes_environmental_equipment_manufacturers.code'], name=op.f('fk_out_eia__yearly_boilers_boiler_manufacturer_code_core_eia__codes_environmental_equipment_manufacturers')),
    sa.ForeignKeyConstraint(['boiler_status'], ['core_eia__codes_boiler_status.code'], name=op.f('fk_out_eia__yearly_boilers_boiler_status_core_eia__codes_boiler_status')),
    sa.ForeignKeyConstraint(['boiler_type'], ['core_eia__codes_boiler_types.code'], name=op.f('fk_out_eia__yearly_boilers_boiler_type_core_eia__codes_boiler_types')),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia__yearly_boilers_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['firing_type_1'], ['core_eia__codes_firing_types.code'], name=op.f('fk_out_eia__yearly_boilers_firing_type_1_core_eia__codes_firing_types')),
    sa.ForeignKeyConstraint(['firing_type_2'], ['core_eia__codes_firing_types.code'], name=op.f('fk_out_eia__yearly_boilers_firing_type_2_core_eia__codes_firing_types')),
    sa.ForeignKeyConstraint(['firing_type_3'], ['core_eia__codes_firing_types.code'], name=op.f('fk_out_eia__yearly_boilers_firing_type_3_core_eia__codes_firing_types')),
    sa.ForeignKeyConstraint(['mercury_control_existing_strategy_1'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_mercury_control_existing_strategy_1_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['mercury_control_existing_strategy_2'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_mercury_control_existing_strategy_2_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['mercury_control_existing_strategy_3'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_mercury_control_existing_strategy_3_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['mercury_control_existing_strategy_4'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_mercury_control_existing_strategy_4_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['mercury_control_existing_strategy_5'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_mercury_control_existing_strategy_5_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['mercury_control_existing_strategy_6'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_mercury_control_existing_strategy_6_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['mercury_control_proposed_strategy_1'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_mercury_control_proposed_strategy_1_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['mercury_control_proposed_strategy_2'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_mercury_control_proposed_strategy_2_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['mercury_control_proposed_strategy_3'], ['core_eia__codes_mercury_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_mercury_control_proposed_strategy_3_core_eia__codes_mercury_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_existing_caaa_compliance_strategy_1'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_nox_control_existing_caaa_compliance_strategy_1_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_existing_caaa_compliance_strategy_2'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_nox_control_existing_caaa_compliance_strategy_2_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_existing_caaa_compliance_strategy_3'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_nox_control_existing_caaa_compliance_strategy_3_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_manufacturer_code'], ['core_eia__codes_environmental_equipment_manufacturers.code'], name=op.f('fk_out_eia__yearly_boilers_nox_control_manufacturer_code_core_eia__codes_environmental_equipment_manufacturers')),
    sa.ForeignKeyConstraint(['nox_control_out_of_compliance_strategy_1'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_nox_control_out_of_compliance_strategy_1_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_out_of_compliance_strategy_2'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_nox_control_out_of_compliance_strategy_2_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_out_of_compliance_strategy_3'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_nox_control_out_of_compliance_strategy_3_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_planned_caaa_compliance_strategy_1'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_nox_control_planned_caaa_compliance_strategy_1_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_planned_caaa_compliance_strategy_2'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_nox_control_planned_caaa_compliance_strategy_2_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_planned_caaa_compliance_strategy_3'], ['core_eia__codes_nox_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_nox_control_planned_caaa_compliance_strategy_3_core_eia__codes_nox_compliance_strategies')),
    sa.ForeignKeyConstraint(['nox_control_status_code'], ['core_eia__codes_nox_control_status.code'], name=op.f('fk_out_eia__yearly_boilers_nox_control_status_code_core_eia__codes_nox_control_status')),
    sa.ForeignKeyConstraint(['particulate_control_out_of_compliance_strategy_1'], ['core_eia__codes_particulate_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_particulate_control_out_of_compliance_strategy_1_core_eia__codes_particulate_compliance_strategies')),
    sa.ForeignKeyConstraint(['particulate_control_out_of_compliance_strategy_2'], ['core_eia__codes_particulate_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_particulate_control_out_of_compliance_strategy_2_core_eia__codes_particulate_compliance_strategies')),
    sa.ForeignKeyConstraint(['particulate_control_out_of_compliance_strategy_3'], ['core_eia__codes_particulate_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_particulate_control_out_of_compliance_strategy_3_core_eia__codes_particulate_compliance_strategies')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'boiler_id', 'report_date'], ['core_eia860__scd_boilers.plant_id_eia', 'core_eia860__scd_boilers.boiler_id', 'core_eia860__scd_boilers.report_date'], name=op.f('fk_out_eia__yearly_boilers_plant_id_eia_core_eia860__scd_boilers')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia__yearly_boilers_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['regulation_mercury'], ['core_eia__codes_regulations.code'], name=op.f('fk_out_eia__yearly_boilers_regulation_mercury_core_eia__codes_regulations')),
    sa.ForeignKeyConstraint(['regulation_nox'], ['core_eia__codes_regulations.code'], name=op.f('fk_out_eia__yearly_boilers_regulation_nox_core_eia__codes_regulations')),
    sa.ForeignKeyConstraint(['regulation_particulate'], ['core_eia__codes_regulations.code'], name=op.f('fk_out_eia__yearly_boilers_regulation_particulate_core_eia__codes_regulations')),
    sa.ForeignKeyConstraint(['regulation_so2'], ['core_eia__codes_regulations.code'], name=op.f('fk_out_eia__yearly_boilers_regulation_so2_core_eia__codes_regulations')),
    sa.ForeignKeyConstraint(['so2_control_existing_caaa_compliance_strategy_1'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_so2_control_existing_caaa_compliance_strategy_1_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['so2_control_existing_caaa_compliance_strategy_2'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_so2_control_existing_caaa_compliance_strategy_2_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['so2_control_existing_caaa_compliance_strategy_3'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_so2_control_existing_caaa_compliance_strategy_3_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['so2_control_out_of_compliance_strategy_1'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_so2_control_out_of_compliance_strategy_1_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['so2_control_out_of_compliance_strategy_2'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_so2_control_out_of_compliance_strategy_2_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['so2_control_out_of_compliance_strategy_3'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_so2_control_out_of_compliance_strategy_3_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['so2_control_planned_caaa_compliance_strategy_1'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_so2_control_planned_caaa_compliance_strategy_1_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['so2_control_planned_caaa_compliance_strategy_2'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_so2_control_planned_caaa_compliance_strategy_2_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['so2_control_planned_caaa_compliance_strategy_3'], ['core_eia__codes_so2_compliance_strategies.code'], name=op.f('fk_out_eia__yearly_boilers_so2_control_planned_caaa_compliance_strategy_3_core_eia__codes_so2_compliance_strategies')),
    sa.ForeignKeyConstraint(['unit_nox'], ['core_eia__codes_nox_units.code'], name=op.f('fk_out_eia__yearly_boilers_unit_nox_core_eia__codes_nox_units')),
    sa.ForeignKeyConstraint(['unit_particulate'], ['core_eia__codes_particulate_units.code'], name=op.f('fk_out_eia__yearly_boilers_unit_particulate_core_eia__codes_particulate_units')),
    sa.ForeignKeyConstraint(['unit_so2'], ['core_eia__codes_so2_units.code'], name=op.f('fk_out_eia__yearly_boilers_unit_so2_core_eia__codes_so2_units')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk_out_eia__yearly_boilers_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia__yearly_boilers_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.ForeignKeyConstraint(['wet_dry_bottom'], ['core_eia__codes_wet_dry_bottom.code'], name=op.f('fk_out_eia__yearly_boilers_wet_dry_bottom_core_eia__codes_wet_dry_bottom')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'boiler_id', 'report_date', name=op.f('pk_out_eia__yearly_boilers'))
    )
    op.create_table('out_eia__yearly_generators',
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=False, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('technology_description', sa.Text(), nullable=True, comment='High level description of the technology used by the generator to produce electricity.'),
    sa.Column('energy_source_code_1', sa.Text(), nullable=True, comment='The code representing the most predominant type of energy that fuels the generator.'),
    sa.Column('prime_mover_code', sa.Text(), nullable=True, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('generator_operating_date', sa.Date(), nullable=True, comment='Date the generator began commercial operation. If harvested values are inconsistent, we default to using the most recently reported date.'),
    sa.Column('generator_retirement_date', sa.Date(), nullable=True, comment='Date of the scheduled or effected retirement of the generator.'),
    sa.Column('operational_status', sa.Text(), nullable=True, comment='The operating status of the asset. For generators this is based on which tab the generator was listed in in EIA 860.'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('planned_generator_retirement_date', sa.Date(), nullable=True, comment='Planned effective date of the scheduled retirement of the generator.'),
    sa.Column('capacity_factor', sa.Float(), nullable=True, comment='Fraction of potential generation that was actually reported for a plant part.'),
    sa.Column('fuel_cost_from_eiaapi', sa.Boolean(), nullable=True, comment='Indicates whether the fuel cost was derived from the EIA API.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('fuel_cost_per_mwh', sa.Float(), nullable=True, comment='Derived from MCOE, a unit level value. Average fuel cost per MWh of heat content in nominal USD.'),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.Float(), nullable=True, comment='Fuel content per unit of electricity generated. Coming from MCOE calculation.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('total_fuel_cost', sa.Float(), nullable=True, comment='Total annual reported fuel costs for the plant part. Includes costs from all fuels.'),
    sa.Column('total_mmbtu', sa.Float(), nullable=True, comment='Total annual heat content of fuel consumed by a plant part record in the plant parts list.'),
    sa.Column('associated_combined_heat_power', sa.Boolean(), nullable=True, comment='Indicates whether the generator is associated with a combined heat and power system'),
    sa.Column('bga_source', sa.Text(), nullable=True, comment='The source from where the unit_id_pudl is compiled. The unit_id_pudl comes directly from EIA 860, or string association (which looks at all the boilers and generators that are not associated with a unit and tries to find a matching string in the respective collection of boilers or generator), or from a unit connection (where the unit_id_eia is employed to find additional boiler generator connections).'),
    sa.Column('bypass_heat_recovery', sa.Boolean(), nullable=True, comment='Can this generator operate while bypassing the heat recovery steam generator?'),
    sa.Column('carbon_capture', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses carbon capture technology.'),
    sa.Column('city', sa.Text(), nullable=True, comment='Name of the city.'),
    sa.Column('cofire_fuels', sa.Boolean(), nullable=True, comment='Can the generator co-fire fuels?.'),
    sa.Column('county', sa.Text(), nullable=True, comment='County name.'),
    sa.Column('current_planned_generator_operating_date', sa.Date(), nullable=True, comment='The most recently updated effective date on which the generator is scheduled to start operation'),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Level of maturity of the data record. Some data sources report less-than-final data. PUDL sometimes includes this data, but use at your own risk.'),
    sa.Column('deliver_power_transgrid', sa.Boolean(), nullable=True, comment='Indicate whether the generator can deliver power to the transmission grid.'),
    sa.Column('distributed_generation', sa.Boolean(), nullable=True, comment='Whether the generator is considered distributed generation'),
    sa.Column('duct_burners', sa.Boolean(), nullable=True, comment='Indicates whether the unit has duct-burners for supplementary firing of the turbine exhaust gas'),
    sa.Column('energy_source_1_transport_1', sa.Text(), nullable=True, comment='Primary mode of transport for energy source 1.'),
    sa.Column('energy_source_1_transport_2', sa.Text(), nullable=True, comment='Secondary mode of transport for energy source 1.'),
    sa.Column('energy_source_1_transport_3', sa.Text(), nullable=True, comment='Tertiary mode of transport for energy source 1.'),
    sa.Column('energy_source_2_transport_1', sa.Text(), nullable=True, comment='Primary mode of transport for energy source 2.'),
    sa.Column('energy_source_2_transport_2', sa.Text(), nullable=True, comment='Secondary mode of transport for energy source 2.'),
    sa.Column('energy_source_2_transport_3', sa.Text(), nullable=True, comment='Tertiary mode of transport for energy source 2.'),
    sa.Column('energy_source_code_2', sa.Text(), nullable=True, comment='The code representing the second most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_code_3', sa.Text(), nullable=True, comment='The code representing the third most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_code_4', sa.Text(), nullable=True, comment='The code representing the fourth most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_code_5', sa.Text(), nullable=True, comment='The code representing the fifth most predominant type of energy that fuels the generator'),
    sa.Column('energy_source_code_6', sa.Text(), nullable=True, comment='The code representing the sixth most predominant type of energy that fuels the generator'),
    sa.Column('energy_storage_capacity_mwh', sa.Float(), nullable=True, comment='Energy storage capacity in MWh (e.g. for batteries).'),
    sa.Column('ferc_qualifying_facility', sa.Boolean(), nullable=True, comment='Indicates whether or not a generator is a qualifying FERC cogeneration facility.'),
    sa.Column('fluidized_bed_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses fluidized bed technology'),
    sa.Column('fuel_type_count', sa.Integer(), nullable=True, comment='A count of how many different simple energy sources there are associated with a generator.'),
    sa.Column('latitude', sa.Float(), nullable=True, comment="Latitude of the plant's location, in degrees."),
    sa.Column('longitude', sa.Float(), nullable=True, comment="Longitude of the plant's location, in degrees."),
    sa.Column('minimum_load_mw', sa.Float(), nullable=True, comment='The minimum load at which the generator can operate at continuosuly.'),
    sa.Column('multiple_fuels', sa.Boolean(), nullable=True, comment='Can the generator burn multiple fuels?'),
    sa.Column('nameplate_power_factor', sa.Float(), nullable=True, comment='The nameplate power factor of the generator.'),
    sa.Column('net_capacity_mwdc', sa.Float(), nullable=True, comment='Generation capacity in megawatts of direct current that is subject to a net metering agreement. Typically used for behind-the-meter solar PV.'),
    sa.Column('operating_switch', sa.Text(), nullable=True, comment='Indicates whether the fuel switching generator can switch when operating'),
    sa.Column('operational_status_code', sa.Text(), nullable=True, comment='The operating status of the asset.'),
    sa.Column('original_planned_generator_operating_date', sa.Date(), nullable=True, comment='The date the generator was originally scheduled to be operational'),
    sa.Column('other_combustion_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses other combustion technologies'),
    sa.Column('other_modifications_date', sa.Date(), nullable=True, comment='Planned effective date that the generator is scheduled to enter commercial operation after any other planned modification is complete.'),
    sa.Column('other_planned_modifications', sa.Boolean(), nullable=True, comment='Indicates whether there are there other modifications planned for the generator.'),
    sa.Column('owned_by_non_utility', sa.Boolean(), nullable=True, comment='Whether any part of generator is owned by a nonutilty'),
    sa.Column('ownership_code', sa.Text(), nullable=True, comment='Identifies the ownership for each generator.'),
    sa.Column('planned_derate_date', sa.Date(), nullable=True, comment='Planned effective month that the generator is scheduled to enter operation after the derate modification.'),
    sa.Column('planned_energy_source_code_1', sa.Text(), nullable=True, comment='New energy source code for the planned repowered generator.'),
    sa.Column('planned_modifications', sa.Boolean(), nullable=True, comment='Indicates whether there are any planned capacity uprates/derates, repowering, other modifications, or generator retirements scheduled for the next 5 years.'),
    sa.Column('planned_net_summer_capacity_derate_mw', sa.Float(), nullable=True, comment='Decrease in summer capacity expected to be realized from the derate modification to the equipment.'),
    sa.Column('planned_net_summer_capacity_uprate_mw', sa.Float(), nullable=True, comment='Increase in summer capacity expected to be realized from the modification to the equipment.'),
    sa.Column('planned_net_winter_capacity_derate_mw', sa.Float(), nullable=True, comment='Decrease in winter capacity expected to be realized from the derate modification to the equipment.'),
    sa.Column('planned_net_winter_capacity_uprate_mw', sa.Float(), nullable=True, comment='Increase in winter capacity expected to be realized from the uprate modification to the equipment.'),
    sa.Column('planned_new_capacity_mw', sa.Float(), nullable=True, comment='The expected new namplate capacity for the generator.'),
    sa.Column('planned_new_prime_mover_code', sa.Text(), nullable=True, comment='New prime mover for the planned repowered generator.'),
    sa.Column('planned_repower_date', sa.Date(), nullable=True, comment='Planned effective date that the generator is scheduled to enter operation after the repowering is complete.'),
    sa.Column('planned_uprate_date', sa.Date(), nullable=True, comment='Planned effective date that the generator is scheduled to enter operation after the uprate modification.'),
    sa.Column('previously_canceled', sa.Boolean(), nullable=True, comment='Indicates whether the generator was previously reported as indefinitely postponed or canceled'),
    sa.Column('pulverized_coal_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses pulverized coal technology'),
    sa.Column('reactive_power_output_mvar', sa.Float(), nullable=True, comment='Reactive Power Output (MVAr)'),
    sa.Column('rto_iso_lmp_node_id', sa.Text(), nullable=True, comment='The designation used to identify the price node in RTO/ISO Locational Marginal Price reports'),
    sa.Column('rto_iso_location_wholesale_reporting_id', sa.Text(), nullable=True, comment='The designation used to report ths specific location of the wholesale sales transactions to FERC for the Electric Quarterly Report'),
    sa.Column('solid_fuel_gasification', sa.Boolean(), nullable=True, comment='Indicates whether the generator is part of a solid fuel gasification system'),
    sa.Column('startup_source_code_1', sa.Text(), nullable=True, comment='The code representing the first, second, third or fourth start-up and flame stabilization energy source used by the combustion unit(s) associated with this generator.'),
    sa.Column('startup_source_code_2', sa.Text(), nullable=True, comment='The code representing the first, second, third or fourth start-up and flame stabilization energy source used by the combustion unit(s) associated with this generator.'),
    sa.Column('startup_source_code_3', sa.Text(), nullable=True, comment='The code representing the first, second, third or fourth start-up and flame stabilization energy source used by the combustion unit(s) associated with this generator.'),
    sa.Column('startup_source_code_4', sa.Text(), nullable=True, comment='The code representing the first, second, third or fourth start-up and flame stabilization energy source used by the combustion unit(s) associated with this generator.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('stoker_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses stoker technology'),
    sa.Column('street_address', sa.Text(), nullable=True, comment='Physical street address.'),
    sa.Column('subcritical_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses subcritical technology'),
    sa.Column('summer_capacity_estimate', sa.Boolean(), nullable=True, comment='Whether the summer capacity value was an estimate'),
    sa.Column('summer_capacity_mw', sa.Float(), nullable=True, comment='The net summer capacity.'),
    sa.Column('summer_estimated_capability_mw', sa.Float(), nullable=True, comment='EIA estimated summer capacity (in MWh).'),
    sa.Column('supercritical_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses supercritical technology'),
    sa.Column('switch_oil_gas', sa.Boolean(), nullable=True, comment='Indicates whether the generator switch between oil and natural gas.'),
    sa.Column('syncronized_transmission_grid', sa.Boolean(), nullable=True, comment='Indicates whether standby generators (SB status) can be synchronized to the grid.'),
    sa.Column('time_cold_shutdown_full_load_code', sa.Text(), nullable=True, comment='The minimum amount of time required to bring the unit to full load from shutdown.'),
    sa.Column('timezone', sa.Enum('Africa/Abidjan', 'Africa/Accra', 'Africa/Addis_Ababa', 'Africa/Algiers', 'Africa/Asmara', 'Africa/Asmera', 'Africa/Bamako', 'Africa/Bangui', 'Africa/Banjul', 'Africa/Bissau', 'Africa/Blantyre', 'Africa/Brazzaville', 'Africa/Bujumbura', 'Africa/Cairo', 'Africa/Casablanca', 'Africa/Ceuta', 'Africa/Conakry', 'Africa/Dakar', 'Africa/Dar_es_Salaam', 'Africa/Djibouti', 'Africa/Douala', 'Africa/El_Aaiun', 'Africa/Freetown', 'Africa/Gaborone', 'Africa/Harare', 'Africa/Johannesburg', 'Africa/Juba', 'Africa/Kampala', 'Africa/Khartoum', 'Africa/Kigali', 'Africa/Kinshasa', 'Africa/Lagos', 'Africa/Libreville', 'Africa/Lome', 'Africa/Luanda', 'Africa/Lubumbashi', 'Africa/Lusaka', 'Africa/Malabo', 'Africa/Maputo', 'Africa/Maseru', 'Africa/Mbabane', 'Africa/Mogadishu', 'Africa/Monrovia', 'Africa/Nairobi', 'Africa/Ndjamena', 'Africa/Niamey', 'Africa/Nouakchott', 'Africa/Ouagadougou', 'Africa/Porto-Novo', 'Africa/Sao_Tome', 'Africa/Timbuktu', 'Africa/Tripoli', 'Africa/Tunis', 'Africa/Windhoek', 'America/Adak', 'America/Anchorage', 'America/Anguilla', 'America/Antigua', 'America/Araguaina', 'America/Argentina/Buenos_Aires', 'America/Argentina/Catamarca', 'America/Argentina/ComodRivadavia', 'America/Argentina/Cordoba', 'America/Argentina/Jujuy', 'America/Argentina/La_Rioja', 'America/Argentina/Mendoza', 'America/Argentina/Rio_Gallegos', 'America/Argentina/Salta', 'America/Argentina/San_Juan', 'America/Argentina/San_Luis', 'America/Argentina/Tucuman', 'America/Argentina/Ushuaia', 'America/Aruba', 'America/Asuncion', 'America/Atikokan', 'America/Atka', 'America/Bahia', 'America/Bahia_Banderas', 'America/Barbados', 'America/Belem', 'America/Belize', 'America/Blanc-Sablon', 'America/Boa_Vista', 'America/Bogota', 'America/Boise', 'America/Buenos_Aires', 'America/Cambridge_Bay', 'America/Campo_Grande', 'America/Cancun', 'America/Caracas', 'America/Catamarca', 'America/Cayenne', 'America/Cayman', 'America/Chicago', 'America/Chihuahua', 'America/Ciudad_Juarez', 'America/Coral_Harbour', 'America/Cordoba', 'America/Costa_Rica', 'America/Creston', 'America/Cuiaba', 'America/Curacao', 'America/Danmarkshavn', 'America/Dawson', 'America/Dawson_Creek', 'America/Denver', 'America/Detroit', 'America/Dominica', 'America/Edmonton', 'America/Eirunepe', 'America/El_Salvador', 'America/Ensenada', 'America/Fort_Nelson', 'America/Fort_Wayne', 'America/Fortaleza', 'America/Glace_Bay', 'America/Godthab', 'America/Goose_Bay', 'America/Grand_Turk', 'America/Grenada', 'America/Guadeloupe', 'America/Guatemala', 'America/Guayaquil', 'America/Guyana', 'America/Halifax', 'America/Havana', 'America/Hermosillo', 'America/Indiana/Indianapolis', 'America/Indiana/Knox', 'America/Indiana/Marengo', 'America/Indiana/Petersburg', 'America/Indiana/Tell_City', 'America/Indiana/Vevay', 'America/Indiana/Vincennes', 'America/Indiana/Winamac', 'America/Indianapolis', 'America/Inuvik', 'America/Iqaluit', 'America/Jamaica', 'America/Jujuy', 'America/Juneau', 'America/Kentucky/Louisville', 'America/Kentucky/Monticello', 'America/Knox_IN', 'America/Kralendijk', 'America/La_Paz', 'America/Lima', 'America/Los_Angeles', 'America/Louisville', 'America/Lower_Princes', 'America/Maceio', 'America/Managua', 'America/Manaus', 'America/Marigot', 'America/Martinique', 'America/Matamoros', 'America/Mazatlan', 'America/Mendoza', 'America/Menominee', 'America/Merida', 'America/Metlakatla', 'America/Mexico_City', 'America/Miquelon', 'America/Moncton', 'America/Monterrey', 'America/Montevideo', 'America/Montreal', 'America/Montserrat', 'America/Nassau', 'America/New_York', 'America/Nipigon', 'America/Nome', 'America/Noronha', 'America/North_Dakota/Beulah', 'America/North_Dakota/Center', 'America/North_Dakota/New_Salem', 'America/Nuuk', 'America/Ojinaga', 'America/Panama', 'America/Pangnirtung', 'America/Paramaribo', 'America/Phoenix', 'America/Port-au-Prince', 'America/Port_of_Spain', 'America/Porto_Acre', 'America/Porto_Velho', 'America/Puerto_Rico', 'America/Punta_Arenas', 'America/Rainy_River', 'America/Rankin_Inlet', 'America/Recife', 'America/Regina', 'America/Resolute', 'America/Rio_Branco', 'America/Rosario', 'America/Santa_Isabel', 'America/Santarem', 'America/Santiago', 'America/Santo_Domingo', 'America/Sao_Paulo', 'America/Scoresbysund', 'America/Shiprock', 'America/Sitka', 'America/St_Barthelemy', 'America/St_Johns', 'America/St_Kitts', 'America/St_Lucia', 'America/St_Thomas', 'America/St_Vincent', 'America/Swift_Current', 'America/Tegucigalpa', 'America/Thule', 'America/Thunder_Bay', 'America/Tijuana', 'America/Toronto', 'America/Tortola', 'America/Vancouver', 'America/Virgin', 'America/Whitehorse', 'America/Winnipeg', 'America/Yakutat', 'America/Yellowknife', 'Antarctica/Casey', 'Antarctica/Davis', 'Antarctica/DumontDUrville', 'Antarctica/Macquarie', 'Antarctica/Mawson', 'Antarctica/McMurdo', 'Antarctica/Palmer', 'Antarctica/Rothera', 'Antarctica/South_Pole', 'Antarctica/Syowa', 'Antarctica/Troll', 'Antarctica/Vostok', 'Arctic/Longyearbyen', 'Asia/Aden', 'Asia/Almaty', 'Asia/Amman', 'Asia/Anadyr', 'Asia/Aqtau', 'Asia/Aqtobe', 'Asia/Ashgabat', 'Asia/Ashkhabad', 'Asia/Atyrau', 'Asia/Baghdad', 'Asia/Bahrain', 'Asia/Baku', 'Asia/Bangkok', 'Asia/Barnaul', 'Asia/Beirut', 'Asia/Bishkek', 'Asia/Brunei', 'Asia/Calcutta', 'Asia/Chita', 'Asia/Choibalsan', 'Asia/Chongqing', 'Asia/Chungking', 'Asia/Colombo', 'Asia/Dacca', 'Asia/Damascus', 'Asia/Dhaka', 'Asia/Dili', 'Asia/Dubai', 'Asia/Dushanbe', 'Asia/Famagusta', 'Asia/Gaza', 'Asia/Harbin', 'Asia/Hebron', 'Asia/Ho_Chi_Minh', 'Asia/Hong_Kong', 'Asia/Hovd', 'Asia/Irkutsk', 'Asia/Istanbul', 'Asia/Jakarta', 'Asia/Jayapura', 'Asia/Jerusalem', 'Asia/Kabul', 'Asia/Kamchatka', 'Asia/Karachi', 'Asia/Kashgar', 'Asia/Kathmandu', 'Asia/Katmandu', 'Asia/Khandyga', 'Asia/Kolkata', 'Asia/Krasnoyarsk', 'Asia/Kuala_Lumpur', 'Asia/Kuching', 'Asia/Kuwait', 'Asia/Macao', 'Asia/Macau', 'Asia/Magadan', 'Asia/Makassar', 'Asia/Manila', 'Asia/Muscat', 'Asia/Nicosia', 'Asia/Novokuznetsk', 'Asia/Novosibirsk', 'Asia/Omsk', 'Asia/Oral', 'Asia/Phnom_Penh', 'Asia/Pontianak', 'Asia/Pyongyang', 'Asia/Qatar', 'Asia/Qostanay', 'Asia/Qyzylorda', 'Asia/Rangoon', 'Asia/Riyadh', 'Asia/Saigon', 'Asia/Sakhalin', 'Asia/Samarkand', 'Asia/Seoul', 'Asia/Shanghai', 'Asia/Singapore', 'Asia/Srednekolymsk', 'Asia/Taipei', 'Asia/Tashkent', 'Asia/Tbilisi', 'Asia/Tehran', 'Asia/Tel_Aviv', 'Asia/Thimbu', 'Asia/Thimphu', 'Asia/Tokyo', 'Asia/Tomsk', 'Asia/Ujung_Pandang', 'Asia/Ulaanbaatar', 'Asia/Ulan_Bator', 'Asia/Urumqi', 'Asia/Ust-Nera', 'Asia/Vientiane', 'Asia/Vladivostok', 'Asia/Yakutsk', 'Asia/Yangon', 'Asia/Yekaterinburg', 'Asia/Yerevan', 'Atlantic/Azores', 'Atlantic/Bermuda', 'Atlantic/Canary', 'Atlantic/Cape_Verde', 'Atlantic/Faeroe', 'Atlantic/Faroe', 'Atlantic/Jan_Mayen', 'Atlantic/Madeira', 'Atlantic/Reykjavik', 'Atlantic/South_Georgia', 'Atlantic/St_Helena', 'Atlantic/Stanley', 'Australia/ACT', 'Australia/Adelaide', 'Australia/Brisbane', 'Australia/Broken_Hill', 'Australia/Canberra', 'Australia/Currie', 'Australia/Darwin', 'Australia/Eucla', 'Australia/Hobart', 'Australia/LHI', 'Australia/Lindeman', 'Australia/Lord_Howe', 'Australia/Melbourne', 'Australia/NSW', 'Australia/North', 'Australia/Perth', 'Australia/Queensland', 'Australia/South', 'Australia/Sydney', 'Australia/Tasmania', 'Australia/Victoria', 'Australia/West', 'Australia/Yancowinna', 'Brazil/Acre', 'Brazil/DeNoronha', 'Brazil/East', 'Brazil/West', 'CET', 'CST6CDT', 'Canada/Atlantic', 'Canada/Central', 'Canada/Eastern', 'Canada/Mountain', 'Canada/Newfoundland', 'Canada/Pacific', 'Canada/Saskatchewan', 'Canada/Yukon', 'Chile/Continental', 'Chile/EasterIsland', 'Cuba', 'EET', 'EST', 'EST5EDT', 'Egypt', 'Eire', 'Etc/GMT', 'Etc/GMT+0', 'Etc/GMT+1', 'Etc/GMT+10', 'Etc/GMT+11', 'Etc/GMT+12', 'Etc/GMT+2', 'Etc/GMT+3', 'Etc/GMT+4', 'Etc/GMT+5', 'Etc/GMT+6', 'Etc/GMT+7', 'Etc/GMT+8', 'Etc/GMT+9', 'Etc/GMT-0', 'Etc/GMT-1', 'Etc/GMT-10', 'Etc/GMT-11', 'Etc/GMT-12', 'Etc/GMT-13', 'Etc/GMT-14', 'Etc/GMT-2', 'Etc/GMT-3', 'Etc/GMT-4', 'Etc/GMT-5', 'Etc/GMT-6', 'Etc/GMT-7', 'Etc/GMT-8', 'Etc/GMT-9', 'Etc/GMT0', 'Etc/Greenwich', 'Etc/UCT', 'Etc/UTC', 'Etc/Universal', 'Etc/Zulu', 'Europe/Amsterdam', 'Europe/Andorra', 'Europe/Astrakhan', 'Europe/Athens', 'Europe/Belfast', 'Europe/Belgrade', 'Europe/Berlin', 'Europe/Bratislava', 'Europe/Brussels', 'Europe/Bucharest', 'Europe/Budapest', 'Europe/Busingen', 'Europe/Chisinau', 'Europe/Copenhagen', 'Europe/Dublin', 'Europe/Gibraltar', 'Europe/Guernsey', 'Europe/Helsinki', 'Europe/Isle_of_Man', 'Europe/Istanbul', 'Europe/Jersey', 'Europe/Kaliningrad', 'Europe/Kiev', 'Europe/Kirov', 'Europe/Kyiv', 'Europe/Lisbon', 'Europe/Ljubljana', 'Europe/London', 'Europe/Luxembourg', 'Europe/Madrid', 'Europe/Malta', 'Europe/Mariehamn', 'Europe/Minsk', 'Europe/Monaco', 'Europe/Moscow', 'Europe/Nicosia', 'Europe/Oslo', 'Europe/Paris', 'Europe/Podgorica', 'Europe/Prague', 'Europe/Riga', 'Europe/Rome', 'Europe/Samara', 'Europe/San_Marino', 'Europe/Sarajevo', 'Europe/Saratov', 'Europe/Simferopol', 'Europe/Skopje', 'Europe/Sofia', 'Europe/Stockholm', 'Europe/Tallinn', 'Europe/Tirane', 'Europe/Tiraspol', 'Europe/Ulyanovsk', 'Europe/Uzhgorod', 'Europe/Vaduz', 'Europe/Vatican', 'Europe/Vienna', 'Europe/Vilnius', 'Europe/Volgograd', 'Europe/Warsaw', 'Europe/Zagreb', 'Europe/Zaporozhye', 'Europe/Zurich', 'GB', 'GB-Eire', 'GMT', 'GMT+0', 'GMT-0', 'GMT0', 'Greenwich', 'HST', 'Hongkong', 'Iceland', 'Indian/Antananarivo', 'Indian/Chagos', 'Indian/Christmas', 'Indian/Cocos', 'Indian/Comoro', 'Indian/Kerguelen', 'Indian/Mahe', 'Indian/Maldives', 'Indian/Mauritius', 'Indian/Mayotte', 'Indian/Reunion', 'Iran', 'Israel', 'Jamaica', 'Japan', 'Kwajalein', 'Libya', 'MET', 'MST', 'MST7MDT', 'Mexico/BajaNorte', 'Mexico/BajaSur', 'Mexico/General', 'NZ', 'NZ-CHAT', 'Navajo', 'PRC', 'PST8PDT', 'Pacific/Apia', 'Pacific/Auckland', 'Pacific/Bougainville', 'Pacific/Chatham', 'Pacific/Chuuk', 'Pacific/Easter', 'Pacific/Efate', 'Pacific/Enderbury', 'Pacific/Fakaofo', 'Pacific/Fiji', 'Pacific/Funafuti', 'Pacific/Galapagos', 'Pacific/Gambier', 'Pacific/Guadalcanal', 'Pacific/Guam', 'Pacific/Honolulu', 'Pacific/Johnston', 'Pacific/Kanton', 'Pacific/Kiritimati', 'Pacific/Kosrae', 'Pacific/Kwajalein', 'Pacific/Majuro', 'Pacific/Marquesas', 'Pacific/Midway', 'Pacific/Nauru', 'Pacific/Niue', 'Pacific/Norfolk', 'Pacific/Noumea', 'Pacific/Pago_Pago', 'Pacific/Palau', 'Pacific/Pitcairn', 'Pacific/Pohnpei', 'Pacific/Ponape', 'Pacific/Port_Moresby', 'Pacific/Rarotonga', 'Pacific/Saipan', 'Pacific/Samoa', 'Pacific/Tahiti', 'Pacific/Tarawa', 'Pacific/Tongatapu', 'Pacific/Truk', 'Pacific/Wake', 'Pacific/Wallis', 'Pacific/Yap', 'Poland', 'Portugal', 'ROC', 'ROK', 'Singapore', 'Turkey', 'UCT', 'US/Alaska', 'US/Aleutian', 'US/Arizona', 'US/Central', 'US/East-Indiana', 'US/Eastern', 'US/Hawaii', 'US/Indiana-Starke', 'US/Michigan', 'US/Mountain', 'US/Pacific', 'US/Samoa', 'UTC', 'Universal', 'W-SU', 'WET', 'Zulu'), nullable=True, comment='IANA timezone name'),
    sa.Column('topping_bottoming_code', sa.Text(), nullable=True, comment='If the generator is associated with a combined heat and power system, indicates whether the generator is part of a topping cycle or a bottoming cycle'),
    sa.Column('turbines_inverters_hydrokinetics', sa.Integer(), nullable=True, comment='Number of wind turbines, or hydrokinetic buoys.'),
    sa.Column('turbines_num', sa.Integer(), nullable=True, comment='Number of wind turbines, or hydrokinetic buoys.'),
    sa.Column('ultrasupercritical_tech', sa.Boolean(), nullable=True, comment='Indicates whether the generator uses ultra-supercritical technology'),
    sa.Column('uprate_derate_completed_date', sa.Date(), nullable=True, comment='The date when the uprate or derate was completed.'),
    sa.Column('uprate_derate_during_year', sa.Boolean(), nullable=True, comment='Was an uprate or derate completed on this generator during the reporting year?'),
    sa.Column('winter_capacity_estimate', sa.Boolean(), nullable=True, comment='Whether the winter capacity value was an estimate'),
    sa.Column('winter_capacity_mw', sa.Float(), nullable=True, comment='The net winter capacity.'),
    sa.Column('winter_estimated_capability_mw', sa.Float(), nullable=True, comment='EIA estimated winter capacity (in MWh).'),
    sa.Column('zip_code', sa.Text(), nullable=True, comment='Five digit US Zip Code.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk_out_eia__yearly_generators_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_1_transport_1'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_out_eia__yearly_generators_energy_source_1_transport_1_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_1_transport_2'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_out_eia__yearly_generators_energy_source_1_transport_2_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_1_transport_3'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_out_eia__yearly_generators_energy_source_1_transport_3_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_2_transport_1'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_out_eia__yearly_generators_energy_source_2_transport_1_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_2_transport_2'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_out_eia__yearly_generators_energy_source_2_transport_2_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_2_transport_3'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk_out_eia__yearly_generators_energy_source_2_transport_3_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_generators_energy_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_2'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_generators_energy_source_code_2_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_3'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_generators_energy_source_code_3_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_4'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_generators_energy_source_code_4_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_5'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_generators_energy_source_code_5_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_6'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_generators_energy_source_code_6_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['operational_status_code'], ['core_eia__codes_operational_status.code'], name=op.f('fk_out_eia__yearly_generators_operational_status_code_core_eia__codes_operational_status')),
    sa.ForeignKeyConstraint(['planned_energy_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_generators_planned_energy_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['planned_new_prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_out_eia__yearly_generators_planned_new_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk_out_eia__yearly_generators_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia__yearly_generators_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_out_eia__yearly_generators_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['startup_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_generators_startup_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['startup_source_code_2'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_generators_startup_source_code_2_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['startup_source_code_3'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_generators_startup_source_code_3_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['startup_source_code_4'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_generators_startup_source_code_4_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk_out_eia__yearly_generators_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia__yearly_generators_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk_out_eia__yearly_generators'))
    )
    op.create_table('out_eia__yearly_generators_by_ownership',
    sa.Column('plant_id_eia', sa.Integer(), nullable=True, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=True, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('technology_description', sa.Text(), nullable=True, comment='High level description of the technology used by the generator to produce electricity.'),
    sa.Column('energy_source_code_1', sa.Text(), nullable=True, comment='The code representing the most predominant type of energy that fuels the generator.'),
    sa.Column('prime_mover_code', sa.Text(), nullable=True, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('generator_operating_date', sa.Date(), nullable=True, comment='Date the generator began commercial operation. If harvested values are inconsistent, we default to using the most recently reported date.'),
    sa.Column('generator_retirement_date', sa.Date(), nullable=True, comment='Date of the scheduled or effected retirement of the generator.'),
    sa.Column('operational_status', sa.Text(), nullable=True, comment='The operating status of the asset. For generators this is based on which tab the generator was listed in in EIA 860.'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('planned_generator_retirement_date', sa.Date(), nullable=True, comment='Planned effective date of the scheduled retirement of the generator.'),
    sa.Column('capacity_factor', sa.Float(), nullable=True, comment='Fraction of potential generation that was actually reported for a plant part.'),
    sa.Column('fuel_cost_from_eiaapi', sa.Boolean(), nullable=True, comment='Indicates whether the fuel cost was derived from the EIA API.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('fuel_cost_per_mwh', sa.Float(), nullable=True, comment='Derived from MCOE, a unit level value. Average fuel cost per MWh of heat content in nominal USD.'),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.Float(), nullable=True, comment='Fuel content per unit of electricity generated. Coming from MCOE calculation.'),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('total_fuel_cost', sa.Float(), nullable=True, comment='Total annual reported fuel costs for the plant part. Includes costs from all fuels.'),
    sa.Column('total_mmbtu', sa.Float(), nullable=True, comment='Total annual heat content of fuel consumed by a plant part record in the plant parts list.'),
    sa.Column('ferc_acct_name', sa.Enum('Hydraulic', 'Nuclear', 'Steam', 'Other'), nullable=True, comment='Name of FERC account, derived from technology description and prime mover code.'),
    sa.Column('generator_operating_year', sa.Integer(), nullable=True, comment='Year a generator went into service.'),
    sa.Column('operational_status_pudl', sa.Enum('operating', 'retired', 'proposed'), nullable=True, comment='The operating status of the asset using PUDL categories.'),
    sa.Column('capacity_eoy_mw', sa.Float(), nullable=True, comment='Total end of year installed (nameplate) capacity for a plant part, in megawatts.'),
    sa.Column('fraction_owned', sa.Float(), nullable=True, comment='Proportion of generator ownership attributable to this utility.'),
    sa.Column('ownership_record_type', sa.Enum('owned', 'total'), nullable=True, comment='Whether each generator record is for one owner or represents a total of all ownerships.'),
    sa.ForeignKeyConstraint(['energy_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_generators_by_ownership_energy_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk_out_eia__yearly_generators_by_ownership_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia__yearly_generators_by_ownership_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_out_eia__yearly_generators_by_ownership_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk_out_eia__yearly_generators_by_ownership_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia__yearly_generators_by_ownership_utility_id_pudl_core_pudl__entity_utilities_pudl'))
    )
    op.create_table('out_eia__yearly_plant_parts',
    sa.Column('record_id_eia', sa.Text(), nullable=False, comment='Identifier for EIA plant parts analysis records.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=True, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('plant_part', sa.Enum('plant_unit', 'plant_gen', 'plant_ferc_acct', 'plant_match_ferc1', 'plant_prime_fuel', 'plant', 'plant_technology', 'plant_prime_mover', 'plant_operating_year'), nullable=True, comment='The part of the plant a record corresponds to.'),
    sa.Column('generator_id', sa.Text(), nullable=True, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('prime_mover_code', sa.Text(), nullable=True, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('energy_source_code_1', sa.Text(), nullable=True, comment='The code representing the most predominant type of energy that fuels the generator.'),
    sa.Column('technology_description', sa.Text(), nullable=True, comment='High level description of the technology used by the generator to produce electricity.'),
    sa.Column('ferc_acct_name', sa.Enum('Hydraulic', 'Nuclear', 'Steam', 'Other'), nullable=True, comment='Name of FERC account, derived from technology description and prime mover code.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('true_gran', sa.Boolean(), nullable=True, comment='Indicates whether a plant part list record is associated with the highest priority plant part for all identical records.'),
    sa.Column('appro_part_label', sa.Enum('plant_unit', 'plant_gen', 'plant_ferc_acct', 'plant_match_ferc1', 'plant_prime_fuel', 'plant', 'plant_technology', 'plant_prime_mover', 'plant_operating_year'), nullable=True, comment='Plant part of the associated true granularity record.'),
    sa.Column('appro_record_id_eia', sa.Text(), nullable=True, comment='EIA record ID of the associated true granularity record.'),
    sa.Column('ferc1_generator_agg_id', sa.Integer(), nullable=True, comment='ID dynamically assigned by PUDL to EIA records with multiple matches to a single FERC ID in the FERC-EIA manual matching process.'),
    sa.Column('capacity_eoy_mw', sa.Float(), nullable=True, comment='Total end of year installed (nameplate) capacity for a plant part, in megawatts.'),
    sa.Column('capacity_factor', sa.Float(), nullable=True, comment='Fraction of potential generation that was actually reported for a plant part.'),
    sa.Column('capacity_mw', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('construction_year', sa.Integer(), nullable=True, comment="Year the plant's oldest still operational unit was built."),
    sa.Column('fraction_owned', sa.Float(), nullable=True, comment='Proportion of generator ownership attributable to this utility.'),
    sa.Column('fuel_cost_per_mmbtu', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('fuel_cost_per_mwh', sa.Float(), nullable=True, comment='Derived from MCOE, a unit level value. Average fuel cost per MWh of heat content in nominal USD.'),
    sa.Column('fuel_type_code_pudl', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('generator_retirement_date', sa.Date(), nullable=True, comment='Date of the scheduled or effected retirement of the generator.'),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.Float(), nullable=True, comment='Fuel content per unit of electricity generated. Coming from MCOE calculation.'),
    sa.Column('installation_year', sa.Integer(), nullable=True, comment="Year the plant's most recently built unit was installed."),
    sa.Column('net_generation_mwh', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('generator_operating_year', sa.Integer(), nullable=True, comment='Year a generator went into service.'),
    sa.Column('operational_status', sa.Text(), nullable=True, comment='The operating status of the asset. For generators this is based on which tab the generator was listed in in EIA 860.'),
    sa.Column('operational_status_pudl', sa.Enum('operating', 'retired', 'proposed'), nullable=True, comment='The operating status of the asset using PUDL categories.'),
    sa.Column('ownership_record_type', sa.Enum('owned', 'total'), nullable=True, comment='Whether each generator record is for one owner or represents a total of all ownerships.'),
    sa.Column('ownership_dupe', sa.Boolean(), nullable=True, comment='Whether a plant part record has a duplicate record with different ownership status.'),
    sa.Column('planned_generator_retirement_date', sa.Date(), nullable=True, comment='Planned effective date of the scheduled retirement of the generator.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('plant_name_ppe', sa.Text(), nullable=True, comment='Derived plant name that includes EIA plant name and other strings associated with ID and PK columns of the plant part.'),
    sa.Column('plant_part_id_eia', sa.Text(), nullable=True, comment='Contains EIA plant ID, plant part, ownership, and EIA utility id'),
    sa.Column('record_count', sa.Integer(), nullable=True, comment='Number of distinct generator IDs that partcipated in the aggregation for a plant part list record.'),
    sa.Column('total_fuel_cost', sa.Float(), nullable=True, comment='Total annual reported fuel costs for the plant part. Includes costs from all fuels.'),
    sa.Column('total_mmbtu', sa.Float(), nullable=True, comment='Total annual heat content of fuel consumed by a plant part record in the plant parts list.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('plant_id_report_year', sa.Text(), nullable=True, comment='PUDL plant ID and report year of the record.'),
    sa.ForeignKeyConstraint(['energy_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_eia__yearly_plant_parts_energy_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk_out_eia__yearly_plant_parts_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_eia__yearly_plant_parts_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_out_eia__yearly_plant_parts_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk_out_eia__yearly_plant_parts_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_eia__yearly_plant_parts_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('record_id_eia', name=op.f('pk_out_eia__yearly_plant_parts'))
    )
    op.create_table('out_pudl__yearly_assn_eia_ferc1_plant_parts',
    sa.Column('record_id_ferc1', sa.Text(), nullable=False, comment='Identifier indicating original FERC Form 1 source record. format: {table_name}_{report_year}_{report_prd}_{respondent_id}_{spplmnt_num}_{row_number}. Unique within FERC Form 1 DB tables which are not row-mapped.'),
    sa.Column('record_id_eia', sa.Text(), nullable=True, comment='Identifier for EIA plant parts analysis records.'),
    sa.Column('match_type', sa.Text(), nullable=True, comment='Indicates the source and validation of the match between EIA and FERC. Match types include matches was generated from the model, verified by the training data, overridden by the training data, etc.'),
    sa.Column('plant_name_ppe', sa.Text(), nullable=True, comment='Derived plant name that includes EIA plant name and other strings associated with ID and PK columns of the plant part.'),
    sa.Column('plant_part', sa.Enum('plant_unit', 'plant_gen', 'plant_ferc_acct', 'plant_match_ferc1', 'plant_prime_fuel', 'plant', 'plant_technology', 'plant_prime_mover', 'plant_operating_year'), nullable=True, comment='The part of the plant a record corresponds to.'),
    sa.Column('report_year', sa.Integer(), nullable=True, comment='Four-digit year in which the data was reported.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('ownership_record_type', sa.Enum('owned', 'total'), nullable=True, comment='Whether each generator record is for one owner or represents a total of all ownerships.'),
    sa.Column('plant_name_eia', sa.Text(), nullable=True, comment='Plant name.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=True, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('generator_id', sa.Text(), nullable=True, comment='Generator ID is usually numeric, but sometimes includes letters. Make sure you treat it as a string!'),
    sa.Column('unit_id_pudl', sa.Integer(), nullable=True, comment='Dynamically assigned PUDL unit id. WARNING: This ID is not guaranteed to be static long term as the input data and algorithm may evolve over time.'),
    sa.Column('prime_mover_code', sa.Text(), nullable=True, comment='Code for the type of prime mover (e.g. CT, CG)'),
    sa.Column('energy_source_code_1', sa.Text(), nullable=True, comment='The code representing the most predominant type of energy that fuels the generator.'),
    sa.Column('technology_description', sa.Text(), nullable=True, comment='High level description of the technology used by the generator to produce electricity.'),
    sa.Column('ferc_acct_name', sa.Enum('Hydraulic', 'Nuclear', 'Steam', 'Other'), nullable=True, comment='Name of FERC account, derived from technology description and prime mover code.'),
    sa.Column('generator_operating_year', sa.Integer(), nullable=True, comment='Year a generator went into service.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL utility ID. May not be stable over time.'),
    sa.Column('true_gran', sa.Boolean(), nullable=True, comment='Indicates whether a plant part list record is associated with the highest priority plant part for all identical records.'),
    sa.Column('appro_part_label', sa.Enum('plant_unit', 'plant_gen', 'plant_ferc_acct', 'plant_match_ferc1', 'plant_prime_fuel', 'plant', 'plant_technology', 'plant_prime_mover', 'plant_operating_year'), nullable=True, comment='Plant part of the associated true granularity record.'),
    sa.Column('appro_record_id_eia', sa.Text(), nullable=True, comment='EIA record ID of the associated true granularity record.'),
    sa.Column('record_count', sa.Integer(), nullable=True, comment='Number of distinct generator IDs that partcipated in the aggregation for a plant part list record.'),
    sa.Column('fraction_owned', sa.Float(), nullable=True, comment='Proportion of generator ownership attributable to this utility.'),
    sa.Column('ownership_dupe', sa.Boolean(), nullable=True, comment='Whether a plant part record has a duplicate record with different ownership status.'),
    sa.Column('operational_status', sa.Text(), nullable=True, comment='The operating status of the asset. For generators this is based on which tab the generator was listed in in EIA 860.'),
    sa.Column('operational_status_pudl', sa.Enum('operating', 'retired', 'proposed'), nullable=True, comment='The operating status of the asset using PUDL categories.'),
    sa.Column('plant_id_pudl', sa.Integer(), nullable=True, comment='A manually assigned PUDL plant ID. May not be constant over time.'),
    sa.Column('total_fuel_cost_eia', sa.Float(), nullable=True, comment='Total annual reported fuel costs for the plant part. Includes costs from all fuels.'),
    sa.Column('fuel_cost_per_mmbtu_eia', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('net_generation_mwh_eia', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('capacity_mw_eia', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('capacity_factor_eia', sa.Float(), nullable=True, comment='Fraction of potential generation that was actually reported for a plant part.'),
    sa.Column('total_mmbtu_eia', sa.Float(), nullable=True, comment='Total annual heat content of fuel consumed by a plant part record in the plant parts list.'),
    sa.Column('unit_heat_rate_mmbtu_per_mwh_eia', sa.Float(), nullable=True, comment='Fuel content per unit of electricity generated. Coming from MCOE calculation.'),
    sa.Column('fuel_type_code_pudl_eia', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('installation_year_eia', sa.Integer(), nullable=True, comment="Year the plant's most recently built unit was installed."),
    sa.Column('plant_part_id_eia', sa.Text(), nullable=True, comment='Contains EIA plant ID, plant part, ownership, and EIA utility id'),
    sa.Column('utility_id_ferc1', sa.Integer(), nullable=True, comment='PUDL-assigned utility ID, identifying a FERC1 utility. This is an auto-incremented ID and is not expected to be stable from year to year.'),
    sa.Column('utility_name_ferc1', sa.Text(), nullable=True, comment='Name of the responding utility, as it is reported in FERC Form 1. For human readability only.'),
    sa.Column('plant_id_ferc1', sa.Integer(), nullable=True, comment='Algorithmically assigned PUDL FERC Plant ID. WARNING: NOT STABLE BETWEEN PUDL DB INITIALIZATIONS.'),
    sa.Column('plant_name_ferc1', sa.Text(), nullable=True, comment='Name of the plant, as reported to FERC. This is a freeform string, not guaranteed to be consistent across references to the same plant.'),
    sa.Column('asset_retirement_cost', sa.Float(), nullable=True, comment='Asset retirement cost (USD).'),
    sa.Column('avg_num_employees', sa.Float(), nullable=True, comment='The average number of employees assigned to each plant.'),
    sa.Column('capacity_factor_ferc1', sa.Float(), nullable=True, comment='Fraction of potential generation that was actually reported for a plant part.'),
    sa.Column('capacity_mw_ferc1', sa.Float(), nullable=True, comment='Total installed (nameplate) capacity, in megawatts.'),
    sa.Column('capex_annual_addition', sa.Float(), nullable=True, comment='Annual capital addition into `capex_total`.'),
    sa.Column('capex_annual_addition_rolling', sa.Float(), nullable=True, comment='Year-to-date capital addition into `capex_total`.'),
    sa.Column('capex_annual_per_kw', sa.Float(), nullable=True, comment='Annual capital addition into `capex_total` per kw.'),
    sa.Column('capex_annual_per_mw', sa.Float(), nullable=True, comment='Annual capital addition into `capex_total` per MW.'),
    sa.Column('capex_annual_per_mw_rolling', sa.Float(), nullable=True, comment='Year-to-date capital addition into `capex_total` per MW.'),
    sa.Column('capex_annual_per_mwh', sa.Float(), nullable=True, comment='Annual capital addition into `capex_total` per MWh.'),
    sa.Column('capex_annual_per_mwh_rolling', sa.Float(), nullable=True, comment='Year-to-date capital addition into `capex_total` per MWh.'),
    sa.Column('capex_equipment', sa.Float(), nullable=True, comment='Cost of plant: equipment (USD).'),
    sa.Column('capex_land', sa.Float(), nullable=True, comment='Cost of plant: land and land rights (USD).'),
    sa.Column('capex_per_mw', sa.Float(), nullable=True, comment='Cost of plant per megawatt of installed (nameplate) capacity. Nominal USD.'),
    sa.Column('capex_structures', sa.Float(), nullable=True, comment='Cost of plant: structures and improvements (USD).'),
    sa.Column('capex_total', sa.Float(), nullable=True, comment='Total cost of plant (USD).'),
    sa.Column('capex_wo_retirement_total', sa.Float(), nullable=True, comment='Total cost of plant (USD) without retirements.'),
    sa.Column('construction_type', sa.Enum('conventional', 'outdoor', 'semioutdoor'), nullable=True, comment="Type of plant construction ('outdoor', 'semioutdoor', or 'conventional'). Categorized by PUDL based on our best guess of intended value in FERC1 freeform strings."),
    sa.Column('construction_year_eia', sa.Integer(), nullable=True, comment="Year the plant's oldest still operational unit was built."),
    sa.Column('construction_year_ferc1', sa.Integer(), nullable=True, comment="Year the plant's oldest still operational unit was built."),
    sa.Column('installation_year_ferc1', sa.Integer(), nullable=True, comment="Year the plant's most recently built unit was installed."),
    sa.Column('net_generation_mwh_ferc1', sa.Float(), nullable=True, comment='Net electricity generation for the specified period in megawatt-hours (MWh).'),
    sa.Column('not_water_limited_capacity_mw', sa.Float(), nullable=True, comment='Plant capacity in MW when not limited by condenser water.'),
    sa.Column('opex_allowances', sa.Float(), nullable=True, comment='Allowances.'),
    sa.Column('opex_boiler', sa.Float(), nullable=True, comment='Maintenance of boiler (or reactor) plant.'),
    sa.Column('opex_coolants', sa.Float(), nullable=True, comment='Cost of coolants and water (nuclear plants only)'),
    sa.Column('opex_electric', sa.Float(), nullable=True, comment='Production expenses: electric expenses (USD).'),
    sa.Column('opex_engineering', sa.Float(), nullable=True, comment='Production expenses: maintenance, supervision, and engineering (USD).'),
    sa.Column('opex_fuel', sa.Float(), nullable=True, comment='Production expenses: fuel (USD).'),
    sa.Column('fuel_cost_per_mwh_eia', sa.Float(), nullable=True, comment='Derived from MCOE, a unit level value. Average fuel cost per MWh of heat content in nominal USD.'),
    sa.Column('fuel_cost_per_mwh_ferc1', sa.Float(), nullable=True, comment='Derived from MCOE, a unit level value. Average fuel cost per MWh of heat content in nominal USD.'),
    sa.Column('opex_misc_power', sa.Float(), nullable=True, comment='Miscellaneous steam (or nuclear) expenses.'),
    sa.Column('opex_misc_steam', sa.Float(), nullable=True, comment='Maintenance of miscellaneous steam (or nuclear) plant.'),
    sa.Column('opex_nonfuel_per_mwh', sa.Float(), nullable=True, comment='Investments in non-fuel production expenses per Mwh.'),
    sa.Column('opex_operations', sa.Float(), nullable=True, comment='Production expenses: operations, supervision, and engineering (USD).'),
    sa.Column('opex_per_mwh', sa.Float(), nullable=True, comment='Total production expenses (USD per MWh generated).'),
    sa.Column('opex_plant', sa.Float(), nullable=True, comment='Production expenses: maintenance of electric plant (USD).'),
    sa.Column('opex_production_total', sa.Float(), nullable=True, comment='Total operating expenses.'),
    sa.Column('opex_rents', sa.Float(), nullable=True, comment='Production expenses: rents (USD).'),
    sa.Column('opex_steam', sa.Float(), nullable=True, comment='Steam expenses.'),
    sa.Column('opex_steam_other', sa.Float(), nullable=True, comment='Steam from other sources.'),
    sa.Column('opex_structures', sa.Float(), nullable=True, comment='Production expenses: maintenance of structures (USD).'),
    sa.Column('opex_total_nonfuel', sa.Float(), nullable=True, comment='Total production expenses, excluding fuel (USD).'),
    sa.Column('opex_transfer', sa.Float(), nullable=True, comment='Steam transferred (Credit).'),
    sa.Column('peak_demand_mw', sa.Float(), nullable=True, comment='Net peak demand for 60 minutes. Note: in some cases peak demand for other time periods may have been reported instead, if hourly peak demand was unavailable.'),
    sa.Column('plant_capability_mw', sa.Float(), nullable=True, comment='Net plant capability in megawatts.'),
    sa.Column('plant_hours_connected_while_generating', sa.Float(), nullable=True, comment='Hours the plant was connected to load while generating in the report year.'),
    sa.Column('plant_type', sa.Text(), nullable=True, comment='Type of plant.'),
    sa.Column('water_limited_capacity_mw', sa.Float(), nullable=True, comment='Plant capacity in MW when limited by condenser water.'),
    sa.Column('fuel_cost_per_mmbtu_ferc1', sa.Float(), nullable=True, comment='Average fuel cost per mmBTU of heat content in nominal USD.'),
    sa.Column('fuel_type', sa.Text(), nullable=True, comment='Type of fuel.'),
    sa.Column('license_id_ferc1', sa.Integer(), nullable=True, comment='FERC issued operating license ID for the facility, if available. This value is extracted from the original plant name where possible.'),
    sa.Column('opex_maintenance', sa.Float(), nullable=True, comment='Production expenses: Maintenance (USD).'),
    sa.Column('opex_total', sa.Float(), nullable=True, comment='Total production expenses, excluding fuel (USD).'),
    sa.Column('capex_facilities', sa.Float(), nullable=True, comment='Cost of plant: reservoirs, dams, and waterways (USD).'),
    sa.Column('capex_roads', sa.Float(), nullable=True, comment='Cost of plant: roads, railroads, and bridges (USD).'),
    sa.Column('net_capacity_adverse_conditions_mw', sa.Float(), nullable=True, comment='Net plant capability under the least favorable operating conditions, in megawatts.'),
    sa.Column('net_capacity_favorable_conditions_mw', sa.Float(), nullable=True, comment='Net plant capability under the most favorable operating conditions, in megawatts.'),
    sa.Column('opex_dams', sa.Float(), nullable=True, comment='Production expenses: maintenance of reservoirs, dams, and waterways (USD).'),
    sa.Column('opex_generation_misc', sa.Float(), nullable=True, comment='Production expenses: miscellaneous power generation expenses (USD).'),
    sa.Column('opex_hydraulic', sa.Float(), nullable=True, comment='Production expenses: hydraulic expenses (USD).'),
    sa.Column('opex_misc_plant', sa.Float(), nullable=True, comment='Production expenses: maintenance of miscellaneous hydraulic plant (USD).'),
    sa.Column('opex_water_for_power', sa.Float(), nullable=True, comment='Production expenses: water for power (USD).'),
    sa.Column('ferc_license_id', sa.Text(), nullable=True, comment='The FERC license ID of a project.'),
    sa.Column('capex_equipment_electric', sa.Float(), nullable=True, comment='Cost of plant: accessory electric equipment (USD).'),
    sa.Column('capex_equipment_misc', sa.Float(), nullable=True, comment='Cost of plant: miscellaneous power plant equipment (USD).'),
    sa.Column('capex_wheels_turbines_generators', sa.Float(), nullable=True, comment='Cost of plant: water wheels, turbines, and generators (USD).'),
    sa.Column('energy_used_for_pumping_mwh', sa.Float(), nullable=True, comment='Energy used for pumping, in megawatt-hours.'),
    sa.Column('net_load_mwh', sa.Float(), nullable=True, comment='Net output for load (net generation - energy used for pumping) in megawatt-hours.'),
    sa.Column('opex_production_before_pumping', sa.Float(), nullable=True, comment='Total production expenses before pumping (USD).'),
    sa.Column('opex_pumped_storage', sa.Float(), nullable=True, comment='Production expenses: pumped storage (USD).'),
    sa.Column('opex_pumping', sa.Float(), nullable=True, comment='Production expenses: We are here to PUMP YOU UP! (USD).'),
    sa.Column('total_fuel_cost_ferc1', sa.Float(), nullable=True, comment='Total annual reported fuel costs for the plant part. Includes costs from all fuels.'),
    sa.Column('total_mmbtu_ferc1', sa.Float(), nullable=True, comment='Total annual heat content of fuel consumed by a plant part record in the plant parts list.'),
    sa.Column('fuel_type_code_pudl_ferc1', sa.Enum('coal', 'gas', 'hydro', 'nuclear', 'oil', 'other', 'solar', 'waste', 'wind'), nullable=True, comment='Simplified fuel type code used in PUDL'),
    sa.Column('unit_heat_rate_mmbtu_per_mwh_ferc1', sa.Float(), nullable=True, comment='Fuel content per unit of electricity generated. Calculated from FERC reported fuel consumption and net generation.'),
    sa.ForeignKeyConstraint(['energy_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk_out_pudl__yearly_assn_eia_ferc1_plant_parts_energy_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk_out_pudl__yearly_assn_eia_ferc1_plant_parts_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk_out_pudl__yearly_assn_eia_ferc1_plant_parts_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk_out_pudl__yearly_assn_eia_ferc1_plant_parts_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk_out_pudl__yearly_assn_eia_ferc1_plant_parts_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_ferc1', 'plant_name_ferc1'], ['core_pudl__assn_ferc1_pudl_plants.utility_id_ferc1', 'core_pudl__assn_ferc1_pudl_plants.plant_name_ferc1'], name=op.f('fk_out_pudl__yearly_assn_eia_ferc1_plant_parts_utility_id_ferc1_core_pudl__assn_ferc1_pudl_plants')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk_out_pudl__yearly_assn_eia_ferc1_plant_parts_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('record_id_ferc1', name=op.f('pk_out_pudl__yearly_assn_eia_ferc1_plant_parts'))
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('out_pudl__yearly_assn_eia_ferc1_plant_parts')
    op.drop_table('out_eia__yearly_plant_parts')
    op.drop_table('out_eia__yearly_generators_by_ownership')
    op.drop_table('out_eia__yearly_generators')
    op.drop_table('out_eia__yearly_boilers')
    op.drop_table('out_eia923__yearly_generation_fuel_by_generator_energy_source_owner')
    op.drop_table('out_eia923__yearly_generation_fuel_by_generator_energy_source')
    op.drop_table('out_eia923__yearly_generation_fuel_by_generator')
    op.drop_table('out_eia923__yearly_generation')
    op.drop_table('out_eia923__yearly_boiler_fuel')
    op.drop_table('out_eia860__yearly_ownership')
    op.drop_table('core_eia860__scd_ownership')
    op.drop_table('core_eia860__scd_generators_wind')
    op.drop_table('core_eia860__scd_generators_solar')
    op.drop_table('core_eia860__scd_generators_energy_storage')
    op.drop_table('core_eia860__assn_yearly_boiler_emissions_control_equipment')
    op.drop_table('core_eia860__assn_boiler_stack_flue')
    op.drop_table('core_eia860__assn_boiler_generator')
    op.drop_table('core_eia860__assn_boiler_cooling')
    op.drop_table('_out_eia__yearly_heat_rate_by_generator')
    op.drop_table('_out_eia__yearly_generators')
    op.drop_table('_out_eia__yearly_fuel_cost_by_generator')
    op.drop_table('_out_eia__yearly_derived_generator_attributes')
    op.drop_table('_out_eia__yearly_capacity_factor_by_generator')
    op.drop_table('out_ferc1__yearly_steam_plants_sched402')
    op.drop_table('out_ferc1__yearly_steam_plants_fuel_sched402')
    op.drop_table('out_ferc1__yearly_steam_plants_fuel_by_plant_sched402')
    op.drop_table('out_ferc1__yearly_small_plants_sched410')
    op.drop_table('out_ferc1__yearly_pumped_storage_plants_sched408')
    op.drop_table('out_ferc1__yearly_hydroelectric_plants_sched406')
    op.drop_table('out_ferc1__yearly_all_plants')
    op.drop_table('out_eia__yearly_plants')
    op.drop_table('out_eia923__yearly_generation_fuel_combined')
    op.drop_table('out_eia923__yearly_fuel_receipts_costs')
    op.drop_table('core_ferc1__yearly_steam_plants_sched402')
    op.drop_table('core_ferc1__yearly_steam_plants_fuel_sched402')
    op.drop_table('core_ferc1__yearly_small_plants_sched410')
    op.drop_table('core_ferc1__yearly_pumped_storage_plants_sched408')
    op.drop_table('core_ferc1__yearly_hydroelectric_plants_sched406')
    op.drop_table('core_eia860__scd_generators')
    op.drop_table('core_eia860__scd_boilers')
    op.drop_table('_out_ferc1__yearly_plants_utilities')
    op.drop_table('_out_eia__yearly_heat_rate_by_unit')
    op.drop_table('_out_eia__plants_utilities')
    op.drop_table('_core_eia860__fgd_equipment')
    op.drop_table('_core_eia860__cooling_equipment')
    op.drop_table('out_ferc1__yearly_utility_plant_summary_sched200')
    op.drop_table('out_ferc1__yearly_transmission_lines_sched422')
    op.drop_table('out_ferc1__yearly_sales_by_rate_schedules_sched304')
    op.drop_table('out_ferc1__yearly_retained_earnings_sched118')
    op.drop_table('out_ferc1__yearly_rate_base')
    op.drop_table('out_ferc1__yearly_purchased_power_and_exchanges_sched326')
    op.drop_table('out_ferc1__yearly_plant_in_service_sched204')
    op.drop_table('out_ferc1__yearly_other_regulatory_liabilities_sched278')
    op.drop_table('out_ferc1__yearly_operating_revenues_sched300')
    op.drop_table('out_ferc1__yearly_operating_expenses_sched320')
    op.drop_table('out_ferc1__yearly_income_statements_sched114')
    op.drop_table('out_ferc1__yearly_energy_sources_sched401')
    op.drop_table('out_ferc1__yearly_energy_dispositions_sched401')
    op.drop_table('out_ferc1__yearly_depreciation_summary_sched336')
    op.drop_table('out_ferc1__yearly_depreciation_changes_sched219')
    op.drop_table('out_ferc1__yearly_depreciation_by_function_sched219')
    op.drop_table('out_ferc1__yearly_cash_flows_sched120')
    op.drop_table('out_ferc1__yearly_balance_sheet_liabilities_sched110')
    op.drop_table('out_ferc1__yearly_balance_sheet_assets_sched110')
    op.drop_table('out_eia__yearly_utilities')
    op.drop_table('out_eia__monthly_generators')
    op.drop_table('out_eia923__monthly_generation_fuel_by_generator_energy_source')
    op.drop_table('out_eia923__monthly_generation_fuel_by_generator')
    op.drop_table('out_eia923__monthly_generation')
    op.drop_table('out_eia923__monthly_boiler_fuel')
    op.drop_table('out_eia923__generation')
    op.drop_table('out_eia923__boiler_fuel')
    op.drop_table('core_pudl__assn_ferc1_xbrl_pudl_utilities')
    op.drop_table('core_pudl__assn_ferc1_pudl_plants')
    op.drop_table('core_pudl__assn_ferc1_dbf_pudl_utilities')
    op.drop_table('core_gridpathratoolkit__assn_generator_aggregation_group')
    op.drop_table('core_ferc1__yearly_utility_plant_summary_sched200')
    op.drop_table('core_ferc1__yearly_transmission_lines_sched422')
    op.drop_table('core_ferc1__yearly_sales_by_rate_schedules_sched304')
    op.drop_table('core_ferc1__yearly_retained_earnings_sched118')
    op.drop_table('core_ferc1__yearly_purchased_power_and_exchanges_sched326')
    op.drop_table('core_ferc1__yearly_plant_in_service_sched204')
    op.drop_table('core_ferc1__yearly_other_regulatory_liabilities_sched278')
    op.drop_table('core_ferc1__yearly_operating_revenues_sched300')
    op.drop_table('core_ferc1__yearly_operating_expenses_sched320')
    op.drop_table('core_ferc1__yearly_income_statements_sched114')
    op.drop_table('core_ferc1__yearly_energy_sources_sched401')
    op.drop_table('core_ferc1__yearly_energy_dispositions_sched401')
    op.drop_table('core_ferc1__yearly_depreciation_summary_sched336')
    op.drop_table('core_ferc1__yearly_depreciation_changes_sched219')
    op.drop_table('core_ferc1__yearly_depreciation_by_function_sched219')
    op.drop_table('core_ferc1__yearly_cash_flows_sched120')
    op.drop_table('core_ferc1__yearly_balance_sheet_liabilities_sched110')
    op.drop_table('core_ferc1__yearly_balance_sheet_assets_sched110')
    op.drop_table('core_epa__assn_eia_epacamd')
    op.drop_table('core_eia923__monthly_generation')
    op.drop_table('core_eia923__monthly_fuel_receipts_costs')
    op.drop_table('core_eia923__monthly_boiler_fuel')
    op.drop_table('core_eia860__scd_plants')
    op.drop_table('_out_eia__monthly_heat_rate_by_generator')
    op.drop_table('_out_eia__monthly_fuel_cost_by_generator')
    op.drop_table('_out_eia__monthly_derived_generator_attributes')
    op.drop_table('_out_eia__monthly_capacity_factor_by_generator')
    op.drop_table('out_ferc714__summarized_demand')
    op.drop_table('out_ferc714__respondents_with_fips')
    op.drop_table('out_eia923__monthly_generation_fuel_combined')
    op.drop_table('out_eia923__monthly_fuel_receipts_costs')
    op.drop_table('out_eia923__generation_fuel_combined')
    op.drop_table('out_eia923__fuel_receipts_costs')
    op.drop_table('out_eia860__yearly_emissions_control_equipment')
    op.drop_table('core_pudl__assn_utilities_plants')
    op.drop_table('core_pudl__assn_ferc1_pudl_utilities')
    op.drop_table('core_pudl__assn_eia_pudl_utilities')
    op.drop_table('core_pudl__assn_eia_pudl_plants')
    op.drop_table('core_ferc714__yearly_planning_area_demand_forecast')
    op.drop_table('core_eia__entity_generators')
    op.drop_table('core_eia__entity_boilers')
    op.drop_table('core_eia__codes_balancing_authority_subregions')
    op.drop_table('core_eia923__monthly_generation_fuel_nuclear')
    op.drop_table('core_eia923__monthly_generation_fuel')
    op.drop_table('core_eia923__monthly_energy_storage')
    op.drop_table('core_eia923__entity_coalmine')
    op.drop_table('core_eia861__yearly_utility_data_rto')
    op.drop_table('core_eia861__yearly_utility_data_nerc')
    op.drop_table('core_eia861__yearly_utility_data_misc')
    op.drop_table('core_eia861__yearly_short_form')
    op.drop_table('core_eia861__yearly_service_territory')
    op.drop_table('core_eia861__yearly_sales')
    op.drop_table('core_eia861__yearly_reliability')
    op.drop_table('core_eia861__yearly_operational_data_revenue')
    op.drop_table('core_eia861__yearly_operational_data_misc')
    op.drop_table('core_eia861__yearly_non_net_metering_misc')
    op.drop_table('core_eia861__yearly_non_net_metering_customer_fuel_class')
    op.drop_table('core_eia861__yearly_net_metering_misc')
    op.drop_table('core_eia861__yearly_net_metering_customer_fuel_class')
    op.drop_table('core_eia861__yearly_mergers')
    op.drop_table('core_eia861__yearly_green_pricing')
    op.drop_table('core_eia861__yearly_energy_efficiency')
    op.drop_table('core_eia861__yearly_dynamic_pricing')
    op.drop_table('core_eia861__yearly_distribution_systems')
    op.drop_table('core_eia861__yearly_distributed_generation_tech')
    op.drop_table('core_eia861__yearly_distributed_generation_misc')
    op.drop_table('core_eia861__yearly_distributed_generation_fuel')
    op.drop_table('core_eia861__yearly_demand_side_management_sales')
    op.drop_table('core_eia861__yearly_demand_side_management_misc')
    op.drop_table('core_eia861__yearly_demand_side_management_ee_dr')
    op.drop_table('core_eia861__yearly_demand_response_water_heater')
    op.drop_table('core_eia861__yearly_demand_response')
    op.drop_table('core_eia861__yearly_advanced_metering_infrastructure')
    op.drop_table('core_eia860m__changelog_generators')
    op.drop_table('core_eia860__scd_utilities')
    op.drop_table('core_eia860__scd_emissions_control_equipment')
    op.drop_table('_out_eia__monthly_heat_rate_by_unit')
    op.drop_table('_core_eia923__fgd_operation_maintenance')
    op.drop_table('_core_eia923__cooling_system_information')
    op.drop_table('out_eia861__yearly_utility_service_territory')
    op.drop_table('out_eia861__yearly_balancing_authority_service_territory')
    op.drop_table('core_pudl__entity_utilities_pudl')
    op.drop_table('core_pudl__entity_plants_pudl')
    op.drop_table('core_pudl__codes_subdivisions')
    op.drop_table('core_pudl__codes_datasources')
    op.drop_table('core_pudl__codes_data_maturities')
    op.drop_table('core_nrelatb__yearly_technology_status')
    op.drop_table('core_nrelatb__yearly_projected_financial_cases_by_scenario')
    op.drop_table('core_nrelatb__yearly_projected_financial_cases')
    op.drop_table('core_nrelatb__yearly_projected_cost_performance')
    op.drop_table('core_ferc__codes_accounts')
    op.drop_table('core_ferc714__respondent_id')
    op.drop_table('core_ferc1__codes_power_purchase_types')
    op.drop_table('core_epa__assn_eia_epacamd_subplant_ids')
    op.drop_table('core_eiaaeo__yearly_projected_generation_in_end_use_sectors_by_fuel_type')
    op.drop_table('core_eiaaeo__yearly_projected_generation_in_electric_sector_by_technology')
    op.drop_table('core_eiaaeo__yearly_projected_fuel_cost_in_electric_sector_by_type')
    op.drop_table('core_eiaaeo__yearly_projected_electric_sales')
    op.drop_table('core_eia__yearly_fuel_receipts_costs_aggs')
    op.drop_table('core_eia__entity_utilities')
    op.drop_table('core_eia__entity_plants')
    op.drop_table('core_eia__codes_wind_quality_class')
    op.drop_table('core_eia__codes_wet_dry_bottom')
    op.drop_table('core_eia__codes_storage_technology_types')
    op.drop_table('core_eia__codes_storage_enclosure_types')
    op.drop_table('core_eia__codes_steam_plant_types')
    op.drop_table('core_eia__codes_sorbent_types')
    op.drop_table('core_eia__codes_so2_units')
    op.drop_table('core_eia__codes_so2_compliance_strategies')
    op.drop_table('core_eia__codes_sector_consolidated')
    op.drop_table('core_eia__codes_reporting_frequencies')
    op.drop_table('core_eia__codes_regulations')
    op.drop_table('core_eia__codes_prime_movers')
    op.drop_table('core_eia__codes_particulate_units')
    op.drop_table('core_eia__codes_particulate_compliance_strategies')
    op.drop_table('core_eia__codes_operational_status')
    op.drop_table('core_eia__codes_nox_units')
    op.drop_table('core_eia__codes_nox_control_status')
    op.drop_table('core_eia__codes_nox_compliance_strategies')
    op.drop_table('core_eia__codes_momentary_interruptions')
    op.drop_table('core_eia__codes_mercury_compliance_strategies')
    op.drop_table('core_eia__codes_fuel_types_agg')
    op.drop_table('core_eia__codes_fuel_transportation_modes')
    op.drop_table('core_eia__codes_firing_types')
    op.drop_table('core_eia__codes_environmental_equipment_manufacturers')
    op.drop_table('core_eia__codes_energy_sources')
    op.drop_table('core_eia__codes_emission_control_equipment_types')
    op.drop_table('core_eia__codes_cooling_water_types')
    op.drop_table('core_eia__codes_cooling_water_sources')
    op.drop_table('core_eia__codes_cooling_tower_types')
    op.drop_table('core_eia__codes_cooling_system_types')
    op.drop_table('core_eia__codes_contract_types')
    op.drop_table('core_eia__codes_coalmine_types')
    op.drop_table('core_eia__codes_boiler_types')
    op.drop_table('core_eia__codes_boiler_status')
    op.drop_table('core_eia__codes_boiler_generator_assn_types')
    op.drop_table('core_eia__codes_balancing_authorities')
    op.drop_table('core_eia__codes_averaging_periods')
    op.drop_table('core_eia861__yearly_balancing_authority')
    op.drop_table('core_eia861__assn_utility')
    op.drop_table('core_eia861__assn_balancing_authority')
    # ### end Alembic commands ###
