"""add planned_repower_date into 860m changelog

Revision ID: aeb66b0b4481
Revises: 5ba8ad3ad527
Create Date: 2025-11-26 13:56:08.558987

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'aeb66b0b4481'
down_revision = '5ba8ad3ad527'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_eia860m__changelog_generators', schema=None) as batch_op:
        batch_op.add_column(sa.Column('planned_repower_date', sa.Date(), nullable=True, comment='Planned effective date that the generator is scheduled to enter operation after the repowering is complete.'))

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_eia860m__changelog_generators', schema=None) as batch_op:
        batch_op.drop_column('planned_repower_date')

    # ### end Alembic commands ###
