"""use sec10k column suffix

Revision ID: ac67e04d1383
Revises: 1189596f92ed
Create Date: 2025-02-04 16:52:10.950619

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'ac67e04d1383'
down_revision = '1189596f92ed'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('out_sec10k__parents_and_subsidiaries', schema=None) as batch_op:
        batch_op.add_column(sa.Column('company_id_sec10k', sa.Text(), nullable=True, comment='PUDL-assigned ID for companies that file SEC Form 10-K or are referenced in exhibit 21 attachments to Form 10-K. May not be stable over time.'))
        batch_op.drop_column('company_id_sec')

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('out_sec10k__parents_and_subsidiaries', schema=None) as batch_op:
        batch_op.add_column(sa.Column('company_id_sec', sa.TEXT(), nullable=True))
        batch_op.drop_column('company_id_sec10k')

    # ### end Alembic commands ###
