"""constrain FERC xbrl factoids

Revision ID: a93bdb8d4fbd
Revises: 57f2bda37a11
Create Date: 2024-09-03 17:15:47.553519

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'a93bdb8d4fbd'
down_revision = '57f2bda37a11'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_ferc1__yearly_cash_flows_sched120', schema=None) as batch_op:
        batch_op.alter_column('amount_type',
               existing_type=sa.TEXT(),
               type_=sa.Enum('cash_provided_by_outside_sources', 'proceeds_from_disposal_of_noncurrent_assets', 'net_increase_decrease_in_inventory_investing_activities', 'gross_additions_to_nuclear_fuel_investing_activities', 'other_adjustments_to_cash_flows_from_investment_activities', 'investment_tax_credit_adjustments_net', 'payments_for_retirement_of_preferred_stock_financing_activities', 'disposition_of_investments_in_and_advances_to_associated_and_subsidiary_companies', 'proceeds_from_issuance_of_preferred_stock_financing_activities', 'net_increase_decrease_in_other_regulatory_liabilities_operating_activities', 'investments_in_and_advances_to_associated_and_subsidiary_companies', 'net_income_loss', 'collections_on_loans', 'contributions_and_advances_from_associated_and_subsidiary_companies', 'cash_flows_provided_from_used_in_financing_activities', 'cash_flows_provided_from_used_in_investment_activities', 'net_increase_decrease_in_payables_and_accrued_expenses_operating_activities', 'loans_made_or_purchased', 'other_adjustments_to_cash_flows_from_operating_activities', 'net_increase_decrease_in_receivables_investing_activities', 'net_increase_decrease_in_payables_and_accrued_expenses_investing_activities', 'other_retirements_of_balances_impacting_cash_flows_from_financing_activities', 'proceeds_from_sales_of_investment_securities', 'payments_for_retirement_abstract', 'proceeds_from_issuance_of_common_stock_financing_activities', 'disposition_of_investments_in_and_advances_to_associated_and_subsidiary_companies_abstract', 'gross_additions_to_nonutility_plant_investing_activities', 'acquisition_of_other_noncurrent_assets', 'ending_balance', 'purchase_of_investment_securities', 'cash_flows_provided_from_used_in_investment_activities_correction', 'net_increase_decrease_in_inventory_operating_activities', 'cash_flows_provided_from_used_in_financing_activities_correction', 'other_adjustments_to_cash_flows_from_financing_activities', 'dividends_on_preferred_stock', 'allowance_for_other_funds_used_during_construction_operating_activities', 'allowance_for_other_funds_used_during_construction_investing_activities', 'other_adjustments_by_outside_sources_to_cash_flows_from_financing_activities', 'net_increase_decrease_in_allowances_inventory_operating_activities', 'cash_outflows_for_plant', 'deferred_income_taxes_net', 'net_increase_decrease_in_cash_and_cash_equivalents_abstract', 'proceeds_from_issuance_of_long_term_debt_financing_activities', 'net_cash_flow_from_operating_activities', 'cash_outflows_for_plant_correction', 'cash_provided_by_outside_sources_correction', 'noncash_adjustments_to_cash_flows_from_operating_activities', 'net_increase_decrease_in_cash_and_cash_equivalents', 'payments_for_retirement_of_long_term_debt_financing_activities', 'undistributed_earnings_from_subsidiary_companies_operating_activities', 'other_construction_and_acquisition_of_plant_investment_activities', 'net_income_loss_correction', 'dividends_on_common_stock', 'net_increase_decrease_in_other_regulatory_assets_operating_activities', 'net_decrease_in_short_term_debt', 'net_increase_in_short_term_debt', 'net_cash_flow_from_operating_activities_correction', 'net_increase_decrease_in_receivables_operating_activities', 'depreciation_and_depletion', 'gross_additions_to_utility_plant_less_nuclear_fuel_investing_activities', 'net_increase_decrease_in_allowances_held_for_speculation_investing_activities', 'gross_additions_to_common_utility_plant_investing_activities', 'payments_for_retirement_of_common_stock_financing_activities', 'starting_balance'),
               existing_nullable=False)

    with op.batch_alter_table('core_ferc1__yearly_depreciation_by_function_sched219', schema=None) as batch_op:
        batch_op.alter_column('depreciation_type',
               existing_type=sa.TEXT(),
               type_=sa.Enum('accumulated_depreciation_subdimension_correction', 'accumulated_depreciation_correction', 'accumulated_depreciation'),
               existing_nullable=False)

    with op.batch_alter_table('core_ferc1__yearly_depreciation_changes_sched219', schema=None) as batch_op:
        batch_op.alter_column('depreciation_type',
               existing_type=sa.TEXT(),
               type_=sa.Enum('depreciation_provision_subdimension_correction', 'depreciation_provision_correction', 'depreciation_expense_for_asset_retirement_costs_correction', 'depreciation_expense_excluding_adjustments_correction', 'book_cost_of_retired_plant', 'depreciation_expense_excluding_adjustments', 'starting_balance_correction', 'net_charges_for_retired_plant_subdimension_correction', 'other_adjustments_to_accumulated_depreciation_correction', 'other_clearing_accounts_subdimension_correction', 'expenses_of_electric_plant_leased_to_others_subdimension_correction', 'expenses_of_electric_plant_leased_to_others', 'depreciation_expense_excluding_adjustments_subdimension_correction', 'other_clearing_accounts_correction', 'other_accounts_subdimension_correction', 'depreciation_expense_for_asset_retirement_costs_subdimension_correction', 'transportation_expenses_clearing_correction', 'net_charges_for_retired_plant', 'depreciation_provision', 'other_accounts', 'transportation_expenses_clearing_subdimension_correction', 'salvage_value_of_retired_plant', 'book_cost_of_retired_plant_correction', 'depreciation_expense_for_asset_retirement_costs', 'net_charges_for_retired_plant_correction', 'salvage_value_of_retired_plant_correction', 'starting_balance_subdimension_correction', 'ending_balance_subdimension_correction', 'book_cost_of_retired_plant_subdimension_correction', 'expenses_of_electric_plant_leased_to_others_correction', 'book_cost_of_asset_retirement_costs_subdimension_correction', 'book_cost_of_asset_retirement_costs_correction', 'other_clearing_accounts', 'transportation_expenses_clearing', 'ending_balance_correction', 'cost_of_removal_of_plant_correction', 'cost_of_removal_of_plant_subdimension_correction', 'ending_balance', 'salvage_value_of_retired_plant_subdimension_correction', 'other_accounts_correction', 'other_adjustments_to_accumulated_depreciation', 'book_cost_of_asset_retirement_costs', 'cost_of_removal_of_plant', 'other_adjustments_to_accumulated_depreciation_subdimension_correction', 'starting_balance'),
               existing_nullable=False)

    with op.batch_alter_table('core_ferc1__yearly_depreciation_summary_sched336', schema=None) as batch_op:
        batch_op.alter_column('ferc_account_label',
               existing_type=sa.TEXT(),
               type_=sa.Enum('depreciation_expense_subdimension_correction', 'amortization_limited_term_electric_plant_correction', 'amortization_limited_term_electric_plant_subdimension_correction', 'depreciation_expense', 'amortization_other_electric_plant', 'depreciation_expense_asset_retirement_subdimension_correction', 'depreciation_expense_asset_retirement_correction', 'depreciation_expense_correction', 'amortization_other_electric_plant_correction', 'depreciation_expense_asset_retirement', 'amortization_limited_term_electric_plant', 'depreciation_amortization_total', 'amortization_other_electric_plant_subdimension_correction', 'depreciation_amortization_total_subdimension_correction', 'depreciation_amortization_total_correction'),
               existing_nullable=False)

    with op.batch_alter_table('core_ferc1__yearly_operating_expenses_sched320', schema=None) as batch_op:
        batch_op.alter_column('expense_type',
               existing_type=sa.TEXT(),
               type_=sa.Enum('maintenance_of_structures', 'station_expenses_transmission_expense', 'street_lighting_and_signal_system_expenses', 'maintenance_of_meters', 'rents_regional_market_expenses', 'market_monitoring_and_compliance', 'load_dispatching_transmission_expense', 'power_purchased_for_storage_operations', 'hydraulic_expenses', 'miscellaneous_steam_power_expenses', 'maintenance_of_street_lighting_and_signal_systems', 'maintenance_of_overhead_lines_transmission', 'customer_records_and_collection_expenses', 'administrative_and_general_operation_expense', 'maintenance_of_miscellaneous_market_operation_plant', 'distribution_expenses_correction', 'maintenance_of_reservoirs_dams_and_waterways', 'load_dispatch_monitor_and_operate_transmission_system', 'operation_supervision_and_engineering_hydraulic_power_generation', 'fuel', 'office_supplies_and_expenses', 'other_power_supply_expense_correction', 'power_production_expenses_other_power', 'hydraulic_power_generation_maintenance_expense_correction', 'administrative_and_general_salaries', 'operation_supervision_and_engineering_steam_power_generation', 'allowances', 'maintenance_of_structures_and_improvements_regional_market_expenses', 'maintenance_of_communication_equipment_electric_transmission', 'operation_of_energy_storage_equipment', 'power_production_expenses_correction', 'operation_supervision_and_engineering_nuclear_power_generation', 'miscellaneous_distribution_expenses', 'maintenance_of_energy_storage_equipment_other_power_generation', 'transmission_maintenance_expense_electric', 'reliability_planning_and_standards_development', 'generation_interconnection_studies', 'informational_and_instructional_advertising_expenses', 'sales_expenses_correction', 'maintenance_of_general_plant', 'maintenance_of_structures_hydraulic_power_generation', 'market_facilitation_monitoring_and_compliance_services', 'transmission_of_electricity_by_others', 'other_power_generation_maintenance_expense', 'transmission_operation_expense_correction', 'maintenance_of_line_transformers', 'rents_nuclear_power_generation', 'maintenance_of_computer_hardware_transmission', 'maintenance_supervision_and_engineering_nuclear_power_generation', 'administrative_and_general_expenses', 'hydraulic_power_generation_maintenance_expense', 'customer_installations_expenses', 'power_production_expenses_hydraulic_power', 'maintenance_supervision_and_engineering', 'power_production_expenses', 'power_production_expenses_nuclear_power', 'customer_service_and_information_expenses', 'ancillary_services_market_administration', 'duplicate_charges_credit', 'distribution_operation_expenses_electric_correction', 'uncollectible_accounts', 'underground_line_expenses_transmission_expense', 'transmission_rights_market_administration', 'electric_expenses_hydraulic_power_generation', 'maintenance_of_electric_plant_steam_power_generation', 'administrative_and_general_expenses_correction', 'load_dispatch_transmission_service_and_scheduling', 'maintenance_of_electric_plant_hydraulic_power_generation', 'maintenance_supervision_and_engineering_electric_transmission_expenses', 'load_dispatching', 'customer_service_and_information_expenses_correction', 'sales_expenses', 'overhead_line_expenses', 'franchise_requirements', 'nuclear_power_generation_operations_expense_correction', 'power_production_expenses_other_power_correction', 'steam_from_other_sources', 'maintenance_of_energy_storage_equipment', 'demonstrating_and_selling_expenses', 'maintenance_of_overhead_lines', 'steam_transferred_credit_nuclear_power_generation', 'maintenance_of_station_equipment_transmission', 'water_for_power', 'maintenance_of_miscellaneous_regional_transmission_plant', 'overhead_line_expense', 'rents_distribution_expense', 'distribution_operation_expenses_electric', 'maintenance_of_miscellaneous_steam_plant', 'hydraulic_power_generation_operations_expense_correction', 'general_advertising_expenses', 'transmission_expenses_correction', 'steam_power_generation_maintenance_expense_correction', 'regional_market_maintenance_expense', 'load_dispatch_reliability', 'transmission_operation_expense', 'distribution_maintenance_expense_electric_correction', 'steam_expenses_steam_power_generation', 'operation_supervision', 'maintenance_of_energy_storage_equipment_transmission', 'capacity_market_administration', 'nuclear_power_generation_operations_expense', 'transmission_maintenance_expense_electric_correction', 'scheduling_system_control_and_dispatch_services', 'maintenance_of_station_equipment', 'electric_expenses_nuclear_power_generation', 'maintenance_of_computer_hardware', 'miscellaneous_other_power_generation_expenses', 'coolants_and_water', 'distribution_expenses', 'maintenance_of_miscellaneous_nuclear_plant', 'regulatory_commission_expenses', 'reliability_planning_and_standards_development_services', 'steam_transferred_credit', 'steam_expenses_nuclear_power_generation', 'injuries_and_damages', 'administrative_expenses_transferred_credit', 'power_production_expenses_steam_power_correction', 'property_insurance', 'regional_market_expenses', 'maintenance_of_computer_software', 'customer_account_expenses', 'rents_transmission_electric_expense', 'day_ahead_and_real_time_market_administration', 'electric_expenses_steam_power_generation', 'maintenance_of_structures_distribution_expense', 'advertising_expenses', 'operation_of_energy_storage_equipment_transmission_expense', 'system_control_and_load_dispatching_electric', 'operation_supervision_and_engineering_electric_transmission_expenses', 'miscellaneous_transmission_expenses', 'other_power_supply_expense', 'other_power_generation_operations_expense', 'maintenance_of_communication_equipment_regional_market_expenses', 'regional_market_operation_expense', 'other_power_generation_maintenance_expense_correction', 'maintenance_of_miscellaneous_other_power_generation_plant', 'miscellaneous_customer_service_and_informational_expenses', 'maintenance_of_miscellaneous_distribution_plant', 'purchased_power', 'meter_expenses', 'station_expenses_distribution', 'miscellaneous_customer_accounts_expenses', 'nuclear_power_generation_maintenance_expense_correction', 'nuclear_power_generation_maintenance_expense', 'transmission_service_studies', 'operation_supervision_and_engineering_distribution_expense', 'regional_market_maintenance_expense_correction', 'miscellaneous_hydraulic_power_generation_expenses', 'power_production_expenses_hydraulic_power_correction', 'regional_market_operation_expense_correction', 'maintenance_supervision_and_engineering_other_power_generation', 'maintenance_supervision_and_engineering_steam_power_generation', 'rents_steam_power_generation', 'nuclear_fuel_expense', 'steam_from_other_sources_nuclear_power_generation', 'maintenance_of_underground_lines_transmission', 'underground_line_expenses', 'customer_assistance_expenses', 'rents_administrative_and_general_expense', 'outside_services_employed', 'rents_hydraulic_power_generation', 'power_production_expenses_nuclear_power_correction', 'operation_supervision_and_engineering_other_power_generation', 'fuel_steam_power_generation', 'power_production_expenses_steam_power', 'maintenance_of_miscellaneous_hydraulic_plant', 'maintenance_of_computer_software_transmission', 'miscellaneous_sales_expenses', 'operation_of_energy_storage_equipment_distribution', 'operations_and_maintenance_expenses_electric_correction', 'maintenance_of_structures_steam_power_generation', 'employee_pensions_and_benefits', 'miscellaneous_general_expenses', 'hydraulic_power_generation_operations_expense', 'maintenance_of_miscellaneous_transmission_plant', 'maintenance_supervision_and_engineering_hydraulic_power_generation', 'steam_power_generation_operations_expense_correction', 'maintenance_of_electric_plant_nuclear_power_generation', 'maintenance_of_structures_nuclear_power_generation', 'maintenance_of_generating_and_electric_plant', 'rents_other_power_generation', 'supervision_customer_account_expenses', 'other_power_generation_operations_expense_correction', 'customer_account_expenses_correction', 'regional_market_expenses_correction', 'maintenance_of_structures_transmission_expense', 'transmission_expenses', 'maintenance_of_reactor_plant_equipment_nuclear_power_generation', 'other_expenses_other_power_supply_expenses', 'generation_expenses', 'supervision_sales_expense', 'miscellaneous_nuclear_power_expenses', 'steam_power_generation_operations_expense', 'distribution_maintenance_expense_electric', 'maintenance_of_underground_lines', 'maintenance_of_boiler_plant_steam_power_generation', 'supervision_customer_service_and_information_expenses', 'operations_and_maintenance_expenses_electric', 'meter_reading_expenses', 'steam_power_generation_maintenance_expense', 'administrative_and_general_operation_expense_correction'),
               existing_nullable=False)

    with op.batch_alter_table('core_ferc1__yearly_operating_revenues_sched300', schema=None) as batch_op:
        batch_op.alter_column('revenue_type',
               existing_type=sa.TEXT(),
               type_=sa.Enum('residential_sales', 'small_or_commercial', 'interdepartmental_rents', 'revenues_from_transmission_of_electricity_of_others', 'interdepartmental_sales_correction', 'revenues_net_of_provision_for_refunds_correction', 'sales_for_resale_correction', 'sales_to_ultimate_consumers_correction', 'other_electric_revenue', 'public_street_and_highway_lighting', 'public_street_and_highway_lighting_correction', 'miscellaneous_revenue', 'sales_for_resale', 'interdepartmental_sales', 'sales_to_ultimate_consumers', 'other_miscellaneous_operating_revenues', 'miscellaneous_service_revenues', 'other_operating_revenues_correction', 'forfeited_discounts', 'sales_to_railroads_and_railways_correction', 'regional_transmission_service_revenues', 'other_sales_to_public_authorities_correction', 'sales_of_water_and_water_power', 'large_or_industrial_correction', 'provision_for_rate_refunds', 'other_operating_revenues', 'sales_of_electricity', 'small_or_commercial_correction', 'sales_to_railroads_and_railways', 'revenues_net_of_provision_for_refunds', 'residential_sales_correction', 'electric_operating_revenues_correction', 'electric_operating_revenues', 'rent_from_electric_property', 'large_or_industrial', 'sales_of_electricity_correction', 'other_sales_to_public_authorities'),
               existing_nullable=False)

    with op.batch_alter_table('core_ferc1__yearly_plant_in_service_sched204', schema=None) as batch_op:
        batch_op.alter_column('ferc_account_label',
               existing_type=sa.TEXT(),
               type_=sa.Enum('structures_and_improvements_hydraulic_production', 'street_lighting_and_signal_systems_distribution_plant', 'electric_plant_in_service_and_completed_construction_not_classified_electric', 'asset_retirement_costs_for_regional_transmission_and_market_operation_plant_regional_transmission_and_market_operation_plant', 'fuel_holders_products_and_accessories_other_production', 'underground_conductors_and_devices_distribution_plant', 'asset_retirement_costs_for_other_production_plant_other_production', 'structures_and_improvements_general_plant', 'transmission_and_market_operation_plant_regional_transmission_and_market_operation_plant_correction', 'general_plant_correction', 'computer_hardware_regional_transmission_and_market_operation_plant', 'roads_and_trails_transmission_plant', 'reservoirs_dams_and_waterways_hydraulic_production', 'asset_retirement_costs_for_transmission_plant_transmission_plant', 'distribution_plant_correction', 'land_and_land_rights_regional_transmission_and_market_operation_plant', 'steam_production_plant', 'intangible_plant', 'asset_retirement_costs_for_nuclear_production_plant_nuclear_production', 'land_and_land_rights_transmission_plant', 'transmission_plant', 'poles_and_fixtures_transmission_plant', 'electric_plant_sold', 'transmission_and_market_operation_plant_regional_transmission_and_market_operation_plant', 'laboratory_equipment_general_plant', 'asset_retirement_costs_for_steam_production_plant_steam_production', 'transportation_equipment_general_plant', 'station_equipment_distribution_plant', 'accessory_electric_equipment_hydraulic_production', 'miscellaneous_power_plant_equipment_other_production', 'turbogenerator_units_steam_production', 'land_and_land_rights_steam_production', 'energy_storage_equipment_other_production', 'prime_movers_other_production', 'tools_shop_and_garage_equipment_general_plant', 'poles_towers_and_fixtures_distribution_plant', 'nuclear_production_plant_correction', 'asset_retirement_costs_for_hydraulic_production_plant_hydraulic_production', 'structures_and_improvements_distribution_plant', 'miscellaneous_power_plant_equipment_hydraulic_production', 'underground_conduit_distribution_plant', 'intangible_plant_correction', 'general_plant_excluding_other_tangible_property_and_asset_retirement_costs_for_general_plant', 'land_and_land_rights_other_production', 'electric_plant_in_service_correction', 'structures_and_improvements_steam_production', 'meters_distribution_plant', 'line_transformers_distribution_plant', 'asset_retirement_costs_for_general_plant_general_plant', 'underground_conduit_transmission_plant', 'energy_storage_equipment_transmission_plant', 'overhead_conductors_and_devices_transmission_plant', 'hydraulic_production_plant', 'transmission_plant_correction', 'generators_other_production', 'miscellaneous_intangible_plant', 'station_equipment_transmission_plant', 'boiler_plant_equipment_steam_production', 'office_furniture_and_equipment_general_plant', 'accessory_electric_equipment_steam_production', 'general_plant_excluding_other_tangible_property_and_asset_retirement_costs_for_general_plant_correction', 'structures_and_improvements_other_production', 'leased_property_on_customer_premises_distribution_plant', 'electric_plant_in_service', 'land_and_land_rights_distribution_plant', 'accessory_electric_equipment_other_production', 'asset_retirement_costs_for_distribution_plant_distribution_plant', 'production_plant_correction', 'structures_and_improvements_regional_transmission_and_market_operation_plant', 'towers_and_fixtures_transmission_plant', 'reactor_plant_equipment_nuclear_production', 'land_and_land_rights_general_plant', 'other_tangible_property_general_plant', 'general_plant', 'services_distribution_plant', 'communication_equipment_regional_transmission_and_market_operation_plant', 'miscellaneous_equipment_general_plant', 'distribution_plant', 'overhead_conductors_and_devices_distribution_plant', 'electric_plant_purchased', 'water_wheels_turbines_and_generators_hydraulic_production', 'turbogenerator_units_nuclear_production', 'accessory_electric_equipment_nuclear_production', 'land_and_land_rights_hydraulic_production', 'roads_railroads_and_bridges_hydraulic_production', 'engines_and_engine_driven_generators_steam_production', 'organization', 'other_production_plant_correction', 'structures_and_improvements_nuclear_production', 'miscellaneous_regional_transmission_and_market_operation_plant_regional_transmission_and_market_operation_plant', 'electric_plant_in_service_and_completed_construction_not_classified_electric_correction', 'power_operated_equipment_general_plant', 'communication_equipment_general_plant', 'underground_conductors_and_devices_transmission_plant', 'franchises_and_consents', 'nuclear_production_plant', 'structures_and_improvements_transmission_plant', 'experimental_electric_plant_unclassified', 'energy_storage_equipment_distribution_plant', 'other_production_plant', 'steam_production_plant_correction', 'stores_equipment_general_plant', 'production_plant', 'miscellaneous_power_plant_equipment_nuclear_production', 'computer_software_regional_transmission_and_market_operation_plant', 'installations_on_customer_premises_distribution_plant', 'hydraulic_production_plant_correction', 'miscellaneous_power_plant_equipment_steam_production', 'land_and_land_rights_nuclear_production'),
               existing_nullable=False)

    with op.batch_alter_table('core_ferc1__yearly_retained_earnings_sched118', schema=None) as batch_op:
        batch_op.alter_column('earnings_type',
               existing_type=sa.TEXT(),
               type_=sa.Enum('appropriated_retained_earnings', 'changes_unappropriated_undistributed_subsidiary_earnings_credits', 'retained_earnings_correction', 'unappropriated_undistributed_subsidiary_earnings_previous_year', 'balance_transferred_from_income', 'appropriated_retained_earnings_amortization_reserve_federal', 'adjustments_to_retained_earnings_credit', 'appropriated_retained_earnings_including_reserve_amortization_correction', 'equity_in_earnings_of_subsidiary_companies', 'unappropriated_retained_earnings_correction', 'unappropriated_retained_earnings_previous_year', 'dividends_declared_preferred_stock', 'unappropriated_retained_earnings', 'unappropriated_undistributed_subsidiary_earnings_correction', 'dividends_received', 'transfers_from_unappropriated_undistributed_subsidiary_earnings', 'unappropriated_undistributed_subsidiary_earnings', 'retained_earnings', 'dividends_declared_common_stock', 'appropriated_retained_earnings_including_reserve_amortization', 'adjustments_to_retained_earnings_debit', 'appropriations_of_retained_earnings'),
               existing_nullable=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_ferc1__yearly_retained_earnings_sched118', schema=None) as batch_op:
        batch_op.alter_column('earnings_type',
               existing_type=sa.Enum('appropriated_retained_earnings', 'changes_unappropriated_undistributed_subsidiary_earnings_credits', 'retained_earnings_correction', 'unappropriated_undistributed_subsidiary_earnings_previous_year', 'balance_transferred_from_income', 'appropriated_retained_earnings_amortization_reserve_federal', 'adjustments_to_retained_earnings_credit', 'appropriated_retained_earnings_including_reserve_amortization_correction', 'equity_in_earnings_of_subsidiary_companies', 'unappropriated_retained_earnings_correction', 'unappropriated_retained_earnings_previous_year', 'dividends_declared_preferred_stock', 'unappropriated_retained_earnings', 'unappropriated_undistributed_subsidiary_earnings_correction', 'dividends_received', 'transfers_from_unappropriated_undistributed_subsidiary_earnings', 'unappropriated_undistributed_subsidiary_earnings', 'retained_earnings', 'dividends_declared_common_stock', 'appropriated_retained_earnings_including_reserve_amortization', 'adjustments_to_retained_earnings_debit', 'appropriations_of_retained_earnings'),
               type_=sa.TEXT(),
               existing_nullable=False)

    with op.batch_alter_table('core_ferc1__yearly_plant_in_service_sched204', schema=None) as batch_op:
        batch_op.alter_column('ferc_account_label',
               existing_type=sa.Enum('structures_and_improvements_hydraulic_production', 'street_lighting_and_signal_systems_distribution_plant', 'electric_plant_in_service_and_completed_construction_not_classified_electric', 'asset_retirement_costs_for_regional_transmission_and_market_operation_plant_regional_transmission_and_market_operation_plant', 'fuel_holders_products_and_accessories_other_production', 'underground_conductors_and_devices_distribution_plant', 'asset_retirement_costs_for_other_production_plant_other_production', 'structures_and_improvements_general_plant', 'transmission_and_market_operation_plant_regional_transmission_and_market_operation_plant_correction', 'general_plant_correction', 'computer_hardware_regional_transmission_and_market_operation_plant', 'roads_and_trails_transmission_plant', 'reservoirs_dams_and_waterways_hydraulic_production', 'asset_retirement_costs_for_transmission_plant_transmission_plant', 'distribution_plant_correction', 'land_and_land_rights_regional_transmission_and_market_operation_plant', 'steam_production_plant', 'intangible_plant', 'asset_retirement_costs_for_nuclear_production_plant_nuclear_production', 'land_and_land_rights_transmission_plant', 'transmission_plant', 'poles_and_fixtures_transmission_plant', 'electric_plant_sold', 'transmission_and_market_operation_plant_regional_transmission_and_market_operation_plant', 'laboratory_equipment_general_plant', 'asset_retirement_costs_for_steam_production_plant_steam_production', 'transportation_equipment_general_plant', 'station_equipment_distribution_plant', 'accessory_electric_equipment_hydraulic_production', 'miscellaneous_power_plant_equipment_other_production', 'turbogenerator_units_steam_production', 'land_and_land_rights_steam_production', 'energy_storage_equipment_other_production', 'prime_movers_other_production', 'tools_shop_and_garage_equipment_general_plant', 'poles_towers_and_fixtures_distribution_plant', 'nuclear_production_plant_correction', 'asset_retirement_costs_for_hydraulic_production_plant_hydraulic_production', 'structures_and_improvements_distribution_plant', 'miscellaneous_power_plant_equipment_hydraulic_production', 'underground_conduit_distribution_plant', 'intangible_plant_correction', 'general_plant_excluding_other_tangible_property_and_asset_retirement_costs_for_general_plant', 'land_and_land_rights_other_production', 'electric_plant_in_service_correction', 'structures_and_improvements_steam_production', 'meters_distribution_plant', 'line_transformers_distribution_plant', 'asset_retirement_costs_for_general_plant_general_plant', 'underground_conduit_transmission_plant', 'energy_storage_equipment_transmission_plant', 'overhead_conductors_and_devices_transmission_plant', 'hydraulic_production_plant', 'transmission_plant_correction', 'generators_other_production', 'miscellaneous_intangible_plant', 'station_equipment_transmission_plant', 'boiler_plant_equipment_steam_production', 'office_furniture_and_equipment_general_plant', 'accessory_electric_equipment_steam_production', 'general_plant_excluding_other_tangible_property_and_asset_retirement_costs_for_general_plant_correction', 'structures_and_improvements_other_production', 'leased_property_on_customer_premises_distribution_plant', 'electric_plant_in_service', 'land_and_land_rights_distribution_plant', 'accessory_electric_equipment_other_production', 'asset_retirement_costs_for_distribution_plant_distribution_plant', 'production_plant_correction', 'structures_and_improvements_regional_transmission_and_market_operation_plant', 'towers_and_fixtures_transmission_plant', 'reactor_plant_equipment_nuclear_production', 'land_and_land_rights_general_plant', 'other_tangible_property_general_plant', 'general_plant', 'services_distribution_plant', 'communication_equipment_regional_transmission_and_market_operation_plant', 'miscellaneous_equipment_general_plant', 'distribution_plant', 'overhead_conductors_and_devices_distribution_plant', 'electric_plant_purchased', 'water_wheels_turbines_and_generators_hydraulic_production', 'turbogenerator_units_nuclear_production', 'accessory_electric_equipment_nuclear_production', 'land_and_land_rights_hydraulic_production', 'roads_railroads_and_bridges_hydraulic_production', 'engines_and_engine_driven_generators_steam_production', 'organization', 'other_production_plant_correction', 'structures_and_improvements_nuclear_production', 'miscellaneous_regional_transmission_and_market_operation_plant_regional_transmission_and_market_operation_plant', 'electric_plant_in_service_and_completed_construction_not_classified_electric_correction', 'power_operated_equipment_general_plant', 'communication_equipment_general_plant', 'underground_conductors_and_devices_transmission_plant', 'franchises_and_consents', 'nuclear_production_plant', 'structures_and_improvements_transmission_plant', 'experimental_electric_plant_unclassified', 'energy_storage_equipment_distribution_plant', 'other_production_plant', 'steam_production_plant_correction', 'stores_equipment_general_plant', 'production_plant', 'miscellaneous_power_plant_equipment_nuclear_production', 'computer_software_regional_transmission_and_market_operation_plant', 'installations_on_customer_premises_distribution_plant', 'hydraulic_production_plant_correction', 'miscellaneous_power_plant_equipment_steam_production', 'land_and_land_rights_nuclear_production'),
               type_=sa.TEXT(),
               existing_nullable=False)

    with op.batch_alter_table('core_ferc1__yearly_operating_revenues_sched300', schema=None) as batch_op:
        batch_op.alter_column('revenue_type',
               existing_type=sa.Enum('residential_sales', 'small_or_commercial', 'interdepartmental_rents', 'revenues_from_transmission_of_electricity_of_others', 'interdepartmental_sales_correction', 'revenues_net_of_provision_for_refunds_correction', 'sales_for_resale_correction', 'sales_to_ultimate_consumers_correction', 'other_electric_revenue', 'public_street_and_highway_lighting', 'public_street_and_highway_lighting_correction', 'miscellaneous_revenue', 'sales_for_resale', 'interdepartmental_sales', 'sales_to_ultimate_consumers', 'other_miscellaneous_operating_revenues', 'miscellaneous_service_revenues', 'other_operating_revenues_correction', 'forfeited_discounts', 'sales_to_railroads_and_railways_correction', 'regional_transmission_service_revenues', 'other_sales_to_public_authorities_correction', 'sales_of_water_and_water_power', 'large_or_industrial_correction', 'provision_for_rate_refunds', 'other_operating_revenues', 'sales_of_electricity', 'small_or_commercial_correction', 'sales_to_railroads_and_railways', 'revenues_net_of_provision_for_refunds', 'residential_sales_correction', 'electric_operating_revenues_correction', 'electric_operating_revenues', 'rent_from_electric_property', 'large_or_industrial', 'sales_of_electricity_correction', 'other_sales_to_public_authorities'),
               type_=sa.TEXT(),
               existing_nullable=False)

    with op.batch_alter_table('core_ferc1__yearly_operating_expenses_sched320', schema=None) as batch_op:
        batch_op.alter_column('expense_type',
               existing_type=sa.Enum('maintenance_of_structures', 'station_expenses_transmission_expense', 'street_lighting_and_signal_system_expenses', 'maintenance_of_meters', 'rents_regional_market_expenses', 'market_monitoring_and_compliance', 'load_dispatching_transmission_expense', 'power_purchased_for_storage_operations', 'hydraulic_expenses', 'miscellaneous_steam_power_expenses', 'maintenance_of_street_lighting_and_signal_systems', 'maintenance_of_overhead_lines_transmission', 'customer_records_and_collection_expenses', 'administrative_and_general_operation_expense', 'maintenance_of_miscellaneous_market_operation_plant', 'distribution_expenses_correction', 'maintenance_of_reservoirs_dams_and_waterways', 'load_dispatch_monitor_and_operate_transmission_system', 'operation_supervision_and_engineering_hydraulic_power_generation', 'fuel', 'office_supplies_and_expenses', 'other_power_supply_expense_correction', 'power_production_expenses_other_power', 'hydraulic_power_generation_maintenance_expense_correction', 'administrative_and_general_salaries', 'operation_supervision_and_engineering_steam_power_generation', 'allowances', 'maintenance_of_structures_and_improvements_regional_market_expenses', 'maintenance_of_communication_equipment_electric_transmission', 'operation_of_energy_storage_equipment', 'power_production_expenses_correction', 'operation_supervision_and_engineering_nuclear_power_generation', 'miscellaneous_distribution_expenses', 'maintenance_of_energy_storage_equipment_other_power_generation', 'transmission_maintenance_expense_electric', 'reliability_planning_and_standards_development', 'generation_interconnection_studies', 'informational_and_instructional_advertising_expenses', 'sales_expenses_correction', 'maintenance_of_general_plant', 'maintenance_of_structures_hydraulic_power_generation', 'market_facilitation_monitoring_and_compliance_services', 'transmission_of_electricity_by_others', 'other_power_generation_maintenance_expense', 'transmission_operation_expense_correction', 'maintenance_of_line_transformers', 'rents_nuclear_power_generation', 'maintenance_of_computer_hardware_transmission', 'maintenance_supervision_and_engineering_nuclear_power_generation', 'administrative_and_general_expenses', 'hydraulic_power_generation_maintenance_expense', 'customer_installations_expenses', 'power_production_expenses_hydraulic_power', 'maintenance_supervision_and_engineering', 'power_production_expenses', 'power_production_expenses_nuclear_power', 'customer_service_and_information_expenses', 'ancillary_services_market_administration', 'duplicate_charges_credit', 'distribution_operation_expenses_electric_correction', 'uncollectible_accounts', 'underground_line_expenses_transmission_expense', 'transmission_rights_market_administration', 'electric_expenses_hydraulic_power_generation', 'maintenance_of_electric_plant_steam_power_generation', 'administrative_and_general_expenses_correction', 'load_dispatch_transmission_service_and_scheduling', 'maintenance_of_electric_plant_hydraulic_power_generation', 'maintenance_supervision_and_engineering_electric_transmission_expenses', 'load_dispatching', 'customer_service_and_information_expenses_correction', 'sales_expenses', 'overhead_line_expenses', 'franchise_requirements', 'nuclear_power_generation_operations_expense_correction', 'power_production_expenses_other_power_correction', 'steam_from_other_sources', 'maintenance_of_energy_storage_equipment', 'demonstrating_and_selling_expenses', 'maintenance_of_overhead_lines', 'steam_transferred_credit_nuclear_power_generation', 'maintenance_of_station_equipment_transmission', 'water_for_power', 'maintenance_of_miscellaneous_regional_transmission_plant', 'overhead_line_expense', 'rents_distribution_expense', 'distribution_operation_expenses_electric', 'maintenance_of_miscellaneous_steam_plant', 'hydraulic_power_generation_operations_expense_correction', 'general_advertising_expenses', 'transmission_expenses_correction', 'steam_power_generation_maintenance_expense_correction', 'regional_market_maintenance_expense', 'load_dispatch_reliability', 'transmission_operation_expense', 'distribution_maintenance_expense_electric_correction', 'steam_expenses_steam_power_generation', 'operation_supervision', 'maintenance_of_energy_storage_equipment_transmission', 'capacity_market_administration', 'nuclear_power_generation_operations_expense', 'transmission_maintenance_expense_electric_correction', 'scheduling_system_control_and_dispatch_services', 'maintenance_of_station_equipment', 'electric_expenses_nuclear_power_generation', 'maintenance_of_computer_hardware', 'miscellaneous_other_power_generation_expenses', 'coolants_and_water', 'distribution_expenses', 'maintenance_of_miscellaneous_nuclear_plant', 'regulatory_commission_expenses', 'reliability_planning_and_standards_development_services', 'steam_transferred_credit', 'steam_expenses_nuclear_power_generation', 'injuries_and_damages', 'administrative_expenses_transferred_credit', 'power_production_expenses_steam_power_correction', 'property_insurance', 'regional_market_expenses', 'maintenance_of_computer_software', 'customer_account_expenses', 'rents_transmission_electric_expense', 'day_ahead_and_real_time_market_administration', 'electric_expenses_steam_power_generation', 'maintenance_of_structures_distribution_expense', 'advertising_expenses', 'operation_of_energy_storage_equipment_transmission_expense', 'system_control_and_load_dispatching_electric', 'operation_supervision_and_engineering_electric_transmission_expenses', 'miscellaneous_transmission_expenses', 'other_power_supply_expense', 'other_power_generation_operations_expense', 'maintenance_of_communication_equipment_regional_market_expenses', 'regional_market_operation_expense', 'other_power_generation_maintenance_expense_correction', 'maintenance_of_miscellaneous_other_power_generation_plant', 'miscellaneous_customer_service_and_informational_expenses', 'maintenance_of_miscellaneous_distribution_plant', 'purchased_power', 'meter_expenses', 'station_expenses_distribution', 'miscellaneous_customer_accounts_expenses', 'nuclear_power_generation_maintenance_expense_correction', 'nuclear_power_generation_maintenance_expense', 'transmission_service_studies', 'operation_supervision_and_engineering_distribution_expense', 'regional_market_maintenance_expense_correction', 'miscellaneous_hydraulic_power_generation_expenses', 'power_production_expenses_hydraulic_power_correction', 'regional_market_operation_expense_correction', 'maintenance_supervision_and_engineering_other_power_generation', 'maintenance_supervision_and_engineering_steam_power_generation', 'rents_steam_power_generation', 'nuclear_fuel_expense', 'steam_from_other_sources_nuclear_power_generation', 'maintenance_of_underground_lines_transmission', 'underground_line_expenses', 'customer_assistance_expenses', 'rents_administrative_and_general_expense', 'outside_services_employed', 'rents_hydraulic_power_generation', 'power_production_expenses_nuclear_power_correction', 'operation_supervision_and_engineering_other_power_generation', 'fuel_steam_power_generation', 'power_production_expenses_steam_power', 'maintenance_of_miscellaneous_hydraulic_plant', 'maintenance_of_computer_software_transmission', 'miscellaneous_sales_expenses', 'operation_of_energy_storage_equipment_distribution', 'operations_and_maintenance_expenses_electric_correction', 'maintenance_of_structures_steam_power_generation', 'employee_pensions_and_benefits', 'miscellaneous_general_expenses', 'hydraulic_power_generation_operations_expense', 'maintenance_of_miscellaneous_transmission_plant', 'maintenance_supervision_and_engineering_hydraulic_power_generation', 'steam_power_generation_operations_expense_correction', 'maintenance_of_electric_plant_nuclear_power_generation', 'maintenance_of_structures_nuclear_power_generation', 'maintenance_of_generating_and_electric_plant', 'rents_other_power_generation', 'supervision_customer_account_expenses', 'other_power_generation_operations_expense_correction', 'customer_account_expenses_correction', 'regional_market_expenses_correction', 'maintenance_of_structures_transmission_expense', 'transmission_expenses', 'maintenance_of_reactor_plant_equipment_nuclear_power_generation', 'other_expenses_other_power_supply_expenses', 'generation_expenses', 'supervision_sales_expense', 'miscellaneous_nuclear_power_expenses', 'steam_power_generation_operations_expense', 'distribution_maintenance_expense_electric', 'maintenance_of_underground_lines', 'maintenance_of_boiler_plant_steam_power_generation', 'supervision_customer_service_and_information_expenses', 'operations_and_maintenance_expenses_electric', 'meter_reading_expenses', 'steam_power_generation_maintenance_expense', 'administrative_and_general_operation_expense_correction'),
               type_=sa.TEXT(),
               existing_nullable=False)

    with op.batch_alter_table('core_ferc1__yearly_depreciation_summary_sched336', schema=None) as batch_op:
        batch_op.alter_column('ferc_account_label',
               existing_type=sa.Enum('depreciation_expense_subdimension_correction', 'amortization_limited_term_electric_plant_correction', 'amortization_limited_term_electric_plant_subdimension_correction', 'depreciation_expense', 'amortization_other_electric_plant', 'depreciation_expense_asset_retirement_subdimension_correction', 'depreciation_expense_asset_retirement_correction', 'depreciation_expense_correction', 'amortization_other_electric_plant_correction', 'depreciation_expense_asset_retirement', 'amortization_limited_term_electric_plant', 'depreciation_amortization_total', 'amortization_other_electric_plant_subdimension_correction', 'depreciation_amortization_total_subdimension_correction', 'depreciation_amortization_total_correction'),
               type_=sa.TEXT(),
               existing_nullable=False)

    with op.batch_alter_table('core_ferc1__yearly_depreciation_changes_sched219', schema=None) as batch_op:
        batch_op.alter_column('depreciation_type',
               existing_type=sa.Enum('depreciation_provision_subdimension_correction', 'depreciation_provision_correction', 'depreciation_expense_for_asset_retirement_costs_correction', 'depreciation_expense_excluding_adjustments_correction', 'book_cost_of_retired_plant', 'depreciation_expense_excluding_adjustments', 'starting_balance_correction', 'net_charges_for_retired_plant_subdimension_correction', 'other_adjustments_to_accumulated_depreciation_correction', 'other_clearing_accounts_subdimension_correction', 'expenses_of_electric_plant_leased_to_others_subdimension_correction', 'expenses_of_electric_plant_leased_to_others', 'depreciation_expense_excluding_adjustments_subdimension_correction', 'other_clearing_accounts_correction', 'other_accounts_subdimension_correction', 'depreciation_expense_for_asset_retirement_costs_subdimension_correction', 'transportation_expenses_clearing_correction', 'net_charges_for_retired_plant', 'depreciation_provision', 'other_accounts', 'transportation_expenses_clearing_subdimension_correction', 'salvage_value_of_retired_plant', 'book_cost_of_retired_plant_correction', 'depreciation_expense_for_asset_retirement_costs', 'net_charges_for_retired_plant_correction', 'salvage_value_of_retired_plant_correction', 'starting_balance_subdimension_correction', 'ending_balance_subdimension_correction', 'book_cost_of_retired_plant_subdimension_correction', 'expenses_of_electric_plant_leased_to_others_correction', 'book_cost_of_asset_retirement_costs_subdimension_correction', 'book_cost_of_asset_retirement_costs_correction', 'other_clearing_accounts', 'transportation_expenses_clearing', 'ending_balance_correction', 'cost_of_removal_of_plant_correction', 'cost_of_removal_of_plant_subdimension_correction', 'ending_balance', 'salvage_value_of_retired_plant_subdimension_correction', 'other_accounts_correction', 'other_adjustments_to_accumulated_depreciation', 'book_cost_of_asset_retirement_costs', 'cost_of_removal_of_plant', 'other_adjustments_to_accumulated_depreciation_subdimension_correction', 'starting_balance'),
               type_=sa.TEXT(),
               existing_nullable=False)

    with op.batch_alter_table('core_ferc1__yearly_depreciation_by_function_sched219', schema=None) as batch_op:
        batch_op.alter_column('depreciation_type',
               existing_type=sa.Enum('accumulated_depreciation_subdimension_correction', 'accumulated_depreciation_correction', 'accumulated_depreciation'),
               type_=sa.TEXT(),
               existing_nullable=False)

    with op.batch_alter_table('core_ferc1__yearly_cash_flows_sched120', schema=None) as batch_op:
        batch_op.alter_column('amount_type',
               existing_type=sa.Enum('cash_provided_by_outside_sources', 'proceeds_from_disposal_of_noncurrent_assets', 'net_increase_decrease_in_inventory_investing_activities', 'gross_additions_to_nuclear_fuel_investing_activities', 'other_adjustments_to_cash_flows_from_investment_activities', 'investment_tax_credit_adjustments_net', 'payments_for_retirement_of_preferred_stock_financing_activities', 'disposition_of_investments_in_and_advances_to_associated_and_subsidiary_companies', 'proceeds_from_issuance_of_preferred_stock_financing_activities', 'net_increase_decrease_in_other_regulatory_liabilities_operating_activities', 'investments_in_and_advances_to_associated_and_subsidiary_companies', 'net_income_loss', 'collections_on_loans', 'contributions_and_advances_from_associated_and_subsidiary_companies', 'cash_flows_provided_from_used_in_financing_activities', 'cash_flows_provided_from_used_in_investment_activities', 'net_increase_decrease_in_payables_and_accrued_expenses_operating_activities', 'loans_made_or_purchased', 'other_adjustments_to_cash_flows_from_operating_activities', 'net_increase_decrease_in_receivables_investing_activities', 'net_increase_decrease_in_payables_and_accrued_expenses_investing_activities', 'other_retirements_of_balances_impacting_cash_flows_from_financing_activities', 'proceeds_from_sales_of_investment_securities', 'payments_for_retirement_abstract', 'proceeds_from_issuance_of_common_stock_financing_activities', 'disposition_of_investments_in_and_advances_to_associated_and_subsidiary_companies_abstract', 'gross_additions_to_nonutility_plant_investing_activities', 'acquisition_of_other_noncurrent_assets', 'ending_balance', 'purchase_of_investment_securities', 'cash_flows_provided_from_used_in_investment_activities_correction', 'net_increase_decrease_in_inventory_operating_activities', 'cash_flows_provided_from_used_in_financing_activities_correction', 'other_adjustments_to_cash_flows_from_financing_activities', 'dividends_on_preferred_stock', 'allowance_for_other_funds_used_during_construction_operating_activities', 'allowance_for_other_funds_used_during_construction_investing_activities', 'other_adjustments_by_outside_sources_to_cash_flows_from_financing_activities', 'net_increase_decrease_in_allowances_inventory_operating_activities', 'cash_outflows_for_plant', 'deferred_income_taxes_net', 'net_increase_decrease_in_cash_and_cash_equivalents_abstract', 'proceeds_from_issuance_of_long_term_debt_financing_activities', 'net_cash_flow_from_operating_activities', 'cash_outflows_for_plant_correction', 'cash_provided_by_outside_sources_correction', 'noncash_adjustments_to_cash_flows_from_operating_activities', 'net_increase_decrease_in_cash_and_cash_equivalents', 'payments_for_retirement_of_long_term_debt_financing_activities', 'undistributed_earnings_from_subsidiary_companies_operating_activities', 'other_construction_and_acquisition_of_plant_investment_activities', 'net_income_loss_correction', 'dividends_on_common_stock', 'net_increase_decrease_in_other_regulatory_assets_operating_activities', 'net_decrease_in_short_term_debt', 'net_increase_in_short_term_debt', 'net_cash_flow_from_operating_activities_correction', 'net_increase_decrease_in_receivables_operating_activities', 'depreciation_and_depletion', 'gross_additions_to_utility_plant_less_nuclear_fuel_investing_activities', 'net_increase_decrease_in_allowances_held_for_speculation_investing_activities', 'gross_additions_to_common_utility_plant_investing_activities', 'payments_for_retirement_of_common_stock_financing_activities', 'starting_balance'),
               type_=sa.TEXT(),
               existing_nullable=False)

    # ### end Alembic commands ###
