"""Update SEC ownership tables

Revision ID: a4d4a2646d09
Revises: eda43a449586
Create Date: 2025-06-01 10:35:42.727179

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'a4d4a2646d09'
down_revision = 'eda43a449586'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('core_sec10k__assn_exhibit_21_subsidiaries_and_filers',
    sa.Column('subsidiary_company_id_sec10k', sa.Text(), nullable=False, comment="PUDL-assigned ID for subsidiaries found in SEC 10-K Exhibit 21. The ID is created by concatenating the CIK of the company whose filing the subsidiary was found in, the subsidiary company's name, and location of incorporation. It is not guaranteed to be stable across different releases of PUDL and so should never be hard-coded in analyses."),
    sa.Column('central_index_key', sa.Text(), nullable=True, comment='Identifier of the company in SEC database.'),
    sa.PrimaryKeyConstraint('subsidiary_company_id_sec10k', name=op.f('pk_core_sec10k__assn_exhibit_21_subsidiaries_and_filers'))
    )
    op.create_table('out_sec10k__parents_and_subsidiaries',
    sa.Column('filename_sec10k', sa.Text(), nullable=False, comment='Unique portion of the filename associated with the SEC 10-K filing in the EDGAR database. The full source URL can be reconstructed by prepending https://www.sec.gov/Archives/edgar/data/ and adding the .txt file type extension.'),
    sa.Column('subsidiary_company_name', sa.Text(), nullable=True, comment='Name of subsidiary company.'),
    sa.Column('subsidiary_company_location', sa.Text(), nullable=True, comment='Location of subsidiary company. This is the full US state name or country name and occasionally a two digit code that was not mapped to a full name during cleaning.'),
    sa.Column('subsidiary_company_id_sec10k', sa.Text(), nullable=False, comment="PUDL-assigned ID for subsidiaries found in SEC 10-K Exhibit 21. The ID is created by concatenating the CIK of the company whose filing the subsidiary was found in, the subsidiary company's name, and location of incorporation. It is not guaranteed to be stable across different releases of PUDL and so should never be hard-coded in analyses."),
    sa.Column('fraction_owned', sa.Float(), nullable=True, comment='Proportion of generator ownership attributable to this utility.'),
    sa.Column('parent_company_central_index_key', sa.Text(), nullable=True, comment='Central index key (CIK) of the parent company.'),
    sa.Column('parent_company_name', sa.Text(), nullable=True, comment='Name of the parent company.'),
    sa.Column('filing_date', sa.Date(), nullable=True, comment='Date of the day on which the filing was submitted.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('parent_company_phone_number', sa.Text(), nullable=True, comment='Phone number of the parent company.'),
    sa.Column('parent_company_business_city', sa.Text(), nullable=True, comment="City where the parent company's place of business is located."),
    sa.Column('parent_company_business_state', sa.Text(), nullable=True, comment="State where the parent company's place of business is located."),
    sa.Column('parent_company_business_street_address', sa.Text(), nullable=True, comment="Street address of the parent company's place of business."),
    sa.Column('parent_company_business_street_address_2', sa.Text(), nullable=True, comment="Second line of the street address of the parent company's place of business."),
    sa.Column('parent_company_business_zip_code', sa.Text(), nullable=True, comment="Zip code of the parent company's place of business."),
    sa.Column('parent_company_business_zip_code_4', sa.Text(), nullable=True, comment="Zip code suffix of the company's place of business."),
    sa.Column('parent_company_mail_city', sa.Text(), nullable=True, comment="City of the parent company's mailing address."),
    sa.Column('parent_company_mail_state', sa.Text(), nullable=True, comment="State of the parent company's mailing address."),
    sa.Column('parent_company_mail_street_address', sa.Text(), nullable=True, comment="Street portion of the parent company's mailing address."),
    sa.Column('parent_company_mail_street_address_2', sa.Text(), nullable=True, comment="Second line of the street portion of the parent company's mailing address."),
    sa.Column('parent_company_mail_zip_code', sa.Text(), nullable=True, comment="Zip code of the parent company's mailing address."),
    sa.Column('parent_company_mail_zip_code_4', sa.Text(), nullable=True, comment="Zip code suffix of the parent company's mailing address."),
    sa.Column('parent_company_incorporation_state', sa.Text(), nullable=True, comment='Two letter state code where parent company is incorporated.'),
    sa.Column('parent_company_utility_id_eia', sa.Integer(), nullable=True, comment='The EIA utility ID of the parent company.'),
    sa.Column('parent_company_utility_name_eia', sa.Text(), nullable=True, comment='The EIA reported utility name of the parent company.'),
    sa.Column('parent_company_industry_name_sic', sa.Text(), nullable=True, comment="Text description of the parent company's Standard Industrial Classification (SIC)"),
    sa.Column('parent_company_industry_id_sic', sa.Text(), nullable=True, comment="Four-digit Standard Industrial Classification (SIC) code identifying the parent company's primary industry. SIC codes have been replaced by NAICS codes in many applications, but are still used by the SEC. See e.g. https://www.osha.gov/data/sic-manual for code definitions."),
    sa.Column('parent_company_taxpayer_id_irs', sa.Text(), nullable=True, comment='Taxpayer ID of the parent company with the IRS.'),
    sa.Column('subsidiary_company_central_index_key', sa.Text(), nullable=True, comment='Central index key (CIK) of the subsidiary company.'),
    sa.Column('subsidiary_company_phone_number', sa.Text(), nullable=True, comment='Phone number of the subsidiary company.'),
    sa.Column('subsidiary_company_business_city', sa.Text(), nullable=True, comment="City where the subsidiary company's place of business is located."),
    sa.Column('subsidiary_company_business_state', sa.Text(), nullable=True, comment="State where the subsidiary company's place of business is located."),
    sa.Column('subsidiary_company_business_street_address', sa.Text(), nullable=True, comment="Street address of the subsidiary company's place of business."),
    sa.Column('subsidiary_company_business_street_address_2', sa.Text(), nullable=True, comment="Second line of the street address of the subsidiary company's place of business."),
    sa.Column('subsidiary_company_business_zip_code', sa.Text(), nullable=True, comment="Zip code of the subsidiary company's place of business."),
    sa.Column('subsidiary_company_business_zip_code_4', sa.Text(), nullable=True, comment="Zip code suffix of the subsidiary company's place of business."),
    sa.Column('subsidiary_company_mail_city', sa.Text(), nullable=True, comment="City of the subsidiary company's mailing address."),
    sa.Column('subsidiary_company_mail_state', sa.Text(), nullable=True, comment="State of the parent company's mailing address."),
    sa.Column('subsidiary_company_mail_street_address', sa.Text(), nullable=True, comment="Street portion of the subsidiary company's mailing address."),
    sa.Column('subsidiary_company_mail_street_address_2', sa.Text(), nullable=True, comment="Second line of the street portion of the subsidiary company's mailing address."),
    sa.Column('subsidiary_company_mail_zip_code', sa.Text(), nullable=True, comment="Zip code of the subsidiary company's mailing address."),
    sa.Column('subsidiary_company_mail_zip_code_4', sa.Text(), nullable=True, comment="Zip code suffix of the subsidiary company's mailing address."),
    sa.Column('subsidiary_company_incorporation_state', sa.Text(), nullable=True, comment='Two letter state code where subisidary company is incorporated.'),
    sa.Column('subsidiary_company_utility_id_eia', sa.Integer(), nullable=True, comment='The EIA utility ID of the subsidiary company.'),
    sa.Column('subsidiary_company_utility_name_eia', sa.Text(), nullable=True, comment='The EIA reported utility name of the subsidiary company.'),
    sa.Column('subsidiary_company_industry_name_sic', sa.Text(), nullable=True, comment="Text description of the subsidiary company's Standard Industrial Classification (SIC)"),
    sa.Column('subsidiary_company_industry_id_sic', sa.Text(), nullable=True, comment="Four-digit Standard Industrial Classification (SIC) code identifying the subsidiary company's primary industry. SIC codes have been replaced by NAICS codes in many applications, but are still used by the SEC. See e.g. https://www.osha.gov/data/sic-manual for code definitions."),
    sa.Column('subsidiary_company_taxpayer_id_irs', sa.Text(), nullable=True, comment='Taxpayer ID of the subsidiary company with the IRS.'),
    sa.PrimaryKeyConstraint('filename_sec10k', 'subsidiary_company_id_sec10k', name=op.f('pk_out_sec10k__parents_and_subsidiaries'))
    )
    op.create_table('core_sec10k__assn_exhibit_21_subsidiaries_and_eia_utilities',
    sa.Column('subsidiary_company_id_sec10k', sa.Text(), nullable=False, comment="PUDL-assigned ID for subsidiaries found in SEC 10-K Exhibit 21. The ID is created by concatenating the CIK of the company whose filing the subsidiary was found in, the subsidiary company's name, and location of incorporation. It is not guaranteed to be stable across different releases of PUDL and so should never be hard-coded in analyses."),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.ForeignKeyConstraint(['utility_id_eia'], ['core_eia__entity_utilities.utility_id_eia'], name=op.f('fk_core_sec10k__assn_exhibit_21_subsidiaries_and_eia_utilities_utility_id_eia_core_eia__entity_utilities')),
    sa.PrimaryKeyConstraint('subsidiary_company_id_sec10k', name=op.f('pk_core_sec10k__assn_exhibit_21_subsidiaries_and_eia_utilities'))
    )
    op.drop_table('core_sec10k__parents_and_subsidiaries')
    with op.batch_alter_table('core_sec10k__quarterly_company_information', schema=None) as batch_op:
        batch_op.alter_column('central_index_key',
               existing_type=sa.TEXT(),
               nullable=False)
        batch_op.alter_column('filer_count',
               existing_type=sa.INTEGER(),
               nullable=True)

    with op.batch_alter_table('core_sec10k__quarterly_exhibit_21_company_ownership', schema=None) as batch_op:
        batch_op.add_column(sa.Column('subsidiary_company_id_sec10k', sa.Text(), nullable=False, comment="PUDL-assigned ID for subsidiaries found in SEC 10-K Exhibit 21. The ID is created by concatenating the CIK of the company whose filing the subsidiary was found in, the subsidiary company's name, and location of incorporation. It is not guaranteed to be stable across different releases of PUDL and so should never be hard-coded in analyses."))
        batch_op.alter_column('filename_sec10k',
               existing_type=sa.TEXT(),
               nullable=False)
        batch_op.drop_column('report_date')

    with op.batch_alter_table('out_sec10k__quarterly_company_information', schema=None) as batch_op:
        batch_op.alter_column('central_index_key',
               existing_type=sa.TEXT(),
               nullable=False)
        batch_op.alter_column('filer_count',
               existing_type=sa.INTEGER(),
               nullable=True)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('out_sec10k__quarterly_company_information', schema=None) as batch_op:
        batch_op.alter_column('filer_count',
               existing_type=sa.INTEGER(),
               nullable=False)
        batch_op.alter_column('central_index_key',
               existing_type=sa.TEXT(),
               nullable=True)

    with op.batch_alter_table('core_sec10k__quarterly_exhibit_21_company_ownership', schema=None) as batch_op:
        batch_op.add_column(sa.Column('report_date', sa.DATE(), nullable=True))
        batch_op.alter_column('filename_sec10k',
               existing_type=sa.TEXT(),
               nullable=True)
        batch_op.drop_column('subsidiary_company_id_sec10k')

    with op.batch_alter_table('core_sec10k__quarterly_company_information', schema=None) as batch_op:
        batch_op.alter_column('filer_count',
               existing_type=sa.INTEGER(),
               nullable=False)
        batch_op.alter_column('central_index_key',
               existing_type=sa.TEXT(),
               nullable=True)

    op.create_table('core_sec10k__parents_and_subsidiaries',
    sa.Column('company_id_sec10k', sa.TEXT(), nullable=True),
    sa.Column('filename_sec10k', sa.TEXT(), nullable=True),
    sa.Column('report_date', sa.DATE(), nullable=True),
    sa.Column('central_index_key', sa.TEXT(), nullable=True),
    sa.Column('utility_id_eia', sa.INTEGER(), nullable=True),
    sa.Column('street_address', sa.TEXT(), nullable=True),
    sa.Column('address_2', sa.TEXT(), nullable=True),
    sa.Column('city', sa.TEXT(), nullable=True),
    sa.Column('state', sa.TEXT(), nullable=True),
    sa.Column('company_name_raw', sa.TEXT(), nullable=True),
    sa.Column('name_change_date', sa.DATE(), nullable=True),
    sa.Column('company_name_old', sa.TEXT(), nullable=True),
    sa.Column('industry_name_sic', sa.TEXT(), nullable=True),
    sa.Column('industry_id_sic', sa.TEXT(), nullable=True),
    sa.Column('incorporation_state', sa.TEXT(), nullable=True),
    sa.Column('location_of_incorporation', sa.TEXT(), nullable=True),
    sa.Column('taxpayer_id_irs', sa.TEXT(), nullable=True),
    sa.Column('files_sec10k', sa.BOOLEAN(), nullable=True),
    sa.Column('parent_company_central_index_key', sa.TEXT(), nullable=True),
    sa.Column('fraction_owned', sa.FLOAT(), nullable=True)
    )
    op.drop_table('core_sec10k__assn_exhibit_21_subsidiaries_and_eia_utilities')
    op.drop_table('out_sec10k__parents_and_subsidiaries')
    op.drop_table('core_sec10k__assn_exhibit_21_subsidiaries_and_filers')
    # ### end Alembic commands ###
