"""Add BA code and names to denormalized generator tables.

Revision ID: a08df6e8711c
Revises: 0f7ef503eef7
Create Date: 2025-11-17 14:31:29.770995

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'a08df6e8711c'
down_revision = '0f7ef503eef7'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('out_eia__monthly_generators', schema=None) as batch_op:
        batch_op.add_column(sa.Column('balancing_authority_code_eia', sa.Text(), nullable=True, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'))
        batch_op.add_column(sa.Column('balancing_authority_name_eia', sa.Text(), nullable=True, comment='Name of the balancing authority.'))
        batch_op.create_foreign_key(batch_op.f('fk_out_eia__monthly_generators_balancing_authority_code_eia_core_eia__codes_balancing_authorities'), 'core_eia__codes_balancing_authorities', ['balancing_authority_code_eia'], ['code'])

    with op.batch_alter_table('out_eia__yearly_generators', schema=None) as batch_op:
        batch_op.add_column(sa.Column('balancing_authority_code_eia', sa.Text(), nullable=True, comment='EIA short code identifying a balancing authority. May include Canadian and Mexican BAs.'))
        batch_op.add_column(sa.Column('balancing_authority_name_eia', sa.Text(), nullable=True, comment='Name of the balancing authority.'))
        batch_op.create_foreign_key(batch_op.f('fk_out_eia__yearly_generators_balancing_authority_code_eia_core_eia__codes_balancing_authorities'), 'core_eia__codes_balancing_authorities', ['balancing_authority_code_eia'], ['code'])

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('out_eia__yearly_generators', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_out_eia__yearly_generators_balancing_authority_code_eia_core_eia__codes_balancing_authorities'), type_='foreignkey')
        batch_op.drop_column('balancing_authority_name_eia')
        batch_op.drop_column('balancing_authority_code_eia')

    with op.batch_alter_table('out_eia__monthly_generators', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_out_eia__monthly_generators_balancing_authority_code_eia_core_eia__codes_balancing_authorities'), type_='foreignkey')
        batch_op.drop_column('balancing_authority_name_eia')
        batch_op.drop_column('balancing_authority_code_eia')

    # ### end Alembic commands ###
