"""Add EIA 923 byproduct disposition table

Revision ID: 9466571f3daa
Revises: af82802f2b64
Create Date: 2025-07-31 16:07:51.062437

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '9466571f3daa'
down_revision = 'af82802f2b64'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('_core_eia923__yearly_byproduct_disposition',
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('plant_id_eia', sa.Integer(), nullable=False, comment='The unique six-digit facility identification number, also called an ORISPL, assigned by the Energy Information Administration.'),
    sa.Column('byproduct_description', sa.Enum('Ash from coal gasification (IGCC) units', 'Bottom ash from standard boiler units', 'Bottom (bed) ash from FBC units', 'FGD Gypsum', 'Fly ash from FBC units', 'Fly ash from standard boiler/PCD units', 'Fly ash from units with dry FGD', 'Other FGD byproducts', 'Other (specify via footnote on Schedule 9)', 'Steam Sales (MMBtu)'), nullable=False, comment='Description of combustion by-product.'),
    sa.Column('byproduct_units', sa.Enum('mmbtu', 'tons'), nullable=True, comment='Reported unit of measure for combustion byproduct.'),
    sa.Column('disposal_landfill_units', sa.Float(), nullable=True, comment='Disposed by-products in landfill, to the nearest hundred tons or in MMBtu for steam sales.'),
    sa.Column('disposal_offsite_units', sa.Float(), nullable=True, comment='Disposed by-products offsite, to the nearest hundred tons or in MMBtu for steam sales.'),
    sa.Column('disposal_ponds_units', sa.Float(), nullable=True, comment='Disposed by-products in ponds, to the nearest hundred tons or in MMBtu for steam sales.z'),
    sa.Column('sold_units', sa.Float(), nullable=True, comment='Sold by-products, in tons (to the nearest 100 tons) or, for Steam, MMBtu.'),
    sa.Column('stored_offsite_units', sa.Float(), nullable=True, comment='Stored by-products offsite, to the nearest hundred tons or in MMBtu for steam sales.'),
    sa.Column('stored_onsite_units', sa.Float(), nullable=True, comment='Stored by-products onsite, to the nearest hundred tons or in MMBtu for steam sales.'),
    sa.Column('used_offsite_units', sa.Float(), nullable=True, comment='Used offsite by-products, to the nearest hundred tons or in MMBtu for steam sales.'),
    sa.Column('used_onsite_units', sa.Float(), nullable=True, comment='Used onsite by-products, to the nearest hundred tons or in MMBtu for steam sales.'),
    sa.Column('total_disposal_units', sa.Float(), nullable=True, comment='Total by-product disposal, to the nearest hundred tons or in MMBtu for steam sales.'),
    sa.Column('no_byproducts_to_report', sa.Text(), nullable=True, comment="Whether any combustion by-products were produced by a plant. 'Y' indicates no byproducts to report. The 'Y' and 'N' values do not align with expected values of reported byproducts. This column is messy and requires standardization."),
    sa.Column('data_maturity', sa.Text(), nullable=True, comment='Maturity of the source data published by EIA that is reflected in this record. EIA releases data incrementally over time, including monthly updates, annual year-to-date updates, provisional early releases of annual data, and final annual release data that is not expected to change further. Records sourced from multiple upstream EIA datasets may have no well defined data maturity. Records whose values have been inferred within PUDL will also have no data maturity.'),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk__core_eia923__yearly_byproduct_disposition_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk__core_eia923__yearly_byproduct_disposition_plant_id_eia_core_eia__entity_plants')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'report_year', 'byproduct_description', name=op.f('pk__core_eia923__yearly_byproduct_disposition'))
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('_core_eia923__yearly_byproduct_disposition')
    # ### end Alembic commands ###
