"""Rename id_dc_coupled_tightly to is_dc_coupled_tightly

Revision ID: 747f0e7954aa
Revises: fff6efbd14db
Create Date: 2025-07-02 20:00:50.453253

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '747f0e7954aa'
down_revision = 'fff6efbd14db'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_eia860__scd_generators_energy_storage', schema=None) as batch_op:
        batch_op.add_column(sa.Column('is_dc_coupled_tightly', sa.Boolean(), nullable=True, comment='Indicates if this energy storage device is DC tightly coupled (means the energy storage device and the PV system are on the same side of an inverter and the battery cannot charge from the grid).'))
        batch_op.drop_column('id_dc_coupled_tightly')

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_eia860__scd_generators_energy_storage', schema=None) as batch_op:
        batch_op.add_column(sa.Column('id_dc_coupled_tightly', sa.BOOLEAN(), nullable=True))
        batch_op.drop_column('is_dc_coupled_tightly')

    # ### end Alembic commands ###
