"""Remove deprecated intermediate _out tables from PUDL DB.

Revision ID: 74711993da70
Revises: eda43a449586
Create Date: 2025-06-20 22:05:35.733849

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '74711993da70'
down_revision = 'eda43a449586'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('_out_eia__plants_utilities')
    op.drop_table('_out_eia__yearly_heat_rate_by_unit')
    op.drop_table('_out_eia__monthly_capacity_factor_by_generator')
    op.drop_table('_out_eia__yearly_derived_generator_attributes')
    op.drop_table('_out_eia__monthly_heat_rate_by_generator')
    op.drop_table('_out_eia__monthly_heat_rate_by_unit')
    op.drop_table('_out_eia__yearly_generators')
    op.drop_table('_out_eia__monthly_derived_generator_attributes')
    op.drop_table('_out_eia__monthly_fuel_cost_by_generator')
    op.drop_table('_out_ferc1__yearly_plants_utilities')
    op.drop_table('_out_eia__yearly_fuel_cost_by_generator')
    op.drop_table('_out_eia__yearly_capacity_factor_by_generator')
    op.drop_table('_out_eia__yearly_heat_rate_by_generator')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('_out_eia__yearly_heat_rate_by_generator',
    sa.Column('report_date', sa.DATE(), nullable=False),
    sa.Column('plant_id_eia', sa.INTEGER(), nullable=False),
    sa.Column('unit_id_pudl', sa.INTEGER(), nullable=True),
    sa.Column('generator_id', sa.TEXT(), nullable=False),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.FLOAT(), nullable=True),
    sa.Column('fuel_type_code_pudl', sa.VARCHAR(length=7), nullable=True),
    sa.Column('fuel_type_count', sa.INTEGER(), nullable=True),
    sa.Column('prime_mover_code', sa.TEXT(), nullable=True),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk__out_eia__yearly_heat_rate_by_generator_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk__out_eia__yearly_heat_rate_by_generator_prime_mover_code_core_eia__codes_prime_movers')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk__out_eia__yearly_heat_rate_by_generator'))
    )
    op.create_table('_out_eia__yearly_capacity_factor_by_generator',
    sa.Column('report_date', sa.DATE(), nullable=False),
    sa.Column('plant_id_eia', sa.INTEGER(), nullable=False),
    sa.Column('generator_id', sa.TEXT(), nullable=False),
    sa.Column('net_generation_mwh', sa.FLOAT(), nullable=True),
    sa.Column('capacity_mw', sa.FLOAT(), nullable=True),
    sa.Column('capacity_factor', sa.FLOAT(), nullable=True),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk__out_eia__yearly_capacity_factor_by_generator_plant_id_eia_core_eia860__scd_generators')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk__out_eia__yearly_capacity_factor_by_generator'))
    )
    op.create_table('_out_eia__yearly_fuel_cost_by_generator',
    sa.Column('report_date', sa.DATE(), nullable=False),
    sa.Column('plant_id_eia', sa.INTEGER(), nullable=False),
    sa.Column('generator_id', sa.TEXT(), nullable=False),
    sa.Column('unit_id_pudl', sa.INTEGER(), nullable=True),
    sa.Column('plant_name_eia', sa.TEXT(), nullable=True),
    sa.Column('plant_id_pudl', sa.INTEGER(), nullable=True),
    sa.Column('utility_id_eia', sa.INTEGER(), nullable=True),
    sa.Column('utility_name_eia', sa.TEXT(), nullable=True),
    sa.Column('utility_id_pudl', sa.INTEGER(), nullable=True),
    sa.Column('fuel_type_count', sa.INTEGER(), nullable=True),
    sa.Column('fuel_type_code_pudl', sa.VARCHAR(length=7), nullable=True),
    sa.Column('fuel_cost_per_mmbtu', sa.FLOAT(), nullable=True),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.FLOAT(), nullable=True),
    sa.Column('fuel_cost_per_mwh', sa.FLOAT(), nullable=True),
    sa.Column('fuel_cost_per_mmbtu_source', sa.VARCHAR(length=11), nullable=True),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk__out_eia__yearly_fuel_cost_by_generator_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk__out_eia__yearly_fuel_cost_by_generator_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk__out_eia__yearly_fuel_cost_by_generator_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk__out_eia__yearly_fuel_cost_by_generator_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk__out_eia__yearly_fuel_cost_by_generator'))
    )
    op.create_table('_out_ferc1__yearly_plants_utilities',
    sa.Column('utility_id_ferc1', sa.INTEGER(), nullable=False),
    sa.Column('plant_name_ferc1', sa.TEXT(), nullable=False),
    sa.Column('plant_id_pudl', sa.INTEGER(), nullable=True),
    sa.Column('utility_name_ferc1', sa.TEXT(), nullable=True),
    sa.Column('utility_id_pudl', sa.INTEGER(), nullable=True),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk__out_ferc1__yearly_plants_utilities_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_ferc1', 'plant_name_ferc1'], ['core_pudl__assn_ferc1_pudl_plants.utility_id_ferc1', 'core_pudl__assn_ferc1_pudl_plants.plant_name_ferc1'], name=op.f('fk__out_ferc1__yearly_plants_utilities_utility_id_ferc1_core_pudl__assn_ferc1_pudl_plants')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk__out_ferc1__yearly_plants_utilities_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('utility_id_ferc1', 'plant_name_ferc1', name=op.f('pk__out_ferc1__yearly_plants_utilities'))
    )
    op.create_table('_out_eia__monthly_fuel_cost_by_generator',
    sa.Column('report_date', sa.DATE(), nullable=False),
    sa.Column('plant_id_eia', sa.INTEGER(), nullable=False),
    sa.Column('generator_id', sa.TEXT(), nullable=False),
    sa.Column('unit_id_pudl', sa.INTEGER(), nullable=True),
    sa.Column('plant_name_eia', sa.TEXT(), nullable=True),
    sa.Column('plant_id_pudl', sa.INTEGER(), nullable=True),
    sa.Column('utility_id_eia', sa.INTEGER(), nullable=True),
    sa.Column('utility_name_eia', sa.TEXT(), nullable=True),
    sa.Column('utility_id_pudl', sa.INTEGER(), nullable=True),
    sa.Column('fuel_type_count', sa.INTEGER(), nullable=True),
    sa.Column('fuel_type_code_pudl', sa.VARCHAR(length=7), nullable=True),
    sa.Column('fuel_cost_per_mmbtu', sa.FLOAT(), nullable=True),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.FLOAT(), nullable=True),
    sa.Column('fuel_cost_per_mwh', sa.FLOAT(), nullable=True),
    sa.Column('fuel_cost_per_mmbtu_source', sa.VARCHAR(length=11), nullable=True),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk__out_eia__monthly_fuel_cost_by_generator_plant_id_eia_core_eia__entity_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk__out_eia__monthly_fuel_cost_by_generator_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_eia'], ['core_eia__entity_utilities.utility_id_eia'], name=op.f('fk__out_eia__monthly_fuel_cost_by_generator_utility_id_eia_core_eia__entity_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk__out_eia__monthly_fuel_cost_by_generator_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk__out_eia__monthly_fuel_cost_by_generator'))
    )
    op.create_table('_out_eia__monthly_derived_generator_attributes',
    sa.Column('plant_id_eia', sa.INTEGER(), nullable=False),
    sa.Column('generator_id', sa.TEXT(), nullable=False),
    sa.Column('unit_id_pudl', sa.INTEGER(), nullable=True),
    sa.Column('report_date', sa.DATE(), nullable=False),
    sa.Column('capacity_factor', sa.FLOAT(), nullable=True),
    sa.Column('fuel_cost_per_mmbtu', sa.FLOAT(), nullable=True),
    sa.Column('fuel_cost_per_mwh', sa.FLOAT(), nullable=True),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.FLOAT(), nullable=True),
    sa.Column('net_generation_mwh', sa.FLOAT(), nullable=True),
    sa.Column('total_fuel_cost', sa.FLOAT(), nullable=True),
    sa.Column('total_mmbtu', sa.FLOAT(), nullable=True),
    sa.Column('fuel_cost_per_mmbtu_source', sa.VARCHAR(length=11), nullable=True),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk__out_eia__monthly_derived_generator_attributes_plant_id_eia_core_eia__entity_generators')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk__out_eia__monthly_derived_generator_attributes'))
    )
    op.create_table('_out_eia__yearly_generators',
    sa.Column('report_date', sa.DATE(), nullable=False),
    sa.Column('plant_id_eia', sa.INTEGER(), nullable=False),
    sa.Column('plant_id_pudl', sa.INTEGER(), nullable=True),
    sa.Column('plant_name_eia', sa.TEXT(), nullable=True),
    sa.Column('utility_id_eia', sa.INTEGER(), nullable=True),
    sa.Column('utility_id_pudl', sa.INTEGER(), nullable=True),
    sa.Column('utility_name_eia', sa.TEXT(), nullable=True),
    sa.Column('generator_id', sa.TEXT(), nullable=False),
    sa.Column('associated_combined_heat_power', sa.BOOLEAN(), nullable=True),
    sa.Column('bga_source', sa.TEXT(), nullable=True),
    sa.Column('bypass_heat_recovery', sa.BOOLEAN(), nullable=True),
    sa.Column('capacity_mw', sa.FLOAT(), nullable=True),
    sa.Column('carbon_capture', sa.BOOLEAN(), nullable=True),
    sa.Column('city', sa.TEXT(), nullable=True),
    sa.Column('county', sa.TEXT(), nullable=True),
    sa.Column('current_planned_generator_operating_date', sa.DATE(), nullable=True),
    sa.Column('data_maturity', sa.TEXT(), nullable=True),
    sa.Column('deliver_power_transgrid', sa.BOOLEAN(), nullable=True),
    sa.Column('distributed_generation', sa.BOOLEAN(), nullable=True),
    sa.Column('duct_burners', sa.BOOLEAN(), nullable=True),
    sa.Column('energy_source_1_transport_1', sa.TEXT(), nullable=True),
    sa.Column('energy_source_1_transport_2', sa.TEXT(), nullable=True),
    sa.Column('energy_source_1_transport_3', sa.TEXT(), nullable=True),
    sa.Column('energy_source_2_transport_1', sa.TEXT(), nullable=True),
    sa.Column('energy_source_2_transport_2', sa.TEXT(), nullable=True),
    sa.Column('energy_source_2_transport_3', sa.TEXT(), nullable=True),
    sa.Column('energy_source_code_1', sa.TEXT(), nullable=True),
    sa.Column('energy_source_code_2', sa.TEXT(), nullable=True),
    sa.Column('energy_source_code_3', sa.TEXT(), nullable=True),
    sa.Column('energy_source_code_4', sa.TEXT(), nullable=True),
    sa.Column('energy_source_code_5', sa.TEXT(), nullable=True),
    sa.Column('energy_source_code_6', sa.TEXT(), nullable=True),
    sa.Column('energy_storage_capacity_mwh', sa.FLOAT(), nullable=True),
    sa.Column('ferc_qualifying_facility', sa.BOOLEAN(), nullable=True),
    sa.Column('fluidized_bed_tech', sa.BOOLEAN(), nullable=True),
    sa.Column('fuel_type_code_pudl', sa.VARCHAR(length=7), nullable=True),
    sa.Column('fuel_type_count', sa.INTEGER(), nullable=True),
    sa.Column('generator_operating_date', sa.DATE(), nullable=True),
    sa.Column('generator_retirement_date', sa.DATE(), nullable=True),
    sa.Column('latitude', sa.FLOAT(), nullable=True),
    sa.Column('longitude', sa.FLOAT(), nullable=True),
    sa.Column('minimum_load_mw', sa.FLOAT(), nullable=True),
    sa.Column('nameplate_power_factor', sa.FLOAT(), nullable=True),
    sa.Column('net_capacity_mwdc', sa.FLOAT(), nullable=True),
    sa.Column('operating_switch', sa.TEXT(), nullable=True),
    sa.Column('operational_status', sa.TEXT(), nullable=True),
    sa.Column('operational_status_code', sa.TEXT(), nullable=True),
    sa.Column('original_planned_generator_operating_date', sa.DATE(), nullable=True),
    sa.Column('other_combustion_tech', sa.BOOLEAN(), nullable=True),
    sa.Column('other_modifications_date', sa.DATE(), nullable=True),
    sa.Column('other_planned_modifications', sa.BOOLEAN(), nullable=True),
    sa.Column('owned_by_non_utility', sa.BOOLEAN(), nullable=True),
    sa.Column('ownership_code', sa.TEXT(), nullable=True),
    sa.Column('planned_derate_date', sa.DATE(), nullable=True),
    sa.Column('planned_energy_source_code_1', sa.TEXT(), nullable=True),
    sa.Column('planned_generator_retirement_date', sa.DATE(), nullable=True),
    sa.Column('planned_modifications', sa.BOOLEAN(), nullable=True),
    sa.Column('planned_net_summer_capacity_derate_mw', sa.FLOAT(), nullable=True),
    sa.Column('planned_net_summer_capacity_uprate_mw', sa.FLOAT(), nullable=True),
    sa.Column('planned_net_winter_capacity_derate_mw', sa.FLOAT(), nullable=True),
    sa.Column('planned_net_winter_capacity_uprate_mw', sa.FLOAT(), nullable=True),
    sa.Column('planned_new_capacity_mw', sa.FLOAT(), nullable=True),
    sa.Column('planned_new_prime_mover_code', sa.TEXT(), nullable=True),
    sa.Column('planned_repower_date', sa.DATE(), nullable=True),
    sa.Column('planned_uprate_date', sa.DATE(), nullable=True),
    sa.Column('previously_canceled', sa.BOOLEAN(), nullable=True),
    sa.Column('prime_mover_code', sa.TEXT(), nullable=True),
    sa.Column('pulverized_coal_tech', sa.BOOLEAN(), nullable=True),
    sa.Column('reactive_power_output_mvar', sa.FLOAT(), nullable=True),
    sa.Column('rto_iso_lmp_node_id', sa.TEXT(), nullable=True),
    sa.Column('rto_iso_location_wholesale_reporting_id', sa.TEXT(), nullable=True),
    sa.Column('solid_fuel_gasification', sa.BOOLEAN(), nullable=True),
    sa.Column('startup_source_code_1', sa.TEXT(), nullable=True),
    sa.Column('startup_source_code_2', sa.TEXT(), nullable=True),
    sa.Column('startup_source_code_3', sa.TEXT(), nullable=True),
    sa.Column('startup_source_code_4', sa.TEXT(), nullable=True),
    sa.Column('state', sa.TEXT(), nullable=True),
    sa.Column('stoker_tech', sa.BOOLEAN(), nullable=True),
    sa.Column('street_address', sa.TEXT(), nullable=True),
    sa.Column('subcritical_tech', sa.BOOLEAN(), nullable=True),
    sa.Column('summer_capacity_estimate', sa.BOOLEAN(), nullable=True),
    sa.Column('summer_capacity_mw', sa.FLOAT(), nullable=True),
    sa.Column('summer_estimated_capability_mw', sa.FLOAT(), nullable=True),
    sa.Column('supercritical_tech', sa.BOOLEAN(), nullable=True),
    sa.Column('syncronized_transmission_grid', sa.BOOLEAN(), nullable=True),
    sa.Column('technology_description', sa.TEXT(), nullable=True),
    sa.Column('time_cold_shutdown_full_load_code', sa.TEXT(), nullable=True),
    sa.Column('timezone', sa.VARCHAR(length=32), nullable=True),
    sa.Column('topping_bottoming_code', sa.TEXT(), nullable=True),
    sa.Column('turbines_inverters_hydrokinetics', sa.INTEGER(), nullable=True),
    sa.Column('turbines_num', sa.INTEGER(), nullable=True),
    sa.Column('ultrasupercritical_tech', sa.BOOLEAN(), nullable=True),
    sa.Column('unit_id_pudl', sa.INTEGER(), nullable=True),
    sa.Column('uprate_derate_completed_date', sa.DATE(), nullable=True),
    sa.Column('uprate_derate_during_year', sa.BOOLEAN(), nullable=True),
    sa.Column('winter_capacity_estimate', sa.BOOLEAN(), nullable=True),
    sa.Column('winter_capacity_mw', sa.FLOAT(), nullable=True),
    sa.Column('winter_estimated_capability_mw', sa.FLOAT(), nullable=True),
    sa.Column('zip_code', sa.TEXT(), nullable=True),
    sa.Column('can_cofire_fuels', sa.BOOLEAN(), nullable=True),
    sa.Column('can_burn_multiple_fuels', sa.BOOLEAN(), nullable=True),
    sa.Column('can_switch_oil_gas', sa.BOOLEAN(), nullable=True),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk__out_eia__yearly_generators_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['energy_source_1_transport_1'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_1_transport_1_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_1_transport_2'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_1_transport_2_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_1_transport_3'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_1_transport_3_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_2_transport_1'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_2_transport_1_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_2_transport_2'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_2_transport_2_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_2_transport_3'], ['core_eia__codes_fuel_transportation_modes.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_2_transport_3_core_eia__codes_fuel_transportation_modes')),
    sa.ForeignKeyConstraint(['energy_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_2'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_code_2_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_3'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_code_3_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_4'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_code_4_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_5'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_code_5_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['energy_source_code_6'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_energy_source_code_6_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['operational_status_code'], ['core_eia__codes_operational_status.code'], name=op.f('fk__out_eia__yearly_generators_operational_status_code_core_eia__codes_operational_status')),
    sa.ForeignKeyConstraint(['planned_energy_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_planned_energy_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['planned_new_prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk__out_eia__yearly_generators_planned_new_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk__out_eia__yearly_generators_plant_id_eia_core_eia860__scd_generators')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk__out_eia__yearly_generators_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk__out_eia__yearly_generators_prime_mover_code_core_eia__codes_prime_movers')),
    sa.ForeignKeyConstraint(['startup_source_code_1'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_startup_source_code_1_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['startup_source_code_2'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_startup_source_code_2_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['startup_source_code_3'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_startup_source_code_3_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['startup_source_code_4'], ['core_eia__codes_energy_sources.code'], name=op.f('fk__out_eia__yearly_generators_startup_source_code_4_core_eia__codes_energy_sources')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk__out_eia__yearly_generators_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk__out_eia__yearly_generators_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('plant_id_eia', 'generator_id', 'report_date', name=op.f('pk__out_eia__yearly_generators'))
    )
    op.create_table('_out_eia__monthly_heat_rate_by_unit',
    sa.Column('report_date', sa.DATE(), nullable=False),
    sa.Column('plant_id_eia', sa.INTEGER(), nullable=False),
    sa.Column('unit_id_pudl', sa.INTEGER(), nullable=False),
    sa.Column('net_generation_mwh', sa.FLOAT(), nullable=True),
    sa.Column('fuel_consumed_for_electricity_mmbtu', sa.FLOAT(), nullable=True),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.FLOAT(), nullable=True),
    sa.ForeignKeyConstraint(['plant_id_eia'], ['core_eia__entity_plants.plant_id_eia'], name=op.f('fk__out_eia__monthly_heat_rate_by_unit_plant_id_eia_core_eia__entity_plants')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'unit_id_pudl', name=op.f('pk__out_eia__monthly_heat_rate_by_unit'))
    )
    op.create_table('_out_eia__monthly_heat_rate_by_generator',
    sa.Column('report_date', sa.DATE(), nullable=False),
    sa.Column('plant_id_eia', sa.INTEGER(), nullable=False),
    sa.Column('unit_id_pudl', sa.INTEGER(), nullable=True),
    sa.Column('generator_id', sa.TEXT(), nullable=False),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.FLOAT(), nullable=True),
    sa.Column('fuel_type_code_pudl', sa.VARCHAR(length=7), nullable=True),
    sa.Column('fuel_type_count', sa.INTEGER(), nullable=True),
    sa.Column('prime_mover_code', sa.TEXT(), nullable=True),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk__out_eia__monthly_heat_rate_by_generator_plant_id_eia_core_eia__entity_generators')),
    sa.ForeignKeyConstraint(['prime_mover_code'], ['core_eia__codes_prime_movers.code'], name=op.f('fk__out_eia__monthly_heat_rate_by_generator_prime_mover_code_core_eia__codes_prime_movers')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk__out_eia__monthly_heat_rate_by_generator'))
    )
    op.create_table('_out_eia__yearly_derived_generator_attributes',
    sa.Column('plant_id_eia', sa.INTEGER(), nullable=False),
    sa.Column('generator_id', sa.TEXT(), nullable=False),
    sa.Column('unit_id_pudl', sa.INTEGER(), nullable=True),
    sa.Column('report_date', sa.DATE(), nullable=False),
    sa.Column('capacity_factor', sa.FLOAT(), nullable=True),
    sa.Column('fuel_cost_per_mmbtu', sa.FLOAT(), nullable=True),
    sa.Column('fuel_cost_per_mwh', sa.FLOAT(), nullable=True),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.FLOAT(), nullable=True),
    sa.Column('net_generation_mwh', sa.FLOAT(), nullable=True),
    sa.Column('total_fuel_cost', sa.FLOAT(), nullable=True),
    sa.Column('total_mmbtu', sa.FLOAT(), nullable=True),
    sa.Column('fuel_cost_per_mmbtu_source', sa.VARCHAR(length=11), nullable=True),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id', 'report_date'], ['core_eia860__scd_generators.plant_id_eia', 'core_eia860__scd_generators.generator_id', 'core_eia860__scd_generators.report_date'], name=op.f('fk__out_eia__yearly_derived_generator_attributes_plant_id_eia_core_eia860__scd_generators')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk__out_eia__yearly_derived_generator_attributes'))
    )
    op.create_table('_out_eia__monthly_capacity_factor_by_generator',
    sa.Column('report_date', sa.DATE(), nullable=False),
    sa.Column('plant_id_eia', sa.INTEGER(), nullable=False),
    sa.Column('generator_id', sa.TEXT(), nullable=False),
    sa.Column('net_generation_mwh', sa.FLOAT(), nullable=True),
    sa.Column('capacity_mw', sa.FLOAT(), nullable=True),
    sa.Column('capacity_factor', sa.FLOAT(), nullable=True),
    sa.ForeignKeyConstraint(['plant_id_eia', 'generator_id'], ['core_eia__entity_generators.plant_id_eia', 'core_eia__entity_generators.generator_id'], name=op.f('fk__out_eia__monthly_capacity_factor_by_generator_plant_id_eia_core_eia__entity_generators')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'generator_id', name=op.f('pk__out_eia__monthly_capacity_factor_by_generator'))
    )
    op.create_table('_out_eia__yearly_heat_rate_by_unit',
    sa.Column('report_date', sa.DATE(), nullable=False),
    sa.Column('plant_id_eia', sa.INTEGER(), nullable=False),
    sa.Column('unit_id_pudl', sa.INTEGER(), nullable=False),
    sa.Column('net_generation_mwh', sa.FLOAT(), nullable=True),
    sa.Column('fuel_consumed_for_electricity_mmbtu', sa.FLOAT(), nullable=True),
    sa.Column('unit_heat_rate_mmbtu_per_mwh', sa.FLOAT(), nullable=True),
    sa.ForeignKeyConstraint(['plant_id_eia', 'report_date'], ['core_eia860__scd_plants.plant_id_eia', 'core_eia860__scd_plants.report_date'], name=op.f('fk__out_eia__yearly_heat_rate_by_unit_plant_id_eia_core_eia860__scd_plants')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'unit_id_pudl', name=op.f('pk__out_eia__yearly_heat_rate_by_unit'))
    )
    op.create_table('_out_eia__plants_utilities',
    sa.Column('report_date', sa.DATE(), nullable=False),
    sa.Column('plant_id_eia', sa.INTEGER(), nullable=False),
    sa.Column('plant_name_eia', sa.TEXT(), nullable=True),
    sa.Column('plant_id_pudl', sa.INTEGER(), nullable=True),
    sa.Column('utility_id_eia', sa.INTEGER(), nullable=False),
    sa.Column('utility_name_eia', sa.TEXT(), nullable=True),
    sa.Column('utility_id_pudl', sa.INTEGER(), nullable=True),
    sa.Column('data_maturity', sa.TEXT(), nullable=True),
    sa.ForeignKeyConstraint(['data_maturity'], ['core_pudl__codes_data_maturities.code'], name=op.f('fk__out_eia__plants_utilities_data_maturity_core_pudl__codes_data_maturities')),
    sa.ForeignKeyConstraint(['plant_id_eia', 'report_date'], ['core_eia860__scd_plants.plant_id_eia', 'core_eia860__scd_plants.report_date'], name=op.f('fk__out_eia__plants_utilities_plant_id_eia_core_eia860__scd_plants')),
    sa.ForeignKeyConstraint(['plant_id_pudl'], ['core_pudl__entity_plants_pudl.plant_id_pudl'], name=op.f('fk__out_eia__plants_utilities_plant_id_pudl_core_pudl__entity_plants_pudl')),
    sa.ForeignKeyConstraint(['utility_id_eia', 'report_date'], ['core_eia860__scd_utilities.utility_id_eia', 'core_eia860__scd_utilities.report_date'], name=op.f('fk__out_eia__plants_utilities_utility_id_eia_core_eia860__scd_utilities')),
    sa.ForeignKeyConstraint(['utility_id_pudl'], ['core_pudl__entity_utilities_pudl.utility_id_pudl'], name=op.f('fk__out_eia__plants_utilities_utility_id_pudl_core_pudl__entity_utilities_pudl')),
    sa.PrimaryKeyConstraint('report_date', 'plant_id_eia', 'utility_id_eia', name=op.f('pk__out_eia__plants_utilities'))
    )
    # ### end Alembic commands ###
