"""Add operator_utility_id_eia to core_eia860__scd_ownership and out_eia860__yearly_ownership

Revision ID: 58ff77a4079c
Revises: 0d951848efc7
Create Date: 2025-04-01 13:49:45.805984

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '58ff77a4079c'
down_revision = '0d951848efc7'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_eia860__scd_ownership', schema=None) as batch_op:
        batch_op.add_column(sa.Column('operator_utility_id_eia', sa.Integer(), nullable=True, comment='The EIA utility Identification number for the operator utility.'))

    with op.batch_alter_table('out_eia860__yearly_ownership', schema=None) as batch_op:
        batch_op.add_column(sa.Column('operator_utility_id_eia', sa.Integer(), nullable=True, comment='The EIA utility Identification number for the operator utility.'))

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('out_eia860__yearly_ownership', schema=None) as batch_op:
        batch_op.drop_column('operator_utility_id_eia')

    with op.batch_alter_table('core_eia860__scd_ownership', schema=None) as batch_op:
        batch_op.drop_column('operator_utility_id_eia')

    # ### end Alembic commands ###
