"""Add generator_operating_date to 860 changelog table

Revision ID: 52aa9f44b6a7
Revises: 49d2f4f7d7b7
Create Date: 2024-07-29 18:15:06.462350

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '52aa9f44b6a7'
down_revision = '49d2f4f7d7b7'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_eia860m__changelog_generators', schema=None) as batch_op:
        batch_op.add_column(sa.Column('generator_operating_date', sa.Date(), nullable=True, comment='Date the generator began commercial operation. If harvested values are inconsistent, we default to using the most recently reported date.'))

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_eia860m__changelog_generators', schema=None) as batch_op:
        batch_op.drop_column('generator_operating_date')

    # ### end Alembic commands ###
