"""Fix NREL tax credit case enum

Revision ID: 52a6b00f2f0a
Revises: fff6efbd14db
Create Date: 2025-07-03 14:36:45.128024

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '52a6b00f2f0a'
down_revision = 'fff6efbd14db'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_nrelatb__yearly_projected_cost_performance', schema=None) as batch_op:
        batch_op.alter_column('model_tax_credit_case_nrelatb',
               existing_type=sa.VARCHAR(length=6),
               type_=sa.Enum('ITC', 'PTC + ITC', 'PTC'),
               existing_nullable=True)

    with op.batch_alter_table('core_nrelatb__yearly_projected_financial_cases_by_scenario', schema=None) as batch_op:
        batch_op.alter_column('model_tax_credit_case_nrelatb',
               existing_type=sa.VARCHAR(length=6),
               type_=sa.Enum('ITC', 'PTC + ITC', 'PTC'),
               existing_nullable=True)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_nrelatb__yearly_projected_financial_cases_by_scenario', schema=None) as batch_op:
        batch_op.alter_column('model_tax_credit_case_nrelatb',
               existing_type=sa.Enum('ITC', 'PTC + ITC', 'PTC'),
               type_=sa.VARCHAR(length=6),
               existing_nullable=True)

    with op.batch_alter_table('core_nrelatb__yearly_projected_cost_performance', schema=None) as batch_op:
        batch_op.alter_column('model_tax_credit_case_nrelatb',
               existing_type=sa.Enum('ITC', 'PTC + ITC', 'PTC'),
               type_=sa.VARCHAR(length=6),
               existing_nullable=True)

    # ### end Alembic commands ###
