"""Update direct_support plant IDs to integers, create FK relationship between direct support IDs and harvested entities

Revision ID: 49d2f4f7d7b7
Revises: b9b6cb1a5405
Create Date: 2024-06-26 13:38:03.884714

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '49d2f4f7d7b7'
down_revision = 'aee9c15c7394'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_eia860__scd_generators_energy_storage', schema=None) as batch_op:
        batch_op.alter_column('plant_id_eia_direct_support_1',
               existing_type=sa.FLOAT(),
               type_=sa.Integer(),
               existing_nullable=True)
        batch_op.alter_column('plant_id_eia_direct_support_2',
               existing_type=sa.FLOAT(),
               type_=sa.Integer(),
               existing_nullable=True)
        batch_op.alter_column('plant_id_eia_direct_support_3',
               existing_type=sa.FLOAT(),
               type_=sa.Integer(),
               existing_nullable=True)
        batch_op.create_foreign_key(batch_op.f('fk_core_eia860__scd_generators_energy_storage_plant_id_eia_direct_support_2_core_eia__entity_generators'), 'core_eia__entity_generators', ['plant_id_eia_direct_support_2', 'generator_id_direct_support_2'], ['plant_id_eia', 'generator_id'])
        batch_op.create_foreign_key(batch_op.f('fk_core_eia860__scd_generators_energy_storage_plant_id_eia_direct_support_1_core_eia__entity_generators'), 'core_eia__entity_generators', ['plant_id_eia_direct_support_1', 'generator_id_direct_support_1'], ['plant_id_eia', 'generator_id'])
        batch_op.create_foreign_key(batch_op.f('fk_core_eia860__scd_generators_energy_storage_plant_id_eia_direct_support_3_core_eia__entity_generators'), 'core_eia__entity_generators', ['plant_id_eia_direct_support_3', 'generator_id_direct_support_3'], ['plant_id_eia', 'generator_id'])

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_eia860__scd_generators_energy_storage', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_core_eia860__scd_generators_energy_storage_plant_id_eia_direct_support_3_core_eia__entity_generators'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_core_eia860__scd_generators_energy_storage_plant_id_eia_direct_support_1_core_eia__entity_generators'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_core_eia860__scd_generators_energy_storage_plant_id_eia_direct_support_2_core_eia__entity_generators'), type_='foreignkey')
        batch_op.alter_column('plant_id_eia_direct_support_3',
               existing_type=sa.Integer(),
               type_=sa.FLOAT(),
               existing_nullable=True)
        batch_op.alter_column('plant_id_eia_direct_support_2',
               existing_type=sa.Integer(),
               type_=sa.FLOAT(),
               existing_nullable=True)
        batch_op.alter_column('plant_id_eia_direct_support_1',
               existing_type=sa.Integer(),
               type_=sa.FLOAT(),
               existing_nullable=True)

    # ### end Alembic commands ###
