"""add under 1mw and over 1mw to tech enums

Revision ID: 450d100cd30b
Revises: d52742bec92a
Create Date: 2024-10-17 14:37:06.632766

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '450d100cd30b'
down_revision = 'd52742bec92a'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_eia861__yearly_distributed_generation_tech', schema=None) as batch_op:
        batch_op.alter_column('tech_class',
               existing_type=sa.VARCHAR(length=19),
               type_=sa.Enum('backup', 'chp_cogen', 'combustion_turbine', 'fuel_cell', 'hydro', 'internal_combustion', 'other', 'pv', 'steam', 'storage_pv', 'storage_nonpv', 'all_storage', 'total', 'virtual_pv', 'virtual_pv_under_1mw', 'virtual_pv_over_1mw', 'wind'),
               existing_nullable=True)

    with op.batch_alter_table('core_eia861__yearly_net_metering_customer_fuel_class', schema=None) as batch_op:
        batch_op.alter_column('tech_class',
               existing_type=sa.VARCHAR(length=19),
               type_=sa.Enum('backup', 'chp_cogen', 'combustion_turbine', 'fuel_cell', 'hydro', 'internal_combustion', 'other', 'pv', 'steam', 'storage_pv', 'storage_nonpv', 'all_storage', 'total', 'virtual_pv', 'virtual_pv_under_1mw', 'virtual_pv_over_1mw', 'wind'),
               existing_nullable=True)

    with op.batch_alter_table('core_eia861__yearly_non_net_metering_customer_fuel_class', schema=None) as batch_op:
        batch_op.alter_column('tech_class',
               existing_type=sa.VARCHAR(length=19),
               type_=sa.Enum('backup', 'chp_cogen', 'combustion_turbine', 'fuel_cell', 'hydro', 'internal_combustion', 'other', 'pv', 'steam', 'storage_pv', 'storage_nonpv', 'all_storage', 'total', 'virtual_pv', 'virtual_pv_under_1mw', 'virtual_pv_over_1mw', 'wind'),
               existing_nullable=True)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_eia861__yearly_non_net_metering_customer_fuel_class', schema=None) as batch_op:
        batch_op.alter_column('tech_class',
               existing_type=sa.Enum('backup', 'chp_cogen', 'combustion_turbine', 'fuel_cell', 'hydro', 'internal_combustion', 'other', 'pv', 'steam', 'storage_pv', 'storage_nonpv', 'all_storage', 'total', 'virtual_pv', 'virtual_pv_under_1mw', 'virtual_pv_over_1mw', 'wind'),
               type_=sa.VARCHAR(length=19),
               existing_nullable=True)

    with op.batch_alter_table('core_eia861__yearly_net_metering_customer_fuel_class', schema=None) as batch_op:
        batch_op.alter_column('tech_class',
               existing_type=sa.Enum('backup', 'chp_cogen', 'combustion_turbine', 'fuel_cell', 'hydro', 'internal_combustion', 'other', 'pv', 'steam', 'storage_pv', 'storage_nonpv', 'all_storage', 'total', 'virtual_pv', 'virtual_pv_under_1mw', 'virtual_pv_over_1mw', 'wind'),
               type_=sa.VARCHAR(length=19),
               existing_nullable=True)

    with op.batch_alter_table('core_eia861__yearly_distributed_generation_tech', schema=None) as batch_op:
        batch_op.alter_column('tech_class',
               existing_type=sa.Enum('backup', 'chp_cogen', 'combustion_turbine', 'fuel_cell', 'hydro', 'internal_combustion', 'other', 'pv', 'steam', 'storage_pv', 'storage_nonpv', 'all_storage', 'total', 'virtual_pv', 'virtual_pv_under_1mw', 'virtual_pv_over_1mw', 'wind'),
               type_=sa.VARCHAR(length=19),
               existing_nullable=True)

    # ### end Alembic commands ###
