"""add xbrl, dbf util id cols to ferc1 out tables

Revision ID: 341e3c844e85
Revises: af82802f2b64
Create Date: 2025-08-08 14:36:42.355526

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '341e3c844e85'
down_revision = 'af82802f2b64'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('out_ferc1__yearly_all_plants', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_balance_sheet_assets_sched110', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_balance_sheet_liabilities_sched110', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_cash_flows_sched120', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_depreciation_by_function_sched219', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_depreciation_changes_sched219', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_depreciation_summary_sched336', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_detailed_balance_sheet_assets', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_detailed_balance_sheet_liabilities', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_detailed_income_statements', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_energy_dispositions_sched401', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_energy_sources_sched401', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_hydroelectric_plants_sched406', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_income_statements_sched114', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_operating_expenses_sched320', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_operating_revenues_sched300', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_other_regulatory_liabilities_sched278', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_plant_in_service_sched204', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_pumped_storage_plants_sched408', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_purchased_power_and_exchanges_sched326', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_rate_base', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_retained_earnings_sched118', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_sales_by_rate_schedules_sched304', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_small_plants_sched410', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_steam_plants_fuel_by_plant_sched402', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_steam_plants_fuel_sched402', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_steam_plants_sched402', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_transmission_lines_sched422', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    with op.batch_alter_table('out_ferc1__yearly_utility_plant_summary_sched200', schema=None) as batch_op:
        batch_op.add_column(sa.Column('utility_id_ferc1_dbf', sa.Integer(), nullable=True, comment='FERC-assigned respondent_id from DBF reporting years, identifying the reporting entity. Stable from year to year.'))
        batch_op.add_column(sa.Column('utility_id_ferc1_xbrl', sa.Text(), nullable=True, comment='FERC-assigned entity_id from XBRL reporting years, identifying the reporting entity. Stable from year to year.'))

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('out_ferc1__yearly_utility_plant_summary_sched200', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_transmission_lines_sched422', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_steam_plants_sched402', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_steam_plants_fuel_sched402', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_steam_plants_fuel_by_plant_sched402', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_small_plants_sched410', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_sales_by_rate_schedules_sched304', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_retained_earnings_sched118', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_rate_base', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_purchased_power_and_exchanges_sched326', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_pumped_storage_plants_sched408', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_plant_in_service_sched204', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_other_regulatory_liabilities_sched278', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_operating_revenues_sched300', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_operating_expenses_sched320', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_income_statements_sched114', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_hydroelectric_plants_sched406', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_energy_sources_sched401', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_energy_dispositions_sched401', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_detailed_income_statements', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_detailed_balance_sheet_liabilities', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_detailed_balance_sheet_assets', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_depreciation_summary_sched336', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_depreciation_changes_sched219', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_depreciation_by_function_sched219', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_cash_flows_sched120', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_balance_sheet_liabilities_sched110', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_balance_sheet_assets_sched110', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    with op.batch_alter_table('out_ferc1__yearly_all_plants', schema=None) as batch_op:
        batch_op.drop_column('utility_id_ferc1_xbrl')
        batch_op.drop_column('utility_id_ferc1_dbf')

    # ### end Alembic commands ###
