"""Consolidate all SEC 10-K migrations

Revision ID: 2be9c446753f
Revises: 58ff77a4079c
Create Date: 2025-04-06 00:30:28.694044

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '2be9c446753f'
down_revision = '58ff77a4079c'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('core_sec10k__assn_sec10k_filers_and_eia_utilities',
    sa.Column('central_index_key', sa.Text(), nullable=False, comment='Identifier of the company in SEC database.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=False, comment='The EIA Utility Identification number.'),
    sa.PrimaryKeyConstraint('central_index_key', 'utility_id_eia', name=op.f('pk_core_sec10k__assn_sec10k_filers_and_eia_utilities'))
    )
    op.create_table('core_sec10k__changelog_company_name',
    sa.Column('central_index_key', sa.Text(), nullable=False, comment='Identifier of the company in SEC database.'),
    sa.Column('name_change_date', sa.Date(), nullable=False, comment='Date of last name change of the company.'),
    sa.Column('company_name_old', sa.Text(), nullable=True, comment='Name of company prior to name change.'),
    sa.Column('company_name', sa.Text(), nullable=True, comment='Name of company submitting SEC 10k filing.')
    )
    op.create_table('core_sec10k__parents_and_subsidiaries',
    sa.Column('company_id_sec10k', sa.Text(), nullable=True, comment='PUDL-assigned ID for companies that file SEC Form 10-K or are referenced in exhibit 21 attachments to Form 10-K. May not be stable over time.'),
    sa.Column('filename_sec10k', sa.Text(), nullable=True, comment='Unique portion of the filename associated with the SEC 10-K filing in the EDGAR database. The full source URL can be reconstructed by prepending https://www.sec.gov/Archives/edgar/data/ and adding the .txt file type extension.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('central_index_key', sa.Text(), nullable=True, comment='Identifier of the company in SEC database.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('street_address', sa.Text(), nullable=True, comment='Physical street address.'),
    sa.Column('address_2', sa.Text(), nullable=True, comment='Second line of the address.'),
    sa.Column('city', sa.Text(), nullable=True, comment='Name of the city.'),
    sa.Column('state', sa.Text(), nullable=True, comment='Two letter US state abbreviation.'),
    sa.Column('company_name_raw', sa.Text(), nullable=True, comment='Uncleaned name of company.'),
    sa.Column('name_change_date', sa.Date(), nullable=True, comment='Date of last name change of the company.'),
    sa.Column('company_name_old', sa.Text(), nullable=True, comment='Name of company prior to name change.'),
    sa.Column('industry_name_sic', sa.Text(), nullable=True, comment='Text description of Standard Industrial Classification (SIC)'),
    sa.Column('industry_id_sic', sa.Text(), nullable=True, comment="Four-digit Standard Industrial Classification (SIC) code identifying the company's primary industry. SIC codes have been replaced by NAICS codes in many applications, but are still used by the SEC. See e.g. https://www.osha.gov/data/sic-manual for code definitions."),
    sa.Column('incorporation_state', sa.Text(), nullable=True, comment='Two letter state code where company is incorporated.'),
    sa.Column('location_of_incorporation', sa.Text(), nullable=True, comment="Location of the company's incorporation. This can be a full US state name, a state abbreviation, the name of a foreign country, etc. Not yet standardized / cleaned."),
    sa.Column('taxpayer_id_irs', sa.Text(), nullable=True, comment='Taxpayer ID of the company with the IRS.'),
    sa.Column('files_sec10k', sa.Boolean(), nullable=True, comment='Indicates whether the company files an SEC 10-K.'),
    sa.Column('parent_company_central_index_key', sa.Text(), nullable=True, comment="Central index key (CIK) of the company's parent company."),
    sa.Column('fraction_owned', sa.Float(), nullable=True, comment='Proportion of generator ownership attributable to this utility.')
    )
    op.create_table('out_sec10k__changelog_company_name',
    sa.Column('central_index_key', sa.Text(), nullable=False, comment='Identifier of the company in SEC database.'),
    sa.Column('name_change_date', sa.Date(), nullable=False, comment='Date of last name change of the company.'),
    sa.Column('company_name_old', sa.Text(), nullable=True, comment='Name of company prior to name change.'),
    sa.Column('company_name_new', sa.Text(), nullable=True, comment='Name of company after name change.')
    )
    op.create_table('out_sec10k__quarterly_company_information',
    sa.Column('filename_sec10k', sa.Text(), nullable=False, comment='Unique portion of the filename associated with the SEC 10-K filing in the EDGAR database. The full source URL can be reconstructed by prepending https://www.sec.gov/Archives/edgar/data/ and adding the .txt file type extension.'),
    sa.Column('filer_count', sa.Integer(), nullable=False, comment='A counter indicating which observation of company data within an SEC 10-K filing header the record pertains to.'),
    sa.Column('central_index_key', sa.Text(), nullable=True, comment='Identifier of the company in SEC database.'),
    sa.Column('utility_id_eia', sa.Integer(), nullable=True, comment='The EIA Utility Identification number.'),
    sa.Column('utility_name_eia', sa.Text(), nullable=True, comment='The name of the utility.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('filing_date', sa.Date(), nullable=True, comment='Date filing was submitted, reported at a daily frequency.'),
    sa.Column('company_name', sa.Text(), nullable=True, comment='Name of company submitting SEC 10k filing.'),
    sa.Column('fiscal_year_end', sa.Text(), nullable=True, comment="The end date of an SEC filing company's fiscal year, in MMDD format."),
    sa.Column('taxpayer_id_irs', sa.Text(), nullable=True, comment='Taxpayer ID of the company with the IRS.'),
    sa.Column('incorporation_state', sa.Text(), nullable=True, comment='Two letter state code where company is incorporated.'),
    sa.Column('industry_name_sic', sa.Text(), nullable=True, comment='Text description of Standard Industrial Classification (SIC)'),
    sa.Column('industry_id_sic', sa.Text(), nullable=True, comment="Four-digit Standard Industrial Classification (SIC) code identifying the company's primary industry. SIC codes have been replaced by NAICS codes in many applications, but are still used by the SEC. See e.g. https://www.osha.gov/data/sic-manual for code definitions."),
    sa.Column('film_number', sa.Text(), nullable=True, comment="Document control number used in the SEC EDGAR database. The first four digits can be used to access scans of the document in the SEC's Virtual Private Reference Room."),
    sa.Column('sec10k_type', sa.Enum('10-k', '10-k/a', '10-k405', '10-k405/a', '10-kt', '10-kt/a', '10-ksb', '10-ksb/a'), nullable=True, comment='Specific version of SEC 10-K that was filed. 10-k: the standard annual report. 10-k/a: an amended version of the annual report. 10-k405: filed to report insider trading that was not reported in a timely fashion. 10-k405/a: an amended version of the 10-k405. 10-kt: submitted in lieu of or in addition to a standard 10-K annual report when a company changes the end of its fiscal year (e.g. due to a merger) leaving the company with a longer or shorter reporting period. 10-kt/a: an amended version of the 10-kt. 10-ksb: the annual report for small businesses, also known as penny stocks. 10-ksb/a: an amended version of the 10-ksb.'),
    sa.Column('sec_act', sa.Enum('1934 act'), nullable=True, comment='SEC Act through which the form was enacted, e.g. 1934 act.'),
    sa.Column('filing_number_sec', sa.Text(), nullable=True, comment='Filing number used internally by the SEC commission to track filing.'),
    sa.Column('phone_number', sa.Text(), nullable=True, comment='Phone number for utility contact 1.'),
    sa.Column('business_street_address', sa.Text(), nullable=True, comment="Street address of the company's place of business."),
    sa.Column('business_street_address_2', sa.Text(), nullable=True, comment="Second line of the street address of the company's place of business."),
    sa.Column('business_city', sa.Text(), nullable=True, comment="City where the company's place of business is located."),
    sa.Column('business_state', sa.Text(), nullable=True, comment="State where the company's place of business is located."),
    sa.Column('business_zip_code', sa.Text(), nullable=True, comment="Zip code of the company's place of business."),
    sa.Column('business_zip_code_4', sa.Text(), nullable=True, comment="Zip code suffix of the company's place of business."),
    sa.Column('business_postal_code', sa.Text(), nullable=True, comment="Non-US postal code of the company's place of business."),
    sa.Column('mail_street_address', sa.Text(), nullable=True, comment="Street portion of the company's for mailing address."),
    sa.Column('mail_street_address_2', sa.Text(), nullable=True, comment="Second line of the street portion of the company's mailing address."),
    sa.Column('mail_city', sa.Text(), nullable=True, comment="City of the company's mailing address."),
    sa.Column('mail_state', sa.Text(), nullable=True, comment="State of the company's mailing address."),
    sa.Column('mail_zip_code', sa.Text(), nullable=True, comment="Zip code of the company's mailing address."),
    sa.Column('mail_zip_code_4', sa.Text(), nullable=True, comment="Zip code suffix of the company's mailing address."),
    sa.Column('mail_postal_code', sa.Text(), nullable=True, comment="Non-US postal code of the company's mailing address."),
    sa.Column('source_url', sa.Text(), nullable=True, comment='URL pointing to the original source of the data in the record.'),
    sa.PrimaryKeyConstraint('filename_sec10k', 'filer_count', name=op.f('pk_out_sec10k__quarterly_company_information'))
    )
    op.create_table('out_sec10k__quarterly_filings',
    sa.Column('filename_sec10k', sa.Text(), nullable=False, comment='Unique portion of the filename associated with the SEC 10-K filing in the EDGAR database. The full source URL can be reconstructed by prepending https://www.sec.gov/Archives/edgar/data/ and adding the .txt file type extension.'),
    sa.Column('central_index_key', sa.Text(), nullable=True, comment='Identifier of the company in SEC database.'),
    sa.Column('company_name', sa.Text(), nullable=True, comment='Name of company submitting SEC 10k filing.'),
    sa.Column('sec10k_type', sa.Enum('10-k', '10-k/a', '10-k405', '10-k405/a', '10-kt', '10-kt/a', '10-ksb', '10-ksb/a'), nullable=True, comment='Specific version of SEC 10-K that was filed. 10-k: the standard annual report. 10-k/a: an amended version of the annual report. 10-k405: filed to report insider trading that was not reported in a timely fashion. 10-k405/a: an amended version of the 10-k405. 10-kt: submitted in lieu of or in addition to a standard 10-K annual report when a company changes the end of its fiscal year (e.g. due to a merger) leaving the company with a longer or shorter reporting period. 10-kt/a: an amended version of the 10-kt. 10-ksb: the annual report for small businesses, also known as penny stocks. 10-ksb/a: an amended version of the 10-ksb.'),
    sa.Column('filing_date', sa.Date(), nullable=True, comment='Date filing was submitted, reported at a daily frequency.'),
    sa.Column('exhibit_21_version', sa.Text(), nullable=True, comment='Version of exhibit 21 submitted (if applicable).'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('source_url', sa.Text(), nullable=True, comment='URL pointing to the original source of the data in the record.'),
    sa.PrimaryKeyConstraint('filename_sec10k', name=op.f('pk_out_sec10k__quarterly_filings'))
    )
    op.drop_table('out_sec10k__parents_and_subsidiaries')
    with op.batch_alter_table('core_sec10k__quarterly_company_information', schema=None) as batch_op:
        batch_op.add_column(sa.Column('central_index_key', sa.Text(), nullable=True, comment='Identifier of the company in SEC database.'))
        batch_op.add_column(sa.Column('company_name', sa.Text(), nullable=True, comment='Name of company submitting SEC 10k filing.'))
        batch_op.add_column(sa.Column('fiscal_year_end', sa.Text(), nullable=True, comment="The end date of an SEC filing company's fiscal year, in MMDD format."))
        batch_op.add_column(sa.Column('taxpayer_id_irs', sa.Text(), nullable=True, comment='Taxpayer ID of the company with the IRS.'))
        batch_op.add_column(sa.Column('incorporation_state', sa.Text(), nullable=True, comment='Two letter state code where company is incorporated.'))
        batch_op.add_column(sa.Column('industry_name_sic', sa.Text(), nullable=True, comment='Text description of Standard Industrial Classification (SIC)'))
        batch_op.add_column(sa.Column('industry_id_sic', sa.Text(), nullable=True, comment="Four-digit Standard Industrial Classification (SIC) code identifying the company's primary industry. SIC codes have been replaced by NAICS codes in many applications, but are still used by the SEC. See e.g. https://www.osha.gov/data/sic-manual for code definitions."))
        batch_op.add_column(sa.Column('film_number', sa.Text(), nullable=True, comment="Document control number used in the SEC EDGAR database. The first four digits can be used to access scans of the document in the SEC's Virtual Private Reference Room."))
        batch_op.add_column(sa.Column('sec10k_type', sa.Enum('10-k', '10-k/a', '10-k405', '10-k405/a', '10-kt', '10-kt/a', '10-ksb', '10-ksb/a'), nullable=True, comment='Specific version of SEC 10-K that was filed. 10-k: the standard annual report. 10-k/a: an amended version of the annual report. 10-k405: filed to report insider trading that was not reported in a timely fashion. 10-k405/a: an amended version of the 10-k405. 10-kt: submitted in lieu of or in addition to a standard 10-K annual report when a company changes the end of its fiscal year (e.g. due to a merger) leaving the company with a longer or shorter reporting period. 10-kt/a: an amended version of the 10-kt. 10-ksb: the annual report for small businesses, also known as penny stocks. 10-ksb/a: an amended version of the 10-ksb.'))
        batch_op.add_column(sa.Column('sec_act', sa.Enum('1934 act'), nullable=True, comment='SEC Act through which the form was enacted, e.g. 1934 act.'))
        batch_op.add_column(sa.Column('filing_number_sec', sa.Text(), nullable=True, comment='Filing number used internally by the SEC commission to track filing.'))
        batch_op.add_column(sa.Column('phone_number', sa.Text(), nullable=True, comment='Phone number for utility contact 1.'))
        batch_op.add_column(sa.Column('business_street_address', sa.Text(), nullable=True, comment="Street address of the company's place of business."))
        batch_op.add_column(sa.Column('business_street_address_2', sa.Text(), nullable=True, comment="Second line of the street address of the company's place of business."))
        batch_op.add_column(sa.Column('business_city', sa.Text(), nullable=True, comment="City where the company's place of business is located."))
        batch_op.add_column(sa.Column('business_state', sa.Text(), nullable=True, comment="State where the company's place of business is located."))
        batch_op.add_column(sa.Column('business_zip_code', sa.Text(), nullable=True, comment="Zip code of the company's place of business."))
        batch_op.add_column(sa.Column('business_zip_code_4', sa.Text(), nullable=True, comment="Zip code suffix of the company's place of business."))
        batch_op.add_column(sa.Column('business_postal_code', sa.Text(), nullable=True, comment="Non-US postal code of the company's place of business."))
        batch_op.add_column(sa.Column('mail_street_address', sa.Text(), nullable=True, comment="Street portion of the company's for mailing address."))
        batch_op.add_column(sa.Column('mail_street_address_2', sa.Text(), nullable=True, comment="Second line of the street portion of the company's mailing address."))
        batch_op.add_column(sa.Column('mail_city', sa.Text(), nullable=True, comment="City of the company's mailing address."))
        batch_op.add_column(sa.Column('mail_state', sa.Text(), nullable=True, comment="State of the company's mailing address."))
        batch_op.add_column(sa.Column('mail_zip_code', sa.Text(), nullable=True, comment="Zip code of the company's mailing address."))
        batch_op.add_column(sa.Column('mail_zip_code_4', sa.Text(), nullable=True, comment="Zip code suffix of the company's mailing address."))
        batch_op.add_column(sa.Column('mail_postal_code', sa.Text(), nullable=True, comment="Non-US postal code of the company's mailing address."))
        batch_op.drop_column('company_information_fact_name')
        batch_op.drop_column('company_information_block_count')
        batch_op.drop_column('company_information_fact_value')
        batch_op.drop_column('company_information_block')
        batch_op.drop_column('report_date')

    with op.batch_alter_table('core_sec10k__quarterly_filings', schema=None) as batch_op:
        batch_op.add_column(sa.Column('sec10k_type', sa.Enum('10-k', '10-k/a', '10-k405', '10-k405/a', '10-kt', '10-kt/a', '10-ksb', '10-ksb/a'), nullable=True, comment='Specific version of SEC 10-K that was filed. 10-k: the standard annual report. 10-k/a: an amended version of the annual report. 10-k405: filed to report insider trading that was not reported in a timely fashion. 10-k405/a: an amended version of the 10-k405. 10-kt: submitted in lieu of or in addition to a standard 10-K annual report when a company changes the end of its fiscal year (e.g. due to a merger) leaving the company with a longer or shorter reporting period. 10-kt/a: an amended version of the 10-kt. 10-ksb: the annual report for small businesses, also known as penny stocks. 10-ksb/a: an amended version of the 10-ksb.'))
        batch_op.drop_column('sec10k_version')

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_sec10k__quarterly_filings', schema=None) as batch_op:
        batch_op.add_column(sa.Column('sec10k_version', sa.TEXT(), nullable=True))
        batch_op.drop_column('sec10k_type')

    with op.batch_alter_table('core_sec10k__quarterly_company_information', schema=None) as batch_op:
        batch_op.add_column(sa.Column('report_date', sa.DATE(), nullable=True))
        batch_op.add_column(sa.Column('company_information_block', sa.TEXT(), nullable=False))
        batch_op.add_column(sa.Column('company_information_fact_value', sa.TEXT(), nullable=False))
        batch_op.add_column(sa.Column('company_information_block_count', sa.INTEGER(), nullable=False))
        batch_op.add_column(sa.Column('company_information_fact_name', sa.TEXT(), nullable=False))
        batch_op.drop_column('mail_postal_code')
        batch_op.drop_column('mail_zip_code_4')
        batch_op.drop_column('mail_zip_code')
        batch_op.drop_column('mail_state')
        batch_op.drop_column('mail_city')
        batch_op.drop_column('mail_street_address_2')
        batch_op.drop_column('mail_street_address')
        batch_op.drop_column('business_postal_code')
        batch_op.drop_column('business_zip_code_4')
        batch_op.drop_column('business_zip_code')
        batch_op.drop_column('business_state')
        batch_op.drop_column('business_city')
        batch_op.drop_column('business_street_address_2')
        batch_op.drop_column('business_street_address')
        batch_op.drop_column('phone_number')
        batch_op.drop_column('filing_number_sec')
        batch_op.drop_column('sec_act')
        batch_op.drop_column('sec10k_type')
        batch_op.drop_column('film_number')
        batch_op.drop_column('industry_id_sic')
        batch_op.drop_column('industry_name_sic')
        batch_op.drop_column('incorporation_state')
        batch_op.drop_column('taxpayer_id_irs')
        batch_op.drop_column('fiscal_year_end')
        batch_op.drop_column('company_name')
        batch_op.drop_column('central_index_key')

    op.create_table('out_sec10k__parents_and_subsidiaries',
    sa.Column('filename_sec10k', sa.TEXT(), nullable=True),
    sa.Column('report_date', sa.DATE(), nullable=True),
    sa.Column('central_index_key', sa.TEXT(), nullable=True),
    sa.Column('utility_id_eia', sa.INTEGER(), nullable=True),
    sa.Column('street_address', sa.TEXT(), nullable=True),
    sa.Column('address_2', sa.TEXT(), nullable=True),
    sa.Column('city', sa.TEXT(), nullable=True),
    sa.Column('state', sa.TEXT(), nullable=True),
    sa.Column('company_name_raw', sa.TEXT(), nullable=True),
    sa.Column('company_name_former', sa.TEXT(), nullable=True),
    sa.Column('industry_description_sic', sa.TEXT(), nullable=True),
    sa.Column('industry_id_sic', sa.TEXT(), nullable=True),
    sa.Column('state_of_incorporation', sa.TEXT(), nullable=True),
    sa.Column('location_of_incorporation', sa.TEXT(), nullable=True),
    sa.Column('company_id_irs', sa.TEXT(), nullable=True),
    sa.Column('files_sec10k', sa.BOOLEAN(), nullable=True),
    sa.Column('parent_company_central_index_key', sa.TEXT(), nullable=True),
    sa.Column('fraction_owned', sa.FLOAT(), nullable=True),
    sa.Column('name_change_date', sa.DATE(), nullable=True),
    sa.Column('company_id_sec10k', sa.TEXT(), nullable=True),
    sa.ForeignKeyConstraint(['utility_id_eia'], ['core_eia__entity_utilities.utility_id_eia'], name='fk_out_sec10k__parents_and_subsidiaries_utility_id_eia_core_eia__entity_utilities')
    )
    op.drop_table('out_sec10k__quarterly_filings')
    op.drop_table('out_sec10k__quarterly_company_information')
    op.drop_table('out_sec10k__changelog_company_name')
    op.drop_table('core_sec10k__parents_and_subsidiaries')
    op.drop_table('core_sec10k__changelog_company_name')
    op.drop_table('core_sec10k__assn_sec10k_filers_and_eia_utilities')
    # ### end Alembic commands ###
