"""Add my cool new fuel cost source column

Revision ID: 1fd5fac43603
Revises: 8fffc1d0399a
Create Date: 2024-10-03 11:23:14.967903

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '1fd5fac43603'
down_revision = '8fffc1d0399a'
branch_labels = None
depends_on = None



def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('_out_eia__monthly_derived_generator_attributes', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_per_mmbtu_source', sa.Enum('original', 'eiaapi', 'rolling_avg', 'mixed'), nullable=True, comment="Indicates what the source of the values in the fuel_cost_per_mmbtu column. The fuel cost either comes directly from the EIA forms (original), was filled in from the EIA's API using state-level averages (eiaapi), was filled in using a rolling average (rolling_avg) or When the records get aggregated together and contain multiple sources (mixed)."))
        batch_op.drop_column('fuel_cost_from_eiaapi')

    with op.batch_alter_table('_out_eia__monthly_fuel_cost_by_generator', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_per_mmbtu_source', sa.Enum('original', 'eiaapi', 'rolling_avg', 'mixed'), nullable=True, comment="Indicates what the source of the values in the fuel_cost_per_mmbtu column. The fuel cost either comes directly from the EIA forms (original), was filled in from the EIA's API using state-level averages (eiaapi), was filled in using a rolling average (rolling_avg) or When the records get aggregated together and contain multiple sources (mixed)."))
        batch_op.drop_column('fuel_cost_from_eiaapi')

    with op.batch_alter_table('_out_eia__yearly_derived_generator_attributes', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_per_mmbtu_source', sa.Enum('original', 'eiaapi', 'rolling_avg', 'mixed'), nullable=True, comment="Indicates what the source of the values in the fuel_cost_per_mmbtu column. The fuel cost either comes directly from the EIA forms (original), was filled in from the EIA's API using state-level averages (eiaapi), was filled in using a rolling average (rolling_avg) or When the records get aggregated together and contain multiple sources (mixed)."))
        batch_op.drop_column('fuel_cost_from_eiaapi')

    with op.batch_alter_table('_out_eia__yearly_fuel_cost_by_generator', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_per_mmbtu_source', sa.Enum('original', 'eiaapi', 'rolling_avg', 'mixed'), nullable=True, comment="Indicates what the source of the values in the fuel_cost_per_mmbtu column. The fuel cost either comes directly from the EIA forms (original), was filled in from the EIA's API using state-level averages (eiaapi), was filled in using a rolling average (rolling_avg) or When the records get aggregated together and contain multiple sources (mixed)."))
        batch_op.drop_column('fuel_cost_from_eiaapi')

    with op.batch_alter_table('out_eia923__fuel_receipts_costs', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_per_mmbtu_source', sa.Enum('original', 'eiaapi', 'rolling_avg', 'mixed'), nullable=True, comment="Indicates what the source of the values in the fuel_cost_per_mmbtu column. The fuel cost either comes directly from the EIA forms (original), was filled in from the EIA's API using state-level averages (eiaapi), was filled in using a rolling average (rolling_avg) or When the records get aggregated together and contain multiple sources (mixed)."))
        batch_op.drop_column('fuel_cost_from_eiaapi')

    with op.batch_alter_table('out_eia923__monthly_fuel_receipts_costs', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_per_mmbtu_source', sa.Enum('original', 'eiaapi', 'rolling_avg', 'mixed'), nullable=True, comment="Indicates what the source of the values in the fuel_cost_per_mmbtu column. The fuel cost either comes directly from the EIA forms (original), was filled in from the EIA's API using state-level averages (eiaapi), was filled in using a rolling average (rolling_avg) or When the records get aggregated together and contain multiple sources (mixed)."))
        batch_op.drop_column('fuel_cost_from_eiaapi')

    with op.batch_alter_table('out_eia923__yearly_fuel_receipts_costs', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_per_mmbtu_source', sa.Enum('original', 'eiaapi', 'rolling_avg', 'mixed'), nullable=True, comment="Indicates what the source of the values in the fuel_cost_per_mmbtu column. The fuel cost either comes directly from the EIA forms (original), was filled in from the EIA's API using state-level averages (eiaapi), was filled in using a rolling average (rolling_avg) or When the records get aggregated together and contain multiple sources (mixed)."))
        batch_op.drop_column('fuel_cost_from_eiaapi')

    with op.batch_alter_table('out_eia__monthly_generators', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_per_mmbtu_source', sa.Enum('original', 'eiaapi', 'rolling_avg', 'mixed'), nullable=True, comment="Indicates what the source of the values in the fuel_cost_per_mmbtu column. The fuel cost either comes directly from the EIA forms (original), was filled in from the EIA's API using state-level averages (eiaapi), was filled in using a rolling average (rolling_avg) or When the records get aggregated together and contain multiple sources (mixed)."))
        batch_op.drop_column('fuel_cost_from_eiaapi')

    with op.batch_alter_table('out_eia__yearly_generators', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_per_mmbtu_source', sa.Enum('original', 'eiaapi', 'rolling_avg', 'mixed'), nullable=True, comment="Indicates what the source of the values in the fuel_cost_per_mmbtu column. The fuel cost either comes directly from the EIA forms (original), was filled in from the EIA's API using state-level averages (eiaapi), was filled in using a rolling average (rolling_avg) or When the records get aggregated together and contain multiple sources (mixed)."))
        batch_op.drop_column('fuel_cost_from_eiaapi')

    with op.batch_alter_table('out_eia__yearly_generators_by_ownership', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_per_mmbtu_source', sa.Enum('original', 'eiaapi', 'rolling_avg', 'mixed'), nullable=True, comment="Indicates what the source of the values in the fuel_cost_per_mmbtu column. The fuel cost either comes directly from the EIA forms (original), was filled in from the EIA's API using state-level averages (eiaapi), was filled in using a rolling average (rolling_avg) or When the records get aggregated together and contain multiple sources (mixed)."))
        batch_op.drop_column('fuel_cost_from_eiaapi')

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('out_eia__yearly_generators_by_ownership', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_from_eiaapi', sa.BOOLEAN(), nullable=True))
        batch_op.drop_column('fuel_cost_per_mmbtu_source')

    with op.batch_alter_table('out_eia__yearly_generators', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_from_eiaapi', sa.BOOLEAN(), nullable=True))
        batch_op.drop_column('fuel_cost_per_mmbtu_source')

    with op.batch_alter_table('out_eia__monthly_generators', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_from_eiaapi', sa.BOOLEAN(), nullable=True))
        batch_op.drop_column('fuel_cost_per_mmbtu_source')

    with op.batch_alter_table('out_eia923__yearly_fuel_receipts_costs', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_from_eiaapi', sa.BOOLEAN(), nullable=True))
        batch_op.drop_column('fuel_cost_per_mmbtu_source')

    with op.batch_alter_table('out_eia923__monthly_fuel_receipts_costs', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_from_eiaapi', sa.BOOLEAN(), nullable=True))
        batch_op.drop_column('fuel_cost_per_mmbtu_source')

    with op.batch_alter_table('out_eia923__fuel_receipts_costs', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_from_eiaapi', sa.BOOLEAN(), nullable=True))
        batch_op.drop_column('fuel_cost_per_mmbtu_source')

    with op.batch_alter_table('_out_eia__yearly_fuel_cost_by_generator', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_from_eiaapi', sa.BOOLEAN(), nullable=True))
        batch_op.drop_column('fuel_cost_per_mmbtu_source')

    with op.batch_alter_table('_out_eia__yearly_derived_generator_attributes', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_from_eiaapi', sa.BOOLEAN(), nullable=True))
        batch_op.drop_column('fuel_cost_per_mmbtu_source')

    with op.batch_alter_table('_out_eia__monthly_fuel_cost_by_generator', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_from_eiaapi', sa.BOOLEAN(), nullable=True))
        batch_op.drop_column('fuel_cost_per_mmbtu_source')

    with op.batch_alter_table('_out_eia__monthly_derived_generator_attributes', schema=None) as batch_op:
        batch_op.add_column(sa.Column('fuel_cost_from_eiaapi', sa.BOOLEAN(), nullable=True))
        batch_op.drop_column('fuel_cost_per_mmbtu_source')

    # ### end Alembic commands ###
