"""Rename SEC 10K tables to reflect temporal granularity.

Revision ID: 1e2ec7bf2b64
Revises: ac67e04d1383
Create Date: 2025-02-05 10:52:45.161681

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '1e2ec7bf2b64'
down_revision = 'ac67e04d1383'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('core_sec10k__quarterly_company_information',
    sa.Column('filename_sec10k', sa.Text(), nullable=False, comment='Name of filing as provided by SEC data portal.'),
    sa.Column('filer_count', sa.Integer(), nullable=False, comment='Index company information as some filings contain information for multiple companies.'),
    sa.Column('company_information_block', sa.Text(), nullable=False, comment='Title of block of data.'),
    sa.Column('company_information_block_count', sa.Integer(), nullable=False, comment='Some blocks are repeated, this defines the index of the data block.'),
    sa.Column('company_information_fact_name', sa.Text(), nullable=False, comment='Name of fact within a ``company_information_block``.'),
    sa.Column('company_information_fact_value', sa.Text(), nullable=False, comment='Value corresponding with ``company_information_fact_name``.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.PrimaryKeyConstraint('filename_sec10k', 'filer_count', 'company_information_block', 'company_information_block_count', 'company_information_fact_name', 'company_information_fact_value', name=op.f('pk_core_sec10k__quarterly_company_information'))
    )
    op.create_table('core_sec10k__quarterly_exhibit_21_company_ownership',
    sa.Column('filename_sec10k', sa.Text(), nullable=True, comment='Name of filing as provided by SEC data portal.'),
    sa.Column('subsidiary_company_name', sa.Text(), nullable=True, comment='Name of subsidiary company.'),
    sa.Column('subsidiary_company_location', sa.Text(), nullable=True, comment='Location of subsidiary company.'),
    sa.Column('fraction_owned', sa.Float(), nullable=True, comment='Proportion of generator ownership attributable to this utility.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.')
    )
    op.create_table('core_sec10k__quarterly_filings',
    sa.Column('filename_sec10k', sa.Text(), nullable=False, comment='Name of filing as provided by SEC data portal.'),
    sa.Column('central_index_key', sa.Text(), nullable=True, comment='Identifier of the company in SEC database.'),
    sa.Column('company_name', sa.Text(), nullable=True, comment='Name of company submitting SEC 10k filing.'),
    sa.Column('sec10k_version', sa.Text(), nullable=True, comment='Specific version of SEC 10k filed.'),
    sa.Column('filing_date', sa.Date(), nullable=True, comment='Date filing was submitted.'),
    sa.Column('exhibit_21_version', sa.Text(), nullable=True, comment='Version of exhibit 21 submitted (if applicable).'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.PrimaryKeyConstraint('filename_sec10k', name=op.f('pk_core_sec10k__quarterly_filings'))
    )
    op.drop_table('core_sec10k__company_information')
    op.drop_table('core_sec10k__filings')
    op.drop_table('core_sec10k__exhibit_21_company_ownership')
    with op.batch_alter_table('out_sec10k__parents_and_subsidiaries', schema=None) as batch_op:
        batch_op.drop_constraint('fk_out_sec10k__parents_and_subsidiaries_utility_id_eia_core_eia860__scd_utilities', type_='foreignkey')
        batch_op.create_foreign_key(batch_op.f('fk_out_sec10k__parents_and_subsidiaries_utility_id_eia_core_eia__entity_utilities'), 'core_eia__entity_utilities', ['utility_id_eia'], ['utility_id_eia'])

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('out_sec10k__parents_and_subsidiaries', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_out_sec10k__parents_and_subsidiaries_utility_id_eia_core_eia__entity_utilities'), type_='foreignkey')
        batch_op.create_foreign_key('fk_out_sec10k__parents_and_subsidiaries_utility_id_eia_core_eia860__scd_utilities', 'core_eia860__scd_utilities', ['utility_id_eia', 'report_date'], ['utility_id_eia', 'report_date'])

    op.create_table('core_sec10k__exhibit_21_company_ownership',
    sa.Column('filename_sec10k', sa.TEXT(), nullable=True),
    sa.Column('subsidiary_company_name', sa.TEXT(), nullable=True),
    sa.Column('fraction_owned', sa.FLOAT(), nullable=True),
    sa.Column('report_date', sa.DATE(), nullable=True),
    sa.Column('subsidiary_company_location', sa.TEXT(), nullable=True)
    )
    op.create_table('core_sec10k__filings',
    sa.Column('filename_sec10k', sa.TEXT(), nullable=False),
    sa.Column('central_index_key', sa.TEXT(), nullable=True),
    sa.Column('company_name', sa.TEXT(), nullable=True),
    sa.Column('sec10k_version', sa.TEXT(), nullable=True),
    sa.Column('exhibit_21_version', sa.TEXT(), nullable=True),
    sa.Column('report_date', sa.DATE(), nullable=True),
    sa.Column('filing_date', sa.DATE(), nullable=True),
    sa.PrimaryKeyConstraint('filename_sec10k', name='pk_core_sec10k__filings')
    )
    op.create_table('core_sec10k__company_information',
    sa.Column('filename_sec10k', sa.TEXT(), nullable=False),
    sa.Column('filer_count', sa.INTEGER(), nullable=False),
    sa.Column('company_information_block', sa.TEXT(), nullable=False),
    sa.Column('company_information_block_count', sa.INTEGER(), nullable=False),
    sa.Column('company_information_fact_name', sa.TEXT(), nullable=False),
    sa.Column('company_information_fact_value', sa.TEXT(), nullable=False),
    sa.Column('report_date', sa.DATE(), nullable=True),
    sa.PrimaryKeyConstraint('filename_sec10k', 'filer_count', 'company_information_block', 'company_information_block_count', 'company_information_fact_name', 'company_information_fact_value', name='pk_core_sec10k__company_information')
    )
    op.drop_table('core_sec10k__quarterly_filings')
    op.drop_table('core_sec10k__quarterly_exhibit_21_company_ownership')
    op.drop_table('core_sec10k__quarterly_company_information')
    # ### end Alembic commands ###
