"""Add sec10k tables

Revision ID: 1189596f92ed
Revises: 1d963598bf21
Create Date: 2025-02-04 16:06:16.870305

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '1189596f92ed'
down_revision = '1d963598bf21'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('core_sec10k__exhibit_21_company_ownership', schema=None) as batch_op:
        batch_op.add_column(sa.Column('subsidiary_company_location', sa.Text(), nullable=True, comment='Location of subsidiary company.'))
        batch_op.drop_column('subsidiary_location')

    with op.batch_alter_table('core_sec10k__filings', schema=None) as batch_op:
        batch_op.add_column(sa.Column('filing_date', sa.Date(), nullable=True, comment='Date filing was submitted.'))
        batch_op.drop_column('date_filed')

    with op.batch_alter_table('out_sec10k__parents_and_subsidiaries', schema=None) as batch_op:
        batch_op.add_column(sa.Column('name_change_date', sa.Date(), nullable=True, comment='Date of last name change of the company.'))
        batch_op.drop_column('date_of_name_change')

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('out_sec10k__parents_and_subsidiaries', schema=None) as batch_op:
        batch_op.add_column(sa.Column('date_of_name_change', sa.DATE(), nullable=True))
        batch_op.drop_column('name_change_date')

    with op.batch_alter_table('core_sec10k__filings', schema=None) as batch_op:
        batch_op.add_column(sa.Column('date_filed', sa.DATE(), nullable=True))
        batch_op.drop_column('filing_date')

    with op.batch_alter_table('core_sec10k__exhibit_21_company_ownership', schema=None) as batch_op:
        batch_op.add_column(sa.Column('subsidiary_location', sa.TEXT(), nullable=True))
        batch_op.drop_column('subsidiary_company_location')

    # ### end Alembic commands ###
