"""Add core_eia176__yearly_gas_disposition_by_consumer

Revision ID: 0f7ef503eef7
Revises: e91f15227f60
Create Date: 2025-11-12 09:51:14.866769

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0f7ef503eef7'
down_revision = 'e91f15227f60'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('core_eia176__yearly_gas_disposition_by_consumer',
    sa.Column('report_year', sa.Integer(), nullable=False, comment='Four-digit year in which the data was reported.'),
    sa.Column('operator_id_eia', sa.Text(), nullable=False, comment='The unique EIA identifier for an operator in a given state. The last two letters of the ID indicate the state.'),
    sa.Column('operating_state', sa.Text(), nullable=True, comment='State that the operator is reporting for.'),
    sa.Column('customer_class', sa.Enum('commercial', 'electric_power', 'industrial', 'other', 'residential', 'vehicle_fuel'), nullable=False, comment='High level categorization of customer type (e.g., commercial, residential).'),
    sa.Column('revenue_class', sa.Enum('sales', 'transport'), nullable=False, comment='Source of revenue: whether revenue originates from gas owned directly by the operator (sales) or gas transported by the operator (transport).'),
    sa.Column('consumers', sa.Integer(), nullable=True, comment='Number of end-use consumers within the report state.'),
    sa.Column('revenue', sa.Float(), nullable=True, comment='Revenue including taxes, rounded to the nearest whole dollar.'),
    sa.Column('volume_mcf', sa.Float(), nullable=True, comment='Total volume of natural gas deliveries in the report state. Reference conditions for measurement are 14.73 psia and 60° Fahrenheit.'),
    sa.PrimaryKeyConstraint('report_year', 'operator_id_eia', 'customer_class', 'revenue_class', name=op.f('pk_core_eia176__yearly_gas_disposition_by_consumer'))
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('core_eia176__yearly_gas_disposition_by_consumer')
    # ### end Alembic commands ###
