"""phmsagas schema

Revision ID: 053f6206fe23
Revises: 7ff6e93327fb
Create Date: 2025-09-25 17:29:50.545669

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '053f6206fe23'
down_revision = '7ff6e93327fb'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('core_phmsagas__yearly_distribution_operators',
    sa.Column('report_id', sa.Integer(), nullable=False, comment='Report number of the PHMSA Gas utility submission.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('operator_id_phmsa', sa.Integer(), nullable=False, comment='PHMSA unique operator ID.'),
    sa.Column('operator_name_phmsa', sa.Text(), nullable=True, comment='PHMSA operator name.'),
    sa.Column('office_street_address', sa.Text(), nullable=True, comment="Street address of an operator's office."),
    sa.Column('office_city', sa.Text(), nullable=True, comment="City where an operator's office is located."),
    sa.Column('office_county', sa.Text(), nullable=True, comment="County where an operator's office is located."),
    sa.Column('office_zip', sa.Text(), nullable=True, comment="Zipcode where an operator's office is located."),
    sa.Column('office_state', sa.Text(), nullable=True, comment="State where an operator's office is located."),
    sa.Column('headquarters_street_address', sa.Text(), nullable=True, comment="Street address for an operator's headquarters."),
    sa.Column('headquarters_city', sa.Text(), nullable=True, comment="City where an operator's headquarters are located."),
    sa.Column('headquarters_county', sa.Text(), nullable=True, comment="County where an operator's headquarters are located."),
    sa.Column('headquarters_state', sa.Text(), nullable=True, comment="State where an operator's headquarters are located."),
    sa.Column('headquarters_zip', sa.Text(), nullable=True, comment="Zipcode where an operator's headquarters are located."),
    sa.Column('additional_information', sa.Text(), nullable=True, comment='Any additional information which will assist in clarifying or classifying the reported data.'),
    sa.PrimaryKeyConstraint('report_id', 'report_date', 'operator_id_phmsa', name=op.f('pk_core_phmsagas__yearly_distribution_operators'))
    )
    op.create_table('_core_phmsagas__yearly_distribution_by_install_decade',
    sa.Column('report_id', sa.Integer(), nullable=False, comment='Report number of the PHMSA Gas utility submission.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('operator_id_phmsa', sa.Integer(), nullable=False, comment='PHMSA unique operator ID.'),
    sa.Column('commodity', sa.Text(), nullable=True, comment='The type of gas delivered by the distribution pipeline.'),
    sa.Column('operating_state', sa.Text(), nullable=False, comment='State that the distribution utility is reporting for. Prior to 2004, this may be a list of states.'),
    sa.Column('install_decade', sa.Text(), nullable=False, comment='The decade the distribution pipeline was installed.'),
    sa.Column('mains_miles', sa.Float(), nullable=True, comment='The miles of mains distribution pipeline.'),
    sa.Column('services', sa.Float(), nullable=True, comment='Number of end in system at end of year.'),
    sa.ForeignKeyConstraint(['report_id', 'report_date', 'operator_id_phmsa'], ['core_phmsagas__yearly_distribution_operators.report_id', 'core_phmsagas__yearly_distribution_operators.report_date', 'core_phmsagas__yearly_distribution_operators.operator_id_phmsa'], name=op.f('fk__core_phmsagas__yearly_distribution_by_install_decade_report_id_core_phmsagas__yearly_distribution_operators')),
    sa.PrimaryKeyConstraint('report_id', 'report_date', 'operator_id_phmsa', 'operating_state', 'install_decade', name=op.f('pk__core_phmsagas__yearly_distribution_by_install_decade'))
    )
    op.create_table('_core_phmsagas__yearly_distribution_by_material',
    sa.Column('report_id', sa.Integer(), nullable=True, comment='Report number of the PHMSA Gas utility submission.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('operator_id_phmsa', sa.Integer(), nullable=True, comment='PHMSA unique operator ID.'),
    sa.Column('commodity', sa.Text(), nullable=True, comment='The type of gas delivered by the distribution pipeline.'),
    sa.Column('operating_state', sa.Text(), nullable=True, comment='State that the distribution utility is reporting for. Prior to 2004, this may be a list of states.'),
    sa.Column('material', sa.Enum('unprotected_steel_bare', 'unprotected_steel_coated', 'cathodically_protected_steel_bare', 'cathodically_protected_steel_coated', 'steel', 'pvc', 'pe', 'abs', 'other_plastic', 'plastic', 'cast_or_wrought_iron', 'wrought_iron', 'ductile_iron', 'copper', 'other_alt', 'other_material', 'other', 'reconditioned_cast_iron', 'cast_iron', 'all_materials', 'total'), nullable=True, comment='The material of the gas distribution pipe. The categories of material types have changed slightly over the years (ex: cast and wrought iron were broken up in two categories before 1984).'),
    sa.Column('mains_miles', sa.Float(), nullable=True, comment='The miles of mains distribution pipeline.'),
    sa.Column('services', sa.Float(), nullable=True, comment='Number of end in system at end of year.'),
    sa.ForeignKeyConstraint(['report_id', 'report_date', 'operator_id_phmsa'], ['core_phmsagas__yearly_distribution_operators.report_id', 'core_phmsagas__yearly_distribution_operators.report_date', 'core_phmsagas__yearly_distribution_operators.operator_id_phmsa'], name=op.f('fk__core_phmsagas__yearly_distribution_by_material_report_id_core_phmsagas__yearly_distribution_operators'))
    )
    op.create_table('_core_phmsagas__yearly_distribution_by_material_and_size',
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('report_id', sa.Integer(), nullable=True, comment='Report number of the PHMSA Gas utility submission.'),
    sa.Column('operator_id_phmsa', sa.Integer(), nullable=True, comment='PHMSA unique operator ID.'),
    sa.Column('commodity', sa.Text(), nullable=True, comment='The type of gas delivered by the distribution pipeline.'),
    sa.Column('operating_state', sa.Text(), nullable=True, comment='State that the distribution utility is reporting for. Prior to 2004, this may be a list of states.'),
    sa.Column('main_size', sa.Enum('0.5_in_or_less', '0.5_to_1_in', '1_in_or_less', '1_to_2_in', '2_in_or_less', '2_to_4_in', '4_to_6_in', '4_to_8_in', '8_in', '8_to_12_in', '10_in', '12_in', 'over_12_in', 'total', 'unknown'), nullable=True, comment='Size range of mains. The size ranges have changed slightly over the years (ex: before 1984 they reported 0.5_in_or_less whereas after they reported 1_in_or_less).'),
    sa.Column('material', sa.Enum('unprotected_steel_bare', 'unprotected_steel_coated', 'cathodically_protected_steel_bare', 'cathodically_protected_steel_coated', 'steel', 'pvc', 'pe', 'abs', 'other_plastic', 'plastic', 'cast_or_wrought_iron', 'wrought_iron', 'ductile_iron', 'copper', 'other_alt', 'other_material', 'other', 'reconditioned_cast_iron', 'cast_iron', 'all_materials', 'total'), nullable=True, comment='The material of the gas distribution pipe. The categories of material types have changed slightly over the years (ex: cast and wrought iron were broken up in two categories before 1984).'),
    sa.Column('mains_miles', sa.Float(), nullable=True, comment='The miles of mains distribution pipeline.'),
    sa.Column('services', sa.Float(), nullable=True, comment='Number of end in system at end of year.'),
    sa.Column('main_other_material_detail', sa.Text(), nullable=True, comment='A free-form text field containing notes about the other material type. This column should only contain values in it for rows with other as the material type listed.'),
    sa.ForeignKeyConstraint(['report_id', 'report_date', 'operator_id_phmsa'], ['core_phmsagas__yearly_distribution_operators.report_id', 'core_phmsagas__yearly_distribution_operators.report_date', 'core_phmsagas__yearly_distribution_operators.operator_id_phmsa'], name=op.f('fk__core_phmsagas__yearly_distribution_by_material_and_size_report_id_core_phmsagas__yearly_distribution_operators'))
    )
    op.create_table('_core_phmsagas__yearly_distribution_excavation_damages',
    sa.Column('report_id', sa.Integer(), nullable=False, comment='Report number of the PHMSA Gas utility submission.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('operator_id_phmsa', sa.Integer(), nullable=False, comment='PHMSA unique operator ID.'),
    sa.Column('commodity', sa.Text(), nullable=True, comment='The type of gas delivered by the distribution pipeline.'),
    sa.Column('operating_state', sa.Text(), nullable=False, comment='State that the distribution utility is reporting for. Prior to 2004, this may be a list of states.'),
    sa.Column('damage_type', sa.Enum('notification', 'locating', 'excavation', 'other', 'total'), nullable=False, comment='A high level category of excavation damage causes.'),
    sa.Column('damage_sub_type', sa.Enum('deteriorated_facility', 'dug_after_expiry', 'failed_clearance', 'failed_to_protect_facilities', 'improper_backfilling', 'inaccurate_mark_abandoned_facility', 'inaccurate_mark_incorrect_records', 'inaccurate_mark_locator_error', 'inaccurate_mark_tracer_wire', 'incorrect_information', 'issues_total', 'marks_faded', 'no_one_call_made', 'not_marked_abandoned_facility', 'not_marked_incomplete_marks', 'not_marked_incorrect_records', 'not_marked_locator_error', 'not_marked_no_response', 'not_marked_tracer_wire', 'not_marked_unlocatable_facility', 'one_call_center_error', 'other_issues', 'outside_ticket_area', 'previous_damage', 'prior_to_test_hole_verification', 'prior_to_valid_start_time', 'root_cause_not_listed', 'total'), nullable=False, comment='A sub-category of damage_type of excavation damage causes.'),
    sa.Column('damages', sa.Float(), nullable=True, comment='Number of instances of excavation damage.'),
    sa.ForeignKeyConstraint(['report_id', 'report_date', 'operator_id_phmsa'], ['core_phmsagas__yearly_distribution_operators.report_id', 'core_phmsagas__yearly_distribution_operators.report_date', 'core_phmsagas__yearly_distribution_operators.operator_id_phmsa'], name=op.f('fk__core_phmsagas__yearly_distribution_excavation_damages_report_id_core_phmsagas__yearly_distribution_operators')),
    sa.PrimaryKeyConstraint('report_id', 'report_date', 'operator_id_phmsa', 'operating_state', 'damage_type', 'damage_sub_type', name=op.f('pk__core_phmsagas__yearly_distribution_excavation_damages'))
    )
    op.create_table('_core_phmsagas__yearly_distribution_filings',
    sa.Column('report_id', sa.Integer(), nullable=False, comment='Report number of the PHMSA Gas utility submission.'),
    sa.Column('operator_id_phmsa', sa.Integer(), nullable=False, comment='PHMSA unique operator ID.'),
    sa.Column('report_date', sa.Date(), nullable=False, comment='Date reported.'),
    sa.Column('filing_date', sa.Date(), nullable=True, comment='Date on which the filing was submitted.'),
    sa.Column('initial_filing_date', sa.Date(), nullable=True, comment='Initial date when filing was originally submitted.'),
    sa.Column('filing_correction_date', sa.Date(), nullable=True, comment='Date when a correction filing was submitted.'),
    sa.Column('report_filing_type', sa.Enum('Initial', 'Supplemental'), nullable=True, comment='Type of report submitted, either Initial or Supplemental.'),
    sa.Column('data_date', sa.Date(), nullable=True, comment='Data as of date.'),
    sa.Column('form_revision_id', sa.Text(), nullable=True, comment='PHMSA form revision identifier.'),
    sa.Column('preparer_name', sa.Text(), nullable=True, comment='Name of representative who filed report.'),
    sa.Column('preparer_title', sa.Text(), nullable=True, comment='Title of representative who filed report.'),
    sa.Column('preparer_phone', sa.Text(), nullable=True, comment='Phone number of representative who filed report.'),
    sa.Column('preparer_fax', sa.Text(), nullable=True, comment='Fax number of representative who filed report.'),
    sa.Column('preparer_email', sa.Text(), nullable=True, comment='Email address of representative who filed report.'),
    sa.ForeignKeyConstraint(['report_id', 'report_date', 'operator_id_phmsa'], ['core_phmsagas__yearly_distribution_operators.report_id', 'core_phmsagas__yearly_distribution_operators.report_date', 'core_phmsagas__yearly_distribution_operators.operator_id_phmsa'], name=op.f('fk__core_phmsagas__yearly_distribution_filings_report_id_core_phmsagas__yearly_distribution_operators')),
    sa.PrimaryKeyConstraint('report_id', 'report_date', 'operator_id_phmsa', name=op.f('pk__core_phmsagas__yearly_distribution_filings'))
    )
    op.create_table('_core_phmsagas__yearly_distribution_leaks',
    sa.Column('report_id', sa.Integer(), nullable=True, comment='Report number of the PHMSA Gas utility submission.'),
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('operator_id_phmsa', sa.Integer(), nullable=True, comment='PHMSA unique operator ID.'),
    sa.Column('commodity', sa.Text(), nullable=True, comment='The type of gas delivered by the distribution pipeline.'),
    sa.Column('operating_state', sa.Text(), nullable=True, comment='State that the distribution utility is reporting for. Prior to 2004, this may be a list of states.'),
    sa.Column('leak_severity', sa.Enum('all_leaks', 'hazardous_leaks'), nullable=True, comment='Whether or not the leak described in this record are all leaks or hazardous leaks.'),
    sa.Column('leak_source', sa.Enum('construction_defect', 'corrosion_failure', 'equipment_failure', 'excavation_damage', 'incorrect_operation', 'material_defect', 'natural_force_damage', 'other', 'other_outside_force', 'outside_force', 'pipe_weld_joint_failure', 'third_party', 'total'), nullable=True, comment='The cause of the leaks.'),
    sa.Column('mains', sa.Float(), nullable=True, comment='The number of mains distribution pipeline.'),
    sa.Column('services', sa.Float(), nullable=True, comment='Number of end in system at end of year.'),
    sa.ForeignKeyConstraint(['report_id', 'report_date', 'operator_id_phmsa'], ['core_phmsagas__yearly_distribution_operators.report_id', 'core_phmsagas__yearly_distribution_operators.report_date', 'core_phmsagas__yearly_distribution_operators.operator_id_phmsa'], name=op.f('fk__core_phmsagas__yearly_distribution_leaks_report_id_core_phmsagas__yearly_distribution_operators'))
    )
    op.create_table('_core_phmsagas__yearly_distribution_misc',
    sa.Column('report_date', sa.Date(), nullable=True, comment='Date reported.'),
    sa.Column('report_id', sa.Integer(), nullable=True, comment='Report number of the PHMSA Gas utility submission.'),
    sa.Column('operator_id_phmsa', sa.Integer(), nullable=True, comment='PHMSA unique operator ID.'),
    sa.Column('operating_state', sa.Text(), nullable=True, comment='State that the distribution utility is reporting for. Prior to 2004, this may be a list of states.'),
    sa.Column('all_known_leaks_scheduled_for_repair', sa.Float(), nullable=True, comment='The number of known system leaks at the end of the report year scheduled for repair.'),
    sa.Column('all_known_leaks_scheduled_for_repair_main', sa.Float(), nullable=True, comment='The number of known leaks on main at the end of the report year scheduled for repair.'),
    sa.Column('hazardous_leaks_mechanical_joint_failure', sa.Float(), nullable=True, comment='The total number of hazardous leaks caused by a mechanical joint failure.'),
    sa.Column('federal_land_leaks_repaired_or_scheduled', sa.Integer(), nullable=True, comment='Total number of leaks repaired, eliminated, or scheduled for repair on federal land during the reporting year.'),
    sa.Column('average_service_length_feet', sa.Float(), nullable=True, comment='The average system service length in feet.'),
    sa.Column('services_efv_in_system', sa.Integer(), nullable=True, comment='Estimated number of services with Excess Flow Valve in the system at end of reported year related to natural gas distribution.'),
    sa.Column('services_efv_installed', sa.Integer(), nullable=True, comment='Total number of services with Excess Flow Valve installed during reported year related to natural gas distribution.'),
    sa.Column('services_shutoff_valve_in_system', sa.Integer(), nullable=True, comment='Estimated number of services with manual service line shut-off valves installed in the system at end of report year related to natural gas distribution.'),
    sa.Column('services_shutoff_valve_installed', sa.Integer(), nullable=True, comment='Total number of manual service line shut-off valves installed during reported year related to natural gas distribution.'),
    sa.Column('unaccounted_for_gas_fraction', sa.Float(), nullable=True, comment='Unaccounted for gas as a fraction of total consumption for the 12 months ending June 30 of the reporting year. Calculated as follows: Take the sum of: (purchased gas + produced gas) minus (customer use + company use + appropriate adjustments). Then divide by the sum of (customer use + company use + appropriate adjustments). Prior to 2017, this field was calculcated with a different deonominator (purchased gas + produced gas). The time period between 2010-2017 having this different calculation method ensured that there was no records that had a negative fraction. For all the other reporting years there are known and expected negative values in this column.'),
    sa.Column('excavation_tickets', sa.Integer(), nullable=True, comment='Number of Excavation Tickets received by the operator during the year, (i.e., receipt of information by the operator from the notification center).'),
    sa.ForeignKeyConstraint(['report_id', 'report_date', 'operator_id_phmsa'], ['core_phmsagas__yearly_distribution_operators.report_id', 'core_phmsagas__yearly_distribution_operators.report_date', 'core_phmsagas__yearly_distribution_operators.operator_id_phmsa'], name=op.f('fk__core_phmsagas__yearly_distribution_misc_report_id_core_phmsagas__yearly_distribution_operators'))
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('_core_phmsagas__yearly_distribution_misc')
    op.drop_table('_core_phmsagas__yearly_distribution_leaks')
    op.drop_table('_core_phmsagas__yearly_distribution_filings')
    op.drop_table('_core_phmsagas__yearly_distribution_excavation_damages')
    op.drop_table('_core_phmsagas__yearly_distribution_by_material_and_size')
    op.drop_table('_core_phmsagas__yearly_distribution_by_material')
    op.drop_table('_core_phmsagas__yearly_distribution_by_install_decade')
    op.drop_table('core_phmsagas__yearly_distribution_operators')
    # ### end Alembic commands ###
