from dataclasses import dataclass
from typing import Any, Dict, List, Optional

@dataclass(frozen=True)
class PolicyPack:
    policy_id: str
    version: str
    allowed_receipt_types: List[str]
    allowed_action_classes: List[str]
    allowed_scopes: List[str]
    freshness_max_age_s: Optional[int] = None

    # Optional (non-normative): require a resolvable registry snapshot reference for replay.
    require_reason_code_registry_snapshot: bool = False

def load_policy_pack(obj: Dict[str, Any]) -> PolicyPack:
    # Minimal shape used by the public-safe vector suite.
    return PolicyPack(
        policy_id=str(obj.get('policy_id','')),
        version=str(obj.get('version','')),
        allowed_receipt_types=list(obj.get('allowed_receipt_types') or []),
        allowed_action_classes=list(obj.get('allowed_action_classes') or []),
        allowed_scopes=list(obj.get('allowed_scopes') or []),
        freshness_max_age_s=obj.get('freshness_max_age_s'),
        require_reason_code_registry_snapshot=bool(obj.get('require_reason_code_registry_snapshot', False)),
    )
