# Supplement S8 — Independent Minimal Verifier (Clean-Room) (Kingdom Conformance RFC v1.3.6)

This ZIP contains a small **independent** (separate codepath) verifier for the *MVP* Kingdom Conformance
Conformance Pack format used in Supplement S2 test vectors.

- Purpose: demonstrate that **two distinct implementations** can reproduce the same PASS / FAIL / HOLD outcomes
  on the published public-safe vectors (including negative + freshness-boundary cases).
- This verifier is **non-normative**. The RFC is the normative specification.
- Public-safe: no secrets, no exploit guidance, and no real keys/hashes.

Quickstart (from the extracted folder):

```bash
python -m kc_independent_verifier.cli verify-pack <path-to-pack.json>
python -m kc_independent_verifier.cli run-vectors <path-to-test_vectors>
```

Notes:
- Freshness checks are evaluated deterministically using `conformance_statement.audit_window.end_utc` as the
  reference time when present (consistent with the S2 vector design).
- Additional checks in this clean-room verifier are intentionally limited to what is needed to reproduce the
  published S2 vector suite (e.g., registry-snapshot-missing HOLD when required by policy, and L2+ control-point
  coverage-gap FAIL).
