import json, hashlib
from typing import Any, Dict

def canonical_json(obj: Any) -> str:
    """Minimal deterministic JSON serialization (JCS-like). 
    For strict RFC 8785 compliance, swap in a dedicated JCS library.
    """
    return json.dumps(obj, sort_keys=True, separators=(",", ":"), ensure_ascii=False)

def sha256_hex_utf8(s: str) -> str:
    return hashlib.sha256(s.encode("utf-8")).hexdigest()

def digest_json(obj: Any) -> str:
    return sha256_hex_utf8(canonical_json(obj))
