# Supplement S2 — Reference Verifier + Test Vectors (Kingdom Conformance RFC v1.3.6)

This ZIP contains **non-normative reference materials** to automate replay checks for Kingdom Conformance conformance claims:
(1) a minimal reference verifier CLI, (2) **PASS/FAIL/HOLD** test vectors (incl. negative + freshness-boundary cases), and (3) sample Conformance Packs (L1/L2).

Public-safe: no secrets, no exploit guidance, and no real keys/hashes. **The RFC is the normative specification.**

Vector suite (`test_vectors/*`) includes:
- PASS (baseline)
- HOLD-negative cases (missing evidence; missing permits)
- FAIL cases (e.g., policy mismatch; permit scope mismatch)
- Freshness boundary cases (PASS at boundary; HOLD when stale)
- **Registry snapshot missing** (HOLD when required registry snapshot reference(s) are absent)
- **Coverage gap** (FAIL when L2+ conformance statements claim control-point coverage that is not evidenced by receipts in the pack)

Quickstart:
  unzip <this-zip>
  cd kc_reference_verifier
  python -m kc_verifier.cli verify-pack examples/conformance_pack_L1_eval.json
  python -m kc_verifier.cli verify-pack examples/conformance_pack_L2_enforce.json
  python -m kc_verifier.cli run-vectors test_vectors

Expected results:
- Each vector directory contains `pack.json` + `expected.json`.
- The `run-vectors` command checks the expected `decision`. If `expected.json` also includes `reason_codes`,
  `run-vectors` checks those too.

Layout:
- `kc_verifier/` — reference verifier CLI + checks (non-normative)
- `examples/` — sample Conformance Packs (L1/L2)
- `test_vectors/` — vector packs (pack.json + expected.json)

Contact: MeridianVerity@proton.me

> Note: v1.3.6 is an editorial-only RFC update; this S2 bundle adds vectors to make the spec more **testable**
> without changing normative RFC text.
