// SPDX-FileCopyrightText: 2014 Istituto Nazionale di Fisica Nucleare
//
// SPDX-License-Identifier: Apache-2.0

package org.italiangrid.storm.webdav.test.tape;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.webmvc.test.autoconfigure.AutoConfigureMockMvc;
import org.springframework.security.test.context.support.WithAnonymousUser;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.web.servlet.MockMvc;

@AutoConfigureMockMvc
@ActiveProfiles({"dev"})
@SpringBootTest(
    properties = {
      "storm.tape.well-known.source=src/test/resources/well-known/malformed-wlcg-tape-rest-api.json"
    })
@WithAnonymousUser
class MalformedEndpointTest {

  @Autowired MockMvc mvc;

  @Test
  void testMalformedWellKnown() throws Exception {
    mvc.perform(get("/.well-known/wlcg-tape-rest-api")).andExpect(status().isNotFound());
  }
}
