// SPDX-FileCopyrightText: 2014 Istituto Nazionale di Fisica Nucleare
//
// SPDX-License-Identifier: Apache-2.0

package org.italiangrid.storm.webdav.metrics;

import com.codahale.metrics.health.HealthCheckRegistry;
import io.dropwizard.metrics.servlets.HealthCheckServlet.ContextListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HealthContextListener extends ContextListener {

  private final HealthCheckRegistry registry;

  @Autowired
  public HealthContextListener(HealthCheckRegistry r) {
    this.registry = r;
  }

  @Override
  protected HealthCheckRegistry getHealthCheckRegistry() {
    return registry;
  }
}
