// SPDX-FileCopyrightText: 2014 Istituto Nazionale di Fisica Nucleare
//
// SPDX-License-Identifier: Apache-2.0

package org.italiangrid.storm.webdav.authz.managers;

import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;

public final class UnanimousDelegatedManager
    implements AuthorizationManager<RequestAuthorizationContext> {

  public static final Logger LOG = LoggerFactory.getLogger(UnanimousDelegatedManager.class);

  private final List<AuthorizationManager<RequestAuthorizationContext>> managers;

  private final String name;

  private UnanimousDelegatedManager(
      String name, List<AuthorizationManager<RequestAuthorizationContext>> managers) {
    this.name = name;
    this.managers = managers;
  }

  @Override
  public AuthorizationResult authorize(
      Supplier<? extends Authentication> authentication, RequestAuthorizationContext filter) {
    int grant = 0;

    for (AuthorizationManager<RequestAuthorizationContext> manager : managers) {
      AuthorizationResult result = manager.authorize(authentication, filter);

      if (LOG.isDebugEnabled()) {
        LOG.debug("Voter: {}, returned: {}", manager, result);
      }

      if (result != null) {
        if (result.isGranted()) {
          grant++;
        } else {
          return new AuthorizationDecision(false);
        }
      }
    }

    // To get this far, there were no deny votes
    if (grant > 0) {
      return new AuthorizationDecision(true);
    }

    return null;
  }

  public static UnanimousDelegatedManager forVoters(
      String name, List<AuthorizationManager<RequestAuthorizationContext>> accessDecisionManagers) {
    return new UnanimousDelegatedManager(name, accessDecisionManagers);
  }

  @Override
  public String toString() {
    return name;
  }
}
