<!--
SPDX-FileCopyrightText: 2014 Istituto Nazionale di Fisica Nucleare

SPDX-License-Identifier: Apache-2.0
-->

# Changelog

## 1.12.0 (2026-01-12)

### Changed

* Upgrade to Spring Boot 4

## 1.11.0 (2025-12-17)

### Added

* Add support to virtual threads
* [GH-149](https://github.com/italiangrid/storm-webdav/issues/149) - Add support to RFC 9530 Digest Fields for WCLG TPC Data Integrity
* Sign RPMs for AlmaLinux 9 and 10

### Changed

* Upgrade to Java 21
* Update dependencies, in particular Spring Boot to 3.5.8

### Fixed

* Return 507 when No space left on device

## 1.10.0 (2025-08-21)

### Added

* [STOR-1575](https://issues.infn.it/jira/browse/STOR-1575) - Add RemoteConnections and Connection to PerfMarker

### Changed

* Add Cache-Control header to well-known URIs
* Make HEAD requests on folders more lightweight: do not calculate listing
* Update dependencies, in particular Spring Boot to 3.5.5 and voms-api-java to 3.3.6

### Fixed

* Return 507 instead of 502 in more cases when disk quota is exceeded
* Add premigrate extended attribute also for pull-mode TPC

## 1.9.0 (2025-07-08)

### Added

* [STOR-1604](https://issues.infn.it/jira/projects/STOR/issues/STOR-1604) - Add tape enabled storage area support
* Support deployment behind nginx reverse proxy
* Build RPM for AlmaLinux 10

### Changed

* Update milton2 to support PROPFIND propname listing
* Update to Spring Boot 3.5.3
* Improve access log

### Fixed

* The TPC max-connections parameter was ignored and this produced many ConnectionRequestTimeoutException
* Expose metrics also for HTTPS traffic
* [GH-123](https://github.com/italiangrid/storm-webdav/issues/123) - Fix StandardOutput and StandardError in systemd service unit
* Fix NullPointerException when accessing authn-info page from Anonymous user
* Improve how StoRM WebDAV version in Server header is obtained
* Avoid duplicate Server header
* Fix prefix of TPC progress threads
* Set the idle timeout also on connector

## 1.8.1 (2025-04-24)

### Changed

* Update dependencies, in particular voms-api-java to 3.3.5, and Bootstrap
* Do not add sudo to Docker image

## 1.8.0 (2025-04-02)

### Added

* Add Spring Boot Micrometer metrics support ([documentation](https://github.com/italiangrid/storm-webdav/blob/develop/doc/metrics.md))
* Add dark theme support in web interface
* Push the Docker image also to GitHub Container Registry

### Changed

* Move non storage-area endpoints under `.storm-webdav` path
* Update Bootstrap, Bootstrap Table and jQuery

### Deprecated

* The old metrics endpoint `/status/metrics` will be removed in a future release

### Fixed

* [GH-107](https://github.com/italiangrid/storm-webdav/issues/107) - Return 403 code if PROPFIND-based directory listing is denied instead of 500

## 1.7.1 (2025-03-05)

### Fixed

* Remove warning in case a non-existent file is requested
* [STOR-819](https://issues.infn.it/jira/browse/STOR-819) - Fix put over directory not allowed

## 1.7.0 (2025-03-03)

### Changed

* [STOR-1621](https://issues.infn.it/jira/browse/STOR-1621) - Upgrade to Spring Boot 3

## 1.6.1 (2025-02-28)

### Fixed

* Fix replace file warning

## 1.6.0 (2025-02-19)

### Added

* [STOR-691](https://issues.infn.it/jira/browse/STOR-691) - The HTML pages generated by StoRM gridhttps WebDAV endpoint seems to allow web crawlers indexing
* Include a `Server` HTTP response header with details of StoRM WebDAV
* Create GitHub release when tagging a stable version

### Changed

* [STOR-1622](https://issues.infn.it/jira/browse/STOR-1622) - Porting to Java 17 and Spring Security 5.8
* [GH-65](https://github.com/italiangrid/storm-webdav/issues/65) - Update HTTP-TPC to ignore whether certificates have allowed namespace
* Improve systemd service unit

### Fixed

* [STOR-1583](https://issues.infn.it/jira/browse/STOR-1583) - Fix how a request with no remote IP address is logged

## 1.5.0 (2025-01-21)

### Fixed

* [STOR-1399](https://issues.infn.it/jira/browse/STOR-1399) - Skip invalid DN into the VO map file
* [STOR-1568](https://issues.infn.it/jira/browse/STOR-1568) - StoRM WebDAV says DELETED but the file is there
* [STOR-1583](https://issues.infn.it/jira/browse/STOR-1583) - Fix how a request with no remote IP address is logged
* [STOR-1600](https://issues.infn.it/jira/browse/STOR-1600) - WLCG scope "storage.modify" must grant stat permission
* [STOR-1602](https://issues.infn.it/jira/browse/STOR-1602) - Macaroon POST requests on files are failing with 403 Unauthorized
* [STOR-1605](https://issues.infn.it/jira/browse/STOR-1605) - The storage.stage:/ scope is not sufficient to read
* [STOR-1616](https://issues.infn.it/jira/browse/STOR-1616) - StoRM WebDAV does not permit the creation of non-existent parent directory even if the scope does it

### Enhancements

* [STOR-1564](https://issues.infn.it/jira/browse/STOR-1564) - Allow creation of non existent parent directories
* [STOR-1618](https://issues.infn.it/jira/browse/STOR-1618) - Add SciTags support
* Update Milton version from v2.7.1.7 to v2.8.0.3
* Support for the 'entitlements' JWT claim
* Add `jwt-client` principal to the ones available for the definition of a fine grained policy entry
* Restored StoRM WebDAV testsuite.
* Fixed Docker image used for testing purposes

## 1.4.2 (2023-06-27)

### Description

This release:

* upgrades significant dependencies (spring-boot, canl, bouncycastle, jQuery)
* removes the support for TRACE method
* tunes some default values (default TPC timeout, default heap size, etc.)
* and fixes other minor bugs/issues.

### Fixes

* [[STOR-1396](https://issues.infn.it/jira/browse/STOR-1396)] - Ensure adler32 checksums are always 8 chars long
* [[STOR-1450](https://issues.infn.it/jira/browse/STOR-1450)] - Increase default timeout for TPC to 30 seconds
* [[STOR-1500](https://issues.infn.it/jira/browse/STOR-1500)] - When redis is disabled the health indicator for redis should be disabled
* [[STOR-1574](https://issues.infn.it/jira/browse/STOR-1574)] - Old java/canl creates problems with encoding of subject/issuer names in self-signed certificates
* [[STOR-1440](https://issues.infn.it/jira/browse/STOR-1440)] - StoRM WebDAV should configure a bigger heap by default
* [[STOR-1497](https://issues.infn.it/jira/browse/STOR-1497)] - Upgrade canl-java to v2.6.0
* [[STOR-1515](https://issues.infn.it/jira/browse/STOR-1515)] - StoRM WebDAV metrics on TPC.pull/push.throughput
* [[STOR-1555](https://issues.infn.it/jira/browse/STOR-1555)] - Upgrade jQuery version
* [[STOR-1556](https://issues.infn.it/jira/browse/STOR-1556)] - Remove TRACE from allowed methods
* [[STOR-1557](https://issues.infn.it/jira/browse/STOR-1557)] - Upgrade Spring Boot version to the latest
* [[STOR-1558](https://issues.infn.it/jira/browse/STOR-1558)] - Update bouncycastle version to 1.67
* [[STOR-1576](https://issues.infn.it/jira/browse/STOR-1576)] - Add .well-known endpoint for StoRM WebDAV to point to the Tape REST endpoint


## 1.4.1 (2021-05-12)

This release fixes the failed state shown on stop/restart of the service due to a misunderstood exit code meaning.

### Fixed

- [[STOR-1400](https://issues.infn.it/jira/browse/STOR-1400)] - StoRM WebDAV service enters failed state when stopped

## 1.4.0 (2021-04-01)

### Added

- [[STOR-1336](https://issues.infn.it/jira/browse/STOR-1336)] - Add support for externalized session management

### Fixed

- [[STOR-1335](https://issues.infn.it/jira/browse/STOR-1335)] - Login with OIDC button not shown for error
  pages
- [[STOR-1332](https://issues.infn.it/jira/browse/STOR-1332)] - Login with OIDC button displayed only on storage area index page
- [[STOR-1298](https://issues.infn.it/jira/browse/STOR-1298)] - StoRM WebDAV RPM doesn't set the proper ownership on `/var/log/storm`
- [[STOR-1358](https://issues.infn.it/jira/browse/STOR-1358)] - StoRM WebDAV package should install Java 11

## 1.2.0 (2019-08-??)

### Added

- [[STOR-1098](https://issues.infn.it/jira/browse/STOR-1098)] - Spring boot updated to 2.1.4.RELEASE
- [[STOR-1097](https://issues.infn.it/jira/browse/STOR-1097)] - Introduced support for Conscrypt JSSE provider to improve TLS performance

### Fixed

- [[STOR-1095](https://issues.infn.it/jira/browse/STOR-1095)] - StoRM WebDAV default configuration does not depend anymore on `iam-test.indigo-datacloud.eu`
- [[STOR-1096](https://issues.infn.it/jira/browse/STOR-1096)] - Unreachable OpenID Connect provider causes StoRM WebDAV startup failure

## 1.1.0 (2019-02-28)

### Added

- Token-based authorization support
- Third-party copy support
- Jetty 9.4 and Spring Boot 2.1 porting
- Dates in logs now are in standard UTC format
- Rotated log files are compressed

### Fixed

- POST handled as GET fixed 

