# Detectability of Earth-like Atmospheres in Ultraviolet Transmission Spectroscopy  
## A Physical Modeling Framework for the Habitable Worlds Observatory (HWO)

This repository presents a physically motivated, end-to-end computational framework for evaluating the detectability of Earth-like exoplanet atmospheres using **ultraviolet (UV) transmission spectroscopy**, with direct relevance to the science objectives of the **NASA Habitable Worlds Observatory (HWO)**.

The model focuses on molecular oxygen (O₂) absorption in the UV and explicitly couples atmospheric structure, line-by-line absorption physics, exact transit limb geometry, and realistic photon-noise-limited instrument modeling.


## 1. Scientific Context and Motivation

The detection of biosignature gases in the atmospheres of Earth-sized exoplanets is a central goal of modern astrophysics and astrobiology. Molecular oxygen (O₂), either directly or via photochemical byproducts such as ozone (O₃), is widely regarded as one of the most compelling biosignatures when interpreted in an appropriate planetary and stellar context.

While most observational strategies emphasize optical and infrared wavelengths, the **ultraviolet regime offers uniquely strong absorption features** for O₂ and related species. However, UV observations are fundamentally photon-limited and highly sensitive to stellar properties.

The Habitable Worlds Observatory aims to characterize nearby potentially habitable exoplanets. This project addresses the following core feasibility question:

> **Under realistic observational conditions, can an Earth-like atmosphere produce a detectable ultraviolet transmission signal during a planetary transit?**


## 2. Conceptual Overview of Transmission Spectroscopy

During a planetary transit, a small fraction of stellar light passes through the planet’s atmosphere before reaching the observer.  
The wavelength-dependent attenuation of this light encodes information about atmospheric composition.

The observable quantity is the **transit depth**:

$$
\delta(\lambda) = \left(\frac{R_{\mathrm{eff}}(\lambda)}{R_*}\right)^2
$$

where:

- $R_*$ is the stellar radius,  
- $R_{\mathrm{eff}}(\lambda)$ is the effective planetary radius, including atmospheric absorption at wavelength $\lambda$.

The atmospheric contribution arises because different wavelengths probe different effective altitudes in the atmosphere.

## 3. Atmospheric Structure Model

The atmosphere is modeled as a spherically symmetric, vertically stratified column characterized by altitude-dependent profiles of:

- Temperature $T(z)$  
- Pressure $P(z)$  
- Molecular number density $n(z)$  

Assuming hydrostatic equilibrium, the pressure profile satisfies:

$$
\frac{dP}{dz} = -\rho(z)\, g
$$

which leads to an exponential density structure characterized by the **scale height**:

$$
H = \frac{k_B\, T}{\mu\, g}
$$

where:

- $k_B$ is the Boltzmann constant,  
- $\mu$ is the mean molecular mass,  
- $g$ is the surface gravity.

Earth-like parameters are adopted to construct representative atmospheric profiles.

## 4. Ultraviolet Absorption and Optical Depth

For each atmospheric layer, the wavelength-dependent **optical depth** along a slant path is computed as:

$$
\tau(\lambda, b) = \int n(z)\, \sigma(\lambda)\, ds
$$

where:

- $\sigma(\lambda)$ is the laboratory-measured absorption cross section,  
- $b$ is the impact parameter of the ray,  
- $ds$ is the differential path length along the line of sight.

The **transmission** is then given by the Beer–Lambert law:

$$
T(\lambda, b) = \exp\!\left[-\tau(\lambda, b)\right]
$$

This formulation directly links molecular-scale absorption physics to the observable transit signal.

## 5. Exact Limb Geometry

The model explicitly accounts for **limb geometry**, integrating over all atmospheric annuli intersected by stellar rays during transit.

The effective atmospheric height is computed as:

$$
h_{\mathrm{eff}}(\lambda) =
\int_0^\infty \left[1 - T(\lambda, b)\right]\, db
$$

leading to an effective planetary radius:

$$
R_{\mathrm{eff}}(\lambda) = R_p + h_{\mathrm{eff}}(\lambda)
$$

This approach avoids simplifying assumptions such as isothermal or optically thin atmospheres and is well suited to ultraviolet absorption regimes.

## 6. Instrument and Noise Model

To assess detectability, the model incorporates a simplified representation of an **HWO-class ultraviolet spectrograph**.

The signal-to-noise ratio (SNR) is estimated assuming photon-noise-limited observations:

$$
\mathrm{SNR}(\lambda) =
\frac{N_{\mathrm{signal}}(\lambda)}
{\sqrt{N_{\mathrm{phot}}(\lambda)}}
$$

where:

- $N_{\mathrm{phot}}$ is the total number of stellar photons collected,  
- $N_{\mathrm{signal}}$ is the wavelength-dependent transit signal.

Instrumental resolution, throughput, and integration time are treated parametrically, allowing flexible sensitivity studies.


## 7. Detectability and Sensitivity Analysis

The framework enables a variety of detectability experiments, including:

- Variation of atmospheric O₂ abundance
- Distance-dependent SNR scaling
- Identification of optimal UV wavelength bands
- Estimation of minimum detectable mixing ratios

A representative detectability criterion (e.g., SNR ≥ 5) is used to define observational feasibility under realistic exposure times.


## 8. Implementation Details

The core model is implemented in Python and emphasizes:

- Explicit physical assumptions
- Transparent numerical integration
- Reproducibility and extensibility

Key components include:
- Atmospheric profile construction
- Slant-path integration
- Spectral convolution
- Visualization and animation of transit geometry

---

## 9. Repository Structure

```text
.
├── hwo_model.py        # Integrated end-to-end physical model
├── dashboard.html      # Interactive visualization of results
├── data_1602/          # Input data and bibliographic resources
│   ├── *.bib
│   ├── *.bib.html
│   └── readme-1.txt
├── .gitignore
└── README.md
```

The current implementation prioritizes clarity and integration. The codebase is designed to be modularized into atmosphere, spectroscopy, and instrument submodules in future iterations.

## 10. Reproducibility

The model relies exclusively on standard scientific Python libraries.
All constants, parameters, and assumptions are explicitly stated in code.

The project adheres to reproducible research practices commonly used in astrophysics and planetary science.

## 11. Relevance to the Habitable Worlds Observatory

This work directly supports HWO feasibility studies by:

Quantifying UV biosignature detectability limits

Highlighting the dominant role of stellar UV photon flux

Providing a transparent framework for sensitivity analysis

The model is readily extensible to additional molecules, stellar types, and instrument architectures.

## 12. Future Work

Potential extensions include:

Explicit ozone (O₃) photochemical modeling

Multi-star spectral comparisons

Coupling to detailed HWO instrument simulators

Bayesian inference of atmospheric parameters

## Author

Antonika Shapovalova
Research in planetary atmospheres, remote sensing, and exoplanet science

GitHub: https://github.com/Antonika

Website: https://antonika.org

## License

This project is released under the MIT License.
See the LICENSE file for details.




