//==============================================================================
//	
//	Copyright (c) 2002-
//	Authors:
//	* Andrew Hinton <ug60axh@cs.bham.ac.uk> (University of Birmingham)
//	* Dave Parker <david.parker@comlab.ox.ac.uk> (University of Oxford, formerly University of Birmingham)
//	
//------------------------------------------------------------------------------
//	
//	This file is part of PRISM.
//	
//	PRISM is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//	
//	PRISM is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//	
//	You should have received a copy of the GNU General Public License
//	along with PRISM; if not, write to the Free Software Foundation,
//	Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//	
//==============================================================================

package userinterface.model;

import javax.swing.*;

import prism.PrismLangException;
import userinterface.util.GUIUndoManager;

@SuppressWarnings("serial")
public abstract class GUIModelEditor extends JPanel
{    
    public abstract String getParseText();
    
    public abstract void newModel();
    
    public abstract void undo();
    
    public abstract void redo();
        
    public abstract void cut();
    
    public abstract void copy();
    
    public abstract void paste();
    
    public abstract void delete();
    
    public abstract void selectAll();
    
    public void modelParseFailed(PrismLangException parserError, boolean background) {}

    public void modelParseSuccessful() {}
    
    public GUIUndoManager getUndoManager()
    {
    	return null;
    }
    
    public boolean canDoClipBoardAction(Action action)
	{
		return false;
	}
}
