/* PrismParser.java */
/* Generated By:JavaCC: Do not edit this line. PrismParser.java */
package parser;

import java.io.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import java.util.HashSet;

import jltl2ba.SimpleLTL;
import parser.BooleanUtils;
import parser.ast.*;
import parser.type.*;
import prism.ModelInfo;
import parser.visitor.*;
import prism.ModelType;
import prism.PrismLangException;

@SuppressWarnings({"unused", "static-access", "serial"})
public class PrismParser implements PrismParserConstants {
        // The model associated with the properties file being parsed
        private static ModelInfo modelInfo;

        // List of keyword strings
        private static ArrayList<String> keywordList = new ArrayList<String>();
        static {
                keywordList.clear();
                for (int i = PrismParserConstants.COMMENT+1; i < PrismParserConstants.NOT; i++) {
                        keywordList.add(PrismParserConstants.tokenImage[i].replaceAll("\"", ""));
                }
        }

        //-----------------------------------------------------------------------------------
        // Main method for testing purposes
        //-----------------------------------------------------------------------------------

        public static void main(String[] args)
        {
                PrismParser p = null;
                InputStream str = null;
                String src = null;

                try {
                        if (args.length == 0) {
                                System.out.println("Usage: java parser.PrismParser <switch> [<file>]");
                                System.out.println("Where: <switch> = -modulesfile or -mf");
                                System.out.println("                  -propertiesfile or -pf");
                                System.out.println("                  -expression or -e");
                                System.out.println("                  -ltl or -l");
                                System.exit(1);
                        }

                        p = new PrismParser();
                        str = (args.length > 1) ? new FileInputStream(args[1]) : System.in;
                        src = (args.length > 1) ? "file "+args[1] : "stdin";
                        System.out.println("Reading from "+src+"...\n");

                        if (args[0].equals("-modulesfile") || args[0].equals("-mf")) {
                                ModulesFile mf = p.parseModulesFile(str);
                                System.out.print("Modules file:\n=============\n\n" + mf);
                                System.out.print("\nTree:\n=====\n" + mf.toTreeString());
                                mf.tidyUp();
                                System.out.print("\nAnd after expansion:\n====================\n\n" +mf);
                        }
                        else if (args[0].equals("-propertiesfile") || args[0].equals("-pf")) {
                                PropertiesFile pf = p.parsePropertiesFile(new ModulesFile(), str);
                                System.out.print("Properties file:\n================\n\n" + pf);
                                System.out.print("\nTree:\n=====\n" + pf.toTreeString());
                                pf.tidyUp();
                                System.out.print("\nAnd after expansion:\n====================\n\n" + pf);
                        }
                        else if (args[0].equals("-expression") || args[0].equals("-e")) {
                                Expression expr = p.parseSingleExpression(str);
                                System.out.println("Expression: " + expr.toString());
                                System.out.print("Tree:\n=====\n" + expr.toTreeString());
                                expr.typeCheck();
                                expr.semanticCheck();
                                System.out.println("Type: " + expr.getType().getTypeString());
                                System.out.println("Eval: " + expr.evaluate());
                        }
                        else if (args[0].equals("-ltl") || args[0].equals("-l")) {
                                Expression expr = p.parseSingleLTLFormula(str);
                                expr = (Expression) expr.accept(new ASTTraverseModify() {
                                        public Object visit(ExpressionIdent e) throws PrismLangException
                                        {
                                                return new parser.ast.ExpressionVar(e.getName(), TypeBool.getInstance());
                                        }
                                });
                                System.out.println("LTL formula: " + expr.toString());
                                System.out.print("Tree:\n=====\n" + expr.toTreeString());
                                expr.typeCheck();
                                //expr.semanticCheck();
                                System.out.println("Type: " + expr.getType().getTypeString());
                                boolean pnf = Expression.isPositiveNormalFormLTL(expr);
                                System.out.println("Positive normal form: " + pnf);
                                System.out.println("Syntactically co-safe: " + Expression.isCoSafeLTLSyntactic(expr));
                                if (!pnf) {
                                        Expression exprPnf = BooleanUtils.convertLTLToPositiveNormalForm(expr.deepCopy());
                                        System.out.println("Positive normal form conversion: " + exprPnf);
                                        System.out.println("Syntactically co-safe: " + Expression.isCoSafeLTLSyntactic(exprPnf));
                                }
                                Expression expr2 = (Expression) expr.deepCopy().accept(new ASTTraverseModify() {
                                        public Object visit(ExpressionVar e) throws PrismLangException
                                        {
                                                        return new parser.ast.ExpressionLabel(e.getName());
                                        }
                                });
                                SimpleLTL sltl = expr2.convertForJltl2ba();
                                System.out.println("LBT: " + sltl.toStringLBT());
                                System.out.println("Spot: " + sltl.toStringSpot());
                                System.out.println("Spin: " + sltl.toStringSpin());
                        } else {
                                System.out.println("Unknown switch"); System.exit(1);
                        }
                }
                catch (PrismLangException e) {
                        System.out.println("Error in "+src+": " + e.getMessage()+"."); System.exit(1);
                }
                catch (FileNotFoundException e) {
                        System.out.println(e); System.exit(1);
                }
        }

        //-----------------------------------------------------------------------------------
        // Methods called by Prism
        //-----------------------------------------------------------------------------------

        // Constructor

        public PrismParser()
        {
                // Call default constructor
                this(System.in);
                setTabSize(8);
        }

        // Parse modules file

        public ModulesFile parseModulesFile(InputStream str) throws PrismLangException { return parseModulesFile(str, null); }

        public ModulesFile parseModulesFile(InputStream str, ModelType typeOverride) throws PrismLangException
        {
                ModulesFile mf = null;

                // (Re)start parser
                ReInit(str);
                // Parse
                try {
                        mf = ModulesFile();
                }
                catch (ParseException e) {
                        throw generateSyntaxError(e);
                }
                // Override type of model if requested
                if (typeOverride != null) {
                        mf.setModelTypeInFile(typeOverride);
                }

                return mf;
        }

        // Parse properties file (pass ModulesFile in to get at its constants)

        public PropertiesFile parsePropertiesFile(ModelInfo modelInfo, InputStream str) throws PrismLangException
        { return parsePropertiesFile(modelInfo, str, false); }

        public PropertiesFile parsePropertiesFile(ModelInfo modelInfo, InputStream str, boolean strict) throws PrismLangException
        {
                PropertiesFile pf = null;

                // (Re)start parser
                ReInit(str);
                this.modelInfo = modelInfo;
                // Parse
                try {
                        pf = strict ? PropertiesFile() : PropertiesFileSemicolonless();
                }
                catch (ParseException e) {
                        throw generateSyntaxError(e);
                }

                return pf;
        }

        // Parse a single expression

        public Expression parseSingleExpression(InputStream str) throws PrismLangException
        {
                Expression expr = null;

                // (Re)start parser
                ReInit(str);
                // Parse
                try {
                        expr = SingleExpression();
                }
                catch (ParseException e) {
                        throw generateSyntaxError(e);
                }
                return expr;
        }

        // Parse a single LTL formula

        public Expression parseSingleLTLFormula(InputStream str) throws PrismLangException
        {
                Expression expr = null;

                // (Re)start parser
                ReInit(str);
                // Parse
                try {
                        expr = SingleLTLFormula();
                }
                catch (ParseException e) {
                        throw generateSyntaxError(e);
                }
                return expr;
        }

        // Parse a for loop

        public ForLoop parseForLoop(InputStream str) throws PrismLangException
        {
                ForLoop fl = null;

                // (Re)start parser
                ReInit(str);
                // Parse
                try {
                        fl = ForLoop();
                }
                catch (ParseException e) {
                        throw generateSyntaxError(e);
                }
                return fl;
        }

        //-----------------------------------------------------------------------------------
        // Some utility methods
        //-----------------------------------------------------------------------------------

        /**
	 * Get comment block directly preceding a token and remove "//" characters
	 */
        public static String getPrecedingCommentBlock(Token firstToken)
        {
                String comment = "", s;
                Token t = firstToken;

                // extract any comment from the previous lines of the file
                if (t.specialToken != null && !(t.specialToken.kind == PrismParserConstants.WHITESPACE && t.specialToken.image.matches("[\\n\\r]*"))) {
                        // trace back thru special tokens that are comments
                        t = t.specialToken;
                        while (t.specialToken != null && !(t.specialToken.kind == PrismParserConstants.WHITESPACE && t.specialToken.image.matches("[\\n\\r]*")))
                                t = t.specialToken;
                        // concatenate comment special tokens
                        while (t != null) {
                                s = t.image;
                                // strip any nasty carriage returns
                                s = s.replaceAll("\r", "");
                                // remove "//" and preceding/subsequent spaces/tabs from comments
                                if (t.kind == PrismParserConstants.COMMENT) {
                                        while (comment.length() > 0 && (""+comment.charAt(comment.length()-1)).matches("[ \t]"))
                                                comment = comment.substring(0,comment.length()-1);
                                        s = s.substring(2);
                                        s = s.replaceFirst("[ \t]*", "");
                                }
                                comment += s;
                                t = t.next;
                        }
                }
                // remove final new line (if present)
                if (comment.length() > 0 && (comment.charAt(comment.length()-1) == '\n'))
                        comment = comment.substring(0,comment.length()-1);

                return comment;
        }

        // Add "//"s into comment block

        public static String slashCommentBlock(String comment)
        {
                int i;
                String s, res = "";
                // break into lines
                while ((i = comment.indexOf("\n")) != -1) {
                        s = comment.substring(0, i);
                        comment = comment.substring(i+1);
                        // add "//" to non-empty lines
                        if (s.trim().length()>0) res += "// " + s;
                        res += "\n";
                }
                // deal with any trailing characters (with no new line ending them)
                if (comment.trim().length()>0) res += "// " + comment + "\n";
                return res;
        }

        /**
	 * Test a string to see if it is a PRISM language keyword.
	 */
        public static boolean isKeyword(String s)
        {
                return keywordList.contains(s);
        }

        /**
	 * Get access to the list of all PRISM language keywords.
	 */
        public static List<String> getListOfKeywords()
        {
                return keywordList;
        }

        /**
	 * Set the tab size used by the lexer/parser.
	 */
        public void setTabSize(int size)
        {
                SimpleCharStream.setTabSize(size);
        }

        /**
	 * Get the tab size used by the lexer/parser.
	 */
        public int getTabSize()
        {
                return SimpleCharStream.getTabSize();
        }

        /**
	 * Generate a syntax error (PrismLangException) from a ParseException.
	 */
        protected PrismLangException generateSyntaxError(ParseException e)
        {
                if (e == null) return new PrismLangException("Syntax error");
                // No token: was prob created manually so use message if present
                if (e.currentToken == null) {
                        String msg = e.getMessage();
                        String exMsg = "Syntax error";
                        if (msg != null && msg.length() > 0)
                                exMsg += ": " + msg;
                        return new PrismLangException(exMsg);
                }
                // Use current/next token to find location of error
                // But don't use error message if too long (esp if generated by JavaCC)
                else {
                        ExpressionIdent tmp;
                        if (e.currentToken.next == null) {
                                tmp = new ExpressionIdent(e.currentToken.image);
                                tmp.setPosition(e.currentToken);
                        } else {
                                tmp = new ExpressionIdent(e.currentToken.next.image);
                                tmp.setPosition(e.currentToken.next);
                        }
                        String msg = e.getMessage();
                        String exMsg = "Syntax error";
                        if (msg != null && msg.length() > 0 && msg.length() < 20)
                                exMsg += ": " + msg;
                        return new PrismLangException(exMsg, tmp);
                }
        }

        //-----------------------------------------------------------------------------------
        // A few classes for temporary storage of bits of the AST
        //-----------------------------------------------------------------------------------

        static class ExpressionPair { public Expression expr1 = null; public Expression expr2 = null; }

//-----------------------------------------------------------------------------------
// Top-level productions
//-----------------------------------------------------------------------------------

// Modules file
  static final public 
ModulesFile ModulesFile() throws ParseException, PrismLangException {ModelType type = null;
        int typeCount = 0;
        Token typeDupe = null;
        Declaration global;
        parser.ast.Module m = null;
        RenamedModule rm = null;
        RewardStruct rs = null;
        Expression init = null;
        ObservableVars obsVars = null;
        Observable obs = null;
        int initCount = 0;
        Expression initDupe = null;
        Player player = null;
        ModulesFile mf = new ModulesFile();
        Token begin = null;
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CONST:
      case CSG:
      case CTMC:
      case CTMDP:
      case DTMC:
      case FORMULA:
      case GLOBAL:
      case INIT:
      case LABEL:
      case MDP:
      case MODULE:
      case NONDETERMINISTIC:
      case OBSERVABLE:
      case OBSERVABLES:
      case PLAYER:
      case POMDP:
      case POPTA:
      case PROBABILISTIC:
      case PROB:
      case PTA:
      case RATE:
      case REWARDS:
      case STOCHASTIC:
      case STPG:
      case SMG:
      case SYSTEM:
      case TPTG:{
        ;
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CSG:
      case CTMC:
      case CTMDP:
      case DTMC:
      case MDP:
      case NONDETERMINISTIC:
      case POMDP:
      case POPTA:
      case PROBABILISTIC:
      case PTA:
      case STOCHASTIC:
      case STPG:
      case SMG:
      case TPTG:{
begin = getToken(1);
        type = ModulesFileType();
typeCount++; if (typeCount == 2) typeDupe = getToken(0);
        break;
        }
      case FORMULA:{
        FormulaDef(mf.getFormulaList());
        break;
        }
      case LABEL:{
        LabelDef(mf.getLabelList());
        break;
        }
      case CONST:
      case PROB:
      case RATE:{
        ConstantDef(mf.getConstantList());
        break;
        }
      case GLOBAL:{
        // Global variable
                global = GlobalDecl();
mf.addGlobal(global);
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        if (jj_2_1(2147483647)) {
          rm = RenamedModule();
mf.addRenamedModule(rm);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case MODULE:{
            // Module
                    m = Module();
mf.addModule(m);
            break;
            }
          case REWARDS:{
            // Reward structure
                    rs = RewardStruct();
mf.addRewardStruct(rs);
            break;
            }
          case INIT:{
            // Initial states ("init...endinit" construct)
                    init = Init();
mf.setInitialStates(init); initCount++; if (initCount == 2) initDupe = init;
            break;
            }
          case OBSERVABLES:{
            // Observables
                    obsVars = ObservableVars();
mf.addObservableVarList(obsVars);
            break;
            }
          case OBSERVABLE:{
            obs = Observable();
mf.addObservableDefinition(obs);
            break;
            }
          case SYSTEM:{
            SystemEndsystem(mf);
            break;
            }
          case PLAYER:{
            // Player definition
                    player = Player();
mf.addPlayer(player);
            break;
            }
          default:
            jj_la1[2] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    jj_consume_token(0);
// Check for multiple instances of some items
                if (typeDupe != null) {
                        ExpressionIdent tmp = new ExpressionIdent(typeDupe.image);
                        tmp.setPosition(typeDupe);
                        {if (true) throw new PrismLangException("There were multiple model type declarations", tmp);}
                }
                if (initDupe != null) {
                        {if (true) throw new PrismLangException("There were multiple init...endinit constructs", initDupe);}
                }

                // Set model type (might be null, i.e., unspecified)
                mf.setModelTypeInFile(type);

                // Return completed ModulesFile object
                mf.setPosition(begin != null? begin: getToken(0), getToken(0));
                {if ("" != null) return mf;}
    throw new Error("Missing return statement in function");
}

// Properties file
  static final public 
PropertiesFile PropertiesFile() throws ParseException, PrismLangException {PropertiesFile pf = new PropertiesFile(modelInfo);
        Property prop;
        Token begin = null;
begin = getToken(1);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case A:
      case CONST:
      case E:
      case FALSE:
      case FILTER:
      case FUNC:
      case LABEL:
      case MAX:
      case MIN:
      case PMAXMAX:
      case PMAXMIN:
      case PMAX:
      case PMINMAX:
      case PMINMIN:
      case PMIN:
      case P:
      case PROB:
      case RATE:
      case RMAXMAX:
      case RMAXMIN:
      case RMAX:
      case RMINMAX:
      case RMINMIN:
      case RMIN:
      case R:
      case S:
      case TRUE:
      case NOT:
      case LPARENTH:
      case DLBRACKET:
      case DLT:
      case MINUS:
      case DQUOTE:
      case REG_INT:
      case REG_DOUBLE:
      case REG_IDENTPRIME:
      case REG_IDENT:{
        ;
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        break label_2;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case A:
      case E:
      case FALSE:
      case FILTER:
      case FUNC:
      case MAX:
      case MIN:
      case PMAXMAX:
      case PMAXMIN:
      case PMAX:
      case PMINMAX:
      case PMINMIN:
      case PMIN:
      case P:
      case RMAXMAX:
      case RMAXMIN:
      case RMAX:
      case RMINMAX:
      case RMINMIN:
      case RMIN:
      case R:
      case S:
      case TRUE:
      case NOT:
      case LPARENTH:
      case DLBRACKET:
      case DLT:
      case MINUS:
      case DQUOTE:
      case REG_INT:
      case REG_DOUBLE:
      case REG_IDENTPRIME:
      case REG_IDENT:{
        prop = Property();
pf.addProperty(prop);
        label_3:
        while (true) {
          jj_consume_token(SEMICOLON);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case SEMICOLON:{
            ;
            break;
            }
          default:
            jj_la1[4] = jj_gen;
            break label_3;
          }
        }
        break;
        }
      case LABEL:{
        LabelDef(pf.getLabelList());
        break;
        }
      case CONST:
      case PROB:
      case RATE:{
        ConstantDef(pf.getConstantList());
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(0);
pf.setPosition(begin, getToken(0)); {if ("" != null) return pf;}
    throw new Error("Missing return statement in function");
}

// Properties file with optional semicolons - beware of potential ambiguities
  static final public 
PropertiesFile PropertiesFileSemicolonless() throws ParseException, PrismLangException {PropertiesFile pf = new PropertiesFile(modelInfo);
        Property prop;
        Token begin = null;
begin = getToken(1);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case A:
      case CONST:
      case E:
      case FALSE:
      case FILTER:
      case FUNC:
      case LABEL:
      case MAX:
      case MIN:
      case PMAXMAX:
      case PMAXMIN:
      case PMAX:
      case PMINMAX:
      case PMINMIN:
      case PMIN:
      case P:
      case PROB:
      case RATE:
      case RMAXMAX:
      case RMAXMIN:
      case RMAX:
      case RMINMAX:
      case RMINMIN:
      case RMIN:
      case R:
      case S:
      case TRUE:
      case NOT:
      case LPARENTH:
      case DLBRACKET:
      case DLT:
      case MINUS:
      case DQUOTE:
      case REG_INT:
      case REG_DOUBLE:
      case REG_IDENTPRIME:
      case REG_IDENT:{
        ;
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case A:
      case E:
      case FALSE:
      case FILTER:
      case FUNC:
      case MAX:
      case MIN:
      case PMAXMAX:
      case PMAXMIN:
      case PMAX:
      case PMINMAX:
      case PMINMIN:
      case PMIN:
      case P:
      case RMAXMAX:
      case RMAXMIN:
      case RMAX:
      case RMINMAX:
      case RMINMIN:
      case RMIN:
      case R:
      case S:
      case TRUE:
      case NOT:
      case LPARENTH:
      case DLBRACKET:
      case DLT:
      case MINUS:
      case DQUOTE:
      case REG_INT:
      case REG_DOUBLE:
      case REG_IDENTPRIME:
      case REG_IDENT:{
        prop = Property();
        label_5:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case SEMICOLON:{
            ;
            break;
            }
          default:
            jj_la1[7] = jj_gen;
            break label_5;
          }
          jj_consume_token(SEMICOLON);
        }
pf.addProperty(prop);
        break;
        }
      case LABEL:{
        LabelDef(pf.getLabelList());
        break;
        }
      case CONST:
      case PROB:
      case RATE:{
        ConstantDef(pf.getConstantList());
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(0);
pf.setPosition(begin, getToken(0)); {if ("" != null) return pf;}
    throw new Error("Missing return statement in function");
}

// Property - expression, with optional name/comment
  static final public 
Property Property() throws ParseException, PrismLangException {String name = null;
        Expression expr;
        Property prop;
        Token begin = null;
begin = getToken(1);
    if (jj_2_2(2147483647)) {
      jj_consume_token(DQUOTE);
      name = Identifier();
      jj_consume_token(DQUOTE);
      jj_consume_token(COLON);
    } else {
      ;
    }
    expr = ExpressionITE(true, false);
prop = new Property(expr, name, getPrecedingCommentBlock(begin));
prop.setPosition(begin, getToken(0)); {if ("" != null) return prop;}
    throw new Error("Missing return statement in function");
}

// A single expression
  static final public 
Expression SingleExpression() throws ParseException, PrismLangException {Expression ret;
    ret = Expression(false, false);
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// A single LTL formula
  static final public 
Expression SingleLTLFormula() throws ParseException, PrismLangException {Expression ret;
    ret = Expression(true, true);
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

//-----------------------------------------------------------------------------------
// Modules file stuff (a few bits of which are reused for property files)
//-----------------------------------------------------------------------------------

// Keyword denoting model type
  static final public 
ModelType ModulesFileType() throws ParseException {ModelType modelType = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DTMC:
    case PROBABILISTIC:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DTMC:{
        jj_consume_token(DTMC);
        break;
        }
      case PROBABILISTIC:{
        jj_consume_token(PROBABILISTIC);
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
modelType=ModelType.DTMC;
      break;
      }
    case MDP:
    case NONDETERMINISTIC:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MDP:{
        jj_consume_token(MDP);
        break;
        }
      case NONDETERMINISTIC:{
        jj_consume_token(NONDETERMINISTIC);
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
modelType=ModelType.MDP;
      break;
      }
    case CTMC:
    case STOCHASTIC:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CTMC:{
        jj_consume_token(CTMC);
        break;
        }
      case STOCHASTIC:{
        jj_consume_token(STOCHASTIC);
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
modelType=ModelType.CTMC;
      break;
      }
    case CTMDP:{
      jj_consume_token(CTMDP);
modelType=ModelType.CTMDP;
      break;
      }
    case PTA:{
      jj_consume_token(PTA);
modelType=ModelType.PTA;
      break;
      }
    case POMDP:{
      jj_consume_token(POMDP);
modelType=ModelType.POMDP;
      break;
      }
    case POPTA:{
      jj_consume_token(POPTA);
modelType=ModelType.POPTA;
      break;
      }
    case STPG:{
      jj_consume_token(STPG);
modelType=ModelType.STPG;
      break;
      }
    case SMG:{
      jj_consume_token(SMG);
modelType=ModelType.SMG;
      break;
      }
    case TPTG:{
      jj_consume_token(TPTG);
modelType=ModelType.TPTG;
      break;
      }
    case CSG:{
      jj_consume_token(CSG);
modelType=ModelType.CSG;
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return modelType;}
    throw new Error("Missing return statement in function");
}

// Formula definition
  static final public 
void FormulaDef(FormulaList formulaList) throws ParseException, PrismLangException {ExpressionIdent name = null;
        Expression expr = null;
    jj_consume_token(FORMULA);
    name = IdentifierExpression();
    jj_consume_token(EQ);
    expr = Expression(false, false);
    jj_consume_token(SEMICOLON);
formulaList.addFormula(name, expr);
}

// Label definition
  static final public 
void LabelDef(LabelList labelList) throws ParseException, PrismLangException {ExpressionIdent name = null;
        Expression expr = null;
    if (jj_2_3(2147483647)) {
      jj_consume_token(LABEL);
      jj_consume_token(DQUOTE);
      name = IdentifierExpression();
      jj_consume_token(DQUOTE);
      jj_consume_token(EQ);
      expr = Expression(false, false);
      jj_consume_token(SEMICOLON);
labelList.addLabel(name, expr);
    } else if (jj_2_4(2147483647)) {
      jj_consume_token(LABEL);
      name = IdentifierExpression();
{if (true) throw new PrismLangException("Label names must be enclosed in double-quotes", name);}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
}

// Constant definition
  static final public 
void ConstantDef(ConstantList constantList) throws ParseException, PrismLangException {Type type = TypeInt.getInstance();
        ExpressionIdent name = null;
        Expression expr = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CONST:{
      jj_consume_token(CONST);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BOOL:
      case DOUBLE:
      case INT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case INT:{
          jj_consume_token(INT);
type=TypeInt.getInstance();
          break;
          }
        case DOUBLE:{
          jj_consume_token(DOUBLE);
type=TypeDouble.getInstance();
          break;
          }
        case BOOL:{
          jj_consume_token(BOOL);
type=TypeBool.getInstance();
          break;
          }
        default:
          jj_la1[13] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        ;
      }
      break;
      }
    case PROB:
    case RATE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case RATE:{
        jj_consume_token(RATE);
        break;
        }
      case PROB:{
        jj_consume_token(PROB);
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
type=TypeDouble.getInstance();
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    // Name and (optional) initial value
            name = IdentifierExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EQ:{
      jj_consume_token(EQ);
      expr = Expression(false, false);
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
constantList.addConstant(name, expr, type);
}

// Global variable declaration
  static final public 
Declaration GlobalDecl() throws ParseException, PrismLangException {Declaration decl = null;
    jj_consume_token(GLOBAL);
    decl = Declaration();
{if ("" != null) return decl;}
    throw new Error("Missing return statement in function");
}

// Variable declaration
  static final public 
Declaration Declaration() throws ParseException, PrismLangException {Declaration decl;
        String name = null;
        DeclarationType declType;
        Expression init = null;
        Token begin = null;
begin = getToken(1);
    name = Identifier();
    jj_consume_token(COLON);
    declType = DeclarationVarType();
decl = new Declaration(name, declType);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INIT:{
      jj_consume_token(INIT);
      init = Expression(false, false);
decl.setStart(init);
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
decl.setPosition(begin, getToken(0)); {if ("" != null) return decl;}
    throw new Error("Missing return statement in function");
}

// Type part of a declaration
  static final public 
DeclarationType DeclarationVarType() throws ParseException, PrismLangException {Expression low = null, high = null;
        DeclarationType declType, subtype;
        Token begin = null;
begin = getToken(1);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACKET:{
      jj_consume_token(LBRACKET);
      low = Expression(false, false);
      jj_consume_token(DOTS);
      high = Expression(false, false);
      jj_consume_token(RBRACKET);
declType = new DeclarationInt(low, high);
      break;
      }
    case INT:{
      jj_consume_token(INT);
declType = new DeclarationIntUnbounded();
      break;
      }
    case BOOL:{
      jj_consume_token(BOOL);
declType = new DeclarationBool();
      break;
      }
    case CLOCK:{
      jj_consume_token(CLOCK);
declType = new DeclarationClock();
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
declType.setPosition(begin, getToken(0)); {if ("" != null) return declType;}
    throw new Error("Missing return statement in function");
}

// Module
  static final public 
parser.ast.Module Module() throws ParseException, PrismLangException {ExpressionIdent name = null;
        Declaration var = null;
        Expression invar;
        Command comm = null;
        parser.ast.Module module = null;
        Token begin = null;
    begin = jj_consume_token(MODULE);
    name = IdentifierExpression();
module = new parser.ast.Module(name.getName());
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case REG_IDENT:{
        ;
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        break label_6;
      }
      var = Declaration();
module.addDeclaration(var);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INVARIANT:{
      jj_consume_token(INVARIANT);
      invar = Expression(false, false);
      jj_consume_token(ENDINVARIANT);
module.setInvariant(invar);
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      ;
    }
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:{
        ;
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        break label_7;
      }
      comm = Command();
module.addCommand(comm);
    }
    jj_consume_token(ENDMODULE);
module.setPosition(begin, getToken(0)); module.setNameASTElement(name); {if ("" != null) return module;}
    throw new Error("Missing return statement in function");
}

// Command
  static final public 
Command Command() throws ParseException, PrismLangException {List<String> synchs = null;
        Expression guard = null;
        Updates updates = null;
        Command comm = new Command();
        Token begin = null;
    // Synchronisation action-label
            begin = jj_consume_token(LBRACKET);
    synchs = ActionList();
comm.setSynchs(synchs);
    jj_consume_token(RBRACKET);
    // Guard/updates
            guard = Expression(false, false);
comm.setGuard(guard);
    jj_consume_token(RARROW);
    updates = Updates();
comm.setUpdates(updates);
    jj_consume_token(SEMICOLON);
comm.setPosition(begin, getToken(0)); {if ("" != null) return comm;}
    throw new Error("Missing return statement in function");
}

// Updates
  static final public 
Updates Updates() throws ParseException, PrismLangException {Expression prob;
        Update update;
        Updates updates = new Updates();
        Token begin = null;
begin = getToken(1);
    if (jj_2_5(2147483647)) {
      update = Update();
updates.addUpdate(null, update);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case A:
      case E:
      case FALSE:
      case FILTER:
      case FUNC:
      case F:
      case G:
      case MAX:
      case MIN:
      case X:
      case PMAXMAX:
      case PMAXMIN:
      case PMAX:
      case PMINMAX:
      case PMINMIN:
      case PMIN:
      case P:
      case RMAXMAX:
      case RMAXMIN:
      case RMAX:
      case RMINMAX:
      case RMINMIN:
      case RMIN:
      case R:
      case S:
      case TRUE:
      case NOT:
      case LPARENTH:
      case LBRACKET:
      case DLBRACKET:
      case DLT:
      case MINUS:
      case DQUOTE:
      case REG_INT:
      case REG_DOUBLE:
      case REG_IDENTPRIME:
      case REG_IDENT:{
        prob = ProbOrRateOrInterval();
        jj_consume_token(COLON);
        update = Update();
updates.addUpdate(prob, update);
        label_8:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case PLUS:{
            ;
            break;
            }
          default:
            jj_la1[23] = jj_gen;
            break label_8;
          }
          jj_consume_token(PLUS);
          prob = ProbOrRateOrInterval();
          jj_consume_token(COLON);
          update = Update();
updates.addUpdate(prob, update);
        }
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
updates.setPosition(begin, getToken(0)); {if ("" != null) return updates;}
    throw new Error("Missing return statement in function");
}

  static final public Expression ProbOrRateOrInterval() throws ParseException, PrismLangException {Expression prob;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case A:
    case E:
    case FALSE:
    case FILTER:
    case FUNC:
    case F:
    case G:
    case MAX:
    case MIN:
    case X:
    case PMAXMAX:
    case PMAXMIN:
    case PMAX:
    case PMINMAX:
    case PMINMIN:
    case PMIN:
    case P:
    case RMAXMAX:
    case RMAXMIN:
    case RMAX:
    case RMINMAX:
    case RMINMIN:
    case RMIN:
    case R:
    case S:
    case TRUE:
    case NOT:
    case LPARENTH:
    case DLBRACKET:
    case DLT:
    case MINUS:
    case DQUOTE:
    case REG_INT:
    case REG_DOUBLE:
    case REG_IDENTPRIME:
    case REG_IDENT:{
      prob = Expression(false, false);
      break;
      }
    case LBRACKET:{
      prob = ExpressionInterval(false, false);
      break;
      }
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return prob;}
    throw new Error("Missing return statement in function");
}

  static final public Update Update() throws ParseException, PrismLangException {Update update = new Update();
        Token begin = null;
begin = getToken(1);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPARENTH:{
      UpdateElement(update);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:{
          ;
          break;
          }
        default:
          jj_la1[26] = jj_gen;
          break label_9;
        }
        jj_consume_token(AND);
        UpdateElement(update);
      }
      break;
      }
    case TRUE:{
      jj_consume_token(TRUE);
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
update.setPosition(begin, getToken(0)); {if ("" != null) return update;}
    throw new Error("Missing return statement in function");
}

  static final public void UpdateElement(Update update) throws ParseException, PrismLangException {ExpressionIdent var = null;
        Expression expr = null;
        Token begin = null;
    begin = jj_consume_token(LPARENTH);
    var = IdentifierPrime();
    jj_consume_token(EQ);
    expr = Expression(false, false);
    jj_consume_token(RPARENTH);
UpdateElement ue = new UpdateElement(var, expr); ue.setPosition(begin, getToken(0)); update.addElement(ue);
}

// Module renaming
  static final public 
RenamedModule RenamedModule() throws ParseException, PrismLangException {ExpressionIdent name = null, base = null;
        RenamedModule rm = null;
        Token begin = null;
    begin = jj_consume_token(MODULE);
    name = IdentifierExpression();
    jj_consume_token(EQ);
    base = IdentifierExpression();
rm = new RenamedModule(name.getName(), base.getName());
    jj_consume_token(LBRACKET);
    Rename(rm);
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        break label_10;
      }
      jj_consume_token(COMMA);
      Rename(rm);
    }
    jj_consume_token(RBRACKET);
    jj_consume_token(ENDMODULE);
rm.setPosition(begin, getToken(0)); rm.setNameASTElement(name); rm.setBaseModuleASTElement(base); {if ("" != null) return rm;}
    throw new Error("Missing return statement in function");
}

  static final public void Rename(RenamedModule rm) throws ParseException {ExpressionIdent id1 = null, id2 = null;
    // NB: have to explicitly include keywords for functions because they can be renamed
            id1 = IdentifierExpressionMinMax();
    jj_consume_token(EQ);
    id2 = IdentifierExpressionMinMax();
rm.addRename(id1.getName(), id2.getName(), id1, id2);
}

// Reward structure
  static final public 
RewardStruct RewardStruct() throws ParseException, PrismLangException {String name = null, s = null;
        Expression guard = null, value = null;
        RewardStruct rs = new RewardStruct();
        RewardStructItem rsi;
        Token begin = null, begin2 = null;
        List<String> synchs = null;
    begin = jj_consume_token(REWARDS);
    if (jj_2_6(2147483647)) {
      jj_consume_token(DQUOTE);
      name = Identifier();
      jj_consume_token(DQUOTE);
rs.setName(name);
    } else {
      ;
    }
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case A:
      case E:
      case FALSE:
      case FILTER:
      case FUNC:
      case F:
      case G:
      case MAX:
      case MIN:
      case X:
      case PMAXMAX:
      case PMAXMIN:
      case PMAX:
      case PMINMAX:
      case PMINMIN:
      case PMIN:
      case P:
      case RMAXMAX:
      case RMAXMIN:
      case RMAX:
      case RMINMAX:
      case RMINMIN:
      case RMIN:
      case R:
      case S:
      case TRUE:
      case NOT:
      case LPARENTH:
      case LBRACKET:
      case DLBRACKET:
      case DLT:
      case MINUS:
      case DQUOTE:
      case REG_INT:
      case REG_DOUBLE:
      case REG_IDENTPRIME:
      case REG_IDENT:{
        ;
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        break label_11;
      }
begin2 = getToken(1); synchs = null;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:{
        jj_consume_token(LBRACKET);
        synchs = ActionList();
        jj_consume_token(RBRACKET);
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        ;
      }
      guard = Expression(false, false);
      jj_consume_token(COLON);
      value = Expression(false, false);
      jj_consume_token(SEMICOLON);
rsi = new RewardStructItem(synchs, guard, value); rsi.setPosition(begin2, getToken(0)); rs.addItem(rsi);
    }
    jj_consume_token(ENDREWARDS);
rs.setPosition(begin, getToken(0)); {if ("" != null) return rs;}
    throw new Error("Missing return statement in function");
}

// Action list (0 or more comma-separated identifiers)
  static final public 
List<String> ActionList() throws ParseException {String s;
        List<String> list = new ArrayList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case REG_IDENT:{
      s = Identifier();
list.add(s);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[31] = jj_gen;
          break label_12;
        }
        jj_consume_token(COMMA);
        s = Identifier();
list.add(s);
      }
      break;
      }
    default:
      jj_la1[32] = jj_gen;
      ;
    }
{if ("" != null) return list;}
    throw new Error("Missing return statement in function");
}

// Initial states ("init...endinit" construct)
  static final public 
Expression Init() throws ParseException, PrismLangException {Expression expr = null;
    jj_consume_token(INIT);
    expr = Expression(false, false);
    jj_consume_token(ENDINIT);
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
}

// Observable variables list (for partially observable models)
  static final public 
ObservableVars ObservableVars() throws ParseException {Token begin = null;
        ObservableVars obsVars = null;
        Expression exprVar = null;
begin = getToken(1);
    jj_consume_token(OBSERVABLES);
obsVars = new ObservableVars();
    exprVar = IdentifierExpression();
obsVars.addVar(exprVar);
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[33] = jj_gen;
        break label_13;
      }
      jj_consume_token(COMMA);
      exprVar = IdentifierExpression();
obsVars.addVar(exprVar);
    }
    jj_consume_token(ENDOBSERVABLES);
obsVars.setPosition(begin, getToken(0)); {if ("" != null) return obsVars;}
    throw new Error("Missing return statement in function");
}

// Individual observable (for partially observable models)
  static final public 
Observable Observable() throws ParseException, PrismLangException {Token begin = null;
        String name = null;
        Expression defn = null;
begin = getToken(1);
    jj_consume_token(OBSERVABLE);
    jj_consume_token(DQUOTE);
    name = Identifier();
    jj_consume_token(DQUOTE);
    jj_consume_token(EQ);
    defn = Expression(false, false);
    jj_consume_token(SEMICOLON);
Observable obs = new Observable(name, defn); obs.setPosition(begin, getToken(0)); {if ("" != null) return obs;}
    throw new Error("Missing return statement in function");
}

// System definition ("system...endsystem" construct)
  static final public 
void SystemEndsystem(ModulesFile mf) throws ParseException {String name = null;
        SystemDefn sysdef;
    jj_consume_token(SYSTEM);
    if (jj_2_7(2147483647)) {
      jj_consume_token(DQUOTE);
      name = Identifier();
      jj_consume_token(DQUOTE);
    } else {
      ;
    }
    sysdef = SystemDefn();
    jj_consume_token(ENDSYSTEM);
mf.addSystemDefn(sysdef, name);
}

// System definition component
  static final public 
SystemDefn SystemDefn() throws ParseException {SystemDefn ret;
    ret = SystemFullParallel();
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// System definition component (full parallel)
  static final public 
SystemDefn SystemFullParallel() throws ParseException {SystemDefn sys1 = null, sys2 = null;
        SystemFullParallel par = null;
        Token begin;
begin = getToken(1);
    sys1 = SystemInterleaved();
par = new SystemFullParallel(); par.addOperand(sys1);
    label_14:
    while (true) {
      if (jj_2_8(2147483647)) {
        ;
      } else {
        break label_14;
      }
      jj_consume_token(OR);
      jj_consume_token(OR);
      sys2 = SystemParallel();
par.addOperand(sys2);
    }
if (par==null || par.getNumOperands() == 1) {
                        {if ("" != null) return sys1;}
                }
                else {
                        par.setPosition(begin, getToken(0));
                        {if ("" != null) return par;}
                }
    throw new Error("Missing return statement in function");
}

// System definition component (interleaved parallel)
  static final public 
SystemDefn SystemInterleaved() throws ParseException {SystemDefn sys1 = null, sys2 = null;
        SystemInterleaved par = null;
        Token begin;
begin = getToken(1);
    sys1 = SystemParallel();
par = new SystemInterleaved(); par.addOperand(sys1);
    label_15:
    while (true) {
      if (jj_2_9(2147483647)) {
        ;
      } else {
        break label_15;
      }
      jj_consume_token(OR);
      jj_consume_token(OR);
      jj_consume_token(OR);
      sys2 = SystemFullParallel();
par.addOperand(sys2);
    }
if (par==null || par.getNumOperands() == 1) {
                        {if ("" != null) return sys1;}
                }
                else {
                        par.setPosition(begin, getToken(0));
                        {if ("" != null) return par;}
                }
    throw new Error("Missing return statement in function");
}

// System definition component (parallel over set of actions)
  static final public 
SystemDefn SystemParallel() throws ParseException {SystemDefn sys1 = null, sys2 = null;
        SystemParallel par = null;
        String s;
        Token begin;
begin = getToken(1);
    sys1 = SystemHideRename();
    if (jj_2_10(2147483647)) {
par = new SystemParallel(); par.setOperand1(sys1);
      jj_consume_token(OR);
      jj_consume_token(LBRACKET);
      s = Identifier();
par.addAction(s);
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[34] = jj_gen;
          break label_16;
        }
        jj_consume_token(COMMA);
        s = Identifier();
par.addAction(s);
      }
      jj_consume_token(RBRACKET);
      jj_consume_token(OR);
      sys2 = SystemHideRename();
par.setOperand2(sys2);
    } else {
      ;
    }
if (par==null) {
                        {if ("" != null) return sys1;}
                }
                else {
                        par.setPosition(begin, getToken(0));
                        {if ("" != null) return par;}
                }
    throw new Error("Missing return statement in function");
}

// System definition component (hiding and renaming)
  static final public 
SystemDefn SystemHideRename() throws ParseException {SystemDefn sys = null;
        SystemHide hide = null;
        SystemRename rename = null;
        String s1 = null, s2 = null;
        Token begin;
begin = getToken(1);
    sys = SystemAtomic();
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACE:
      case DIVIDE:{
        ;
        break;
        }
      default:
        jj_la1[35] = jj_gen;
        break label_17;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DIVIDE:{
hide = new SystemHide(sys);
        jj_consume_token(DIVIDE);
        jj_consume_token(LBRACE);
        s1 = Identifier();
hide.addAction(s1);
        label_18:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[36] = jj_gen;
            break label_18;
          }
          jj_consume_token(COMMA);
          s1 = Identifier();
hide.addAction(s1);
        }
        jj_consume_token(RBRACE);
sys = hide;
        break;
        }
      case LBRACE:{
rename = new SystemRename(sys);
        jj_consume_token(LBRACE);
        s1 = Identifier();
        jj_consume_token(RENAME);
        s2 = Identifier();
rename.addRename(s1, s2);
        label_19:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[37] = jj_gen;
            break label_19;
          }
          jj_consume_token(COMMA);
          s1 = Identifier();
          jj_consume_token(RENAME);
          s2 = Identifier();
rename.addRename(s1, s2);
        }
        jj_consume_token(RBRACE);
sys = rename;
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
sys.setPosition(begin, getToken(0)); {if ("" != null) return sys;}
    throw new Error("Missing return statement in function");
}

// System definition component (bottom level)
  static final public 
SystemDefn SystemAtomic() throws ParseException {String name = null;
        SystemDefn sys = null;
        Token begin;
begin = getToken(1);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case REG_IDENT:{
      name = Identifier();
sys = new SystemModule(name);
      break;
      }
    case DQUOTE:{
      jj_consume_token(DQUOTE);
      name = Identifier();
      jj_consume_token(DQUOTE);
sys = new SystemReference(name);
      break;
      }
    case LPARENTH:{
      jj_consume_token(LPARENTH);
      sys = SystemDefn();
      jj_consume_token(RPARENTH);
sys = new SystemBrackets(sys);
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
sys.setPosition(begin, getToken(0)); {if ("" != null) return sys;}
    throw new Error("Missing return statement in function");
}

// Player definition
  static final public 
Player Player() throws ParseException {String name = null;
        Player player = null;
        Token begin;
begin = getToken(1);
    jj_consume_token(PLAYER);
    name = Identifier();
player = new Player(name);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACKET:
    case REG_IDENT:{
      PlayerItem(player);
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[40] = jj_gen;
          break label_20;
        }
        jj_consume_token(COMMA);
        PlayerItem(player);
      }
      break;
      }
    default:
      jj_la1[41] = jj_gen;
      ;
    }
    jj_consume_token(ENDPLAYER);
player.setPosition(begin, getToken(0)); {if ("" != null) return player;}
    throw new Error("Missing return statement in function");
}

// Player definition item (module or [action])
  static final public 
void PlayerItem(Player player) throws ParseException {String name = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACKET:{
      jj_consume_token(LBRACKET);
      name = Identifier();
      jj_consume_token(RBRACKET);
player.addAction(name);
      break;
      }
    case REG_IDENT:{
      name = Identifier();
player.addModule(name);
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

//-----------------------------------------------------------------------------------
// Expressions.
// This includes PRISM properties (if the "prop" parameter is true)
// and (within this) path formulas (if the "pathprop" parameter is true).
// Which allows us to use the same productions for the grammars for
// all three cases (they are very similar).
//-----------------------------------------------------------------------------------

// Expression
  static final public 
Expression Expression(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression ret;
    ret = ExpressionTemporalBinary(prop, pathprop);
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Expression: temporal operators, binary (U, W, R) and unary (X, F, G)

// Note: the potential occurrence of two successive (unseparated) expressions
// (e.g. "a" and "b" in "F<=a b") is a grammar flaw because the function and
// minus operators can cause ambiguities, for example:
// "F<=a(b)+c(d)" = "F<=a" "(b)+c(d)" = "F<=a(b)+c" "(d)" ?
// "F<=-a-b-c" = "F<=-a" "-b-c" = "F<=-a-b" "-c" ?
// In many cases, these could be distinguished by type checking but
// that does not really help since this is done post-parsing.
// To prevent (very common) cases such as "F<=t (b)", "F<=t (b)&(c)", etc.
// being mis-parsed ("t(b)" would always be taken over "t"), we catch this case
// separately (see TimeBound() production below for details).
// This means that more complex time-bounds, especially those that
// start/end with an identifier should be parenthesised, e.g. "F<=(t1+t2)".

// In fact, JavaCC also warns about lookahead for this function.
// This is because (like unary minus), R can appear on the left of a unary
// operator (reward R operator) or in the middle of a binary operator (release).
  static final public 
Expression ExpressionTemporalBinary(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression ret, expr;
        ExpressionTemporal exprTemp;
        Token begin = null;
begin = getToken(1);
    ret = ExpressionTemporalUnary(prop, pathprop);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case R:
    case U:
    case W:{
if (!pathprop) {if (true) throw generateParseException();}
exprTemp = new ExpressionTemporal(); exprTemp.setOperand1(ret);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case U:{
        jj_consume_token(U);
exprTemp.setOperator(ExpressionTemporal.P_U);
        break;
        }
      case W:{
        jj_consume_token(W);
exprTemp.setOperator(ExpressionTemporal.P_W);
        break;
        }
      case R:{
        jj_consume_token(R);
exprTemp.setOperator(ExpressionTemporal.P_R);
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:
      case EQ:
      case LT:
      case GT:
      case LE:
      case GE:{
        TimeBound(exprTemp);
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        ;
      }
      expr = ExpressionTemporalUnary(prop, pathprop);
exprTemp.setOperand2(expr); exprTemp.setPosition(begin, getToken(0)); ret = exprTemp;
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      ;
    }
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

  static final public Expression ExpressionTemporalUnary(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression ret, expr;
        ExpressionTemporal exprTemp;
        Token begin = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case F:
    case G:
    case X:{
if (!pathprop) {if (true) throw generateParseException();}
begin = getToken(1); exprTemp = new ExpressionTemporal();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case X:{
        jj_consume_token(X);
exprTemp.setOperator(ExpressionTemporal.P_X);
        break;
        }
      case F:{
        jj_consume_token(F);
exprTemp.setOperator(ExpressionTemporal.P_F);
        break;
        }
      case G:{
        jj_consume_token(G);
exprTemp.setOperator(ExpressionTemporal.P_G);
        break;
        }
      default:
        jj_la1[46] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:
      case EQ:
      case LT:
      case GT:
      case LE:
      case GE:{
        TimeBound(exprTemp);
        break;
        }
      default:
        jj_la1[47] = jj_gen;
        ;
      }
      expr = ExpressionTemporalUnary(prop, pathprop);
exprTemp.setOperand2(expr); exprTemp.setPosition(begin, getToken(0)); ret = exprTemp;
      break;
      }
    case A:
    case E:
    case FALSE:
    case FILTER:
    case FUNC:
    case MAX:
    case MIN:
    case PMAXMAX:
    case PMAXMIN:
    case PMAX:
    case PMINMAX:
    case PMINMIN:
    case PMIN:
    case P:
    case RMAXMAX:
    case RMAXMIN:
    case RMAX:
    case RMINMAX:
    case RMINMIN:
    case RMIN:
    case R:
    case S:
    case TRUE:
    case NOT:
    case LPARENTH:
    case DLBRACKET:
    case DLT:
    case MINUS:
    case DQUOTE:
    case REG_INT:
    case REG_DOUBLE:
    case REG_IDENTPRIME:
    case REG_IDENT:{
      ret = ExpressionITE(prop, pathprop);
      break;
      }
    default:
      jj_la1[48] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Time bound for temporal operators
// (see ExpressionTemporal production for lookahead explanation)
  static final public 
void TimeBound(ExpressionTemporal exprTemp) throws ParseException, PrismLangException {Expression lBound, uBound;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LE:{
      jj_consume_token(LE);
      if (jj_2_11(2147483647)) {
        uBound = IdentifierExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case A:
        case E:
        case FALSE:
        case FILTER:
        case FUNC:
        case F:
        case G:
        case MAX:
        case MIN:
        case X:
        case PMAXMAX:
        case PMAXMIN:
        case PMAX:
        case PMINMAX:
        case PMINMIN:
        case PMIN:
        case P:
        case RMAXMAX:
        case RMAXMIN:
        case RMAX:
        case RMINMAX:
        case RMINMIN:
        case RMIN:
        case R:
        case S:
        case TRUE:
        case NOT:
        case LPARENTH:
        case DLBRACKET:
        case DLT:
        case MINUS:
        case DQUOTE:
        case REG_INT:
        case REG_DOUBLE:
        case REG_IDENTPRIME:
        case REG_IDENT:{
          uBound = Expression(false, false);
          break;
          }
        default:
          jj_la1[49] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
exprTemp.setUpperBound(uBound, false);
      break;
      }
    case LT:{
      jj_consume_token(LT);
      if (jj_2_12(2147483647)) {
        uBound = IdentifierExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case A:
        case E:
        case FALSE:
        case FILTER:
        case FUNC:
        case F:
        case G:
        case MAX:
        case MIN:
        case X:
        case PMAXMAX:
        case PMAXMIN:
        case PMAX:
        case PMINMAX:
        case PMINMIN:
        case PMIN:
        case P:
        case RMAXMAX:
        case RMAXMIN:
        case RMAX:
        case RMINMAX:
        case RMINMIN:
        case RMIN:
        case R:
        case S:
        case TRUE:
        case NOT:
        case LPARENTH:
        case DLBRACKET:
        case DLT:
        case MINUS:
        case DQUOTE:
        case REG_INT:
        case REG_DOUBLE:
        case REG_IDENTPRIME:
        case REG_IDENT:{
          uBound = Expression(false, false);
          break;
          }
        default:
          jj_la1[50] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
exprTemp.setUpperBound(uBound, true);
      break;
      }
    case GE:{
      jj_consume_token(GE);
      if (jj_2_13(2147483647)) {
        lBound = IdentifierExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case A:
        case E:
        case FALSE:
        case FILTER:
        case FUNC:
        case F:
        case G:
        case MAX:
        case MIN:
        case X:
        case PMAXMAX:
        case PMAXMIN:
        case PMAX:
        case PMINMAX:
        case PMINMIN:
        case PMIN:
        case P:
        case RMAXMAX:
        case RMAXMIN:
        case RMAX:
        case RMINMAX:
        case RMINMIN:
        case RMIN:
        case R:
        case S:
        case TRUE:
        case NOT:
        case LPARENTH:
        case DLBRACKET:
        case DLT:
        case MINUS:
        case DQUOTE:
        case REG_INT:
        case REG_DOUBLE:
        case REG_IDENTPRIME:
        case REG_IDENT:{
          lBound = Expression(false, false);
          break;
          }
        default:
          jj_la1[51] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
exprTemp.setLowerBound(lBound, false);
      break;
      }
    case GT:{
      jj_consume_token(GT);
      if (jj_2_14(2147483647)) {
        lBound = IdentifierExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case A:
        case E:
        case FALSE:
        case FILTER:
        case FUNC:
        case F:
        case G:
        case MAX:
        case MIN:
        case X:
        case PMAXMAX:
        case PMAXMIN:
        case PMAX:
        case PMINMAX:
        case PMINMIN:
        case PMIN:
        case P:
        case RMAXMAX:
        case RMAXMIN:
        case RMAX:
        case RMINMAX:
        case RMINMIN:
        case RMIN:
        case R:
        case S:
        case TRUE:
        case NOT:
        case LPARENTH:
        case DLBRACKET:
        case DLT:
        case MINUS:
        case DQUOTE:
        case REG_INT:
        case REG_DOUBLE:
        case REG_IDENTPRIME:
        case REG_IDENT:{
          lBound = Expression(false, false);
          break;
          }
        default:
          jj_la1[52] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
exprTemp.setLowerBound(lBound, true);
      break;
      }
    case LBRACKET:{
      jj_consume_token(LBRACKET);
      lBound = Expression(false, false);
      jj_consume_token(COMMA);
      uBound = Expression(false, false);
      jj_consume_token(RBRACKET);
exprTemp.setLowerBound(lBound, false); exprTemp.setUpperBound(uBound, false);
      break;
      }
    case EQ:{
      jj_consume_token(EQ);
      lBound = Expression(false, false);
exprTemp.setEqualBounds(lBound);
      break;
      }
    default:
      jj_la1[53] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

// Expression: if-then-else, i.e. "cond ? then : else"
  static final public 
Expression ExpressionITE(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression ret, left, right;
        Token begin = null;
begin = getToken(1);
    ret = ExpressionImplies(prop, pathprop);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case QMARK:{
      jj_consume_token(QMARK);
      left = ExpressionImplies(prop, pathprop);
      jj_consume_token(COLON);
      right = ExpressionITE(prop, pathprop);
ret = new ExpressionITE(ret, left, right); ret.setPosition(begin, getToken(0));
      break;
      }
    default:
      jj_la1[54] = jj_gen;
      ;
    }
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Expression: implies
  static final public 
Expression ExpressionImplies(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression ret, expr;
        Token begin = null;
begin = getToken(1);
    ret = ExpressionIff(prop, pathprop);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IMPLIES:{
      jj_consume_token(IMPLIES);
      expr = ExpressionImplies(prop, pathprop);
ret = new ExpressionBinaryOp(ExpressionBinaryOp.IMPLIES, ret, expr); ret.setPosition(begin, getToken(0));
      break;
      }
    default:
      jj_la1[55] = jj_gen;
      ;
    }
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Expression: if-and-only-iff
  static final public 
Expression ExpressionIff(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression ret, expr;
        Token begin = null;
begin = getToken(1);
    ret = ExpressionOr(prop, pathprop);
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IFF:{
        ;
        break;
        }
      default:
        jj_la1[56] = jj_gen;
        break label_21;
      }
      jj_consume_token(IFF);
      expr = ExpressionOr(prop, pathprop);
ret = new ExpressionBinaryOp(ExpressionBinaryOp.IFF, ret, expr); ret.setPosition(begin, getToken(0));
    }
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Expression: or
  static final public 
Expression ExpressionOr(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression ret, expr;
        Token begin = null;
begin = getToken(1);
    ret = ExpressionAnd(prop, pathprop);
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[57] = jj_gen;
        break label_22;
      }
      jj_consume_token(OR);
      expr = ExpressionAnd(prop, pathprop);
ret = new ExpressionBinaryOp(ExpressionBinaryOp.OR, ret, expr); ret.setPosition(begin, getToken(0));
    }
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Expression: and
  static final public 
Expression ExpressionAnd(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression ret, expr;
        Token begin = null;
begin = getToken(1);
    ret = ExpressionNot(prop, pathprop);
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[58] = jj_gen;
        break label_23;
      }
      jj_consume_token(AND);
      expr = ExpressionNot(prop, pathprop);
ret = new ExpressionBinaryOp(ExpressionBinaryOp.AND, ret, expr); ret.setPosition(begin, getToken(0));
    }
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Expression: not
  static final public 
Expression ExpressionNot(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression ret, expr;
        Token begin = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      begin = jj_consume_token(NOT);
      expr = ExpressionNot(prop, pathprop);
ret = new ExpressionUnaryOp(ExpressionUnaryOp.NOT, expr); ret.setPosition(begin, getToken(0));
      break;
      }
    case A:
    case E:
    case FALSE:
    case FILTER:
    case FUNC:
    case MAX:
    case MIN:
    case PMAXMAX:
    case PMAXMIN:
    case PMAX:
    case PMINMAX:
    case PMINMIN:
    case PMIN:
    case P:
    case RMAXMAX:
    case RMAXMIN:
    case RMAX:
    case RMINMAX:
    case RMINMIN:
    case RMIN:
    case R:
    case S:
    case TRUE:
    case LPARENTH:
    case DLBRACKET:
    case DLT:
    case MINUS:
    case DQUOTE:
    case REG_INT:
    case REG_DOUBLE:
    case REG_IDENTPRIME:
    case REG_IDENT:{
      ret = ExpressionEquality(prop, pathprop);
      break;
      }
    default:
      jj_la1[59] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Expression: equality operators: =, !=
  static final public 
Expression ExpressionEquality(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression ret, expr;
        int op;
        Token begin = null;
begin = getToken(1);
    ret = ExpressionRelop(prop, pathprop);
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQ:
      case NE:{
        ;
        break;
        }
      default:
        jj_la1[60] = jj_gen;
        break label_24;
      }
      op = EqNeq();
      expr = ExpressionRelop(prop, pathprop);
ret = new ExpressionBinaryOp(op, ret, expr); ret.setPosition(begin, getToken(0));
    }
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Expression: relational operators: >, <, >=, <=
  static final public 
Expression ExpressionRelop(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression ret, expr;
        int op;
        Token begin = null;
begin = getToken(1);
    ret = ExpressionPlusMinus(prop, pathprop);
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LT:
      case GT:
      case LE:
      case GE:{
        ;
        break;
        }
      default:
        jj_la1[61] = jj_gen;
        break label_25;
      }
      op = LtGt();
      expr = ExpressionPlusMinus(prop, pathprop);
ret = new ExpressionBinaryOp(op, ret, expr); ret.setPosition(begin, getToken(0));
    }
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Expression: plus/minus

// JavaCC warns about lookahead for this function. This is because in a few places
// (bounded temporal operators and semicolon-less properties files)
// (see the relevant productions for details)
// we allow two or more successive expressions resulting in potential ambiguities
// e.g. "-a-b" = "(-a)-b" = "-a" "-b"
// Ignoring the warning results in the largest match being taken.
  static final public 
Expression ExpressionPlusMinus(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression ret, expr;
        int op;
        Token begin = null;
begin = getToken(1);
    ret = ExpressionTimesDivide(prop, pathprop);
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[62] = jj_gen;
        break label_26;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
op = ExpressionBinaryOp.PLUS;
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
op = ExpressionBinaryOp.MINUS;
        break;
        }
      default:
        jj_la1[63] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr = ExpressionTimesDivide(prop, pathprop);
ret = new ExpressionBinaryOp(op, ret, expr); ret.setPosition(begin, getToken(0));
    }
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Expression: times/divide
  static final public 
Expression ExpressionTimesDivide(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression ret, expr;
        int op;
        Token begin = null;
begin = getToken(1);
    ret = ExpressionPower(prop, pathprop);
    label_27:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TIMES:
      case DIVIDE:{
        ;
        break;
        }
      default:
        jj_la1[64] = jj_gen;
        break label_27;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TIMES:{
        jj_consume_token(TIMES);
op = ExpressionBinaryOp.TIMES;
        break;
        }
      case DIVIDE:{
        jj_consume_token(DIVIDE);
op = ExpressionBinaryOp.DIVIDE;
        break;
        }
      default:
        jj_la1[65] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr = ExpressionPower(prop, pathprop);
ret = new ExpressionBinaryOp(op, ret, expr); ret.setPosition(begin, getToken(0));
    }
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Expression: power (^)
  static final public 
Expression ExpressionPower(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression ret, expr;
        int op;
        Token begin = null;
begin = getToken(1);
    ret = ExpressionUnaryMinus(prop, pathprop);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case POWER:{
      jj_consume_token(POWER);
      expr = ExpressionPower(prop, pathprop);
ret = new ExpressionBinaryOp(ExpressionBinaryOp.POW, ret, expr); ret.setPosition(begin, getToken(0));
      break;
      }
    default:
      jj_la1[66] = jj_gen;
      ;
    }
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Expression: unary minus
  static final public 
Expression ExpressionUnaryMinus(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression ret, expr;
        Token begin = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:{
      begin = jj_consume_token(MINUS);
      expr = ExpressionUnaryMinus(prop, pathprop);
ret = new ExpressionUnaryOp(ExpressionUnaryOp.MINUS, expr); ret.setPosition(begin, getToken(0));
      break;
      }
    case A:
    case E:
    case FALSE:
    case FILTER:
    case FUNC:
    case MAX:
    case MIN:
    case PMAXMAX:
    case PMAXMIN:
    case PMAX:
    case PMINMAX:
    case PMINMIN:
    case PMIN:
    case P:
    case RMAXMAX:
    case RMAXMIN:
    case RMAX:
    case RMINMAX:
    case RMINMIN:
    case RMIN:
    case R:
    case S:
    case TRUE:
    case LPARENTH:
    case DLBRACKET:
    case DLT:
    case DQUOTE:
    case REG_INT:
    case REG_DOUBLE:
    case REG_IDENTPRIME:
    case REG_IDENT:{
      ret = ExpressionBasic(prop, pathprop);
      break;
      }
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Basic expression (top of operator precedence ordering)
  static final public 
Expression ExpressionBasic(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FALSE:
    case TRUE:
    case REG_INT:
    case REG_DOUBLE:{
      ret = ExpressionLiteral(prop, pathprop);
      break;
      }
    case REG_IDENTPRIME:
    case REG_IDENT:{
      ret = ExpressionFuncOrIdent(prop, pathprop);
      break;
      }
    case MAX:
    case MIN:{
      ret = ExpressionFuncMinMax(prop, pathprop);
      break;
      }
    case FUNC:{
      ret = ExpressionFuncOldStyle(prop, pathprop);
      break;
      }
    case LPARENTH:{
      ret = ExpressionParenth(prop, pathprop);
      break;
      }
    case PMAXMAX:
    case PMAXMIN:
    case PMAX:
    case PMINMAX:
    case PMINMIN:
    case PMIN:
    case P:{
      // Remaining options are only applicable for properties
                      ret = ExpressionProb(prop, pathprop);
      break;
      }
    case S:{
      ret = ExpressionSS(prop, pathprop);
      break;
      }
    case RMAXMAX:
    case RMAXMIN:
    case RMAX:
    case RMINMAX:
    case RMINMIN:
    case RMIN:
    case R:{
      ret = ExpressionReward(prop, pathprop);
      break;
      }
    case E:{
      ret = ExpressionExists(prop, pathprop);
      break;
      }
    case A:{
      ret = ExpressionForAll(prop, pathprop);
      break;
      }
    case DLBRACKET:
    case DLT:{
      ret = ExpressionStrategy(prop, pathprop);
      break;
      }
    case DQUOTE:{
      ret = ExpressionLabel(prop, pathprop);
      break;
      }
    case FILTER:{
      ret = ExpressionFilter(prop, pathprop);
      break;
      }
    default:
      jj_la1[68] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Expression: function or identifier

// JavaCC warns about lookahead for this function. This is because in a few places
// (bounded temporal operators and semicolon-less properties files)
// (see the relevant productions for details)
// we allow two or more successive expressions resulting in potential ambiguities
// e.g. "a(b)" = "a" "(b)"
// Ignoring the warning results in the largest match being taken.
  static final public 
Expression ExpressionFuncOrIdent(boolean prop, boolean pathprop) throws ParseException, PrismLangException {String s = null;
        Expression ret = null;
        Token begin = null;
        ExpressionIdent p;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case REG_IDENT:{
      s = Identifier();
ret = new ExpressionIdent(s); begin = getToken(0);
      break;
      }
    case REG_IDENTPRIME:{
      p = IdentifierPrime();
ret = p; ; begin = getToken(0);
      break;
      }
    default:
      jj_la1[69] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPARENTH:{
      jj_consume_token(LPARENTH);
ret = new ExpressionFunc(s);
      ExpressionFuncArgs(prop, pathprop, (ExpressionFunc)ret);
      jj_consume_token(RPARENTH);
      break;
      }
    default:
      jj_la1[70] = jj_gen;
      ;
    }
ret.setPosition(begin, getToken(0)); {if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Expression: min/max function (treated differently because min/max are keywords)
  static final public 
Expression ExpressionFuncMinMax(boolean prop, boolean pathprop) throws ParseException, PrismLangException {String s = null;
        ExpressionFunc func = null;
        Token begin = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MIN:{
      begin = jj_consume_token(MIN);
s = "min";
      break;
      }
    case MAX:{
      begin = jj_consume_token(MAX);
s = "max";
      break;
      }
    default:
      jj_la1[71] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
func = new ExpressionFunc(s);
    jj_consume_token(LPARENTH);
    ExpressionFuncArgs(prop, pathprop, func);
    jj_consume_token(RPARENTH);
func.setPosition(begin, getToken(0)); {if ("" != null) return func;}
    throw new Error("Missing return statement in function");
}

// Expression: old-style function, i.e. "func(name, ...)"
  static final public 
Expression ExpressionFuncOldStyle(boolean prop, boolean pathprop) throws ParseException, PrismLangException {String s = null;
        ExpressionFunc func = null;
        Token begin = null;
    begin = jj_consume_token(FUNC);
    jj_consume_token(LPARENTH);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MIN:{
      jj_consume_token(MIN);
s = "min";
      break;
      }
    case MAX:{
      jj_consume_token(MAX);
s = "max";
      break;
      }
    case REG_IDENT:{
      s = Identifier();
      break;
      }
    default:
      jj_la1[72] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(COMMA);
func = new ExpressionFunc(s); func.setOldStyle(true);
    ExpressionFuncArgs(prop, pathprop, func);
    jj_consume_token(RPARENTH);
func.setPosition(begin, getToken(0)); {if ("" != null) return func;}
    throw new Error("Missing return statement in function");
}

// Arguments for a function in an expression
  static final public 
void ExpressionFuncArgs(boolean prop, boolean pathprop, ExpressionFunc func) throws ParseException, PrismLangException {Expression expr;
    expr = Expression(prop, pathprop);
func.addOperand(expr);
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[73] = jj_gen;
        break label_28;
      }
      jj_consume_token(COMMA);
      expr = Expression(prop, pathprop);
func.addOperand(expr);
    }
}

// Expression: literal
  static final public 
Expression ExpressionLiteral(boolean prop, boolean pathprop) throws ParseException {Expression ret = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case REG_INT:{
      jj_consume_token(REG_INT);
try {
                        int i = Integer.parseInt(getToken(0).image);
                        ret = new ExpressionLiteral(TypeInt.getInstance(), Integer.valueOf(i));
                } catch (NumberFormatException e) {
                        // Need to catch this because some matches for regexp REG_INT
                        // are not valid integers (e.g. too big).
                        ParseException ex = new ParseException("Invalid integer literal");
                        ex.currentToken = getToken(0);
                        {if (true) throw ex;}
                        // NB: can't call generateParseException() here; it crashes
                }
      break;
      }
    case REG_DOUBLE:{
      jj_consume_token(REG_DOUBLE);
try {
                        double d = Double.parseDouble(getToken(0).image);
                        ret = new ExpressionLiteral(TypeDouble.getInstance(), Double.valueOf(d), getToken(0).image);
                } catch (NumberFormatException e) {
                        // Need to catch this because some matches for regexp REG_DOUBLE
                        // may not be valid doubles.
                        ParseException ex = new ParseException("Invalid double literal");
                        // NB: can't call generateParseException() here; it crashes
                }
      break;
      }
    case TRUE:{
      jj_consume_token(TRUE);
ret = new ExpressionLiteral(TypeBool.getInstance(), Boolean.valueOf(true));
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
ret = new ExpressionLiteral(TypeBool.getInstance(), Boolean.valueOf(false));
      break;
      }
    default:
      jj_la1[74] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
ret.setPosition(getToken(0)); {if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Expression: parentheses
  static final public 
Expression ExpressionParenth(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression expr, ret;
        Token begin = null;
    begin = jj_consume_token(LPARENTH);
    expr = Expression(prop, pathprop);
    jj_consume_token(RPARENTH);
ret = new ExpressionUnaryOp(ExpressionUnaryOp.PARENTH, expr); ret.setPosition(begin, getToken(0)); {if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Expression: interval
  static final public 
Expression ExpressionInterval(boolean prop, boolean pathprop) throws ParseException, PrismLangException {ExpressionInterval expr = null;
        Expression expr1 = null, expr2 = null;
        Token begin = null;
    begin = jj_consume_token(LBRACKET);
    expr1 = Expression(prop, pathprop);
    jj_consume_token(COMMA);
    expr2 = Expression(prop, pathprop);
    jj_consume_token(RBRACKET);
expr = new ExpressionInterval(expr1, expr2); expr.setPosition(begin, getToken(0)); {if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
}

//-----------------------------------------------------------------------------------
// Property stuff
//-----------------------------------------------------------------------------------

// (Property) expression: probabilistic operator P
  static final public 
Expression ExpressionProb(boolean prop, boolean pathprop) throws ParseException, PrismLangException {ExpressionIdent modifier = null;
        int r;
        String relOp = null;
        Expression prob = null;
        Expression expr;
        Filter filter = null;
        ExpressionProb ret = new ExpressionProb();
        Token begin = null;
        boolean isBool;
if (!prop) {if (true) throw generateParseException();}
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case P:{
      begin = jj_consume_token(P);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPARENTH:{
        jj_consume_token(LPARENTH);
        modifier = IdentifierExpression();
        jj_consume_token(RPARENTH);
        break;
        }
      default:
        jj_la1[75] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LT:
      case GT:
      case LE:
      case GE:{
        r = LtGt();
        prob = Expression(false, false);
relOp = ExpressionBinaryOp.opSymbols[r]; isBool = true;
        break;
        }
      case EQ:{
        jj_consume_token(EQ);
        jj_consume_token(QMARK);
relOp = "="; isBool = false;
        break;
        }
      case MIN:{
        jj_consume_token(MIN);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EQ:{
          jj_consume_token(EQ);
          jj_consume_token(QMARK);
relOp = "min="; isBool = false;
          break;
          }
        case MIN:{
          jj_consume_token(MIN);
          jj_consume_token(EQ);
          jj_consume_token(QMARK);
relOp = "minmin="; isBool = false;
          break;
          }
        case MAX:{
          jj_consume_token(MAX);
          jj_consume_token(EQ);
          jj_consume_token(QMARK);
relOp = "minmax="; isBool = false;
          break;
          }
        default:
          jj_la1[76] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case MAX:{
        jj_consume_token(MAX);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EQ:{
          jj_consume_token(EQ);
          jj_consume_token(QMARK);
relOp = "max="; isBool = false;
          break;
          }
        case MIN:{
          jj_consume_token(MIN);
          jj_consume_token(EQ);
          jj_consume_token(QMARK);
relOp = "maxmin="; isBool = false;
          break;
          }
        case MAX:{
          jj_consume_token(MAX);
          jj_consume_token(EQ);
          jj_consume_token(QMARK);
relOp = "maxmax="; isBool = false;
          break;
          }
        default:
          jj_la1[77] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case MINMIN:{
        jj_consume_token(MINMIN);
        jj_consume_token(EQ);
        jj_consume_token(QMARK);
relOp = "minmin="; isBool = false;
        break;
        }
      case MINMAX:{
        jj_consume_token(MINMAX);
        jj_consume_token(EQ);
        jj_consume_token(QMARK);
relOp = "minmax="; isBool = false;
        break;
        }
      case MAXMIN:{
        jj_consume_token(MAXMIN);
        jj_consume_token(EQ);
        jj_consume_token(QMARK);
relOp = "maxmin="; isBool = false;
        break;
        }
      case MAXMAX:{
        jj_consume_token(MAXMAX);
        jj_consume_token(EQ);
        jj_consume_token(QMARK);
relOp = "maxmax="; isBool = false;
        break;
        }
      default:
        jj_la1[78] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case PMIN:{
      begin = jj_consume_token(PMIN);
      jj_consume_token(EQ);
      jj_consume_token(QMARK);
relOp = "min="; isBool = false;
      break;
      }
    case PMAX:{
      begin = jj_consume_token(PMAX);
      jj_consume_token(EQ);
      jj_consume_token(QMARK);
relOp = "max="; isBool = false;
      break;
      }
    case PMINMIN:{
      begin = jj_consume_token(PMINMIN);
      jj_consume_token(EQ);
      jj_consume_token(QMARK);
relOp = "minmin="; isBool = false;
      break;
      }
    case PMINMAX:{
      begin = jj_consume_token(PMINMAX);
      jj_consume_token(EQ);
      jj_consume_token(QMARK);
relOp = "minmax="; isBool = false;
      break;
      }
    case PMAXMIN:{
      begin = jj_consume_token(PMAXMIN);
      jj_consume_token(EQ);
      jj_consume_token(QMARK);
relOp = "maxmin="; isBool = false;
      break;
      }
    case PMAXMAX:{
      begin = jj_consume_token(PMAXMAX);
      jj_consume_token(EQ);
      jj_consume_token(QMARK);
relOp = "maxmax="; isBool = false;
      break;
      }
    default:
      jj_la1[79] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACKET);
    expr = Expression(prop, true);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACE:{
      filter = Filter();
      break;
      }
    default:
      jj_la1[80] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
ret.setModifier(modifier == null ? null : modifier.getName());
                ret.setRelOp(relOp);
                ret.setProb(prob);
                ret.setExpression(expr);
                ret.setFilter(filter);
                ret.setPosition(begin, getToken(0));
                // Filter is actually dealt with by wrapping this expression in
                // an (invisible) ExpressionFilter expression
                if (filter != null) {
                        String filterOp = isBool ? "&" : filter.getFilterOpString();
                        ExpressionFilter ef = new ExpressionFilter(filterOp, ret, filter.getExpression());
                        ef.setInvisible(true);
                        {if ("" != null) return ef;}
                }
                else {if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Filter for a P/S/R operator
  static final public 
Filter Filter() throws ParseException, PrismLangException {Filter filter;
        Expression expr;
        Token begin = null;
    begin = jj_consume_token(LBRACE);
    expr = Expression(true, false);
filter = new Filter(expr);
    jj_consume_token(RBRACE);
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACE:{
        ;
        break;
        }
      default:
        jj_la1[81] = jj_gen;
        break label_29;
      }
      jj_consume_token(LBRACE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MIN:{
        jj_consume_token(MIN);
filter.setMinRequested(true);
        break;
        }
      case MAX:{
        jj_consume_token(MAX);
filter.setMaxRequested(true);
        break;
        }
      default:
        jj_la1[82] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RBRACE);
    }
filter.setPosition(begin, getToken(0)); {if ("" != null) return filter;}
    throw new Error("Missing return statement in function");
}

// (Property) expression: steady-state operator S
  static final public 
Expression ExpressionSS(boolean prop, boolean pathprop) throws ParseException, PrismLangException {ExpressionIdent modifier = null;
        int r;
        String relOp = null;
        Expression prob = null;
        Expression expr;
        Filter filter = null;
        ExpressionSS ret = new ExpressionSS();
        Token begin;
        boolean isBool;
if (!prop) {if (true) throw generateParseException();}
    // Various options for "S" keyword and attached symbols
            begin = jj_consume_token(S);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPARENTH:
    case LT:
    case GT:
    case LE:
    case GE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPARENTH:{
        jj_consume_token(LPARENTH);
        modifier = IdentifierExpression();
        jj_consume_token(RPARENTH);
        break;
        }
      default:
        jj_la1[83] = jj_gen;
        ;
      }
      r = LtGt();
      prob = Expression(false, false);
relOp = ExpressionBinaryOp.opSymbols[r]; isBool = true;
      break;
      }
    case EQ:{
      jj_consume_token(EQ);
      jj_consume_token(QMARK);
relOp = "="; isBool = false;
      break;
      }
    default:
      jj_la1[84] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACKET);
    expr = Expression(prop, pathprop);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACE:{
      filter = Filter();
      break;
      }
    default:
      jj_la1[85] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
ret.setModifier(modifier == null ? null : modifier.getName());
                ret.setRelOp(relOp);
                ret.setProb(prob);
                ret.setExpression(expr);
                ret.setFilter(filter);
                ret.setPosition(begin, getToken(0));
                // Filter is actually dealt with by wrapping this expression in
                // an (invisible) ExpressionFilter expression
                if (filter != null) {
                        String filterOp = isBool ? "&" : filter.getFilterOpString();
                        ExpressionFilter ef = new ExpressionFilter(filterOp, ret, filter.getExpression());
                        ef.setInvisible(true);
                        {if ("" != null) return ef;}
                }
                else {if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// (Property) expression: expected reward operator R
  static final public 
Expression ExpressionReward(boolean prop, boolean pathprop) throws ParseException, PrismLangException {ExpressionIdent modifier = null;
        int r;
        String relOp = null;
        Expression rew = null;
        Expression expr;
        Filter filter = null;
        ExpressionReward ret = new ExpressionReward();
        Token begin;
        boolean isBool;
if (!prop) {if (true) throw generateParseException();}
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case R:{
      begin = jj_consume_token(R);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPARENTH:{
        jj_consume_token(LPARENTH);
        modifier = IdentifierExpression();
        jj_consume_token(RPARENTH);
        break;
        }
      default:
        jj_la1[86] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACE:{
        RewardIndex(ret);
        break;
        }
      default:
        jj_la1[87] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LT:
      case GT:
      case LE:
      case GE:{
        r = LtGt();
        rew = Expression(false, false);
relOp = ExpressionBinaryOp.opSymbols[r]; isBool = true;
        break;
        }
      case EQ:{
        jj_consume_token(EQ);
        jj_consume_token(QMARK);
relOp = "="; isBool = false;
        break;
        }
      case MIN:{
        jj_consume_token(MIN);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EQ:{
          jj_consume_token(EQ);
          jj_consume_token(QMARK);
relOp = "min="; isBool = false;
          break;
          }
        case MIN:{
          jj_consume_token(MIN);
          jj_consume_token(EQ);
          jj_consume_token(QMARK);
relOp = "minmin="; isBool = false;
          break;
          }
        case MAX:{
          jj_consume_token(MAX);
          jj_consume_token(EQ);
          jj_consume_token(QMARK);
relOp = "minmax="; isBool = false;
          break;
          }
        default:
          jj_la1[88] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case MAX:{
        jj_consume_token(MAX);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EQ:{
          jj_consume_token(EQ);
          jj_consume_token(QMARK);
relOp = "max="; isBool = false;
          break;
          }
        case MIN:{
          jj_consume_token(MIN);
          jj_consume_token(EQ);
          jj_consume_token(QMARK);
relOp = "maxmin="; isBool = false;
          break;
          }
        case MAX:{
          jj_consume_token(MAX);
          jj_consume_token(EQ);
          jj_consume_token(QMARK);
relOp = "maxmax="; isBool = false;
          break;
          }
        default:
          jj_la1[89] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case MINMIN:{
        jj_consume_token(MINMIN);
        jj_consume_token(EQ);
        jj_consume_token(QMARK);
relOp = "minmin="; isBool = false;
        break;
        }
      case MINMAX:{
        jj_consume_token(MINMAX);
        jj_consume_token(EQ);
        jj_consume_token(QMARK);
relOp = "minmax="; isBool = false;
        break;
        }
      case MAXMIN:{
        jj_consume_token(MAXMIN);
        jj_consume_token(EQ);
        jj_consume_token(QMARK);
relOp = "maxmin="; isBool = false;
        break;
        }
      case MAXMAX:{
        jj_consume_token(MAXMAX);
        jj_consume_token(EQ);
        jj_consume_token(QMARK);
relOp = "maxmax="; isBool = false;
        break;
        }
      default:
        jj_la1[90] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case RMIN:{
      begin = jj_consume_token(RMIN);
      jj_consume_token(EQ);
      jj_consume_token(QMARK);
relOp = "min="; isBool = false;
      break;
      }
    case RMAX:{
      begin = jj_consume_token(RMAX);
      jj_consume_token(EQ);
      jj_consume_token(QMARK);
relOp = "max="; isBool = false;
      break;
      }
    case RMINMIN:{
      begin = jj_consume_token(RMINMIN);
      jj_consume_token(EQ);
      jj_consume_token(QMARK);
relOp = "minmin="; isBool = false;
      break;
      }
    case RMINMAX:{
      begin = jj_consume_token(RMINMAX);
      jj_consume_token(EQ);
      jj_consume_token(QMARK);
relOp = "minmax="; isBool = false;
      break;
      }
    case RMAXMIN:{
      begin = jj_consume_token(RMAXMIN);
      jj_consume_token(EQ);
      jj_consume_token(QMARK);
relOp = "maxmin="; isBool = false;
      break;
      }
    case RMAXMAX:{
      begin = jj_consume_token(RMAXMAX);
      jj_consume_token(EQ);
      jj_consume_token(QMARK);
relOp = "maxmax="; isBool = false;
      break;
      }
    default:
      jj_la1[91] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACKET);
    expr = ExpressionRewardContents(prop, pathprop);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACE:{
      filter = Filter();
      break;
      }
    default:
      jj_la1[92] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
ret.setModifier(modifier == null ? null : modifier.getName());
                ret.setRelOp(relOp);
                ret.setReward(rew);
                ret.setExpression(expr);
                ret.setFilter(filter);
                ret.setPosition(begin, getToken(0));
                // Filter is actually dealt with by wrapping this expression in
                // an (invisible) ExpressionFilter expression
                if (filter != null) {
                        String filterOp = isBool ? "&" : filter.getFilterOpString();
                        ExpressionFilter ef = new ExpressionFilter(filterOp, ret, filter.getExpression());
                        ef.setInvisible(true);
                        {if ("" != null) return ef;}
                }
                else {if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Reward struct index for R operator
  static final public 
void RewardIndex(ExpressionReward exprRew) throws ParseException, PrismLangException {Object index = null;
        Object indexDiv = null;
        Object discount = null;
    jj_consume_token(LBRACE);
    if (jj_2_15(2147483647)) {
      jj_consume_token(DQUOTE);
      index = Identifier();
      jj_consume_token(DQUOTE);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISCOUNT:{
        jj_consume_token(DISCOUNT);
        jj_consume_token(EQ);
        discount = Expression(false, false);
        break;
        }
      case A:
      case E:
      case FALSE:
      case FILTER:
      case FUNC:
      case F:
      case G:
      case MAX:
      case MIN:
      case X:
      case PMAXMAX:
      case PMAXMIN:
      case PMAX:
      case PMINMAX:
      case PMINMIN:
      case PMIN:
      case P:
      case RMAXMAX:
      case RMAXMIN:
      case RMAX:
      case RMINMAX:
      case RMINMIN:
      case RMIN:
      case R:
      case S:
      case TRUE:
      case NOT:
      case LPARENTH:
      case DLBRACKET:
      case DLT:
      case MINUS:
      case DQUOTE:
      case REG_INT:
      case REG_DOUBLE:
      case REG_IDENTPRIME:
      case REG_IDENT:{
        index = Expression(false, false);
        break;
        }
      default:
        jj_la1[93] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      jj_consume_token(DISCOUNT);
      jj_consume_token(EQ);
      discount = Expression(false,false);
      break;
      }
    default:
      jj_la1[94] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DIVIDE:{
      jj_consume_token(DIVIDE);
      jj_consume_token(LBRACE);
      if (jj_2_16(2147483647)) {
        jj_consume_token(DQUOTE);
        indexDiv = Identifier();
        jj_consume_token(DQUOTE);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case A:
        case E:
        case FALSE:
        case FILTER:
        case FUNC:
        case F:
        case G:
        case MAX:
        case MIN:
        case X:
        case PMAXMAX:
        case PMAXMIN:
        case PMAX:
        case PMINMAX:
        case PMINMIN:
        case PMIN:
        case P:
        case RMAXMAX:
        case RMAXMIN:
        case RMAX:
        case RMINMAX:
        case RMINMIN:
        case RMIN:
        case R:
        case S:
        case TRUE:
        case NOT:
        case LPARENTH:
        case DLBRACKET:
        case DLT:
        case MINUS:
        case DQUOTE:
        case REG_INT:
        case REG_DOUBLE:
        case REG_IDENTPRIME:
        case REG_IDENT:{
          indexDiv = Expression(false, false);
          break;
          }
        default:
          jj_la1[95] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RBRACE);
      break;
      }
    default:
      jj_la1[96] = jj_gen;
      ;
    }
exprRew.setRewardStructIndex(index);
                if (indexDiv != null) {
                        exprRew.setRewardStructIndexDiv(indexDiv);
                }
                if (discount != null) {
                        exprRew.setDiscount(discount);
                }
}

// Contents of an R operator

// JavaCC warns about lookahead for this function. This is because there is a possible conflict between
// R [ S ], where "S" is the long-run reward operator, and R [ S [ ] ], where "S [ ]" is an LTL formula
// comprising a single atomic proposition. We use lookahead to resolve the ambiguity.
  static final public 
Expression ExpressionRewardContents(boolean prop, boolean pathprop) throws ParseException, PrismLangException {Expression expr = null;
        ExpressionTemporal exprTemp = null;
        Expression ret = null;
        Token begin;
begin = getToken(1);
    if (jj_2_17(2147483647)) {
      expr = ExpressionSS(prop, true);
ret = expr;
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        jj_consume_token(S);
ret = new ExpressionTemporal(ExpressionTemporal.R_S, null, null);
        break;
        }
      default:
        jj_la1[97] = jj_gen;
        if (jj_2_18(2147483647)) {
          begin = jj_consume_token(C);
          jj_consume_token(LE);
          expr = Expression(false, false);
exprTemp = new ExpressionTemporal(ExpressionTemporal.R_C, null, null); exprTemp.setUpperBound(expr); ret = exprTemp;
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case C:{
            jj_consume_token(C);
ret = new ExpressionTemporal(ExpressionTemporal.R_C, null, null);
            break;
            }
          case I:{
            jj_consume_token(I);
            jj_consume_token(EQ);
            expr = Expression(false, false);
exprTemp = new ExpressionTemporal(ExpressionTemporal.R_I, null, null); exprTemp.setUpperBound(expr); ret = exprTemp;
            break;
            }
          case Fc:{
            jj_consume_token(Fc);
            expr = Expression(prop, pathprop);
ret = new ExpressionTemporal(ExpressionTemporal.R_Fc, null, expr);
            break;
            }
          case F0:{
            jj_consume_token(F0);
            expr = Expression(prop, pathprop);
ret = new ExpressionTemporal(ExpressionTemporal.R_F0, null, expr);
            break;
            }
          case A:
          case E:
          case FALSE:
          case FILTER:
          case FUNC:
          case F:
          case G:
          case MAX:
          case MIN:
          case X:
          case PMAXMAX:
          case PMAXMIN:
          case PMAX:
          case PMINMAX:
          case PMINMIN:
          case PMIN:
          case P:
          case RMAXMAX:
          case RMAXMIN:
          case RMAX:
          case RMINMAX:
          case RMINMIN:
          case RMIN:
          case R:
          case S:
          case TRUE:
          case NOT:
          case LPARENTH:
          case DLBRACKET:
          case DLT:
          case MINUS:
          case DQUOTE:
          case REG_INT:
          case REG_DOUBLE:
          case REG_IDENTPRIME:
          case REG_IDENT:{
            expr = Expression(prop, true);
ret = expr;
            break;
            }
          default:
            jj_la1[98] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
ret.setPosition(begin, getToken(0)); {if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// (Property) expression: n-player Nash operator
  static final public 
Expression ExpressionMultiNash(boolean prop, boolean pathprop) throws ParseException, PrismLangException {ExpressionMultiNash ret = new ExpressionMultiNash();
        Expression bound = null;
        ArrayList<Expression> formulae = new ArrayList<Expression>();
        ExpressionQuant expr;
        String relOp = null;
        boolean isBool;
        int r;
        int n = 0;
if (!prop) {if (true) throw generateParseException();}
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MIN:{
      jj_consume_token(MIN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LT:
      case GT:
      case LE:
      case GE:{
        r = LtGt();
        bound = Expression(false, false);
relOp = ExpressionBinaryOp.opSymbols[r]; isBool = true;
        break;
        }
      case EQ:{
        jj_consume_token(EQ);
        jj_consume_token(QMARK);
relOp = "min="; isBool = false;
        break;
        }
      default:
        jj_la1[99] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case MAX:{
      jj_consume_token(MAX);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LT:
      case GT:
      case LE:
      case GE:{
        r = LtGt();
        bound = Expression(false, false);
relOp = ExpressionBinaryOp.opSymbols[r]; isBool = true;
        break;
        }
      case EQ:{
        jj_consume_token(EQ);
        jj_consume_token(QMARK);
relOp = "max="; isBool = false;
        break;
        }
      default:
        jj_la1[100] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[101] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LPARENTH);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case P:{
      expr = ExpressionMultiNashProb(prop, true);
      break;
      }
    case R:{
      expr = ExpressionMultiNashReward(prop, true);
      break;
      }
    default:
      jj_la1[102] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
ret.addOperand(expr);
    label_30:
    while (true) {
      jj_consume_token(PLUS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case P:{
        expr = ExpressionMultiNashProb(prop, true);
        break;
        }
      case R:{
        expr = ExpressionMultiNashReward(prop, true);
        break;
        }
      default:
        jj_la1[103] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
ret.addOperand(expr);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        ;
        break;
        }
      default:
        jj_la1[104] = jj_gen;
        break label_30;
      }
    }
    jj_consume_token(RPARENTH);
ret.setBound(bound);
                ret.setRelOp(relOp);
                {if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// (Property) expression: probabilistic operator (n-player Nash)
  static final public 
ExpressionQuant ExpressionMultiNashProb(boolean prop, boolean pathprop) throws ParseException, PrismLangException {ExpressionMultiNashProb ret = new ExpressionMultiNashProb();
        Expression expr = null;
        Token begin;
if (!prop) {if (true) throw generateParseException();}
    begin = jj_consume_token(P);
    jj_consume_token(LBRACKET);
    expr = Expression(prop, true);
    jj_consume_token(RBRACKET);
ret.setExpression(expr);
                ret.setPosition(begin, getToken(0));
                {if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// (Property) expression: reward operator (n-player Nash)
  static final public 
ExpressionQuant ExpressionMultiNashReward(boolean prop, boolean pathprop) throws ParseException, PrismLangException {ExpressionMultiNashReward ret = new ExpressionMultiNashReward();
        Expression expr = null;
        Token begin;
if (!prop) {if (true) throw generateParseException();}
    begin = jj_consume_token(R);
    MultiNashRewardIndexes(ret);
    jj_consume_token(LBRACKET);
    expr = ExpressionRewardContents(prop, pathprop);
    jj_consume_token(RBRACKET);
ret.setExpression(expr);
                ret.setPosition(begin, getToken(0));
                {if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// (Reward) structure index for equilibria
  static final public 
void MultiNashRewardIndexes(ExpressionMultiNashReward exprMultiNash) throws ParseException, PrismLangException {Object index = null;
    jj_consume_token(LBRACE);
    if (jj_2_19(2147483647)) {
      jj_consume_token(DQUOTE);
      index = Identifier();
      jj_consume_token(DQUOTE);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case A:
      case E:
      case FALSE:
      case FILTER:
      case FUNC:
      case F:
      case G:
      case MAX:
      case MIN:
      case X:
      case PMAXMAX:
      case PMAXMIN:
      case PMAX:
      case PMINMAX:
      case PMINMIN:
      case PMIN:
      case P:
      case RMAXMAX:
      case RMAXMIN:
      case RMAX:
      case RMINMAX:
      case RMINMIN:
      case RMIN:
      case R:
      case S:
      case TRUE:
      case NOT:
      case LPARENTH:
      case DLBRACKET:
      case DLT:
      case MINUS:
      case DQUOTE:
      case REG_INT:
      case REG_DOUBLE:
      case REG_IDENTPRIME:
      case REG_IDENT:{
        index = Expression(false, false);
        break;
        }
      default:
        jj_la1[105] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
exprMultiNash.setRewardStructIndex(index);
}

// (Property) expression: CTL existential operator E
  static final public 
Expression ExpressionExists(boolean prop, boolean pathprop) throws ParseException, PrismLangException {ExpressionExists ret = new ExpressionExists();
        Expression expr;
        Token begin = null;
if (!prop) {if (true) throw generateParseException();}
    begin = jj_consume_token(E);
    jj_consume_token(LBRACKET);
    expr = Expression(prop, true);
    jj_consume_token(RBRACKET);
ret.setExpression(expr);
                ret.setPosition(begin, getToken(0));
                {if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// (Property) expression: CTL universal operator A
  static final public 
Expression ExpressionForAll(boolean prop, boolean pathprop) throws ParseException, PrismLangException {ExpressionForAll ret = new ExpressionForAll();
        Expression expr;
        Token begin = null;
if (!prop) {if (true) throw generateParseException();}
    begin = jj_consume_token(A);
    jj_consume_token(LBRACKET);
    expr = Expression(prop, true);
    jj_consume_token(RBRACKET);
ret.setExpression(expr);
                ret.setPosition(begin, getToken(0));
                {if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// (Property) expression: ATL strategy operators <<>> and [[]]
  static final public 
Expression ExpressionStrategy(boolean prop, boolean pathprop) throws ParseException, PrismLangException {ExpressionStrategy ret;
        Expression expr;
        List<Coalition> coalitions;
        ArrayList<Expression> optionsSpec = null;
        Token begin = null;
if (!prop) {if (true) throw generateParseException();}
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DLT:{
      begin = jj_consume_token(DLT);
ret = new ExpressionStrategy(true);
      coalitions = ExpressionStrategyCoalitionList();
      jj_consume_token(DGT);
      break;
      }
    case DLBRACKET:{
      begin = jj_consume_token(DLBRACKET);
ret = new ExpressionStrategy(false);
      coalitions = ExpressionStrategyCoalitionList();
      jj_consume_token(DRBRACKET);
      break;
      }
    default:
      jj_la1[106] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
ret.setCoalitions(coalitions);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACE:{
      jj_consume_token(LBRACE);
      optionsSpec = ExpressionStrategyOptions();
      jj_consume_token(RBRACE);
      break;
      }
    default:
      jj_la1[107] = jj_gen;
      ;
    }
ret.processOptions(optionsSpec);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MAX:
    case MIN:
    case PMAXMAX:
    case PMAXMIN:
    case PMAX:
    case PMINMAX:
    case PMINMIN:
    case PMIN:
    case P:
    case RMAXMAX:
    case RMAXMIN:
    case RMAX:
    case RMINMAX:
    case RMINMIN:
    case RMIN:
    case R:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PMAXMAX:
      case PMAXMIN:
      case PMAX:
      case PMINMAX:
      case PMINMIN:
      case PMIN:
      case P:{
        expr = ExpressionProb(prop, pathprop);
        break;
        }
      case RMAXMAX:
      case RMAXMIN:
      case RMAX:
      case RMINMAX:
      case RMINMIN:
      case RMIN:
      case R:{
        expr = ExpressionReward(prop, pathprop);
        break;
        }
      case MAX:
      case MIN:{
        expr = ExpressionMultiNash(prop,pathprop);
        break;
        }
      default:
        jj_la1[108] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
ret.setSingleOperand(expr);
      break;
      }
    case LPARENTH:{
      expr = ExpressionParenth(prop, pathprop);
ret.addOperand(expr);
      break;
      }
    default:
      jj_la1[109] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
ret.setPosition(begin, getToken(0));
                {if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// List of coalitions (player lists) for a strategy (<<>> or [[]]) operator
  static final public 
List<Coalition> ExpressionStrategyCoalitionList() throws ParseException {Coalition coalition;
        List<Coalition> coalitions = new ArrayList<Coalition>();;
    coalition = ExpressionStrategyCoalition();
coalitions.add(coalition);
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        ;
        break;
        }
      default:
        jj_la1[110] = jj_gen;
        break label_31;
      }
      jj_consume_token(COLON);
      coalition = ExpressionStrategyCoalition();
coalitions.add(coalition);
    }
{if ("" != null) return coalitions;}
    throw new Error("Missing return statement in function");
}

// Coalition (player list) for a strategy (<<>> or [[]]) operator
  static final public 
Coalition ExpressionStrategyCoalition() throws ParseException {Coalition coalition = new Coalition();
        List<String> players = new ArrayList<String>();
        String s;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TIMES:{
      jj_consume_token(TIMES);
coalition.setAllPlayers();
      break;
      }
    default:
      jj_la1[113] = jj_gen;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case REG_INT:
      case REG_IDENT:{
        s = ExpressionStrategyCoalitionPlayer();
players.add(s);
        label_32:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[111] = jj_gen;
            break label_32;
          }
          jj_consume_token(COMMA);
          s = ExpressionStrategyCoalitionPlayer();
players.add(s);
        }
coalition.setPlayers(players);
        break;
        }
      default:
        jj_la1[112] = jj_gen;
        ;
      }
    }
{if ("" != null) return coalition;}
    throw new Error("Missing return statement in function");
}

// Single player in a coalition for a strategy (<<>> or [[]]) operator
  static final public 
String ExpressionStrategyCoalitionPlayer() throws ParseException {String s;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case REG_INT:{
      jj_consume_token(REG_INT);
      break;
      }
    case REG_IDENT:{
      jj_consume_token(REG_IDENT);
      break;
      }
    default:
      jj_la1[114] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
s = getToken(0).image;
{if ("" != null) return s;}
    throw new Error("Missing return statement in function");
}

// Options for a strategy operator
  static final public 
ArrayList<Expression> ExpressionStrategyOptions() throws ParseException, PrismLangException {Expression expr;
        ArrayList<Expression> optionsSpec;
    expr = Expression(false, false);
optionsSpec = new ArrayList<>(); optionsSpec.add(expr);
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[115] = jj_gen;
        break label_33;
      }
      jj_consume_token(COMMA);
      expr = Expression(false, false);
optionsSpec.add(expr);
    }
{if ("" != null) return optionsSpec;}
    throw new Error("Missing return statement in function");
}

// (Property) expression: label (including "init")
  static final public 
Expression ExpressionLabel(boolean prop, boolean pathprop) throws ParseException {String s;
        ExpressionLabel ret = null;
        Token begin;
if (!prop) {if (true) throw generateParseException();}
    begin = jj_consume_token(DQUOTE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case REG_IDENT:{
      s = Identifier();
      break;
      }
    case INIT:{
      jj_consume_token(INIT);
s = "init";
      break;
      }
    default:
      jj_la1[116] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(DQUOTE);
ret = new ExpressionLabel(s); ret.setPosition(begin, getToken(0)); {if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// (Property) expression: filter (using "filter" keyword)
  static final public 
Expression ExpressionFilter(boolean prop, boolean pathprop) throws ParseException, PrismLangException {ExpressionFilter expr = null;
        String op = null;
        Expression filter = null;
        Expression expr2 = null;
        Token begin = null;
if (!prop) {if (true) throw generateParseException();}
    // filter(
            begin = jj_consume_token(FILTER);
    jj_consume_token(LPARENTH);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MIN:{
      jj_consume_token(MIN);
op = "min";
      break;
      }
    case MAX:{
      jj_consume_token(MAX);
op = "max";
      break;
      }
    case PLUS:{
      jj_consume_token(PLUS);
op = "+";
      break;
      }
    case AND:{
      jj_consume_token(AND);
op = "&";
      break;
      }
    case OR:{
      jj_consume_token(OR);
op = "|";
      break;
      }
    case REG_IDENT:{
      op = Identifier();
      break;
      }
    default:
      jj_la1[117] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(COMMA);
    expr2 = Expression(prop, pathprop);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      filter = Expression(prop, pathprop);
      break;
      }
    default:
      jj_la1[118] = jj_gen;
      ;
    }
    jj_consume_token(RPARENTH);
expr = new ExpressionFilter(op, expr2, filter); expr.setPosition(begin, getToken(0)); {if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
}

//-----------------------------------------------------------------------------------
// Miscellaneous stuff
//-----------------------------------------------------------------------------------

// Identifier (returns String)
  static final public 
String Identifier() throws ParseException {
    jj_consume_token(REG_IDENT);
{if ("" != null) return getToken(0).image;}
    throw new Error("Missing return statement in function");
}

// Identifier (returns ExpressionIdent, storing position info)
  static final public 
ExpressionIdent IdentifierExpression() throws ParseException {String ident;
        ExpressionIdent ret;
    ident = Identifier();
ret = new ExpressionIdent(ident); ret.setPosition(getToken(0)); {if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Identifier or min/max keyword (returns ExpressionIdent, storing position info)
  static final public 
ExpressionIdent IdentifierExpressionMinMax() throws ParseException {String ident;
        ExpressionIdent ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case REG_IDENT:{
      ident = Identifier();
      break;
      }
    case MIN:{
      jj_consume_token(MIN);
ident="min";
      break;
      }
    case MAX:{
      jj_consume_token(MAX);
ident="max";
      break;
      }
    default:
      jj_la1[119] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
ret = new ExpressionIdent(ident); ret.setPosition(getToken(0)); {if ("" != null) return ret;}
    throw new Error("Missing return statement in function");
}

// Primed identifier
  static final public 
ExpressionIdent IdentifierPrime() throws ParseException {
    jj_consume_token(REG_IDENTPRIME);
// Remove prime, create new ident and return
                String s = getToken(0).image;
                s = s.substring(0, s.length()-1);
                ExpressionIdent expr = new ExpressionIdent(s);
                expr.setPosition(token);
                expr.setEndColumn(expr.getEndColumn() - 1);
                expr.setPrime(true);
                {if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
}

// Equality operators: =, !=
  static final public 
int EqNeq() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EQ:{
      jj_consume_token(EQ);
{if ("" != null) return ExpressionBinaryOp.EQ;}
      break;
      }
    case NE:{
      jj_consume_token(NE);
{if ("" != null) return ExpressionBinaryOp.NE;}
      break;
      }
    default:
      jj_la1[120] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

// Relational operators: >, <, >=, <=
  static final public 
int LtGt() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case GT:{
      jj_consume_token(GT);
{if ("" != null) return ExpressionBinaryOp.GT;}
      break;
      }
    case LT:{
      jj_consume_token(LT);
{if ("" != null) return ExpressionBinaryOp.LT;}
      break;
      }
    case GE:{
      jj_consume_token(GE);
{if ("" != null) return ExpressionBinaryOp.GE;}
      break;
      }
    case LE:{
      jj_consume_token(LE);
{if ("" != null) return ExpressionBinaryOp.LE;}
      break;
      }
    default:
      jj_la1[121] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

// For loop
  static final public 
ForLoop ForLoop() throws ParseException, PrismLangException {String s;
        Expression from = null, to = null, step = null;
        ForLoop fl = new ForLoop();
        Token begin;
begin = getToken(1);
    s = Identifier();
    jj_consume_token(EQ);
    from = Expression(false, false);
    jj_consume_token(COLON);
    to = Expression(false, false);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      step = Expression(false, false);
      break;
      }
    default:
      jj_la1[122] = jj_gen;
      ;
    }
    jj_consume_token(0);
fl.setLHS(s);
                fl.setFrom(from);
                fl.setTo(to);
                if (step != null) fl.setStep(step);
                fl.setPosition(begin, getToken(0));
                {if ("" != null) return fl;}
    throw new Error("Missing return statement in function");
}

  static private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  static private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  static private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  static private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  static private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  static private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  static private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  static private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  static private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  static private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  static private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  static private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  static private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  static private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  static private boolean jj_2_15(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  static private boolean jj_2_16(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  static private boolean jj_2_17(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  static private boolean jj_2_18(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  static private boolean jj_2_19(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  static private boolean jj_3R_ExpressionBasic_1517_9_135()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionBasic_1518_17_136()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionBasic_1520_17_137()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionBasic_1522_17_138()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionBasic_1524_17_139()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionBasic_1526_17_140()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionBasic_1529_17_141()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionBasic_1531_17_142()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionBasic_1533_17_143()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionBasic_1535_17_144()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionBasic_1537_17_145()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionBasic_1539_17_146()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionBasic_1541_17_147()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionBasic_1543_17_148()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  static private boolean jj_3R_LtGt_2282_9_59()
 {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  static private boolean jj_3R_SystemParallel_1130_11_64()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_Identifier_2217_9_34()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SystemParallel_1131_65_75()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACKET)) return true;
    if (jj_scan_token(OR)) return true;
    if (jj_3R_SystemHideRename_1156_9_63()) return true;
    return false;
  }

  static private boolean jj_3R_LtGt_2281_9_58()
 {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  static private boolean jj_3R_LtGt_2280_9_57()
 {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionUnaryMinus_1505_17_134()
 {
    if (jj_3R_ExpressionBasic_1517_9_135()) return true;
    return false;
  }

  static private boolean jj_3R_LtGt_2279_9_56()
 {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  static private boolean jj_3R_LtGt_2279_9_50()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_LtGt_2279_9_56()) {
    jj_scanpos = xsp;
    if (jj_3R_LtGt_2280_9_57()) {
    jj_scanpos = xsp;
    if (jj_3R_LtGt_2281_9_58()) {
    jj_scanpos = xsp;
    if (jj_3R_LtGt_2282_9_59()) return true;
    }
    }
    }
    return false;
  }

  static private boolean jj_3_15()
 {
    if (jj_scan_token(DQUOTE)) return true;
    return false;
  }

  static private boolean jj_3R_SystemParallel_1128_9_54()
 {
    if (jj_3R_SystemHideRename_1156_9_63()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SystemParallel_1130_11_64()) jj_scanpos = xsp;
    return false;
  }

  static private boolean jj_3R_ExpressionUnaryMinus_1502_17_133()
 {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_ExpressionUnaryMinus_1501_9_129()) return true;
    return false;
  }

  static private boolean jj_3R_RewardIndex_1889_11_259()
 {
    if (jj_scan_token(DIVIDE)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RewardIndex_1889_33_267()) {
    jj_scanpos = xsp;
    if (jj_3R_RewardIndex_1889_101_268()) return true;
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionPlusMinus_1454_62_128()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  static private boolean jj_3R_RewardIndex_1886_10_258()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_scan_token(DISCOUNT)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_EqNeq_2270_9_124()
 {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  static private boolean jj_3R_EqNeq_2269_9_120()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_EqNeq_2269_9_123()) {
    jj_scanpos = xsp;
    if (jj_3R_EqNeq_2270_9_124()) return true;
    }
    return false;
  }

  static private boolean jj_3R_EqNeq_2269_9_123()
 {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  static private boolean jj_3R_RewardIndex_1884_10_255()
 {
    if (jj_scan_token(DQUOTE)) return true;
    if (jj_3R_Identifier_2217_9_34()) return true;
    if (jj_scan_token(DQUOTE)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionUnaryMinus_1501_9_129()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionUnaryMinus_1502_17_133()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionUnaryMinus_1505_17_134()) return true;
    }
    return false;
  }

  static private boolean jj_3R_RewardIndex_1882_9_244()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RewardIndex_1884_10_255()) {
    jj_scanpos = xsp;
    if (jj_3R_RewardIndex_1884_75_256()) {
    jj_scanpos = xsp;
    if (jj_3R_RewardIndex_1884_125_257()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_RewardIndex_1886_10_258()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_RewardIndex_1889_11_259()) jj_scanpos = xsp;
    return false;
  }

  static private boolean jj_3R_ExpressionPower_1488_17_130()
 {
    if (jj_scan_token(POWER)) return true;
    if (jj_3R_ExpressionPower_1486_9_125()) return true;
    return false;
  }

  static private boolean jj_3R_SystemInterleaved_1104_9_47()
 {
    if (jj_3R_SystemParallel_1128_9_54()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SystemInterleaved_1106_70_55()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionStrategyOptions_2158_103_253()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionPower_1486_9_125()
 {
    if (jj_3R_ExpressionUnaryMinus_1501_9_129()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionPower_1488_17_130()) jj_scanpos = xsp;
    return false;
  }

  static private boolean jj_3R_IdentifierPrime_2250_9_53()
 {
    if (jj_scan_token(REG_IDENTPRIME)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionTimesDivide_1471_19_131()
 {
    if (jj_scan_token(TIMES)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionTimesDivide_1471_17_126()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionTimesDivide_1471_19_131()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionTimesDivide_1471_64_132()) return true;
    }
    if (jj_3R_ExpressionPower_1486_9_125()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFilter_2196_56_202()
 {
    if (jj_scan_token(OR)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1837_26_250()
 {
    if (jj_scan_token(MAX)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1836_26_249()
 {
    if (jj_scan_token(MIN)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1835_26_248()
 {
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionTimesDivide_1469_9_121()
 {
    if (jj_3R_ExpressionPower_1486_9_125()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ExpressionTimesDivide_1471_17_126()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1850_10_188()
 {
    if (jj_scan_token(RMAXMAX)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1833_26_247()
 {
    if (jj_scan_token(MAX)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1842_17_224()
 {
    if (jj_scan_token(MAXMAX)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1849_10_187()
 {
    if (jj_scan_token(RMAXMIN)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1832_26_246()
 {
    if (jj_scan_token(MIN)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1841_17_223()
 {
    if (jj_scan_token(MAXMIN)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1848_10_186()
 {
    if (jj_scan_token(RMINMAX)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1831_26_245()
 {
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1840_17_222()
 {
    if (jj_scan_token(MINMAX)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1847_10_185()
 {
    if (jj_scan_token(RMINMIN)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1839_17_221()
 {
    if (jj_scan_token(MINMIN)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1846_10_184()
 {
    if (jj_scan_token(RMAX)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_SystemFullParallel_1081_9_40()
 {
    if (jj_3R_SystemInterleaved_1104_9_47()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SystemFullParallel_1083_71_48()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionPlusMinus_1454_19_127()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1845_10_183()
 {
    if (jj_scan_token(RMIN)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionPlusMinus_1454_17_122()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionPlusMinus_1454_19_127()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionPlusMinus_1454_62_128()) return true;
    }
    if (jj_3R_ExpressionTimesDivide_1469_9_121()) return true;
    return false;
  }

  static private boolean jj_3R_IdentifierExpression_2228_9_37()
 {
    if (jj_3R_Identifier_2217_9_34()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1835_17_220()
 {
    if (jj_scan_token(MAX)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionReward_1835_26_248()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1836_26_249()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1837_26_250()) return true;
    }
    }
    return false;
  }

  static private boolean jj_3_2()
 {
    if (jj_scan_token(DQUOTE)) return true;
    if (jj_3R_Identifier_2217_9_34()) return true;
    if (jj_scan_token(DQUOTE)) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1831_17_219()
 {
    if (jj_scan_token(MIN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionReward_1831_26_245()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1832_26_246()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1833_26_247()) return true;
    }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1830_17_218()
 {
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1829_18_217()
 {
    if (jj_3R_LtGt_2279_9_50()) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFilter_2196_34_201()
 {
    if (jj_scan_token(AND)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFilter_2195_35_199()
 {
    if (jj_scan_token(MAX)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1828_18_216()
 {
    if (jj_3R_RewardIndex_1882_9_244()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1827_19_215()
 {
    if (jj_scan_token(LPARENTH)) return true;
    if (jj_3R_IdentifierExpression_2228_9_37()) return true;
    if (jj_scan_token(RPARENTH)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionPlusMinus_1452_9_118()
 {
    if (jj_3R_ExpressionTimesDivide_1469_9_121()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ExpressionPlusMinus_1454_17_122()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_SystemDefn_1068_9_36()
 {
    if (jj_3R_SystemFullParallel_1081_9_40()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionSS_1788_55_44()
 {
    if (jj_3R_Filter_1756_9_52()) return true;
    return false;
  }

  static private boolean jj_3R_Identifier_2217_9_34()
 {
    if (jj_scan_token(REG_IDENT)) return true;
    return false;
  }

  static private boolean jj_3_7()
 {
    if (jj_scan_token(DQUOTE)) return true;
    if (jj_3R_Identifier_2217_9_34()) return true;
    if (jj_scan_token(DQUOTE)) return true;
    if (jj_3R_SystemDefn_1068_9_36()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionLabel_2174_47_197()
 {
    if (jj_scan_token(INIT)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1826_10_182()
 {
    if (jj_scan_token(R)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionReward_1827_19_215()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionReward_1828_18_216()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionReward_1829_18_217()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1830_17_218()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1831_17_219()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1835_17_220()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1839_17_221()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1840_17_222()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1841_17_223()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1842_17_224()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1824_9_155()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionReward_1826_10_182()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1845_10_183()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1846_10_184()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1847_10_185()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1848_10_186()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1849_10_187()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionReward_1850_10_188()) return true;
    }
    }
    }
    }
    }
    }
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_ExpressionRewardContents_1915_9_189()) return true;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionReward_1852_69_190()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFilter_2201_11_204()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionRelop_1432_11_119()
 {
    if (jj_3R_LtGt_2279_9_50()) return true;
    if (jj_3R_ExpressionPlusMinus_1452_9_118()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFilter_2197_11_203()
 {
    if (jj_3R_Identifier_2217_9_34()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFilter_2196_11_200()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFilter_2195_11_198()
 {
    if (jj_scan_token(MIN)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionRelop_1431_9_116()
 {
    if (jj_3R_ExpressionPlusMinus_1452_9_118()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ExpressionRelop_1432_11_119()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionLabel_2174_30_196()
 {
    if (jj_3R_Identifier_2217_9_34()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFilter_2190_9_160()
 {
    if (jj_scan_token(FILTER)) return true;
    if (jj_scan_token(LPARENTH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionFilter_2195_11_198()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionFilter_2195_35_199()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionFilter_2196_11_200()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionFilter_2196_34_201()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionFilter_2196_56_202()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionFilter_2197_11_203()) return true;
    }
    }
    }
    }
    }
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionFilter_2201_11_204()) jj_scanpos = xsp;
    if (jj_scan_token(RPARENTH)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionEquality_1418_11_117()
 {
    if (jj_3R_EqNeq_2269_9_120()) return true;
    if (jj_3R_ExpressionRelop_1431_9_116()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionEquality_1417_9_115()
 {
    if (jj_3R_ExpressionRelop_1431_9_116()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ExpressionEquality_1418_11_117()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionStrategy_2097_93_237()
 {
    if (jj_3R_ExpressionMultiNash_1949_9_254()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionNot_1403_17_114()
 {
    if (jj_3R_ExpressionEquality_1417_9_115()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionSS_1785_17_42()
 {
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionSS_1783_19_49()
 {
    if (jj_scan_token(LPARENTH)) return true;
    if (jj_3R_IdentifierExpression_2228_9_37()) return true;
    if (jj_scan_token(RPARENTH)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionNot_1401_17_113()
 {
    if (jj_scan_token(NOT)) return true;
    if (jj_3R_ExpressionNot_1400_9_111()) return true;
    return false;
  }

  static private boolean jj_3R_TimeBound_1318_99_106()
 {
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionSS_1783_17_41()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionSS_1783_19_49()) jj_scanpos = xsp;
    if (jj_3R_LtGt_2279_9_50()) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_TimeBound_1317_99_104()
 {
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionLabel_2172_9_159()
 {
    if (jj_scan_token(DQUOTE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionLabel_2174_30_196()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionLabel_2174_47_197()) return true;
    }
    if (jj_scan_token(DQUOTE)) return true;
    return false;
  }

  static private boolean jj_3R_TimeBound_1316_99_102()
 {
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_TimeBound_1315_99_100()
 {
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionNot_1400_9_111()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionNot_1401_17_113()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionNot_1403_17_114()) return true;
    }
    return false;
  }

  static private boolean jj_3R_ExpressionSS_1780_9_38()
 {
    if (jj_scan_token(S)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionSS_1783_17_41()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionSS_1785_17_42()) return true;
    }
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionSS_1788_55_44()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionStrategyOptions_2158_9_234()
 {
    if (jj_3R_Expression_1239_9_43()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ExpressionStrategyOptions_2158_103_253()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionAnd_1388_11_112()
 {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_ExpressionNot_1400_9_111()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionAnd_1387_9_109()
 {
    if (jj_3R_ExpressionNot_1400_9_111()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ExpressionAnd_1388_11_112()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1727_51_181()
 {
    if (jj_3R_Filter_1756_9_52()) return true;
    return false;
  }

  static private boolean jj_3R_Filter_1759_19_72()
 {
    if (jj_scan_token(MAX)) return true;
    return false;
  }

  static private boolean jj_3R_Filter_1758_19_71()
 {
    if (jj_scan_token(MIN)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionStrategyCoalitionPlayer_2146_9_278()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) return true;
    }
    return false;
  }

  static private boolean jj_3R_ExpressionOr_1375_11_110()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_ExpressionAnd_1387_9_109()) return true;
    return false;
  }

  static private boolean jj_3R_Filter_1757_11_62()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Filter_1758_19_71()) {
    jj_scanpos = xsp;
    if (jj_3R_Filter_1759_19_72()) return true;
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionOr_1374_9_107()
 {
    if (jj_3R_ExpressionAnd_1387_9_109()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ExpressionOr_1375_11_110()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionStrategy_2097_51_236()
 {
    if (jj_3R_ExpressionReward_1824_9_155()) return true;
    return false;
  }

  static private boolean jj_3_6()
 {
    if (jj_scan_token(DQUOTE)) return true;
    return false;
  }

  static private boolean jj_3R_Filter_1756_9_52()
 {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    if (jj_scan_token(RBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_Filter_1757_11_62()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionStrategyCoalition_2133_13_279()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_ExpressionStrategyCoalitionPlayer_2146_9_278()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionStrategyCoalition_2132_11_269()
 {
    if (jj_3R_ExpressionStrategyCoalitionPlayer_2146_9_278()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ExpressionStrategyCoalition_2133_13_279()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionStrategyCoalition_2132_9_261()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionStrategyCoalition_2132_11_269()) jj_scanpos = xsp;
    return false;
  }

  static private boolean jj_3R_ExpressionStrategyCoalition_2130_11_260()
 {
    if (jj_scan_token(TIMES)) return true;
    return false;
  }

  static private boolean jj_3_1()
 {
    if (jj_scan_token(MODULE)) return true;
    if (jj_3R_Identifier_2217_9_34()) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionStrategyCoalition_2130_9_251()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionStrategyCoalition_2130_11_260()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionStrategyCoalition_2132_9_261()) return true;
    }
    return false;
  }

  static private boolean jj_3R_ExpressionIff_1362_11_108()
 {
    if (jj_scan_token(IFF)) return true;
    if (jj_3R_ExpressionOr_1374_9_107()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionIff_1361_9_97()
 {
    if (jj_3R_ExpressionOr_1374_9_107()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ExpressionIff_1362_11_108()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionStrategyCoalitionList_2117_10_252()
 {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_ExpressionStrategyCoalition_2130_9_251()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionImplies_1349_11_98()
 {
    if (jj_scan_token(IMPLIES)) return true;
    if (jj_3R_ExpressionImplies_1348_9_87()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionStrategyCoalitionList_2116_9_233()
 {
    if (jj_3R_ExpressionStrategyCoalition_2130_9_251()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ExpressionStrategyCoalitionList_2117_10_252()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionImplies_1348_9_87()
 {
    if (jj_3R_ExpressionIff_1361_9_97()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionImplies_1349_11_98()) jj_scanpos = xsp;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1712_26_243()
 {
    if (jj_scan_token(MAX)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1711_26_242()
 {
    if (jj_scan_token(MIN)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1710_26_241()
 {
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1725_10_180()
 {
    if (jj_scan_token(PMAXMAX)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1708_26_240()
 {
    if (jj_scan_token(MAX)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1717_17_214()
 {
    if (jj_scan_token(MAXMAX)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1724_10_179()
 {
    if (jj_scan_token(PMAXMIN)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionITE_1334_17_88()
 {
    if (jj_scan_token(QMARK)) return true;
    if (jj_3R_ExpressionImplies_1348_9_87()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_ExpressionITE_1332_9_80()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1707_26_239()
 {
    if (jj_scan_token(MIN)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1716_17_213()
 {
    if (jj_scan_token(MAXMIN)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1723_10_178()
 {
    if (jj_scan_token(PMINMAX)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1706_26_238()
 {
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1715_17_212()
 {
    if (jj_scan_token(MINMAX)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1722_10_177()
 {
    if (jj_scan_token(PMINMIN)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1714_17_211()
 {
    if (jj_scan_token(MINMIN)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1721_10_176()
 {
    if (jj_scan_token(PMAX)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3_14()
 {
    if (jj_3R_IdentifierExpression_2228_9_37()) return true;
    if (jj_scan_token(LPARENTH)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1720_10_175()
 {
    if (jj_scan_token(PMIN)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3_13()
 {
    if (jj_3R_IdentifierExpression_2228_9_37()) return true;
    if (jj_scan_token(LPARENTH)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1704_25_207()
 {
    if (jj_3R_LtGt_2279_9_50()) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1703_26_206()
 {
    if (jj_scan_token(LPARENTH)) return true;
    if (jj_3R_IdentifierExpression_2228_9_37()) return true;
    if (jj_scan_token(RPARENTH)) return true;
    return false;
  }

  static private boolean jj_3_12()
 {
    if (jj_3R_IdentifierExpression_2228_9_37()) return true;
    if (jj_scan_token(LPARENTH)) return true;
    return false;
  }

  static private boolean jj_3_11()
 {
    if (jj_3R_IdentifierExpression_2228_9_37()) return true;
    if (jj_scan_token(LPARENTH)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1710_17_210()
 {
    if (jj_scan_token(MAX)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionProb_1710_26_241()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1711_26_242()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1712_26_243()) return true;
    }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionStrategy_2099_11_195()
 {
    if (jj_3R_ExpressionParenth_1660_9_153()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionStrategy_2097_11_235()
 {
    if (jj_3R_ExpressionProb_1701_9_154()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionITE_1332_9_80()
 {
    if (jj_3R_ExpressionImplies_1348_9_87()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionITE_1334_17_88()) jj_scanpos = xsp;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1706_17_209()
 {
    if (jj_scan_token(MIN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionProb_1706_26_238()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1707_26_239()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1708_26_240()) return true;
    }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionStrategy_2097_9_194()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionStrategy_2097_11_235()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionStrategy_2097_51_236()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionStrategy_2097_93_237()) return true;
    }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1705_17_208()
 {
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_TimeBound_1318_20_105()
 {
    if (jj_3R_IdentifierExpression_2228_9_37()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionStrategy_2093_10_193()
 {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_ExpressionStrategyOptions_2158_9_234()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  static private boolean jj_3R_TimeBound_1317_20_103()
 {
    if (jj_3R_IdentifierExpression_2228_9_37()) return true;
    return false;
  }

  static private boolean jj_3R_MultiNashRewardIndexes_2029_73_282()
 {
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_Update_917_36_46()
 {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_UpdateElement_930_9_45()) return true;
    return false;
  }

  static private boolean jj_3R_TimeBound_1316_20_101()
 {
    if (jj_3R_IdentifierExpression_2228_9_37()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionStrategy_2090_11_192()
 {
    if (jj_scan_token(DLBRACKET)) return true;
    if (jj_3R_ExpressionStrategyCoalitionList_2116_9_233()) return true;
    if (jj_scan_token(DRBRACKET)) return true;
    return false;
  }

  static private boolean jj_3R_TimeBound_1315_20_99()
 {
    if (jj_3R_IdentifierExpression_2228_9_37()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionStrategy_2089_10_191()
 {
    if (jj_scan_token(DLT)) return true;
    if (jj_3R_ExpressionStrategyCoalitionList_2116_9_233()) return true;
    if (jj_scan_token(DGT)) return true;
    return false;
  }

  static private boolean jj_3R_TimeBound_1320_11_94()
 {
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1703_10_174()
 {
    if (jj_scan_token(P)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionProb_1703_26_206()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionProb_1704_25_207()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1705_17_208()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1706_17_209()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1710_17_210()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1714_17_211()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1715_17_212()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1716_17_213()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1717_17_214()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  static private boolean jj_3R_TimeBound_1319_11_93()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionStrategy_2086_9_158()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionStrategy_2089_10_191()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionStrategy_2090_11_192()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_ExpressionStrategy_2093_10_193()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionStrategy_2097_9_194()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionStrategy_2099_11_195()) return true;
    }
    return false;
  }

  static private boolean jj_3R_TimeBound_1318_11_92()
 {
    if (jj_scan_token(GT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_TimeBound_1318_20_105()) {
    jj_scanpos = xsp;
    if (jj_3R_TimeBound_1318_99_106()) return true;
    }
    return false;
  }

  static private boolean jj_3R_TimeBound_1317_11_91()
 {
    if (jj_scan_token(GE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_TimeBound_1317_20_103()) {
    jj_scanpos = xsp;
    if (jj_3R_TimeBound_1317_99_104()) return true;
    }
    return false;
  }

  static private boolean jj_3R_TimeBound_1316_11_90()
 {
    if (jj_scan_token(LT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_TimeBound_1316_20_101()) {
    jj_scanpos = xsp;
    if (jj_3R_TimeBound_1316_99_102()) return true;
    }
    return false;
  }

  static private boolean jj_3R_ExpressionProb_1701_9_154()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionProb_1703_10_174()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1720_10_175()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1721_10_176()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1722_10_177()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1723_10_178()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1724_10_179()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionProb_1725_10_180()) return true;
    }
    }
    }
    }
    }
    }
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionProb_1727_51_181()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  static private boolean jj_3R_TimeBound_1315_11_89()
 {
    if (jj_scan_token(LE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_TimeBound_1315_20_99()) {
    jj_scanpos = xsp;
    if (jj_3R_TimeBound_1315_99_100()) return true;
    }
    return false;
  }

  static private boolean jj_3R_TimeBound_1315_9_81()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_TimeBound_1315_11_89()) {
    jj_scanpos = xsp;
    if (jj_3R_TimeBound_1316_11_90()) {
    jj_scanpos = xsp;
    if (jj_3R_TimeBound_1317_11_91()) {
    jj_scanpos = xsp;
    if (jj_3R_TimeBound_1318_11_92()) {
    jj_scanpos = xsp;
    if (jj_3R_TimeBound_1319_11_93()) {
    jj_scanpos = xsp;
    if (jj_3R_TimeBound_1320_11_94()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  static private boolean jj_3R_UpdateElement_930_9_45()
 {
    if (jj_scan_token(LPARENTH)) return true;
    if (jj_3R_IdentifierPrime_2250_9_53()) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    if (jj_scan_token(RPARENTH)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionTemporalUnary_1302_17_66()
 {
    if (jj_3R_ExpressionITE_1332_9_80()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionTemporalUnary_1298_19_79()
 {
    if (jj_3R_TimeBound_1315_9_81()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionTemporalUnary_1297_19_78()
 {
    if (jj_scan_token(G)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionTemporalUnary_1296_19_77()
 {
    if (jj_scan_token(F)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionTemporalUnary_1295_19_76()
 {
    if (jj_scan_token(X)) return true;
    return false;
  }

  static private boolean jj_3R_Update_917_10_39()
 {
    if (jj_3R_UpdateElement_930_9_45()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_Update_917_36_46()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionTemporalUnary_1293_17_65()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionTemporalUnary_1295_19_76()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionTemporalUnary_1296_19_77()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionTemporalUnary_1297_19_78()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_ExpressionTemporalUnary_1298_19_79()) jj_scanpos = xsp;
    if (jj_3R_ExpressionTemporalUnary_1291_9_60()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionMultiNash_1953_122_273()
 {
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionForAll_2065_9_157()
 {
    if (jj_scan_token(A)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionMultiNash_1951_122_271()
 {
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  static private boolean jj_3R_Update_915_9_35()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Update_917_10_39()) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) return true;
    }
    return false;
  }

  static private boolean jj_3_5()
 {
    if (jj_3R_Update_915_9_35()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionTemporalUnary_1291_9_60()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionTemporalUnary_1293_17_65()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionTemporalUnary_1302_17_66()) return true;
    }
    return false;
  }

  static private boolean jj_3R_ExpressionFuncArgs_1610_72_205()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFuncOldStyle_1598_83_173()
 {
    if (jj_3R_Identifier_2217_9_34()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionTemporalBinary_1277_19_70()
 {
    if (jj_3R_TimeBound_1315_9_81()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionTemporalBinary_1276_19_69()
 {
    if (jj_scan_token(R)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionTemporalBinary_1275_19_68()
 {
    if (jj_scan_token(W)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionTemporalBinary_1274_19_67()
 {
    if (jj_scan_token(U)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionTemporalBinary_1272_17_61()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionTemporalBinary_1274_19_67()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionTemporalBinary_1275_19_68()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionTemporalBinary_1276_19_69()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_ExpressionTemporalBinary_1277_19_70()) jj_scanpos = xsp;
    if (jj_3R_ExpressionTemporalUnary_1291_9_60()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionExists_2046_9_156()
 {
    if (jj_scan_token(E)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionParenth_1660_9_153()
 {
    if (jj_scan_token(LPARENTH)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    if (jj_scan_token(RPARENTH)) return true;
    return false;
  }

  static private boolean jj_3_19()
 {
    if (jj_scan_token(DQUOTE)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionTemporalBinary_1269_9_51()
 {
    if (jj_3R_ExpressionTemporalUnary_1291_9_60()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionTemporalBinary_1272_17_61()) jj_scanpos = xsp;
    return false;
  }

  static private boolean jj_3R_ExpressionFuncOldStyle_1598_60_172()
 {
    if (jj_scan_token(MAX)) return true;
    return false;
  }

  static private boolean jj_3R_MultiNashRewardIndexes_2029_10_281()
 {
    if (jj_scan_token(DQUOTE)) return true;
    if (jj_3R_Identifier_2217_9_34()) return true;
    if (jj_scan_token(DQUOTE)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionLiteral_1647_9_164()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  static private boolean jj_3R_MultiNashRewardIndexes_2028_9_280()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_MultiNashRewardIndexes_2029_10_281()) {
    jj_scanpos = xsp;
    if (jj_3R_MultiNashRewardIndexes_2029_73_282()) return true;
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionLiteral_1645_9_163()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionLiteral_1634_9_162()
 {
    if (jj_scan_token(REG_DOUBLE)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFuncOldStyle_1598_37_171()
 {
    if (jj_scan_token(MIN)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionMultiNashReward_2008_9_275()
 {
    if (jj_scan_token(R)) return true;
    if (jj_3R_MultiNashRewardIndexes_2028_9_280()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_ExpressionRewardContents_1915_9_189()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  static private boolean jj_3R_Expression_1239_9_43()
 {
    if (jj_3R_ExpressionTemporalBinary_1269_9_51()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionLiteral_1621_9_161()
 {
    if (jj_scan_token(REG_INT)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionLiteral_1620_9_149()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionLiteral_1621_9_161()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionLiteral_1634_9_162()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionLiteral_1645_9_163()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionLiteral_1647_9_164()) return true;
    }
    }
    }
    return false;
  }

  static private boolean jj_3R_RewardIndex_1884_125_257()
 {
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFuncMinMax_1584_42_169()
 {
    if (jj_scan_token(MAX)) return true;
    return false;
  }

  static private boolean jj_3R_SystemHideRename_1161_81_95()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_Identifier_2217_9_34()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFuncArgs_1610_9_170()
 {
    if (jj_3R_Expression_1239_9_43()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ExpressionFuncArgs_1610_72_205()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionMultiNashProb_1986_9_274()
 {
    if (jj_scan_token(P)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  static private boolean jj_3R_RewardIndex_1889_101_268()
 {
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFuncOldStyle_1598_9_152()
 {
    if (jj_scan_token(FUNC)) return true;
    if (jj_scan_token(LPARENTH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionFuncOldStyle_1598_37_171()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionFuncOldStyle_1598_60_172()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionFuncOldStyle_1598_83_173()) return true;
    }
    }
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_ExpressionFuncArgs_1610_9_170()) return true;
    if (jj_scan_token(RPARENTH)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionMultiNash_1964_25_277()
 {
    if (jj_3R_ExpressionMultiNashReward_2008_9_275()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionMultiNash_1962_26_276()
 {
    if (jj_3R_ExpressionMultiNashProb_1986_9_274()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionMultiNash_1961_18_266()
 {
    if (jj_scan_token(PLUS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionMultiNash_1962_26_276()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionMultiNash_1964_25_277()) return true;
    }
    return false;
  }

  static private boolean jj_3R_ExpressionFuncMinMax_1584_11_168()
 {
    if (jj_scan_token(MIN)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionMultiNash_1959_17_265()
 {
    if (jj_3R_ExpressionMultiNashReward_2008_9_275()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFuncMinMax_1584_9_151()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionFuncMinMax_1584_11_168()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionFuncMinMax_1584_42_169()) return true;
    }
    if (jj_scan_token(LPARENTH)) return true;
    if (jj_3R_ExpressionFuncArgs_1610_9_170()) return true;
    if (jj_scan_token(RPARENTH)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionMultiNash_1957_18_264()
 {
    if (jj_3R_ExpressionMultiNashProb_1986_9_274()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionMultiNash_1953_16_272()
 {
    if (jj_3R_LtGt_2279_9_50()) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionMultiNash_1951_16_270()
 {
    if (jj_3R_LtGt_2279_9_50()) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_SystemAtomic_1191_10_84()
 {
    if (jj_scan_token(LPARENTH)) return true;
    if (jj_3R_SystemDefn_1068_9_36()) return true;
    if (jj_scan_token(RPARENTH)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFuncOrIdent_1571_11_167()
 {
    if (jj_scan_token(LPARENTH)) return true;
    if (jj_3R_ExpressionFuncArgs_1610_9_170()) return true;
    if (jj_scan_token(RPARENTH)) return true;
    return false;
  }

  static private boolean jj_3R_SystemAtomic_1189_10_83()
 {
    if (jj_scan_token(DQUOTE)) return true;
    if (jj_3R_Identifier_2217_9_34()) return true;
    if (jj_scan_token(DQUOTE)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionMultiNash_1953_9_263()
 {
    if (jj_scan_token(MAX)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionMultiNash_1953_16_272()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionMultiNash_1953_122_273()) return true;
    }
    return false;
  }

  static private boolean jj_3R_ExpressionFuncOrIdent_1568_11_166()
 {
    if (jj_3R_IdentifierPrime_2250_9_53()) return true;
    return false;
  }

  static private boolean jj_3R_SystemAtomic_1187_9_82()
 {
    if (jj_3R_Identifier_2217_9_34()) return true;
    return false;
  }

  static private boolean jj_3R_SystemParallel_1131_65_75()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_Identifier_2217_9_34()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFuncOrIdent_1567_11_165()
 {
    if (jj_3R_Identifier_2217_9_34()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionMultiNash_1951_9_262()
 {
    if (jj_scan_token(MIN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionMultiNash_1951_16_270()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionMultiNash_1951_122_271()) return true;
    }
    return false;
  }

  static private boolean jj_3R_RewardIndex_1884_75_256()
 {
    if (jj_scan_token(DISCOUNT)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_SystemAtomic_1184_9_73()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SystemAtomic_1187_9_82()) {
    jj_scanpos = xsp;
    if (jj_3R_SystemAtomic_1189_10_83()) {
    jj_scanpos = xsp;
    if (jj_3R_SystemAtomic_1191_10_84()) return true;
    }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionMultiNash_1949_9_254()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionMultiNash_1951_9_262()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionMultiNash_1953_9_263()) return true;
    }
    if (jj_scan_token(LPARENTH)) return true;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionMultiNash_1957_18_264()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionMultiNash_1959_17_265()) return true;
    }
    if (jj_3R_ExpressionMultiNash_1961_18_266()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ExpressionMultiNash_1961_18_266()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPARENTH)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionFuncOrIdent_1566_9_150()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionFuncOrIdent_1567_11_165()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionFuncOrIdent_1568_11_166()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_ExpressionFuncOrIdent_1571_11_167()) jj_scanpos = xsp;
    return false;
  }

  static private boolean jj_3R_SystemHideRename_1168_19_96()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_Identifier_2217_9_34()) return true;
    if (jj_scan_token(RENAME)) return true;
    if (jj_3R_Identifier_2217_9_34()) return true;
    return false;
  }

  static private boolean jj_3_9()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_scan_token(OR)) return true;
    if (jj_scan_token(OR)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionBasic_1543_17_148()
 {
    if (jj_3R_ExpressionFilter_2190_9_160()) return true;
    return false;
  }

  static private boolean jj_3_18()
 {
    if (jj_scan_token(C)) return true;
    if (jj_scan_token(LE)) return true;
    return false;
  }

  static private boolean jj_3R_SystemInterleaved_1106_70_55()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_scan_token(OR)) return true;
    if (jj_scan_token(OR)) return true;
    if (jj_3R_SystemFullParallel_1081_9_40()) return true;
    return false;
  }

  static private boolean jj_3R_SystemHideRename_1165_11_86()
 {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_Identifier_2217_9_34()) return true;
    if (jj_scan_token(RENAME)) return true;
    if (jj_3R_Identifier_2217_9_34()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SystemHideRename_1168_19_96()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionBasic_1541_17_147()
 {
    if (jj_3R_ExpressionLabel_2172_9_159()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionRewardContents_1929_11_232()
 {
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionBasic_1539_17_146()
 {
    if (jj_3R_ExpressionStrategy_2086_9_158()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionRewardContents_1926_11_231()
 {
    if (jj_scan_token(F0)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionBasic_1537_17_145()
 {
    if (jj_3R_ExpressionForAll_2065_9_157()) return true;
    return false;
  }

  static private boolean jj_3_17()
 {
    if (jj_3R_ExpressionSS_1780_9_38()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionRewardContents_1925_11_230()
 {
    if (jj_scan_token(Fc)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionRewardContents_1924_11_229()
 {
    if (jj_scan_token(I)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionBasic_1535_17_144()
 {
    if (jj_3R_ExpressionExists_2046_9_156()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionRewardContents_1923_11_228()
 {
    if (jj_scan_token(C)) return true;
    return false;
  }

  static private boolean jj_3R_SystemHideRename_1159_9_85()
 {
    if (jj_scan_token(DIVIDE)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_Identifier_2217_9_34()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SystemHideRename_1161_81_95()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  static private boolean jj_3R_SystemHideRename_1159_9_74()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SystemHideRename_1159_9_85()) {
    jj_scanpos = xsp;
    if (jj_3R_SystemHideRename_1165_11_86()) return true;
    }
    return false;
  }

  static private boolean jj_3R_ExpressionRewardContents_1922_11_227()
 {
    if (jj_scan_token(C)) return true;
    if (jj_scan_token(LE)) return true;
    if (jj_3R_Expression_1239_9_43()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionBasic_1533_17_143()
 {
    if (jj_3R_ExpressionReward_1824_9_155()) return true;
    return false;
  }

  static private boolean jj_3_16()
 {
    if (jj_scan_token(DQUOTE)) return true;
    return false;
  }

  static private boolean jj_3R_SystemHideRename_1156_9_63()
 {
    if (jj_3R_SystemAtomic_1184_9_73()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SystemHideRename_1159_9_74()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionBasic_1531_17_142()
 {
    if (jj_3R_ExpressionSS_1780_9_38()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionRewardContents_1919_11_226()
 {
    if (jj_scan_token(S)) return true;
    return false;
  }

  static private boolean jj_3_8()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_scan_token(OR)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionBasic_1529_17_141()
 {
    if (jj_3R_ExpressionProb_1701_9_154()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionRewardContents_1918_9_225()
 {
    if (jj_3R_ExpressionSS_1780_9_38()) return true;
    return false;
  }

  static private boolean jj_3_4()
 {
    if (jj_scan_token(LABEL)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionBasic_1526_17_140()
 {
    if (jj_3R_ExpressionParenth_1660_9_153()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionRewardContents_1915_9_189()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionRewardContents_1918_9_225()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionRewardContents_1919_11_226()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionRewardContents_1922_11_227()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionRewardContents_1923_11_228()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionRewardContents_1924_11_229()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionRewardContents_1925_11_230()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionRewardContents_1926_11_231()) {
    jj_scanpos = xsp;
    if (jj_3R_ExpressionRewardContents_1929_11_232()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  static private boolean jj_3R_ExpressionBasic_1524_17_139()
 {
    if (jj_3R_ExpressionFuncOldStyle_1598_9_152()) return true;
    return false;
  }

  static private boolean jj_3R_RewardIndex_1889_33_267()
 {
    if (jj_scan_token(DQUOTE)) return true;
    if (jj_3R_Identifier_2217_9_34()) return true;
    if (jj_scan_token(DQUOTE)) return true;
    return false;
  }

  static private boolean jj_3_3()
 {
    if (jj_scan_token(LABEL)) return true;
    if (jj_scan_token(DQUOTE)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionBasic_1522_17_138()
 {
    if (jj_3R_ExpressionFuncMinMax_1584_9_151()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionReward_1852_69_190()
 {
    if (jj_3R_Filter_1756_9_52()) return true;
    return false;
  }

  static private boolean jj_3R_SystemFullParallel_1083_71_48()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_scan_token(OR)) return true;
    if (jj_3R_SystemParallel_1128_9_54()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionBasic_1520_17_137()
 {
    if (jj_3R_ExpressionFuncOrIdent_1566_9_150()) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionTimesDivide_1471_64_132()
 {
    if (jj_scan_token(DIVIDE)) return true;
    return false;
  }

  static private boolean jj_3R_ExpressionBasic_1518_17_136()
 {
    if (jj_3R_ExpressionLiteral_1620_9_149()) return true;
    return false;
  }

  static private boolean jj_3_10()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  static private boolean jj_initialized_once = false;
  /** Generated Token Manager. */
  static public PrismParserTokenManager token_source;
  static SimpleCharStream jj_input_stream;
  /** Current token. */
  static public Token token;
  /** Next token. */
  static public Token jj_nt;
  static private int jj_ntk;
  static private Token jj_scanpos, jj_lastpos;
  static private int jj_la;
  static private int jj_gen;
  static final private int[] jj_la1 = new int[123];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0xa08023c0,0x208023c0,0x80000000,0x3404048,0x0,0x3404048,0x3404048,0x0,0x3404048,0x2000,0x0,0x100,0x2380,0x1010,0x1010,0x0,0x40,0x0,0x80000000,0x30,0x0,0x0,0x0,0x0,0x47404008,0x47404008,0x0,0x0,0x0,0x47404008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x44000000,0x0,0x47404008,0x47404008,0x47404008,0x47404008,0x47404008,0x0,0x0,0x0,0x0,0x0,0x0,0x3404008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3404008,0x3404008,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x47404808,0x0,0x47404008,0x0,0x0,0x5f404408,0x0,0x0,0x0,0x0,0x0,0x0,0x47404008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x7f80e888,0x3f002088,0x4080c800,0xa87f0448,0x0,0xa87f0448,0xa87f0448,0x0,0xa87f0448,0x4000000,0x2080,0x0,0x17002080,0x4,0x4,0x28000000,0x28000000,0x0,0x0,0x4,0x0,0x1,0x0,0x0,0x807f1440,0x807f1440,0x0,0x0,0x0,0x807f1440,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x807f1440,0x807f1440,0x807f1440,0x807f1440,0x807f1440,0x0,0x0,0x0,0x0,0x0,0x0,0x807f0440,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x807f0440,0x807f0440,0x0,0x0,0x440,0x440,0x0,0x0,0x0,0x440,0x440,0x770,0x7f0000,0x0,0x0,0x440,0x0,0x0,0x0,0x0,0x0,0x440,0x440,0x770,0x80000000,0x0,0x807f1440,0x0,0x807f1440,0x0,0x0,0x807f1442,0x0,0x0,0x440,0x400000,0x400000,0x0,0x807f1440,0x0,0x0,0x807f0440,0x807f0440,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x440,0x0,0x440,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0xf80,0xb80,0x400,0x2200907f,0x400000,0x2200907f,0x2200907f,0x400000,0x2200907f,0x0,0x0,0x80,0xb80,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x8000000,0x0,0x2a00907f,0x2a00907f,0x10000,0x2001000,0x800000,0x2a00907f,0x8000000,0x800000,0x0,0x800000,0x800000,0x80000000,0x800000,0x800000,0x80000000,0x2000000,0x800000,0x8000000,0x8000000,0x6020,0x8000000,0x6020,0x0,0x8000000,0x2200907f,0x2200907f,0x2200907f,0x2200907f,0x2200907f,0x8000000,0x0,0x40000,0x80000,0x20000,0x10000,0x2200907f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2200107f,0x2200107f,0x0,0x2000000,0x0,0x0,0x800000,0x1000,0x2000000,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x2000000,0x2000000,0x80000000,0x2000000,0x80000000,0x0,0x0,0x0,0x3f,0x80000000,0x2200907f,0x800000,0x2200907f,0x0,0x40,0x2200907f,0x0,0x0,0x0,0x20,0x20,0x0,0x2200907f,0x20000000,0x80000000,0x3f,0x200003f,0x200000,0x800000,0x0,0x0,0x0,0x800000,0x0,0x30000,0x800000,0x0,0x0,0x0,0x200000,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x0,0x0,0x0,0x3e0420,0x0,0x3e0420,0x3e0420,0x0,0x3e0420,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x200000,0x0,0x0,0x200,0x3e0420,0x3e0420,0x0,0x0,0x0,0x3e0420,0x0,0x0,0x200000,0x0,0x0,0x1000,0x0,0x0,0x1000,0x220000,0x0,0x200000,0x200000,0x0,0x19a,0x0,0x0,0x19a,0x3e0420,0x3e0420,0x3e0420,0x3e0420,0x3e0420,0x19a,0x10000,0x0,0x0,0x0,0x0,0x3e0420,0x6,0x198,0x600,0x600,0x1800,0x1800,0x2000,0x3e0420,0x3e0020,0x300000,0x0,0x0,0x200000,0x0,0xc0000,0x0,0x2,0x2,0x19a,0x0,0x0,0x0,0x0,0x0,0x19a,0x0,0x0,0x0,0x2,0x2,0x19a,0x0,0x0,0x3e0420,0x0,0x3e0420,0x1000,0x0,0x3e0420,0x19a,0x19a,0x0,0x0,0x0,0x200,0x3e0420,0x20,0x0,0x0,0x0,0x0,0x0,0x240000,0x800,0x240000,0x0,0x200000,0x200200,0x0,0x200000,0x6,0x198,0x0,};
	}
  static final private JJCalls[] jj_2_rtns = new JJCalls[19];
  static private boolean jj_rescan = false;
  static private int jj_gc = 0;

  /** Constructor with InputStream. */
  public PrismParser(java.io.InputStream stream) {
	  this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public PrismParser(java.io.InputStream stream, String encoding) {
	 if (jj_initialized_once) {
	   System.out.println("ERROR: Second call to constructor of static parser.  ");
	   System.out.println("	   You must either use ReInit() or set the JavaCC option STATIC to false");
	   System.out.println("	   during parser generation.");
	   throw new Error();
	 }
	 jj_initialized_once = true;
	 try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source = new PrismParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 123; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  static public void ReInit(java.io.InputStream stream) {
	  ReInit(stream, null);
  }
  /** Reinitialise. */
  static public void ReInit(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 123; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public PrismParser(java.io.Reader stream) {
	 if (jj_initialized_once) {
	   System.out.println("ERROR: Second call to constructor of static parser. ");
	   System.out.println("	   You must either use ReInit() or set the JavaCC option STATIC to false");
	   System.out.println("	   during parser generation.");
	   throw new Error();
	 }
	 jj_initialized_once = true;
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new PrismParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 123; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  static public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new PrismParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 123; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public PrismParser(PrismParserTokenManager tm) {
	 if (jj_initialized_once) {
	   System.out.println("ERROR: Second call to constructor of static parser. ");
	   System.out.println("	   You must either use ReInit() or set the JavaCC option STATIC to false");
	   System.out.println("	   during parser generation.");
	   throw new Error();
	 }
	 jj_initialized_once = true;
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 123; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(PrismParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 123; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  static private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  static private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  static final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  static final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  static private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  static private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  static private int[] jj_expentry;
  static private int jj_kind = -1;
  static private int[] jj_lasttokens = new int[100];
  static private int jj_endpos;

  static private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  static public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[120];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 123; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		   if ((jj_la1_3[i] & (1<<j)) != 0) {
			 la1tokens[96+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 120; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage);
  }

  static private boolean trace_enabled;

/** Trace enabled. */
  static final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  static final public void enable_tracing() {
  }

  /** Disable tracing. */
  static final public void disable_tracing() {
  }

  static private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 19; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			   case 7: jj_3_8(); break;
			   case 8: jj_3_9(); break;
			   case 9: jj_3_10(); break;
			   case 10: jj_3_11(); break;
			   case 11: jj_3_12(); break;
			   case 12: jj_3_13(); break;
			   case 13: jj_3_14(); break;
			   case 14: jj_3_15(); break;
			   case 15: jj_3_16(); break;
			   case 16: jj_3_17(); break;
			   case 17: jj_3_18(); break;
			   case 18: jj_3_19(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  static private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}

//-----------------------------------------------------------------------------------

