// BridgeDb,
// An abstraction layer for identifier mapping services, both local and online.
//
// Copyright 2006-2009  BridgeDb developers
// Copyright 2012-2013  Christian Y. A. Brenninkmeijer
// Copyright 2012-2013  OpenPhacts
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
package org.bridgedb.uri.ws;

import org.bridgedb.uri.api.UriConstants;
import org.bridgedb.ws.WsConstants;

/**
 *
 * @author Christian
 */
public class WsUriConstants extends WsConstants{
    
    public static final String BASE_URI = "baseUri";
    public static final String BRIDGEDB_API = "BridgeDbApi";
    public static final String BRIDGEDB_HOME = "BridgeDb";
    public static final String DATA_SOURCE = "dataSource";
    public static final String FORMAT = "format";
    public static final String GET_OVERALL_STATISTICS = "getOverallStatistics";
    public static final String GRAPH = "graph";
    public static final String GRAPHVIZ = "graphviz";
    public static final String INCLUDE_XREF_RESULTS = "includeXrefResults"; 
    public static final String INCLUDE_URI_RESULTS = "includeUriResults";
    public static final String MAP = "map";
    public static final String MAP_URI = "mapUri";
    public static final String MAP_BY_SET = "mapBySet";
    public static final String MAPPING_SET = UriConstants.MAPPING_SET;
    public static final String LENS_URI = "lensUri";
    public static final String LENS_GROUP = "lensGroup";
    public static final String LINKSET_INFO = "linksetInfo";
    public static final String OVERRIDE_PREDICATE_URI = "overridePredicateURI";
    public static final String RDF = UriConstants.RDF;
    public static final String RDF_FORMAT = "rdfFormat";
    public static final String SQL_COMPAT_VERSION = "SqlCompatVersion";
    public static final String TARGET_URI_PATTERN = "targetUriPattern";

    public static final String TO_XREF = "toXref";
    public static final String TO_URIS = "toUris";
    public static final String URI = "Uri";
    public static final String URI_EXISTS = "UriExists";
    public static final String URI_SEARCH = "UriSearch";
    public static final String XML = "XML";
    
    public static final String SOURCE_INFOS = "SourceInfos";
    public static final String SOURCE_TARGET_INFOS = "SourceTargetInfos";
    public static final String URI_SPACES_PER_GRAPH = "URISpacesPerGraph";
    
}
