// PathVisio,
// a tool for data visualization and analysis using Biological Pathways
// Copyright 2006-2009 BiGCaT Bioinformatics
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
package org.bridgedb.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractParameterModel implements ParameterModel
{
	public File getFile(int i)
	{
		return (File)getValue(i);
	}
	
	public String getString (int i)
	{
		return (String)getValue(i);
	}
	
	public boolean getBoolean (int i)
	{
		return (Boolean)getValue(i);
	}
	
	private List<ParameterModelListener> listeners = new ArrayList<ParameterModelListener>();
	
	public void addParameterModelListener(ParameterModelListener l)
	{
		listeners.add(l);
	}
	
	public void removeParameterModelListener(ParameterModelListener l)
	{
		listeners.remove(l);
	}

	protected void fireParameterModelEvent (ParameterModelEvent e)
	{
		for (ParameterModelListener l : listeners)
		{
			l.parametersChanged(e);
		}
	}
}
