/*
BridgeDb database structure

These creation statements were extracted from a Derby file.
They may not correspond exactly to the original structure.
*/

-- Table ATTRIBUTE

CREATE TABLE "APP"."ATTRIBUTE"
(
   ID varchar(50),
   CODE varchar(50),
   ATTRNAME varchar(50),
   ATTRVALUE varchar(255)
)
;

-- Table DATANODE

CREATE TABLE "APP"."DATANODE"
(
   ID varchar(50) NOT NULL,
   CODE varchar(50) NOT NULL,
   CONSTRAINT SQL180509171519650 PRIMARY KEY (ID,CODE)
)
;
CREATE UNIQUE INDEX SQL180509171519650 ON "APP"."DATANODE"
(
  ID,
  CODE
)
;
CREATE INDEX I_CODE ON "APP"."DATANODE"(CODE)
;

-- Table INFO

CREATE TABLE "APP"."INFO"
(
   SCHEMAVERSION int PRIMARY KEY NOT NULL,
   BUILDDATE varchar(50),
   DATASOURCENAME varchar(50),
   DATASOURCEVERSION varchar(50),
   SERIES varchar(50),
   DATATYPE varchar(50)
)
;
CREATE UNIQUE INDEX SQL180509171519580 ON "APP"."INFO"(SCHEMAVERSION)
;

-- Table LINK

CREATE TABLE "APP"."LINK"
(
   IDLEFT varchar(50) NOT NULL,
   CODELEFT varchar(50) NOT NULL,
   IDRIGHT varchar(50) NOT NULL,
   CODERIGHT varchar(50) NOT NULL,
   BRIDGE varchar(50),
   CONSTRAINT SQL180509171519620 PRIMARY KEY (IDLEFT,CODELEFT,IDRIGHT,CODERIGHT)
)
;
CREATE INDEX I_CODERIGHT ON "APP"."LINK"(CODERIGHT)
;
CREATE INDEX I_IDRIGHT ON "APP"."LINK"(IDRIGHT)
;
CREATE INDEX I_CODELEFT ON "APP"."LINK"(CODELEFT)
;
CREATE UNIQUE INDEX SQL180509171519620 ON "APP"."LINK"
(
  IDLEFT,
  CODELEFT,
  IDRIGHT,
  CODERIGHT
)
;
