
# ADS Steganography

This repo provides a minimal implementation of Adaptive Dynamic Sampling (ADS) steganography.
You can run the pipeline via ADS.ipynb,including the encoding and decoding algorithms.

## Repository layout

<summary><b>Repository structure</b></summary>


```text
ADS-github/
├── ADS.ipynb
├── README.md
├── requirements.txt
├── bit_stream.txt
└── dataset/
    ├── instinwild_en_4000.json
    └── XHS.jsonl
```
## Installation

Python 3.9+ recommended
```text
pip install -r requirements.txt
```
### Model
In this experiment, we download large language models that are available on Hugging Face(https://huggingface.co/).

## Quick Start
1. Insstall dependencies.
2. Open the notebook: ADS.ipynb
3. Run cells in order to reproduce encoding/decoding.



## Datasets
	•	XHS.jsonl (Chinese prompts, JSON Lines)
	•	instinwild_en_4000.json (English prompts, JSON)

These are for quick checks; replace with your own prompts for experiments.


## Ethics
 Steganography is not a panacea that takes the risk of circumvention away.

 This repository is provided strictly for academic evaluation. Please comply with applicable laws, regulations, and platform policies.

