# Generative AI in Higher Education Teaching & Learning

## National Policy Framework

Authors: James O’Sullivan (Higher Education Authority & University College Cork), Colin Lowry (Higher Education Authority), Ross Woods (Higher Education Authority), Tim Conlon (Higher Education Authority)

Published by Ireland’s Higher Education Authority (HEA) in December 2025, this collection sets out the national policy framework governing the use of generative artificial intelligence in teaching and learning within Irish higher education institutions. It applies in particular to large language models, such as ChatGPT, and related generative systems that are now embedded in everyday educational practice.

The purpose of the framework is to support educators, academic leaders, and professional staff in making informed, values-based decisions about how generative AI is adopted, governed, and integrated into teaching, learning, and assessment. It provides a shared national reference point while preserving institutional autonomy and disciplinary judgement.

## Composition of the framework

This Zenodo record contains the complete, authoritative set of HEA policy documents relating to generative AI in higher education teaching and learning. The materials are designed to be read as a coherent suite, though individual documents may also be cited and used independently.

### Core guidelines

The framework currently comprises 12 documents, anchored by two central documents:

1. Generative AI in Higher Education Teaching & Learning: Policy Framework
2. Generative AI in Higher Education Teaching & Learning: Principles for Ethical AI Adoption

Together, these establish a values-led statement of intent and guidance that situates AI adoption in relation to the core missions of higher education, including student-centred learning, academic judgement, integrity, equity, and inclusion. They recognise that generative AI tools are already part of how students and staff work, and argue for coordinated, institutionally governed responses rather than ad-hoc or purely local decisions. The principles for ethical AI adoption articulate the normative commitments that underpin all subsequent guidance.

### Supporting instruments

The framework is accompanied by a set of supporting policy instruments intended to translate high-level principles into everyday institutional practice. These include guidance on:

3. Evidence for the HEA’s national policy framework
4. Alignment with the European Union AI Act
5. AI literacy training
6. AI-resilient assessment practices
7. Vendor and procurement governance

These instruments are designed to support embedding the framework within institutional structures, routines, and decision-making processes, particularly in relation to assessment, professional development, and systems governance.

### Roles and responsibilities

A further set of documents extends the framework into a governance architecture by defining the responsibilities of different actors across the higher education system. These cover:

8. Institutional leadership teams
9. Teaching staff
10. Students
11. Academic support units
12. IT and data protection

Taken together, these texts make explicit that ethical, lawful, and pedagogically sound AI adoption cannot be achieved by any single group acting alone. Instead, responsibility is distributed across leadership, academic practice, professional services, and students themselves, with an emphasis on accountability, collaboration, and clarity of role.

## Scope and use

This framework deals specifically with generative AI in the context of teaching and learning. While generative AI has wider implications for research, administration, and institutional strategy, those domains fall outside the direct scope of the documents contained here.

The framework is intended for use as a national reference point to inform institutional policy development, curriculum and assessment design, staff development, and governance arrangements. Institutions are expected to adapt and operationalise the guidance in ways that reflect their own contexts, disciplines, and missions, while remaining aligned with the shared values articulated in the framework.

## Versioning and updates

This release reflects the state of generative AI adoption in higher education teaching and learning as of December 2025. The framework is explicitly designed to evolve in response to technological developments, emerging evidence, sectoral experience, and continued consultation. The HEA will issue updated versions as required. Earlier versions will remain available for reference and citation.

Users of this material should ensure they are consulting the most recent published version when developing or reviewing institutional policies.

## Licence and citation

All documents in this collection are published under the Creative Commons Attribution–ShareAlike 4.0 International licence (CC BY-SA 4.0). Individual documents may be cited separately using their respective DOIs, or the collection may be cited as a whole where appropriate.