# DWM Full Repro Pack (Gate 1–3)

This folder is a **single “one-zip” reproducibility bundle** intended to be uploaded as a Zenodo dataset (or similar) so your paper can cite **one stable public link**.

## Contents

### `gate_outputs/`
- `DWM_Repro_Pack_Gate1.zip` — Gate-1 reproducibility pack (as provided)
- Gate-2 bundles:
  - `gate2c_outputs_36angles.zip`
  - `gate2c_dref_sweep_fixedJ0.csv` + `.txt`
  - `gate2d_plus_outputs.zip`
- Gate-3 bundles:
  - `gate3a_outputs.zip`
  - `gate3b_outputs.zip`
  - `gate3c_outputs.zip`
  - `gate3d_outputs.zip`
  - `gate3g_outputs.zip`
- `galaxy_csv_bundle.zip` — SPARC / galaxy CSV bundle used for fits
- `rt5b_gate1_attempt.zip` — archived attempt bundle
- `Files.zip` — the original user-provided bundle (kept verbatim for provenance)

### `scripts/`
Transparency scripts (Python) to reproduce the **Gate-2** field-solve artifacts and to postprocess **Gate-3** CSV outputs into plots:
- `gate2c_run.py`
- `gate2d_plus_run.py`
- `gate3_postprocess.py`

### `docs/`
- This README
- `DWM roundtable_gate_tracker_v1 1-2-2026 (1).txt` — tracker snapshot

## How to use (Android-friendly)
1. Upload the final zip to Zenodo as a *Dataset*.
2. After Zenodo mints a DOI, copy the DOI URL.
3. In the paper, cite it as “Reproducibility Pack (Zenodo DOI: …)” and (optionally) include a footnote link.

## Quick re-runs
From any Python environment (local, Colab, etc.):

```bash
python scripts/gate2c_run.py --outdir out_gate2c
python scripts/gate2d_plus_run.py --outdir out_gate2d
python scripts/gate3_postprocess.py --gate3g_zip gate_outputs/gate3g_outputs.zip --outdir plots_gate3
```

Dependencies: `numpy`, `pandas`, `matplotlib`.
