# experiments/

This directory contains **targeted experimental studies** exploring specific
mechanisms, failure modes, and extensions of the **Pattern-Based Computing (PBC)**
paradigm.

These experiments are **intentionally separated** from the main `src/` code:
- they are exploratory,
- they test hypotheses in isolation,
- they may evolve or be discarded.

They should be read as **research experiments**, not as final results.

---

## Scope and Intent

The purpose of this folder is to answer *mechanistic questions*, such as:

- How does episodic intervention compare to continuous control?
- What happens when latent overload accumulates?
- Can closed-loop feedback be achieved without explicit optimization?
- How does relaxation-gated control affect stability and cost?

Results here emphasize **qualitative behavior and structural insight** rather
than numerical optimality.

---

## ⚠️ Experimental Status

- Code may be rough or verbose.
- Parameters are tuned for insight, not benchmarks.
- Scripts may include interactive plots (`plt.show()`).
- Outputs are **not guaranteed** to match paper figures.

This is expected and intentional.

---

## Experiments

### Traffic Systems

- `pbc_trafico_ab.py`  
  A/B comparison between:
  - classical continuous control (e.g. ALINEA),
  - Pattern-Based Computing with **episodic, windowed intervention**.

  Focus:
  - sparsity of intervention,
  - congestion reduction vs control effort,
  - robustness across random seeds.

- `pbc_trafico_descongestion.py`  
  Extended traffic experiment focused on **decongestion dynamics** and failure:

  Introduces:
  - relaxation gates,
  - latent overload accumulation,
  - temporary capacity loss as a discharge mechanism.

  Metrics explored:
  - congestion area ∫C(t)dt,
  - relaxation time τ,
  - number and impact of latent discharge events.

### Network / Infrastructure Control

- `pbc_grid_closedloop.py`  
  Closed-loop PBC experiment on a **synthetic power grid**:

  - system outputs feed back into the lower pattern,
  - actuators include inertia, saturation, and leakage,
  - control emerges from structural bias, not explicit commands.

  Demonstrates that PBC can operate in **true feedback loops**.

---

## How to Run

Each experiment is standalone and can be executed directly:

```bash
python src/experimental/experiments/pbc_trafico_ab.py
```

or:

```bash
python src/experimental/experiments/pbc_grid_closedloop.py
```

Most scripts produce:
- console summaries,
- on-screen plots for inspection.

Files are intentionally not optimized for batch execution.

---

## Relationship to the Paper

- These experiments **inform the paper**, but are not part of the
  reproducible pipeline.
- They function as:
  - ablations,
  - stress tests,
  - intuition-building exercises.

Canonical, paper-aligned implementations live in `src/`.

---

## Design Principles

- Favor **explicit dynamics** over abstractions.
- Keep each experiment **self-contained**.
- Optimize for interpretability over performance.

---

## Reader Guidance

If you are a reviewer or reader:
- treat this folder as a **code-based lab notebook**,
- conclusions should be interpreted qualitatively unless explicitly stated.

